/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.EntityGender;
import net.sourceforge.plantuml.cucadiagram.EntityGenderUtils;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandHideShow
extends SingleLineCommand2<ClassDiagram> {
    private static final EnumSet<EntityPortion> PORTION_METHOD = EnumSet.of(EntityPortion.METHOD);
    private static final EnumSet<EntityPortion> PORTION_MEMBER = EnumSet.of(EntityPortion.FIELD, EntityPortion.METHOD);
    private static final EnumSet<EntityPortion> PORTION_FIELD = EnumSet.of(EntityPortion.FIELD);

    public CommandHideShow(ClassDiagram classDiagram) {
        super(classDiagram, CommandHideShow.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("COMMAND", "(hide|show)"), new RegexLeaf("\\s+"), new RegexLeaf("GENDER", "(?:(class|interface|enum|abstract|[\\p{L}0-9_.]+|\"[^\"]+\"|\\<\\<.*\\>\\>)\\s+)*?"), new RegexLeaf("EMPTY", "(?:(empty)\\s+)?"), new RegexLeaf("PORTION", "(members?|attributes?|fields?|methods?|circle\\w*|stereotypes?)"), new RegexLeaf("$"));
    }

    private final EntityGender emptyByGender(Set<EntityPortion> set) {
        if (set == PORTION_METHOD) {
            return EntityGenderUtils.emptyMethods();
        }
        if (set == PORTION_FIELD) {
            return EntityGenderUtils.emptyFields();
        }
        if (set == PORTION_MEMBER) {
            return EntityGenderUtils.emptyMembers();
        }
        return EntityGenderUtils.all();
    }

    @Override
    protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        Set<EntityPortion> set = this.getEntityPortion(map.get("PORTION").get(0));
        EntityGender entityGender = null;
        String string = map.get("GENDER").get(0);
        if (string == null) {
            entityGender = EntityGenderUtils.all();
        } else if (string.equalsIgnoreCase("class")) {
            entityGender = EntityGenderUtils.byEntityType(EntityType.CLASS);
        } else if (string.equalsIgnoreCase("interface")) {
            entityGender = EntityGenderUtils.byEntityType(EntityType.INTERFACE);
        } else if (string.equalsIgnoreCase("enum")) {
            entityGender = EntityGenderUtils.byEntityType(EntityType.ENUM);
        } else if (string.equalsIgnoreCase("abstract")) {
            entityGender = EntityGenderUtils.byEntityType(EntityType.ABSTRACT_CLASS);
        } else if (string.startsWith("<<")) {
            entityGender = EntityGenderUtils.byStereotype(string);
        } else {
            IEntity iEntity = ((ClassDiagram)this.getSystem()).getOrCreateClass(string);
            entityGender = EntityGenderUtils.byEntityAlone(iEntity);
        }
        if (entityGender != null) {
            boolean bl;
            boolean bl2 = bl = map.get("EMPTY").get(0) != null;
            if (bl) {
                entityGender = EntityGenderUtils.and(entityGender, this.emptyByGender(set));
            }
            if (((ClassDiagram)this.getSystem()).getCurrentGroup() != null) {
                entityGender = EntityGenderUtils.and(entityGender, EntityGenderUtils.byPackage(((ClassDiagram)this.getSystem()).getCurrentGroup()));
            }
            ((ClassDiagram)this.getSystem()).hideOrShow(entityGender, set, map.get("COMMAND").get(0).equalsIgnoreCase("show"));
        }
        return CommandExecutionResult.ok();
    }

    private Set<EntityPortion> getEntityPortion(String string) {
        String string2 = string.substring(0, 3).toLowerCase();
        if (string2.equals("met")) {
            return PORTION_METHOD;
        }
        if (string2.equals("mem")) {
            return PORTION_MEMBER;
        }
        if (string2.equals("att") || string2.equals("fie")) {
            return PORTION_FIELD;
        }
        if (string2.equals("cir")) {
            return EnumSet.of(EntityPortion.CIRCLED_CHARACTER);
        }
        if (string2.equals("ste")) {
            return EnumSet.of(EntityPortion.STEREOTYPE);
        }
        throw new IllegalArgumentException();
    }
}

