/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.Tile;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UText;

class TileText
implements Tile {
    private final String text;
    private final FontConfiguration fontConfiguration;

    public TileText(String string, FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
        this.text = string;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.text);
        Log.debug("g2d=" + dimension2D);
        Log.debug("Size for " + this.text + " is " + dimension2D);
        double d = dimension2D.getHeight();
        if (d < 10.0) {
            d = 10.0;
        }
        double d2 = this.text.indexOf(9) == -1 ? dimension2D.getWidth() : this.getWidth(stringBounder);
        return new Dimension2DDouble(d2, d);
    }

    public double getFontSize2D() {
        return this.fontConfiguration.getFont().getSize2D();
    }

    public void draw(ColorMapper colorMapper, Graphics2D graphics2D, double d, double d2) {
        Dimension2D dimension2D;
        graphics2D.setFont(this.fontConfiguration.getFont().getFont());
        graphics2D.setPaint(colorMapper.getMappedColor(this.fontConfiguration.getColor()));
        graphics2D.drawString(this.text, (float)d, (float)d2);
        if (this.fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            dimension2D = this.calculateDimension(StringBounderUtils.asStringBounder(graphics2D));
            int n = (int)(d2 + 2.5);
            graphics2D.setStroke(new BasicStroke(1.3f));
            graphics2D.drawLine((int)d, n, (int)(d + dimension2D.getWidth()), n);
            graphics2D.setStroke(new BasicStroke());
        }
        if (this.fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            dimension2D = this.calculateDimension(StringBounderUtils.asStringBounder(graphics2D));
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.fontConfiguration.getFont().getFont());
            int n = (int)(d2 - (double)fontMetrics.getDescent() - 0.5);
            graphics2D.setStroke(new BasicStroke(1.5f));
            graphics2D.drawLine((int)d, n, (int)(d + dimension2D.getWidth()), n);
            graphics2D.setStroke(new BasicStroke());
        }
    }

    double getTabSize(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.fontConfiguration.getFont(), "        ").getWidth();
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        uGraphic.getParam().setColor(this.fontConfiguration.getColor());
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\t", true);
        if (stringTokenizer.hasMoreTokens()) {
            double d3 = this.getTabSize(uGraphic.getStringBounder());
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.equals("\t")) {
                    double d4 = d % d3;
                    d += d3 - d4;
                    continue;
                }
                UText uText = new UText(string, this.fontConfiguration);
                uGraphic.draw(d, d2, uText);
                Dimension2D dimension2D = uGraphic.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), string);
                d += dimension2D.getWidth();
            }
        }
    }

    double getWidth(StringBounder stringBounder) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\t", true);
        double d = this.getTabSize(stringBounder);
        double d2 = 0.0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("\t")) {
                double d3 = d2 % d;
                d2 += d - d3;
                continue;
            }
            Dimension2D dimension2D = stringBounder.calculateDimension(this.fontConfiguration.getFont(), string);
            d2 += dimension2D.getWidth();
        }
        return d2;
    }
}

