/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.Map;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLinkClass2
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    public CommandLinkClass2(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram) {
        super(abstractClassOrObjectDiagram, CommandLinkClass2.getRegexConcat(abstractClassOrObjectDiagram.getUmlDiagramType()));
    }

    static RegexConcat getRegexConcat(UmlDiagramType umlDiagramType) {
        return new RegexConcat(new RegexLeaf("HEADER", "^(?:@([\\d.]+)\\s+)?"), new RegexOr(new RegexLeaf("ENT1", "(?:" + CommandLinkClass2.optionalKeywords(umlDiagramType) + "\\s+)?" + "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*|\"[^\"]+\")\\s*(\\<\\<.*\\>\\>)?"), new RegexLeaf("COUPLE1", "\\(\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*,\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*\\)")), new RegexLeaf("\\s*"), new RegexLeaf("FIRST_LABEL", "(?:\"([^\"]+)\")?"), new RegexLeaf("\\s*"), new RegexOr(new RegexLeaf("LEFT_TO_RIGHT", "(([-=.]+)(?:(left|right|up|down|le?|ri?|up?|do?)(?=[-=.]))?([-=.]*)(o +|[\\]>*+]|\\|[>\\]])?)"), new RegexLeaf("RIGHT_TO_LEFT", "(( +o|[\\[<*+]|[<\\[]\\|)?([-=.]*)(left|right|up|down|le?|ri?|up?|do?)?([-=.]+))"), new RegexLeaf("NAV_AGREG_OR_COMPO_INV", "(\\<([-=.]*)(left|right|up|down|le?|ri?|up?|do?[-=.]+)?([-=.]+)(o +|\\*))"), new RegexLeaf("NAV_AGREG_OR_COMPO", "(( +o|\\*)([-=.]+)(?:(left|right|up|down|le?|ri?|up?|do?)(?=[-=.]))?([-=.]*)\\>)")), new RegexLeaf("\\s*"), new RegexLeaf("SECOND_LABEL", "(?:\"([^\"]+)\")?"), new RegexLeaf("\\s*"), new RegexOr(new RegexLeaf("ENT2", "(?:" + CommandLinkClass2.optionalKeywords(umlDiagramType) + "\\s+)?" + "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*|\"[^\"]+\")\\s*(\\<\\<.*\\>\\>)?"), new RegexLeaf("COUPLE2", "\\(\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*,\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*\\)")), new RegexLeaf("\\s*"), new RegexOr(null, true, new RegexLeaf("LABEL_LINK", ":\\s*([^\"]+)"), new RegexLeaf("LABEL_LINK_XT", ":\\s*(\"[^\"]*\")?\\s*([^\"]*)\\s*(\"[^\"]*\")?")), new RegexLeaf("$"));
    }

    private static String optionalKeywords(UmlDiagramType umlDiagramType) {
        if (umlDiagramType == UmlDiagramType.CLASS) {
            return "(interface|enum|abstract\\s+class|abstract|class)";
        }
        if (umlDiagramType == UmlDiagramType.OBJECT) {
            return "(object)";
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        Object object;
        String string = map.get("ENT1").get(1);
        String string2 = map.get("ENT2").get(1);
        if (string == null) {
            return this.executeArgSpecial1(map);
        }
        if (string2 == null) {
            return this.executeArgSpecial2(map);
        }
        string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
        string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
        if (((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(string) && ((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(string2)) {
            return this.executePackageLink(map);
        }
        if (((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(string) || ((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(string2)) {
            return CommandExecutionResult.error("Package can be only linked to other package");
        }
        Entity entity = (Entity)((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string);
        Entity entity2 = (Entity)((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string2);
        if (map.get("ENT1").get(0) != null && (object = EntityType.getEntityType(map.get("ENT1").get(0))) != EntityType.OBJECT) {
            entity.muteToType((EntityType)((Object)object));
        }
        if (map.get("ENT2").get(0) != null && (object = EntityType.getEntityType(map.get("ENT2").get(0))) != EntityType.OBJECT) {
            entity2.muteToType((EntityType)((Object)object));
        }
        if (map.get("ENT1").get(2) != null) {
            entity.setStereotype(new Stereotype(map.get("ENT1").get(2), ((AbstractClassOrObjectDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((AbstractClassOrObjectDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        if (map.get("ENT2").get(2) != null) {
            entity2.setStereotype(new Stereotype(map.get("ENT2").get(2), ((AbstractClassOrObjectDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((AbstractClassOrObjectDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        object = this.getLinkType(map);
        Direction direction = this.getDirection(map);
        String string3 = direction == Direction.LEFT || direction == Direction.RIGHT ? "-" : this.getQueue(map);
        if (direction != null && ((LinkType)object).isExtendsOrAgregationOrCompositionOrPlus()) {
            direction = direction.getInv();
        }
        String string4 = map.get("FIRST_LABEL").get(0);
        String string5 = map.get("SECOND_LABEL").get(0);
        String string6 = null;
        if (map.get("LABEL_LINK").get(0) != null) {
            string6 = map.get("LABEL_LINK").get(0);
        } else if (map.get("LABEL_LINK_XT").get(0) != null || map.get("LABEL_LINK_XT").get(1) != null || map.get("LABEL_LINK_XT").get(2) != null) {
            string6 = map.get("LABEL_LINK_XT").get(1);
            string4 = this.merge(string4, map.get("LABEL_LINK_XT").get(0));
            string5 = this.merge(map.get("LABEL_LINK_XT").get(2), string5);
        }
        Link link = new Link(entity, entity2, (LinkType)object, string6, string3.length(), string4, string5, ((AbstractClassOrObjectDiagram)this.getSystem()).getLabeldistance(), ((AbstractClassOrObjectDiagram)this.getSystem()).getLabelangle());
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        this.addLink(link, map.get("HEADER").get(0));
        return CommandExecutionResult.ok();
    }

    private String merge(String string, String string2) {
        if (string == null && string2 == null) {
            return null;
        }
        if (string == null && string2 != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
        }
        if (string2 == null && string != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
        }
        return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string) + "\\n" + StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
    }

    private void addLink(Link link, String string) {
        ((AbstractClassOrObjectDiagram)this.getSystem()).addLink(link);
        if (string == null) {
            LinkType linkType = link.getType();
        } else {
            link.setWeight(Double.parseDouble(string));
        }
    }

    private CommandExecutionResult executePackageLink(Map<String, RegexPartialMatch> map) {
        String string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("ENT1").get(1));
        String string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("ENT2").get(1));
        Group group = ((AbstractClassOrObjectDiagram)this.getSystem()).getGroup(string);
        Group group2 = ((AbstractClassOrObjectDiagram)this.getSystem()).getGroup(string2);
        LinkType linkType = this.getLinkType(map);
        Direction direction = this.getDirection(map);
        String string3 = direction == Direction.LEFT || direction == Direction.RIGHT ? "-" : this.getQueue(map);
        String string4 = map.get("LABEL_LINK").get(0);
        String string5 = map.get("FIRST_LABEL").get(0);
        String string6 = map.get("SECOND_LABEL").get(0);
        Link link = new Link(group.getEntityCluster(), group2.getEntityCluster(), linkType, string4, string3.length(), string5, string6, ((AbstractClassOrObjectDiagram)this.getSystem()).getLabeldistance(), ((AbstractClassOrObjectDiagram)this.getSystem()).getLabelangle());
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        ((AbstractClassOrObjectDiagram)this.getSystem()).resetPragmaLabel();
        this.addLink(link, map.get("HEADER").get(0));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial1(Map<String, RegexPartialMatch> map) {
        String string = map.get("COUPLE1").get(0);
        String string2 = map.get("COUPLE1").get(1);
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).entityExist(string)) {
            return CommandExecutionResult.error("No class " + string);
        }
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).entityExist(string2)) {
            return CommandExecutionResult.error("No class " + string2);
        }
        String string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("ENT2").get(1));
        IEntity iEntity = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string3);
        LinkType linkType = this.getLinkType(map);
        String string4 = map.get("LABEL_LINK").get(0);
        int n = this.getQueue(map).length();
        String string5 = map.get("HEADER").get(0);
        boolean bl = ((AbstractClassOrObjectDiagram)this.getSystem()).associationClass(1, string, string2, iEntity, linkType, string4);
        if (!bl) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial2(Map<String, RegexPartialMatch> map) {
        String string = map.get("COUPLE2").get(0);
        String string2 = map.get("COUPLE2").get(1);
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).entityExist(string)) {
            return CommandExecutionResult.error("No class " + string);
        }
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).entityExist(string2)) {
            return CommandExecutionResult.error("No class " + string2);
        }
        String string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("ENT1").get(1));
        IEntity iEntity = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string3);
        LinkType linkType = this.getLinkType(map);
        String string4 = map.get("LABEL_LINK").get(0);
        int n = this.getQueue(map).length();
        String string5 = map.get("HEADER").get(0);
        boolean bl = ((AbstractClassOrObjectDiagram)this.getSystem()).associationClass(2, string, string2, iEntity, linkType, string4);
        if (!bl) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private LinkType getLinkTypeNormal(RegexPartialMatch regexPartialMatch) {
        String string = regexPartialMatch.get(1).trim() + regexPartialMatch.get(3).trim();
        String string2 = regexPartialMatch.get(4);
        return this.getLinkType(string, string2);
    }

    private LinkType getLinkTypeInv(RegexPartialMatch regexPartialMatch) {
        String string = regexPartialMatch.get(2).trim() + regexPartialMatch.get(4).trim();
        String string2 = regexPartialMatch.get(1);
        return this.getLinkType(string, string2).getInv();
    }

    private LinkType getLinkType(String string, String string2) {
        if (string2 != null) {
            string2 = string2.trim();
        }
        LinkType linkType = this.getLinkTypeFromKey(string2);
        if (string.startsWith(".")) {
            linkType = linkType.getDashed();
        }
        return linkType;
    }

    private LinkType getLinkType(Map<String, RegexPartialMatch> map) {
        if (map.get("LEFT_TO_RIGHT").get(0) != null) {
            return this.getLinkTypeNormal(map.get("LEFT_TO_RIGHT"));
        }
        if (map.get("RIGHT_TO_LEFT").get(0) != null) {
            return this.getLinkTypeInv(map.get("RIGHT_TO_LEFT"));
        }
        if (map.get("NAV_AGREG_OR_COMPO_INV").get(0) != null) {
            LinkType linkType;
            String string = map.get("NAV_AGREG_OR_COMPO_INV").get(4).trim();
            String string2 = map.get("NAV_AGREG_OR_COMPO_INV").get(1).trim() + map.get("NAV_AGREG_OR_COMPO_INV").get(3).trim();
            if (string.equals("*")) {
                linkType = new LinkType(LinkDecor.COMPOSITION, LinkDecor.ARROW);
            } else if (string.equals("o")) {
                linkType = new LinkType(LinkDecor.AGREGATION, LinkDecor.ARROW);
            } else {
                throw new IllegalArgumentException();
            }
            if (string2.startsWith(".")) {
                linkType = linkType.getDashed();
            }
            return linkType;
        }
        if (map.get("NAV_AGREG_OR_COMPO").get(0) != null) {
            LinkType linkType;
            String string = map.get("NAV_AGREG_OR_COMPO").get(1).trim();
            String string3 = map.get("NAV_AGREG_OR_COMPO").get(2).trim() + map.get("NAV_AGREG_OR_COMPO").get(4).trim();
            if (string.equals("*")) {
                linkType = new LinkType(LinkDecor.ARROW, LinkDecor.COMPOSITION);
            } else if (string.equals("o")) {
                linkType = new LinkType(LinkDecor.ARROW, LinkDecor.AGREGATION);
            } else {
                throw new IllegalArgumentException();
            }
            if (string3.startsWith(".")) {
                linkType = linkType.getDashed();
            }
            return linkType;
        }
        throw new IllegalArgumentException();
    }

    private String getQueue(Map<String, RegexPartialMatch> map) {
        if (map.get("LEFT_TO_RIGHT").get(1) != null) {
            return map.get("LEFT_TO_RIGHT").get(1).trim() + map.get("LEFT_TO_RIGHT").get(3).trim();
        }
        if (map.get("RIGHT_TO_LEFT").get(2) != null) {
            return map.get("RIGHT_TO_LEFT").get(2).trim() + map.get("RIGHT_TO_LEFT").get(4).trim();
        }
        if (map.get("NAV_AGREG_OR_COMPO_INV").get(1) != null) {
            return map.get("NAV_AGREG_OR_COMPO_INV").get(1).trim() + map.get("NAV_AGREG_OR_COMPO_INV").get(3).trim();
        }
        if (map.get("NAV_AGREG_OR_COMPO").get(2) != null) {
            return map.get("NAV_AGREG_OR_COMPO").get(2).trim() + map.get("NAV_AGREG_OR_COMPO").get(4).trim();
        }
        throw new IllegalArgumentException();
    }

    private Direction getDirection(Map<String, RegexPartialMatch> map) {
        if (map.get("LEFT_TO_RIGHT").get(2) != null) {
            return StringUtils.getQueueDirection(map.get("LEFT_TO_RIGHT").get(2));
        }
        if (map.get("RIGHT_TO_LEFT").get(3) != null) {
            return StringUtils.getQueueDirection(map.get("RIGHT_TO_LEFT").get(3)).getInv();
        }
        if (map.get("NAV_AGREG_OR_COMPO").get(3) != null) {
            return StringUtils.getQueueDirection(map.get("NAV_AGREG_OR_COMPO").get(3)).getInv();
        }
        if (map.get("NAV_AGREG_OR_COMPO_INV").get(2) != null) {
            return StringUtils.getQueueDirection(map.get("NAV_AGREG_OR_COMPO_INV").get(2));
        }
        return null;
    }

    private LinkType getLinkTypeFromKey(String string) {
        if (string == null) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        if (string.equals("+")) {
            return new LinkType(LinkDecor.PLUS, LinkDecor.NONE);
        }
        if (string.equals("*")) {
            return new LinkType(LinkDecor.COMPOSITION, LinkDecor.NONE);
        }
        if (string.equalsIgnoreCase("o")) {
            return new LinkType(LinkDecor.AGREGATION, LinkDecor.NONE);
        }
        if (string.equals("<") || string.equals(">")) {
            return new LinkType(LinkDecor.ARROW, LinkDecor.NONE);
        }
        if (string.equals("<|") || string.equals("|>")) {
            return new LinkType(LinkDecor.EXTENDS, LinkDecor.NONE);
        }
        throw new IllegalArgumentException(string);
    }
}

