/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.FontChange;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlCommand;
import net.sourceforge.plantuml.graphic.Img;
import net.sourceforge.plantuml.graphic.Line;
import net.sourceforge.plantuml.graphic.Splitter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.Text;
import net.sourceforge.plantuml.graphic.Tile;
import net.sourceforge.plantuml.graphic.TileImage;
import net.sourceforge.plantuml.graphic.TileText;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UGraphic;

class SingleLine
implements Line {
    private final List<Tile> blocs = new ArrayList<Tile>();
    private final HorizontalAlignement horizontalAlignement;

    public SingleLine(String string, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement) {
        if (string.length() == 0) {
            string = " ";
        }
        this.horizontalAlignement = horizontalAlignement;
        Splitter splitter = new Splitter(string);
        for (HtmlCommand htmlCommand : splitter.getHtmlCommands(false)) {
            if (htmlCommand instanceof Text) {
                String string2 = ((Text)htmlCommand).getText();
                this.blocs.add(new TileText(string2, fontConfiguration));
                continue;
            }
            if (htmlCommand instanceof Img) {
                this.blocs.add(((Img)htmlCommand).createMonoImage());
                continue;
            }
            if (!(htmlCommand instanceof FontChange)) continue;
            fontConfiguration = ((FontChange)htmlCommand).apply(fontConfiguration);
        }
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = 0.0;
        double d2 = 0.0;
        for (Tile tile : this.blocs) {
            Dimension2D dimension2D = tile.calculateDimension(stringBounder);
            d += dimension2D.getWidth();
            d2 = Math.max(d2, dimension2D.getHeight());
        }
        return new Dimension2DDouble(d, d2);
    }

    private double maxDeltaY(Graphics2D graphics2D) {
        double d = 0.0;
        Dimension2D dimension2D = this.calculateDimension(StringBounderUtils.asStringBounder(graphics2D));
        for (Tile tile : this.blocs) {
            if (!(tile instanceof TileText)) continue;
            Dimension2D dimension2D2 = tile.calculateDimension(StringBounderUtils.asStringBounder(graphics2D));
            double d2 = dimension2D.getHeight() - dimension2D2.getHeight() + ((TileText)tile).getFontSize2D();
            d = Math.max(d, d2);
        }
        return d;
    }

    private double maxDeltaY(UGraphic uGraphic) {
        double d = 0.0;
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        for (Tile tile : this.blocs) {
            if (!(tile instanceof TileText)) continue;
            Dimension2D dimension2D2 = tile.calculateDimension(uGraphic.getStringBounder());
            double d2 = dimension2D.getHeight() - dimension2D2.getHeight() + ((TileText)tile).getFontSize2D();
            d = Math.max(d, d2);
        }
        return d;
    }

    public void draw(ColorMapper colorMapper, Graphics2D graphics2D, double d, double d2) {
        double d3 = this.maxDeltaY(graphics2D);
        for (Tile tile : this.blocs) {
            if (tile instanceof TileImage) {
                tile.draw(colorMapper, graphics2D, d, d2);
            } else {
                tile.draw(colorMapper, graphics2D, d, d2 + d3);
            }
            d += tile.calculateDimension(StringBounderUtils.asStringBounder(graphics2D)).getWidth();
        }
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        double d3 = this.maxDeltaY(uGraphic);
        for (Tile tile : this.blocs) {
            if (tile instanceof TileImage) {
                tile.drawU(uGraphic, d, d2);
            } else {
                tile.drawU(uGraphic, d, d2 + d3);
            }
            d += tile.calculateDimension(uGraphic.getStringBounder()).getWidth();
        }
    }

    public HorizontalAlignement getHorizontalAlignement() {
        return this.horizontalAlignement;
    }
}

