/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandMultilinesNote
extends CommandMultilines<SequenceDiagram> {
    public CommandMultilinesNote(SequenceDiagram sequenceDiagram) {
        super(sequenceDiagram, "(?i)^note\\s+(right|left|over)\\s+(?:of\\s+)?([\\p{L}0-9_.]+|\"[^\"]+\")\\s*(#\\w+)?$", "(?i)^end ?note$");
    }

    @Override
    public CommandExecutionResult execute(List<String> list) {
        List<String> list2 = StringUtils.getSplit(this.getStartingPattern(), list.get(0).trim());
        Participant participant = ((SequenceDiagram)this.getSystem()).getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(list2.get(1)));
        NotePosition notePosition = NotePosition.valueOf(list2.get(0).toUpperCase());
        List<String> list3 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
        if (list3.size() > 0) {
            Note note = new Note(participant, notePosition, list3);
            note.setSpecificBackcolor(HtmlColor.getColorIfValid(list2.get(2)));
            ((SequenceDiagram)this.getSystem()).addNote(note);
        }
        return CommandExecutionResult.ok();
    }
}

