/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import org.geotools.data.FIDReader;
import org.opengis.feature.simple.SimpleFeatureType;

public class DefaultFIDReader
implements FIDReader {
    protected static final String CLOSE_MESG = "Close has already been called on this FIDReader";
    private int len;
    protected int index = 0;
    protected StringBuffer buffer;

    public DefaultFIDReader(String typeName) {
        this.buffer = new StringBuffer(typeName);
        this.buffer.append('.');
        this.len = typeName.length() + 1;
    }

    public DefaultFIDReader(SimpleFeatureType featureType) {
        this(featureType.getTypeName());
    }

    public void close() {
        this.index = -1;
    }

    public boolean hasNext() throws IOException {
        if (this.index < 0) {
            throw new IOException(CLOSE_MESG);
        }
        return this.index < Integer.MAX_VALUE;
    }

    public String next() throws IOException {
        if (this.index < 0) {
            throw new IOException(CLOSE_MESG);
        }
        this.buffer.setLength(this.len);
        this.buffer.append(++this.index);
        return this.buffer.toString();
    }
}

