/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.wms;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.factory.DirectAuthorityFactory;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.util.InternationalString;

public class WebCRSFactory
extends DirectAuthorityFactory
implements CRSAuthorityFactory {
    private static final String PREFIX = "CRS";
    private final Map<Integer, CoordinateReferenceSystem> crsMap = new TreeMap<Integer, CoordinateReferenceSystem>();

    public WebCRSFactory() {
        this(null);
    }

    public WebCRSFactory(Hints hints) {
        super(hints, 50);
    }

    private synchronized void ensureInitialized() throws FactoryException {
        if (this.crsMap.isEmpty()) {
            this.add(84, "WGS84", DefaultEllipsoid.WGS84);
            this.add(83, "NAD83", DefaultEllipsoid.GRS80);
            this.add(27, "NAD27", DefaultEllipsoid.CLARKE_1866);
        }
    }

    private void add(int code, String name, Ellipsoid ellipsoid) throws FactoryException {
        assert (Thread.holdsLock((Object)this));
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Citation authority = this.getAuthority();
        String text = String.valueOf(code);
        properties.put("name", name);
        properties.put("authority", authority);
        GeodeticDatum datum = this.factories.getDatumFactory().createGeodeticDatum(properties, ellipsoid, (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
        properties.put("identifiers", new NamedIdentifier[]{new NamedIdentifier(authority, text), new NamedIdentifier(authority, PREFIX + text)});
        GeographicCRS crs = this.factories.getCRSFactory().createGeographicCRS(properties, datum, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
        if (this.crsMap.put(code, (CoordinateReferenceSystem)crs) != null) {
            throw new IllegalArgumentException(text);
        }
    }

    public Citation getAuthority() {
        return Citations.CRS;
    }

    public Set getAuthorityCodes(Class type) throws FactoryException {
        this.ensureInitialized();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Map.Entry<Integer, CoordinateReferenceSystem> entry : this.crsMap.entrySet()) {
            CoordinateReferenceSystem crs = entry.getValue();
            if (!type.isAssignableFrom(crs.getClass())) continue;
            Integer code = entry.getKey();
            set.add(String.valueOf(code));
        }
        return set;
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        return new SimpleInternationalString(this.createObject(code).getName().getCode());
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.createCoordinateReferenceSystem(code);
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        int i;
        String c = this.trimAuthority(code).toUpperCase();
        if (c.startsWith(PREFIX)) {
            c = c.substring(PREFIX.length());
        }
        try {
            i = Integer.parseInt(c);
        }
        catch (NumberFormatException exception) {
            NoSuchAuthorityCodeException e = this.noSuchAuthorityCode(CoordinateReferenceSystem.class, code);
            e.initCause((Throwable)exception);
            throw e;
        }
        this.ensureInitialized();
        CoordinateReferenceSystem crs = this.crsMap.get(i);
        if (crs != null) {
            return crs;
        }
        throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, code);
    }
}

