/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.processor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dataone.cn.index.processor.IndexTaskProcessorJob;
import org.quartz.InterruptableJob;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class IndexTaskProcessorScheduler {
    private static Logger logger = Logger.getLogger((String)IndexTaskProcessorScheduler.class.getName());
    private static final String QUARTZ_PROCESSOR_TRIGGER = "index-process-trigger";
    private static final String QUARTZ_PROCESSOR_GROUP = "d1-cn-index-processor";
    private static final String QUARTZ_PROCESSOR_JOB = "d1-index-processor-job";
    private Scheduler scheduler;

    public void start() {
        try {
            logger.warn((Object)("starting index task processor quartz scheduler [" + this + "] ..."));
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/org/dataone/configuration/quartz.properties"));
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(properties);
            this.scheduler = schedulerFactory.getScheduler();
            JobDetail job = JobBuilder.newJob(IndexTaskProcessorJob.class).withIdentity(QUARTZ_PROCESSOR_JOB, QUARTZ_PROCESSOR_GROUP).build();
            SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(QUARTZ_PROCESSOR_TRIGGER, QUARTZ_PROCESSOR_GROUP).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatMinutelyForever((int)2)).build();
            this.scheduler.scheduleJob(job, (Trigger)trigger);
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void stop() {
        logger.warn((Object)("stopping index task processor quartz scheduler [" + this + "] ..."));
        try {
            if (this.scheduler.isStarted()) {
                this.scheduler.standby();
                List jobs = this.scheduler.getCurrentlyExecutingJobs();
                if (jobs != null) {
                    for (JobExecutionContext j : jobs) {
                        if (j.getJobInstance() instanceof InterruptableJob) {
                            logger.warn((Object)("interrupting processing job [" + j.getJobInstance() + "] ..."));
                            ((InterruptableJob)j.getJobInstance()).interrupt();
                            continue;
                        }
                        logger.warn((Object)("processing job [" + j.getJobInstance() + "] not interruptable..."));
                    }
                }
                while (!this.scheduler.getCurrentlyExecutingJobs().isEmpty()) {
                    logger.warn((Object)String.format("%d jobs executing,  waiting for them to complete...", this.scheduler.getCurrentlyExecutingJobs().size()));
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        logger.warn((Object)"Sleep interrupted while waiting for executing jobs to finish. check again!");
                    }
                }
                logger.warn((Object)("Job scheduler [" + this + "] finished executing all jobs."));
                this.scheduler.deleteJob(JobKey.jobKey((String)QUARTZ_PROCESSOR_JOB, (String)QUARTZ_PROCESSOR_GROUP));
            }
        }
        catch (SchedulerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

