/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.convert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.dataone.cn.indexer.convert.IConverter;

public class SolrDateConverter
implements IConverter {
    private static TimeZone OUTPUT_TIMEZONE = TimeZone.getTimeZone("Zulu");
    protected static final String OUTPUT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected boolean assumeDate = false;

    @Override
    public String convert(String data) {
        if (data == null || data.equals("")) {
            return "";
        }
        if (this.assumeDate && !data.contains("-")) {
            if (data.length() == 6) {
                data = data.substring(0, 4) + "-" + data.substring(4);
            }
            if (data.length() == 8) {
                data = data.substring(0, 4) + "-" + data.substring(4, 6) + "-" + data.substring(6);
            }
        }
        String outputDateFormat = "";
        try {
            Date dateTime = DatatypeConverter.parseDate((String)data).getTime();
            SimpleDateFormat sdf = new SimpleDateFormat(OUTPUT_DATE_FORMAT);
            sdf.setTimeZone(OUTPUT_TIMEZONE);
            outputDateFormat = sdf.format(dateTime);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return outputDateFormat;
    }

    public boolean isAssumeDate() {
        return this.assumeDate;
    }

    public void setAssumeDate(boolean assumeDate) {
        this.assumeDate = assumeDate;
    }

    public static Date ParseSolrDate(String date) {
        Date outputDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(OUTPUT_DATE_FORMAT);
            outputDate = sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
        return outputDate;
    }
}

