/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v2.itk;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dataone.client.D1NodeFactory;
import org.dataone.client.NodeLocator;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.DefaultHttpMultipartRestClient;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.utils.ExceptionUtils;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.MNode;
import org.dataone.client.v2.impl.NodeListNodeLocator;
import org.dataone.client.v2.impl.SettingsContextNodeLocator;
import org.dataone.service.cn.v2.CNCore;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Session;

public class D1Client {
    private static NodeLocator nodeLocator;
    private static long lastRefresh;
    private static long EXPIRATION_MILLIS;
    protected static MultipartRestClient multipartRestClient;
    static final Logger logger;

    protected static MultipartRestClient getMultipartRestClient() throws IOException, ClientSideException {
        if (multipartRestClient == null) {
            multipartRestClient = new DefaultHttpMultipartRestClient();
        }
        return multipartRestClient;
    }

    public static void setNodeLocator(NodeLocator nodeLocator) {
        D1Client.nodeLocator = nodeLocator;
    }

    public static CNode getCN() throws ServiceFailure, NotImplemented {
        return D1Client.getCN((Session)null);
    }

    @Deprecated
    public static CNode getCN(Session session) throws ServiceFailure, NotImplemented {
        CNode cn = null;
        try {
            if (nodeLocator == null) {
                nodeLocator = new SettingsContextNodeLocator(D1Client.getMultipartRestClient());
            }
            cn = (CNode)nodeLocator.getCNode();
        }
        catch (Exception e) {
            logger.warn((Object)("problem getting nodelist from SettingsContextNL: " + e.getClass().getCanonicalName() + " : " + e.getMessage()));
            try {
                nodeLocator = new NodeListNodeLocator(null, D1Client.getMultipartRestClient());
                cn = (CNode)nodeLocator.getCNode();
            }
            catch (IOException | ClientSideException e1) {
                throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
            }
        }
        return cn;
    }

    public static void setCN(String cnUrl) throws NotImplemented, ServiceFailure {
        if (cnUrl == null) {
            cnUrl = "";
        }
        try {
            CNCore cn = D1NodeFactory.buildNode(CNCore.class, D1Client.getMultipartRestClient(), URI.create(cnUrl));
            nodeLocator = new NodeListNodeLocator(cn.listNodes(), D1Client.getMultipartRestClient());
        }
        catch (IOException | ClientSideException e) {
            ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
    }

    public static MNode getMN(String mnBaseUrl) throws ServiceFailure {
        MNode mn = null;
        if (nodeLocator != null) {
            try {
                mn = (MNode)nodeLocator.getNode(mnBaseUrl);
            }
            catch (ClientSideException clientSideException) {
                // empty catch block
            }
        }
        if (mn == null) {
            try {
                mn = D1NodeFactory.buildNode(MNode.class, D1Client.getMultipartRestClient(), URI.create(mnBaseUrl));
            }
            catch (IOException | ClientSideException cse) {
                throw ExceptionUtils.recastClientSideExceptionToServiceFailure(cse);
            }
        }
        return mn;
    }

    public static CNode getCN(String cnBaseUrl) throws ServiceFailure {
        CNode cn = null;
        if (nodeLocator != null) {
            try {
                cn = (CNode)nodeLocator.getNode(cnBaseUrl);
            }
            catch (ClientSideException clientSideException) {
                // empty catch block
            }
        }
        if (cn == null) {
            try {
                cn = D1NodeFactory.buildNode(CNode.class, D1Client.getMultipartRestClient(), URI.create(cnBaseUrl));
            }
            catch (IOException | ClientSideException cse) {
                throw ExceptionUtils.recastClientSideExceptionToServiceFailure(cse);
            }
        }
        return cn;
    }

    public static MNode getMN(NodeReference nodeRef) throws ServiceFailure {
        MNode mn = null;
        try {
            D1Client.getCN();
            mn = (MNode)nodeLocator.getNode(nodeRef);
        }
        catch (ClientSideException e) {
            try {
                if (new Date().getTime() - lastRefresh > EXPIRATION_MILLIS) {
                    nodeLocator = new SettingsContextNodeLocator(D1Client.getMultipartRestClient());
                }
            }
            catch (IOException | ClientSideException | NotImplemented throwable) {
                // empty catch block
            }
            try {
                mn = (MNode)nodeLocator.getNode(nodeRef);
            }
            catch (ClientSideException e1) {
                throw new ServiceFailure("0000", "Node is not an MNode: " + nodeRef.getValue());
            }
        }
        catch (NotImplemented e) {
            throw new ServiceFailure("0000", "Got 'NotImplemented' from getCN(): " + e.getDescription());
        }
        if (mn == null) {
            throw new ServiceFailure("0000", "Failed to find baseUrl for node " + nodeRef.getValue() + " in the NodeList");
        }
        return mn;
    }

    static {
        EXPIRATION_MILLIS = 5000L;
        logger = Logger.getLogger(D1Client.class);
    }
}

