/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TopGroups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSecondPassGroupingCollector<GROUP_VALUE_TYPE>
extends Collector {
    protected final Map<GROUP_VALUE_TYPE, SearchGroupDocs<GROUP_VALUE_TYPE>> groupMap;
    private final int maxDocsPerGroup;
    protected SearchGroupDocs<GROUP_VALUE_TYPE>[] groupDocs;
    private final Collection<SearchGroup<GROUP_VALUE_TYPE>> groups;
    private final Sort withinGroupSort;
    private final Sort groupSort;
    private int totalHitCount;
    private int totalGroupedHitCount;

    public AbstractSecondPassGroupingCollector(Collection<SearchGroup<GROUP_VALUE_TYPE>> groups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) throws IOException {
        if (groups.size() == 0) {
            throw new IllegalArgumentException("no groups to collect (groups.size() is 0)");
        }
        this.groupSort = groupSort;
        this.withinGroupSort = withinGroupSort;
        this.groups = groups;
        this.maxDocsPerGroup = maxDocsPerGroup;
        this.groupMap = new HashMap<GROUP_VALUE_TYPE, SearchGroupDocs<GROUP_VALUE_TYPE>>(groups.size());
        for (SearchGroup<GROUP_VALUE_TYPE> group : groups) {
            Object collector = withinGroupSort == null ? TopScoreDocCollector.create((int)maxDocsPerGroup, (boolean)true) : TopFieldCollector.create((Sort)withinGroupSort, (int)maxDocsPerGroup, (boolean)fillSortFields, (boolean)getScores, (boolean)getMaxScores, (boolean)true);
            this.groupMap.put(group.groupValue, new SearchGroupDocs(group.groupValue, (TopDocsCollector<?>)collector));
        }
    }

    public void setScorer(Scorer scorer) throws IOException {
        for (SearchGroupDocs<GROUP_VALUE_TYPE> group : this.groupMap.values()) {
            group.collector.setScorer(scorer);
        }
    }

    public void collect(int doc) throws IOException {
        ++this.totalHitCount;
        SearchGroupDocs<GROUP_VALUE_TYPE> group = this.retrieveGroup(doc);
        if (group != null) {
            ++this.totalGroupedHitCount;
            group.collector.collect(doc);
        }
    }

    protected abstract SearchGroupDocs<GROUP_VALUE_TYPE> retrieveGroup(int var1) throws IOException;

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        for (SearchGroupDocs<GROUP_VALUE_TYPE> group : this.groupMap.values()) {
            group.collector.setNextReader(reader, docBase);
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    public TopGroups<GROUP_VALUE_TYPE> getTopGroups(int withinGroupOffset) {
        GroupDocs[] groupDocsResult = new GroupDocs[this.groups.size()];
        int groupIDX = 0;
        for (SearchGroup<GROUP_VALUE_TYPE> group : this.groups) {
            SearchGroupDocs<GROUP_VALUE_TYPE> groupDocs = this.groupMap.get(group.groupValue);
            TopDocs topDocs = groupDocs.collector.topDocs(withinGroupOffset, this.maxDocsPerGroup);
            groupDocsResult[groupIDX++] = new GroupDocs(topDocs.getMaxScore(), topDocs.totalHits, topDocs.scoreDocs, groupDocs.groupValue, group.sortValues);
        }
        return new TopGroups(this.groupSort.getSort(), this.withinGroupSort == null ? null : this.withinGroupSort.getSort(), this.totalHitCount, this.totalGroupedHitCount, groupDocsResult);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SearchGroupDocs<GROUP_VALUE_TYPE> {
        public final GROUP_VALUE_TYPE groupValue;
        public final TopDocsCollector<?> collector;

        public SearchGroupDocs(GROUP_VALUE_TYPE groupValue, TopDocsCollector<?> collector) {
            this.groupValue = groupValue;
            this.collector = collector;
        }
    }
}

