/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.harvesterClient;

import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatException;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.metacat.harvesterClient.HarvestSiteSchedule;
import edu.ucsb.nceas.metacat.harvesterClient.Harvester;
import edu.ucsb.nceas.utilities.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class HarvestDocument {
    private String docid;
    private String docidFull;
    String documentType;
    String documentURL;
    private Harvester harvester;
    private HarvestSiteSchedule harvestSiteSchedule;
    int identifier;
    int revision;
    String scope;
    boolean accessError = false;
    boolean inserted = false;
    boolean metacatHasIt = false;
    boolean updated = false;
    boolean uploadError = false;

    public HarvestDocument(Harvester harvester, HarvestSiteSchedule harvestSiteSchedule, String string, int n, int n2, String string2, String string3) {
        this.harvester = harvester;
        this.harvestSiteSchedule = harvestSiteSchedule;
        this.documentType = string2;
        this.documentURL = string3;
        this.scope = string;
        this.identifier = n;
        this.revision = n2;
        this.docid = string + "." + n;
        this.docidFull = this.docid + "." + n2;
    }

    public StringReader getSiteDocument() {
        StringReader stringReader = null;
        try {
            URL uRL = new URL(this.documentURL);
            InputStream inputStream = uRL.openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            String string = IOUtil.getAsString((Reader)inputStreamReader, (boolean)true);
            stringReader = new StringReader(string);
            this.harvester.addLogEntry(0, "Retrieved: " + this.documentURL, "harvester.GetDocSuccess", this.harvestSiteSchedule.siteScheduleID, null, "");
        }
        catch (MalformedURLException malformedURLException) {
            this.accessError = true;
            this.harvester.addLogEntry(1, "MalformedURLException", "harvester.GetDocError", this.harvestSiteSchedule.siteScheduleID, this, "MalformedURLException: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            this.accessError = true;
            this.harvester.addLogEntry(1, "IOException", "harvester.GetDocError", this.harvestSiteSchedule.siteScheduleID, this, "IOException: " + iOException.getMessage());
        }
        return stringReader;
    }

    public void harvestDocument() {
        StringReader stringReader;
        boolean bl = false;
        boolean bl2 = false;
        int n = this.metacatHighestRevision();
        if (n == -1) {
            bl = true;
        } else if (this.revision > n) {
            bl2 = true;
        } else {
            this.metacatHasIt = true;
            this.harvester.addLogEntry(0, "Attempting to update " + this.docid + " to revision " + this.revision + ". Metacat has document revision " + n + ".", "harvester.MetacatHasDoc", this.harvestSiteSchedule.siteScheduleID, null, "");
        }
        if ((bl || bl2) && (stringReader = this.getSiteDocument()) != null && this.validateDocument()) {
            this.putMetacatDocument(bl, bl2, stringReader);
        }
    }

    private boolean isMetacatSuccessString(String string) {
        boolean bl = false;
        if (string != null && string.contains("<success>")) {
            bl = true;
        }
        return bl;
    }

    private void logMetacatError(boolean bl, String string, String string2, Exception exception) {
        this.uploadError = true;
        if (bl) {
            this.harvester.addLogEntry(1, string, "harvester.InsertDocError", this.harvestSiteSchedule.siteScheduleID, this, string2 + ": " + exception.getMessage());
        } else {
            this.harvester.addLogEntry(1, string, "harvester.UpdateDocError", this.harvestSiteSchedule.siteScheduleID, this, string2 + ": " + exception.getMessage());
        }
    }

    public int metacatHighestRevision() {
        Connection connection = this.harvester.getConnection();
        int n = -1;
        String string = "SELECT REV FROM XML_DOCUMENTS WHERE DOCID = '" + this.docid + "'";
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                n = resultSet.getInt("REV");
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
        return n;
    }

    public void printOutput(PrintStream printStream) {
        printStream.println("* scope:                " + this.scope);
        printStream.println("* identifier:           " + this.identifier);
        printStream.println("* revision:             " + this.revision);
        printStream.println("* documentType:         " + this.documentType);
        printStream.println("* documentURL:          " + this.documentURL);
    }

    public void prettyPrint(PrintStream printStream) {
        printStream.println("*   " + this.docidFull + "  (" + this.documentURL + ")");
    }

    private void putMetacatDocument(boolean bl, boolean bl2, StringReader stringReader) {
        Metacat metacat = this.harvester.metacat;
        String string = "";
        if (this.harvester.connectToMetacat()) {
            try {
                String string2 = "";
                if (bl) {
                    string2 = "harvester.InsertDocSuccess";
                    string = metacat.insert(this.docidFull, (Reader)stringReader, null);
                    this.inserted = true;
                } else if (bl2) {
                    string2 = "harvester.UpdateDocSuccess";
                    string = metacat.update(this.docidFull, (Reader)stringReader, null);
                    this.updated = true;
                }
                if (this.isMetacatSuccessString(string)) {
                    String string3 = this.docidFull + " : " + string;
                    this.harvester.addLogEntry(0, string3, string2, this.harvestSiteSchedule.siteScheduleID, null, "");
                } else {
                    this.inserted = false;
                    this.updated = false;
                    Exception exception = new Exception("Metacat insert/update failed without reporting an exception");
                    this.logMetacatError(bl, string, "UnreportedMetacatException", exception);
                }
            }
            catch (MetacatInaccessibleException metacatInaccessibleException) {
                this.logMetacatError(bl, string, "MetacatInaccessibleException", (Exception)((Object)metacatInaccessibleException));
            }
            catch (InsufficientKarmaException insufficientKarmaException) {
                this.logMetacatError(bl, string, "InsufficientKarmaException", (Exception)((Object)insufficientKarmaException));
            }
            catch (MetacatException metacatException) {
                this.logMetacatError(bl, string, "MetacatException", (Exception)((Object)metacatException));
            }
            catch (IOException iOException) {
                this.logMetacatError(bl, string, "IOException", iOException);
            }
            catch (Exception exception) {
                this.logMetacatError(bl, string, "Exception", exception);
            }
        }
    }

    private boolean validateDocument() {
        boolean bl = true;
        return bl;
    }
}

