/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.harvesterClient;

import com.oreilly.servlet.ParameterParser;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class HarvesterRegistration
extends HttpServlet {
    private static final String CONFIG_DIR = "WEB-INF";
    private static final long serialVersionUID = 7390084694699704362L;
    private ServletConfig config = null;
    private ServletContext context = null;
    private String defaultDB;
    private final long millisecondsPerDay = 86400000L;
    private String password;
    private String user;

    private boolean checkValues(PrintWriter printWriter, String string, int n) {
        boolean bl = true;
        if (string.equals("")) {
            printWriter.println("A value must be specified in the Harvest List URL field");
            bl = false;
        }
        if (n < 0 || n > 99) {
            printWriter.println("Harvest Frequency should be in the range 1 to 99");
            bl = false;
        }
        return bl;
    }

    private void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void dbInsert(PrintWriter printWriter, Connection connection, int n, String string, String string2, String string3, String string4, String string5, int n2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        long l = (long)n2 * 86400000L;
        if (string5.equals("weeks")) {
            l *= 7L;
        } else if (string5.equals("months")) {
            l *= 30L;
        }
        Date date = new Date();
        long l2 = date.getTime();
        Date date2 = new Date(l2);
        String string6 = simpleDateFormat.format(date2);
        try {
            Statement statement = connection.createStatement();
            String string7 = "insert into HARVEST_SITE_SCHEDULE (SITE_SCHEDULE_ID, CONTACT_EMAIL, DOCUMENTLISTURL, LDAPDN, LDAPPWD, UNIT, UPDATEFREQUENCY, DATENEXTHARVEST) values(" + n + "," + this.quoteString(string) + "," + this.quoteString(string2) + "," + this.quoteString(string3) + "," + this.quoteString(string4) + "," + this.quoteString(string5) + "," + n2 + "," + this.quoteString(string6) + ")";
            System.out.println(string7);
            statement.executeUpdate(string7);
            statement.close();
            this.reportResults(printWriter, string3, string, string2, n2, string5, string6);
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
    }

    private void dbRemove(PrintWriter printWriter, Connection connection, int n, String string) {
        String string2 = "DELETE FROM HARVEST_SITE_SCHEDULE WHERE SITE_SCHEDULE_ID=" + n;
        int n2 = 0;
        try {
            Statement statement = connection.createStatement();
            System.out.println(string2);
            n2 = statement.executeUpdate(string2);
            statement.close();
            System.out.println(n2 + " record(s) removed.");
            if (n2 > 0) {
                printWriter.println("Harvester registration removed for user " + string);
            } else {
                printWriter.println("A problem was encountered removing registration for user " + string);
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
    }

    private void dbUpdate(PrintWriter printWriter, Connection connection, int n, String string, String string2, String string3, String string4, String string5, int n2, String string6) {
        long l;
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd-MMM-yyyy");
        long l2 = date.getTime();
        long l3 = (long)n2 * 86400000L;
        if (string5.equals("weeks")) {
            l3 *= 7L;
        } else if (string5.equals("months")) {
            l3 *= 30L;
        }
        if (string6.equals("")) {
            l = l2;
        } else {
            try {
                Date date2 = simpleDateFormat.parse(string6);
                long l4 = date2.getTime();
                l = l4 + l3;
                l = Math.max(l, l2);
            }
            catch (ParseException parseException) {
                System.out.println("Error parsing date: " + string6 + " " + parseException.getMessage());
                l = l2;
            }
        }
        Date date3 = new Date(l);
        String string7 = simpleDateFormat2.format(date3);
        try {
            Statement statement = connection.createStatement();
            statement.executeUpdate("UPDATE HARVEST_SITE_SCHEDULE SET CONTACT_EMAIL=" + this.quoteString(string) + " WHERE SITE_SCHEDULE_ID = " + n);
            statement.executeUpdate("UPDATE HARVEST_SITE_SCHEDULE SET DOCUMENTLISTURL=" + this.quoteString(string2) + " WHERE SITE_SCHEDULE_ID = " + n);
            statement.executeUpdate("UPDATE HARVEST_SITE_SCHEDULE SET LDAPPWD=" + this.quoteString(string4) + " WHERE SITE_SCHEDULE_ID = " + n);
            statement.executeUpdate("UPDATE HARVEST_SITE_SCHEDULE SET UNIT=" + this.quoteString(string5) + " WHERE SITE_SCHEDULE_ID = " + n);
            statement.executeUpdate("UPDATE HARVEST_SITE_SCHEDULE SET UPDATEFREQUENCY=" + n2 + " WHERE SITE_SCHEDULE_ID = " + n);
            statement.executeUpdate("UPDATE HARVEST_SITE_SCHEDULE SET DATENEXTHARVEST=" + this.quoteString(string7) + " WHERE SITE_SCHEDULE_ID = " + n);
            statement.close();
            this.reportResults(printWriter, string3, string, string2, n2, string5, string7);
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        AutoCloseable autoCloseable;
        Connection connection = this.getConnection();
        String string = "";
        String string2 = "http://";
        String string3 = "days";
        int n = 1;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            System.out.println("User did not log in.");
            return;
        }
        String string4 = (String)httpSession.getAttribute("username");
        String string5 = (String)httpSession.getAttribute("password");
        int n2 = this.getSiteScheduleID(connection, string4);
        if (n2 != 0) {
            String string6 = "SELECT * FROM HARVEST_SITE_SCHEDULE WHERE SITE_SCHEDULE_ID=" + n2;
            try {
                Statement statement = connection.createStatement();
                autoCloseable = statement.executeQuery(string6);
                while (autoCloseable.next()) {
                    string = autoCloseable.getString("CONTACT_EMAIL");
                    string2 = autoCloseable.getString("DOCUMENTLISTURL");
                    n = autoCloseable.getInt("UPDATEFREQUENCY");
                    string3 = autoCloseable.getString("UNIT");
                }
                statement.close();
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException: " + sQLException.getMessage());
            }
        }
        httpServletResponse.setContentType("text/html");
        autoCloseable = httpServletResponse.getWriter();
        ((PrintWriter)autoCloseable).println("<HTML>");
        ((PrintWriter)autoCloseable).println("<HEAD>");
        ((PrintWriter)autoCloseable).println("<TITLE>Metacat Harvester Registration</TITLE>");
        ((PrintWriter)autoCloseable).println("</HEAD>");
        ((PrintWriter)autoCloseable).println("<BODY>");
        ((PrintWriter)autoCloseable).println("<H2><B>Metacat Harvester Registration</B></H2>");
        ((PrintWriter)autoCloseable).println("<FORM METHOD=POST>");
        ((PrintWriter)autoCloseable).println("Fill out the form below to schedule regular harvests of EML ");
        ((PrintWriter)autoCloseable).println("documents from your site.<BR>");
        ((PrintWriter)autoCloseable).println("To register or changes values, enter all values ");
        ((PrintWriter)autoCloseable).println("below and click <B>Register</B>. ");
        ((PrintWriter)autoCloseable).println("To unregister, simply click <B>Unregister</B>.<BR>");
        ((PrintWriter)autoCloseable).println("<table>");
        ((PrintWriter)autoCloseable).println("<tr>");
        ((PrintWriter)autoCloseable).println("<td>");
        ((PrintWriter)autoCloseable).println("Email address:");
        ((PrintWriter)autoCloseable).println("</td>");
        ((PrintWriter)autoCloseable).println("<td>");
        ((PrintWriter)autoCloseable).println("<INPUT TYPE=TEXT NAME=contactEmail SIZE=30 VALUE=");
        ((PrintWriter)autoCloseable).println(string + ">");
        ((PrintWriter)autoCloseable).println("</td>");
        ((PrintWriter)autoCloseable).println("</tr>");
        ((PrintWriter)autoCloseable).println("<tr>");
        ((PrintWriter)autoCloseable).println("<td>");
        ((PrintWriter)autoCloseable).println("Harvest List URL:");
        ((PrintWriter)autoCloseable).println("</td>");
        ((PrintWriter)autoCloseable).println("<td>");
        ((PrintWriter)autoCloseable).println("<INPUT TYPE=TEXT NAME=documentListURL SIZE=50 VALUE=");
        ((PrintWriter)autoCloseable).println(string2 + ">");
        ((PrintWriter)autoCloseable).println("</td>");
        ((PrintWriter)autoCloseable).println("</tr>");
        ((PrintWriter)autoCloseable).println("<tr>");
        ((PrintWriter)autoCloseable).println("<td>");
        ((PrintWriter)autoCloseable).println("Harvest Frequency");
        ((PrintWriter)autoCloseable).println("</td>");
        ((PrintWriter)autoCloseable).println("<td>");
        ((PrintWriter)autoCloseable).println("</td>");
        ((PrintWriter)autoCloseable).println("</tr>");
        ((PrintWriter)autoCloseable).println("<tr>");
        ((PrintWriter)autoCloseable).println("<td>");
        ((PrintWriter)autoCloseable).println("  Once every (1-99):");
        ((PrintWriter)autoCloseable).println("</td>");
        ((PrintWriter)autoCloseable).println("<td>");
        ((PrintWriter)autoCloseable).println("<INPUT TYPE=TEXT NAME=updateFrequency ");
        ((PrintWriter)autoCloseable).println("MAXLENGTH=2 SIZE=2 VALUE=");
        ((PrintWriter)autoCloseable).println(n + ">");
        ((PrintWriter)autoCloseable).println("</td>");
        ((PrintWriter)autoCloseable).println("</tr>");
        ((PrintWriter)autoCloseable).println("<tr>");
        ((PrintWriter)autoCloseable).println("<td>");
        ((PrintWriter)autoCloseable).println("</td>");
        ((PrintWriter)autoCloseable).println("<td>");
        ((PrintWriter)autoCloseable).println("<INPUT TYPE=RADIO ");
        if (string3.equals("days")) {
            ((PrintWriter)autoCloseable).println("CHECKED ");
        }
        ((PrintWriter)autoCloseable).println("NAME=unit VALUE=days>day(s)");
        ((PrintWriter)autoCloseable).println("<INPUT TYPE=RADIO ");
        if (string3.equals("weeks")) {
            ((PrintWriter)autoCloseable).println("CHECKED ");
        }
        ((PrintWriter)autoCloseable).println("NAME=unit VALUE=weeks>week(s)");
        ((PrintWriter)autoCloseable).println("<INPUT TYPE=RADIO ");
        if (string3.equals("months")) {
            ((PrintWriter)autoCloseable).println("CHECKED ");
        }
        ((PrintWriter)autoCloseable).println("NAME=unit VALUE=months>month(s)");
        ((PrintWriter)autoCloseable).println("</td>");
        ((PrintWriter)autoCloseable).println("</tr>");
        ((PrintWriter)autoCloseable).println("<tr></tr>");
        ((PrintWriter)autoCloseable).println("<tr>");
        ((PrintWriter)autoCloseable).println("<td>");
        ((PrintWriter)autoCloseable).println("<INPUT TYPE=SUBMIT NAME=register VALUE=Register>");
        ((PrintWriter)autoCloseable).println("<INPUT TYPE=SUBMIT NAME=unregister VALUE=Unregister>");
        ((PrintWriter)autoCloseable).println("</td>");
        ((PrintWriter)autoCloseable).println("<td>");
        ((PrintWriter)autoCloseable).println("</td>");
        ((PrintWriter)autoCloseable).println("</tr>");
        ((PrintWriter)autoCloseable).println("</table>");
        ((PrintWriter)autoCloseable).println("</BODY>");
        ((PrintWriter)autoCloseable).println("</HTML>");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean bl;
        Connection connection = this.getConnection();
        boolean bl2 = false;
        ParameterParser parameterParser = new ParameterParser((ServletRequest)httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            System.out.println("User did not log in.");
            return;
        }
        String string = (String)httpSession.getAttribute("username");
        String string2 = (String)httpSession.getAttribute("password");
        String string3 = parameterParser.getStringParameter("contactEmail", "None");
        String string4 = parameterParser.getStringParameter("documentListURL", "");
        String string5 = parameterParser.getStringParameter("unit", "days");
        int n = parameterParser.getIntParameter("updateFrequency", 1);
        String string6 = parameterParser.getStringParameter("register", "");
        String string7 = parameterParser.getStringParameter("unregister", "");
        bl2 = string7.equalsIgnoreCase("Unregister");
        int n2 = this.getSiteScheduleID(connection, string);
        String string8 = this.getDateLastHarvest(connection, n2);
        httpServletResponse.setContentType("text/plain");
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (!bl2 && !(bl = this.checkValues(printWriter, string4, n))) {
            return;
        }
        if (n2 == 0) {
            if (bl2) {
                System.out.println("Unable to remove record for user " + string);
                System.out.println("No matching record found in HARVEST_SITE_SCHEDULE");
                printWriter.println("No record found for user " + string + ".");
                printWriter.println("Since you were not registered, no action was taken.");
            } else {
                int n3 = this.getMaxValue(connection, "HARVEST_SITE_SCHEDULE", "SITE_SCHEDULE_ID");
                n2 = n3 + 1;
                this.dbInsert(printWriter, connection, n2, string3, string4, string, string2, string5, n);
            }
        } else if (bl2) {
            this.dbRemove(printWriter, connection, n2, string);
        } else {
            this.dbUpdate(printWriter, connection, n2, string3, string4, string, string2, string5, n, string8);
        }
        this.closeConnection(connection);
    }

    private Connection getConnection() {
        Connection connection = null;
        try {
            SQLWarning sQLWarning;
            System.out.println("Getting connection to Harvester tables");
            connection = DriverManager.getConnection(this.defaultDB, this.user, this.password);
            if (sQLWarning != null) {
                for (sQLWarning = connection.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                    System.out.println("SQLState: " + sQLWarning.getSQLState());
                    System.out.println("Message:  " + sQLWarning.getMessage());
                    System.out.println("Vendor: " + sQLWarning.getErrorCode());
                    System.out.println("");
                }
            }
        }
        catch (SQLException sQLException) {
            System.out.println("Database access failed " + sQLException);
        }
        return connection;
    }

    private String getDateLastHarvest(Connection connection, int n) {
        String string = "";
        String string2 = "SELECT DATELASTHARVEST FROM HARVEST_SITE_SCHEDULE WHERE SITE_SCHEDULE_ID=" + n;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                string = resultSet.getString("DATELASTHARVEST");
                if (!resultSet.wasNull()) continue;
                string = "";
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
        return string;
    }

    private int getMaxValue(Connection connection, String string, String string2) {
        int n = 0;
        String string3 = "SELECT " + string2 + " FROM " + string;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                int n2 = resultSet.getInt(string2);
                n = Math.max(n, n2);
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
        return n;
    }

    private int getSiteScheduleID(Connection connection, String string) {
        String string2 = "SELECT * FROM HARVEST_SITE_SCHEDULE";
        int n = 0;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3 = resultSet.getString("LDAPDN");
                if (!string3.equalsIgnoreCase(string)) continue;
                n = resultSet.getInt("SITE_SCHEDULE_ID");
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
        return n;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        String string = "";
        super.init(servletConfig);
        this.config = servletConfig;
        this.context = servletConfig.getServletContext();
        String string2 = this.context.getRealPath(CONFIG_DIR);
        try {
            ServletContext servletContext = servletConfig.getServletContext();
            PropertyService.getInstance((ServletContext)servletContext);
            string = PropertyService.getProperty((String)"database.driver");
            this.defaultDB = PropertyService.getProperty((String)"database.connectionURI");
            this.password = PropertyService.getProperty((String)"database.password");
            this.user = PropertyService.getProperty((String)"database.user");
        }
        catch (ServiceException serviceException) {
            System.out.println("Error initializing PropertyService: " + serviceException.getMessage());
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            System.out.println("Error reading property: " + propertyNotFoundException.getMessage());
        }
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Can't load driver " + classNotFoundException);
        }
    }

    private String quoteString(String string) {
        return "'" + string + "'";
    }

    private void reportResults(PrintWriter printWriter, String string, String string2, String string3, int n, String string4, String string5) {
        printWriter.println("Harvester registration updated for " + string);
        printWriter.println("  Email Address:             " + string2);
        printWriter.println("  Harvest List URL:          " + string3);
        printWriter.println("  Harvest Frequency:         " + n);
        printWriter.println("  Unit:                      " + string4);
        printWriter.println("");
        printWriter.println("Next scheduled harvest date: " + string5);
    }
}

