/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.AccessionNumber;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.accesscontrol.XMLAccessAccess;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.database.DatabaseService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.AccessException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.access.XMLAccessDAO;
import java.io.File;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectInfo;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationPolicy;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.MediaType;
import org.dataone.service.types.v2.MediaTypeProperty;
import org.dataone.service.types.v2.SystemMetadata;

public class IdentifierManager {
    public static final String TYPE_SYSTEM_METADATA = "systemmetadata";
    public static final String TYPE_IDENTIFIER = "identifier";
    private static boolean filterWhiteSpaces = Settings.getConfiguration().getBoolean("dataone.listingidentifier.filteringwhitespaces", true);
    private static IdentifierManager self = null;
    private Logger logMetacat = Logger.getLogger(IdentifierManager.class);

    private IdentifierManager() {
    }

    public static IdentifierManager getInstance() {
        if (self == null) {
            self = new IdentifierManager();
        }
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemMetadata getSystemMetadata(String guid) throws McdbDocNotFoundException {
        BigInteger numberOfReplicas;
        Boolean replicationAllowed;
        SystemMetadata sysMeta;
        block19: {
            sysMeta = new SystemMetadata();
            String sql = "select guid, date_uploaded, rights_holder, checksum, checksum_algorithm, origin_member_node, authoritive_member_node, date_modified, submitter, object_format, size, replication_allowed, number_replicas, obsoletes, obsoleted_by, serial_version, archived, series_id, file_name, media_type from systemmetadata where guid = ?";
            DBConnection dbConn = null;
            int serialNumber = -1;
            replicationAllowed = new Boolean(false);
            numberOfReplicas = new BigInteger("-1");
            BigInteger serialVersion = new BigInteger("-1");
            Boolean archived = new Boolean(false);
            try {
                dbConn = DBConnectionPool.getDBConnection("IdentifierManager.getSystemMetadata");
                serialNumber = dbConn.getCheckOutSerialNumber();
                PreparedStatement stmt = dbConn.prepareStatement(sql);
                stmt.setString(1, guid);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    Timestamp dateUploaded = rs.getTimestamp(2);
                    String rightsHolder = rs.getString(3);
                    String checksum = rs.getString(4);
                    String checksumAlgorithm = rs.getString(5);
                    String originMemberNode = rs.getString(6);
                    String authoritativeMemberNode = rs.getString(7);
                    Timestamp dateModified = rs.getTimestamp(8);
                    String submitter = rs.getString(9);
                    String fmtidStr = rs.getString(10);
                    BigInteger size = new BigInteger(rs.getString(11));
                    replicationAllowed = new Boolean(rs.getBoolean(12));
                    numberOfReplicas = new BigInteger(rs.getString(13));
                    String obsoletes = rs.getString(14);
                    String obsoletedBy = rs.getString(15);
                    serialVersion = new BigInteger(rs.getString(16));
                    archived = new Boolean(rs.getBoolean(17));
                    String series_id = rs.getString(18);
                    String file_name = rs.getString(19);
                    String media_type = rs.getString(20);
                    Identifier sysMetaId = new Identifier();
                    sysMetaId.setValue(guid);
                    sysMeta.setIdentifier(sysMetaId);
                    sysMeta.setSerialVersion(serialVersion);
                    sysMeta.setDateUploaded((java.util.Date)dateUploaded);
                    Subject rightsHolderSubject = new Subject();
                    rightsHolderSubject.setValue(rightsHolder);
                    sysMeta.setRightsHolder(rightsHolderSubject);
                    Checksum checksumObject = new Checksum();
                    checksumObject.setValue(checksum);
                    checksumObject.setAlgorithm(checksumAlgorithm);
                    sysMeta.setChecksum(checksumObject);
                    if (originMemberNode != null) {
                        NodeReference omn = new NodeReference();
                        omn.setValue(originMemberNode);
                        sysMeta.setOriginMemberNode(omn);
                    }
                    if (authoritativeMemberNode != null) {
                        NodeReference amn = new NodeReference();
                        amn.setValue(authoritativeMemberNode);
                        sysMeta.setAuthoritativeMemberNode(amn);
                    }
                    sysMeta.setDateSysMetadataModified((java.util.Date)dateModified);
                    if (submitter != null) {
                        Subject submitterSubject = new Subject();
                        submitterSubject.setValue(submitter);
                        sysMeta.setSubmitter(submitterSubject);
                    }
                    ObjectFormatIdentifier fmtid = new ObjectFormatIdentifier();
                    fmtid.setValue(fmtidStr);
                    sysMeta.setFormatId(fmtid);
                    sysMeta.setSize(size);
                    if (obsoletes != null) {
                        Identifier obsoletesId = new Identifier();
                        obsoletesId.setValue(obsoletes);
                        sysMeta.setObsoletes(obsoletesId);
                    }
                    if (obsoletedBy != null) {
                        Identifier obsoletedById = new Identifier();
                        obsoletedById.setValue(obsoletedBy);
                        sysMeta.setObsoletedBy(obsoletedById);
                    }
                    sysMeta.setArchived(archived);
                    if (series_id != null) {
                        Identifier seriesId = new Identifier();
                        seriesId.setValue(series_id);
                        sysMeta.setSeriesId(seriesId);
                    }
                    if (file_name != null) {
                        sysMeta.setFileName(file_name);
                    }
                    if (media_type != null) {
                        MediaType mediaType = new MediaType();
                        mediaType.setName(media_type);
                        String mediaTypePropertyQuery = "select name, value from smmediatypeproperties where guid = ?";
                        PreparedStatement stmt2 = dbConn.prepareStatement(mediaTypePropertyQuery);
                        stmt2.setString(1, guid);
                        ResultSet rs2 = stmt2.executeQuery();
                        while (rs2.next()) {
                            String name = rs2.getString(1);
                            String value = rs2.getString(2);
                            MediaTypeProperty property = new MediaTypeProperty();
                            property.setName(name);
                            property.setValue(value);
                            mediaType.addProperty(property);
                        }
                        sysMeta.setMediaType(mediaType);
                        rs2.close();
                        stmt2.close();
                    }
                    stmt.close();
                    break block19;
                }
                stmt.close();
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                throw new McdbDocNotFoundException("Could not find " + guid);
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.logMetacat.error((Object)("Error while getting system metadata for guid " + guid + " : " + e.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
        ReplicationPolicy replicationPolicy = new ReplicationPolicy();
        if (numberOfReplicas != null && numberOfReplicas.intValue() != -1) {
            replicationPolicy.setNumberReplicas(Integer.valueOf(numberOfReplicas.intValue()));
        }
        if (replicationAllowed != null) {
            replicationPolicy.setReplicationAllowed(replicationAllowed);
        }
        replicationPolicy.setBlockedMemberNodeList(this.getReplicationPolicy(guid, "blocked"));
        replicationPolicy.setPreferredMemberNodeList(this.getReplicationPolicy(guid, "preferred"));
        sysMeta.setReplicationPolicy(replicationPolicy);
        sysMeta.setReplicaList(this.getReplicationStatus(guid));
        try {
            sysMeta.setAccessPolicy(this.getAccessPolicy(guid));
        }
        catch (AccessException e) {
            throw new McdbDocNotFoundException(e);
        }
        return sysMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NodeReference> getReplicationPolicy(String guid, String policy) throws McdbDocNotFoundException {
        ArrayList<NodeReference> nodes = new ArrayList<NodeReference>();
        String sql = "select guid, policy, member_node from smReplicationPolicy where guid = ? and policy = ? order by policy_id ASC";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("IdentifierManager.getReplicationPolicy");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            stmt.setString(1, guid);
            stmt.setString(2, policy);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String memberNode = rs.getString(3);
                NodeReference node = new NodeReference();
                node.setValue(memberNode);
                nodes.add(node);
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error while getting system metadata replication policy for guid " + guid), (Throwable)e);
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Replica> getReplicationStatus(String guid) throws McdbDocNotFoundException {
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        String sql = "select guid, member_node, status, date_verified from smReplicationStatus where guid = ?";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("IdentifierManager.getReplicas");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            stmt.setString(1, guid);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String memberNode = rs.getString(2);
                String status = rs.getString(3);
                Timestamp verified = rs.getTimestamp(4);
                Replica replica = new Replica();
                NodeReference node = new NodeReference();
                node.setValue(memberNode);
                replica.setReplicaMemberNode(node);
                replica.setReplicationStatus(ReplicationStatus.valueOf((String)status));
                replica.setReplicaVerified(new java.util.Date(verified.getTime()));
                replicas.add(replica);
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error while getting system metadata replication policy for guid " + guid), (Throwable)e);
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return replicas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLatestRevForLocalId(String localId) throws McdbDocNotFoundException {
        int rev;
        block8: {
            try {
                AccessionNumber acc = new AccessionNumber(localId, "NONE");
                localId = acc.getDocid();
            }
            catch (Exception acc) {
                // empty catch block
            }
            rev = 0;
            String sql = "select rev from xml_documents where docid like ? ";
            DBConnection dbConn = null;
            int serialNumber = -1;
            try {
                dbConn = DBConnectionPool.getDBConnection("IdentifierManager.getLatestRevForLocalId");
                serialNumber = dbConn.getCheckOutSerialNumber();
                PreparedStatement stmt = dbConn.prepareStatement(sql);
                stmt.setString(1, localId);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    rev = rs.getInt(1);
                    stmt.close();
                    break block8;
                }
                stmt.close();
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                throw new McdbDocNotFoundException("While trying to get the latest rev, could not find document " + localId);
            }
            catch (SQLException e) {
                this.logMetacat.error((Object)("Error while looking up the guid: " + e.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
        return rev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLocalIdsWithNoSystemMetadata(boolean includeRevisions, int serverLocation) {
        Vector<String> ids = new Vector<String>();
        String sql = "select docid, rev from xml_documents where docid not in (select docid from identifier where guid in (select guid from systemmetadata))";
        if (serverLocation > 0) {
            sql = sql + " and server_location = ? ";
        }
        String revisionSql = "select docid, rev from xml_revisions where docid not in (select docid from identifier where guid in (select guid from systemmetadata))";
        if (serverLocation > 0) {
            revisionSql = revisionSql + " and server_location = ? ";
        }
        if (includeRevisions) {
            sql = sql + " UNION ALL " + revisionSql;
        }
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("IdentifierManager.getLocalIdsWithNoSystemMetadata");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            if (serverLocation > 0) {
                stmt.setInt(1, serverLocation);
                if (includeRevisions) {
                    stmt.setInt(2, serverLocation);
                }
            }
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String localid = rs.getString(1);
                String rev = rs.getString(2);
                localid = localid + "." + rev;
                this.logMetacat.debug((Object)("id to add SM for: " + localid));
                ids.add(localid);
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error while looking up the guid: " + e.getMessage()));
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllLocalIds() {
        Vector<String> ids = new Vector<String>();
        String sql = "select docid from xml_documents";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("IdentifierManager.getAllLocalIds");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String localid = rs.getString(1);
                ids.add(localid);
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error while looking up the guid: " + e.getMessage()));
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllSystemMetadataGUIDs() {
        Vector<String> guids = new Vector<String>();
        String sql = "select guid from systemmetadata";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("IdentifierManager.getAllGUIDs");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String guid = rs.getString(1);
                guids.add(guid);
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error while retrieving the guid: " + e.getMessage()));
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return guids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUpdatedSystemMetadataIds(java.util.Date since) throws Exception {
        Vector<String> ids = new Vector<String>();
        String sql = "select guid from systemmetadata where guid not in  (select guid from identifier)  and date_modified > ?";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("IdentifierManager.getUpdatedSystemMetadataIds");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            stmt.setDate(1, new Date(since.getTime()));
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String guid = rs.getString(1);
                ids.add(guid);
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error while looking up the updated guids: " + e.getMessage()));
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.util.Date getLastModifiedDate() throws Exception {
        Date maxDate = null;
        Vector ids = new Vector();
        String sql = "select max(date_modified) from systemmetadata";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("IdentifierManager.getLastModifiedDate");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                maxDate = rs.getDate(1);
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error while looking up the latest update date: " + e.getMessage()));
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return maxDate;
    }

    public boolean identifierExists(String guid) throws SQLException {
        boolean idExists;
        block3: {
            idExists = false;
            try {
                String id = this.getLocalId(guid);
                if (id != null) {
                    idExists = true;
                }
            }
            catch (McdbDocNotFoundException e) {
                idExists = this.systemMetadataPIDExists(guid);
                if (idExists) break block3;
                idExists = this.systemMetadataSIDExists(guid);
            }
        }
        return idExists;
    }

    public boolean mappingExists(String guid) throws SQLException {
        boolean idExists = false;
        try {
            String id = this.getLocalId(guid);
            if (id != null) {
                idExists = true;
            }
        }
        catch (McdbDocNotFoundException mcdbDocNotFoundException) {
            // empty catch block
        }
        return idExists;
    }

    public String generateLocalId(String guid, int rev) {
        return this.generateLocalId(guid, rev, false);
    }

    public String generateLocalId(String guid, int rev, boolean isSystemMetadata) {
        String localId = "";
        boolean conformsToDocidFormat = false;
        localId = conformsToDocidFormat ? guid : DocumentUtil.generateDocumentId(rev);
        this.logMetacat.debug((Object)"creating mapping in generateLocalId");
        if (!isSystemMetadata) {
            this.createMapping(guid, localId);
        }
        return localId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getGUID(String docid, int rev) throws McdbDocNotFoundException {
        this.logMetacat.debug((Object)("getting guid for " + docid));
        String query = "select guid from identifier where docid = ? and rev = ?";
        String guid = null;
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement stmt = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("IdentifierManager.getGUID");
            serialNumber = dbConn.getCheckOutSerialNumber();
            stmt = dbConn.prepareStatement(query);
            stmt.setString(1, docid);
            stmt.setInt(2, rev);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) throw new McdbDocNotFoundException("No guid registered for docid " + docid + "." + rev);
            guid = rs.getString(1);
            if (rs == null) return guid;
            rs.close();
            return guid;
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error while looking up the guid: " + e.getMessage()));
            return guid;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                this.logMetacat.warn((Object)("Couldn't close the prepared statement since " + e.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Identifier getHeadPID(Identifier sid) throws SQLException {
        Identifier pid;
        block39: {
            pid = null;
            if (sid != null && sid.getValue() != null && !sid.getValue().trim().equals("")) {
                Identifier firstOne;
                boolean first;
                boolean hasNext;
                Vector<Identifier> endsList;
                HashMap<String, String> obsoletesIdGuidMap;
                boolean hasError;
                ResultSet result;
                ResultSet rs;
                Statement stmt2;
                DBConnection dbConn;
                block38: {
                    this.logMetacat.debug((Object)("getting pid of the head version for matching the sid: " + sid.getValue()));
                    String sql = "select guid, obsoleted_by, obsoletes from systemMetadata where series_id = ? order by date_uploaded DESC";
                    dbConn = null;
                    int serialNumber = -1;
                    PreparedStatement stmt = null;
                    stmt2 = null;
                    rs = null;
                    result = null;
                    hasError = false;
                    obsoletesIdGuidMap = new HashMap<String, String>();
                    endsList = new Vector<Identifier>();
                    try {
                        dbConn = DBConnectionPool.getDBConnection("IdentifierManager.getHeadPID");
                        serialNumber = dbConn.getCheckOutSerialNumber();
                        stmt = dbConn.prepareStatement(sql);
                        stmt.setString(1, sid.getValue());
                        rs = stmt.executeQuery();
                        hasNext = rs.next();
                        first = true;
                        firstOne = new Identifier();
                        if (hasNext) break block38;
                        this.logMetacat.info((Object)("We don't find anything matching the id " + sid.getValue() + " as sid. The null will be returned since it is probably a pid"));
                        break block39;
                    }
                    catch (SQLException e) {
                        this.logMetacat.error((Object)("Error while get the head pid for the sid " + sid.getValue() + " : " + e.getMessage()));
                        throw e;
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            if (result != null) {
                                result.close();
                            }
                            if (stmt != null) {
                                stmt.close();
                            }
                            if (stmt2 != null) {
                                stmt2.close();
                            }
                        }
                        catch (Exception e) {
                            this.logMetacat.warn((Object)("Couldn't close the prepared statement since " + e.getMessage()));
                        }
                        finally {
                            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                        }
                    }
                }
                while (hasNext) {
                    String guidStr = rs.getString(1);
                    String obsoletedByStr = rs.getString(2);
                    String obsoletesStr = rs.getString(3);
                    Identifier guid = new Identifier();
                    guid.setValue(guidStr);
                    if (obsoletesStr != null && !obsoletesStr.trim().equals("")) {
                        if (obsoletesIdGuidMap.containsKey(obsoletesStr) && !guidStr.equals(obsoletesIdGuidMap.get(obsoletesStr))) {
                            this.logMetacat.error((Object)("Both id " + guidStr + " and id " + obsoletesIdGuidMap.get(obsoletesStr) + " obsoletes the id" + obsoletesStr + ". It is illegal. So the head pid maybe is wrong."));
                            hasError = true;
                        }
                        this.logMetacat.debug((Object)("Put " + guidStr + "(a value) Obsoletes " + obsoletesStr + " (a key) into the vector."));
                        obsoletesIdGuidMap.put(obsoletesStr, guidStr);
                    }
                    if (first) {
                        firstOne = guid;
                        first = false;
                    }
                    if (obsoletedByStr == null || obsoletedByStr.trim().equals("")) {
                        this.logMetacat.debug((Object)("" + guidStr + " is a type 1 end for sid " + sid.getValue()));
                        endsList.add(guid);
                    } else {
                        Identifier obsoletedBy = new Identifier();
                        obsoletedBy.setValue(obsoletedByStr);
                        String sql2 = "select series_id, guid from systemMetadata where guid = ? ";
                        stmt2 = dbConn.prepareStatement(sql2);
                        stmt2.setString(1, obsoletedByStr);
                        result = stmt2.executeQuery();
                        boolean next = result.next();
                        if (next) {
                            this.logMetacat.debug((Object)("The object " + obsoletedBy + " which obsoletes " + guidStr + " does have a system metadata on the table."));
                            String sidInObsoletedBy = result.getString(1);
                            if (sidInObsoletedBy == null || !sidInObsoletedBy.equals(sid.getValue())) {
                                this.logMetacat.debug((Object)("" + guidStr + " is a type 2 end for sid " + sid.getValue() + "since it is obsoleted by the object " + sidInObsoletedBy + " which has a different sid or no sids"));
                                endsList.add(guid);
                            }
                        } else {
                            this.logMetacat.debug((Object)("The object " + obsoletedBy + " which obsoletes " + guidStr + " is missing on the host."));
                            if (obsoletesIdGuidMap != null && obsoletesIdGuidMap.containsKey(obsoletedByStr)) {
                                this.logMetacat.debug((Object)("Though the object " + obsoletedBy + " which obsoletes " + guidStr + " is missing." + " However, there is another object " + obsoletesIdGuidMap.get(obsoletedByStr) + " in the chain obsoleting it. So it is not an end."));
                            } else {
                                this.logMetacat.debug((Object)("" + guidStr + " is a type 2 end for sid " + sid.getValue()));
                                endsList.add(guid);
                            }
                        }
                    }
                    hasNext = rs.next();
                }
                if (hasError) {
                    this.logMetacat.info((Object)("The sid chain " + sid.getValue() + " was messed up and we will return the object with the latest upload date."));
                    pid = firstOne;
                } else if (endsList.size() == 1) {
                    this.logMetacat.info((Object)("It is an ideal chain for sid " + sid.getValue()));
                    pid = (Identifier)endsList.get(0);
                } else if (endsList.size() == 0) {
                    this.logMetacat.info((Object)"This is weird situation and we don't find any end. We use the latest DateOfupload");
                    pid = this.checkObsoletesChain(firstOne, obsoletesIdGuidMap);
                } else if (endsList.size() > 1) {
                    this.logMetacat.info((Object)("It is NOT an ideal chain for sid " + sid.getValue()));
                    pid = this.checkObsoletesChain((Identifier)endsList.get(0), obsoletesIdGuidMap);
                }
            }
        }
        if (pid != null && sid != null) {
            this.logMetacat.info((Object)("The head of chain for sid " + sid.getValue() + "  --is--  " + pid.getValue()));
            return pid;
        }
        if (pid != null) return pid;
        if (sid == null) return pid;
        this.logMetacat.info((Object)("The head of chain for sid " + sid.getValue() + " is null. So it is pid."));
        return pid;
    }

    private Identifier checkObsoletesChain(Identifier latestDateUpload, HashMap<String, String> obsoletesIdGuidMap) {
        Identifier pid = latestDateUpload;
        if (obsoletesIdGuidMap != null && latestDateUpload != null && obsoletesIdGuidMap.containsKey(latestDateUpload.getValue())) {
            this.logMetacat.debug((Object)("Another object obsoletes the lasted uploaded object " + latestDateUpload.getValue()));
            String pidStr = obsoletesIdGuidMap.get(latestDateUpload.getValue());
            while (obsoletesIdGuidMap.containsKey(pidStr)) {
                pidStr = obsoletesIdGuidMap.get(pidStr);
                this.logMetacat.debug((Object)("Another object " + pidStr + " obsoletes the object "));
            }
            pid = new Identifier();
            pid.setValue(pidStr);
        }
        if (pid != null && latestDateUpload != null) {
            this.logMetacat.debug((Object)("IdnetifierManager.checkObsoletesChain - The final return value is " + pid.getValue() + " for given value " + latestDateUpload.getValue()));
        }
        return pid;
    }

    public boolean systemMetadataSIDExists(Identifier sid) throws SQLException {
        if (sid != null && sid.getValue() != null && !sid.getValue().trim().equals("")) {
            return this.systemMetadataSIDExists(sid.getValue());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean systemMetadataSIDExists(String sid) throws SQLException {
        boolean exists = false;
        this.logMetacat.debug((Object)("Check if the  sid: " + sid + " exists on the series_id field of the system metadata table."));
        if (sid == null) return exists;
        if (sid.trim().equals("")) return exists;
        String sql = "select guid from systemMetadata where series_id = ?";
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement stmt = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("IdentifierManager.serialIdExists");
            serialNumber = dbConn.getCheckOutSerialNumber();
            stmt = dbConn.prepareStatement(sql);
            stmt.setString(1, sid);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                exists = true;
            }
            if (rs == null) return exists;
            rs.close();
            return exists;
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error while checking if the sid " + sid + " exists on the series_id field of the system metadata table: " + e.getMessage()));
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                this.logMetacat.warn((Object)("Couldn't close the prepared statement since " + e.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    public boolean systemMetadataPIDExists(Identifier pid) throws SQLException {
        if (pid != null && pid.getValue() != null && !pid.getValue().trim().equals("")) {
            return this.systemMetadataPIDExists(pid.getValue());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean systemMetadataPIDExists(String guid) throws SQLException {
        this.logMetacat.debug((Object)("looking up system metadata for guid " + guid));
        boolean exists = false;
        String query = "select guid from systemmetadata where guid = ?";
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement stmt = null;
        if (guid == null) return exists;
        if (guid.trim().equals("")) return exists;
        try {
            dbConn = DBConnectionPool.getDBConnection("IdentifierManager.systemMetadataExisits");
            serialNumber = dbConn.getCheckOutSerialNumber();
            stmt = dbConn.prepareStatement(query);
            stmt.setString(1, guid);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                exists = true;
            }
            if (rs == null) return exists;
            rs.close();
            return exists;
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error while looking up the system metadata: " + e.getMessage()));
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                this.logMetacat.warn((Object)("Couldn't close the prepared statement since " + e.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    public void insertOrUpdateSystemMetadata(SystemMetadata sysmeta) throws McdbDocNotFoundException, SQLException, InvalidSystemMetadata {
        String guid = sysmeta.getIdentifier().getValue();
        DBConnection dbConn = DBConnectionPool.getDBConnection("IdentifierManager.insertSystemMetadata");
        int serialNumber = dbConn.getCheckOutSerialNumber();
        try {
            dbConn.setAutoCommit(false);
            if (!IdentifierManager.getInstance().systemMetadataPIDExists(guid)) {
                this.insertSystemMetadata(guid, dbConn);
            }
            this.updateSystemMetadata(sysmeta, dbConn);
            dbConn.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logMetacat.error((Object)("Error while creating systemmetadata record: " + guid), (Throwable)e);
            dbConn.rollback();
            throw new SQLException("Can't save system metadata " + e.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
    }

    /*
     * Exception decompiling
     */
    public void updateMapping(String guid, String localId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateSystemMetadataFields(long dateUploaded, String rightsHolder, String checksum, String checksumAlgorithm, String originMemberNode, String authoritativeMemberNode, long modifiedDate, String submitter, String guid, String objectFormat, BigInteger size, boolean archived, boolean replicationAllowed, int numberReplicas, String obsoletes, String obsoletedBy, BigInteger serialVersion, String seriesId, String fileName, MediaType mediaType, DBConnection dbConn) throws SQLException {
        Statement stmt = null;
        Statement stmt2 = null;
        try {
            dbConn.setAutoCommit(false);
            String query = "update systemmetadata set (date_uploaded, rights_holder, checksum, checksum_algorithm, origin_member_node, authoritive_member_node, date_modified, submitter, object_format, size, archived, replication_allowed, number_replicas, obsoletes, obsoleted_by, serial_version, series_id, file_name, media_type) = (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?) where guid = ?";
            stmt = dbConn.prepareStatement(query);
            stmt.setTimestamp(1, new Timestamp(dateUploaded));
            stmt.setString(2, rightsHolder);
            stmt.setString(3, checksum);
            stmt.setString(4, checksumAlgorithm);
            stmt.setString(5, originMemberNode);
            stmt.setString(6, authoritativeMemberNode);
            stmt.setTimestamp(7, new Timestamp(modifiedDate));
            stmt.setString(8, submitter);
            stmt.setString(9, objectFormat);
            stmt.setString(10, size.toString());
            stmt.setBoolean(11, archived);
            stmt.setBoolean(12, replicationAllowed);
            stmt.setInt(13, numberReplicas);
            stmt.setString(14, obsoletes);
            stmt.setString(15, obsoletedBy);
            if (serialVersion != null) {
                stmt.setString(16, serialVersion.toString());
            } else {
                stmt.setString(16, null);
            }
            stmt.setString(17, seriesId);
            stmt.setString(18, fileName);
            if (mediaType == null) {
                stmt.setString(19, null);
            } else {
                stmt.setString(19, mediaType.getName());
            }
            stmt.setString(20, guid);
            this.logMetacat.debug((Object)("stmt: " + stmt.toString()));
            int rows = stmt.executeUpdate();
            if (mediaType != null && mediaType.getPropertyList() != null) {
                String sql2 = "insert into smmediatypeproperties (guid, name, value) values (?, ?, ?)";
                stmt2 = dbConn.prepareStatement(sql2);
                for (MediaTypeProperty item : mediaType.getPropertyList()) {
                    if (item == null) continue;
                    String name = item.getName();
                    String value = item.getValue();
                    stmt2.setString(1, guid);
                    stmt2.setString(2, name);
                    stmt2.setString(3, value);
                    this.logMetacat.debug((Object)("insert media type properties query: " + stmt2.toString()));
                    int n = stmt2.executeUpdate();
                }
            }
            dbConn.commit();
            dbConn.setAutoCommit(true);
        }
        catch (Exception e) {
            dbConn.rollback();
            dbConn.setAutoCommit(true);
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (stmt2 != null) {
                stmt2.close();
            }
        }
    }

    private void insertReplicationPolicy(String guid, String policy, List<String> memberNodes, DBConnection dbConn) throws SQLException {
        String delete = "delete from smReplicationPolicy where guid = ? and policy = ?";
        PreparedStatement stmt = dbConn.prepareStatement(delete);
        stmt.setString(1, guid);
        stmt.setString(2, policy);
        int deletedCount = stmt.executeUpdate();
        stmt.close();
        for (String memberNode : memberNodes) {
            String insert = "insert into smReplicationPolicy (guid, policy, member_node) values (?, ?, ?)";
            PreparedStatement insertStatement = dbConn.prepareStatement(insert);
            insertStatement.setString(1, guid);
            insertStatement.setString(2, policy);
            insertStatement.setString(3, memberNode);
            this.logMetacat.debug((Object)("smReplicationPolicy sql: " + insertStatement.toString()));
            int rows = insertStatement.executeUpdate();
            insertStatement.close();
        }
    }

    private void insertReplicationStatus(String guid, List<Replica> replicas, DBConnection dbConn) throws SQLException {
        String delete = "delete from smReplicationStatus where guid = ?";
        PreparedStatement stmt = dbConn.prepareStatement(delete);
        stmt.setString(1, guid);
        int deletedCount = stmt.executeUpdate();
        stmt.close();
        if (replicas != null) {
            for (Replica replica : replicas) {
                String insert = "insert into smReplicationStatus (guid, member_node, status, date_verified) values (?, ?, ?, ?)";
                PreparedStatement insertStatement = dbConn.prepareStatement(insert);
                String memberNode = replica.getReplicaMemberNode().getValue();
                String status = replica.getReplicationStatus().toString();
                Timestamp sqlDate = new Timestamp(replica.getReplicaVerified().getTime());
                insertStatement.setString(1, guid);
                insertStatement.setString(2, memberNode);
                insertStatement.setString(3, status);
                insertStatement.setTimestamp(4, sqlDate);
                this.logMetacat.debug((Object)("smReplicationStatus sql: " + insertStatement.toString()));
                int rows = insertStatement.executeUpdate();
                insertStatement.close();
            }
        }
    }

    public void updateSystemMetadata(SystemMetadata sm, DBConnection dbConn) throws McdbDocNotFoundException, SQLException, InvalidSystemMetadata, AccessException {
        Boolean replicationAllowed = false;
        Integer numberReplicas = -1;
        ReplicationPolicy replicationPolicy = sm.getReplicationPolicy();
        if (replicationPolicy != null) {
            replicationAllowed = replicationPolicy.getReplicationAllowed();
            numberReplicas = replicationPolicy.getNumberReplicas();
            replicationAllowed = replicationAllowed == null ? false : replicationAllowed;
            numberReplicas = numberReplicas == null ? -1 : numberReplicas;
        }
        this.updateSystemMetadataFields(sm.getDateUploaded() == null ? null : Long.valueOf(sm.getDateUploaded().getTime()), sm.getRightsHolder() == null ? null : sm.getRightsHolder().getValue(), sm.getChecksum() == null ? null : sm.getChecksum().getValue(), sm.getChecksum() == null ? null : sm.getChecksum().getAlgorithm(), sm.getOriginMemberNode() == null ? null : sm.getOriginMemberNode().getValue(), sm.getAuthoritativeMemberNode() == null ? null : sm.getAuthoritativeMemberNode().getValue(), sm.getDateSysMetadataModified() == null ? null : Long.valueOf(sm.getDateSysMetadataModified().getTime()), sm.getSubmitter() == null ? null : sm.getSubmitter().getValue(), sm.getIdentifier().getValue(), sm.getFormatId() == null ? null : sm.getFormatId().getValue(), sm.getSize(), sm.getArchived() == null ? false : sm.getArchived(), replicationAllowed, numberReplicas, sm.getObsoletes() == null ? null : sm.getObsoletes().getValue(), sm.getObsoletedBy() == null ? null : sm.getObsoletedBy().getValue(), sm.getSerialVersion(), sm.getSeriesId() == null ? null : sm.getSeriesId().getValue(), sm.getFileName() == null ? null : sm.getFileName(), sm.getMediaType() == null ? null : sm.getMediaType(), dbConn);
        String guid = sm.getIdentifier().getValue();
        if (replicationPolicy != null) {
            ArrayList<String> nodes = null;
            String policy = null;
            if (replicationPolicy.getBlockedMemberNodeList() != null) {
                nodes = new ArrayList<String>();
                policy = "blocked";
                for (NodeReference node : replicationPolicy.getBlockedMemberNodeList()) {
                    nodes.add(node.getValue());
                }
                this.insertReplicationPolicy(guid, policy, nodes, dbConn);
            }
            if (replicationPolicy.getPreferredMemberNodeList() != null) {
                nodes = new ArrayList();
                policy = "preferred";
                for (NodeReference node : replicationPolicy.getPreferredMemberNodeList()) {
                    nodes.add(node.getValue());
                }
                this.insertReplicationPolicy(guid, policy, nodes, dbConn);
            }
        }
        this.insertReplicationStatus(guid, sm.getReplicaList(), dbConn);
        AccessPolicy accessPolicy = sm.getAccessPolicy();
        if (accessPolicy != null) {
            this.insertAccessPolicy(guid, accessPolicy);
        }
    }

    private void insertAccessPolicy(String guid, AccessPolicy accessPolicy) throws McdbDocNotFoundException, AccessException {
        XMLAccessAccess accessController = new XMLAccessAccess();
        String existingPermOrder = "allowFirst";
        Vector<XMLAccessDAO> existingAccess = accessController.getXMLAccessForDoc(guid);
        if (existingAccess != null && existingAccess.size() > 0) {
            existingPermOrder = existingAccess.get(0).getPermOrder();
        }
        ArrayList<XMLAccessDAO> accessDAOs = new ArrayList<XMLAccessDAO>();
        for (AccessRule accessRule : accessPolicy.getAllowList()) {
            List subjects = accessRule.getSubjectList();
            List permissions = accessRule.getPermissionList();
            for (Subject subject : subjects) {
                XMLAccessDAO accessDAO = new XMLAccessDAO();
                accessDAO.setPrincipalName(subject.getValue());
                accessDAO.setGuid(guid);
                accessDAO.setPermType("allow");
                accessDAO.setPermOrder(existingPermOrder);
                if (permissions != null) {
                    for (Permission permission : permissions) {
                        Long metacatPermission = new Long(this.convertPermission(permission));
                        accessDAO.addPermission(metacatPermission);
                    }
                }
                accessDAOs.add(accessDAO);
            }
        }
        accessController.deleteXMLAccessForDoc(guid, "allow");
        accessController.insertAccess(guid, accessDAOs);
    }

    public AccessPolicy getAccessPolicy(String guid) throws McdbDocNotFoundException, AccessException {
        AccessPolicy accessPolicy = new AccessPolicy();
        XMLAccessAccess accessController = new XMLAccessAccess();
        Vector<XMLAccessDAO> accessDAOs = accessController.getXMLAccessForDoc(guid);
        for (XMLAccessDAO accessDAO : accessDAOs) {
            if (!accessDAO.getPermType().equals("allow")) continue;
            AccessRule accessRule = new AccessRule();
            List<Permission> permissions = this.convertPermission(accessDAO.getPermission().intValue());
            if (permissions == null || permissions.isEmpty()) {
                this.logMetacat.warn((Object)("skipping empty access rule permissions for " + guid));
                continue;
            }
            accessRule.setPermissionList(permissions);
            Subject subject = new Subject();
            subject.setValue(accessDAO.getPrincipalName());
            accessRule.addSubject(subject);
            accessPolicy.addAllow(accessRule);
        }
        return accessPolicy;
    }

    public int convertPermission(Permission permission) {
        if (permission.equals((Object)Permission.READ)) {
            return 4;
        }
        if (permission.equals((Object)Permission.WRITE)) {
            return 2;
        }
        if (permission.equals((Object)Permission.CHANGE_PERMISSION)) {
            return 7;
        }
        return -1;
    }

    public List<Permission> convertPermission(int permission) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        if (permission == 7) {
            permissions.add(Permission.READ);
            permissions.add(Permission.WRITE);
            permissions.add(Permission.CHANGE_PERMISSION);
            return permissions;
        }
        if ((permission & 1) == 1) {
            permissions.add(Permission.CHANGE_PERMISSION);
        }
        if ((permission & 4) == 4) {
            permissions.add(Permission.READ);
        }
        if ((permission & 2) == 2) {
            permissions.add(Permission.WRITE);
        }
        return permissions;
    }

    public String getLocalId(String guid) throws McdbDocNotFoundException, SQLException {
        String db_guid = "";
        String docid = "";
        int rev = 0;
        String query = "select guid, docid, rev from identifier where guid = ?";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("Identifier.getLocalId");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement stmt = dbConn.prepareStatement(query);
            stmt.setString(1, guid);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                db_guid = rs.getString(1);
                docid = rs.getString(2);
                rev = rs.getInt(3);
                assert (db_guid.equals(guid));
            } else {
                throw new McdbDocNotFoundException("Document not found:" + guid);
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error while looking up the local identifier: " + e.getMessage()));
            throw e;
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return docid + "." + rev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectList querySystemMetadata(java.util.Date startTime, java.util.Date endTime, ObjectFormatIdentifier objectFormatId, NodeReference nodeId, int start, int count, Identifier identifier, boolean isSID) throws SQLException, PropertyNotFoundException, ServiceException {
        ObjectList ol = new ObjectList();
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement countStmt = null;
        ResultSet totalResult = null;
        Statement fieldStmt = null;
        ResultSet rs = null;
        try {
            String fieldSql = "select guid, date_uploaded, rights_holder, checksum, checksum_algorithm, origin_member_node, authoritive_member_node, date_modified, submitter, object_format, size from systemmetadata";
            String countSql = "select count(guid) from systemmetadata";
            String whereClauseSql = "";
            boolean f1 = false;
            boolean f2 = false;
            boolean f3 = false;
            boolean f4 = false;
            boolean f5 = false;
            if (startTime != null) {
                whereClauseSql = whereClauseSql + " where systemmetadata.date_modified >= ?";
                f1 = true;
            }
            if (endTime != null) {
                whereClauseSql = !f1 ? whereClauseSql + " where systemmetadata.date_modified < ?" : whereClauseSql + " and systemmetadata.date_modified < ?";
                f2 = true;
            }
            if (objectFormatId != null) {
                whereClauseSql = !f1 && !f2 ? whereClauseSql + " where object_format = ?" : whereClauseSql + " and object_format = ?";
                f3 = true;
            }
            if (identifier != null && identifier.getValue() != null && !identifier.getValue().equals("")) {
                whereClauseSql = !(f1 || f2 || f3) ? (isSID ? whereClauseSql + " where series_id = ?" : whereClauseSql + " where guid = ?") : (isSID ? whereClauseSql + " and series_id = ?" : whereClauseSql + " and guid = ?");
                f4 = true;
            }
            if (nodeId != null && nodeId.getValue() != null && !nodeId.getValue().trim().equals("")) {
                whereClauseSql = !f1 && !f2 && !f3 && !f4 ? whereClauseSql + " where authoritive_member_node = '" + nodeId.getValue().trim() + "'" : whereClauseSql + " and authoritive_member_node = '" + nodeId.getValue().trim() + "'";
                f5 = true;
            }
            if (filterWhiteSpaces) {
                this.logMetacat.debug((Object)"IdnetifierManager.querySystemMetadata - the default value of the property \"dataone.listingidentifier.filteringwhitespaces\" is true, so we will filter the white spaces in the query");
                whereClauseSql = !(f1 || f2 || f3 || f4 || f5) ? whereClauseSql + " where guid not like '% %' " : whereClauseSql + " and guid not like '% %' ";
            } else {
                this.logMetacat.debug((Object)"IdnetifierManager.querySystemMetadata - the property \"dataone.listingidentifier.filteringwhitespaces\" is configured to be false, so we don't filter the white spaces in the query.");
            }
            dbConn = DBConnectionPool.getDBConnection("IdentifierManager.querySystemMetadata");
            serialNumber = dbConn.getCheckOutSerialNumber();
            String orderBySql = " order by guid ";
            String fieldQuery = fieldSql + whereClauseSql + orderBySql;
            String finalQuery = DatabaseService.getInstance().getDBAdapter().getPagedQuery(fieldQuery, start, count);
            fieldStmt = dbConn.prepareStatement(finalQuery);
            String countQuery = countSql + whereClauseSql;
            countStmt = dbConn.prepareStatement(countQuery);
            if (f1 && f2 && f3 && f4) {
                fieldStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                fieldStmt.setTimestamp(2, new Timestamp(endTime.getTime()));
                fieldStmt.setString(3, objectFormatId.getValue());
                fieldStmt.setString(4, identifier.getValue());
                countStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                countStmt.setTimestamp(2, new Timestamp(endTime.getTime()));
                countStmt.setString(3, objectFormatId.getValue());
                countStmt.setString(4, identifier.getValue());
            }
            if (f1 && f2 && f3 && !f4) {
                fieldStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                fieldStmt.setTimestamp(2, new Timestamp(endTime.getTime()));
                fieldStmt.setString(3, objectFormatId.getValue());
                countStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                countStmt.setTimestamp(2, new Timestamp(endTime.getTime()));
                countStmt.setString(3, objectFormatId.getValue());
            } else if (f1 && f2 && !f3 && f4) {
                fieldStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                fieldStmt.setTimestamp(2, new Timestamp(endTime.getTime()));
                fieldStmt.setString(3, identifier.getValue());
                countStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                countStmt.setTimestamp(2, new Timestamp(endTime.getTime()));
                countStmt.setString(3, identifier.getValue());
            } else if (f1 && f2 && !f3 && !f4) {
                fieldStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                fieldStmt.setTimestamp(2, new Timestamp(endTime.getTime()));
                countStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                countStmt.setTimestamp(2, new Timestamp(endTime.getTime()));
            } else if (f1 && !f2 && f3 && f4) {
                fieldStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                fieldStmt.setString(2, objectFormatId.getValue());
                fieldStmt.setString(3, identifier.getValue());
                countStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                countStmt.setString(2, objectFormatId.getValue());
                countStmt.setString(3, identifier.getValue());
            } else if (f1 && !f2 && f3 && !f4) {
                fieldStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                fieldStmt.setString(2, objectFormatId.getValue());
                countStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                countStmt.setString(2, objectFormatId.getValue());
            } else if (f1 && !f2 && !f3 && f4) {
                fieldStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                fieldStmt.setString(2, identifier.getValue());
                countStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                countStmt.setString(2, identifier.getValue());
            } else if (f1 && !f2 && !f3 && !f4) {
                fieldStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
                countStmt.setTimestamp(1, new Timestamp(startTime.getTime()));
            } else if (!f1 && f2 && f3 && f4) {
                fieldStmt.setTimestamp(1, new Timestamp(endTime.getTime()));
                fieldStmt.setString(2, objectFormatId.getValue());
                fieldStmt.setString(3, identifier.getValue());
                countStmt.setTimestamp(1, new Timestamp(endTime.getTime()));
                countStmt.setString(2, objectFormatId.getValue());
                countStmt.setString(3, identifier.getValue());
            } else if (!f1 && f2 && f3 && !f4) {
                fieldStmt.setTimestamp(1, new Timestamp(endTime.getTime()));
                fieldStmt.setString(2, objectFormatId.getValue());
                countStmt.setTimestamp(1, new Timestamp(endTime.getTime()));
                countStmt.setString(2, objectFormatId.getValue());
            } else if (!f1 && !f2 && f3 && f4) {
                fieldStmt.setString(1, objectFormatId.getValue());
                fieldStmt.setString(2, identifier.getValue());
                countStmt.setString(1, objectFormatId.getValue());
                countStmt.setString(2, identifier.getValue());
            } else if (!f1 && !f2 && f3 && !f4) {
                fieldStmt.setString(1, objectFormatId.getValue());
                countStmt.setString(1, objectFormatId.getValue());
            } else if (!f1 && f2 && !f3 && f4) {
                fieldStmt.setTimestamp(1, new Timestamp(endTime.getTime()));
                fieldStmt.setString(2, identifier.getValue());
                countStmt.setTimestamp(1, new Timestamp(endTime.getTime()));
                countStmt.setString(2, identifier.getValue());
            } else if (!f1 && f2 && !f3 && !f4) {
                fieldStmt.setTimestamp(1, new Timestamp(endTime.getTime()));
                countStmt.setTimestamp(1, new Timestamp(endTime.getTime()));
            } else if (!f1 && !f2 && !f3 && f4) {
                fieldStmt.setString(1, identifier.getValue());
                countStmt.setString(1, identifier.getValue());
            } else if (f1 || f2 || f3 || !f4) {
                // empty if block
            }
            this.logMetacat.info((Object)("list objects fieldStmt: " + fieldStmt.toString()));
            this.logMetacat.info((Object)("list objects countStmt: " + countStmt.toString()));
            int total = 0;
            totalResult = countStmt.executeQuery();
            if (totalResult.next()) {
                total = totalResult.getInt(1);
            }
            this.logMetacat.debug((Object)("list objects total: " + total));
            ol.setStart(start);
            ol.setCount(count);
            if (count != 0) {
                rs = fieldStmt.executeQuery();
                while (rs.next()) {
                    String guid = rs.getString(1);
                    this.logMetacat.debug((Object)("query found object with guid " + guid));
                    String checksum = rs.getString(4);
                    String checksumAlgorithm = rs.getString(5);
                    Timestamp dateModified = rs.getTimestamp(8);
                    String fmtidStr = rs.getString(10);
                    String sz = rs.getString(11);
                    BigInteger size = new BigInteger("0");
                    if (sz != null && !sz.trim().equals("")) {
                        size = new BigInteger(rs.getString(11));
                    }
                    ObjectInfo oi = new ObjectInfo();
                    Identifier id = new Identifier();
                    id.setValue(guid);
                    oi.setIdentifier(id);
                    if (dateModified != null) {
                        oi.setDateSysMetadataModified((java.util.Date)dateModified);
                    }
                    Checksum cs = new Checksum();
                    cs.setValue(checksum);
                    try {
                        cs.setAlgorithm(checksumAlgorithm);
                    }
                    catch (Exception e) {
                        this.logMetacat.error((Object)"could not parse checksum algorithm", (Throwable)e);
                        continue;
                    }
                    oi.setChecksum(cs);
                    ObjectFormatIdentifier fmtid = new ObjectFormatIdentifier();
                    fmtid.setValue(fmtidStr);
                    oi.setFormatId(fmtid);
                    oi.setSize(size);
                    ol.addObjectInfo(oi);
                }
                this.logMetacat.debug((Object)("list objects count: " + ol.sizeObjectInfoList()));
                ol.setCount(ol.sizeObjectInfoList());
            }
            ol.setTotal(total);
        }
        catch (Throwable throwable) {
            try {
                if (totalResult != null) {
                    totalResult.close();
                }
                if (countStmt != null) {
                    countStmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (fieldStmt != null) {
                    fieldStmt.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            throw throwable;
        }
        try {
            if (totalResult != null) {
                totalResult.close();
            }
            if (countStmt != null) {
                countStmt.close();
            }
            if (rs != null) {
                rs.close();
            }
            if (fieldStmt != null) {
                fieldStmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        if (ol != null) {
            this.logMetacat.debug((Object)("list objects start(before returning): " + ol.getStart()));
            this.logMetacat.debug((Object)("list objects count: " + ol.getCount()));
            this.logMetacat.debug((Object)("list objects total: " + ol.getTotal()));
        }
        return ol;
    }

    /*
     * Exception decompiling
     */
    public void createMapping(String guid, String localId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void removeMapping(String guid, String localId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void insertSystemMetadata(String guid, DBConnection dbConn) throws SQLException {
        String query = "insert into systemmetadata (guid) values (?)";
        PreparedStatement stmt = dbConn.prepareStatement(query);
        stmt.setString(1, guid);
        this.logMetacat.debug((Object)("system metadata query: " + stmt.toString()));
        int rows = stmt.executeUpdate();
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSystemMetadata(String guid) {
        boolean success = false;
        int serialNumber = -1;
        DBConnection dbConn = null;
        String query = null;
        PreparedStatement stmt = null;
        int rows = 0;
        try {
            dbConn = DBConnectionPool.getDBConnection("IdentifierManager.deleteSystemMetadata");
            serialNumber = dbConn.getCheckOutSerialNumber();
            dbConn.setAutoCommit(false);
            query = "delete from smReplicationPolicy where guid = ?";
            stmt = dbConn.prepareStatement(query);
            stmt.setString(1, guid);
            this.logMetacat.debug((Object)("delete smReplicationPolicy: " + stmt.toString()));
            rows = stmt.executeUpdate();
            stmt.close();
            query = "delete from smReplicationStatus where guid = ?";
            stmt = dbConn.prepareStatement(query);
            stmt.setString(1, guid);
            this.logMetacat.debug((Object)("delete smReplicationStatus: " + stmt.toString()));
            rows = stmt.executeUpdate();
            stmt.close();
            query = "delete from smMediaTypeProperties where guid = ?";
            stmt = dbConn.prepareStatement(query);
            stmt.setString(1, guid);
            this.logMetacat.debug((Object)("delete smMediaTypeProperties: " + stmt.toString()));
            rows = stmt.executeUpdate();
            stmt.close();
            query = "delete from xml_access where guid = ?";
            stmt = dbConn.prepareStatement(query);
            stmt.setString(1, guid);
            this.logMetacat.debug((Object)("delete xml_access: " + stmt.toString()));
            rows = stmt.executeUpdate();
            stmt.close();
            query = "delete from systemmetadata where guid = ? ";
            stmt = dbConn.prepareStatement(query);
            stmt.setString(1, guid);
            this.logMetacat.debug((Object)("delete system metadata: " + stmt.toString()));
            rows = stmt.executeUpdate();
            stmt.close();
            dbConn.commit();
            dbConn.setAutoCommit(true);
            success = true;
        }
        catch (Exception e) {
            this.logMetacat.error((Object)("Error while deleting systemmetadata record: " + guid), (Throwable)e);
            try {
                dbConn.rollback();
            }
            catch (SQLException sqle) {
                this.logMetacat.error((Object)("Error while rolling back delete for record: " + guid), (Throwable)sqle);
            }
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAuthoritativeMemberNodeId(String existingMemberNodeId, String newMemberNodeId) {
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("IdentifierManager.updateAuthoritativeMemberNodeId");
            serialNumber = dbConn.getCheckOutSerialNumber();
            String query = "update systemmetadata set authoritive_member_node = ?  where authoritive_member_node = ?";
            PreparedStatement stmt = dbConn.prepareStatement(query);
            stmt.setString(1, newMemberNodeId);
            stmt.setString(2, existingMemberNodeId);
            this.logMetacat.debug((Object)("stmt: " + stmt.toString()));
            int rows = stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.logMetacat.error((Object)("updateSystemMetadataFields: SQL error while updating system metadata: " + e.getMessage()));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            this.logMetacat.error((Object)("updateSystemMetadataFields: NumberFormat error while updating system metadata: " + e.getMessage()));
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
    }

    public boolean objectFileExists(String localId, boolean isScienceMetadata) throws PropertyNotFoundException {
        String documentPath;
        boolean exist = false;
        if (localId != null && (documentPath = this.getObjectFilePath(localId, isScienceMetadata)) != null) {
            File file = new File(documentPath);
            exist = file.exists();
        }
        this.logMetacat.debug((Object)("IdentifierManager.ObjectFileExist - Does the object file for the local id " + localId + " which is science metadata " + isScienceMetadata + " exist in the Metacast file system? The answer is " + exist));
        return exist;
    }

    public String getObjectFilePath(String localId, boolean isScienceMetadata) throws PropertyNotFoundException {
        String documentPath = null;
        if (localId != null) {
            String documentDir = null;
            documentDir = isScienceMetadata ? PropertyService.getProperty("application.documentfilepath") : PropertyService.getProperty("application.datafilepath");
            documentPath = documentDir + FileUtil.getFS() + localId;
        }
        this.logMetacat.debug((Object)("IdentifierManager.getObjectFilePath - the file path for the object with localId " + localId + " which is scienceMetacat " + isScienceMetadata + ", is " + documentPath + ". If the value is null, this means we can't find it."));
        return documentPath;
    }

    public boolean existsInXmlLRevisionTable(String docid, int rev) throws SQLException {
        boolean exist = false;
        DBConnection conn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        ResultSet rs = null;
        this.logMetacat.info((Object)("IdentifierManager.existsInXmlLRevisionTable - the docid is " + docid + " and rev is " + rev));
        try {
            conn = DBConnectionPool.getDBConnection("IdentifierManager.existsInXmlLRevisionTable");
            serialNumber = conn.getCheckOutSerialNumber();
            this.logMetacat.debug((Object)("IdentifierManager.existsInXmlLRevisionTable - check if the document " + docid + "." + rev + " exists in the xml_revision table"));
            pstmt = conn.prepareStatement("SELECT rev, docid FROM xml_revisions WHERE docid = ? AND rev = ?");
            pstmt.setString(1, docid);
            pstmt.setInt(2, rev);
            this.logMetacat.debug((Object)("IdentifierManager.existsInXmlLRevisionTable - executing SQL: " + pstmt.toString()));
            pstmt.execute();
            rs = pstmt.getResultSet();
            if (rs.next()) {
                exist = true;
            }
            conn.increaseUsageCount(1);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(conn, serialNumber);
            if (rs != null) {
                rs.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
        this.logMetacat.info((Object)("IdentifierManager.existsInXmlLRevisionTable - Does the docid " + docid + "." + rev + " exist in the xml_revision table? - " + exist));
        return exist;
    }
}

