/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.MetacatAdmin;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.replication.ReplicationService;
import edu.ucsb.nceas.metacat.service.SessionService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.metacat.util.SessionData;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class ReplicationAdmin
extends MetacatAdmin {
    private static ReplicationAdmin instance = null;
    private Logger logMetacat = Logger.getLogger(ReplicationAdmin.class);

    private ReplicationAdmin() throws AdminException {
    }

    public static ReplicationAdmin getInstance() throws AdminException {
        if (instance == null) {
            instance = new ReplicationAdmin();
        }
        return instance;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws AdminException, ServiceException, IOException, MetacatUtilException {
        PrintWriter out = null;
        Hashtable<String, String[]> params = new Hashtable<String, String[]>();
        Enumeration paramlist = request.getParameterNames();
        while (paramlist.hasMoreElements()) {
            String name = (String)paramlist.nextElement();
            String[] value = request.getParameterValues(name);
            params.put(name, value);
        }
        String action = "";
        if (!params.isEmpty() && params.get("action") != null) {
            action = ((String[])params.get("action"))[0];
        }
        HttpSession session = request.getSession(true);
        SessionData sessionData = null;
        String sessionId = "";
        String username = "";
        String[] groupnames = new String[]{""};
        if (params.containsKey("sessionid")) {
            sessionId = ((String[])params.get("sessionid"))[0];
            this.logMetacat.info((Object)("sessionid " + sessionId));
            if (SessionService.getInstance().isSessionRegistered(sessionId)) {
                this.logMetacat.info((Object)("Looking up id " + sessionId + " in registered sessions"));
                sessionData = SessionService.getInstance().getRegisteredSession(sessionId);
            }
        }
        if (sessionData == null) {
            sessionData = new SessionData(session.getId(), (String)session.getAttribute("username"), (String[])session.getAttribute("groups"), (String)session.getAttribute("password"), (String)session.getAttribute("name"));
        }
        username = sessionData.getUserName();
        this.logMetacat.warn((Object)("The user name from session is: " + username));
        groupnames = sessionData.getGroupNames();
        if (!AuthUtil.isAdministrator(username, groupnames)) {
            String msg = "The user \"" + username + "\" is not authorized for this action: " + action;
            out = response.getWriter();
            out.print("<error>");
            out.print(msg);
            out.print("</error>");
            out.close();
            this.logMetacat.warn((Object)msg);
            return;
        }
        if (action.equals("stop")) {
            ReplicationService.getInstance().stopReplication();
            out = response.getWriter();
            out.println("Replication Handler Stopped");
        } else if (action.equals("start")) {
            ReplicationService.getInstance().startReplication(params);
            out = response.getWriter();
            out.println("Replication Handler Started");
        } else if (action.equals("getall")) {
            ReplicationService.getInstance().runOnce();
            response.setContentType("text/html");
            out = response.getWriter();
            out.println("<html><body>\"Get All\" Done</body></html>");
        } else if (action.equals("servercontrol")) {
            ReplicationService.handleServerControlRequest(params, request, response);
        } else if (action.equals("resynchSystemMetadata")) {
            HazelcastService.getInstance().resynchInThread();
            response.setContentType("text/html");
            out = response.getWriter();
            out.println("<html><body>SystemMetadata resynch has been started</body></html>");
        } else {
            RequestUtil.forwardRequest(request, response, "/admin/replication-configuration.jsp", null);
        }
    }

    @Override
    protected Vector<String> validateOptions(HttpServletRequest request) {
        Vector<String> errorVector = new Vector<String>();
        return errorVector;
    }
}

