/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.advancedsearch;

import edu.ucsb.nceas.metacat.advancedsearch.AdvancedSearch;
import edu.ucsb.nceas.metacat.advancedsearch.AdvancedSearchBean;
import edu.ucsb.nceas.metacat.advancedsearch.MetacatHelper;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AdvancedSearchServlet
extends HttpServlet {
    static final long serialVersionUID = 0L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession httpSession = request.getSession();
        Metacat metacat = (Metacat)httpSession.getAttribute("metacat");
        MetacatHelper metacatHelper = new MetacatHelper();
        String qformat = (String)httpSession.getAttribute("qformat");
        String resultsJSP = metacatHelper.getResultsJSP();
        ServletContext servletContext = httpSession.getServletContext();
        String xslPath = metacatHelper.getResultsetXSL(request);
        String metacatURL = servletContext.getInitParameter("metacatURL");
        if (metacatURL == null || metacatURL.equals("")) {
            try {
                metacatURL = SystemUtil.getContextURL() + "/metacat";
            }
            catch (PropertyNotFoundException pnfe) {
                throw new ServletException("Could not get Metacat URL: " + pnfe.getMessage());
            }
        }
        AdvancedSearchBean advancedSearchBean = (AdvancedSearchBean)request.getAttribute("advancedSearchBean");
        AdvancedSearch advancedSearch = new AdvancedSearch(advancedSearchBean);
        String result = advancedSearch.executeAdvancedSearch(metacatURL, metacat, qformat, xslPath);
        request.setAttribute("result", (Object)result);
        RequestDispatcher dispatcher = request.getRequestDispatcher(resultsJSP);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            ServletContext context = config.getServletContext();
            PropertyService.getInstance(context);
        }
        catch (ServiceException se) {
            System.err.println("Error in loading properties: " + se.getMessage());
        }
    }
}

