/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.lsid;

import com.ibm.lsid.ExpiringResponse;
import com.ibm.lsid.LSID;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.LSIDServiceConfig;
import com.ibm.lsid.server.impl.SimpleAuthority;
import com.ibm.lsid.wsdl.HTTPLocation;
import com.ibm.lsid.wsdl.LSIDDataPort;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import com.ibm.lsid.wsdl.SOAPLocation;
import edu.ucsb.nceas.metacat.lsid.LSIDDataLookup;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LSIDAuthorityMain
extends SimpleAuthority {
    private LSIDDataLookup lookup = null;
    private static Log logger = LogFactory.getLog((String)"edu.ucsb.nceas.metacat.lsid");
    private static final Pattern HOST_PTN = Pattern.compile("https?://([^/:]+)(?::(\\d+))?(.*)/authority(.*)");

    public void initService(LSIDServiceConfig cf) throws LSIDServerException {
        logger.info((Object)"Starting LSIDAuthorityMain.");
        this.lookup = new LSIDDataLookup();
    }

    public ExpiringResponse getKnownURIs() throws LSIDServerException {
        logger.debug((Object)"In LSIDAuthorityMain.getKnownURIs()");
        return null;
    }

    public LSIDMetadataPort[] getMetadataLocations(LSID lsid, String url) {
        int lsType;
        logger.debug((Object)"In LSIDAuthorityMain.getMetadataLocations()");
        if (this.lookup == null) {
            return null;
        }
        try {
            lsType = this.lookup.lsidType(lsid);
        }
        catch (LSIDServerException ex) {
            ex.printStackTrace();
            lsType = 1;
        }
        if (lsType == 1) {
            return null;
        }
        HostDescriptor hd = new HostDescriptor(url);
        return new LSIDMetadataPort[]{new HTTPLocation(hd.host, hd.port, hd.pathPrefix + "/authority/metadata"), new SOAPLocation(hd.baseURL + "metadata")};
    }

    public LSIDDataPort[] getDataLocations(LSID lsid, String url) {
        int lsType;
        logger.debug((Object)"In LSIDAuthorityMain.getDataLocations()");
        if (this.lookup == null) {
            return null;
        }
        try {
            lsType = this.lookup.lsidType(lsid);
        }
        catch (LSIDServerException ex) {
            ex.printStackTrace();
            lsType = 1;
        }
        if (lsType == 1) {
            return null;
        }
        if (lsType == 2) {
            return new LSIDDataPort[0];
        }
        HostDescriptor hd = new HostDescriptor(url);
        return new LSIDDataPort[]{new HTTPLocation(hd.host, hd.port, hd.pathPrefix + "/authority/data"), new SOAPLocation(hd.baseURL + "data")};
    }

    private class HostDescriptor {
        public String host;
        public int port;
        public String pathPrefix;
        public String baseURL;

        public HostDescriptor(String url) {
            logger.debug((Object)("Creating a HostDescriptor for: " + url));
            this.host = "localhost";
            this.port = -1;
            this.pathPrefix = "";
            if (url != null || url.length() > 0) {
                logger.debug((Object)"HostDescriptor: url is > 0 length");
                Matcher m = HOST_PTN.matcher(url);
                if (m.lookingAt()) {
                    this.host = m.group(1);
                    logger.debug((Object)("HostDescriptor.host: " + this.host));
                    if (m.group(2) != null && m.group(2).length() > 0) {
                        this.port = Integer.parseInt(m.group(2));
                    }
                    logger.debug((Object)("HostDescriptor.port: " + this.port));
                    this.pathPrefix = m.group(3);
                    logger.debug((Object)("HostDescriptor.pathPrefix: " + this.pathPrefix));
                }
            }
            this.baseURL = this.port > 0 ? "http://" + this.host + ":" + this.port + this.pathPrefix + "/authority/" : "http://" + this.host + this.pathPrefix + "/authority/";
            logger.debug((Object)("HostDescriptor.baseURL: " + this.baseURL));
        }
    }
}

