/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.oaipmh.provider.server.crosswalk;

import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;

public class Eml2oai_dc
extends Crosswalk {
    private static String dirPath = null;
    private static final String XSLT_NAME_200 = "eml200toDublinCore.xsl";
    private static final String XSLT_NAME_201 = "eml201toDublinCore.xsl";
    private static final String XSLT_NAME_210 = "eml210toDublinCore.xsl";
    private static final String XSLT_NAME_211 = "eml211toDublinCore.xsl";
    private static final String SCHEMA_LOCATION = "http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd";
    private Transformer transformer = null;
    private Transformer transformer200 = null;
    private Transformer transformer201 = null;
    private Transformer transformer210 = null;
    private Transformer transformer211 = null;

    public Eml2oai_dc(Properties properties) throws OAIInternalServerError {
        super(SCHEMA_LOCATION);
        String xsltPath200 = dirPath + "/" + XSLT_NAME_200;
        String xsltPath201 = dirPath + "/" + XSLT_NAME_201;
        String xsltPath210 = dirPath + "/" + XSLT_NAME_210;
        String xsltPath211 = dirPath + "/" + XSLT_NAME_211;
        FileInputStream fileInputStream200 = null;
        FileInputStream fileInputStream201 = null;
        FileInputStream fileInputStream210 = null;
        FileInputStream fileInputStream211 = null;
        try {
            TransformerFactory tFactory200 = TransformerFactory.newInstance();
            fileInputStream200 = new FileInputStream(xsltPath200);
            StreamSource xslSource200 = new StreamSource(fileInputStream200);
            this.transformer200 = tFactory200.newTransformer(xslSource200);
            fileInputStream200.close();
            TransformerFactory tFactory201 = TransformerFactory.newInstance();
            fileInputStream201 = new FileInputStream(xsltPath201);
            StreamSource xslSource201 = new StreamSource(fileInputStream201);
            this.transformer201 = tFactory201.newTransformer(xslSource201);
            fileInputStream201.close();
            TransformerFactory tFactory210 = TransformerFactory.newInstance();
            fileInputStream210 = new FileInputStream(xsltPath210);
            StreamSource xslSource210 = new StreamSource(fileInputStream210);
            this.transformer210 = tFactory210.newTransformer(xslSource210);
            fileInputStream210.close();
            TransformerFactory tFactory211 = TransformerFactory.newInstance();
            fileInputStream211 = new FileInputStream(xsltPath211);
            StreamSource xslSource211 = new StreamSource(fileInputStream211);
            this.transformer211 = tFactory210.newTransformer(xslSource211);
            fileInputStream211.close();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream200);
                IOUtils.closeQuietly(fileInputStream201);
                IOUtils.closeQuietly(fileInputStream210);
                IOUtils.closeQuietly(fileInputStream211);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream200);
        IOUtils.closeQuietly((InputStream)fileInputStream201);
        IOUtils.closeQuietly((InputStream)fileInputStream210);
        IOUtils.closeQuietly((InputStream)fileInputStream211);
    }

    public static void setDirPath(String configDir) {
        dirPath = configDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createMetadata(Object nativeItem) throws CannotDisseminateFormatException {
        HashMap recordMap = (HashMap)nativeItem;
        try {
            String xmlRec = (String)recordMap.get("recordBytes");
            xmlRec = xmlRec.trim();
            if (xmlRec.startsWith("<?")) {
                int offset = xmlRec.indexOf("?>");
                xmlRec = xmlRec.substring(offset + 2);
            }
            if (xmlRec.contains("eml://ecoinformatics.org/eml-2.0.0")) {
                this.transformer = this.transformer200;
            } else if (xmlRec.contains("eml://ecoinformatics.org/eml-2.0.1")) {
                this.transformer = this.transformer201;
            } else if (xmlRec.contains("eml://ecoinformatics.org/eml-2.1.0")) {
                this.transformer = this.transformer210;
            } else if (xmlRec.contains("eml://ecoinformatics.org/eml-2.1.1")) {
                this.transformer = this.transformer211;
            }
            StringReader stringReader = new StringReader(xmlRec);
            StreamSource streamSource = new StreamSource(stringReader);
            StringWriter stringWriter = new StringWriter();
            Transformer transformer = this.transformer;
            synchronized (transformer) {
                this.transformer.transform(streamSource, new StreamResult(stringWriter));
            }
            return stringWriter.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CannotDisseminateFormatException(e.getMessage());
        }
    }

    public boolean isAvailableFor(Object nativeItem) {
        return true;
    }
}

