/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.plugin;

import edu.ucsb.nceas.metacat.plugin.MetacatHandlerPlugin;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetacatHandlerPluginManager {
    private static MetacatHandlerPluginManager instance = null;
    private static Log log = LogFactory.getLog(MetacatHandlerPluginManager.class);
    private List<MetacatHandlerPlugin> handlers;

    private MetacatHandlerPluginManager() {
        block5: {
            this.handlers = new ArrayList<MetacatHandlerPlugin>();
            String[] configuredHandlers = null;
            try {
                String handlersString = PropertyService.getProperty("plugin.handlers");
                if (handlersString == null || handlersString.length() <= 0) break block5;
                for (String className : configuredHandlers = handlersString.split(",")) {
                    MetacatHandlerPlugin handlerInstance = null;
                    try {
                        Class<?> handlerClass = Class.forName(className);
                        handlerInstance = (MetacatHandlerPlugin)handlerClass.newInstance();
                    }
                    catch (Exception e) {
                        log.error((Object)("Problem initializing MetacatHandlerPlugin: " + className), (Throwable)e);
                        continue;
                    }
                    this.handlers.add(handlerInstance);
                }
            }
            catch (PropertyNotFoundException e) {
                log.warn((Object)"Could not find any MetacatPluginHandlers", (Throwable)e);
                return;
            }
        }
    }

    public static MetacatHandlerPluginManager getInstance() throws ServiceException {
        if (instance == null) {
            try {
                instance = new MetacatHandlerPluginManager();
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage());
            }
        }
        return instance;
    }

    public void addHandler(MetacatHandlerPlugin plugin) {
    }

    public MetacatHandlerPlugin getHandler(String action) {
        for (MetacatHandlerPlugin plugin : this.handlers) {
            if (!plugin.handlesAction(action)) continue;
            return plugin;
        }
        return null;
    }
}

