/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.restservice;

import edu.ucsb.nceas.metacat.AuthSession;
import edu.ucsb.nceas.metacat.MetacatHandler;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.SessionService;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.metacat.util.SessionData;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dataone.mimemultipart.MultipartRequest;
import org.dataone.mimemultipart.MultipartRequestResolver;
import org.dataone.portal.PortalCertificateManager;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Group;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;

public class D1ResourceHandler {
    public static final byte GET = 1;
    public static final byte POST = 2;
    public static final byte PUT = 3;
    public static final byte DELETE = 4;
    public static final byte HEAD = 5;
    protected static int MAX_UPLOAD_SIZE = 1000000000;
    protected static final String RESOURCE_BASE_URL = "d1";
    protected static final String RESOURCE_OBJECTS = "object";
    protected static final String RESOURCE_META = "meta";
    protected static final String RESOURCE_LOG = "log";
    protected static final String RESOURCE_QUERY = "query";
    protected static final String RESOURCE_IS_AUTHORIZED = "isAuthorized";
    protected static final String RESOURCE_ACCESS_RULES = "accessRules";
    protected static final String RESOURCE_VIEWS = "views";
    protected static final String FUNCTION_NAME_INSERT = "insert";
    protected static final String FUNCTION_NAME_UPDATE = "update";
    protected ServletContext servletContext;
    protected Logger logMetacat;
    protected MetacatHandler handler;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected Hashtable<String, String[]> params;
    protected Map<String, List<String>> multipartparams;
    protected Session session;

    public D1ResourceHandler(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.servletContext = servletContext;
        this.request = request;
        this.response = response;
        this.logMetacat = Logger.getLogger(D1ResourceHandler.class);
        try {
            MAX_UPLOAD_SIZE = Integer.parseInt(PropertyService.getProperty("dataone.max_upload_size"));
        }
        catch (PropertyNotFoundException e) {
            this.logMetacat.warn((Object)"Property not found: dataone.max_upload_size");
        }
    }

    public void handle(byte httpVerb) {
        this.logMetacat = Logger.getLogger(D1ResourceHandler.class);
        try {
            this.session = PortalCertificateManager.getInstance().getSession(this.request);
            if (this.session == null) {
                SessionData sessionData = RequestUtil.getSessionData(this.request);
                if (sessionData != null && !SessionService.getInstance().getPublicSession().getUserName().equals(sessionData.getUserName())) {
                    this.session = new Session();
                    String userName = sessionData.getUserName();
                    String[] groupNames = sessionData.getGroupNames();
                    Subject userSubject = new Subject();
                    userSubject.setValue(userName);
                    this.session.setSubject(userSubject);
                    SubjectInfo subjectInfo = new SubjectInfo();
                    Person person = new Person();
                    person.setSubject(userSubject);
                    if (groupNames != null && groupNames.length > 0) {
                        for (String groupName : groupNames) {
                            Group group = new Group();
                            group.setGroupName(groupName);
                            Subject groupSubject = new Subject();
                            groupSubject.setValue(groupName);
                            group.setSubject(groupSubject);
                            subjectInfo.addGroup(group);
                            person.addIsMemberOf(groupSubject);
                        }
                    }
                    subjectInfo.addPerson(person);
                    this.session.setSubjectInfo(subjectInfo);
                }
            } else {
                Subject subject = this.session.getSubject();
                if (subject != null) {
                    String dn = subject.getValue();
                    this.logMetacat.debug((Object)("D1ReourceHandler.handle - the subject dn in the session is " + dn + " This dn will be used to look up the group information"));
                    if (dn != null) {
                        String username = null;
                        String password = null;
                        String[] groups = null;
                        try {
                            AuthSession auth = new AuthSession();
                            groups = auth.getGroups(username, password, dn);
                        }
                        catch (Exception e) {
                            this.logMetacat.warn((Object)("D1ReourceHandler.handle - we can't get group information for the user " + dn + " from the authentication interface since :"), (Throwable)e);
                        }
                        if (groups != null) {
                            SubjectInfo subjectInfo = this.session.getSubjectInfo();
                            if (subjectInfo != null) {
                                this.logMetacat.debug((Object)"D1ReourceHandler.handle - the subject information is NOT null when we try to figure out the group information.");
                                List persons = subjectInfo.getPersonList();
                                Person targetPerson = null;
                                if (persons != null) {
                                    for (Person person : persons) {
                                        if (!person.getSubject().equals((Object)subject)) continue;
                                        targetPerson = person;
                                        this.logMetacat.debug((Object)("D1ReourceHandler.handle - we find a person with the subject " + dn + " in the subject info."));
                                        break;
                                    }
                                }
                                boolean newPerson = false;
                                if (targetPerson == null) {
                                    newPerson = true;
                                    targetPerson = new Person();
                                    targetPerson.setSubject(subject);
                                }
                                for (int i = 0; i < groups.length; ++i) {
                                    this.logMetacat.debug((Object)("D1ReourceHandler.handle - create the group " + groups[i] + " for an existing subject info."));
                                    Group group = new Group();
                                    group.setGroupName(groups[i]);
                                    Subject groupSubject = new Subject();
                                    groupSubject.setValue(groups[i]);
                                    group.setSubject(groupSubject);
                                    subjectInfo.addGroup(group);
                                    targetPerson.addIsMemberOf(groupSubject);
                                }
                                if (newPerson) {
                                    subjectInfo.addPerson(targetPerson);
                                }
                            } else {
                                this.logMetacat.debug((Object)"D1ReourceHandler.handle - the subject information is NOT null when we try to figure out the group information.");
                                subjectInfo = new SubjectInfo();
                                Person person = new Person();
                                person.setSubject(subject);
                                for (int i = 0; i < groups.length; ++i) {
                                    this.logMetacat.debug((Object)("D1ReourceHandler.handle - create the group " + groups[i] + " for a new subject info."));
                                    Group group = new Group();
                                    group.setGroupName(groups[i]);
                                    Subject groupSubject = new Subject();
                                    groupSubject.setValue(groups[i]);
                                    group.setSubject(groupSubject);
                                    subjectInfo.addGroup(group);
                                    person.addIsMemberOf(groupSubject);
                                }
                                subjectInfo.addPerson(person);
                                this.session.setSubjectInfo(subjectInfo);
                            }
                        }
                    }
                }
            }
            this.params = new Hashtable();
            this.initParams();
            Timer timer = new Timer();
            this.handler = new MetacatHandler(timer);
        }
        catch (Exception e) {
            this.response.setStatus(400);
            this.printError("Incorrect resource!", this.response);
            this.logMetacat.error((Object)(e.getClass() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    protected boolean isD1Enabled() {
        return true;
    }

    protected String parseTrailing(String resource, String token) {
        String extra = null;
        if (resource.indexOf(token) != -1) {
            extra = resource.substring(resource.indexOf(token) + token.length());
            if (extra.startsWith("/")) {
                extra = extra.substring(1);
            }
            if (extra.length() == 0) {
                extra = null;
            }
        }
        return extra;
    }

    protected void collectMultipartParams() throws IOException, FileUploadException, Exception {
        File tmpDir = D1ResourceHandler.getTempDirectory();
        MultipartRequest mr = null;
        this.logMetacat.debug((Object)"Parsing rights holder info from the mime multipart entity");
        MultipartRequestResolver mrr = new MultipartRequestResolver(tmpDir.getAbsolutePath(), MAX_UPLOAD_SIZE, 0);
        mr = mrr.resolveMultipart(this.request);
        this.logMetacat.debug((Object)"Resolved the rights holder info from the mime multipart entity.");
        this.multipartparams = mr.getMultipartParameters();
    }

    protected Map<String, File> collectMultipartFiles() throws ServiceFailure, InvalidRequest {
        this.logMetacat.debug((Object)"Disassembling MIME multipart form");
        File tmpDir = D1ResourceHandler.getTempDirectory();
        this.logMetacat.debug((Object)("temp dir: " + tmpDir.getAbsolutePath()));
        MultipartRequestResolver mrr = new MultipartRequestResolver(tmpDir.getAbsolutePath(), MAX_UPLOAD_SIZE, 0);
        MultipartRequest mr = null;
        try {
            mr = mrr.resolveMultipart(this.request);
        }
        catch (Exception e) {
            throw new ServiceFailure("1202", "Could not resolve multipart files: " + e.getMessage());
        }
        this.logMetacat.debug((Object)"resolved multipart request");
        Map files = mr.getMultipartFiles();
        if (files == null) {
            throw new ServiceFailure("1202", "no multipart files found");
        }
        this.logMetacat.debug((Object)"got multipart files");
        if (files.keySet() == null) {
            this.logMetacat.error((Object)"No file keys in MMP request.");
            throw new ServiceFailure("1202", "No file keys found in MMP.");
        }
        this.multipartparams = mr.getMultipartParameters();
        if (this.logMetacat.isDebugEnabled()) {
            String key;
            Iterator<Object> it = files.keySet().iterator();
            this.logMetacat.debug((Object)"iterating through files");
            while (it.hasNext()) {
                key = (String)it.next();
                this.logMetacat.debug((Object)("files key: " + key));
                this.logMetacat.debug((Object)("files value: " + files.get(key)));
            }
            it = this.multipartparams.keySet().iterator();
            this.logMetacat.debug((Object)"iterating through multipartparams");
            while (it.hasNext()) {
                key = (String)it.next();
                this.logMetacat.debug((Object)("multipartparams key: " + key));
                this.logMetacat.debug((Object)("multipartparams value: " + this.multipartparams.get(key)));
            }
            it = this.params.keySet().iterator();
            this.logMetacat.debug((Object)"iterating through params");
            while (it.hasNext()) {
                key = (String)it.next();
                this.logMetacat.debug((Object)("param key: " + key));
                this.logMetacat.debug((Object)("param value: " + this.params.get(key)));
            }
            this.logMetacat.debug((Object)"done iterating the request...");
        }
        return files;
    }

    protected void initParams() {
        String name = null;
        String[] value = null;
        Enumeration paramlist = this.request.getParameterNames();
        while (paramlist.hasMoreElements()) {
            name = (String)paramlist.nextElement();
            value = this.request.getParameterValues(name);
            this.params.put(name, value);
        }
    }

    protected void initMultipartParams() throws Exception {
        this.logMetacat.debug((Object)"Disassembling MIME multipart form");
        File tmpDir = D1ResourceHandler.getTempDirectory();
        this.logMetacat.debug((Object)("temp dir: " + tmpDir.getAbsolutePath()));
        MultipartRequestResolver mrr = new MultipartRequestResolver(tmpDir.getAbsolutePath(), MAX_UPLOAD_SIZE, 0);
        MultipartRequest mr = mrr.resolveMultipart(this.request);
        this.multipartparams = mr.getMultipartParameters();
    }

    protected static String[] findBoundaryString(InputStream is) throws IOException {
        String[] endResult = new String[2];
        String boundary = "";
        String searchString = "boundary=";
        byte[] b = new byte[1024];
        int numbytes = is.read(b, 0, 1024);
        while (numbytes != -1) {
            String s = new String(b, 0, numbytes);
            int searchStringIndex = s.indexOf(searchString);
            if (s.indexOf("\"", searchStringIndex + searchString.length() + 1) == -1) {
                boundary = s.substring(searchStringIndex + searchString.length() + 1, s.length());
                continue;
            }
            if (!boundary.startsWith("--")) {
                boundary = s.substring(searchStringIndex + searchString.length() + 1, s.indexOf("\"", searchStringIndex + searchString.length() + 1));
                endResult[0] = boundary = "--" + boundary;
                endResult[1] = s.substring(s.indexOf("\"", searchStringIndex + searchString.length() + 1) + 1, s.length());
                break;
            }
            searchString = "\"";
            searchStringIndex = s.indexOf(searchString);
            boundary = boundary + s.substring(0, searchStringIndex);
            endResult[0] = boundary = "--" + boundary;
            endResult[1] = s.substring(s.indexOf("\"", searchStringIndex + searchString.length() + 1) + 1, s.length());
            break;
        }
        return endResult;
    }

    protected static File getTempDirectory() {
        File tmpDir = null;
        Logger logMetacat = Logger.getLogger(D1ResourceHandler.class);
        try {
            tmpDir = new File(PropertyService.getProperty("application.tempDir"));
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)"D1ResourceHandler.writeMMPPartstoFiles: application.tmpDir not found.  Using /tmp instead.");
            tmpDir = new File("/tmp");
        }
        return tmpDir;
    }

    protected void printError(String message, HttpServletResponse response) {
        try {
            this.logMetacat.error((Object)("D1ResourceHandler: Printing error to servlet response: " + message));
            PrintWriter out = response.getWriter();
            response.setContentType("text/xml");
            out.println("<?xml version=\"1.0\"?>");
            out.println("<error>");
            out.println(message);
            out.println("</error>");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void serializeException(BaseException e, OutputStream out) {
        this.response.setContentType("text/xml");
        this.response.setStatus(e.getCode());
        this.logMetacat.error((Object)("D1ResourceHandler: Serializing exception with code " + e.getCode() + ": " + e.getMessage()), (Throwable)e);
        try {
            IOUtils.write((String)e.serialize(0), (OutputStream)out);
        }
        catch (IOException e1) {
            this.logMetacat.error((Object)("Error writing exception to stream. " + e1.getMessage()));
        }
    }

    public static String decode(String s) {
        String result = null;
        if (s != null) {
            try {
                result = URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                result = URLDecoder.decode(s);
            }
            System.out.println("After decoded: " + result);
        }
        return result;
    }
}

