/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.skin.VisibilityModifier;

public class Member {
    private String display;
    private final boolean staticModifier;
    private final boolean abstractModifier;
    private final VisibilityModifier visibilityModifier;

    public Member(String string, boolean bl) {
        String string2 = string.toLowerCase();
        this.staticModifier = string2.contains("{static}") || string2.contains("{classifier}");
        this.abstractModifier = string2.contains("{abstract}");
        String string3 = string.replaceAll("(?i)\\{(static|classifier|abstract)\\}", "").trim();
        if (VisibilityModifier.isVisibilityCharacter(string3.charAt(0))) {
            this.visibilityModifier = VisibilityModifier.getVisibilityModifier(string.charAt(0), !bl);
            this.display = string3.substring(1).trim();
        } else {
            this.display = string3;
            this.visibilityModifier = null;
        }
    }

    public String getDisplay(boolean bl) {
        if (bl) {
            return this.getDisplayWithVisibilityChar();
        }
        return this.getDisplayWithoutVisibilityChar();
    }

    public String getDisplayWithoutVisibilityChar() {
        assert (!VisibilityModifier.isVisibilityCharacter(this.display.charAt(0)));
        return this.display;
    }

    public String getDisplayWithVisibilityChar() {
        if (this.isPrivate()) {
            return "-" + this.display;
        }
        if (this.isPublic()) {
            return "+" + this.display;
        }
        if (this.isPackagePrivate()) {
            return "~" + this.display;
        }
        if (this.isProtected()) {
            return "#" + this.display;
        }
        return this.display;
    }

    public boolean equals(Object object) {
        Member member = (Member)object;
        return this.display.equals(member.display);
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public final boolean isStatic() {
        return this.staticModifier;
    }

    public final boolean isAbstract() {
        return this.abstractModifier;
    }

    public final boolean isVisibilityModified() {
        return this.visibilityModifier != null;
    }

    public final boolean isPrivate() {
        return this.visibilityModifier == VisibilityModifier.PRIVATE_FIELD || this.visibilityModifier == VisibilityModifier.PRIVATE_METHOD;
    }

    public final boolean isProtected() {
        return this.visibilityModifier == VisibilityModifier.PROTECTED_FIELD || this.visibilityModifier == VisibilityModifier.PROTECTED_METHOD;
    }

    public final boolean isPublic() {
        return this.visibilityModifier == VisibilityModifier.PUBLIC_FIELD || this.visibilityModifier == VisibilityModifier.PUBLIC_METHOD;
    }

    public final boolean isPackagePrivate() {
        return this.visibilityModifier == VisibilityModifier.PACKAGE_PRIVATE_FIELD || this.visibilityModifier == VisibilityModifier.PACKAGE_PRIVATE_METHOD;
    }

    public final VisibilityModifier getVisibilityModifier() {
        return this.visibilityModifier;
    }
}

