/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eggs;

import java.math.BigInteger;

public class EggUtils {
    public static String fromByteArrays(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            String string = Integer.toHexString(by & 0xFF);
            if (string.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static byte[] toByteArrays(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
        }
        return byArray;
    }

    public static BigInteger fromSecretSentence(String string) {
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger bigInteger2 = BigInteger.valueOf(26L);
        string = string.replace('\u00e9', 'e');
        string = string.replace('\u00ea', 'e');
        for (char c : string.toCharArray()) {
            int n = EggUtils.convertChar(c);
            if (n == -1) continue;
            bigInteger = bigInteger.multiply(bigInteger2);
            bigInteger = bigInteger.add(BigInteger.valueOf(n));
        }
        return bigInteger;
    }

    private static int convertChar(char c) {
        if ((c = Character.toLowerCase(c)) >= 'a' && c <= 'z') {
            return c - 97;
        }
        return -1;
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        int n = 0;
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[n++]);
            if (n != byArray2.length) continue;
            n = 0;
        }
        return byArray3;
    }
}

