/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.Iterator;
import java.util.logging.Logger;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FilterVisitor2;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;
import org.geotools.util.logging.Logging;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.IncludeFilter;

public class WFSBBoxFilterVisitor
implements FilterVisitor2 {
    private static final Logger logger = Logging.getLogger((String)"org.geotools.filter");
    Envelope maxbbox;

    public WFSBBoxFilterVisitor() {
        this(null);
    }

    public WFSBBoxFilterVisitor(Envelope fsd) {
        this.maxbbox = fsd;
    }

    public void visit(Filter filter) {
        if (Filter.NONE == filter) {
            return;
        }
        switch (filter.getFilterType()) {
            case 19: {
                this.visit((BetweenFilter)filter);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                this.visit((BetweenFilter)filter);
                break;
            }
            case 22: {
                this.visit((BetweenFilter)filter);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 24: {
                this.visit((GeometryFilter)filter);
                break;
            }
            case 20: {
                this.visit((LikeFilter)filter);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.visit((LogicFilter)filter);
                break;
            }
            case 21: {
                this.visit((NullFilter)filter);
                break;
            }
        }
    }

    public void visit(BetweenFilter filter) {
        if (filter != null) {
            if (filter.getLeftValue() != null) {
                filter.getLeftValue().accept((FilterVisitor)this);
            }
            if (filter.getRightValue() != null) {
                filter.getRightValue().accept((FilterVisitor)this);
            }
            if (filter.getMiddleValue() != null) {
                filter.getMiddleValue().accept((FilterVisitor)this);
            }
        }
    }

    public void visit(CompareFilter filter) {
        if (filter != null) {
            if (filter.getLeftValue() != null) {
                filter.getLeftValue().accept((FilterVisitor)this);
            }
            if (filter.getRightValue() != null) {
                filter.getRightValue().accept((FilterVisitor)this);
            }
        }
    }

    public void visit(GeometryFilter filter) {
        if (filter != null) {
            Expression leftGeometry = filter.getLeftGeometry();
            Expression rightGeometry = filter.getRightGeometry();
            switch (filter.getFilterType()) {
                case 4: {
                    Envelope bbox = null;
                    LiteralExpression le = null;
                    if (leftGeometry != null && leftGeometry.getType() == 104) {
                        le = (LiteralExpression)leftGeometry;
                        if (le != null && le.getLiteral() != null && le.getLiteral() instanceof Geometry) {
                            bbox = ((Geometry)le.getLiteral()).getEnvelopeInternal();
                        }
                    } else if (rightGeometry != null && rightGeometry.getType() == 104 && (le = (LiteralExpression)rightGeometry) != null && le.getLiteral() != null && le.getLiteral() instanceof Geometry) {
                        Geometry g = (Geometry)le.getLiteral();
                        bbox = g.getEnvelopeInternal();
                    }
                    if (bbox != null) {
                        boolean changed = false;
                        double minx = bbox.getMinX();
                        double miny = bbox.getMinY();
                        double maxx = bbox.getMaxX();
                        double maxy = bbox.getMaxY();
                        if (this.maxbbox != null) {
                            if (minx < this.maxbbox.getMinX()) {
                                minx = this.maxbbox.getMinX();
                                changed = true;
                            }
                            if (maxx > this.maxbbox.getMaxX()) {
                                maxx = this.maxbbox.getMaxX();
                                changed = true;
                            }
                            if (miny < this.maxbbox.getMinY()) {
                                miny = this.maxbbox.getMinY();
                                changed = true;
                            }
                            if (maxy > this.maxbbox.getMaxY()) {
                                maxy = this.maxbbox.getMaxY();
                                changed = true;
                            }
                        }
                        if (changed) {
                            Envelope tmp = new Envelope(minx, maxx, miny, maxy);
                            try {
                                le.setLiteral((Object)new GeometryFactory().toGeometry(tmp));
                            }
                            catch (IllegalFilterException e) {
                                logger.warning(e.toString());
                            }
                        }
                    }
                    return;
                }
            }
            if (leftGeometry != null) {
                leftGeometry.accept((FilterVisitor)this);
            }
            if (rightGeometry != null) {
                rightGeometry.accept((FilterVisitor)this);
            }
        }
    }

    public void visit(LikeFilter filter) {
        if (filter != null && filter.getValue() != null) {
            filter.getValue().accept((FilterVisitor)this);
        }
    }

    public void visit(LogicFilter filter) {
        if (filter != null) {
            Iterator i = filter.getFilterIterator();
            while (i.hasNext()) {
                org.opengis.filter.Filter child = (org.opengis.filter.Filter)i.next();
                if (child instanceof Filter) {
                    Filter tmp = (Filter)child;
                    tmp.accept((FilterVisitor)this);
                    continue;
                }
                if (child instanceof IncludeFilter) {
                    IncludeFilter include = (IncludeFilter)child;
                    this.visit(include);
                    continue;
                }
                if (child instanceof ExcludeFilter) {
                    ExcludeFilter exclude = (ExcludeFilter)child;
                    this.visit(exclude);
                    continue;
                }
                logger.warning("Unnown filter:" + child);
            }
        }
    }

    public void visit(NullFilter filter) {
        if (filter != null && filter.getNullCheckValue() != null) {
            filter.getNullCheckValue().accept((FilterVisitor)this);
        }
    }

    public void visit(FidFilter filter) {
    }

    public void visit(AttributeExpression expression) {
    }

    public void visit(Expression expression) {
    }

    public void visit(LiteralExpression expression) {
    }

    public void visit(MathExpression expression) {
    }

    public void visit(FunctionExpression expression) {
    }

    public void visit(IncludeFilter filter) {
    }

    public void visit(ExcludeFilter filter) {
    }
}

