/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.task.IndexTask;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.parser.IDocumentDeleteSubprocessor;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.solrhttp.HTTPService;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementAdd;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.SAXException;

public class SolrIndexService {
    private static Logger log = Logger.getLogger(SolrIndexService.class);
    private static final String OUTPUT_ENCODING = "UTF-8";
    private List<IDocumentSubprocessor> subprocessors = null;
    private List<IDocumentDeleteSubprocessor> deleteSubprocessors = null;
    private IDocumentSubprocessor systemMetadataProcessor = null;
    @Autowired
    private HTTPService httpService = null;
    @Autowired
    private String solrIndexUri = null;
    @Autowired
    private String solrQueryUri = null;
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();

    public void removeFromIndex(String identifier) throws Exception {
        HashMap<String, SolrDoc> docs = new HashMap<String, SolrDoc>();
        for (IDocumentDeleteSubprocessor deleteSubprocessor : this.getDeleteSubprocessors()) {
            docs.putAll(deleteSubprocessor.processDocForDelete(identifier, docs));
        }
        ArrayList<SolrDoc> docsToUpdate = new ArrayList<SolrDoc>();
        ArrayList<String> idsToIndex = new ArrayList<String>();
        for (String idToUpdate : docs.keySet()) {
            if (docs.get(idToUpdate) != null) {
                docsToUpdate.add((SolrDoc)docs.get(idToUpdate));
                continue;
            }
            idsToIndex.add(idToUpdate);
        }
        SolrElementAdd addCommand = this.getAddCommand(docsToUpdate);
        this.sendCommand(addCommand);
        this.deleteDocFromIndex(identifier);
        for (String idToIndex : idsToIndex) {
            Identifier pid = new Identifier();
            pid.setValue(idToIndex);
            SystemMetadata sysMeta = (SystemMetadata)HazelcastClientFactory.getSystemMetadataMap().get((Object)pid);
            if (!SolrDoc.visibleInIndex(sysMeta)) continue;
            String objectPath = (String)HazelcastClientFactory.getObjectPathMap().get((Object)pid);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            TypeMarshaller.marshalTypeToOutputStream((Object)sysMeta, (OutputStream)os);
            this.insertIntoIndex(idToIndex, new ByteArrayInputStream(os.toByteArray()), objectPath);
        }
    }

    public void removeFromIndex(List<IndexTask> tasks) throws Exception {
        for (IndexTask indexTask : tasks) {
            String identifier = indexTask.getPid();
            try {
                this.removeFromIndex(identifier);
            }
            catch (Exception e) {
                log.error((Object)("Unable to remove from index: " + identifier), (Throwable)e);
            }
        }
    }

    public SolrElementAdd processObject(String id, InputStream systemMetaDataStream, String objectPath) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, EncoderException {
        long processObjStart = System.currentTimeMillis();
        Map<String, SolrDoc> docs = new HashMap<String, SolrDoc>();
        try {
            long sysmetaProcStart = System.currentTimeMillis();
            docs = this.systemMetadataProcessor.processDocument(id, docs, systemMetaDataStream);
            this.perfLog.log(this.systemMetadataProcessor.getClass().getSimpleName() + ".processDocument() processing sysmeta for id " + id, System.currentTimeMillis() - sysmetaProcStart);
        }
        catch (Exception e) {
            log.error((Object)("Error parsing system metadata for id: " + id + e.getMessage()));
            e.printStackTrace();
        }
        if (objectPath != null) {
            String formatId = docs.get(id).getFirstFieldValue("formatId");
            int i = 1;
            for (IDocumentSubprocessor subprocessor : this.getSubprocessors()) {
                if (subprocessor.canProcess(formatId)) {
                    try {
                        long startFechingFile = System.currentTimeMillis();
                        FileInputStream objectStream = new FileInputStream(objectPath);
                        this.perfLog.log("Loop " + i + ". SolrIndexService.processObject() fetch file for id " + id, System.currentTimeMillis() - startFechingFile);
                        if (!objectStream.getFD().valid()) {
                            log.error((Object)("Could not load OBJECT file for ID,Path=" + id + ", " + objectPath));
                        } else {
                            long scimetaProcStart = System.currentTimeMillis();
                            docs = subprocessor.processDocument(id, docs, objectStream);
                            this.perfLog.log(String.format("Loop %d. SolrIndexService.processObject() %s.processDocument() total subprocessor processing time for id %s with format: %s", i, subprocessor.getClass().getSimpleName(), id, formatId), System.currentTimeMillis() - scimetaProcStart);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)String.format("The subprocessor %s can't process the id %s since %s. However, the index still can be achieved without this part of information provided by the processor.", subprocessor.getClass().getName(), id, e.getMessage()), (Throwable)e);
                    }
                }
                ++i;
            }
        } else {
            log.warn((Object)("The optional objectPath for pid " + id + " is null, so skipping processing with content subprocessors"));
        }
        long mergeProcStart = System.currentTimeMillis();
        HashMap<String, SolrDoc> mergedDocs = new HashMap<String, SolrDoc>();
        int index = 1;
        for (SolrDoc mergeDoc : docs.values()) {
            int innerIndex = 1;
            for (IDocumentSubprocessor subprocessor : this.getSubprocessors()) {
                long before = System.currentTimeMillis();
                mergeDoc = subprocessor.mergeWithIndexedDocument(mergeDoc);
                this.perfLog.log("Outer loop " + index + ", inner loop" + innerIndex + " SolrIndexService.processObject() merging docs for id " + id, System.currentTimeMillis() - before);
                ++innerIndex;
            }
            mergedDocs.put(mergeDoc.getIdentifier(), mergeDoc);
            ++index;
        }
        this.perfLog.log("Total - SolrIndexService.processObject() merging docs for id " + id, System.currentTimeMillis() - mergeProcStart);
        SolrElementAdd addCommand = this.getAddCommand(new ArrayList<SolrDoc>(mergedDocs.values()));
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            addCommand.serialize((OutputStream)baos, OUTPUT_ENCODING);
            log.trace((Object)baos.toString());
        }
        this.perfLog.log("SolrIndexService.processObject() total processing time for id " + id, System.currentTimeMillis() - processObjStart);
        return addCommand;
    }

    public void insertIntoIndex(String id, InputStream systemMetaDataStream, String objectPath) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, EncoderException {
        SolrElementAdd addCommand = this.processObject(id, systemMetaDataStream, objectPath);
        long solrAddStart = System.currentTimeMillis();
        this.sendCommand(addCommand);
        this.perfLog.log("SolrIndexService.sendCommand(SolrElementAdd) adding docs into Solr index for id " + id, System.currentTimeMillis() - solrAddStart);
    }

    public void insertIntoIndex(List<IndexTask> tasks) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, EncoderException {
        SolrElementAdd batchAddCommand = new SolrElementAdd();
        for (IndexTask task : tasks) {
            ByteArrayInputStream smdStream = new ByteArrayInputStream(task.getSysMetadata().getBytes());
            SolrElementAdd addCommand = this.processObject(task.getPid(), smdStream, task.getObjectPath());
            batchAddCommand = this.mergeAddCommands(batchAddCommand, addCommand);
        }
        long solrAddStart = System.currentTimeMillis();
        this.sendCommand(batchAddCommand);
        this.perfLog.log("SolrIndexService.sendCommand(SolrElementAdd) batch adding (" + tasks.size() + ") docs into Solr index", System.currentTimeMillis() - solrAddStart);
    }

    private SolrElementAdd mergeAddCommands(SolrElementAdd original, SolrElementAdd addition) {
        if (original.getDocList() == null) {
            original.setDocList(new ArrayList<SolrDoc>());
        }
        if (addition.getDocList() == null) {
            addition.setDocList(new ArrayList<SolrDoc>());
        }
        original.getDocList().addAll(addition.getDocList());
        return original;
    }

    private void sendCommand(SolrElementAdd addCommand) throws IOException {
        HTTPService service = this.getHttpService();
        service.sendUpdate(this.getSolrindexUri(), addCommand, OUTPUT_ENCODING);
    }

    private SolrElementAdd getAddCommand(List<SolrDoc> docs) {
        return new SolrElementAdd(docs);
    }

    private void deleteDocFromIndex(String identifier) {
        this.httpService.sendSolrDelete(identifier);
    }

    public String getSolrindexUri() {
        return this.solrIndexUri;
    }

    public void setSolrIndexUri(String solrindexUri) {
        this.solrIndexUri = solrindexUri;
    }

    public void setHttpService(HTTPService service) {
        this.httpService = service;
    }

    public HTTPService getHttpService() {
        return this.httpService;
    }

    public String getSolrQueryUri() {
        return this.solrQueryUri;
    }

    public void setSolrQueryUri(String solrQueryUri) {
        this.solrQueryUri = solrQueryUri;
    }

    public List<IDocumentSubprocessor> getSubprocessors() {
        if (this.subprocessors == null) {
            this.subprocessors = new ArrayList<IDocumentSubprocessor>();
        }
        return this.subprocessors;
    }

    public List<IDocumentDeleteSubprocessor> getDeleteSubprocessors() {
        if (this.deleteSubprocessors == null) {
            this.deleteSubprocessors = new ArrayList<IDocumentDeleteSubprocessor>();
        }
        return this.deleteSubprocessors;
    }

    public void setSubprocessors(List<IDocumentSubprocessor> subprocessorList) {
        this.subprocessors = subprocessorList;
    }

    public void setDeleteSubprocessors(List<IDocumentDeleteSubprocessor> deleteSubprocessorList) {
        this.deleteSubprocessors = deleteSubprocessorList;
    }

    public IDocumentSubprocessor getSystemMetadataProcessor() {
        return this.systemMetadataProcessor;
    }

    public void setSystemMetadataProcessor(IDocumentSubprocessor systemMetadataProcessor) {
        this.systemMetadataProcessor = systemMetadataProcessor;
    }
}

