/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.IndexingQueue;
import edu.ucsb.nceas.metacat.IndexingQueueObject;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class IndexingTask
extends Thread {
    private Log logMetacat = LogFactory.getLog(IndexingTask.class);
    protected static final long MAXIMUMINDEXDELAY;
    protected boolean metacatRunning = true;

    IndexingTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.metacatRunning) {
            IndexingQueueObject indexQueueObject = IndexingQueue.getInstance().getNext();
            if (indexQueueObject == null) continue;
            if (!IndexingQueue.getInstance().currentDocidsBeingIndexed.contains(indexQueueObject.getDocid())) {
                try {
                    IndexingQueue.getInstance().currentDocidsBeingIndexed.add(indexQueueObject.getDocid());
                    String docid = indexQueueObject.getDocid() + "." + indexQueueObject.getRev();
                    if (this.checkDocumentTable(docid, "xml_documents")) {
                        this.logMetacat.warn((Object)("Calling buildIndex for " + docid));
                        DocumentImpl doc = new DocumentImpl(docid, false);
                        doc.buildIndex();
                        this.logMetacat.warn((Object)("finish building index for doicd " + docid));
                        continue;
                    }
                    this.logMetacat.warn((Object)("Couldn't find the docid:" + docid + " in xml_documents table"));
                    IndexingTask.sleep(MAXIMUMINDEXDELAY);
                    throw new Exception("Couldn't find the docid:" + docid + " in xml_documents table");
                }
                catch (Exception e) {
                    this.logMetacat.warn((Object)("Exception: " + e));
                    e.printStackTrace();
                    if (indexQueueObject.getCount() < 25) {
                        indexQueueObject.setCount(indexQueueObject.getCount() + 1);
                        IndexingQueue.getInstance().add(indexQueueObject);
                        continue;
                    }
                    this.logMetacat.fatal((Object)("Docid " + indexQueueObject.getDocid() + " has been inserted to IndexingQueue more than 25 times. Not adding the docid to the queue again."));
                    continue;
                }
                finally {
                    IndexingQueue.getInstance().currentDocidsBeingIndexed.remove(indexQueueObject.getDocid());
                    continue;
                }
            }
            indexQueueObject.setCount(indexQueueObject.getCount() + 1);
            IndexingQueue.getInstance().add(indexQueueObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDocumentTable(String docid, String tablename) throws Exception {
        DBConnection dbConn = null;
        int serialNumber = -1;
        boolean inxmldoc = false;
        String revision = docid.substring(docid.lastIndexOf(".") + 1, docid.length());
        int rev = Integer.parseInt(revision);
        docid = docid.substring(0, docid.lastIndexOf("."));
        this.logMetacat.info((Object)("Checking if document exists in xml_documents: docid is " + docid + " and revision is " + revision));
        try {
            dbConn = DBConnectionPool.getDBConnection("DBSAXHandler.checkDocumentTable");
            serialNumber = dbConn.getCheckOutSerialNumber();
            String xmlDocumentsCheck = "SELECT distinct docid FROM " + tablename + " WHERE docid = ?  AND rev = ?";
            PreparedStatement xmlDocCheck = dbConn.prepareStatement(xmlDocumentsCheck);
            xmlDocCheck.setString(1, docid);
            xmlDocCheck.setInt(2, rev);
            dbConn.increaseUsageCount(1);
            xmlDocCheck.execute();
            ResultSet doccheckRS = xmlDocCheck.getResultSet();
            boolean tableHasRows = doccheckRS.next();
            if (tableHasRows) {
                inxmldoc = true;
            }
            doccheckRS.close();
            xmlDocCheck.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return inxmldoc;
    }

    static {
        long maxIndexDelay = 0L;
        try {
            maxIndexDelay = Integer.parseInt(PropertyService.getProperty("database.maximumIndexDelay"));
        }
        catch (PropertyNotFoundException pnfe) {
            System.err.println("Could not get property in static block: " + pnfe.getMessage());
        }
        MAXIMUMINDEXDELAY = maxIndexDelay;
    }
}

