/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.QueryTerm;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryGroup {
    private String operator = null;
    private Vector children = null;
    private int countPercentageSearchItem = 0;
    private Vector queryTermsWithSameValue = null;
    private Vector queryTermsInPathIndex = null;
    private Vector<QueryTerm> queryTerms = null;
    private Vector queryGroupsChildren = null;
    private static Log logMetacat = LogFactory.getLog(QueryGroup.class);
    public static String UNION = "UNION";
    public static String INTERSECT = "INTERSECT";

    public QueryGroup(String operator) {
        this.operator = operator;
        this.children = new Vector();
        this.queryTermsWithSameValue = new Vector();
        this.queryTermsInPathIndex = new Vector();
        this.queryTerms = new Vector();
        this.queryGroupsChildren = new Vector();
    }

    public void addChild(QueryGroup qgroup) {
        this.children.add(qgroup);
        this.queryGroupsChildren.add(qgroup);
    }

    public void addChild(QueryTerm qterm) {
        this.children.add(qterm);
        this.handleNewQueryTerms(qterm);
    }

    private Enumeration getChildren() {
        return this.children.elements();
    }

    public int getPercentageSymbolCount() {
        return this.countPercentageSearchItem;
    }

    public String printSQL(boolean useXMLIndex, List<Object> parameterValues) {
        int count;
        int i;
        StringBuffer self = new StringBuffer();
        StringBuffer queryString = new StringBuffer();
        boolean first = true;
        if (!this.queryTermsWithSameValue.isEmpty() || !this.queryTermsInPathIndex.isEmpty()) {
            ArrayList<Object> groupValues = new ArrayList<Object>();
            String pathIndexQueryString = this.printSQLStringInPathIndex(groupValues);
            parameterValues.addAll(groupValues);
            queryString.append(pathIndexQueryString);
            if (queryString != null) {
                first = false;
            }
        }
        for (i = 0; i < this.queryGroupsChildren.size(); ++i) {
            ArrayList<Object> childrenValues = new ArrayList<Object>();
            QueryGroup qg = (QueryGroup)this.queryGroupsChildren.elementAt(i);
            String queryGroupSQL = qg.printSQL(useXMLIndex, childrenValues);
            logMetacat.info((Object)("In QueryGroup.printSQL.. found a QueryGroup: " + queryGroupSQL));
            if (first) {
                first = false;
            } else if (!queryString.toString().equals("") && queryGroupSQL != null && !queryGroupSQL.equals("")) {
                queryString.append(" " + this.operator + " ");
            }
            queryString.append(queryGroupSQL);
            parameterValues.addAll(childrenValues);
            count = qg.getPercentageSymbolCount();
            this.countPercentageSearchItem += count;
        }
        for (i = 0; i < this.queryTerms.size(); ++i) {
            ArrayList<Object> termValues = new ArrayList<Object>();
            QueryTerm qt = this.queryTerms.elementAt(i);
            String termQueryString = qt.printSQL(useXMLIndex, termValues);
            logMetacat.info((Object)("In QueryGroup.printSQL.. found a QueryGroup: " + termQueryString));
            if (qt.getSearchMode().equals("contains") && qt.getValue().equals("%")) continue;
            if (first) {
                first = false;
            } else if (!queryString.toString().equals("")) {
                queryString.append(" " + this.operator + " ");
            }
            queryString.append(termQueryString);
            parameterValues.addAll(termValues);
            count = qt.getPercentageSymbolCount();
            this.countPercentageSearchItem += count;
        }
        if (!queryString.toString().equals("")) {
            self.append("(");
            self.append(queryString.toString());
            self.append(")");
        }
        logMetacat.info((Object)("In QueryGroup.printSQL.. final query returned is: " + self.toString()));
        return self.toString();
    }

    private String printSQLStringInPathIndex(List<Object> parameterValues) {
        String sql = "";
        String value = "";
        StringBuffer sqlBuff = new StringBuffer();
        int index = 0;
        if (this.queryTermsWithSameValue != null && this.queryTermsInPathIndex != null) {
            sqlBuff.append("SELECT DISTINCT docid FROM xml_path_index WHERE ");
            if (!this.queryTermsWithSameValue.isEmpty()) {
                boolean firstVector = true;
                for (int j = 0; j < this.queryTermsWithSameValue.size(); ++j) {
                    Vector queryTermVector = (Vector)this.queryTermsWithSameValue.elementAt(j);
                    QueryTerm term1 = (QueryTerm)queryTermVector.elementAt(0);
                    value = term1.getValue();
                    boolean first = true;
                    if (firstVector) {
                        firstVector = false;
                    } else {
                        sqlBuff.append(" OR ");
                    }
                    sqlBuff.append(" (");
                    ArrayList<Object> searchValues = new ArrayList<Object>();
                    String searchTermSQL = term1.printSearchExprSQL(searchValues);
                    sqlBuff.append(searchTermSQL);
                    parameterValues.addAll(searchValues);
                    sqlBuff.append("AND path IN ( ");
                    for (int i = 0; i < queryTermVector.size(); ++i) {
                        QueryTerm term = (QueryTerm)queryTermVector.elementAt(i);
                        value = term.getValue();
                        String path = term.getPathExpression();
                        if (path == null || path.equals("")) continue;
                        if (first) {
                            first = false;
                            sqlBuff.append("?");
                            parameterValues.add(path);
                        } else {
                            sqlBuff.append(", ?");
                            parameterValues.add(path);
                        }
                        ++index;
                        if (value == null || !value.equals("%") && !value.equals("%%%")) continue;
                        ++this.countPercentageSearchItem;
                    }
                    sqlBuff.append(" ))");
                }
            }
            if (!this.queryTermsInPathIndex.isEmpty()) {
                for (int j = 0; j < this.queryTermsInPathIndex.size(); ++j) {
                    QueryTerm term = (QueryTerm)this.queryTermsInPathIndex.elementAt(j);
                    if (term == null) continue;
                    term.setInUnionGroup(true);
                    if (index > 0) {
                        sqlBuff.append(" OR ");
                    }
                    sqlBuff.append("(");
                    ArrayList<Object> termParameterValues = new ArrayList<Object>();
                    String termSQL = term.printSQL(true, termParameterValues);
                    sqlBuff.append(termSQL);
                    sqlBuff.append(")");
                    parameterValues.addAll(termParameterValues);
                    ++index;
                }
            }
        }
        if (index > 0) {
            sql = sqlBuff.toString();
        }
        return sql;
    }

    public String toString() {
        StringBuffer self = new StringBuffer();
        self.append("  (Query group operator=" + this.operator + "\n");
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            Object qobject = en.nextElement();
            self.append(qobject);
        }
        self.append("  )\n");
        return self.toString();
    }

    private void handleNewQueryTerms(QueryTerm newTerm) {
        if (newTerm != null) {
            try {
                if (this.operator != null && this.operator.equalsIgnoreCase(UNION) && SystemUtil.getPathsForIndexing().contains(newTerm.getPathExpression())) {
                    int i;
                    for (i = 0; i < this.queryTermsInPathIndex.size(); ++i) {
                        QueryTerm term = (QueryTerm)this.queryTermsInPathIndex.elementAt(i);
                        if (term == null || !term.hasSameSearchValue(newTerm)) continue;
                        Vector<QueryTerm> newSameValueVector = new Vector<QueryTerm>();
                        newSameValueVector.add(term);
                        newSameValueVector.addElement(newTerm);
                        this.queryTermsWithSameValue.add(newSameValueVector);
                        this.queryTermsInPathIndex.remove(i);
                        return;
                    }
                    for (i = 0; i < this.queryTermsWithSameValue.size(); ++i) {
                        Vector sameValueVec = (Vector)this.queryTermsWithSameValue.elementAt(i);
                        QueryTerm term = (QueryTerm)sameValueVec.elementAt(0);
                        if (term == null || !term.hasSameSearchValue(newTerm)) continue;
                        sameValueVec.add(newTerm);
                        return;
                    }
                    this.queryTermsInPathIndex.add(newTerm);
                    return;
                }
            }
            catch (MetacatUtilException ue) {
                logMetacat.warn((Object)("Could not get index paths: " + ue.getMessage()));
            }
            this.queryTerms.add(newTerm);
        }
    }
}

