/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.MetacatAdmin;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.ServiceService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.UtilException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BackupAdmin
extends MetacatAdmin {
    private static BackupAdmin Admin = null;
    private static Log logMetacat = LogFactory.getLog(BackupAdmin.class);
    public static final String HIDDEN_EXISTS_POPULATED = "hiddenExistsPopulated";
    public static final String HIDDEN_EXISTS_UNPOPULATED = "hiddenExistsUnPopulated";
    public static final String BASE_EXISTS_ONLY = "baseExistsOnly";
    public static final String UNKNOWN = "unknown";

    private BackupAdmin() {
    }

    public static BackupAdmin getInstance() {
        if (Admin == null) {
            Admin = new BackupAdmin();
        }
        return Admin;
    }

    public void configureBackup(HttpServletRequest request, HttpServletResponse response) throws AdminException {
        String processForm = request.getParameter("processForm");
        String formErrors = (String)request.getAttribute("formErrors");
        if (processForm == null || !processForm.equals("true") || formErrors != null) {
            try {
                String backupBaseDir = SystemUtil.discoverExternalDir();
                logMetacat.debug((Object)("BackupAdmin.configureBackup - Backup dir discovered as: " + backupBaseDir));
                String backupDirStatus = this.getBackupDirStatus(backupBaseDir);
                logMetacat.debug((Object)("BackupAdmin.configureBackup - Status of discovered backup dir: " + backupDirStatus));
                if (backupBaseDir != null) {
                    request.setAttribute("backupBaseDir", (Object)backupBaseDir);
                } else {
                    request.setAttribute("backupBaseDir", (Object)"");
                }
                request.setAttribute("backupDirStatus", (Object)backupDirStatus);
                RequestUtil.forwardRequest(request, response, "/admin/backup-configuration.jsp", null);
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("BackupAdmin.configureBackup - Problem discovering backup directory while initializing backup configuration page: " + mue.getMessage());
            }
        }
        Vector<String> processingSuccess = new Vector<String>();
        Vector<String> processingErrors = new Vector<String>();
        Vector<String> validationErrors = new Vector<String>();
        validationErrors.addAll(this.validateOptions(request));
        String backupDir = null;
        String realApplicationContext = null;
        String hiddenBackupDir = null;
        if (validationErrors.size() == 0) {
            try {
                backupDir = request.getParameter("backup-dir");
                realApplicationContext = ServiceService.getRealApplicationContext();
                hiddenBackupDir = backupDir + FileUtil.getFS() + "." + realApplicationContext;
                FileUtil.createDirectory((String)hiddenBackupDir);
                PropertyService.setProperty("application.backupDir", backupDir);
                ServiceService.refreshService("PropertyService");
                PropertyService.setRecommendedExternalDir(backupDir);
                ServiceService.refreshService("SkinPropertyService");
                SystemUtil.storeExternalDirLocation(backupDir);
            }
            catch (UtilException ue) {
                String errorMessage = "BackupAdmin.configureBackup - Could not create directory: " + hiddenBackupDir + " : " + ue.getMessage() + ". Please try again";
                processingErrors.add(errorMessage);
                logMetacat.error((Object)errorMessage);
            }
            catch (GeneralPropertyException gpe) {
                String errorMessage = "BackupAdmin.configureBackup - Could not set application.backupDir property  to " + backupDir + " : " + gpe.getMessage() + ".";
                processingErrors.add(errorMessage);
                logMetacat.error((Object)errorMessage);
            }
            catch (ServiceException se) {
                String errorMessage = "BackupAdmin.configureBackup - Could not refresh service : " + se.getMessage() + ".";
                processingErrors.add(errorMessage);
                logMetacat.error((Object)errorMessage);
            }
        }
        try {
            if (validationErrors.size() > 0 || processingErrors.size() > 0) {
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestFormErrors(request, validationErrors);
                RequestUtil.setRequestErrors(request, processingErrors);
                RequestUtil.forwardRequest(request, response, "/admin", null);
            } else {
                processingSuccess.add("Directory: " + backupDir + " configured.");
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestSuccess(request, processingSuccess);
                RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
            }
        }
        catch (MetacatUtilException mue) {
            throw new AdminException("BackupAdmin.configureBackup - utility problem while processing login page: " + mue.getMessage());
        }
    }

    protected String getBackupDirStatus(String backupBaseDir) {
        if (backupBaseDir == null) {
            return UNKNOWN;
        }
        if (FileUtil.getFileStatus((String)(backupBaseDir + FileUtil.getFS() + ".metacat" + FileUtil.getFS() + "metacat.properties.backup")) >= FileUtil.EXISTS_READ_WRITABLE) {
            return HIDDEN_EXISTS_POPULATED;
        }
        if (FileUtil.getFileStatus((String)(backupBaseDir + FileUtil.getFS() + ".metacat")) >= FileUtil.EXISTS_READ_WRITABLE) {
            return HIDDEN_EXISTS_UNPOPULATED;
        }
        if (FileUtil.getFileStatus((String)backupBaseDir) >= FileUtil.EXISTS_READ_WRITABLE) {
            return BASE_EXISTS_ONLY;
        }
        return UNKNOWN;
    }

    @Override
    protected Vector<String> validateOptions(HttpServletRequest request) {
        String deployDir;
        Vector<String> errorVector = new Vector<String>();
        String backupDir = request.getParameter("backup-dir");
        String hiddenBackupDir = backupDir + FileUtil.getFS() + ".metacat";
        if (FileUtil.getFileStatus((String)hiddenBackupDir) > FileUtil.DOES_NOT_EXIST && !FileUtil.isDirectory((String)hiddenBackupDir)) {
            errorVector.add(hiddenBackupDir + " exists, but is not a directory.");
        }
        if (backupDir.startsWith(deployDir = SystemUtil.discoverDeployDir(request))) {
            errorVector.add("Backup location must be outside of the application directory: " + deployDir);
        }
        return errorVector;
    }
}

