/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.MetacatVersion;
import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.MetacatAdmin;
import edu.ucsb.nceas.metacat.admin.upgrade.UpgradeUtilityInterface;
import edu.ucsb.nceas.metacat.admin.upgrade.solr.SolrSchemaModificationException;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBVersion;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.DatabaseUtil;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.DBUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBAdmin
extends MetacatAdmin {
    public static final int DB_DOES_NOT_EXIST = 0;
    public static final int TABLES_DO_NOT_EXIST = 1;
    public static final int TABLES_EXIST = 2;
    public static final int VERSION_INACTIVE = 0;
    public static final int VERSION_ACTIVE = 1;
    private TreeSet<DBVersion> versionSet = null;
    private static DBAdmin dbAdmin = null;
    private Log logMetacat = LogFactory.getLog(DBAdmin.class);
    private HashSet<String> sqlCommandSet = new HashSet();
    private Map<String, String> scriptSuffixMap = new HashMap<String, String>();
    private static DBVersion databaseVersion = null;
    private Vector<String> solrUpdateClassesList = new Vector();

    private DBAdmin() throws AdminException {
        this.sqlCommandSet.add("INSERT");
        this.sqlCommandSet.add("UPDATE");
        this.sqlCommandSet.add("DELETE");
        this.sqlCommandSet.add("ALTER");
        this.sqlCommandSet.add("CREATE");
        this.sqlCommandSet.add("DROP");
        this.sqlCommandSet.add("BEGIN");
        this.sqlCommandSet.add("COMMIT");
        this.sqlCommandSet.add("WITH");
        this.sqlCommandSet.add("SELECT");
        try {
            this.versionSet = DatabaseUtil.getUpgradeVersions();
            this.scriptSuffixMap = DatabaseUtil.getScriptSuffixes();
        }
        catch (PropertyNotFoundException pnfe) {
            throw new AdminException("DBAdmin() - Could not retrieve database upgrade versions during instantiation" + pnfe.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new AdminException("DBAdmin() - Bad version format numbering: " + nfe.getMessage());
        }
    }

    public static DBAdmin getInstance() throws AdminException {
        if (dbAdmin == null) {
            dbAdmin = new DBAdmin();
        }
        return dbAdmin;
    }

    public void configureDatabase(HttpServletRequest request, HttpServletResponse response) throws AdminException {
        String processForm = request.getParameter("processForm");
        String formErrors = (String)request.getAttribute("formErrors");
        HttpSession session = request.getSession();
        String supportEmail = null;
        if (processForm == null || !processForm.equals("true") || formErrors != null) {
            try {
                databaseVersion = this.discoverDBVersion();
                MetacatVersion metacatVersion = SystemUtil.getMetacatVersion();
                session.setAttribute("metacatVersion", (Object)MetacatVersion.getVersionID());
                if (databaseVersion.compareTo(metacatVersion) == 0) {
                    PropertyService.setProperty("configutil.databaseConfigured", "true");
                }
                MetacatVersion metaCatVersion = SystemUtil.getMetacatVersion();
                request.setAttribute("metacatVersion", (Object)metaCatVersion);
                DBVersion dbVersionString = this.getDBVersion();
                request.setAttribute("databaseVersion", (Object)dbVersionString);
                Vector<String> updateScriptList = this.getUpdateScripts();
                request.setAttribute("updateScriptList", updateScriptList);
                supportEmail = PropertyService.getProperty("email.recipient");
                request.setAttribute("supportEmail", (Object)supportEmail);
                RequestUtil.clearRequestMessages(request);
                RequestUtil.forwardRequest(request, response, "/admin/database-configuration.jsp", null);
            }
            catch (GeneralPropertyException gpe) {
                throw new AdminException("DBAdmin.configureDatabase - Problem getting or setting property while initializing system properties page: " + gpe.getMessage());
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("DBAdmin.configureDatabase - utility problem while initializing system properties page:" + mue.getMessage());
            }
        }
        Vector<String> validationErrors = new Vector<String>();
        Vector<String> processingSuccess = new Vector<String>();
        try {
            supportEmail = PropertyService.getProperty("email.recipient");
            validationErrors.addAll(this.validateOptions(request));
            this.upgradeDatabase();
            PropertyService.setProperty("configutil.databaseConfigured", "true");
            PropertyService.persistMainBackupProperties();
            processingSuccess.add("Database successfully upgraded");
            RequestUtil.clearRequestMessages(request);
            RequestUtil.setRequestSuccess(request, processingSuccess);
            RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
        }
        catch (GeneralPropertyException gpe) {
            throw new AdminException("DBAdmin.configureDatabase - Problem getting or setting property while upgrading database: " + gpe.getMessage());
        }
        catch (MetacatUtilException mue) {
            throw new AdminException("DBAdmin.configureDatabase - utility problem while upgrading database: " + mue.getMessage());
        }
    }

    public int getDBStatus() throws SQLException, PropertyNotFoundException {
        Connection connection = DBUtil.getConnection((String)PropertyService.getProperty("database.connectionURI"), (String)PropertyService.getProperty("database.user"), (String)PropertyService.getProperty("database.password"));
        if (DBUtil.tableExists((Connection)connection, (String)"xml_documents")) {
            return 2;
        }
        return 1;
    }

    public DBVersion getDBVersion() throws AdminException {
        try {
            if (!PropertyService.arePropertiesConfigured()) {
                throw new AdminException("DBAdmin.getDBVersion - An attempt was made to get the database version before system properties were configured");
            }
        }
        catch (GeneralPropertyException gpe) {
            throw new AdminException("DBAdmin.getDBVersion - Could not determine the database version: " + gpe.getMessage());
        }
        if (databaseVersion == null) {
            databaseVersion = this.discoverDBVersion();
        }
        if (databaseVersion == null) {
            throw new AdminException("DBAdmin.getDBVersion - Could not find database version");
        }
        return databaseVersion;
    }

    private DBVersion discoverDBVersion() throws AdminException {
        try {
            int dbStatus = this.getDBStatus();
            if (dbStatus == 0) {
                throw new AdminException("DBAdmin.discoverDBVersion - Database does not exist for connection" + PropertyService.getProperty("database.connectionURI"));
            }
            if (dbStatus == 1) {
                databaseVersion = new DBVersion("0.0.0");
                return databaseVersion;
            }
            databaseVersion = this.getRegisteredDBVersion();
            if (databaseVersion != null) {
                return databaseVersion;
            }
            databaseVersion = this.getUnRegisteredDBVersion();
        }
        catch (SQLException sqle) {
            String errorMessage = "DBAdmin.discoverDBVersion - SQL error during  database version discovery: " + sqle.getMessage();
            this.logMetacat.error((Object)errorMessage);
            throw new AdminException(errorMessage);
        }
        catch (PropertyNotFoundException pnfe) {
            String errorMessage = "DBAdmin.discoverDBVersion - Property not found during  database version discovery: " + pnfe.getMessage();
            this.logMetacat.error((Object)errorMessage);
            throw new AdminException(errorMessage);
        }
        catch (NumberFormatException nfe) {
            throw new AdminException("DBAdmin.discoverDBVersion - Bad version format numbering: " + nfe.getMessage());
        }
        if (databaseVersion == null) {
            throw new AdminException("DBAdmin.discoverDBVersion - Database version discovery returned null");
        }
        return databaseVersion;
    }

    public Vector<String> getSolrUpdateClasses() {
        return this.solrUpdateClassesList;
    }

    private DBVersion getRegisteredDBVersion() throws AdminException, SQLException {
        String dbVersionString = null;
        try (Statement pstmt = null;){
            Connection connection = DBUtil.getConnection((String)PropertyService.getProperty("database.connectionURI"), (String)PropertyService.getProperty("database.user"), (String)PropertyService.getProperty("database.password"));
            if (!DBUtil.tableExists((Connection)connection, (String)"db_version")) {
                DBVersion dBVersion = null;
                return dBVersion;
            }
            pstmt = connection.prepareStatement("SELECT version FROM db_version WHERE status = ?");
            pstmt.setInt(1, 1);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean hasRows = rs.next();
            if (hasRows) {
                dbVersionString = rs.getString(1);
            }
            if (dbVersionString == null) {
                DBVersion dBVersion = null;
                return dBVersion;
            }
            DBVersion dBVersion = new DBVersion(dbVersionString);
            return dBVersion;
        }
    }

    public DBVersion getUnRegisteredDBVersion() throws AdminException, SQLException {
        Connection connection = null;
        try {
            connection = DBUtil.getConnection((String)PropertyService.getProperty("database.connectionURI"), (String)PropertyService.getProperty("database.user"), (String)PropertyService.getProperty("database.password"));
            String dbVersionString = null;
            if (this.is1_9_1(connection)) {
                dbVersionString = "1.9.1";
            } else if (this.is1_9_0(connection)) {
                dbVersionString = "1.9.0";
            } else if (this.is1_8_0(connection)) {
                dbVersionString = "1.8.0";
            } else if (this.is1_7_0(connection)) {
                dbVersionString = "1.7.0";
            } else if (this.is1_6_0(connection)) {
                dbVersionString = "1.6.0";
            } else if (this.is1_5_0(connection)) {
                dbVersionString = "1.5.0";
            } else if (this.is1_4_0(connection)) {
                dbVersionString = "1.4.0";
            } else if (this.is1_3_0(connection)) {
                dbVersionString = "1.3.0";
            } else if (this.is1_2_0(connection)) {
                dbVersionString = "1.2.0";
            }
            if (dbVersionString == null) {
                return null;
            }
            return new DBVersion(dbVersionString);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new AdminException("DBAdmin.getUnRegisteredDBVersion - Could not get property for unregistered db version: " + pnfe.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new AdminException("DBAdmin.getUnRegisteredDBVersion - Bad version format numbering: " + nfe.getMessage());
        }
    }

    public String validateDBConnectivity(String dbDriver, String connection, String user, String password) {
        try {
            DBConnection.testConnection(dbDriver, connection, user, password);
        }
        catch (SQLException se) {
            return "Invalid database credential was provided: " + se.getMessage();
        }
        return null;
    }

    private boolean is1_9_0(Connection connection) throws SQLException {
        return DBUtil.tableExists((Connection)connection, (String)"db_version");
    }

    private boolean is1_9_1(Connection connection) throws SQLException {
        return DBUtil.tableExists((Connection)connection, (String)"db_version");
    }

    private boolean is1_8_0(Connection connection) throws SQLException, PropertyNotFoundException {
        String tableName = "xml_nodes";
        String dbType = PropertyService.getProperty("database.type");
        boolean isOracle = dbType.equals("oracle");
        if (isOracle) {
            tableName = "XML_NODES";
        }
        return DBUtil.indexExists((Connection)connection, (String)tableName, (String)"xml_nodes_idx4");
    }

    private boolean is1_7_0(Connection connection) throws SQLException, PropertyNotFoundException {
        String tableName = "xml_documents";
        String dbType = PropertyService.getProperty("database.type");
        boolean isOracle = dbType.equals("oracle");
        if (isOracle) {
            tableName = "XML_DOCUMENTS";
        }
        return DBUtil.indexExists((Connection)connection, (String)tableName, (String)"xml_documents_idx2");
    }

    private boolean is1_6_0(Connection connection) throws SQLException {
        return DBUtil.tableExists((Connection)connection, (String)"identifier");
    }

    private boolean is1_5_0(Connection connection) throws SQLException {
        return DBUtil.tableExists((Connection)connection, (String)"xml_returnfield");
    }

    private boolean is1_4_0(Connection connection) throws SQLException {
        return DBUtil.tableExists((Connection)connection, (String)"access_log");
    }

    private boolean is1_3_0(Connection connection) throws SQLException {
        return DBUtil.tableExists((Connection)connection, (String)"xml_accesssubtree");
    }

    private boolean is1_2_0(Connection connection) throws SQLException {
        return DBUtil.columnExists((Connection)connection, (String)"xml_replication", (String)"datareplicate");
    }

    public Vector<String> getUpdateScripts() throws AdminException {
        Vector<String> updateScriptList = new Vector<String>();
        String sqlFileLocation = null;
        String databaseType = null;
        MetacatVersion metaCatVersion = null;
        try {
            metaCatVersion = SystemUtil.getMetacatVersion();
            sqlFileLocation = SystemUtil.getSQLDir();
            databaseType = PropertyService.getProperty("database.type");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new AdminException("DBAdmin.getUpdateScripts - Could not get property while trying to retrieve database update scripts: " + pnfe.getMessage());
        }
        String sqlSuffix = "-" + this.scriptSuffixMap.get("database.scriptsuffix." + databaseType);
        if (metaCatVersion == null || databaseVersion == null) {
            return updateScriptList;
        }
        for (DBVersion nextVersion : this.versionSet) {
            Vector<String> versionUpdateScripts = nextVersion.getUpdateScripts();
            if (databaseVersion.getVersionString().equals("0.0.0") && nextVersion.getVersionString().equals("0.0.0")) {
                for (String versionUpdateScript : versionUpdateScripts) {
                    updateScriptList.add(sqlFileLocation + FileUtil.getFS() + versionUpdateScript + sqlSuffix);
                }
                return updateScriptList;
            }
            if (nextVersion.compareTo(databaseVersion) <= 0 || nextVersion.compareTo(metaCatVersion) > 0 || nextVersion.getUpdateScripts() == null) continue;
            for (String versionUpdateScript : versionUpdateScripts) {
                updateScriptList.add(sqlFileLocation + FileUtil.getFS() + versionUpdateScript + sqlSuffix);
            }
        }
        return updateScriptList;
    }

    public Vector<String> getUpdateClasses() throws AdminException {
        Vector<String> updateClassList = new Vector<String>();
        MetacatVersion metaCatVersion = null;
        try {
            metaCatVersion = SystemUtil.getMetacatVersion();
        }
        catch (PropertyNotFoundException pnfe) {
            throw new AdminException("DBAdmin.getUpdateScripts - Could not get property while trying to retrieve update utilities: " + pnfe.getMessage());
        }
        if (metaCatVersion == null || databaseVersion == null) {
            return updateClassList;
        }
        for (DBVersion nextVersion : this.versionSet) {
            if (nextVersion.compareTo(databaseVersion) <= 0 || nextVersion.compareTo(metaCatVersion) > 0) continue;
            String solrKey = "solr.upgradeUtility." + nextVersion.getVersionString();
            String solrClassName = null;
            try {
                solrClassName = PropertyService.getProperty(solrKey);
                if (solrClassName != null && !solrClassName.trim().equals("")) {
                    this.solrUpdateClassesList.add(solrClassName);
                }
            }
            catch (PropertyNotFoundException pnfe) {
                this.logMetacat.warn((Object)("No solr update utility defined for version: " + solrKey));
            }
            catch (Exception e) {
                this.logMetacat.warn((Object)("Can't put the solr update utility class into a vector : " + e.getMessage()));
            }
            String key = "database.upgradeUtility." + nextVersion.getVersionString();
            String className = null;
            try {
                className = PropertyService.getProperty(key);
            }
            catch (PropertyNotFoundException pnfe) {
                this.logMetacat.warn((Object)("No utility defined for version: " + key));
                continue;
            }
            updateClassList.add(className);
        }
        return updateClassList;
    }

    public void upgradeDatabase() throws AdminException {
        boolean persist = true;
        try {
            Vector<String> updateScriptList = this.getUpdateScripts();
            for (String updateScript : updateScriptList) {
                this.runSQLFile(updateScript);
            }
            try {
                MetacatAdmin.updateUpgradeStatus("configutil.upgrade.database.status", "success", persist);
            }
            catch (Exception e) {
                this.logMetacat.warn((Object)("DBAdmin.upgradeDatabase - couldn't update the status of the upgrading database process since " + e.getMessage()));
            }
        }
        catch (SQLException sqle) {
            try {
                MetacatAdmin.updateUpgradeStatus("configutil.upgrade.database.status", "failure", persist);
            }
            catch (Exception e) {
                this.logMetacat.warn((Object)("DBAdmin.upgradeDatabase - couldn't update the status of the upgrading database process since " + e.getMessage()));
            }
            throw new AdminException("DBAdmin.upgradeDatabase - SQL error when running upgrade scripts: " + sqle.getMessage());
        }
        Vector<String> updateClassList = this.getUpdateClasses();
        for (String className : updateClassList) {
            UpgradeUtilityInterface utility = null;
            try {
                utility = (UpgradeUtilityInterface)Class.forName(className).newInstance();
                utility.upgrade();
            }
            catch (SolrSchemaModificationException e) {
            }
            catch (Exception e) {
                try {
                    MetacatAdmin.updateUpgradeStatus("configutil.upgrade.java.status", "failure", persist);
                }
                catch (Exception ee) {
                    this.logMetacat.warn((Object)("DBAdmin.upgradeDatabase - couldn't update the status of the upgrading database process since " + ee.getMessage()));
                }
                throw new AdminException("DBAdmin.upgradeDatabase - error getting utility class: " + className + ". Error message: " + e.getMessage());
            }
        }
        try {
            MetacatAdmin.updateUpgradeStatus("configutil.upgrade.java.status", "success", persist);
        }
        catch (Exception e) {
            this.logMetacat.warn((Object)("DBAdmin.upgradeDatabase - couldn't update the status of the upgrading database process since " + e.getMessage()));
        }
        try {
            databaseVersion = new DBVersion(SystemUtil.getMetacatVersion().getVersionString());
        }
        catch (PropertyNotFoundException pnfe) {
            throw new AdminException("DBAdmin.upgradeDatabase - Couldn't set the database version since: " + pnfe.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new AdminException("DBAdmin.upgradeDatabase - Bad version format numbering: " + nfe.getMessage());
        }
    }

    public void runSQLFile(String sqlFileName) throws AdminException, SQLException {
        if (FileUtil.getFileStatus((String)sqlFileName) < FileUtil.EXISTS_READABLE) {
            throw new AdminException("Could not read sql update file: " + sqlFileName);
        }
        try (Connection connection = null;){
            connection = DBUtil.getConnection((String)PropertyService.getProperty("database.connectionURI"), (String)PropertyService.getProperty("database.user"), (String)PropertyService.getProperty("database.password"));
            connection.setAutoCommit(false);
            this.logMetacat.debug((Object)("DBAdmin.runSQLFile - processing File: " + sqlFileName));
            Vector<String> sqlCommands = this.loadSQLFromFile(sqlFileName);
            for (String sqlStatement : sqlCommands) {
                Statement statement = connection.createStatement();
                this.logMetacat.debug((Object)("executing sql: " + sqlStatement));
                try {
                    statement.execute(sqlStatement);
                }
                catch (SQLException sqle) {
                    if (sqlStatement.toUpperCase().startsWith("DROP") && (sqle.getMessage().contains("ORA-02289") || sqle.getMessage().contains("ORA-04098") || sqle.getMessage().contains("ORA-04080") || sqle.getMessage().contains("ORA-00942"))) {
                        this.logMetacat.warn((Object)("DBAdmin.runSQLFile - did not process sql drop statement: " + sqle.getMessage()));
                        continue;
                    }
                    throw sqle;
                }
            }
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> loadSQLFromFile(String sqlFileName) throws IOException {
        Vector<String> sqlCommands = new Vector<String>();
        FileInputStream fin = null;
        try {
            String fileLine;
            fin = new FileInputStream(sqlFileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fin));
            block2: while ((fileLine = reader.readLine()) != null) {
                String trimmedLine;
                String endChar = ";";
                String firstWord = trimmedLine = fileLine.trim();
                if (trimmedLine.indexOf(32) > 0) {
                    firstWord = trimmedLine.substring(0, trimmedLine.indexOf(32));
                }
                if (firstWord.endsWith(endChar)) {
                    firstWord = firstWord.substring(0, firstWord.indexOf(endChar));
                }
                if (!this.sqlCommandSet.contains(firstWord.toUpperCase())) continue;
                String sqlStatement = "";
                do {
                    String trimmedInnerLine;
                    if ((trimmedInnerLine = fileLine.trim()).toUpperCase().equals("BEGIN") || trimmedInnerLine.toUpperCase().startsWith("BEGIN ") || trimmedInnerLine.toUpperCase().equals("DECLARE") || trimmedInnerLine.toUpperCase().startsWith("DECLARE ")) {
                        endChar = "/";
                    }
                    if (trimmedInnerLine.matches("^$") || trimmedInnerLine.matches("^\\*.*") || trimmedInnerLine.matches("/\\*.*")) continue;
                    if (trimmedInnerLine.indexOf("--") >= 0) {
                        trimmedInnerLine = trimmedInnerLine.substring(0, trimmedInnerLine.indexOf("--")).trim();
                    }
                    if (sqlStatement.length() > 0) {
                        sqlStatement = sqlStatement + " ";
                    }
                    sqlStatement = sqlStatement + trimmedInnerLine;
                    if (!trimmedInnerLine.endsWith(endChar)) continue;
                    sqlStatement = sqlStatement.substring(0, sqlStatement.length() - 1);
                    sqlCommands.add(sqlStatement);
                    continue block2;
                } while ((fileLine = reader.readLine()) != null);
            }
            fin.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fin);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fin);
        return sqlCommands;
    }

    @Override
    protected Vector<String> validateOptions(HttpServletRequest request) {
        Vector<String> errorVector = new Vector<String>();
        return errorVector;
    }
}

