/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.EZIDAdmin;
import edu.ucsb.nceas.metacat.admin.MetacatAdmin;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuotaAdmin
extends MetacatAdmin {
    private static QuotaAdmin quotaAdmin = null;
    private Log logMetacat = LogFactory.getLog(EZIDAdmin.class);

    private QuotaAdmin() throws AdminException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QuotaAdmin getInstance() throws AdminException {
        if (quotaAdmin != null) return quotaAdmin;
        Class<QuotaAdmin> clazz = QuotaAdmin.class;
        synchronized (QuotaAdmin.class) {
            if (quotaAdmin != null) return quotaAdmin;
            quotaAdmin = new QuotaAdmin();
            // ** MonitorExit[var0] (shouldn't be in output)
            return quotaAdmin;
        }
    }

    public void configureQuota(HttpServletRequest request, HttpServletResponse response) throws AdminException {
        this.logMetacat.debug((Object)"QuotaAdmin.configQuota - the start of the method");
        String processForm = request.getParameter("processForm");
        String bypass = request.getParameter("bypass");
        String formErrors = (String)request.getAttribute("formErrors");
        if (processForm == null || !processForm.equals("true") || formErrors != null) {
            this.logMetacat.debug((Object)"QuotaAdmin.configQuota - in the error handling routine");
            try {
                String enablePortalStr = PropertyService.getProperty("dataone.quotas.portals.enabled");
                String enableStorageStr = PropertyService.getProperty("dataone.quotas.storage.enabled");
                String enableReplicationStr = PropertyService.getProperty("dataone.quotas.replication.enabled");
                String baseurl = PropertyService.getProperty("dataone.quotas.bookkeeper.serviceUrl");
                boolean enablePortal = false;
                if (enablePortalStr != null) {
                    enablePortal = Boolean.parseBoolean(enablePortalStr);
                }
                boolean enableStorage = false;
                if (enableStorageStr != null) {
                    enableStorage = Boolean.parseBoolean(enableStorageStr);
                }
                boolean enableReplication = false;
                if (enableReplicationStr != null) {
                    enableReplication = Boolean.parseBoolean(enableReplicationStr);
                }
                request.setAttribute("dataone.quotas.portals.enabled", (Object)enablePortal);
                request.setAttribute("dataone.quotas.storage.enabled", (Object)enableStorage);
                request.setAttribute("dataone.quotas.replication.enabled", (Object)enableReplication);
                request.setAttribute("dataone.quotas.bookkeeper.serviceUrl", (Object)baseurl);
                SortedProperties backupProperties = null;
                backupProperties = PropertyService.getMainBackupProperties();
                if (backupProperties != null) {
                    Vector backupKeys = backupProperties.getPropertyNames();
                    for (String key : backupKeys) {
                        String value = backupProperties.getProperty(key);
                        if (key != null && value != null && key.equals("dataone.quotas.bookkeeper.serviceUrl")) {
                            request.setAttribute(key, (Object)value);
                            continue;
                        }
                        if (value == null) continue;
                        request.setAttribute(key, (Object)Boolean.parseBoolean(value));
                    }
                }
                RequestUtil.forwardRequest(request, response, "/admin/quota-configuration.jsp", null);
            }
            catch (GeneralPropertyException gpe) {
                throw new AdminException("QuotaAdmin.configureQuota - Problem getting or setting property while initializing system properties page: " + gpe.getMessage());
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("QuotaAdmin.configureQuota- utility problem while initializing system properties page:" + mue.getMessage());
            }
        }
        if (bypass != null && bypass.equals("true")) {
            this.logMetacat.debug((Object)"QuotaAdmin.configQuota - in the bypass routine...");
            Vector<String> processingErrors = new Vector<String>();
            Vector<String> processingSuccess = new Vector<String>();
            try {
                PropertyService.setProperty("configutil.quotaConfigured", "bypassed");
            }
            catch (GeneralPropertyException gpe) {
                String errorMessage = "QuotaAdmin.configureQuota - Problem getting or setting property while processing system properties page: " + gpe.getMessage();
                this.logMetacat.error((Object)errorMessage);
                processingErrors.add(errorMessage);
            }
            try {
                if (processingErrors.size() > 0) {
                    RequestUtil.clearRequestMessages(request);
                    RequestUtil.setRequestErrors(request, processingErrors);
                    RequestUtil.forwardRequest(request, response, "/admin", null);
                }
                processingSuccess.add("Quota configuration successfully bypassed");
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestSuccess(request, processingSuccess);
                RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("QuotaAdmin.configureQuota - utility problem while processing the quota services quotaservices page: " + mue.getMessage());
            }
        } else {
            this.logMetacat.debug((Object)"QuotaAdmin.configQuota - in the else routine...");
            Vector<String> validationErrors = new Vector<String>();
            Vector<String> processingErrors = new Vector<String>();
            Vector<String> processingSuccess = new Vector<String>();
            try {
                validationErrors.addAll(this.validateOptions(request));
                String enablePortalStr = request.getParameter("dataone.quotas.portals.enabled");
                String enableStorageStr = request.getParameter("dataone.quotas.storage.enabled");
                String enableReplicationStr = request.getParameter("dataone.quotas.replication.enabled");
                String baseurl = request.getParameter("dataone.quotas.bookkeeper.serviceUrl");
                boolean enablePortal = false;
                if (enablePortalStr != null) {
                    enablePortal = Boolean.parseBoolean(enablePortalStr);
                }
                boolean enableStorage = false;
                if (enableStorageStr != null) {
                    enableStorage = Boolean.parseBoolean(enableStorageStr);
                }
                boolean enableReplication = false;
                if (enableReplicationStr != null) {
                    enableReplication = Boolean.parseBoolean(enableReplicationStr);
                }
                PropertyService.setPropertyNoPersist("dataone.quotas.portals.enabled", Boolean.toString(enablePortal));
                PropertyService.setPropertyNoPersist("dataone.quotas.storage.enabled", Boolean.toString(enableStorage));
                PropertyService.setPropertyNoPersist("dataone.quotas.replication.enabled", Boolean.toString(enableReplication));
                PropertyService.setPropertyNoPersist("dataone.quotas.bookkeeper.serviceUrl", baseurl);
                PropertyService.persistProperties();
                PropertyService.syncToSettings();
                PropertyService.persistMainBackupProperties();
            }
            catch (GeneralPropertyException gpe) {
                String errorMessage = "QuotaDAdmin.configureQuota - Problem getting or setting property while processing system properties page: " + gpe.getMessage();
                this.logMetacat.error((Object)errorMessage);
                processingErrors.add(errorMessage);
            }
            try {
                if (validationErrors.size() > 0 || processingErrors.size() > 0) {
                    RequestUtil.clearRequestMessages(request);
                    RequestUtil.setRequestFormErrors(request, validationErrors);
                    RequestUtil.setRequestErrors(request, processingErrors);
                    RequestUtil.forwardRequest(request, response, "/admin", null);
                } else {
                    PropertyService.setProperty("configutil.quotaConfigured", "true");
                    processingSuccess.add("Quota Service successfully configured");
                    RequestUtil.clearRequestMessages(request);
                    RequestUtil.setRequestSuccess(request, processingSuccess);
                    RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
                }
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("QuotaAdmin.configureQuota - utility problem while processing ezidservices quotaservices page: " + mue.getMessage());
            }
            catch (GeneralPropertyException gpe) {
                throw new AdminException("QuotaAdmin.configureQuota - problem with properties while processing ezidservices configuration page: " + gpe.getMessage());
            }
        }
    }

    @Override
    protected Vector<String> validateOptions(HttpServletRequest request) {
        Vector<String> errorVector = new Vector<String>();
        return errorVector;
    }
}

