/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.DBAdmin;
import edu.ucsb.nceas.metacat.admin.MetacatAdmin;
import edu.ucsb.nceas.metacat.admin.upgrade.UpgradeUtilityInterface;
import edu.ucsb.nceas.metacat.admin.upgrade.solr.SolrSchemaModificationException;
import edu.ucsb.nceas.metacat.common.SolrServerFactory;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.ServiceService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.UtilException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.CoreStatus;
import org.dataone.service.exceptions.UnsupportedType;
import org.xml.sax.SAXException;

public class SolrAdmin
extends MetacatAdmin {
    private static SolrAdmin solrAdmin = null;
    private Log logMetacat = LogFactory.getLog(SolrAdmin.class);
    public static final String CREATE = "create";
    public static final String REGISTER = "register";
    public static final String REGISTERANDUPDATE = "registerAndUpdate";
    public static final String CREATEWITHWARN = "createWithWarn";
    public static final String CREATEORUPDATEWITHWARN = "createOrUpdateWithWarn";
    public static final String REGISTERWITHWARN = "RegisterWithWarn";
    public static final String REGISTERANDUPDATEWITHWARN = "RegisterAndUpdateWithWarn";
    public static final String KEEP = "KEEP";
    private static final String SOLRXMLFILENAME = "solr.xml";
    public static final String UPDATE = "update";
    public static final String UNKNOWN = "Unkown";
    public static final String ACTION = "action";
    public static final String CURRENTCOREINSTANCEDIR = "core-current-instance-dir";
    public static final String NEWSOLRCOREORNOT = "newSolrCoreOrNot";
    public static final String NEWSOLRCORE = "newSolrCore";
    public static final String EXISTINGCORE = "existingCore";
    public static final String SOLRCORENAME = "solrCoreName";
    public static final String NEWSOLCORENAME = "newSolrCoreName";
    private static final String CONF = "conf";
    private static final String DATA = "data";
    private static final String CORE_PROPERTY = "core.properties";
    private static final String SOLR_HOME = "SOLR_HOME";
    private SolrSchemaModificationException solrSchemaException = null;
    private Vector<String> updateClassList = DBAdmin.getInstance().getSolrUpdateClasses();

    private SolrAdmin() throws AdminException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SolrAdmin getInstance() throws AdminException {
        if (solrAdmin != null) return solrAdmin;
        Class<SolrAdmin> clazz = SolrAdmin.class;
        synchronized (SolrAdmin.class) {
            if (solrAdmin != null) return solrAdmin;
            solrAdmin = new SolrAdmin();
            // ** MonitorExit[var0] (shouldn't be in output)
            return solrAdmin;
        }
    }

    public void configureSolr(HttpServletRequest request, HttpServletResponse response) throws AdminException {
        block74: {
            UnsupportedOperationException unspportedOperExcepiton = null;
            String processForm = request.getParameter("processForm");
            String bypass = request.getParameter("bypass");
            String formErrors = (String)request.getAttribute("formErrors");
            if (processForm == null || !processForm.equals("true") || formErrors != null) {
                try {
                    String baseURL = PropertyService.getProperty("solr.baseURL");
                    String coreName = PropertyService.getProperty("solr.coreName");
                    String solrHomePath = PropertyService.getProperty("solr.homeDir");
                    if (coreName == null || coreName.trim().equals("")) {
                        throw new AdminException("The slor core name shouldn't be null or blank. Please go back to the Metacat Global Properties admin page to configure again.");
                    }
                    if (solrHomePath == null || solrHomePath.trim().equals("")) {
                        throw new AdminException("The slor home path shouldn't be null or blank. Please go back to the Metacat Global Properties admin page to configure again.");
                    }
                    boolean solrHomeExists = new File(solrHomePath).exists();
                    if (solrHomeExists && !FileUtil.isDirectory((String)solrHomePath)) {
                        throw new AdminException("SolrAdmin.configureProperties - SOLR home is not a directory: " + solrHomePath);
                    }
                    boolean solrHomeConfExists = new File(solrHomePath + "/" + CONF).exists();
                    boolean solrHomeDataExists = new File(solrHomePath + "/" + DATA).exists();
                    boolean solrHomeCoreExists = new File(solrHomePath + "/" + CORE_PROPERTY).exists();
                    request.setAttribute("solrHomeExist", (Object)solrHomeExists);
                    request.setAttribute("solrHomeValueInProp", (Object)solrHomePath);
                    String solrHomeForGivenCore = this.getInstanceDir(coreName);
                    request.setAttribute("solrCore", (Object)coreName);
                    if (solrHomeForGivenCore != null) {
                        request.setAttribute("solrHomeForGivenCore", (Object)solrHomeForGivenCore);
                    }
                    boolean updateSchema = false;
                    if (this.updateClassList != null && this.updateClassList.size() > 0) {
                        updateSchema = true;
                    }
                    this.logMetacat.info((Object)("SolrAmdin.confgureSolr -the solr-home on the properties is " + solrHomePath + " and doe it exist? " + solrHomeExists));
                    this.logMetacat.info((Object)("SolrAmdin.confgureSolr - the instance directory for the core " + coreName + " is " + solrHomeForGivenCore + " If it is null, this means the core doesn't exit."));
                    this.logMetacat.info((Object)("SolrAmdin.confgureSolr - in this upgrade/installation, do we need to update the schema file?" + updateSchema));
                    if (!(solrHomeForGivenCore != null || solrHomeExists && (solrHomeConfExists || solrHomeCoreExists || solrHomeDataExists))) {
                        request.setAttribute(ACTION, (Object)CREATE);
                    } else if (solrHomeForGivenCore == null && solrHomeExists && !updateSchema) {
                        request.setAttribute(ACTION, (Object)REGISTER);
                    } else if (solrHomeForGivenCore == null && solrHomeExists && updateSchema) {
                        request.setAttribute(ACTION, (Object)REGISTERANDUPDATE);
                    } else if (!(solrHomeForGivenCore == null || solrHomeForGivenCore.equals(solrHomePath) || solrHomeExists || updateSchema)) {
                        request.setAttribute(ACTION, (Object)CREATEWITHWARN);
                    } else if (solrHomeForGivenCore != null && !solrHomeForGivenCore.equals(solrHomePath) && !solrHomeExists && updateSchema) {
                        request.setAttribute(ACTION, (Object)CREATEORUPDATEWITHWARN);
                    } else if (solrHomeForGivenCore != null && !solrHomeForGivenCore.equals(solrHomePath) && solrHomeExists && !updateSchema) {
                        request.setAttribute(ACTION, (Object)REGISTERWITHWARN);
                    } else if (solrHomeForGivenCore != null && !solrHomeForGivenCore.equals(solrHomePath) && solrHomeExists && updateSchema) {
                        request.setAttribute(ACTION, (Object)REGISTERANDUPDATEWITHWARN);
                    } else if (solrHomeForGivenCore != null && solrHomeForGivenCore.equals(solrHomePath) && solrHomeExists && !updateSchema) {
                        request.setAttribute(ACTION, (Object)KEEP);
                    } else if (solrHomeForGivenCore != null && solrHomeForGivenCore.equals(solrHomePath) && solrHomeExists && updateSchema) {
                        request.setAttribute(ACTION, (Object)UPDATE);
                    } else {
                        request.setAttribute(ACTION, (Object)UNKNOWN);
                    }
                    RequestUtil.forwardRequest(request, response, "/admin/solr-configuration.jsp", null);
                }
                catch (GeneralPropertyException gpe) {
                    throw new AdminException("SolrAdmin.configureSolr - Problem getting or setting property while initializing solr page: " + gpe.getMessage());
                }
                catch (MetacatUtilException mue) {
                    throw new AdminException("SolrAdmin.configureSolr- utility problem while initializing solr page:" + mue.getMessage());
                }
                catch (UnsupportedType e) {
                    throw new AdminException("SolrAdmin.configureSolr- umsupported type problem while initializing solr page:" + e.getMessage());
                }
                catch (ParserConfigurationException e) {
                    throw new AdminException("SolrAdmin.configureSolr- parser configuration problem while initializing solr page:" + e.getMessage());
                }
                catch (IOException e) {
                    throw new AdminException("SolrAdmin.configureSolr- io problem while initializing solr page:" + e.getMessage());
                }
                catch (SAXException e) {
                    throw new AdminException("SolrAdmin.configureSolr- SAX problem while initializing solr page:" + e.getMessage());
                }
                catch (SolrServerException e) {
                    throw new AdminException("SolrAdmin.configureSolr- solr problem while initializing solr page:" + e.getMessage());
                }
            }
            if (bypass != null && bypass.equals("true")) {
                Vector<String> processingErrors = new Vector<String>();
                Vector<String> processingSuccess = new Vector<String>();
                try {
                    PropertyService.setProperty("configutil.solrserverConfigured", "bypassed");
                    try {
                        boolean persist = true;
                        MetacatAdmin.updateUpgradeStatus("configutil.upgrade.solr.status", "success", persist);
                    }
                    catch (Exception e) {
                        this.logMetacat.warn((Object)("SolrAdmin.configureSolr - couldn't update the status of the upgrading Solr process since " + e.getMessage()));
                    }
                }
                catch (GeneralPropertyException gpe) {
                    String errorMessage = "SolrAdmin.configureSolr - Problem getting or setting property while processing system properties page: " + gpe.getMessage();
                    this.logMetacat.error((Object)errorMessage);
                    processingErrors.add(errorMessage);
                }
                try {
                    if (processingErrors.size() > 0) {
                        RequestUtil.clearRequestMessages(request);
                        RequestUtil.setRequestErrors(request, processingErrors);
                        RequestUtil.forwardRequest(request, response, "/admin", null);
                    }
                    processingSuccess.add("Solr configuration successfully bypassed");
                    RequestUtil.clearRequestMessages(request);
                    RequestUtil.setRequestSuccess(request, processingSuccess);
                    RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
                }
                catch (MetacatUtilException mue) {
                    throw new AdminException("Solr.configureSolr - utility problem while processing solr services solr services page: " + mue.getMessage());
                }
            } else {
                Vector<String> processingSuccess;
                Vector<String> processingErrors;
                Vector<String> validationErrors;
                block73: {
                    validationErrors = new Vector<String>();
                    processingErrors = new Vector<String>();
                    processingSuccess = new Vector<String>();
                    try {
                        validationErrors.addAll(this.validateOptions(request));
                        String action = request.getParameter(ACTION);
                        this.logMetacat.info((Object)("SolrAdmin.configureSolr - the action which users choose is " + action));
                        if (action != null && action.equals(CREATE)) {
                            try {
                                this.createSolrHome();
                            }
                            catch (UnsupportedOperationException usoe) {
                                unspportedOperExcepiton = usoe;
                            }
                            this.registerSolrCore();
                            break block73;
                        }
                        if (action != null && action.equals(REGISTER)) {
                            this.registerSolrCore();
                            break block73;
                        }
                        if (action != null && action.equals(REGISTERANDUPDATE)) {
                            this.registerSolrCore();
                            this.updateSolrSchema();
                            break block73;
                        }
                        if (action != null && (action.equals(CREATEWITHWARN) || action.equals(CREATEORUPDATEWITHWARN) || action.equals(REGISTERWITHWARN) || action.equals(REGISTERANDUPDATEWITHWARN))) {
                            String userChoice = request.getParameter(NEWSOLRCOREORNOT);
                            this.logMetacat.info((Object)("SolrAdmin.configureSolr - the user's choice is " + userChoice));
                            if (userChoice != null && userChoice.equals(NEWSOLRCORE)) {
                                String newCoreName = request.getParameter(NEWSOLCORENAME);
                                this.logMetacat.info((Object)("SolrAdmin.configureSolr - the new solr core name users chose is " + newCoreName));
                                if (newCoreName == null || newCoreName.trim().equals("")) {
                                    String error = "The new core name shouldn't be null or blank";
                                    processingErrors.add(error);
                                    break block73;
                                }
                                String instanceDirForNewCore = this.getInstanceDir(newCoreName);
                                if (instanceDirForNewCore != null) {
                                    String error = "The new core name " + newCoreName + " is used by another core. Please choose another name";
                                    processingErrors.add(error);
                                    break block73;
                                }
                                PropertyService.setPropertyNoPersist("solr.coreName", newCoreName);
                                PropertyService.persistProperties();
                                PropertyService.syncToSettings();
                                PropertyService.persistMainBackupProperties();
                                if (action.equals(CREATEWITHWARN) || action.equals(CREATEORUPDATEWITHWARN)) {
                                    try {
                                        this.createSolrHome();
                                    }
                                    catch (UnsupportedOperationException usoe) {
                                        unspportedOperExcepiton = usoe;
                                    }
                                    this.registerSolrCore();
                                    break block73;
                                }
                                if (action.equals(REGISTERWITHWARN)) {
                                    this.registerSolrCore();
                                } else if (action.equals(REGISTERANDUPDATEWITHWARN)) {
                                    this.registerSolrCore();
                                    this.updateSolrSchema();
                                }
                                break block73;
                            }
                            if (userChoice != null && userChoice.equals(EXISTINGCORE)) {
                                String currentSolrInstanceDir = request.getParameter(CURRENTCOREINSTANCEDIR);
                                this.logMetacat.info((Object)("SolrAdmin.configureSolr - the current solr instance directory is " + currentSolrInstanceDir));
                                PropertyService.setPropertyNoPersist("solr.homeDir", currentSolrInstanceDir);
                                PropertyService.persistProperties();
                                PropertyService.syncToSettings();
                                PropertyService.persistMainBackupProperties();
                                if (action.equals(CREATEORUPDATEWITHWARN) || action.equals(REGISTERANDUPDATEWITHWARN)) {
                                    this.updateSolrSchema();
                                }
                                break block73;
                            }
                            throw new AdminException("User's choice " + userChoice + " can't be understood.");
                        }
                        if (action != null && action.equals(KEEP)) break block73;
                        if (action != null && action.equals(UPDATE)) {
                            this.updateSolrSchema();
                            break block73;
                        }
                        throw new Exception("The action " + action + " can't be handled in the solr configuration.");
                    }
                    catch (Exception gpe) {
                        String errorMessage = "SolrAdmin.configureSolr - Problem processing the solr setting since " + gpe.getMessage();
                        this.logMetacat.error((Object)errorMessage);
                        processingErrors.add(errorMessage);
                    }
                }
                try {
                    Vector<String> errorVector;
                    boolean persist = true;
                    if (validationErrors.size() > 0 || processingErrors.size() > 0) {
                        try {
                            MetacatAdmin.updateUpgradeStatus("configutil.upgrade.solr.status", "failure", persist);
                        }
                        catch (Exception e) {
                            this.logMetacat.warn((Object)("SolrAdmin.configureSolr - couldn't update the status of the upgrading Solr process since " + e.getMessage()));
                        }
                        RequestUtil.clearRequestMessages(request);
                        RequestUtil.setRequestFormErrors(request, validationErrors);
                        RequestUtil.setRequestErrors(request, processingErrors);
                        RequestUtil.forwardRequest(request, response, "/admin", null);
                        break block74;
                    }
                    PropertyService.setProperty("configutil.solrserverConfigured", "true");
                    try {
                        MetacatAdmin.updateUpgradeStatus("configutil.upgrade.solr.status", "success", persist);
                    }
                    catch (Exception e) {
                        this.logMetacat.warn((Object)("SolrAdmin.configureSolr - couldn't update the status of the upgrading Solr process since " + e.getMessage()));
                    }
                    if (this.solrSchemaException != null) {
                        errorVector = new Vector<String>();
                        errorVector.add(this.solrSchemaException.getMessage());
                        RequestUtil.clearRequestMessages(request);
                        RequestUtil.setRequestErrors(request, errorVector);
                        RequestUtil.forwardRequest(request, response, "/admin/solr-schema-warn.jsp", null);
                    } else if (unspportedOperExcepiton != null) {
                        errorVector = new Vector();
                        errorVector.add(unspportedOperExcepiton.getMessage());
                        RequestUtil.clearRequestMessages(request);
                        RequestUtil.setRequestErrors(request, errorVector);
                        RequestUtil.forwardRequest(request, response, "/admin/solr-warn.jsp", null);
                    } else {
                        processingSuccess.add("Solr server was successfully configured");
                        RequestUtil.clearRequestMessages(request);
                        RequestUtil.setRequestSuccess(request, processingSuccess);
                        RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
                    }
                }
                catch (MetacatUtilException mue) {
                    throw new AdminException("SolrAdmin.configureSolr - utility problem while processing solr services solr services page: " + mue.getMessage());
                }
                catch (GeneralPropertyException gpe) {
                    throw new AdminException("SolrAdmin.configureSolr - problem with properties while processing solr services configuration page: " + gpe.getMessage());
                }
            }
        }
    }

    @Override
    protected Vector<String> validateOptions(HttpServletRequest request) {
        Vector<String> errorVector = new Vector<String>();
        return errorVector;
    }

    private String getInstanceDir(String coreName) throws UnsupportedType, ParserConfigurationException, IOException, SAXException, SolrServerException {
        String instanceDir = null;
        SolrClient client = SolrServerFactory.createSolrAdminClient();
        CoreAdminRequest adminRequest = new CoreAdminRequest();
        CoreStatus status = CoreAdminRequest.getCoreStatus((String)coreName, (SolrClient)client);
        if (status != null) {
            try {
                instanceDir = status.getInstanceDirectory();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return instanceDir;
    }

    private void createSolrHome() throws PropertyNotFoundException, IOException, ServiceException, UtilException {
        block11: {
            String solrHomePath = PropertyService.getProperty("solr.homeDir");
            String indexContext = PropertyService.getProperty("index.context");
            boolean solrHomeExists = new File(solrHomePath).exists();
            boolean solrHomeConfExists = new File(solrHomePath + "/" + CONF).exists();
            boolean solrHomeDataExists = new File(solrHomePath + "/" + DATA).exists();
            boolean solrHomeCoreExists = new File(solrHomePath + "/" + CORE_PROPERTY).exists();
            if (!solrHomeExists || !solrHomeConfExists && !solrHomeCoreExists && !solrHomeDataExists) {
                try {
                    String metacatWebInf = ServiceService.getRealConfigDir();
                    String metacatIndexSolrHome = metacatWebInf + "/../../" + indexContext + "/WEB-INF/classes/solr-home";
                    File sourceDir = new File(metacatIndexSolrHome);
                    if (sourceDir.exists()) {
                        FileUtil.createDirectory((String)solrHomePath);
                        OrFileFilter fileFilter = new OrFileFilter();
                        fileFilter.addFileFilter(DirectoryFileFilter.DIRECTORY);
                        boolean solrXmlExists = new File(solrHomePath + "/" + SOLRXMLFILENAME).exists();
                        if (!solrXmlExists) {
                            fileFilter.addFileFilter((IOFileFilter)new WildcardFileFilter("*"));
                        } else {
                            fileFilter.addFileFilter((IOFileFilter)new NotFileFilter((IOFileFilter)new NameFileFilter(SOLRXMLFILENAME)));
                        }
                        FileUtils.copyDirectory((File)new File(metacatIndexSolrHome), (File)new File(solrHomePath), (FileFilter)fileFilter);
                        Path solrHomePathObj = Paths.get(solrHomePath, new String[0]);
                        final HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                        perms.add(PosixFilePermission.OWNER_READ);
                        perms.add(PosixFilePermission.OWNER_WRITE);
                        perms.add(PosixFilePermission.OWNER_EXECUTE);
                        perms.add(PosixFilePermission.GROUP_READ);
                        perms.add(PosixFilePermission.GROUP_WRITE);
                        perms.add(PosixFilePermission.GROUP_EXECUTE);
                        perms.add(PosixFilePermission.OTHERS_READ);
                        perms.add(PosixFilePermission.OTHERS_EXECUTE);
                        try {
                            FileSystem fileSystem = solrHomePathObj.getFileSystem();
                            Files.walkFileTree(solrHomePathObj, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                @Override
                                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                    Files.setPosixFilePermissions(file, perms);
                                    return FileVisitResult.CONTINUE;
                                }

                                @Override
                                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                                    Files.setPosixFilePermissions(dir, perms);
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                            break block11;
                        }
                        catch (Exception e) {
                            String errorString = "SolrAdmin.createSolrHome - Metacat can't recursively set the user group the write permission on the solr home directory -" + solrHomePath + ". Please manually do this action";
                            this.logMetacat.error((Object)errorString, (Throwable)e);
                            throw new UnsupportedOperationException(errorString);
                        }
                    }
                    String errorString = "SolrAdmin.createSolrHome - the source director : " + sourceDir + " which should contain the original solr configuration doesn't exist";
                    this.logMetacat.error((Object)errorString);
                    throw new IOException(errorString);
                }
                catch (IOException ue) {
                    String errorString = "SolrAdmin.createSolrHome - Could not initialize directory: " + solrHomePath + " : " + ue.getMessage();
                    this.logMetacat.error((Object)errorString);
                    throw new IOException(errorString);
                }
                catch (ServiceException e) {
                    String errorString = "SolrAdmin.createSolrHome - Could not initialize directory: " + solrHomePath + " : " + e.getMessage();
                    this.logMetacat.error((Object)errorString);
                    throw new ServiceException(errorString);
                }
                catch (UtilException e) {
                    String errorString = "SolrAdmin.createSolrHome - Could not initialize directory: " + solrHomePath + " : " + e.getMessage();
                    this.logMetacat.error((Object)errorString);
                    throw new UtilException(errorString);
                }
            }
            if (!FileUtil.isDirectory((String)solrHomePath)) {
                String errorString = "SolrAdmin.createSolrHome - existing SOLR home is not a directory: " + solrHomePath;
                this.logMetacat.error((Object)errorString);
                throw new IOException(errorString);
            }
            String errorString = "SolrAdmin.createSolrHome - existing SOLR home " + solrHomePath + " already has a core and we can't create blank core in there.";
            this.logMetacat.error((Object)errorString);
            throw new IOException(errorString);
        }
    }

    private void registerSolrCore() throws Exception {
        String coreName = PropertyService.getProperty("solr.coreName");
        String instanceDir = PropertyService.getProperty("solr.homeDir");
        try {
            SolrClient client = SolrServerFactory.createSolrAdminClient();
            CoreAdminRequest adminRequest = new CoreAdminRequest();
            CoreAdminRequest.createCore((String)coreName, (String)instanceDir, (SolrClient)client);
        }
        catch (Exception e) {
            String error = "SolrAdmin.registerSolrCore - Couldn't register the solr core - " + coreName + " with the instance directory - " + instanceDir + " since " + e.getMessage();
            this.logMetacat.error((Object)error, (Throwable)e);
            throw new Exception(error);
        }
        String solrEnvScriptPath = PropertyService.getProperty("solr.env.script.path");
        this.modifySolrHomeInSolrEnvScript(instanceDir, solrEnvScriptPath);
    }

    private void updateSolrSchema() throws AdminException {
        if (this.updateClassList != null) {
            for (String className : this.updateClassList) {
                UpgradeUtilityInterface utility = null;
                try {
                    utility = (UpgradeUtilityInterface)Class.forName(className).newInstance();
                    utility.upgrade();
                }
                catch (SolrSchemaModificationException e) {
                    this.solrSchemaException = e;
                }
                catch (Exception e) {
                    throw new AdminException("Solr.upgradeSolrSchema - error getting utility class: " + className + ". Error message: " + e.getMessage());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void modifySolrHomeInSolrEnvScript(String solrHome, String envScriptPath) throws Exception {
        if (solrHome != null && !solrHome.trim().equals("")) {
            if (envScriptPath != null && !envScriptPath.trim().equals("")) {
                File envScriptFile = new File(envScriptPath);
                if (!envScriptFile.exists()) throw new AdminException("The solr script file setting environment variables doesn't exist at this path " + envScriptPath + ".\nPlease find the solr.in.sh file and manually modify the file by adding a line - SOLR_HOME=" + solrHome);
                if (!envScriptFile.canWrite() || !envScriptFile.canRead()) throw new AdminException("Tomcat user doesn't have the write/read permission on the solr script file setting environment variables at this location " + envScriptPath + ".\nPlease manually modify the file by adding a line - SOLR_HOME=" + solrHome);
                Scanner scanner = new Scanner(envScriptFile);
                StringBuffer buffer = new StringBuffer();
                while (scanner.hasNextLine()) {
                    String text = scanner.nextLine();
                    if (text.startsWith(SOLR_HOME)) {
                        buffer.append("#" + text);
                    } else {
                        buffer.append(text);
                    }
                    buffer.append("\n");
                }
                buffer.append("SOLR_HOME=\"" + solrHome + "\"");
                scanner.close();
                PrintWriter printer = new PrintWriter(envScriptFile);
                printer.print(buffer);
                printer.close();
                return;
            } else {
                this.logMetacat.error((Object)"SolrAdmin.modifySolrHomeInSolrEnvScript - the path of the solr script file setting environment variables shouldn't be null or blank");
            }
            return;
        } else {
            this.logMetacat.error((Object)"SolrAdmin.modifySolrHomeInSolrEnvScript - the solr home string shouldn't be null or blank.");
        }
    }
}

