/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin.upgrade;

import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.upgrade.UpgradeUtilityInterface;
import edu.ucsb.nceas.metacat.dataone.MNodeService;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.doi.DOIServiceFactory;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.SystemMetadata;

public class UpdateDOI
implements UpgradeUtilityInterface {
    private static Log log = LogFactory.getLog(UpdateDOI.class);
    private int serverLocation = 1;
    private String nodeId = null;
    private String DOISCHEME = "doi:";

    public UpdateDOI() throws Exception {
        Node node = MNodeService.getInstance(null).getCapabilities();
        this.nodeId = node.getIdentifier().getValue();
    }

    public int getServerLocation() {
        return this.serverLocation;
    }

    public void setServerLocation(int serverLocation) {
        this.serverLocation = serverLocation;
    }

    private void updateDOIRegistration(List<String> identifiers) {
        for (String pid : identifiers) {
            try {
                Identifier identifier = new Identifier();
                identifier.setValue(pid);
                SystemMetadata sysMeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)identifier);
                if (sysMeta == null) {
                    Identifier sid = new Identifier();
                    sid.setValue(pid);
                    Identifier head = IdentifierManager.getInstance().getHeadPID(sid);
                    if (head != null) {
                        sysMeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)head);
                    }
                }
                if (sysMeta == null) continue;
                DOIServiceFactory.getDOIService().registerDOI(sysMeta);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean upgrade() throws AdminException {
        boolean success = true;
        try {
            List<String> idList = null;
            idList = IdentifierManager.getInstance().getGUIDs(DocumentImpl.EML2_0_0NAMESPACE, this.nodeId, this.DOISCHEME);
            this.updateDOIRegistration(idList);
            idList = IdentifierManager.getInstance().getGUIDs(DocumentImpl.EML2_0_1NAMESPACE, this.nodeId, this.DOISCHEME);
            this.updateDOIRegistration(idList);
            idList = IdentifierManager.getInstance().getGUIDs(DocumentImpl.EML2_1_0NAMESPACE, this.nodeId, this.DOISCHEME);
            this.updateDOIRegistration(idList);
            idList = IdentifierManager.getInstance().getGUIDs(DocumentImpl.EML2_1_1NAMESPACE, this.nodeId, this.DOISCHEME);
            this.updateDOIRegistration(idList);
            idList = IdentifierManager.getInstance().getGUIDs(DocumentImpl.EML2_2_0NAMESPACE, this.nodeId, this.DOISCHEME);
            this.updateDOIRegistration(idList);
        }
        catch (Exception e) {
            String msg = "Problem updating DOIs: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            success = false;
            throw new AdminException(msg);
        }
        return success;
    }

    public boolean upgradeById(List<String> ids) throws AdminException {
        boolean success = true;
        try {
            this.updateDOIRegistration(ids);
        }
        catch (Exception e) {
            String msg = "Problem updating DOIs: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            success = false;
            throw new AdminException(msg);
        }
        return success;
    }

    public boolean upgradeByFormatId(List<String> formatIds) throws AdminException {
        boolean success = true;
        try {
            for (String formatId : formatIds) {
                List<String> idList = IdentifierManager.getInstance().getGUIDs(formatId, this.nodeId, this.DOISCHEME);
                Collections.sort(idList);
                this.updateDOIRegistration(idList);
            }
        }
        catch (Exception e) {
            String msg = "Problem updating DOIs: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            success = false;
            throw new AdminException(msg);
        }
        return success;
    }
}

