/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.advancedsearch;

import edu.ucsb.nceas.metacat.AuthLdap;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetacatHelper {
    private static Log logMetacat = LogFactory.getLog(AuthLdap.class);

    public String constructDN(String username, String organization) {
        String DC;
        try {
            DC = PropertyService.getProperty("auth.base");
        }
        catch (PropertyNotFoundException pnfe) {
            DC = "dc=ecoinformatics,dc=org";
            logMetacat.error((Object)("Could not find property: auth.base.  Setting to: dc=ecoinformatics,dc=org : " + pnfe.getMessage()));
        }
        String DN = "uid=" + username + ",o=" + organization + "," + DC;
        return DN;
    }

    public String constructMetacatURL(String serverName, int serverPort, String contextString) {
        String metacatURL = "http://" + serverName;
        if (serverPort > 0) {
            Integer serverPortInteger = new Integer(serverPort);
            String serverPortString = serverPortInteger.toString();
            metacatURL = metacatURL + ":" + serverPortString;
        }
        metacatURL = metacatURL + "/" + contextString + "/metacat";
        return metacatURL;
    }

    public String getResultsJSP() {
        String resultsJSP = "style/skins/default/advancedsearchresults.jsp";
        return resultsJSP;
    }

    public String getResultsetXSL(HttpServletRequest request) {
        HttpSession httpSession = request.getSession();
        ServletContext servletContext = httpSession.getServletContext();
        String xslPath = servletContext.getRealPath("style/common/resultset.xsl");
        return xslPath;
    }
}

