/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.doi.datacite;

import edu.ucsb.nceas.ezid.profile.DataCiteProfileResourceTypeValues;
import edu.ucsb.nceas.metacat.dataone.MNodeService;
import edu.ucsb.nceas.metacat.doi.datacite.DataCiteMetadataFactory;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.SystemMetadata;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Party;
import org.ecoinformatics.datamanager.parser.UserId;
import org.ecoinformatics.datamanager.parser.generic.Eml200DataPackageParser;
import org.w3c.dom.Document;

public class EML2DataCiteFactory
extends DataCiteMetadataFactory {
    private static Log logMetacat = LogFactory.getLog(EML2DataCiteFactory.class);

    @Override
    public boolean canProcess(String namespace) {
        boolean can = false;
        if (namespace != null && (namespace.startsWith("eml://ecoinformatics.org/eml-2") || namespace.startsWith("https://eml.ecoinformatics.org/eml"))) {
            can = true;
        }
        logMetacat.debug((Object)("EML2DataCitFactory.canProcess - If this factory can process the xml with the name space " + namespace + "? " + can));
        return can;
    }

    @Override
    public String generateMetadata(Identifier identifier, SystemMetadata sysmeta) throws InvalidRequest, ServiceFailure {
        if (identifier != null && sysmeta != null) {
            try {
                DataPackage emlPackage = this.getEMLPackage(sysmeta);
                if (emlPackage != null) {
                    String format;
                    String language = emlPackage.getLanguage();
                    Document doc = this.generateROOTDoc();
                    String scheme = "DOI";
                    String id = this.removeIdSchemePrefix(identifier.getValue(), scheme);
                    this.addIdentifier(doc, id, scheme);
                    this.appendCreators(sysmeta.getRightsHolder(), emlPackage, doc);
                    String title = emlPackage.getTitle();
                    if (title == null || title.trim().equals("")) {
                        throw new InvalidRequest("1031", "The datacite instance must have a title. It can't be null or blank");
                    }
                    this.appendTitle(title, doc, language);
                    String publisher = this.lookupPublisher(emlPackage);
                    this.addPublisher(doc, publisher);
                    String year = this.lookupPublishingYear(emlPackage, sysmeta);
                    this.addPublicationYear(doc, year);
                    List subjects = emlPackage.getKeywords();
                    if (subjects != null) {
                        for (String subject : subjects) {
                            this.appendSubject(subject, doc, language);
                        }
                    }
                    this.addLanguage(doc, language);
                    String resourceType = null;
                    this.addResourceType(doc, DataCiteProfileResourceTypeValues.DATASET.toString(), resourceType);
                    String description = emlPackage.getAbstract();
                    if (description != null) {
                        this.appendDescription(description, doc, language, "Abstract");
                    }
                    if ((format = EML2DataCiteFactory.lookupFormat(sysmeta)) != null) {
                        this.appendFormat(doc, format);
                    }
                    return this.serializeDoc(doc);
                }
                throw new ServiceFailure("1030", "Metacat can't parse the eml object " + identifier.getValue() + " so we can't get the needed information from it.");
            }
            catch (InvalidRequest e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServiceFailure("1030", e.getMessage());
            }
        }
        return null;
    }

    private DataPackage getEMLPackage(SystemMetadata sysMeta) throws Exception {
        DataPackage dataPackage = null;
        if (sysMeta.getFormatId().getValue().startsWith("eml://") || sysMeta.getFormatId().getValue().startsWith("https://eml.ecoinformatics.org/eml")) {
            Eml200DataPackageParser parser = new Eml200DataPackageParser();
            MockHttpServletRequest request = new MockHttpServletRequest(null, null, null);
            Session session = new Session();
            Subject subject = MNodeService.getInstance((HttpServletRequest)request).getCapabilities().getSubject(0);
            session.setSubject(subject);
            InputStream emlStream = MNodeService.getInstance((HttpServletRequest)request).get(session, sysMeta.getIdentifier());
            parser.parse(emlStream);
            dataPackage = parser.getDataPackage();
        }
        return dataPackage;
    }

    private void appendCreators(Subject subject, DataPackage emlPackage, Document doc) throws InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, NotFound, InvalidToken, XPathExpressionException {
        String nameSep = ", ";
        List parties = emlPackage.getCreators();
        if (parties == null || parties.isEmpty()) {
            throw new InvalidRequest("1031", "The datacite instance must have a creator. It can't be null or blank");
        }
        boolean found = false;
        for (Party party : parties) {
            UserId userId;
            String surName = party.getSurName();
            String positionName = party.getPositionName();
            String organization = party.getOrganization();
            String fullName = null;
            if (surName != null && !surName.trim().equals("")) {
                List givenNames = party.getGivenNames();
                fullName = surName;
                if (givenNames != null && givenNames.size() > 0 && givenNames.get(0) != null && !((String)givenNames.get(0)).trim().equals("")) {
                    fullName = fullName + nameSep + (String)givenNames.get(0);
                }
            } else if (positionName != null && !positionName.trim().equals("")) {
                fullName = positionName;
            } else {
                fullName = organization;
                organization = null;
            }
            String nameIdentifier = null;
            String nameIdentifierSchemeURI = null;
            String nameIdentifierScheme = null;
            List userIds = party.getUserIdList();
            if (userIds != null && !userIds.isEmpty() && (userId = (UserId)userIds.get(0)) != null) {
                String value = userId.getValue();
                String directory = userId.getDirectory();
                if (directory != null && (directory.startsWith("https://orcid.org") || directory.startsWith("http://orcid.org"))) {
                    nameIdentifierScheme = "ORCID";
                    if (!directory.endsWith("/")) {
                        directory = directory + "/";
                    }
                    nameIdentifier = value.indexOf(nameIdentifierSchemeURI = directory) > -1 ? value.replaceFirst(nameIdentifierSchemeURI, "") : value;
                } else {
                    nameIdentifierScheme = directory;
                    nameIdentifier = value;
                }
            }
            this.appendCreator(fullName, doc, organization, nameIdentifier, nameIdentifierSchemeURI, nameIdentifierScheme);
            found = true;
        }
        if (!found) {
            throw new InvalidRequest("1031", "The datacite instance must have a creator. It can't be null or blank");
        }
    }

    String lookupPublishingYear(DataPackage emlPackage, SystemMetadata sysMeta) throws InvalidRequest {
        String publishYear = null;
        String pubDate = emlPackage.getPubDate();
        if (pubDate != null && !pubDate.trim().equals("")) {
            String regex = "^\\d{4}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(pubDate);
            if (matcher.matches()) {
                publishYear = pubDate;
                return publishYear;
            }
            regex = "^\\d{4}-\\d{2}-\\d{2}";
            pattern = Pattern.compile(regex);
            matcher = pattern.matcher(pubDate);
            if (matcher.matches()) {
                publishYear = pubDate.substring(0, 4);
                return publishYear;
            }
        }
        if (publishYear == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            publishYear = sdf.format(sysMeta.getDateUploaded());
        }
        if (publishYear == null || publishYear.trim().equals("")) {
            throw new InvalidRequest("1031", "The datacite instance must have the publishing year. Metacat looked the eml object and the system meta data. But they are blank.");
        }
        return publishYear;
    }

    String lookupPublisher(DataPackage emlPackage) throws ServiceFailure, InvalidRequest {
        String publisherStr = "";
        Party publisher = emlPackage.getPublisher();
        if (publisher != null) {
            String givenNameDelimiter = ", ";
            String delimiter = ". ";
            String surName = publisher.getSurName();
            List givenNames = publisher.getGivenNames();
            String positionName = publisher.getPositionName();
            String organizationName = publisher.getOrganization();
            if (surName != null && !surName.trim().equals("")) {
                publisherStr = publisherStr + surName;
            }
            if (givenNames != null && givenNames.get(0) != null && !((String)givenNames.get(0)).trim().equals("")) {
                publisherStr = publisherStr + givenNameDelimiter + (String)givenNames.get(0);
            }
            if (positionName != null && !positionName.trim().equals("")) {
                if (!publisherStr.trim().equals("")) {
                    publisherStr = publisherStr + delimiter;
                }
                publisherStr = publisherStr + positionName;
            }
            if (organizationName != null && !organizationName.trim().equals("")) {
                if (!publisherStr.trim().equals("")) {
                    publisherStr = publisherStr + delimiter;
                }
                publisherStr = publisherStr + organizationName;
            }
        }
        if (publisherStr == null || publisherStr.trim().equals("")) {
            Node node = MNodeService.getInstance(null).getCapabilities();
            publisherStr = node.getName();
        }
        if (publisherStr == null || publisherStr.trim().equals("")) {
            throw new InvalidRequest("1031", "The datacite instance must have a publisher. Metacat looked the eml object and member node name. But they are blank.");
        }
        return publisherStr;
    }
}

