/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.download;

import edu.ucsb.nceas.metacat.DBTransform;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.common.query.stream.ContentTypeByteArrayInputStream;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.export.HtmlToPdf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.speedbagit.SpeedBagIt;

public class PackageDownloaderV1 {
    public List<Identifier> packagePids;
    public SpeedBagIt speedBag;
    private Identifier pid;
    public StringBuffer pidMapping;
    public Map<Identifier, String> fileNames;
    private Log logMetacat = LogFactory.getLog(this.getClass());

    public PackageDownloaderV1(Identifier pid) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, InvalidRequest, IOException, NotImplemented {
        this.speedBag = new SpeedBagIt(0.97, "MD5");
        this.pidMapping = new StringBuffer();
        this.fileNames = new HashMap<Identifier, String>();
        this.packagePids = new ArrayList<Identifier>();
        this.pid = pid;
    }

    public InputStream download() throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        try {
            return this.speedBag.stream();
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
            ServiceFailure sf = new ServiceFailure("1030", "There was an error while streaming the downloaded data package. " + e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            ServiceFailure sf = new ServiceFailure("1030", "While creating the package download, an unsupported checksumming algorithm was encountered. " + e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
    }

    public void addSciPdf(InputStream metadataStream, SystemMetadata metadataSysMeta, Identifier metadataID) {
        try {
            String format = "default";
            DBTransform transformer = new DBTransform();
            String documentContent = IOUtils.toString((InputStream)metadataStream, (String)"UTF-8");
            String sourceType = metadataSysMeta.getFormatId().getValue();
            String targetType = "-//W3C//HTML//EN";
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            Hashtable<String, String[]> params = new Hashtable<String, String[]>();
            String localId = null;
            try {
                localId = IdentifierManager.getInstance().getLocalId(this.pid.getValue());
            }
            catch (McdbDocNotFoundException e) {
                throw new NotFound("1020", e.getMessage());
            }
            params.put("qformat", new String[]{format});
            params.put("docid", new String[]{localId});
            params.put("pid", new String[]{this.pid.getValue()});
            params.put("displaymodule", new String[]{"printall"});
            transformer.transformXMLDocument(documentContent, sourceType, targetType, format, writer, params, null);
            ContentTypeByteArrayInputStream resultInputStream = new ContentTypeByteArrayInputStream(baos.toByteArray());
            File tmpDir = File.createTempFile("package_", "_dir");
            tmpDir.delete();
            tmpDir.mkdir();
            File cssDir = new File(tmpDir, format);
            cssDir.mkdir();
            File cssFile = new File(tmpDir, format + "/" + format + ".css");
            String originalCssPath = SystemUtil.getContextDir() + "/style/skins/" + format + "/" + format + ".css";
            IOUtils.copy((InputStream)new FileInputStream(originalCssPath), (OutputStream)new FileOutputStream(cssFile));
            String pdfFileName = metadataID.getValue().replaceAll("[^a-zA-Z0-9\\-\\.]", "_") + "-METADATA.pdf";
            File pdfFile = new File(tmpDir, pdfFileName);
            pdfFile = File.createTempFile("metadata", ".pdf", tmpDir);
            File htmlFile = File.createTempFile("metadata", ".html", tmpDir);
            IOUtils.copy((InputStream)resultInputStream, (OutputStream)new FileOutputStream(htmlFile));
            HtmlToPdf.export((String)htmlFile.getAbsolutePath(), (String)pdfFile.getAbsolutePath());
            htmlFile.delete();
            cssFile.delete();
            cssDir.delete();
            byte[] pdfMetadata = Files.readAllBytes(Paths.get(pdfFile.getAbsolutePath(), new String[0]));
            ByteArrayInputStream pdfInputStream = new ByteArrayInputStream(pdfMetadata);
            pdfFile.delete();
            tmpDir.delete();
            this.speedBag.addFile((InputStream)pdfInputStream, Paths.get("data/" + pdfFileName, new String[0]).toString(), false);
            this.pidMapping.append(metadataID.getValue() + " (pdf)\tdata/" + pdfFile.getName() + "\n");
        }
        catch (Exception e) {
            this.logMetacat.error((Object)"There was an error generating the PDF file during a package export. Ensure that the package metadata is valid and supported.", (Throwable)e);
        }
    }
}

