/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.properties;

import edu.ucsb.nceas.metacat.properties.PropertiesInterface;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.ServiceService;
import edu.ucsb.nceas.metacat.shared.BaseService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.MetaDataProperty;
import edu.ucsb.nceas.utilities.PropertiesMetaData;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;

public class ConfigurableProperties
extends BaseService
implements PropertiesInterface {
    private static final String MAIN_CONFIG_FILE_NAME = "metacat.properties";
    private static String mainConfigFilePath = null;
    private static SortedProperties mainProperties = null;
    private static final String MAIN_METADATA_FILE_NAME = "metacat.properties.metadata.xml";
    private static String mainMetadataFilePath = null;
    private static PropertiesMetaData mainMetaData = null;
    private static final String MAIN_BACKUP_FILE_NAME = "metacat.properties.backup";
    private static String mainBackupFilePath = null;
    private static SortedProperties mainBackupProperties = null;
    private static final String AUTH_METADATA_FILE_NAME = "auth.properties.metadata.xml";
    private static String authMetadataFilePath = null;
    private static PropertiesMetaData authMetaData = null;
    private static final String AUTH_BACKUP_FILE_NAME = "auth.properties.backup";
    private static String authBackupFilePath = null;
    private static SortedProperties authBackupProperties = null;
    private static boolean bypassAlreadyChecked = false;
    private static Log logMetacat = LogFactory.getLog(ConfigurableProperties.class);

    protected ConfigurableProperties() throws ServiceException {
        this._serviceName = "ConfigurableProperties";
        this.initialize();
    }

    @Override
    public boolean refreshable() {
        return true;
    }

    @Override
    public void doRefresh() throws ServiceException {
        this.initialize();
    }

    @Override
    public void stop() throws ServiceException {
    }

    private void initialize() throws ServiceException {
        logMetacat.debug((Object)"Initializing ConfigurableProperties");
        try {
            mainConfigFilePath = PropertyService.CONFIG_FILE_DIR + FileUtil.getFS() + MAIN_CONFIG_FILE_NAME;
            mainMetadataFilePath = PropertyService.CONFIG_FILE_DIR + FileUtil.getFS() + MAIN_METADATA_FILE_NAME;
            authMetadataFilePath = PropertyService.CONFIG_FILE_DIR + FileUtil.getFS() + AUTH_METADATA_FILE_NAME;
            mainProperties = new SortedProperties(mainConfigFilePath);
            mainProperties.load();
            try {
                Settings.getConfiguration();
                Settings.augmentConfiguration((String)mainConfigFilePath);
            }
            catch (ConfigurationException e) {
                logMetacat.error((Object)("Could not augment DataONE properties. " + e.getMessage()), (Throwable)e);
            }
            mainMetaData = new PropertiesMetaData(mainMetadataFilePath);
            authMetaData = new PropertiesMetaData(authMetadataFilePath);
            String recommendedExternalDir = SystemUtil.discoverExternalDir();
            PropertyService.setRecommendedExternalDir(recommendedExternalDir);
            String backupPath = this.getProperty("application.backupDir");
            if (backupPath == null || backupPath.equals("")) {
                backupPath = SystemUtil.getStoredBackupDir();
            }
            if ((backupPath == null || backupPath.equals("")) && recommendedExternalDir != null) {
                backupPath = recommendedExternalDir + FileUtil.getFS() + "." + ServiceService.getRealApplicationContext();
            }
            if (backupPath != null && !backupPath.equals("")) {
                this.setProperty("application.backupDir", backupPath);
                SystemUtil.writeStoredBackupFile(backupPath);
                mainBackupFilePath = backupPath + FileUtil.getFS() + MAIN_BACKUP_FILE_NAME;
                mainBackupProperties = new SortedProperties(mainBackupFilePath);
                mainBackupProperties.load();
                authBackupFilePath = backupPath + FileUtil.getFS() + AUTH_BACKUP_FILE_NAME;
                authBackupProperties = new SortedProperties(authBackupFilePath);
                authBackupProperties.load();
            }
        }
        catch (TransformerException te) {
            throw new ServiceException("Transform problem while loading properties: " + te.getMessage());
        }
        catch (IOException ioe) {
            throw new ServiceException("I/O problem while loading properties: " + ioe.getMessage());
        }
        catch (GeneralPropertyException gpe) {
            throw new ServiceException("General properties problem while loading properties: " + gpe.getMessage());
        }
        catch (MetacatUtilException ue) {
            throw new ServiceException("Utilities problem while loading properties: " + ue.getMessage());
        }
    }

    @Override
    public String getProperty(String propertyName) throws PropertyNotFoundException {
        return mainProperties.getProperty(propertyName);
    }

    @Override
    public Vector<String> getPropertyNames() {
        return mainProperties.getPropertyNames();
    }

    @Override
    public Vector<String> getPropertyNamesByGroup(String groupName) {
        return mainProperties.getPropertyNamesByGroup(groupName);
    }

    @Override
    public Map<String, String> getPropertiesByGroup(String groupName) throws PropertyNotFoundException {
        return mainProperties.getPropertiesByGroup(groupName);
    }

    @Override
    public void addProperty(String propertyName, String value) throws GeneralPropertyException {
        mainProperties.addProperty(propertyName, value);
        mainProperties.store();
    }

    @Override
    public void setProperty(String propertyName, String newValue) throws GeneralPropertyException {
        mainProperties.setProperty(propertyName, newValue);
        mainProperties.store();
    }

    @Override
    public void setPropertyNoPersist(String propertyName, String newValue) throws GeneralPropertyException {
        mainProperties.setPropertyNoPersist(propertyName, newValue);
    }

    @Override
    public void persistProperties() throws GeneralPropertyException {
        mainProperties.store();
    }

    @Override
    public SortedProperties getMainBackupProperties() {
        return mainBackupProperties;
    }

    @Override
    public SortedProperties getAuthBackupProperties() {
        return authBackupProperties;
    }

    @Override
    public PropertiesMetaData getMainMetaData() {
        return mainMetaData;
    }

    @Override
    public PropertiesMetaData getAuthMetaData() {
        return authMetaData;
    }

    @Override
    public void persistMainBackupProperties() throws GeneralPropertyException {
        try {
            SortedProperties backupProperties = new SortedProperties(mainBackupFilePath);
            PropertiesMetaData mainMetadata = new PropertiesMetaData(mainMetadataFilePath);
            Map mainKeyMap = mainMetadata.getProperties();
            Set mainKeySet = mainKeyMap.keySet();
            for (String propertyKey : mainKeySet) {
                MetaDataProperty metaData = (MetaDataProperty)mainKeyMap.get(propertyKey);
                if (metaData.getFieldType().equals("password")) continue;
                backupProperties.addProperty(propertyKey, this.getProperty(propertyKey));
            }
            backupProperties.store();
            mainBackupProperties = new SortedProperties(mainBackupFilePath);
            mainBackupProperties.load();
        }
        catch (TransformerException te) {
            throw new GeneralPropertyException("Could not transform backup properties xml: " + te.getMessage());
        }
        catch (IOException ioe) {
            throw new GeneralPropertyException("Could not backup configurable properties: " + ioe.getMessage());
        }
    }

    @Override
    public void persistAuthBackupProperties(ServletContext servletContext) throws GeneralPropertyException {
        try {
            SortedProperties backupProperties = new SortedProperties(authBackupFilePath);
            PropertiesMetaData authMetadata = new PropertiesMetaData(authMetadataFilePath);
            Map authKeyMap = authMetadata.getProperties();
            Set authKeySet = authKeyMap.keySet();
            for (String propertyKey : authKeySet) {
                MetaDataProperty metaData = (MetaDataProperty)authKeyMap.get(propertyKey);
                if (metaData.getFieldType().equals("password")) continue;
                backupProperties.addProperty(propertyKey, this.getProperty(propertyKey));
            }
            backupProperties.store();
            authBackupProperties = new SortedProperties(authBackupFilePath);
            authBackupProperties.load();
        }
        catch (TransformerException te) {
            throw new GeneralPropertyException("Could not transform backup properties xml: " + te.getMessage());
        }
        catch (IOException ioe) {
            throw new GeneralPropertyException("Could not backup configurable properties: " + ioe.getMessage());
        }
    }

    @Override
    public boolean arePropertiesConfigured() throws GeneralPropertyException {
        String propertiesConfigured = this.getProperty("configutil.propertiesConfigured");
        return propertiesConfigured != null && !propertiesConfigured.equals("false");
    }

    @Override
    public boolean doBypass() throws PropertyNotFoundException {
        if (bypassAlreadyChecked) {
            logMetacat.debug((Object)"bypassConfiguration not performing full bypass check.  Bypass set to false");
            return false;
        }
        String strRunConfiguration = this.getProperty("dev.runConfiguration");
        boolean runConfiguration = Boolean.parseBoolean(strRunConfiguration);
        logMetacat.debug((Object)("bypassConfiguration: dev.runConfiguration property set to: " + strRunConfiguration));
        if (runConfiguration) {
            bypassAlreadyChecked = true;
            return false;
        }
        return true;
    }

    @Override
    public void bypassConfiguration() throws GeneralPropertyException {
        try {
            boolean doBypass = this.doBypass();
            if (!doBypass) {
                throw new GeneralPropertyException("Attempting to do bypass when system is not configured for it.");
            }
            logMetacat.debug((Object)"bypassConfiguration: setting main backup properties.");
            SortedProperties mainBackupProperties = this.getMainBackupProperties();
            Vector backupPropertyNames = mainBackupProperties.getPropertyNames();
            for (String backupPropertyName : backupPropertyNames) {
                String value = mainBackupProperties.getProperty(backupPropertyName);
                this.setPropertyNoPersist(backupPropertyName, value);
            }
            logMetacat.debug((Object)"bypassConfiguration: setting auth backup properties.");
            SortedProperties authBackupProperties = this.getAuthBackupProperties();
            Vector authBackupPropertyNames = authBackupProperties.getPropertyNames();
            for (String authBackupPropertyName : authBackupPropertyNames) {
                String value = authBackupProperties.getProperty(authBackupPropertyName);
                this.setPropertyNoPersist(authBackupPropertyName, value);
            }
            logMetacat.debug((Object)"bypassConfiguration: setting configutil sections to true.");
            this.setPropertyNoPersist("configutil.propertiesConfigured", "true");
            this.setPropertyNoPersist("configutil.authConfigured", "true");
            this.setPropertyNoPersist("configutil.skinsConfigured", "true");
            this.setPropertyNoPersist("configutil.databaseConfigured", "true");
            this.setPropertyNoPersist("configutil.geoserverConfigured", "bypassed");
            this.persistProperties();
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("bypassConfiguration: Could not find property: " + pnfe.getMessage()));
        }
        catch (GeneralPropertyException gpe) {
            logMetacat.error((Object)("bypassConfiguration: General property error: " + gpe.getMessage()));
        }
        bypassAlreadyChecked = true;
    }

    @Override
    public boolean checkAndSetProperty(HttpServletRequest request, String propertyName) throws GeneralPropertyException {
        boolean changed = false;
        String value = this.getProperty(propertyName);
        String newValue = request.getParameter(propertyName);
        if (newValue != null && !newValue.trim().equals(value)) {
            this.setPropertyNoPersist(propertyName, newValue.trim());
            changed = true;
        }
        return changed;
    }
}

