/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.service;

import edu.ucsb.nceas.metacat.client.MetacatException;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.XMLNamespaceParser;
import edu.ucsb.nceas.metacat.service.XMLNoNamespaceSchema;
import edu.ucsb.nceas.metacat.service.XMLSchema;
import edu.ucsb.nceas.metacat.shared.BaseService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.StringUtil;
import java.io.IOException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class XMLSchemaService
extends BaseService {
    public static final String NAMESPACEKEYWORD = "xmlns";
    public static final String SCHEMA_DIR = "/schema/";
    public static String NONXML = "NonXML";
    private static XMLSchemaService xmlSchemaService = null;
    private static Log logMetacat = LogFactory.getLog(XMLSchemaService.class);
    private static boolean useFullSchemaValidation = false;
    private static Vector<XMLSchema> registeredSchemaList = new Vector();
    private static Vector<XMLNoNamespaceSchema> registeredNoNamespaceSchemaList = new Vector();
    private static Vector<String> nameSpaceList = new Vector();
    private static String nameSpaceAndLocationStringWithoutFormatId = "";
    private static Hashtable<String, String> formatId_NamespaceLocationHash = new Hashtable();
    private static Vector<String> nonXMLMetadataFormatList = new Vector();

    private XMLSchemaService() {
        this._serviceName = "XMLSchemaService";
        try {
            this.doRefresh();
        }
        catch (ServiceException e) {
            logMetacat.debug((Object)e.getMessage());
        }
    }

    public static XMLSchemaService getInstance() {
        if (xmlSchemaService == null) {
            xmlSchemaService = new XMLSchemaService();
        }
        return xmlSchemaService;
    }

    @Override
    public boolean refreshable() {
        return true;
    }

    @Override
    public synchronized void doRefresh() throws ServiceException {
        logMetacat.debug((Object)"XMLService.doRefresh - refreshing the schema service.");
        try {
            this.populateRegisteredSchemaList();
            this.populateRegisteredNoNamespaceSchemaList();
            this.setUseFullSchemaValidation();
            XMLSchemaService.createRegisteredNameSpaceList();
            XMLSchemaService.createRegisteredNameSpaceAndLocationString();
            this.populateNonXMLMetadataFormatList();
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)"XMLService.doRefresh - Could not find property: xml.useFullSchemaValidation. Setting to false.");
        }
    }

    @Override
    public void stop() throws ServiceException {
    }

    public Vector<XMLSchema> getRegisteredSchemaList() {
        return registeredSchemaList;
    }

    public Vector<XMLNoNamespaceSchema> getRegisteredNoNamespaceSchemaList() {
        return registeredNoNamespaceSchemaList;
    }

    public String getNameSpaceAndLocationStringWithoutFormatId() {
        return nameSpaceAndLocationStringWithoutFormatId;
    }

    public String getNameSpaceAndLocation(String formatId) {
        if (formatId == null) {
            return null;
        }
        return formatId_NamespaceLocationHash.get(formatId);
    }

    public Vector<String> getNameSpaceList() {
        return nameSpaceList;
    }

    public Vector<String> getNonXMLMetadataFormatList() {
        return nonXMLMetadataFormatList;
    }

    public boolean useFullSchemaValidation() {
        return useFullSchemaValidation;
    }

    private void setUseFullSchemaValidation() throws PropertyNotFoundException {
        String strUseFullSchemaValidation = PropertyService.getProperty("xml.useFullSchemaValidation");
        useFullSchemaValidation = Boolean.valueOf(strUseFullSchemaValidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateRegisteredSchemaList() {
        DBConnection conn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        ResultSet resultSet = null;
        registeredSchemaList = new Vector();
        String sql = "SELECT public_id, system_id, format_id FROM xml_catalog where entry_type ='" + XMLSchema.getType() + "'";
        try {
            conn = DBConnectionPool.getDBConnection("XMLService.populateRegisteredSchemaList");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement(sql);
            logMetacat.debug((Object)("XMLService.populateRegisteredSchemaList - Selecting schemas: " + pstmt.toString()));
            pstmt.execute();
            resultSet = pstmt.getResultSet();
            while (resultSet.next()) {
                String fileNamespace = resultSet.getString(1);
                String fileLocation = resultSet.getString(2);
                String formatId = resultSet.getString(3);
                logMetacat.debug((Object)("XMLService.populateRegisteredSchemaList - Registering schema: " + fileNamespace + " " + fileLocation + " and format id " + formatId));
                XMLSchema xmlSchema = new XMLSchema(fileNamespace, fileLocation, formatId);
                if (fileLocation.startsWith("http://") || fileLocation.startsWith("https://")) continue;
                xmlSchema.setFileName(fileLocation);
                if (FileUtil.getFileStatus((String)xmlSchema.getLocalFileDir()) >= FileUtil.EXISTS_READABLE) {
                    registeredSchemaList.add(xmlSchema);
                    continue;
                }
                if (fileLocation.startsWith("http://") || fileLocation.startsWith("https://")) {
                    logMetacat.warn((Object)("XMLService.populateRegisteredSchemaList - Schema file: " + fileLocation + " resides on a different server. So we don't add it to the registered schema list."));
                    continue;
                }
                logMetacat.warn((Object)("XMLService.populateRegisteredSchemaList - Schema file: " + xmlSchema.getLocalFileDir() + " is registered  in the database but does not exist on the file system. So we don't add it to the registered schema list."));
            }
        }
        catch (SQLException e) {
            logMetacat.error((Object)("XMLService.populateRegisteredSchemaList - SQL Error: " + e.getMessage()));
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException sqlE) {
                logMetacat.error((Object)("XMLSchemaService.populateRegisteredSchemaList - Error in XMLService.populateRegisteredSchemaList(): " + sqlE.getMessage()));
            }
            DBConnectionPool.returnDBConnection(conn, serialNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateRegisteredNoNamespaceSchemaList() {
        DBConnection conn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        ResultSet resultSet = null;
        registeredNoNamespaceSchemaList = new Vector();
        String sql = "SELECT no_namespace_schema_location, system_id, format_id FROM xml_catalog where entry_type ='" + XMLNoNamespaceSchema.getType() + "'";
        try {
            conn = DBConnectionPool.getDBConnection("XMLService.populateRegisteredNoNamespaceSchemaList");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement(sql);
            logMetacat.debug((Object)("XMLService.populateRegisteredNoNamespaceSchemaList - Selecting schemas: " + pstmt.toString()));
            pstmt.execute();
            resultSet = pstmt.getResultSet();
            while (resultSet.next()) {
                String noNamespaceSchemaLocationURI = resultSet.getString(1);
                String fileLocation = resultSet.getString(2);
                String formatId = resultSet.getString(3);
                logMetacat.debug((Object)("XMLService.populateRegisteredNoNamespaceSchemaList - try to register schema: " + noNamespaceSchemaLocationURI + "(no namespace-schema-location-uri) " + fileLocation + " and format id " + formatId));
                XMLNoNamespaceSchema xmlSchema = new XMLNoNamespaceSchema(noNamespaceSchemaLocationURI, fileLocation, formatId);
                if (fileLocation.startsWith("http://") || fileLocation.startsWith("https://")) continue;
                xmlSchema.setFileName(fileLocation);
                if (FileUtil.getFileStatus((String)xmlSchema.getLocalFileDir()) >= FileUtil.EXISTS_READABLE) {
                    registeredNoNamespaceSchemaList.add(xmlSchema);
                    continue;
                }
                if (fileLocation.startsWith("http://") || fileLocation.startsWith("https://")) {
                    logMetacat.warn((Object)("XMLService.populateRegisteredNoNamespaceSchemaList - Schema file: " + fileLocation + " resides on a different server. So we don't add it to the registered no-namespace schema list."));
                    continue;
                }
                logMetacat.warn((Object)("XMLService.populateRegisteredNoNamespaceSchemaList - Schema file: " + xmlSchema.getLocalFileDir() + " is registered  in the database but does not exist on the file system. So we don't add it to the registered no-namespace schema list."));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logMetacat.error((Object)("XMLService.populateRegisteredNoNamespaceSchemaList - SQL Error: " + e.getMessage()));
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException sqlE) {
                logMetacat.error((Object)("XMLSchemaService.populateRegisteredNoNamespaceSchemaList - Error in close the pstmt: " + sqlE.getMessage()));
            }
            DBConnectionPool.returnDBConnection(conn, serialNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateNonXMLMetadataFormatList() {
        DBConnection conn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        ResultSet resultSet = null;
        nonXMLMetadataFormatList = new Vector();
        String sql = "SELECT format_id FROM xml_catalog where entry_type ='" + NONXML + "'";
        try {
            conn = DBConnectionPool.getDBConnection("XMLService.populateNonXMLMetadataFormatList");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement(sql);
            pstmt.execute();
            resultSet = pstmt.getResultSet();
            while (resultSet.next()) {
                String formatId = resultSet.getString(1);
                logMetacat.debug((Object)("XMLService.populateNonXMLMetadataFormatList - find the format id: " + formatId + " as an non-xml metadata format id in the database."));
                if (nonXMLMetadataFormatList.contains(formatId)) continue;
                logMetacat.debug((Object)("XMLService.populateNonXMLMetadataFormatList - put the format id: " + formatId + " into the non-xml metadata format id list."));
                nonXMLMetadataFormatList.add(formatId);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logMetacat.error((Object)("XMLService.populateRegisteredNoNamespaceSchemaList - SQL Error: " + e.getMessage()));
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException sqlE) {
                logMetacat.error((Object)("XMLSchemaService.populateNonXMLMetadataFormatList - Error in close the pstmt: " + sqlE.getMessage()));
            }
            DBConnectionPool.returnDBConnection(conn, serialNumber);
        }
    }

    private static void createRegisteredNameSpaceAndLocationString() {
        boolean firstRowWithoutFormatid = true;
        boolean firstRowWithFormatid = true;
        nameSpaceAndLocationStringWithoutFormatId = "";
        formatId_NamespaceLocationHash = new Hashtable();
        for (XMLSchema xmlSchema : registeredSchemaList) {
            String formatId = xmlSchema.getFormatId();
            if (formatId == null || formatId.trim().equals("")) {
                if (!firstRowWithoutFormatid) {
                    nameSpaceAndLocationStringWithoutFormatId = nameSpaceAndLocationStringWithoutFormatId + " ";
                }
                nameSpaceAndLocationStringWithoutFormatId = nameSpaceAndLocationStringWithoutFormatId + xmlSchema.getFileNamespace() + " " + xmlSchema.getLocalFileUri();
                firstRowWithoutFormatid = false;
                continue;
            }
            if (!formatId_NamespaceLocationHash.containsKey(xmlSchema.getFormatId())) {
                formatId_NamespaceLocationHash.put(formatId, xmlSchema.getFileNamespace() + " " + xmlSchema.getLocalFileUri());
                continue;
            }
            String value = formatId_NamespaceLocationHash.get(formatId);
            value = value + " " + xmlSchema.getFileNamespace() + " " + xmlSchema.getLocalFileUri();
            formatId_NamespaceLocationHash.put(formatId, value);
        }
    }

    private static void createRegisteredNameSpaceList() {
        nameSpaceList = new Vector();
        for (XMLSchema xmlSchema : registeredSchemaList) {
            nameSpaceList.add(xmlSchema.getFileNamespace());
        }
    }

    public static boolean areAllSchemasRegistered(Vector<XMLSchema> schemaList) {
        for (XMLSchema xmlSchema : schemaList) {
            if (XMLSchemaService.isSchemaRegistered(xmlSchema)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSchemaRegistered(XMLSchema xmlSchema) {
        for (XMLSchema registeredXmlSchema : registeredSchemaList) {
            if (!registeredXmlSchema.getLocalFileUri().equals(xmlSchema.getLocalFileUri()) || !registeredXmlSchema.getFileNamespace().equals(xmlSchema.getFileNamespace())) continue;
            return true;
        }
        return false;
    }

    public static boolean isNamespaceRegistered(String namespace) {
        boolean registered = false;
        if (namespace != null && !namespace.trim().equals("")) {
            if (nameSpaceList != null && !nameSpaceList.isEmpty()) {
                for (String registeredNamespace : nameSpaceList) {
                    logMetacat.debug((Object)("XMLSchemaService.isNamespaceRegistered - Loop the registered namespaces in Metacat: " + registeredNamespace + " to compare the given namespace " + namespace));
                    if (registeredNamespace == null || !registeredNamespace.equals(namespace)) continue;
                    registered = true;
                    break;
                }
            } else {
                logMetacat.error((Object)"XMLSchemaService.isNamespaceRegistered - The registered namespace list is null or empty! So we will reject any document which needs validataion");
            }
        } else {
            logMetacat.debug((Object)"XMLSchemaService.isNamespaceRegistered - The given namespace is null or blank. So it is not registered.");
        }
        logMetacat.debug((Object)("XMLSchemaService.isNamespaceRegistered - Is the namespace " + namespace + " registered in Metacat? " + registered));
        return registered;
    }

    public String findNamespaceAndSchemaLocalLocation(String formatId, String namespace) throws MetacatException {
        String location = null;
        location = this.getNameSpaceAndLocation(formatId);
        logMetacat.debug((Object)("XMLSchemaService.findNamespaceAndSchemaLocation - the location based the format id " + formatId + " is " + location));
        if (location == null) {
            logMetacat.debug((Object)("XMLSchemaService.findNamespaceAndSchemaLocation - the location based on the format id " + formatId + " is null and we will lookup the given namespace " + namespace));
            if (XMLSchemaService.isNamespaceRegistered(namespace)) {
                location = this.getNameSpaceAndLocationStringWithoutFormatId();
                logMetacat.debug((Object)("XMLSchemaService.findNamespaceAndSchemaLocation - the given namespace " + namespace + " is registered in Metacat"));
            } else {
                logMetacat.debug((Object)("XMLSchemaService.findNamespaceAndSchemaLocation - the given namespace " + namespace + " is NOT registered in Metacat"));
            }
        }
        if (location == null) {
            logMetacat.error((Object)("XMLSchemaService.findNamespaceAndSchemaLocation - We can't find the schema location for the namespace " + namespace + " and format id " + formatId + ". This means they are not registered in Metacat."));
            throw new MetacatException("The namespace " + namespace + " and the format id " + formatId + " are not registered in the Metacat. So the object using the namespace was rejected since Metacat can't validate the xml instance. Please contact the Metacat operator to register them.");
        }
        logMetacat.debug((Object)("XMLSchemaService.findNamespaceAndSchemaLocation - The final location string for the namespace " + namespace + " and format id " + formatId + " is " + location));
        return location;
    }

    public String findNoNamespaceSchemaLocalLocation(String formatId, String noNamespaceSchemaLocation) throws MetacatException {
        String location = null;
        logMetacat.debug((Object)("XMLSchemaService.findNoNamespaceSchemaLocalLocation - the given format id for determining the schema local location is " + formatId));
        logMetacat.debug((Object)("XMLSchemaService.findNoNamespaceSchemaLocalLocation - the given noNamespaceSchemaLocationURI for determining the schema local location is " + noNamespaceSchemaLocation));
        if (registeredNoNamespaceSchemaList != null && !registeredNoNamespaceSchemaList.isEmpty()) {
            if (formatId != null && !formatId.trim().equals("")) {
                logMetacat.debug((Object)("XMLSchemaService.findNoNamespaceSchemaLocalLocation - the given format id " + formatId + "is not null and let's compare format id first."));
                for (XMLNoNamespaceSchema schema : registeredNoNamespaceSchemaList) {
                    if (schema == null) continue;
                    String registeredFormatId = schema.getFormatId();
                    logMetacat.debug((Object)("XMLSchemaService.findNoNamespaceSchemaLocalLocation - the registered no-namespace schema has the format id " + registeredFormatId));
                    if (registeredFormatId == null || registeredFormatId.trim().equals("")) continue;
                    logMetacat.debug((Object)("XMLSchemaService.findNoNamespaceSchemaLocalLocation - the registered format id " + registeredFormatId + "is not null as well. Compare it"));
                    if (!formatId.equals(registeredFormatId)) continue;
                    logMetacat.debug((Object)("XMLSchemaService.findNoNamespaceSchemaLocalLocation - the given and registered format id is the same: " + formatId + ". Match sucessfully!"));
                    location = schema.getLocalFileUri();
                    break;
                }
            }
            if (location == null) {
                logMetacat.debug((Object)("XMLSchemaService.findNoNamespaceSchemaLocalLocation - we can't find any regisered no-namespace schema has the foramtid " + formatId + " (if it is null, this means there is no given format id.) Let's compare the noNamespaceSchemaLocaionURL which the given value is " + noNamespaceSchemaLocation));
                if (noNamespaceSchemaLocation != null && !noNamespaceSchemaLocation.trim().equals("")) {
                    logMetacat.debug((Object)("XMLSchemaService.findNoNamespaceSchemaLocalLocation - the given noNamespaceSchemaLocation URI " + noNamespaceSchemaLocation + "is not null and let's compare it."));
                    for (XMLNoNamespaceSchema schema : registeredNoNamespaceSchemaList) {
                        if (schema == null) continue;
                        String registeredSchemaLocationURI = schema.getNoNamespaceSchemaLocation();
                        logMetacat.debug((Object)("XMLSchemaService.findNoNamespaceSchemaLocalLocation - the registered no-namespace schema has noNamespaceSchemaLocation uri " + registeredSchemaLocationURI));
                        if (registeredSchemaLocationURI == null || registeredSchemaLocationURI.trim().equals("")) continue;
                        logMetacat.debug((Object)("XMLSchemaService.findNoNamespaceSchemaLocalLocation - the registered registeredSchemaLocation URI " + registeredSchemaLocationURI + "is not null as well. Compare it"));
                        if (!noNamespaceSchemaLocation.equals(registeredSchemaLocationURI)) continue;
                        logMetacat.debug((Object)("XMLSchemaService.findNoNamespaceSchemaLocalLocation - the given and registered noNamespaceSchemaLocation is the same: " + noNamespaceSchemaLocation + ". Match sucessfully!"));
                        location = schema.getLocalFileUri();
                        break;
                    }
                }
            }
        } else {
            logMetacat.warn((Object)"XMLSchemaService.findNoNamespaceSchemaLocalLocation - there is no registered no-namespace schema in the Metacat");
        }
        if (location == null) {
            logMetacat.error((Object)("XMLSchemaService.findNoNamespaceSchemaLocalLocation - We can't find Metacat local schema location for the noNamespaceLocation " + noNamespaceSchemaLocation + " and format id " + formatId + ". This means they are not registered in Metacat."));
            throw new MetacatException("The noNamespaceSchemaLocation " + noNamespaceSchemaLocation + " or the format id " + formatId + " is not registered in the Metacat. So the object using them was rejected since Metacat can't validate the xml instance. Please contact the Metacat operator to register them.");
        }
        logMetacat.debug((Object)("XMLSchemaService.findNoNamespaceSchemaLocalLocation - the schema location is " + location + " (if it is null, this means it is not registered) for the format id " + formatId + " or noNamespaceSchemaLocation URI " + noNamespaceSchemaLocation));
        return location;
    }

    public static Vector<XMLSchema> findSchemasInXML(StringReader xml) throws IOException {
        Vector<XMLSchema> schemaList = new Vector<XMLSchema>();
        if (xml == null) {
            logMetacat.debug((Object)"XMLSchemaService.findSchemasInXML - Returning empty schemaList.");
            return schemaList;
        }
        String targetLine = XMLSchemaService.getSchemaLine(xml);
        if (targetLine != null) {
            String regex = "(\\p{Graph}*):schemaLocation=\"([^\"]*)\"";
            Pattern pattern = Pattern.compile(regex, 34);
            Matcher matcher = pattern.matcher(targetLine);
            int i = 0;
            while (i < targetLine.length() && matcher.find(i)) {
                String uri = matcher.group(2);
                uri = StringUtil.replaceTabsNewLines((String)uri);
                uri = StringUtil.replaceDuplicateSpaces((String)uri);
                Vector parsedUri = StringUtil.toVector((String)uri, (char)' ');
                for (int j = 0; j < parsedUri.size(); j += 2) {
                    if (j + 1 >= parsedUri.size()) {
                        throw new IOException("Odd number of elements found when parsing schema location: " + targetLine + ". There should be an even number of uri/files in location.");
                    }
                    String formatId = null;
                    XMLSchema xmlSchema = new XMLSchema((String)parsedUri.get(j), (String)parsedUri.get(j + 1), formatId);
                    schemaList.add(xmlSchema);
                }
                i = matcher.end();
            }
        }
        logMetacat.debug((Object)("XMLSchemaService.findSchemasInXML - Schemas for xml are " + schemaList.toString()));
        return schemaList;
    }

    public static String findDocumentNamespace(StringReader xml) throws IOException, PropertyNotFoundException, SAXException {
        String namespace = null;
        if (xml == null) {
            logMetacat.debug((Object)"XMLSchemaService.findDocumentNamespace - XML doc is null.  There is no namespace.");
            return namespace;
        }
        XMLNamespaceParser namespaceParser = new XMLNamespaceParser(xml);
        namespaceParser.parse();
        namespace = namespaceParser.getNamespace();
        logMetacat.debug((Object)("XMLSchemaService.findDocumentNamespace - the namespace (null means no namespace) in the document is " + namespace));
        return namespace;
    }

    public static String findNoNamespaceSchemaLocationAttr(StringReader xml) throws PropertyNotFoundException, SAXException, IOException {
        String noNamespaceSchemaLocation = null;
        XMLNamespaceParser namespaceParser = new XMLNamespaceParser(xml);
        namespaceParser.parse();
        noNamespaceSchemaLocation = namespaceParser.getNoNamespaceSchemaLocation();
        logMetacat.debug((Object)("XMLSchemaService.findNoNamespaceSchemaLocation - the noNamespaceSchemaLocation (null means no namespace) in the document is " + noNamespaceSchemaLocation));
        return noNamespaceSchemaLocation;
    }

    private static String getSchemaLine(StringReader xml) throws IOException {
        String secondLine = null;
        int count = 0;
        boolean TARGETNUM = true;
        StringBuffer buffer = new StringBuffer();
        boolean comment = false;
        boolean processingInstruction = false;
        int thirdPreviousCharacter = 63;
        int secondPreviousCharacter = 63;
        int previousCharacter = 63;
        int currentCharacter = 63;
        int tmp = xml.read();
        while (tmp != -1) {
            currentCharacter = (char)tmp;
            if (currentCharacter == 45 && previousCharacter == 45 && secondPreviousCharacter == 33 && thirdPreviousCharacter == 60) {
                comment = true;
            }
            if (comment && currentCharacter == 62 && previousCharacter == 45 && secondPreviousCharacter == 45) {
                comment = false;
            }
            if (currentCharacter == 63 && previousCharacter == 60) {
                processingInstruction = true;
            }
            if (processingInstruction && currentCharacter == 62 && previousCharacter == 63) {
                processingInstruction = false;
            }
            if (currentCharacter != 33 && previousCharacter == 60 && !comment && !processingInstruction) {
                ++count;
            }
            if (count == 1 && currentCharacter != 62) {
                buffer.append((char)currentCharacter);
            }
            if (count == 1 && currentCharacter == 62) break;
            thirdPreviousCharacter = secondPreviousCharacter;
            secondPreviousCharacter = previousCharacter;
            previousCharacter = currentCharacter;
            tmp = xml.read();
        }
        secondLine = buffer.toString();
        logMetacat.debug((Object)("XMLSchemaService.getSchemaLine - the second line string is: " + secondLine));
        xml.reset();
        return secondLine;
    }

    public static String getSchemaFileNameFromUri(String uri) {
        int slash;
        String filename = uri;
        if (filename != null && !filename.trim().equals("") && (slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92))) > -1) {
            filename = filename.substring(slash + 1);
        }
        return filename;
    }

    public static String getBaseUrlFromSchemaURL(String url) {
        int slash;
        String baseURL = null;
        if (url != null && (url.indexOf("http://") != -1 || url.indexOf("https://") != -1) && (slash = url.lastIndexOf(47)) > -1) {
            baseURL = url.substring(0, slash + 1);
        }
        return baseURL;
    }
}

