/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.spatial;

import edu.ucsb.nceas.metacat.spatial.SpatialFeatureSchema;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class SpatialDataset {
    private static SpatialFeatureSchema featureSchema = new SpatialFeatureSchema();
    private static ShapefileDataStore polygonStore = null;
    private static ShapefileDataStore pointStore = null;
    private static FeatureStore featureStore = null;
    FeatureCollection polygonCollection = FeatureCollections.newCollection();
    FeatureCollection pointCollection = FeatureCollections.newCollection();
    private static Log log = LogFactory.getLog((String)SpatialDataset.class.getName());

    public SpatialDataset() throws IOException {
        polygonStore = new ShapefileDataStore(new File(SpatialFeatureSchema.polygonShpUri).toURL());
        pointStore = new ShapefileDataStore(new File(SpatialFeatureSchema.pointShpUri).toURL());
    }

    public void add(String geomType, SimpleFeature feature) {
        if (geomType.equals("polygon")) {
            if (feature != null) {
                this.polygonCollection.add((Feature)feature);
            }
        } else if (geomType.equals("point") && feature != null) {
            this.pointCollection.add((Feature)feature);
        }
    }

    public void delete(String geomType, String docid) throws IOException {
        FilterFactory filterFactory = FilterFactoryFinder.createFilterFactory();
        CompareFilter filter = null;
        Object fStore = null;
        Object dStore = null;
        try {
            filter = filterFactory.createCompareFilter((short)14);
            filter.addLeftValue((Expression)filterFactory.createAttributeExpression("docid"));
            filter.addRightValue((Expression)filterFactory.createLiteralExpression(docid));
        }
        catch (IllegalFilterException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        if (geomType.equals("polygon")) {
            this.deleteFromDataStore(polygonStore, filter, docid);
        } else if (geomType.equals("point")) {
            this.deleteFromDataStore(pointStore, filter, docid);
        } else {
            throw new IOException("Unkown Geo Type " + geomType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFromDataStore(ShapefileDataStore dStore, CompareFilter filter, String docid) throws IOException {
        if (dStore != null && filter != null) {
            ShapefileDataStore shapefileDataStore = dStore;
            synchronized (shapefileDataStore) {
                DefaultTransaction t = new DefaultTransaction("handle");
                t.putProperty((Object)"updating spatial cache", (Object)new Integer(7));
                String lockId = "SpatialDataset.delete";
                FeatureStore fStore = (FeatureStore)dStore.getFeatureSource(dStore.getTypeNames()[0]);
                try {
                    if (fStore != null) {
                        fStore.setTransaction((Transaction)t);
                        t.addAuthorization(lockId);
                        fStore.removeFeatures((Filter)filter);
                        t.commit();
                        log.info((Object)(" Delete docid " + docid + " from spatial cache"));
                    } else {
                        log.error((Object)"Feature store is null");
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    t.rollback();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    t.rollback();
                }
                finally {
                    t.close();
                }
            }
        }
        if (dStore == null) {
            log.error((Object)"Shape file store is null");
        }
    }

    public void insertOrUpdate(String geomType, SimpleFeature feature, String docid) throws IOException {
        FeatureCollection fColl = FeatureCollections.newCollection();
        FilterFactory filterFactory = FilterFactoryFinder.createFilterFactory();
        CompareFilter filter = null;
        Object fStore = null;
        Object dStore = null;
        try {
            filter = filterFactory.createCompareFilter((short)14);
            filter.addLeftValue((Expression)filterFactory.createAttributeExpression("docid"));
            filter.addRightValue((Expression)filterFactory.createLiteralExpression(docid));
        }
        catch (IllegalFilterException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        if (geomType.equals("polygon")) {
            log.debug((Object)"SpatialDataset.insertOrUpdate - inserting or updating polygon store");
            this.insertOrUpdateDataStore(polygonStore, filter, feature, fColl, docid);
        } else if (geomType.equals("point")) {
            log.debug((Object)"SpatialDataset.insertOrUpdate - inserting or updating point store");
            this.insertOrUpdateDataStore(pointStore, filter, feature, fColl, docid);
        } else {
            throw new IOException("Unkown Geo Type " + geomType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertOrUpdateDataStore(ShapefileDataStore dStore, CompareFilter filter, SimpleFeature feature, FeatureCollection fColl, String docid) throws IOException {
        if (dStore != null && filter != null && feature != null && fColl != null) {
            ShapefileDataStore shapefileDataStore = dStore;
            synchronized (shapefileDataStore) {
                DefaultTransaction t = new DefaultTransaction("handle");
                t.putProperty((Object)"updating spatial cache", (Object)new Integer(7));
                String lockId = "SpatialDataset.insertOrUpdate";
                try {
                    FeatureStore fStore = (FeatureStore)dStore.getFeatureSource(dStore.getTypeNames()[0]);
                    if (fStore != null) {
                        fStore.setTransaction((Transaction)t);
                        t.addAuthorization(lockId);
                        fStore.removeFeatures((Filter)filter);
                        fColl.add((Feature)feature);
                        fStore.addFeatures(fColl);
                        t.commit();
                        log.info((Object)(" Insert or Update docid " + docid + " from spatial cache"));
                    } else {
                        log.error((Object)"Feature store is null");
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    t.rollback();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    t.rollback();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    t.rollback();
                }
                finally {
                    t.close();
                }
            }
        }
        if (dStore == null) {
            log.error((Object)"Shape file store is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        block15: {
            block14: {
                try {
                    if (polygonStore != null) {
                        ShapefileDataStore shapefileDataStore = polygonStore;
                        synchronized (shapefileDataStore) {
                            SimpleFeatureType polygonType = featureSchema.getPolygonFeatureType();
                            polygonStore.createSchema(polygonType);
                            FeatureStore polygonFeatureStore = (FeatureStore)polygonStore.getFeatureSource(polygonType.getTypeName());
                            polygonFeatureStore.addFeatures(this.polygonCollection);
                            log.info((Object)(" ---- Polygons saved to " + SpatialFeatureSchema.polygonShpUri));
                            break block14;
                        }
                    }
                    log.error((Object)"Couldn't find the polygon shape file store");
                }
                catch (MalformedURLException e) {
                    log.error((Object)("Malformed URL Exception : " + e));
                }
                catch (IOException e) {
                    log.error((Object)("IO Exception : " + e));
                }
            }
            try {
                if (pointStore != null) {
                    ShapefileDataStore e = pointStore;
                    synchronized (e) {
                        SimpleFeatureType pointsType = featureSchema.getPointFeatureType();
                        pointStore.createSchema(pointsType);
                        FeatureStore pointFeatureStore = (FeatureStore)pointStore.getFeatureSource(pointsType.getTypeName());
                        pointFeatureStore.addFeatures(this.pointCollection);
                        log.info((Object)(" ---- Polygons saved to " + SpatialFeatureSchema.pointShpUri));
                        break block15;
                    }
                }
                log.error((Object)"Couldn't find the shape point file store");
            }
            catch (MalformedURLException e) {
                log.error((Object)("Malformed URL Exception : " + e));
            }
            catch (IOException e) {
                log.error((Object)("IO Exception : " + e));
            }
        }
    }
}

