## MetacatUI: A client-side web interface for DataONE data repositories

- **Author**: Matthew B. Jones, Chris Jones, Lauren Walker, Robyn Thiessen-Bock, Ben Leinfelder, Peter Slaughter, Bryce Mecum, Rushiraj Nenuji ([NCEAS](https://www.nceas.ucsb.edu)), Hesham Elbashandy, Val Hendrix 
- **DOI**: [doi:10.18739/A25M6282K](https://doi.org/10.18739/A25M6282K)
- **License**: [Apache 2](http://opensource.org/licenses/Apache-2.0)
- [Package source code on Github](https://github.com/NCEAS/metacatui)
- [**Submit Bugs and feature requests**](https://github.com/NCEAS/metacatui/issues/new/choose)
- Contact us: metacat-dev@ecoinformatics.org

![Tests Status](https://github.com/NCEAS/metacatui/actions/workflows/test.js.yml/badge.svg)

MetacatUI is a client-side web interface for querying Metacat servers and other servers that implement the DataONE REST API.  Currently, it is used as the basis for the [KNB Data Repository](http://knb.ecoinformatics.org), the [NSF Arctic Data Center](https://arcticdata.io/catalog/), the [DataONE federation](https://search.dataone.org), and other repositories.

MetacatUI is an open source, community project.  We [welcome contributions](https://github.com/NCEAS/metacatui/blob/main/CONTRIBUTING.md) in many forms, including code, graphics, documentation, bug reports, testing, etc.  Use the [discussion list](https://github.com/NCEAS/metacatui/issues) to discuss these contributions with us.

## Citation

Cite this software as:

> Matthew B. Jones, Chris Jones, Lauren Walker, Robyn Thiessen-Bock, Ben Leinfelder, Peter Slaughter, Bryce Mecum, Rushiraj Nenuji, Hesham Elbashandy, Val Hendrix. 2022. MetacatUI: A client-side web interface for DataONE data repositories (version 2.23.0). Arctic Data Center. [doi:10.18739/A25M6282K](https://doi.org/10.18739/A25M6282K)

## Screenshots

The main search view
![KNB Search](https://raw.githubusercontent.com/NCEAS/metacatui/main/docs/screenshots/metacatui-knb-1200w.png)

The dataset landing page
![Arctic Data Center Metadata View](https://raw.githubusercontent.com/NCEAS/metacatui/main/docs/screenshots/metacatui-arctic-1200w.png)

-----------------

## Documentation

Documentation can be found on the [MetacatUI website](https://nceas.github.io/metacatui).

-----------------

## License
```
Copyright [2013] [Regents of the University of California]

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```

## Acknowledgements
Work on this package was supported by:

- NSF-ABI grant #1262458 to C. Gries, M. B. Jones, and S. Collins.
- NSF-DATANET grant #1430508 to W. Michener, M. B. Jones, D. Vieglais, S. Allard and P. Cruse
- NSF DIBBS grant #1443062 to T. Habermann and M. B. Jones
- NSF-PLR grant #1546024 to M. B. Jones, S. Baker-Yeboah, J. Dozier, M. Schildhauer, and A. Budden
- NSF-PLR grant #2042102 to M. B. Jones,  A. Budden, M. Schildhauer, and  J. Dozier

Additional support was provided for working group collaboration by the National Center for Ecological Analysis and Synthesis, a Center funded by the University of California, Santa Barbara, and the State of California.

[![nceas_footer](https://www.nceas.ucsb.edu/files/newLogo_0.png)](http://www.nceas.ucsb.edu)
