!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).Cesium={})}(this,function(exports){"use strict";function defined(e){return null!=e}function DeveloperError(e){var t;this.name="DeveloperError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}defined(Object.create)&&(DeveloperError.prototype=Object.create(Error.prototype),DeveloperError.prototype.constructor=DeveloperError),DeveloperError.prototype.toString=function(){var e=this.name+": "+this.message;return defined(this.stack)&&(e+="\n"+this.stack.toString()),e},DeveloperError.throwInstantiationError=function(){throw new DeveloperError("This function defines an interface and should not be called directly.")};var Check={};function getUndefinedErrorMessage(e){return e+" is required, actual value was undefined"}function getFailedTypeErrorMessage(e,t,i){return"Expected "+i+" to be typeof "+t+", actual typeof was "+e}function defaultValue(e,t){return null!=e?e:t}function MersenneTwister(e){null==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)}Check.typeOf={},Check.defined=function(e,t){if(!defined(t))throw new DeveloperError(getUndefinedErrorMessage(e))},Check.typeOf.func=function(e,t){if("function"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"function",e))},Check.typeOf.string=function(e,t){if("string"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"string",e))},Check.typeOf.number=function(e,t){if("number"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"number",e))},Check.typeOf.number.lessThan=function(e,t,i){if(Check.typeOf.number(e,t),i<=t)throw new DeveloperError("Expected "+e+" to be less than "+i+", actual value was "+t)},Check.typeOf.number.lessThanOrEquals=function(e,t,i){if(Check.typeOf.number(e,t),i<t)throw new DeveloperError("Expected "+e+" to be less than or equal to "+i+", actual value was "+t)},Check.typeOf.number.greaterThan=function(e,t,i){if(Check.typeOf.number(e,t),t<=i)throw new DeveloperError("Expected "+e+" to be greater than "+i+", actual value was "+t)},Check.typeOf.number.greaterThanOrEquals=function(e,t,i){if(Check.typeOf.number(e,t),t<i)throw new DeveloperError("Expected "+e+" to be greater than or equal to"+i+", actual value was "+t)},Check.typeOf.object=function(e,t){if("object"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"object",e))},Check.typeOf.bool=function(e,t){if("boolean"!=typeof t)throw new DeveloperError(getFailedTypeErrorMessage(typeof t,"boolean",e))},Check.typeOf.number.equals=function(e,t,i,r){if(Check.typeOf.number(e,i),Check.typeOf.number(t,r),i!==r)throw new DeveloperError(e+" must be equal to "+t+", the actual values are "+i+" and "+r)},defaultValue.EMPTY_OBJECT=Object.freeze({}),MersenneTwister.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},MersenneTwister.prototype.genrand_int32=function(){var e,t,i=new Array(0,this.MATRIX_A);if(this.mti>=this.N){for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^i[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^i[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^i[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},MersenneTwister.prototype.random=function(){return this.genrand_int32()*(1/4294967296)};var CesiumMath={EPSILON1:.1,EPSILON2:.01,EPSILON3:.001,EPSILON4:1e-4,EPSILON5:1e-5,EPSILON6:1e-6,EPSILON7:1e-7,EPSILON8:1e-8,EPSILON9:1e-9,EPSILON10:1e-10,EPSILON11:1e-11,EPSILON12:1e-12,EPSILON13:1e-13,EPSILON14:1e-14,EPSILON15:1e-15,EPSILON16:1e-16,EPSILON17:1e-17,EPSILON18:1e-18,EPSILON19:1e-19,EPSILON20:1e-20,EPSILON21:1e-21,GRAVITATIONALPARAMETER:3986004418e5,SOLAR_RADIUS:6955e5,LUNAR_RADIUS:1737400,SIXTY_FOUR_KILOBYTES:65536,FOUR_GIGABYTES:4294967296};CesiumMath.sign=defaultValue(Math.sign,function(e){return 0===(e=+e)||e!=e?e:0<e?1:-1}),CesiumMath.signNotZero=function(e){return e<0?-1:1},CesiumMath.toSNorm=function(e,t){return t=defaultValue(t,255),Math.round((.5*CesiumMath.clamp(e,-1,1)+.5)*t)},CesiumMath.fromSNorm=function(e,t){return t=defaultValue(t,255),CesiumMath.clamp(e,0,t)/t*2-1},CesiumMath.normalize=function(e,t,i){return 0===(i=Math.max(i-t,0))?0:CesiumMath.clamp((e-t)/i,0,1)},CesiumMath.sinh=defaultValue(Math.sinh,function(e){return(Math.exp(e)-Math.exp(-e))/2}),CesiumMath.cosh=defaultValue(Math.cosh,function(e){return(Math.exp(e)+Math.exp(-e))/2}),CesiumMath.lerp=function(e,t,i){return(1-i)*e+i*t},CesiumMath.PI=Math.PI,CesiumMath.ONE_OVER_PI=1/Math.PI,CesiumMath.PI_OVER_TWO=Math.PI/2,CesiumMath.PI_OVER_THREE=Math.PI/3,CesiumMath.PI_OVER_FOUR=Math.PI/4,CesiumMath.PI_OVER_SIX=Math.PI/6,CesiumMath.THREE_PI_OVER_TWO=3*Math.PI/2,CesiumMath.TWO_PI=2*Math.PI,CesiumMath.ONE_OVER_TWO_PI=1/(2*Math.PI),CesiumMath.RADIANS_PER_DEGREE=Math.PI/180,CesiumMath.DEGREES_PER_RADIAN=180/Math.PI,CesiumMath.RADIANS_PER_ARCSECOND=CesiumMath.RADIANS_PER_DEGREE/3600,CesiumMath.toRadians=function(e){return e*CesiumMath.RADIANS_PER_DEGREE},CesiumMath.toDegrees=function(e){return e*CesiumMath.DEGREES_PER_RADIAN},CesiumMath.convertLongitudeRange=function(e){var t=CesiumMath.TWO_PI,e=e-Math.floor(e/t)*t;return e<-Math.PI?e+t:e>=Math.PI?e-t:e},CesiumMath.clampToLatitudeRange=function(e){return CesiumMath.clamp(e,-1*CesiumMath.PI_OVER_TWO,CesiumMath.PI_OVER_TWO)},CesiumMath.negativePiToPi=function(e){return CesiumMath.zeroToTwoPi(e+CesiumMath.PI)-CesiumMath.PI},CesiumMath.zeroToTwoPi=function(e){var t=CesiumMath.mod(e,CesiumMath.TWO_PI);return Math.abs(t)<CesiumMath.EPSILON14&&Math.abs(e)>CesiumMath.EPSILON14?CesiumMath.TWO_PI:t},CesiumMath.mod=function(e,t){return(e%t+t)%t},CesiumMath.equalsEpsilon=function(e,t,i,r){i=defaultValue(i,0),r=defaultValue(r,i);var n=Math.abs(e-t);return n<=r||n<=i*Math.max(Math.abs(e),Math.abs(t))},CesiumMath.lessThan=function(e,t,i){return e-t<-i},CesiumMath.lessThanOrEquals=function(e,t,i){return e-t<i},CesiumMath.greaterThan=function(e,t,i){return i<e-t},CesiumMath.greaterThanOrEquals=function(e,t,i){return-i<e-t};var factorials=[1];CesiumMath.factorial=function(e){var t=factorials.length;if(t<=e)for(var i=factorials[t-1],r=t;r<=e;r++){var n=i*r;factorials.push(n),i=n}return factorials[e]},CesiumMath.incrementWrap=function(e,t,i){return i=defaultValue(i,0),t<++e&&(e=i),e},CesiumMath.isPowerOfTwo=function(e){return 0!==e&&0==(e&e-1)},CesiumMath.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},CesiumMath.clamp=function(e,t,i){return e<t?t:i<e?i:e};var randomNumberGenerator=new MersenneTwister;function Cartesian3(e,t,i){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(i,0)}CesiumMath.setRandomNumberSeed=function(e){randomNumberGenerator=new MersenneTwister(e)},CesiumMath.nextRandomNumber=function(){return randomNumberGenerator.random()},CesiumMath.randomBetween=function(e,t){return CesiumMath.nextRandomNumber()*(t-e)+e},CesiumMath.acosClamped=function(e){return Math.acos(CesiumMath.clamp(e,-1,1))},CesiumMath.asinClamped=function(e){return Math.asin(CesiumMath.clamp(e,-1,1))},CesiumMath.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},CesiumMath.logBase=function(e,t){return Math.log(e)/Math.log(t)},CesiumMath.cbrt=defaultValue(Math.cbrt,function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t}),CesiumMath.log2=defaultValue(Math.log2,function(e){return Math.log(e)*Math.LOG2E}),CesiumMath.fog=function(e,t){t*=e;return 1-Math.exp(-t*t)},CesiumMath.fastApproximateAtan=function(e){return e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},CesiumMath.fastApproximateAtan2=function(e,t){var i=Math.abs(e),r=Math.abs(t),n=Math.max(i,r),n=Math.min(i,r)/n,i=CesiumMath.fastApproximateAtan(n);return i=Math.abs(t)>Math.abs(e)?CesiumMath.PI_OVER_TWO-i:i,i=e<0?CesiumMath.PI-i:i,i=t<0?-i:i},Cartesian3.fromSpherical=function(e,t){defined(t)||(t=new Cartesian3);var i=e.clock,r=e.cone,n=defaultValue(e.magnitude,1),e=n*Math.sin(r);return t.x=e*Math.cos(i),t.y=e*Math.sin(i),t.z=n*Math.cos(r),t},Cartesian3.fromElements=function(e,t,i,r){return defined(r)?(r.x=e,r.y=t,r.z=i,r):new Cartesian3(e,t,i)},Cartesian3.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new Cartesian3(e.x,e.y,e.z)},Cartesian3.fromCartesian4=Cartesian3.clone,Cartesian3.packedLength=3,Cartesian3.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i]=e.z,t},Cartesian3.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Cartesian3),i.x=e[t++],i.y=e[t++],i.z=e[t],i},Cartesian3.packArray=function(e,t){var i=e.length,r=3*i;if(defined(t)){if(!Array.isArray(t)&&t.length!==r)throw new DeveloperError("If result is a typed array, it must have exactly array.length * 3 elements");t.length!==r&&(t.length=r)}else t=new Array(r);for(var n=0;n<i;++n)Cartesian3.pack(e[n],t,3*n);return t},Cartesian3.unpackArray=function(e,t){var i=e.length;defined(t)?t.length=i/3:t=new Array(i/3);for(var r=0;r<i;r+=3){var n=r/3;t[n]=Cartesian3.unpack(e,r,t[n])}return t},Cartesian3.fromArray=Cartesian3.unpack,Cartesian3.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},Cartesian3.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},Cartesian3.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i.z=Math.min(e.z,t.z),i},Cartesian3.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i.z=Math.max(e.z,t.z),i},Cartesian3.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},Cartesian3.magnitude=function(e){return Math.sqrt(Cartesian3.magnitudeSquared(e))};var distanceScratch=new Cartesian3;Cartesian3.distance=function(e,t){return Cartesian3.subtract(e,t,distanceScratch),Cartesian3.magnitude(distanceScratch)},Cartesian3.distanceSquared=function(e,t){return Cartesian3.subtract(e,t,distanceScratch),Cartesian3.magnitudeSquared(distanceScratch)},Cartesian3.normalize=function(e,t){var i=Cartesian3.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t.z=e.z/i,t},Cartesian3.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},Cartesian3.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i.z=e.z*t.z,i},Cartesian3.divideComponents=function(e,t,i){return i.x=e.x/t.x,i.y=e.y/t.y,i.z=e.z/t.z,i},Cartesian3.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i},Cartesian3.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i},Cartesian3.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i},Cartesian3.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i},Cartesian3.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},Cartesian3.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var lerpScratch=new Cartesian3;Cartesian3.lerp=function(e,t,i,r){return Cartesian3.multiplyByScalar(t,i,lerpScratch),r=Cartesian3.multiplyByScalar(e,1-i,r),Cartesian3.add(lerpScratch,r,r)};var angleBetweenScratch=new Cartesian3,angleBetweenScratch2=new Cartesian3;Cartesian3.angleBetween=function(e,t){Cartesian3.normalize(e,angleBetweenScratch),Cartesian3.normalize(t,angleBetweenScratch2);e=Cartesian3.dot(angleBetweenScratch,angleBetweenScratch2),t=Cartesian3.magnitude(Cartesian3.cross(angleBetweenScratch,angleBetweenScratch2,angleBetweenScratch));return Math.atan2(t,e)};var mostOrthogonalAxisScratch=new Cartesian3;Cartesian3.mostOrthogonalAxis=function(e,t){e=Cartesian3.normalize(e,mostOrthogonalAxisScratch);return Cartesian3.abs(e,e),t=e.x<=e.y?e.x<=e.z?Cartesian3.clone(Cartesian3.UNIT_X,t):Cartesian3.clone(Cartesian3.UNIT_Z,t):e.y<=e.z?Cartesian3.clone(Cartesian3.UNIT_Y,t):Cartesian3.clone(Cartesian3.UNIT_Z,t)},Cartesian3.projectVector=function(e,t,i){e=Cartesian3.dot(e,t)/Cartesian3.dot(t,t);return Cartesian3.multiplyByScalar(t,e,i)},Cartesian3.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},Cartesian3.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]&&e.z===t[i+2]},Cartesian3.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,i,r)&&CesiumMath.equalsEpsilon(e.y,t.y,i,r)&&CesiumMath.equalsEpsilon(e.z,t.z,i,r)},Cartesian3.cross=function(e,t,i){var r=e.x,n=e.y,a=e.z,o=t.x,s=t.y,e=t.z,t=n*e-a*s,e=a*o-r*e,o=r*s-n*o;return i.x=t,i.y=e,i.z=o,i},Cartesian3.midpoint=function(e,t,i){return i.x=.5*(e.x+t.x),i.y=.5*(e.y+t.y),i.z=.5*(e.z+t.z),i},Cartesian3.fromDegrees=function(e,t,i,r,n){return e=CesiumMath.toRadians(e),t=CesiumMath.toRadians(t),Cartesian3.fromRadians(e,t,i,r,n)};var scratchN=new Cartesian3,scratchK=new Cartesian3,wgs84RadiiSquared=new Cartesian3(40680631590769,40680631590769,40408299984661.445);Cartesian3.fromRadians=function(e,t,i,r,n){i=defaultValue(i,0);var a=defined(r)?r.radiiSquared:wgs84RadiiSquared,r=Math.cos(t);scratchN.x=r*Math.cos(e),scratchN.y=r*Math.sin(e),scratchN.z=Math.sin(t),scratchN=Cartesian3.normalize(scratchN,scratchN),Cartesian3.multiplyComponents(a,scratchN,scratchK);a=Math.sqrt(Cartesian3.dot(scratchN,scratchK));return scratchK=Cartesian3.divideByScalar(scratchK,a,scratchK),scratchN=Cartesian3.multiplyByScalar(scratchN,i,scratchN),defined(n)||(n=new Cartesian3),Cartesian3.add(scratchK,scratchN,n)},Cartesian3.fromDegreesArray=function(e,t,i){var r=e.length;defined(i)?i.length=r/2:i=new Array(r/2);for(var n=0;n<r;n+=2){var a=e[n],o=e[n+1],s=n/2;i[s]=Cartesian3.fromDegrees(a,o,0,t,i[s])}return i},Cartesian3.fromRadiansArray=function(e,t,i){var r=e.length;defined(i)?i.length=r/2:i=new Array(r/2);for(var n=0;n<r;n+=2){var a=e[n],o=e[n+1],s=n/2;i[s]=Cartesian3.fromRadians(a,o,0,t,i[s])}return i},Cartesian3.fromDegreesArrayHeights=function(e,t,i){var r=e.length;defined(i)?i.length=r/3:i=new Array(r/3);for(var n=0;n<r;n+=3){var a=e[n],o=e[n+1],s=e[n+2],l=n/3;i[l]=Cartesian3.fromDegrees(a,o,s,t,i[l])}return i},Cartesian3.fromRadiansArrayHeights=function(e,t,i){var r=e.length;defined(i)?i.length=r/3:i=new Array(r/3);for(var n=0;n<r;n+=3){var a=e[n],o=e[n+1],s=e[n+2],l=n/3;i[l]=Cartesian3.fromRadians(a,o,s,t,i[l])}return i},Cartesian3.ZERO=Object.freeze(new Cartesian3(0,0,0)),Cartesian3.UNIT_X=Object.freeze(new Cartesian3(1,0,0)),Cartesian3.UNIT_Y=Object.freeze(new Cartesian3(0,1,0)),Cartesian3.UNIT_Z=Object.freeze(new Cartesian3(0,0,1)),Cartesian3.prototype.clone=function(e){return Cartesian3.clone(this,e)},Cartesian3.prototype.equals=function(e){return Cartesian3.equals(this,e)},Cartesian3.prototype.equalsEpsilon=function(e,t,i){return Cartesian3.equalsEpsilon(this,e,t,i)},Cartesian3.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"};var scaleToGeodeticSurfaceIntersection=new Cartesian3,scaleToGeodeticSurfaceGradient=new Cartesian3;function scaleToGeodeticSurface(e,t,i,r,n){var a=e.x,o=e.y,s=e.z,l=t.x,c=t.y,t=t.z,u=a*a*l*l,d=o*o*c*c,h=s*s*t*t,l=u+d+h,c=Math.sqrt(1/l),t=Cartesian3.multiplyByScalar(e,c,scaleToGeodeticSurfaceIntersection);if(l<r)return isFinite(c)?Cartesian3.clone(t,n):void 0;var p=i.x,m=i.y,f=i.z,i=scaleToGeodeticSurfaceGradient;i.x=t.x*p*2,i.y=t.y*m*2,i.z=t.z*f*2;var g,_,y,C,v,S,T,x=(1-c)*Cartesian3.magnitude(e)/(.5*Cartesian3.magnitude(i)),b=0;do{b=(g=u*(v=(_=1/(1+(x-=b)*p))*_)+d*(S=(y=1/(1+x*m))*y)+h*(T=(C=1/(1+x*f))*C)-1)/(-2*(u*(v*_)*p+d*(S*y)*m+h*(T*C)*f))}while(Math.abs(g)>CesiumMath.EPSILON12);return defined(n)?(n.x=a*_,n.y=o*y,n.z=s*C,n):new Cartesian3(a*_,o*y,s*C)}function Cartographic(e,t,i){this.longitude=defaultValue(e,0),this.latitude=defaultValue(t,0),this.height=defaultValue(i,0)}Cartographic.fromRadians=function(e,t,i,r){return i=defaultValue(i,0),defined(r)?(r.longitude=e,r.latitude=t,r.height=i,r):new Cartographic(e,t,i)},Cartographic.fromDegrees=function(e,t,i,r){return e=CesiumMath.toRadians(e),t=CesiumMath.toRadians(t),Cartographic.fromRadians(e,t,i,r)};var cartesianToCartographicN=new Cartesian3,cartesianToCartographicP=new Cartesian3,cartesianToCartographicH=new Cartesian3,wgs84OneOverRadii=new Cartesian3(1/6378137,1/6378137,1/6356752.314245179),wgs84OneOverRadiiSquared=new Cartesian3(1/40680631590769,1/40680631590769,1/40408299984661.445),wgs84CenterToleranceSquared=CesiumMath.EPSILON1;function initialize(e,t,i,r){t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,0),e._radii=new Cartesian3(t,i,r),e._radiiSquared=new Cartesian3(t*t,i*i,r*r),e._radiiToTheFourth=new Cartesian3(t*t*t*t,i*i*i*i,r*r*r*r),e._oneOverRadii=new Cartesian3(0===t?0:1/t,0===i?0:1/i,0===r?0:1/r),e._oneOverRadiiSquared=new Cartesian3(0===t?0:1/(t*t),0===i?0:1/(i*i),0===r?0:1/(r*r)),e._minimumRadius=Math.min(t,i,r),e._maximumRadius=Math.max(t,i,r),e._centerToleranceSquared=CesiumMath.EPSILON1,0!==e._radiiSquared.z&&(e._squaredXOverSquaredZ=e._radiiSquared.x/e._radiiSquared.z)}function Ellipsoid(e,t,i){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,initialize(this,e,t,i)}Cartographic.fromCartesian=function(e,t,i){var r=defined(t)?t.oneOverRadii:wgs84OneOverRadii,n=defined(t)?t.oneOverRadiiSquared:wgs84OneOverRadiiSquared,r=scaleToGeodeticSurface(e,r,n,defined(t)?t._centerToleranceSquared:wgs84CenterToleranceSquared,cartesianToCartographicP);if(defined(r)){t=Cartesian3.multiplyComponents(r,n,cartesianToCartographicN),t=Cartesian3.normalize(t,t),n=Cartesian3.subtract(e,r,cartesianToCartographicH),r=Math.atan2(t.y,t.x),t=Math.asin(t.z),n=CesiumMath.sign(Cartesian3.dot(n,e))*Cartesian3.magnitude(n);return defined(i)?(i.longitude=r,i.latitude=t,i.height=n,i):new Cartographic(r,t,n)}},Cartographic.toCartesian=function(e,t,i){return Cartesian3.fromRadians(e.longitude,e.latitude,e.height,t,i)},Cartographic.clone=function(e,t){if(defined(e))return defined(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new Cartographic(e.longitude,e.latitude,e.height)},Cartographic.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},Cartographic.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e.longitude-t.longitude)<=i&&Math.abs(e.latitude-t.latitude)<=i&&Math.abs(e.height-t.height)<=i},Cartographic.ZERO=Object.freeze(new Cartographic(0,0,0)),Cartographic.prototype.clone=function(e){return Cartographic.clone(this,e)},Cartographic.prototype.equals=function(e){return Cartographic.equals(this,e)},Cartographic.prototype.equalsEpsilon=function(e,t){return Cartographic.equalsEpsilon(this,e,t)},Cartographic.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},Object.defineProperties(Ellipsoid.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),Ellipsoid.clone=function(e,t){if(defined(e)){var i=e._radii;return defined(t)?(Cartesian3.clone(i,t._radii),Cartesian3.clone(e._radiiSquared,t._radiiSquared),Cartesian3.clone(e._radiiToTheFourth,t._radiiToTheFourth),Cartesian3.clone(e._oneOverRadii,t._oneOverRadii),Cartesian3.clone(e._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=e._minimumRadius,t._maximumRadius=e._maximumRadius,t._centerToleranceSquared=e._centerToleranceSquared,t):new Ellipsoid(i.x,i.y,i.z)}},Ellipsoid.fromCartesian3=function(e,t){return defined(t)||(t=new Ellipsoid),defined(e)&&initialize(t,e.x,e.y,e.z),t},Ellipsoid.WGS84=Object.freeze(new Ellipsoid(6378137,6378137,6356752.314245179)),Ellipsoid.UNIT_SPHERE=Object.freeze(new Ellipsoid(1,1,1)),Ellipsoid.MOON=Object.freeze(new Ellipsoid(CesiumMath.LUNAR_RADIUS,CesiumMath.LUNAR_RADIUS,CesiumMath.LUNAR_RADIUS)),Ellipsoid.prototype.clone=function(e){return Ellipsoid.clone(this,e)},Ellipsoid.packedLength=Cartesian3.packedLength,Ellipsoid.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._radii,t,i),t},Ellipsoid.unpack=function(e,t,i){t=defaultValue(t,0);t=Cartesian3.unpack(e,t);return Ellipsoid.fromCartesian3(t,i)},Ellipsoid.prototype.geocentricSurfaceNormal=Cartesian3.normalize,Ellipsoid.prototype.geodeticSurfaceNormalCartographic=function(e,t){var i=e.longitude,r=e.latitude,n=Math.cos(r),e=n*Math.cos(i),i=n*Math.sin(i),r=Math.sin(r);return defined(t)||(t=new Cartesian3),t.x=e,t.y=i,t.z=r,Cartesian3.normalize(t,t)},Ellipsoid.prototype.geodeticSurfaceNormal=function(e,t){if(!Cartesian3.equalsEpsilon(e,Cartesian3.ZERO,CesiumMath.EPSILON14))return defined(t)||(t=new Cartesian3),t=Cartesian3.multiplyComponents(e,this._oneOverRadiiSquared,t),Cartesian3.normalize(t,t)};var cartographicToCartesianNormal=new Cartesian3,cartographicToCartesianK=new Cartesian3;Ellipsoid.prototype.cartographicToCartesian=function(e,t){var i=cartographicToCartesianNormal,r=cartographicToCartesianK;this.geodeticSurfaceNormalCartographic(e,i),Cartesian3.multiplyComponents(this._radiiSquared,i,r);var n=Math.sqrt(Cartesian3.dot(i,r));return Cartesian3.divideByScalar(r,n,r),Cartesian3.multiplyByScalar(i,e.height,i),defined(t)||(t=new Cartesian3),Cartesian3.add(r,i,t)},Ellipsoid.prototype.cartographicArrayToCartesianArray=function(e,t){var i=e.length;defined(t)?t.length=i:t=new Array(i);for(var r=0;r<i;r++)t[r]=this.cartographicToCartesian(e[r],t[r]);return t};var cartesianToCartographicN$1=new Cartesian3,cartesianToCartographicP$1=new Cartesian3,cartesianToCartographicH$1=new Cartesian3;Ellipsoid.prototype.cartesianToCartographic=function(e,t){var i=this.scaleToGeodeticSurface(e,cartesianToCartographicP$1);if(defined(i)){var r=this.geodeticSurfaceNormal(i,cartesianToCartographicN$1),n=Cartesian3.subtract(e,i,cartesianToCartographicH$1),i=Math.atan2(r.y,r.x),r=Math.asin(r.z),n=CesiumMath.sign(Cartesian3.dot(n,e))*Cartesian3.magnitude(n);return defined(t)?(t.longitude=i,t.latitude=r,t.height=n,t):new Cartographic(i,r,n)}},Ellipsoid.prototype.cartesianArrayToCartographicArray=function(e,t){var i=e.length;defined(t)?t.length=i:t=new Array(i);for(var r=0;r<i;++r)t[r]=this.cartesianToCartographic(e[r],t[r]);return t},Ellipsoid.prototype.scaleToGeodeticSurface=function(e,t){return scaleToGeodeticSurface(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},Ellipsoid.prototype.scaleToGeocentricSurface=function(e,t){defined(t)||(t=new Cartesian3);var i=e.x,r=e.y,n=e.z,a=this._oneOverRadiiSquared,a=1/Math.sqrt(i*i*a.x+r*r*a.y+n*n*a.z);return Cartesian3.multiplyByScalar(e,a,t)},Ellipsoid.prototype.transformPositionToScaledSpace=function(e,t){return defined(t)||(t=new Cartesian3),Cartesian3.multiplyComponents(e,this._oneOverRadii,t)},Ellipsoid.prototype.transformPositionFromScaledSpace=function(e,t){return defined(t)||(t=new Cartesian3),Cartesian3.multiplyComponents(e,this._radii,t)},Ellipsoid.prototype.equals=function(e){return this===e||defined(e)&&Cartesian3.equals(this._radii,e._radii)},Ellipsoid.prototype.toString=function(){return this._radii.toString()},Ellipsoid.prototype.getSurfaceNormalIntersectionWithZAxis=function(e,t,i){t=defaultValue(t,0);var r=this._squaredXOverSquaredZ;if(defined(i)||(i=new Cartesian3),i.x=0,i.y=0,i.z=e.z*(1-r),!(Math.abs(i.z)>=this._radii.z-t))return i};var abscissas=[.14887433898163,.43339539412925,.67940956829902,.86506336668898,.97390652851717,0],weights=[.29552422471475,.26926671930999,.21908636251598,.14945134915058,.066671344308684,0];function gaussLegendreQuadrature(e,t,i){for(var r=.5*(t+e),n=.5*(t-e),a=0,o=0;o<5;o++){var s=n*abscissas[o];a+=weights[o]*(i(r+s)+i(r-s))}return a*=n}function GeographicProjection(e){this._ellipsoid=defaultValue(e,Ellipsoid.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}Ellipsoid.prototype.surfaceArea=function(e){for(var t=e.west,n=e.east,i=e.south,r=e.north;n<t;)n+=CesiumMath.TWO_PI;var e=this._radiiSquared,a=e.x,o=e.y,s=e.z,l=a*o;return gaussLegendreQuadrature(i,r,function(e){var i=Math.cos(e),r=Math.sin(e);return Math.cos(e)*gaussLegendreQuadrature(t,n,function(e){var t=Math.cos(e),e=Math.sin(e);return Math.sqrt(l*r*r+s*(o*t*t+a*e*e)*i*i)})})},Object.defineProperties(GeographicProjection.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),GeographicProjection.prototype.project=function(e,t){var i=this._semimajorAxis,r=e.longitude*i,i=e.latitude*i,e=e.height;return defined(t)?(t.x=r,t.y=i,t.z=e,t):new Cartesian3(r,i,e)},GeographicProjection.prototype.unproject=function(e,t){var i=this._oneOverSemimajorAxis,r=e.x*i,i=e.y*i,e=e.z;return defined(t)?(t.longitude=r,t.latitude=i,t.height=e,t):new Cartographic(r,i,e)};var Intersect={OUTSIDE:-1,INTERSECTING:0,INSIDE:1},Intersect$1=Object.freeze(Intersect);function Interval(e,t){this.start=defaultValue(e,0),this.stop=defaultValue(t,0)}function Matrix3(e,t,i,r,n,a,o,s,l){this[0]=defaultValue(e,0),this[1]=defaultValue(r,0),this[2]=defaultValue(o,0),this[3]=defaultValue(t,0),this[4]=defaultValue(n,0),this[5]=defaultValue(s,0),this[6]=defaultValue(i,0),this[7]=defaultValue(a,0),this[8]=defaultValue(l,0)}Matrix3.packedLength=9,Matrix3.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t},Matrix3.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix3),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i},Matrix3.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new Matrix3(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},Matrix3.fromArray=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix3),i[0]=e[t],i[1]=e[t+1],i[2]=e[t+2],i[3]=e[t+3],i[4]=e[t+4],i[5]=e[t+5],i[6]=e[t+6],i[7]=e[t+7],i[8]=e[t+8],i},Matrix3.fromColumnMajorArray=function(e,t){return Matrix3.clone(e,t)},Matrix3.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new Matrix3(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},Matrix3.fromQuaternion=function(e,t){var i=e.x*e.x,r=e.x*e.y,n=e.x*e.z,a=e.x*e.w,o=e.y*e.y,s=e.y*e.z,l=e.y*e.w,c=e.z*e.z,u=e.z*e.w,d=e.w*e.w,h=i-o-c+d,p=2*(r-u),m=2*(n+l),e=2*(r+u),r=o-i-c+d,u=2*(s-a),l=2*(n-l),a=2*(s+a),d=-i-o+c+d;return defined(t)?(t[0]=h,t[1]=e,t[2]=l,t[3]=p,t[4]=r,t[5]=a,t[6]=m,t[7]=u,t[8]=d,t):new Matrix3(h,p,m,e,r,u,l,a,d)},Matrix3.fromHeadingPitchRoll=function(e,t){var i=Math.cos(-e.pitch),r=Math.cos(-e.heading),n=Math.cos(e.roll),a=Math.sin(-e.pitch),o=Math.sin(-e.heading),s=Math.sin(e.roll),l=i*r,c=-n*o+s*a*r,u=s*o+n*a*r,d=i*o,e=n*r+s*a*o,o=-s*r+n*a*o,a=-a,s=s*i,i=n*i;return defined(t)?(t[0]=l,t[1]=d,t[2]=a,t[3]=c,t[4]=e,t[5]=s,t[6]=u,t[7]=o,t[8]=i,t):new Matrix3(l,c,u,d,e,o,a,s,i)},Matrix3.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new Matrix3(e.x,0,0,0,e.y,0,0,0,e.z)},Matrix3.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new Matrix3(e,0,0,0,e,0,0,0,e)},Matrix3.fromCrossProduct=function(e,t){return defined(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new Matrix3(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},Matrix3.fromRotationX=function(e,t){var i=Math.cos(e),e=Math.sin(e);return defined(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=i,t[5]=e,t[6]=0,t[7]=-e,t[8]=i,t):new Matrix3(1,0,0,0,i,-e,0,e,i)},Matrix3.fromRotationY=function(e,t){var i=Math.cos(e),e=Math.sin(e);return defined(t)?(t[0]=i,t[1]=0,t[2]=-e,t[3]=0,t[4]=1,t[5]=0,t[6]=e,t[7]=0,t[8]=i,t):new Matrix3(i,0,e,0,1,0,-e,0,i)},Matrix3.fromRotationZ=function(e,t){var i=Math.cos(e),e=Math.sin(e);return defined(t)?(t[0]=i,t[1]=e,t[2]=0,t[3]=-e,t[4]=i,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new Matrix3(i,-e,0,e,i,0,0,0,1)},Matrix3.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},Matrix3.getElementIndex=function(e,t){return 3*e+t},Matrix3.getColumn=function(e,t,i){var r=3*t,n=e[r],t=e[1+r],r=e[2+r];return i.x=n,i.y=t,i.z=r,i},Matrix3.setColumn=function(e,t,i,r){t*=3;return(r=Matrix3.clone(e,r))[t]=i.x,r[1+t]=i.y,r[2+t]=i.z,r},Matrix3.getRow=function(e,t,i){var r=e[t],n=e[t+3],t=e[t+6];return i.x=r,i.y=n,i.z=t,i},Matrix3.setRow=function(e,t,i,r){return(r=Matrix3.clone(e,r))[t]=i.x,r[t+3]=i.y,r[t+6]=i.z,r};var scratchColumn=new Cartesian3;Matrix3.getScale=function(e,t){return t.x=Cartesian3.magnitude(Cartesian3.fromElements(e[0],e[1],e[2],scratchColumn)),t.y=Cartesian3.magnitude(Cartesian3.fromElements(e[3],e[4],e[5],scratchColumn)),t.z=Cartesian3.magnitude(Cartesian3.fromElements(e[6],e[7],e[8],scratchColumn)),t};var scratchScale=new Cartesian3;Matrix3.getMaximumScale=function(e){return Matrix3.getScale(e,scratchScale),Cartesian3.maximumComponent(scratchScale)},Matrix3.multiply=function(e,t,i){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],n=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],s=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],l=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],u=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],t=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return i[0]=r,i[1]=n,i[2]=a,i[3]=o,i[4]=s,i[5]=l,i[6]=c,i[7]=u,i[8]=t,i},Matrix3.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i[4]=e[4]+t[4],i[5]=e[5]+t[5],i[6]=e[6]+t[6],i[7]=e[7]+t[7],i[8]=e[8]+t[8],i},Matrix3.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i[4]=e[4]-t[4],i[5]=e[5]-t[5],i[6]=e[6]-t[6],i[7]=e[7]-t[7],i[8]=e[8]-t[8],i},Matrix3.multiplyByVector=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=e[0]*r+e[3]*n+e[6]*a,t=e[1]*r+e[4]*n+e[7]*a,a=e[2]*r+e[5]*n+e[8]*a;return i.x=o,i.y=t,i.z=a,i},Matrix3.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i[4]=e[4]*t,i[5]=e[5]*t,i[6]=e[6]*t,i[7]=e[7]*t,i[8]=e[8]*t,i},Matrix3.multiplyByScale=function(e,t,i){return i[0]=e[0]*t.x,i[1]=e[1]*t.x,i[2]=e[2]*t.x,i[3]=e[3]*t.y,i[4]=e[4]*t.y,i[5]=e[5]*t.y,i[6]=e[6]*t.z,i[7]=e[7]*t.z,i[8]=e[8]*t.z,i},Matrix3.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},Matrix3.transpose=function(e,t){var i=e[0],r=e[3],n=e[6],a=e[1],o=e[4],s=e[7],l=e[2],c=e[5],e=e[8];return t[0]=i,t[1]=r,t[2]=n,t[3]=a,t[4]=o,t[5]=s,t[6]=l,t[7]=c,t[8]=e,t};var UNIT=new Cartesian3(1,1,1);function computeFrobeniusNorm(e){for(var t=0,i=0;i<9;++i){var r=e[i];t+=r*r}return Math.sqrt(t)}Matrix3.getRotation=function(e,t){var i=Cartesian3.divideComponents(UNIT,Matrix3.getScale(e,scratchScale),scratchScale);return t=Matrix3.multiplyByScale(e,i,t)};var rowVal=[1,0,0],colVal=[2,2,1];function offDiagonalFrobeniusNorm(e){for(var t=0,i=0;i<3;++i){var r=e[Matrix3.getElementIndex(colVal[i],rowVal[i])];t+=2*r*r}return Math.sqrt(t)}function shurDecomposition(e,t){for(var i=CesiumMath.EPSILON15,r=0,n=1,a=0;a<3;++a){var o=Math.abs(e[Matrix3.getElementIndex(colVal[a],rowVal[a])]);r<o&&(n=a,r=o)}var s=1,l=0,c=rowVal[n],u=colVal[n];return Math.abs(e[Matrix3.getElementIndex(u,c)])>i&&(l=(i=(i=(e[Matrix3.getElementIndex(u,u)]-e[Matrix3.getElementIndex(c,c)])/2/e[Matrix3.getElementIndex(u,c)])<0?-1/(-i+Math.sqrt(1+i*i)):1/(i+Math.sqrt(1+i*i)))*(s=1/Math.sqrt(1+i*i))),(t=Matrix3.clone(Matrix3.IDENTITY,t))[Matrix3.getElementIndex(c,c)]=t[Matrix3.getElementIndex(u,u)]=s,t[Matrix3.getElementIndex(u,c)]=l,t[Matrix3.getElementIndex(c,u)]=-l,t}var jMatrix=new Matrix3,jMatrixTranspose=new Matrix3;Matrix3.computeEigenDecomposition=function(e,t){var i=CesiumMath.EPSILON20,r=0,n=0;defined(t)||(t={});for(var a=t.unitary=Matrix3.clone(Matrix3.IDENTITY,t.unitary),o=t.diagonal=Matrix3.clone(e,t.diagonal),s=i*computeFrobeniusNorm(o);n<10&&offDiagonalFrobeniusNorm(o)>s;)shurDecomposition(o,jMatrix),Matrix3.transpose(jMatrix,jMatrixTranspose),Matrix3.multiply(o,jMatrix,o),Matrix3.multiply(jMatrixTranspose,o,o),Matrix3.multiply(a,jMatrix,a),2<++r&&(++n,r=0);return t},Matrix3.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},Matrix3.determinant=function(e){var t=e[0],i=e[3],r=e[6],n=e[1],a=e[4],o=e[7],s=e[2],l=e[5],e=e[8];return t*(a*e-l*o)+n*(l*r-i*e)+s*(i*o-a*r)},Matrix3.inverse=function(e,t){var i=e[0],r=e[1],n=e[2],a=e[3],o=e[4],s=e[5],l=e[6],c=e[7],u=e[8],e=Matrix3.determinant(e);t[0]=o*u-c*s,t[1]=c*n-r*u,t[2]=r*s-o*n,t[3]=l*s-a*u,t[4]=i*u-l*n,t[5]=a*n-i*s,t[6]=a*c-l*o,t[7]=l*r-i*c,t[8]=i*o-a*r;e=1/e;return Matrix3.multiplyByScalar(t,e,t)};var scratchTransposeMatrix=new Matrix3;function Cartesian4(e,t,i,r){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(i,0),this.w=defaultValue(r,0)}Matrix3.inverseTranspose=function(e,t){return Matrix3.inverse(Matrix3.transpose(e,scratchTransposeMatrix),t)},Matrix3.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},Matrix3.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i&&Math.abs(e[4]-t[4])<=i&&Math.abs(e[5]-t[5])<=i&&Math.abs(e[6]-t[6])<=i&&Math.abs(e[7]-t[7])<=i&&Math.abs(e[8]-t[8])<=i},Matrix3.IDENTITY=Object.freeze(new Matrix3(1,0,0,0,1,0,0,0,1)),Matrix3.ZERO=Object.freeze(new Matrix3(0,0,0,0,0,0,0,0,0)),Matrix3.COLUMN0ROW0=0,Matrix3.COLUMN0ROW1=1,Matrix3.COLUMN0ROW2=2,Matrix3.COLUMN1ROW0=3,Matrix3.COLUMN1ROW1=4,Matrix3.COLUMN1ROW2=5,Matrix3.COLUMN2ROW0=6,Matrix3.COLUMN2ROW1=7,Matrix3.COLUMN2ROW2=8,Object.defineProperties(Matrix3.prototype,{length:{get:function(){return Matrix3.packedLength}}}),Matrix3.prototype.clone=function(e){return Matrix3.clone(this,e)},Matrix3.prototype.equals=function(e){return Matrix3.equals(this,e)},Matrix3.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]&&e[4]===t[i+4]&&e[5]===t[i+5]&&e[6]===t[i+6]&&e[7]===t[i+7]&&e[8]===t[i+8]},Matrix3.prototype.equalsEpsilon=function(e,t){return Matrix3.equalsEpsilon(this,e,t)},Matrix3.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},Cartesian4.fromElements=function(e,t,i,r,n){return defined(n)?(n.x=e,n.y=t,n.z=i,n.w=r,n):new Cartesian4(e,t,i,r)},Cartesian4.fromColor=function(e,t){return defined(t)?(t.x=e.red,t.y=e.green,t.z=e.blue,t.w=e.alpha,t):new Cartesian4(e.red,e.green,e.blue,e.alpha)},Cartesian4.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new Cartesian4(e.x,e.y,e.z,e.w)},Cartesian4.packedLength=4,Cartesian4.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.z,t[i]=e.w,t},Cartesian4.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Cartesian4),i.x=e[t++],i.y=e[t++],i.z=e[t++],i.w=e[t],i},Cartesian4.packArray=function(e,t){var i=e.length,r=4*i;if(defined(t)){if(!Array.isArray(t)&&t.length!==r)throw new DeveloperError("If result is a typed array, it must have exactly array.length * 4 elements");t.length!==r&&(t.length=r)}else t=new Array(r);for(var n=0;n<i;++n)Cartesian4.pack(e[n],t,4*n);return t},Cartesian4.unpackArray=function(e,t){var i=e.length;defined(t)?t.length=i/4:t=new Array(i/4);for(var r=0;r<i;r+=4){var n=r/4;t[n]=Cartesian4.unpack(e,r,t[n])}return t},Cartesian4.fromArray=Cartesian4.unpack,Cartesian4.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},Cartesian4.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},Cartesian4.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i.z=Math.min(e.z,t.z),i.w=Math.min(e.w,t.w),i},Cartesian4.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i.z=Math.max(e.z,t.z),i.w=Math.max(e.w,t.w),i},Cartesian4.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},Cartesian4.magnitude=function(e){return Math.sqrt(Cartesian4.magnitudeSquared(e))};var distanceScratch$1=new Cartesian4;Cartesian4.distance=function(e,t){return Cartesian4.subtract(e,t,distanceScratch$1),Cartesian4.magnitude(distanceScratch$1)},Cartesian4.distanceSquared=function(e,t){return Cartesian4.subtract(e,t,distanceScratch$1),Cartesian4.magnitudeSquared(distanceScratch$1)},Cartesian4.normalize=function(e,t){var i=Cartesian4.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t.z=e.z/i,t.w=e.w/i,t},Cartesian4.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},Cartesian4.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i.z=e.z*t.z,i.w=e.w*t.w,i},Cartesian4.divideComponents=function(e,t,i){return i.x=e.x/t.x,i.y=e.y/t.y,i.z=e.z/t.z,i.w=e.w/t.w,i},Cartesian4.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i.w=e.w+t.w,i},Cartesian4.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i.w=e.w-t.w,i},Cartesian4.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i.w=e.w*t,i},Cartesian4.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i.w=e.w/t,i},Cartesian4.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},Cartesian4.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var lerpScratch$1=new Cartesian4;Cartesian4.lerp=function(e,t,i,r){return Cartesian4.multiplyByScalar(t,i,lerpScratch$1),r=Cartesian4.multiplyByScalar(e,1-i,r),Cartesian4.add(lerpScratch$1,r,r)};var mostOrthogonalAxisScratch$1=new Cartesian4;Cartesian4.mostOrthogonalAxis=function(e,t){e=Cartesian4.normalize(e,mostOrthogonalAxisScratch$1);return Cartesian4.abs(e,e),t=e.x<=e.y?e.x<=e.z?e.x<=e.w?Cartesian4.clone(Cartesian4.UNIT_X,t):Cartesian4.clone(Cartesian4.UNIT_W,t):e.z<=e.w?Cartesian4.clone(Cartesian4.UNIT_Z,t):Cartesian4.clone(Cartesian4.UNIT_W,t):e.y<=e.z?e.y<=e.w?Cartesian4.clone(Cartesian4.UNIT_Y,t):Cartesian4.clone(Cartesian4.UNIT_W,t):e.z<=e.w?Cartesian4.clone(Cartesian4.UNIT_Z,t):Cartesian4.clone(Cartesian4.UNIT_W,t)},Cartesian4.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},Cartesian4.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]&&e.z===t[i+2]&&e.w===t[i+3]},Cartesian4.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,i,r)&&CesiumMath.equalsEpsilon(e.y,t.y,i,r)&&CesiumMath.equalsEpsilon(e.z,t.z,i,r)&&CesiumMath.equalsEpsilon(e.w,t.w,i,r)},Cartesian4.ZERO=Object.freeze(new Cartesian4(0,0,0,0)),Cartesian4.UNIT_X=Object.freeze(new Cartesian4(1,0,0,0)),Cartesian4.UNIT_Y=Object.freeze(new Cartesian4(0,1,0,0)),Cartesian4.UNIT_Z=Object.freeze(new Cartesian4(0,0,1,0)),Cartesian4.UNIT_W=Object.freeze(new Cartesian4(0,0,0,1)),Cartesian4.prototype.clone=function(e){return Cartesian4.clone(this,e)},Cartesian4.prototype.equals=function(e){return Cartesian4.equals(this,e)},Cartesian4.prototype.equalsEpsilon=function(e,t,i){return Cartesian4.equalsEpsilon(this,e,t,i)},Cartesian4.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var scratchF32Array=new Float32Array(1),scratchU8Array=new Uint8Array(scratchF32Array.buffer),testU32=new Uint32Array([287454020]),testU8=new Uint8Array(testU32.buffer),littleEndian=68===testU8[0];function RuntimeError(e){var t;this.name="RuntimeError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}function Matrix4(e,t,i,r,n,a,o,s,l,c,u,d,h,p,m,f){this[0]=defaultValue(e,0),this[1]=defaultValue(n,0),this[2]=defaultValue(l,0),this[3]=defaultValue(h,0),this[4]=defaultValue(t,0),this[5]=defaultValue(a,0),this[6]=defaultValue(c,0),this[7]=defaultValue(p,0),this[8]=defaultValue(i,0),this[9]=defaultValue(o,0),this[10]=defaultValue(u,0),this[11]=defaultValue(m,0),this[12]=defaultValue(r,0),this[13]=defaultValue(s,0),this[14]=defaultValue(d,0),this[15]=defaultValue(f,0)}Cartesian4.packFloat=function(e,t){return defined(t)||(t=new Cartesian4),scratchF32Array[0]=e,littleEndian?(t.x=scratchU8Array[0],t.y=scratchU8Array[1],t.z=scratchU8Array[2],t.w=scratchU8Array[3]):(t.x=scratchU8Array[3],t.y=scratchU8Array[2],t.z=scratchU8Array[1],t.w=scratchU8Array[0]),t},Cartesian4.unpackFloat=function(e){return littleEndian?(scratchU8Array[0]=e.x,scratchU8Array[1]=e.y,scratchU8Array[2]=e.z,scratchU8Array[3]=e.w):(scratchU8Array[0]=e.w,scratchU8Array[1]=e.z,scratchU8Array[2]=e.y,scratchU8Array[3]=e.x),scratchF32Array[0]},defined(Object.create)&&(RuntimeError.prototype=Object.create(Error.prototype),RuntimeError.prototype.constructor=RuntimeError),RuntimeError.prototype.toString=function(){var e=this.name+": "+this.message;return defined(this.stack)&&(e+="\n"+this.stack.toString()),e},Matrix4.packedLength=16,Matrix4.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},Matrix4.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix4),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},Matrix4.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new Matrix4(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},Matrix4.fromArray=Matrix4.unpack,Matrix4.fromColumnMajorArray=function(e,t){return Matrix4.clone(e,t)},Matrix4.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new Matrix4(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},Matrix4.fromRotationTranslation=function(e,t,i){return t=defaultValue(t,Cartesian3.ZERO),defined(i)?(i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=0,i[4]=e[3],i[5]=e[4],i[6]=e[5],i[7]=0,i[8]=e[6],i[9]=e[7],i[10]=e[8],i[11]=0,i[12]=t.x,i[13]=t.y,i[14]=t.z,i[15]=1,i):new Matrix4(e[0],e[3],e[6],t.x,e[1],e[4],e[7],t.y,e[2],e[5],e[8],t.z,0,0,0,1)},Matrix4.fromTranslationQuaternionRotationScale=function(e,t,i,r){defined(r)||(r=new Matrix4);var n=i.x,a=i.y,o=i.z,s=t.x*t.x,l=t.x*t.y,c=t.x*t.z,u=t.x*t.w,d=t.y*t.y,h=t.y*t.z,p=t.y*t.w,m=t.z*t.z,f=t.z*t.w,g=t.w*t.w,_=s-d-m+g,y=2*(l-f),i=2*(c+p),t=2*(l+f),l=d-s-m+g,f=2*(h-u),p=2*(c-p),u=2*(h+u),g=-s-d+m+g;return r[0]=_*n,r[1]=t*n,r[2]=p*n,r[3]=0,r[4]=y*a,r[5]=l*a,r[6]=u*a,r[7]=0,r[8]=i*o,r[9]=f*o,r[10]=g*o,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r},Matrix4.fromTranslationRotationScale=function(e,t){return Matrix4.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},Matrix4.fromTranslation=function(e,t){return Matrix4.fromRotationTranslation(Matrix3.IDENTITY,e,t)},Matrix4.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Matrix4(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},Matrix4.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Matrix4(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var fromCameraF=new Cartesian3,fromCameraR=new Cartesian3,fromCameraU=new Cartesian3;Matrix4.fromCamera=function(e,t){var i=e.position,r=e.direction,n=e.up;Cartesian3.normalize(r,fromCameraF),Cartesian3.normalize(Cartesian3.cross(fromCameraF,n,fromCameraR),fromCameraR),Cartesian3.normalize(Cartesian3.cross(fromCameraR,fromCameraF,fromCameraU),fromCameraU);var a=fromCameraR.x,o=fromCameraR.y,s=fromCameraR.z,l=fromCameraF.x,c=fromCameraF.y,u=fromCameraF.z,d=fromCameraU.x,h=fromCameraU.y,p=fromCameraU.z,m=i.x,e=i.y,r=i.z,n=a*-m+o*-e+s*-r,i=d*-m+h*-e+p*-r,r=l*m+c*e+u*r;return defined(t)?(t[0]=a,t[1]=d,t[2]=-l,t[3]=0,t[4]=o,t[5]=h,t[6]=-c,t[7]=0,t[8]=s,t[9]=p,t[10]=-u,t[11]=0,t[12]=n,t[13]=i,t[14]=r,t[15]=1,t):new Matrix4(a,o,s,n,d,h,p,i,-l,-c,-u,r,0,0,0,1)},Matrix4.computePerspectiveFieldOfView=function(e,t,i,r,n){var a=1/Math.tan(.5*e),e=a/t,t=(r+i)/(i-r),r=2*r*i/(i-r);return n[0]=e,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=a,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=t,n[11]=-1,n[12]=0,n[13]=0,n[14]=r,n[15]=0,n},Matrix4.computeOrthographicOffCenter=function(e,t,i,r,n,a,o){var s=1/(t-e),l=1/(r-i),c=1/(a-n),e=-(t+e)*s,i=-(r+i)*l,n=-(a+n)*c;return s*=2,l*=2,c*=-2,o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=l,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=e,o[13]=i,o[14]=n,o[15]=1,o},Matrix4.computePerspectiveOffCenter=function(e,t,i,r,n,a,o){var s=2*n/(t-e),l=2*n/(r-i),e=(t+e)/(t-e),r=(r+i)/(r-i),i=-(a+n)/(a-n),n=-2*a*n/(a-n);return o[0]=s,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=l,o[6]=0,o[7]=0,o[8]=e,o[9]=r,o[10]=i,o[11]=-1,o[12]=0,o[13]=0,o[14]=n,o[15]=0,o},Matrix4.computeInfinitePerspectiveOffCenter=function(e,t,i,r,n,a){var o=2*n/(t-e),s=2*n/(r-i),e=(t+e)/(t-e),i=(r+i)/(r-i),n=-2*n;return a[0]=o,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=e,a[9]=i,a[10]=-1,a[11]=-1,a[12]=0,a[13]=0,a[14]=n,a[15]=0,a},Matrix4.computeViewportTransformation=function(e,t,i,r){defined(r)||(r=new Matrix4),e=defaultValue(e,defaultValue.EMPTY_OBJECT);var n=defaultValue(e.x,0),a=defaultValue(e.y,0),o=defaultValue(e.width,0),s=defaultValue(e.height,0);t=defaultValue(t,0);var l=.5*o,e=.5*s,o=.5*((i=defaultValue(i,1))-t),s=e,i=o,n=n+l,e=a+e,o=t+o;return r[0]=l,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=s,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=i,r[11]=0,r[12]=n,r[13]=e,r[14]=o,r[15]=1,r},Matrix4.computeView=function(e,t,i,r,n){return n[0]=r.x,n[1]=i.x,n[2]=-t.x,n[3]=0,n[4]=r.y,n[5]=i.y,n[6]=-t.y,n[7]=0,n[8]=r.z,n[9]=i.z,n[10]=-t.z,n[11]=0,n[12]=-Cartesian3.dot(r,e),n[13]=-Cartesian3.dot(i,e),n[14]=Cartesian3.dot(t,e),n[15]=1,n},Matrix4.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},Matrix4.getElementIndex=function(e,t){return 4*e+t},Matrix4.getColumn=function(e,t,i){var r=4*t,n=e[r],a=e[1+r],t=e[2+r],r=e[3+r];return i.x=n,i.y=a,i.z=t,i.w=r,i},Matrix4.setColumn=function(e,t,i,r){t*=4;return(r=Matrix4.clone(e,r))[t]=i.x,r[1+t]=i.y,r[2+t]=i.z,r[3+t]=i.w,r},Matrix4.setTranslation=function(e,t,i){return i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=e[3],i[4]=e[4],i[5]=e[5],i[6]=e[6],i[7]=e[7],i[8]=e[8],i[9]=e[9],i[10]=e[10],i[11]=e[11],i[12]=t.x,i[13]=t.y,i[14]=t.z,i[15]=e[15],i};var scaleScratch=new Cartesian3;Matrix4.setScale=function(e,t,i){var r=Matrix4.getScale(e,scaleScratch),r=Cartesian3.divideComponents(t,r,scaleScratch);return Matrix4.multiplyByScale(e,r,i)},Matrix4.getRow=function(e,t,i){var r=e[t],n=e[t+4],a=e[t+8],t=e[t+12];return i.x=r,i.y=n,i.z=a,i.w=t,i},Matrix4.setRow=function(e,t,i,r){return(r=Matrix4.clone(e,r))[t]=i.x,r[t+4]=i.y,r[t+8]=i.z,r[t+12]=i.w,r};var scratchColumn$1=new Cartesian3;Matrix4.getScale=function(e,t){return t.x=Cartesian3.magnitude(Cartesian3.fromElements(e[0],e[1],e[2],scratchColumn$1)),t.y=Cartesian3.magnitude(Cartesian3.fromElements(e[4],e[5],e[6],scratchColumn$1)),t.z=Cartesian3.magnitude(Cartesian3.fromElements(e[8],e[9],e[10],scratchColumn$1)),t};var scratchScale$1=new Cartesian3;Matrix4.getMaximumScale=function(e){return Matrix4.getScale(e,scratchScale$1),Cartesian3.maximumComponent(scratchScale$1)},Matrix4.multiply=function(e,t,i){var r=e[0],n=e[1],a=e[2],o=e[3],s=e[4],l=e[5],c=e[6],u=e[7],d=e[8],h=e[9],p=e[10],m=e[11],f=e[12],g=e[13],_=e[14],y=e[15],C=t[0],v=t[1],S=t[2],T=t[3],x=t[4],b=t[5],E=t[6],P=t[7],A=t[8],w=t[9],D=t[10],M=t[11],I=t[12],R=t[13],O=t[14],L=t[15],F=r*C+s*v+d*S+f*T,e=n*C+l*v+h*S+g*T,t=a*C+c*v+p*S+_*T,C=o*C+u*v+m*S+y*T,v=r*x+s*b+d*E+f*P,S=n*x+l*b+h*E+g*P,T=a*x+c*b+p*E+_*P,x=o*x+u*b+m*E+y*P,b=r*A+s*w+d*D+f*M,E=n*A+l*w+h*D+g*M,P=a*A+c*w+p*D+_*M,M=o*A+u*w+m*D+y*M,f=r*I+s*R+d*O+f*L,g=n*I+l*R+h*O+g*L,_=a*I+c*R+p*O+_*L,L=o*I+u*R+m*O+y*L;return i[0]=F,i[1]=e,i[2]=t,i[3]=C,i[4]=v,i[5]=S,i[6]=T,i[7]=x,i[8]=b,i[9]=E,i[10]=P,i[11]=M,i[12]=f,i[13]=g,i[14]=_,i[15]=L,i},Matrix4.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i[4]=e[4]+t[4],i[5]=e[5]+t[5],i[6]=e[6]+t[6],i[7]=e[7]+t[7],i[8]=e[8]+t[8],i[9]=e[9]+t[9],i[10]=e[10]+t[10],i[11]=e[11]+t[11],i[12]=e[12]+t[12],i[13]=e[13]+t[13],i[14]=e[14]+t[14],i[15]=e[15]+t[15],i},Matrix4.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i[4]=e[4]-t[4],i[5]=e[5]-t[5],i[6]=e[6]-t[6],i[7]=e[7]-t[7],i[8]=e[8]-t[8],i[9]=e[9]-t[9],i[10]=e[10]-t[10],i[11]=e[11]-t[11],i[12]=e[12]-t[12],i[13]=e[13]-t[13],i[14]=e[14]-t[14],i[15]=e[15]-t[15],i},Matrix4.multiplyTransformation=function(e,t,i){var r=e[0],n=e[1],a=e[2],o=e[4],s=e[5],l=e[6],c=e[8],u=e[9],d=e[10],h=e[12],p=e[13],m=e[14],f=t[0],g=t[1],_=t[2],y=t[4],C=t[5],v=t[6],S=t[8],T=t[9],x=t[10],b=t[12],E=t[13],P=t[14],e=r*f+o*g+c*_,t=n*f+s*g+u*_,f=a*f+l*g+d*_,g=r*y+o*C+c*v,_=n*y+s*C+u*v,y=a*y+l*C+d*v,C=r*S+o*T+c*x,v=n*S+s*T+u*x,x=a*S+l*T+d*x,h=r*b+o*E+c*P+h,p=n*b+s*E+u*P+p,m=a*b+l*E+d*P+m;return i[0]=e,i[1]=t,i[2]=f,i[3]=0,i[4]=g,i[5]=_,i[6]=y,i[7]=0,i[8]=C,i[9]=v,i[10]=x,i[11]=0,i[12]=h,i[13]=p,i[14]=m,i[15]=1,i},Matrix4.multiplyByMatrix3=function(e,t,i){var r=e[0],n=e[1],a=e[2],o=e[4],s=e[5],l=e[6],c=e[8],u=e[9],d=e[10],h=t[0],p=t[1],m=t[2],f=t[3],g=t[4],_=t[5],y=t[6],C=t[7],v=t[8],S=r*h+o*p+c*m,t=n*h+s*p+u*m,h=a*h+l*p+d*m,p=r*f+o*g+c*_,m=n*f+s*g+u*_,_=a*f+l*g+d*_,c=r*y+o*C+c*v,u=n*y+s*C+u*v,v=a*y+l*C+d*v;return i[0]=S,i[1]=t,i[2]=h,i[3]=0,i[4]=p,i[5]=m,i[6]=_,i[7]=0,i[8]=c,i[9]=u,i[10]=v,i[11]=0,i[12]=e[12],i[13]=e[13],i[14]=e[14],i[15]=e[15],i},Matrix4.multiplyByTranslation=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=r*e[0]+n*e[4]+a*e[8]+e[12],t=r*e[1]+n*e[5]+a*e[9]+e[13],a=r*e[2]+n*e[6]+a*e[10]+e[14];return i[0]=e[0],i[1]=e[1],i[2]=e[2],i[3]=e[3],i[4]=e[4],i[5]=e[5],i[6]=e[6],i[7]=e[7],i[8]=e[8],i[9]=e[9],i[10]=e[10],i[11]=e[11],i[12]=o,i[13]=t,i[14]=a,i[15]=e[15],i};var uniformScaleScratch=new Cartesian3;Matrix4.multiplyByUniformScale=function(e,t,i){return uniformScaleScratch.x=t,uniformScaleScratch.y=t,uniformScaleScratch.z=t,Matrix4.multiplyByScale(e,uniformScaleScratch,i)},Matrix4.multiplyByScale=function(e,t,i){var r=t.x,n=t.y,t=t.z;return 1===r&&1===n&&1===t?Matrix4.clone(e,i):(i[0]=r*e[0],i[1]=r*e[1],i[2]=r*e[2],i[3]=0,i[4]=n*e[4],i[5]=n*e[5],i[6]=n*e[6],i[7]=0,i[8]=t*e[8],i[9]=t*e[9],i[10]=t*e[10],i[11]=0,i[12]=e[12],i[13]=e[13],i[14]=e[14],i[15]=1,i)},Matrix4.multiplyByVector=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=t.w,s=e[0]*r+e[4]*n+e[8]*a+e[12]*o,l=e[1]*r+e[5]*n+e[9]*a+e[13]*o,t=e[2]*r+e[6]*n+e[10]*a+e[14]*o,o=e[3]*r+e[7]*n+e[11]*a+e[15]*o;return i.x=s,i.y=l,i.z=t,i.w=o,i},Matrix4.multiplyByPointAsVector=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=e[0]*r+e[4]*n+e[8]*a,t=e[1]*r+e[5]*n+e[9]*a,a=e[2]*r+e[6]*n+e[10]*a;return i.x=o,i.y=t,i.z=a,i},Matrix4.multiplyByPoint=function(e,t,i){var r=t.x,n=t.y,a=t.z,o=e[0]*r+e[4]*n+e[8]*a+e[12],t=e[1]*r+e[5]*n+e[9]*a+e[13],e=e[2]*r+e[6]*n+e[10]*a+e[14];return i.x=o,i.y=t,i.z=e,i},Matrix4.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i[4]=e[4]*t,i[5]=e[5]*t,i[6]=e[6]*t,i[7]=e[7]*t,i[8]=e[8]*t,i[9]=e[9]*t,i[10]=e[10]*t,i[11]=e[11]*t,i[12]=e[12]*t,i[13]=e[13]*t,i[14]=e[14]*t,i[15]=e[15]*t,i},Matrix4.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},Matrix4.transpose=function(e,t){var i=e[1],r=e[2],n=e[3],a=e[6],o=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=i,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=n,t[13]=o,t[14]=s,t[15]=e[15],t},Matrix4.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},Matrix4.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},Matrix4.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i&&Math.abs(e[4]-t[4])<=i&&Math.abs(e[5]-t[5])<=i&&Math.abs(e[6]-t[6])<=i&&Math.abs(e[7]-t[7])<=i&&Math.abs(e[8]-t[8])<=i&&Math.abs(e[9]-t[9])<=i&&Math.abs(e[10]-t[10])<=i&&Math.abs(e[11]-t[11])<=i&&Math.abs(e[12]-t[12])<=i&&Math.abs(e[13]-t[13])<=i&&Math.abs(e[14]-t[14])<=i&&Math.abs(e[15]-t[15])<=i},Matrix4.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},Matrix4.getMatrix3=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var scratchInverseRotation=new Matrix3,scratchMatrix3Zero=new Matrix3,scratchBottomRow=new Cartesian4,scratchExpectedBottomRow=new Cartesian4(0,0,0,1);Matrix4.inverse=function(e,t){var i=e[0],r=e[4],n=e[8],a=e[12],o=e[1],s=e[5],l=e[9],c=e[13],u=e[2],d=e[6],h=e[10],p=e[14],m=e[3],f=e[7],g=e[11],_=e[15],y=h*_,C=p*g,v=d*_,S=p*f,T=d*g,x=h*f,b=u*_,E=p*m,P=u*g,A=h*m,w=u*f,D=d*m,M=y*s+S*l+T*c-(C*s+v*l+x*c),I=C*o+b*l+A*c-(y*o+E*l+P*c),R=v*o+E*s+w*c-(S*o+b*s+D*c),O=x*o+P*s+D*l-(T*o+A*s+w*l),L=C*r+v*n+x*a-(y*r+S*n+T*a),F=y*i+E*n+P*a-(C*i+b*n+A*a),N=S*i+b*r+D*a-(v*i+E*r+w*a),B=T*i+A*r+w*n-(x*i+P*r+D*n),V=(y=n*c)*f+(S=a*s)*g+(T=r*l)*_-((C=a*l)*f+(v=r*c)*g+(x=n*s)*_),l=C*m+(b=i*c)*g+(A=n*o)*_-(y*m+(E=a*o)*g+(P=i*l)*_),_=v*m+E*f+(w=i*s)*_-(S*m+b*f+(D=r*o)*_),f=x*m+P*f+D*g-(T*m+A*f+w*g),g=v*h+x*p+C*d-(T*p+y*d+S*h),C=P*p+y*u+E*h-(b*h+A*p+C*u),E=b*d+D*p+S*u-(w*p+v*u+E*d),u=w*h+T*u+A*d-(P*d+D*h+x*u),a=i*M+r*I+n*R+a*O;if(Math.abs(a)<CesiumMath.EPSILON21){if(Matrix3.equalsEpsilon(Matrix4.getMatrix3(e,scratchInverseRotation),scratchMatrix3Zero,CesiumMath.EPSILON7)&&Cartesian4.equals(Matrix4.getRow(e,3,scratchBottomRow),scratchExpectedBottomRow))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;throw new RuntimeError("matrix is not invertible because its determinate is zero.")}return a=1/a,t[0]=M*a,t[1]=I*a,t[2]=R*a,t[3]=O*a,t[4]=L*a,t[5]=F*a,t[6]=N*a,t[7]=B*a,t[8]=V*a,t[9]=l*a,t[10]=_*a,t[11]=f*a,t[12]=g*a,t[13]=C*a,t[14]=E*a,t[15]=u*a,t},Matrix4.inverseTransformation=function(e,t){var i=e[0],r=e[1],n=e[2],a=e[4],o=e[5],s=e[6],l=e[8],c=e[9],u=e[10],d=e[12],h=e[13],p=e[14],m=-i*d-r*h-n*p,e=-a*d-o*h-s*p,p=-l*d-c*h-u*p;return t[0]=i,t[1]=a,t[2]=l,t[3]=0,t[4]=r,t[5]=o,t[6]=c,t[7]=0,t[8]=n,t[9]=s,t[10]=u,t[11]=0,t[12]=m,t[13]=e,t[14]=p,t[15]=1,t};var scratchTransposeMatrix$1=new Matrix4;function Rectangle(e,t,i,r){this.west=defaultValue(e,0),this.south=defaultValue(t,0),this.east=defaultValue(i,0),this.north=defaultValue(r,0)}Matrix4.inverseTranspose=function(e,t){return Matrix4.inverse(Matrix4.transpose(e,scratchTransposeMatrix$1),t)},Matrix4.IDENTITY=Object.freeze(new Matrix4(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),Matrix4.ZERO=Object.freeze(new Matrix4(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),Matrix4.COLUMN0ROW0=0,Matrix4.COLUMN0ROW1=1,Matrix4.COLUMN0ROW2=2,Matrix4.COLUMN0ROW3=3,Matrix4.COLUMN1ROW0=4,Matrix4.COLUMN1ROW1=5,Matrix4.COLUMN1ROW2=6,Matrix4.COLUMN1ROW3=7,Matrix4.COLUMN2ROW0=8,Matrix4.COLUMN2ROW1=9,Matrix4.COLUMN2ROW2=10,Matrix4.COLUMN2ROW3=11,Matrix4.COLUMN3ROW0=12,Matrix4.COLUMN3ROW1=13,Matrix4.COLUMN3ROW2=14,Matrix4.COLUMN3ROW3=15,Object.defineProperties(Matrix4.prototype,{length:{get:function(){return Matrix4.packedLength}}}),Matrix4.prototype.clone=function(e){return Matrix4.clone(this,e)},Matrix4.prototype.equals=function(e){return Matrix4.equals(this,e)},Matrix4.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]&&e[4]===t[i+4]&&e[5]===t[i+5]&&e[6]===t[i+6]&&e[7]===t[i+7]&&e[8]===t[i+8]&&e[9]===t[i+9]&&e[10]===t[i+10]&&e[11]===t[i+11]&&e[12]===t[i+12]&&e[13]===t[i+13]&&e[14]===t[i+14]&&e[15]===t[i+15]},Matrix4.prototype.equalsEpsilon=function(e,t){return Matrix4.equalsEpsilon(this,e,t)},Matrix4.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},Object.defineProperties(Rectangle.prototype,{width:{get:function(){return Rectangle.computeWidth(this)}},height:{get:function(){return Rectangle.computeHeight(this)}}}),Rectangle.packedLength=4,Rectangle.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.west,t[i++]=e.south,t[i++]=e.east,t[i]=e.north,t},Rectangle.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Rectangle),i.west=e[t++],i.south=e[t++],i.east=e[t++],i.north=e[t],i},Rectangle.computeWidth=function(e){var t=e.east,e=e.west;return t<e&&(t+=CesiumMath.TWO_PI),t-e},Rectangle.computeHeight=function(e){return e.north-e.south},Rectangle.fromDegrees=function(e,t,i,r,n){return e=CesiumMath.toRadians(defaultValue(e,0)),t=CesiumMath.toRadians(defaultValue(t,0)),i=CesiumMath.toRadians(defaultValue(i,0)),r=CesiumMath.toRadians(defaultValue(r,0)),defined(n)?(n.west=e,n.south=t,n.east=i,n.north=r,n):new Rectangle(e,t,i,r)},Rectangle.fromRadians=function(e,t,i,r,n){return defined(n)?(n.west=defaultValue(e,0),n.south=defaultValue(t,0),n.east=defaultValue(i,0),n.north=defaultValue(r,0),n):new Rectangle(e,t,i,r)},Rectangle.fromCartographicArray=function(e,t){for(var i=Number.MAX_VALUE,r=-Number.MAX_VALUE,n=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,s=-Number.MAX_VALUE,l=0,c=e.length;l<c;l++)var u=e[l],i=Math.min(i,u.longitude),r=Math.max(r,u.longitude),o=Math.min(o,u.latitude),s=Math.max(s,u.latitude),u=0<=u.longitude?u.longitude:u.longitude+CesiumMath.TWO_PI,n=Math.min(n,u),a=Math.max(a,u);return a-n<r-i&&(i=n,(r=a)>CesiumMath.PI&&(r-=CesiumMath.TWO_PI),i>CesiumMath.PI&&(i-=CesiumMath.TWO_PI)),defined(t)?(t.west=i,t.south=o,t.east=r,t.north=s,t):new Rectangle(i,o,r,s)},Rectangle.fromCartesianArray=function(e,t,i){t=defaultValue(t,Ellipsoid.WGS84);for(var r=Number.MAX_VALUE,n=-Number.MAX_VALUE,a=Number.MAX_VALUE,o=-Number.MAX_VALUE,s=Number.MAX_VALUE,l=-Number.MAX_VALUE,c=0,u=e.length;c<u;c++)var d=t.cartesianToCartographic(e[c]),r=Math.min(r,d.longitude),n=Math.max(n,d.longitude),s=Math.min(s,d.latitude),l=Math.max(l,d.latitude),d=0<=d.longitude?d.longitude:d.longitude+CesiumMath.TWO_PI,a=Math.min(a,d),o=Math.max(o,d);return o-a<n-r&&(r=a,(n=o)>CesiumMath.PI&&(n-=CesiumMath.TWO_PI),r>CesiumMath.PI&&(r-=CesiumMath.TWO_PI)),defined(i)?(i.west=r,i.south=s,i.east=n,i.north=l,i):new Rectangle(r,s,n,l)},Rectangle.clone=function(e,t){if(defined(e))return defined(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new Rectangle(e.west,e.south,e.east,e.north)},Rectangle.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e.west-t.west)<=i&&Math.abs(e.south-t.south)<=i&&Math.abs(e.east-t.east)<=i&&Math.abs(e.north-t.north)<=i},Rectangle.prototype.clone=function(e){return Rectangle.clone(this,e)},Rectangle.prototype.equals=function(e){return Rectangle.equals(this,e)},Rectangle.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},Rectangle.prototype.equalsEpsilon=function(e,t){return Rectangle.equalsEpsilon(this,e,t)},Rectangle.validate=function(e){},Rectangle.southwest=function(e,t){return defined(t)?(t.longitude=e.west,t.latitude=e.south,t.height=0,t):new Cartographic(e.west,e.south)},Rectangle.northwest=function(e,t){return defined(t)?(t.longitude=e.west,t.latitude=e.north,t.height=0,t):new Cartographic(e.west,e.north)},Rectangle.northeast=function(e,t){return defined(t)?(t.longitude=e.east,t.latitude=e.north,t.height=0,t):new Cartographic(e.east,e.north)},Rectangle.southeast=function(e,t){return defined(t)?(t.longitude=e.east,t.latitude=e.south,t.height=0,t):new Cartographic(e.east,e.south)},Rectangle.center=function(e,t){var i=e.east,r=e.west;i<r&&(i+=CesiumMath.TWO_PI);i=CesiumMath.negativePiToPi(.5*(r+i)),e=.5*(e.south+e.north);return defined(t)?(t.longitude=i,t.latitude=e,t.height=0,t):new Cartographic(i,e)},Rectangle.intersection=function(e,t,i){var r=e.east,n=e.west,a=t.east,o=t.west;r<n&&0<a?r+=CesiumMath.TWO_PI:a<o&&0<r&&(a+=CesiumMath.TWO_PI),r<n&&o<0?o+=CesiumMath.TWO_PI:a<o&&n<0&&(n+=CesiumMath.TWO_PI);o=CesiumMath.negativePiToPi(Math.max(n,o)),r=CesiumMath.negativePiToPi(Math.min(r,a));if(!((e.west<e.east||t.west<t.east)&&r<=o)){a=Math.max(e.south,t.south),t=Math.min(e.north,t.north);if(!(t<=a))return defined(i)?(i.west=o,i.south=a,i.east=r,i.north=t,i):new Rectangle(o,a,r,t)}},Rectangle.simpleIntersection=function(e,t,i){var r=Math.max(e.west,t.west),n=Math.max(e.south,t.south),a=Math.min(e.east,t.east),t=Math.min(e.north,t.north);if(!(t<=n||a<=r))return defined(i)?(i.west=r,i.south=n,i.east=a,i.north=t,i):new Rectangle(r,n,a,t)},Rectangle.union=function(e,t,i){defined(i)||(i=new Rectangle);var r=e.east,n=e.west,a=t.east,o=t.west;r<n&&0<a?r+=CesiumMath.TWO_PI:a<o&&0<r&&(a+=CesiumMath.TWO_PI),r<n&&o<0?o+=CesiumMath.TWO_PI:a<o&&n<0&&(n+=CesiumMath.TWO_PI);o=CesiumMath.convertLongitudeRange(Math.min(n,o)),a=CesiumMath.convertLongitudeRange(Math.max(r,a));return i.west=o,i.south=Math.min(e.south,t.south),i.east=a,i.north=Math.max(e.north,t.north),i},Rectangle.expand=function(e,t,i){return defined(i)||(i=new Rectangle),i.west=Math.min(e.west,t.longitude),i.south=Math.min(e.south,t.latitude),i.east=Math.max(e.east,t.longitude),i.north=Math.max(e.north,t.latitude),i},Rectangle.contains=function(e,t){var i=t.longitude,r=t.latitude,n=e.west,t=e.east;return t<n&&(t+=CesiumMath.TWO_PI,i<0&&(i+=CesiumMath.TWO_PI)),(n<i||CesiumMath.equalsEpsilon(i,n,CesiumMath.EPSILON14))&&(i<t||CesiumMath.equalsEpsilon(i,t,CesiumMath.EPSILON14))&&r>=e.south&&r<=e.north};var subsampleLlaScratch=new Cartographic;function BoundingSphere(e,t){this.center=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.radius=defaultValue(t,0)}Rectangle.subsample=function(e,t,i,r){t=defaultValue(t,Ellipsoid.WGS84),i=defaultValue(i,0),defined(r)||(r=[]);var n=0,a=e.north,o=e.south,s=e.east,l=e.west,c=subsampleLlaScratch;c.height=i,c.longitude=l,c.latitude=a,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.longitude=s,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.latitude=o,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.longitude=l,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.latitude=a<0?a:0<o?o:0;for(var u=1;u<8;++u)c.longitude=-Math.PI+u*CesiumMath.PI_OVER_TWO,Rectangle.contains(e,c)&&(r[n]=t.cartographicToCartesian(c,r[n]),n++);return 0===c.latitude&&(c.longitude=l,r[n]=t.cartographicToCartesian(c,r[n]),n++,c.longitude=s,r[n]=t.cartographicToCartesian(c,r[n]),n++),r.length=n,r},Rectangle.MAX_VALUE=Object.freeze(new Rectangle(-Math.PI,-CesiumMath.PI_OVER_TWO,Math.PI,CesiumMath.PI_OVER_TWO));var fromPointsXMin=new Cartesian3,fromPointsYMin=new Cartesian3,fromPointsZMin=new Cartesian3,fromPointsXMax=new Cartesian3,fromPointsYMax=new Cartesian3,fromPointsZMax=new Cartesian3,fromPointsCurrentPos=new Cartesian3,fromPointsScratch=new Cartesian3,fromPointsRitterCenter=new Cartesian3,fromPointsMinBoxPt=new Cartesian3,fromPointsMaxBoxPt=new Cartesian3,fromPointsNaiveCenterScratch=new Cartesian3,volumeConstant=4/3*CesiumMath.PI;BoundingSphere.fromPoints=function(e,t){if(defined(t)||(t=new BoundingSphere),!defined(e)||0===e.length)return t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=0,t;for(var i=Cartesian3.clone(e[0],fromPointsCurrentPos),r=Cartesian3.clone(i,fromPointsXMin),n=Cartesian3.clone(i,fromPointsYMin),a=Cartesian3.clone(i,fromPointsZMin),o=Cartesian3.clone(i,fromPointsXMax),s=Cartesian3.clone(i,fromPointsYMax),l=Cartesian3.clone(i,fromPointsZMax),c=e.length,u=1;u<c;u++){Cartesian3.clone(e[u],i);var d=i.x,h=i.y,p=i.z;d<r.x&&Cartesian3.clone(i,r),d>o.x&&Cartesian3.clone(i,o),h<n.y&&Cartesian3.clone(i,n),h>s.y&&Cartesian3.clone(i,s),p<a.z&&Cartesian3.clone(i,a),p>l.z&&Cartesian3.clone(i,l)}var m=Cartesian3.magnitudeSquared(Cartesian3.subtract(o,r,fromPointsScratch)),f=Cartesian3.magnitudeSquared(Cartesian3.subtract(s,n,fromPointsScratch)),g=Cartesian3.magnitudeSquared(Cartesian3.subtract(l,a,fromPointsScratch)),_=r,y=o,m=m;m<f&&(m=f,_=n,y=s),m<g&&(m=g,_=a,y=l);var C=fromPointsRitterCenter;C.x=.5*(_.x+y.x),C.y=.5*(_.y+y.y),C.z=.5*(_.z+y.z);var v=Cartesian3.magnitudeSquared(Cartesian3.subtract(y,C,fromPointsScratch)),S=Math.sqrt(v),_=fromPointsMinBoxPt;_.x=r.x,_.y=n.y,_.z=a.z;y=fromPointsMaxBoxPt;y.x=o.x,y.y=s.y,y.z=l.z;var T=Cartesian3.midpoint(_,y,fromPointsNaiveCenterScratch),x=0;for(u=0;u<c;u++){Cartesian3.clone(e[u],i);var b=Cartesian3.magnitude(Cartesian3.subtract(i,T,fromPointsScratch));x<b&&(x=b);var E=Cartesian3.magnitudeSquared(Cartesian3.subtract(i,C,fromPointsScratch));v<E&&(v=(S=.5*(S+(b=Math.sqrt(E))))*S,E=b-S,C.x=(S*C.x+E*i.x)/b,C.y=(S*C.y+E*i.y)/b,C.z=(S*C.z+E*i.z)/b)}return S<x?(Cartesian3.clone(C,t.center),t.radius=S):(Cartesian3.clone(T,t.center),t.radius=x),t};var defaultProjection=new GeographicProjection,fromRectangle2DLowerLeft=new Cartesian3,fromRectangle2DUpperRight=new Cartesian3,fromRectangle2DSouthwest=new Cartographic,fromRectangle2DNortheast=new Cartographic;BoundingSphere.fromRectangle2D=function(e,t,i){return BoundingSphere.fromRectangleWithHeights2D(e,t,0,0,i)},BoundingSphere.fromRectangleWithHeights2D=function(e,t,i,r,n){if(defined(n)||(n=new BoundingSphere),!defined(e))return n.center=Cartesian3.clone(Cartesian3.ZERO,n.center),n.radius=0,n;t=defaultValue(t,defaultProjection),Rectangle.southwest(e,fromRectangle2DSouthwest),fromRectangle2DSouthwest.height=i,Rectangle.northeast(e,fromRectangle2DNortheast),fromRectangle2DNortheast.height=r;var a=t.project(fromRectangle2DSouthwest,fromRectangle2DLowerLeft),i=t.project(fromRectangle2DNortheast,fromRectangle2DUpperRight),e=i.x-a.x,r=i.y-a.y,t=i.z-a.z;n.radius=.5*Math.sqrt(e*e+r*r+t*t);i=n.center;return i.x=a.x+.5*e,i.y=a.y+.5*r,i.z=a.z+.5*t,n};var fromRectangle3DScratch=[];BoundingSphere.fromRectangle3D=function(e,t,i,r){if(t=defaultValue(t,Ellipsoid.WGS84),i=defaultValue(i,0),defined(r)||(r=new BoundingSphere),!defined(e))return r.center=Cartesian3.clone(Cartesian3.ZERO,r.center),r.radius=0,r;i=Rectangle.subsample(e,t,i,fromRectangle3DScratch);return BoundingSphere.fromPoints(i,r)},BoundingSphere.fromVertices=function(e,t,i,r){if(defined(r)||(r=new BoundingSphere),!defined(e)||0===e.length)return r.center=Cartesian3.clone(Cartesian3.ZERO,r.center),r.radius=0,r;t=defaultValue(t,Cartesian3.ZERO),i=defaultValue(i,3);var n=fromPointsCurrentPos;n.x=e[0]+t.x,n.y=e[1]+t.y,n.z=e[2]+t.z;for(var a=Cartesian3.clone(n,fromPointsXMin),o=Cartesian3.clone(n,fromPointsYMin),s=Cartesian3.clone(n,fromPointsZMin),l=Cartesian3.clone(n,fromPointsXMax),c=Cartesian3.clone(n,fromPointsYMax),u=Cartesian3.clone(n,fromPointsZMax),d=e.length,h=0;h<d;h+=i){var p=e[h]+t.x,m=e[h+1]+t.y,f=e[h+2]+t.z;n.x=p,n.y=m,n.z=f,p<a.x&&Cartesian3.clone(n,a),p>l.x&&Cartesian3.clone(n,l),m<o.y&&Cartesian3.clone(n,o),m>c.y&&Cartesian3.clone(n,c),f<s.z&&Cartesian3.clone(n,s),f>u.z&&Cartesian3.clone(n,u)}var g=Cartesian3.magnitudeSquared(Cartesian3.subtract(l,a,fromPointsScratch)),_=Cartesian3.magnitudeSquared(Cartesian3.subtract(c,o,fromPointsScratch)),y=Cartesian3.magnitudeSquared(Cartesian3.subtract(u,s,fromPointsScratch)),C=a,v=l,g=g;g<_&&(g=_,C=o,v=c),g<y&&(g=y,C=s,v=u);var S=fromPointsRitterCenter;S.x=.5*(C.x+v.x),S.y=.5*(C.y+v.y),S.z=.5*(C.z+v.z);var T=Cartesian3.magnitudeSquared(Cartesian3.subtract(v,S,fromPointsScratch)),x=Math.sqrt(T),C=fromPointsMinBoxPt;C.x=a.x,C.y=o.y,C.z=s.z;v=fromPointsMaxBoxPt;v.x=l.x,v.y=c.y,v.z=u.z;var b=Cartesian3.midpoint(C,v,fromPointsNaiveCenterScratch),E=0;for(h=0;h<d;h+=i){n.x=e[h]+t.x,n.y=e[h+1]+t.y,n.z=e[h+2]+t.z;var P=Cartesian3.magnitude(Cartesian3.subtract(n,b,fromPointsScratch));E<P&&(E=P);var A=Cartesian3.magnitudeSquared(Cartesian3.subtract(n,S,fromPointsScratch));T<A&&(T=(x=.5*(x+(P=Math.sqrt(A))))*x,A=P-x,S.x=(x*S.x+A*n.x)/P,S.y=(x*S.y+A*n.y)/P,S.z=(x*S.z+A*n.z)/P)}return x<E?(Cartesian3.clone(S,r.center),r.radius=x):(Cartesian3.clone(b,r.center),r.radius=E),r},BoundingSphere.fromEncodedCartesianVertices=function(e,t,i){if(defined(i)||(i=new BoundingSphere),!defined(e)||!defined(t)||e.length!==t.length||0===e.length)return i.center=Cartesian3.clone(Cartesian3.ZERO,i.center),i.radius=0,i;var r=fromPointsCurrentPos;r.x=e[0]+t[0],r.y=e[1]+t[1],r.z=e[2]+t[2];for(var n=Cartesian3.clone(r,fromPointsXMin),a=Cartesian3.clone(r,fromPointsYMin),o=Cartesian3.clone(r,fromPointsZMin),s=Cartesian3.clone(r,fromPointsXMax),l=Cartesian3.clone(r,fromPointsYMax),c=Cartesian3.clone(r,fromPointsZMax),u=e.length,d=0;d<u;d+=3){var h=e[d]+t[d],p=e[d+1]+t[d+1],m=e[d+2]+t[d+2];r.x=h,r.y=p,r.z=m,h<n.x&&Cartesian3.clone(r,n),h>s.x&&Cartesian3.clone(r,s),p<a.y&&Cartesian3.clone(r,a),p>l.y&&Cartesian3.clone(r,l),m<o.z&&Cartesian3.clone(r,o),m>c.z&&Cartesian3.clone(r,c)}var f=Cartesian3.magnitudeSquared(Cartesian3.subtract(s,n,fromPointsScratch)),g=Cartesian3.magnitudeSquared(Cartesian3.subtract(l,a,fromPointsScratch)),_=Cartesian3.magnitudeSquared(Cartesian3.subtract(c,o,fromPointsScratch)),y=n,C=s,f=f;f<g&&(f=g,y=a,C=l),f<_&&(f=_,y=o,C=c);var v=fromPointsRitterCenter;v.x=.5*(y.x+C.x),v.y=.5*(y.y+C.y),v.z=.5*(y.z+C.z);var S=Cartesian3.magnitudeSquared(Cartesian3.subtract(C,v,fromPointsScratch)),T=Math.sqrt(S),y=fromPointsMinBoxPt;y.x=n.x,y.y=a.y,y.z=o.z;C=fromPointsMaxBoxPt;C.x=s.x,C.y=l.y,C.z=c.z;var x=Cartesian3.midpoint(y,C,fromPointsNaiveCenterScratch),b=0;for(d=0;d<u;d+=3){r.x=e[d]+t[d],r.y=e[d+1]+t[d+1],r.z=e[d+2]+t[d+2];var E=Cartesian3.magnitude(Cartesian3.subtract(r,x,fromPointsScratch));b<E&&(b=E);var P=Cartesian3.magnitudeSquared(Cartesian3.subtract(r,v,fromPointsScratch));S<P&&(S=(T=.5*(T+(E=Math.sqrt(P))))*T,P=E-T,v.x=(T*v.x+P*r.x)/E,v.y=(T*v.y+P*r.y)/E,v.z=(T*v.z+P*r.z)/E)}return T<b?(Cartesian3.clone(v,i.center),i.radius=T):(Cartesian3.clone(x,i.center),i.radius=b),i},BoundingSphere.fromCornerPoints=function(e,t,i){defined(i)||(i=new BoundingSphere);e=Cartesian3.midpoint(e,t,i.center);return i.radius=Cartesian3.distance(e,t),i},BoundingSphere.fromEllipsoid=function(e,t){return defined(t)||(t=new BoundingSphere),Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=e.maximumRadius,t};var fromBoundingSpheresScratch=new Cartesian3;BoundingSphere.fromBoundingSpheres=function(e,t){if(defined(t)||(t=new BoundingSphere),!defined(e)||0===e.length)return t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t.radius=0,t;var i=e.length;if(1===i)return BoundingSphere.clone(e[0],t);if(2===i)return BoundingSphere.union(e[0],e[1],t);for(var r=[],n=0;n<i;n++)r.push(e[n].center);var a=(t=BoundingSphere.fromPoints(r,t)).center,o=t.radius;for(n=0;n<i;n++)var s=e[n],o=Math.max(o,Cartesian3.distance(a,s.center,fromBoundingSpheresScratch)+s.radius);return t.radius=o,t};var fromOrientedBoundingBoxScratchU=new Cartesian3,fromOrientedBoundingBoxScratchV=new Cartesian3,fromOrientedBoundingBoxScratchW=new Cartesian3;BoundingSphere.fromOrientedBoundingBox=function(e,t){defined(t)||(t=new BoundingSphere);var i=e.halfAxes,r=Matrix3.getColumn(i,0,fromOrientedBoundingBoxScratchU),n=Matrix3.getColumn(i,1,fromOrientedBoundingBoxScratchV),i=Matrix3.getColumn(i,2,fromOrientedBoundingBoxScratchW);return Cartesian3.add(r,n,r),Cartesian3.add(r,i,r),t.center=Cartesian3.clone(e.center,t.center),t.radius=Cartesian3.magnitude(r),t},BoundingSphere.clone=function(e,t){if(defined(e))return defined(t)?(t.center=Cartesian3.clone(e.center,t.center),t.radius=e.radius,t):new BoundingSphere(e.center,e.radius)},BoundingSphere.packedLength=4,BoundingSphere.pack=function(e,t,i){i=defaultValue(i,0);var r=e.center;return t[i++]=r.x,t[i++]=r.y,t[i++]=r.z,t[i]=e.radius,t},BoundingSphere.unpack=function(e,t,i){t=defaultValue(t,0),defined(i)||(i=new BoundingSphere);var r=i.center;return r.x=e[t++],r.y=e[t++],r.z=e[t++],i.radius=e[t],i};var unionScratch=new Cartesian3,unionScratchCenter=new Cartesian3;BoundingSphere.union=function(e,t,i){defined(i)||(i=new BoundingSphere);var r=e.center,n=e.radius,a=t.center,o=t.radius,s=Cartesian3.subtract(a,r,unionScratch),a=Cartesian3.magnitude(s);if(a+o<=n)return e.clone(i),i;if(a+n<=o)return t.clone(i),i;o=.5*(n+a+o),a=Cartesian3.multiplyByScalar(s,(o-n)/a,unionScratchCenter);return Cartesian3.add(a,r,a),Cartesian3.clone(a,i.center),i.radius=o,i};var expandScratch=new Cartesian3;BoundingSphere.expand=function(e,t,i){i=BoundingSphere.clone(e,i);t=Cartesian3.magnitude(Cartesian3.subtract(t,i.center,expandScratch));return t>i.radius&&(i.radius=t),i},BoundingSphere.intersectPlane=function(e,t){var i=e.center,r=e.radius,e=t.normal,t=Cartesian3.dot(e,i)+t.distance;return t<-r?Intersect$1.OUTSIDE:t<r?Intersect$1.INTERSECTING:Intersect$1.INSIDE},BoundingSphere.transform=function(e,t,i){return defined(i)||(i=new BoundingSphere),i.center=Matrix4.multiplyByPoint(t,e.center,i.center),i.radius=Matrix4.getMaximumScale(t)*e.radius,i};var distanceSquaredToScratch=new Cartesian3;BoundingSphere.distanceSquaredTo=function(e,t){t=Cartesian3.subtract(e.center,t,distanceSquaredToScratch);return Cartesian3.magnitudeSquared(t)-e.radius*e.radius},BoundingSphere.transformWithoutScale=function(e,t,i){return defined(i)||(i=new BoundingSphere),i.center=Matrix4.multiplyByPoint(t,e.center,i.center),i.radius=e.radius,i};var scratchCartesian3=new Cartesian3;BoundingSphere.computePlaneDistances=function(e,t,i,r){defined(r)||(r=new Interval);t=Cartesian3.subtract(e.center,t,scratchCartesian3),t=Cartesian3.dot(i,t);return r.start=t-e.radius,r.stop=t+e.radius,r};for(var projectTo2DNormalScratch=new Cartesian3,projectTo2DEastScratch=new Cartesian3,projectTo2DNorthScratch=new Cartesian3,projectTo2DWestScratch=new Cartesian3,projectTo2DSouthScratch=new Cartesian3,projectTo2DCartographicScratch=new Cartographic,projectTo2DPositionsScratch=new Array(8),n=0;n<8;++n)projectTo2DPositionsScratch[n]=new Cartesian3;var projectTo2DProjection=new GeographicProjection;function URI(e){e instanceof URI?(this.scheme=e.scheme,this.authority=e.authority,this.path=e.path,this.query=e.query,this.fragment=e.fragment):e&&(e=parseRegex.exec(e),this.scheme=e[1],this.authority=e[2],this.path=e[3],this.query=e[4],this.fragment=e[5])}BoundingSphere.projectTo2D=function(e,t,i){var r=(t=defaultValue(t,projectTo2DProjection)).ellipsoid,n=e.center,a=e.radius,o=Cartesian3.equals(n,Cartesian3.ZERO)?Cartesian3.clone(Cartesian3.UNIT_X,projectTo2DNormalScratch):r.geodeticSurfaceNormal(n,projectTo2DNormalScratch),s=Cartesian3.cross(Cartesian3.UNIT_Z,o,projectTo2DEastScratch);Cartesian3.normalize(s,s);var l=Cartesian3.cross(o,s,projectTo2DNorthScratch);Cartesian3.normalize(l,l),Cartesian3.multiplyByScalar(o,a,o),Cartesian3.multiplyByScalar(l,a,l),Cartesian3.multiplyByScalar(s,a,s);var c=Cartesian3.negate(l,projectTo2DSouthScratch),e=Cartesian3.negate(s,projectTo2DWestScratch),u=projectTo2DPositionsScratch,a=u[0];Cartesian3.add(o,l,a),Cartesian3.add(a,s,a),a=u[1],Cartesian3.add(o,l,a),Cartesian3.add(a,e,a),a=u[2],Cartesian3.add(o,c,a),Cartesian3.add(a,e,a),a=u[3],Cartesian3.add(o,c,a),Cartesian3.add(a,s,a),Cartesian3.negate(o,o),a=u[4],Cartesian3.add(o,l,a),Cartesian3.add(a,s,a),a=u[5],Cartesian3.add(o,l,a),Cartesian3.add(a,e,a),a=u[6],Cartesian3.add(o,c,a),Cartesian3.add(a,e,a),a=u[7],Cartesian3.add(o,c,a),Cartesian3.add(a,s,a);for(var d=u.length,h=0;h<d;++h){var p=u[h];Cartesian3.add(n,p,p);var m=r.cartesianToCartographic(p,projectTo2DCartographicScratch);t.project(m,p)}c=(n=(i=BoundingSphere.fromPoints(u,i)).center).x,s=n.y,a=n.z;return n.x=a,n.y=c,n.z=s,i},BoundingSphere.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},BoundingSphere.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&e.radius===t.radius},BoundingSphere.prototype.intersectPlane=function(e){return BoundingSphere.intersectPlane(this,e)},BoundingSphere.prototype.distanceSquaredTo=function(e){return BoundingSphere.distanceSquaredTo(this,e)},BoundingSphere.prototype.computePlaneDistances=function(e,t,i){return BoundingSphere.computePlaneDistances(this,e,t,i)},BoundingSphere.prototype.isOccluded=function(e){return BoundingSphere.isOccluded(this,e)},BoundingSphere.prototype.equals=function(e){return BoundingSphere.equals(this,e)},BoundingSphere.prototype.clone=function(e){return BoundingSphere.clone(this,e)},BoundingSphere.prototype.volume=function(){var e=this.radius;return volumeConstant*e*e*e},URI.prototype.scheme=null,URI.prototype.authority=null,URI.prototype.path="",URI.prototype.query=null,URI.prototype.fragment=null;var parseRegex=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");URI.prototype.getScheme=function(){return this.scheme},URI.prototype.getAuthority=function(){return this.authority},URI.prototype.getPath=function(){return this.path},URI.prototype.getQuery=function(){return this.query},URI.prototype.getFragment=function(){return this.fragment},URI.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},URI.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},URI.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},URI.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(authorityRegex,replaceAuthority).replace(caseRegex,replaceCase)),this.path&&(this.path=this.path.replace(caseRegex,replaceCase)),this.query&&(this.query=this.query.replace(caseRegex,replaceCase)),this.fragment&&(this.fragment=this.fragment.replace(caseRegex,replaceCase))};var caseRegex=/%[0-9a-z]{2}/gi,percentRegex=/[a-zA-Z0-9\-\._~]/,authorityRegex=/(.*@)?([^@:]*)(:.*)?/,reduceArray,slice,undef;function replaceCase(e){var t=unescape(e);return percentRegex.test(t)?t:e.toUpperCase()}function replaceAuthority(e,t,i,r){return(t||"")+i.toLowerCase()+(r||"")}function getAbsoluteUri(e,t){var i;return"undefined"!=typeof document&&(i=document),getAbsoluteUri._implementation(e,t,i)}function when(e,t,i,r){return resolve(e).then(t,i,r)}function resolve(e){var t,e=e instanceof Promise$1?e:isPromise(e)?(t=defer(),e.then(function(e){t.resolve(e)},function(e){t.reject(e)},function(e){t.progress(e)}),t.promise):fulfilled(e);return e}function reject(e){return when(e,rejected)}function Promise$1(e){this.then=e}function fulfilled(t){return new Promise$1(function(e){try{return resolve(e?e(t):t)}catch(e){return rejected(e)}})}function rejected(i){return new Promise$1(function(e,t){try{return t?resolve(t(i)):rejected(i)}catch(e){return rejected(e)}})}function defer(){var e=new Promise$1(n),o=[],s=[],r=function(t,i,r){var n=defer(),a="function"==typeof r?function(e){try{n.progress(r(e))}catch(e){n.progress(e)}}:function(e){n.progress(e)};return o.push(function(e){e.then(t,i).then(n.resolve,n.reject,a)}),s.push(a),n.promise},t=function(e){return processQueue(s,e),e},i=function(e){return e=resolve(e),r=e.then,i=resolve,t=noop,processQueue(o,e),s=o=undef,e};return{then:n,resolve:a,reject:l,progress:c,promise:e,resolver:{resolve:a,reject:l,progress:c}};function n(e,t,i){return r(e,t,i)}function a(e){return i(e)}function l(e){return i(rejected(e))}function c(e){return t(e)}}function isPromise(e){return e&&"function"==typeof e.then}function some(e,p,m,f,g){return checkCallbacks(2,arguments),when(e,function(e){var t,i,r,n,a=e.length>>>0,o=Math.max(0,Math.min(p,a)),s=[],l=a-o+1,c=[],u=defer();if(o)for(r=u.progress,i=function(e){c.push(e),--l||(t=i=noop,u.reject(c))},t=function(e){s.push(e),--o||(t=i=noop,u.resolve(s))},n=0;n<a;++n)n in e&&when(e[n],h,d,r);else u.resolve(s);return u.then(m,f,g);function d(e){i(e)}function h(e){t(e)}})}function any(e,t,i,r){return some(e,1,function(e){return t?t(e[0]):e[0]},i,r)}function all(e,t,i,r){return checkCallbacks(1,arguments),map(e,identity).then(t,i,r)}function join(){return map(arguments,identity)}function map(e,s){return when(e,function(e){var t,i,r,n=t=e.length>>>0,a=[],o=defer();if(n)for(i=function(e,t){when(e,s).then(function(e){a[t]=e,--n||o.resolve(a)},o.reject)},r=0;r<t;r++)r in e?i(e[r],r):--n;else o.resolve(a);return o.promise})}function reduce(e,a){var t=slice.call(arguments,1);return when(e,function(e){var n=e.length;return t[0]=function(e,i,r){return when(e,function(t){return when(i,function(e){return a(t,e,r,n)})})},reduceArray.apply(e,t)})}function chain(e,t,i){var r=2<arguments.length;return when(e,function(e){return e=r?i:e,t.resolve(e),e},function(e){return t.reject(e),rejected(e)},t.progress)}function processQueue(e,t){for(var i,r=0;i=e[r++];)i(t)}function checkCallbacks(e,t){for(var i,r=t.length;e<r;)if(null!=(i=t[--r])&&"function"!=typeof i)throw new Error("arg "+r+" must be a function")}function noop(){}function identity(e){return e}function appendForwardSlash(e){return 0!==e.length&&"/"===e[e.length-1]||(e+="/"),e}function clone(e,t){if(null===e||"object"!=typeof e)return e;t=defaultValue(t,!1);var i,r,n=new e.constructor;for(i in e)e.hasOwnProperty(i)&&(r=e[i],t&&(r=clone(r,t)),n[i]=r);return n}function combine(e,t,i){i=defaultValue(i,!1);var r,n,a,o={},s=defined(e),l=defined(t);if(s)for(r in e)e.hasOwnProperty(r)&&(n=e[r],l&&i&&"object"==typeof n&&t.hasOwnProperty(r)?(a=t[r],o[r]="object"==typeof a?combine(n,a,i):n):o[r]=n);if(l)for(r in t)t.hasOwnProperty(r)&&!o.hasOwnProperty(r)&&(a=t[r],o[r]=a);return o}function getBaseUri(e,t){var i="",r=e.lastIndexOf("/");return-1!==r&&(i=e.substring(0,r+1)),t&&(defined((e=new URI(e)).query)&&(i+="?"+e.query),defined(e.fragment)&&(i+="#"+e.fragment)),i}function getExtensionFromUri(e){var t=new URI(e);t.normalize();e=t.path,t=e.lastIndexOf("/");return-1!==t&&(e=e.substr(t+1)),e=-1===(t=e.lastIndexOf("."))?"":e.substr(t+1)}URI.prototype.resolve=function(e){var t=new URI;return this.scheme?(t.scheme=this.scheme,t.authority=this.authority,t.path=this.path,t.query=this.query):(t.scheme=e.scheme,this.authority?(t.authority=this.authority,t.path=this.path,t.query=this.query):(t.authority=e.authority,""==this.path?(t.path=e.path,t.query=this.query||e.query):("/"==this.path.charAt(0)?t.path=this.path:e.authority&&""==e.path?t.path="/"+this.path:t.path=e.path.substring(0,e.path.lastIndexOf("/")+1)+this.path,t.removeDotSegments(),t.query=this.query))),t.fragment=this.fragment,t},URI.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),i=[],r=""==t[0];r&&t.shift();for(""==t[0]&&t.shift();t.length;)".."==(e=t.shift())?i.pop():"."!=e&&i.push(e);"."!=e&&".."!=e||i.push(""),r&&i.unshift(""),this.path=i.join("/")},URI.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},getAbsoluteUri._implementation=function(e,t,i){if(!defined(t)){if(void 0===i)return e;t=defaultValue(i.baseURI,i.location.href)}t=new URI(t);return new URI(e).resolve(t).toString()},when.defer=defer,when.resolve=resolve,when.reject=reject,when.join=join,when.all=all,when.map=map,when.reduce=reduce,when.any=any,when.some=some,when.chain=chain,when.isPromise=isPromise,Promise$1.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(undef,e)},yield:function(e){return this.then(function(){return e})},spread:function(t){return this.then(function(e){return all(e,function(e){return t.apply(undef,e)})})}},slice=[].slice,reduceArray=[].reduce||function(e){var t,i=0,r=Object(this),n=r.length>>>0,a=arguments;if(a.length<=1)for(;;){if(i in r){t=r[i++];break}if(++i>=n)throw new TypeError}else t=a[1];for(;i<n;++i)i in r&&(t=e(t,r[i],i,r));return t};var blobUriRegex=/^blob:/i,a;function isBlobUri(e){return blobUriRegex.test(e)}function isCrossOriginUrl(e){defined(a)||(a=document.createElement("a")),a.href=window.location.href;var t=a.host,i=a.protocol;return a.href=e,a.href=a.href,i!==a.protocol||t!==a.host}var dataUriRegex=/^data:/i;function isDataUri(e){return dataUriRegex.test(e)}function loadAndExecuteScript(e){var t=when.defer(),i=document.createElement("script");i.async=!0,i.src=e;var r=document.getElementsByTagName("head")[0];return i.onload=function(){i.onload=void 0,r.removeChild(i),t.resolve()},i.onerror=function(e){t.reject(e)},r.appendChild(i),t.promise}function objectToQuery(e){var t,i="";for(t in e)if(e.hasOwnProperty(t)){var r=e[t],n=encodeURIComponent(t)+"=";if(Array.isArray(r))for(var a=0,o=r.length;a<o;++a)i+=n+encodeURIComponent(r[a])+"&";else i+=n+encodeURIComponent(r)+"&"}return i=i.slice(0,-1)}function queryToObject(e){var t={};if(""===e)return t;for(var i=e.replace(/\+/g,"%20").split(/[&;]/),r=0,n=i.length;r<n;++r){var a=i[r].split("="),o=decodeURIComponent(a[0]),s=defined(s=a[1])?decodeURIComponent(s):"",a=t[o];"string"==typeof a?t[o]=[a,s]:Array.isArray(a)?a.push(s):t[o]=s}return t}var RequestState={UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5},RequestState$1=Object.freeze(RequestState),RequestType={TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3},RequestType$1=Object.freeze(RequestType);function Request(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.throttleByServer,!1),i=defaultValue(e.throttle,!1);this.url=e.url,this.requestFunction=e.requestFunction,this.cancelFunction=e.cancelFunction,this.priorityFunction=e.priorityFunction,this.priority=defaultValue(e.priority,0),this.throttle=i,this.throttleByServer=t,this.type=defaultValue(e.type,RequestType$1.OTHER),this.serverKey=void 0,this.state=RequestState$1.UNISSUED,this.deferred=void 0,this.cancelled=!1}function parseResponseHeaders(e){var t={};if(!e)return t;for(var i=e.split("\r\n"),r=0;r<i.length;++r){var n,a=i[r],o=a.indexOf(": ");0<o&&(n=a.substring(0,o),o=a.substring(o+2),t[n]=o)}return t}function RequestErrorEvent(e,t,i){this.statusCode=e,this.response=t,this.responseHeaders=i,"string"==typeof this.responseHeaders&&(this.responseHeaders=parseResponseHeaders(this.responseHeaders))}function Event(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function compareNumber(e,t){return t-e}function Heap(e){this._comparator=e.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function swap(e,t,i){var r=e[t];e[t]=e[i],e[i]=r}function sortRequests(e,t){return e.priority-t.priority}Request.prototype.cancel=function(){this.cancelled=!0},Request.prototype.clone=function(e){return defined(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new Request(this)},RequestErrorEvent.prototype.toString=function(){var e="Request has failed.";return defined(this.statusCode)&&(e+=" Status Code: "+this.statusCode),e},Object.defineProperties(Event.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),Event.prototype.addEventListener=function(e,t){this._listeners.push(e),this._scopes.push(t);var i=this;return function(){i.removeEventListener(e,t)}},Event.prototype.removeEventListener=function(e,t){for(var i=this._listeners,r=this._scopes,n=-1,a=0;a<i.length;a++)if(i[a]===e&&r[a]===t){n=a;break}return-1!==n&&(this._insideRaiseEvent?(this._toRemove.push(n),i[n]=void 0,r[n]=void 0):(i.splice(n,1),r.splice(n,1)),!0)},Event.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;for(var e=this._listeners,t=this._scopes,i=e.length,r=0;r<i;r++)defined(e[r])&&e[r].apply(t[r],arguments);var n=this._toRemove;if(0<(i=n.length)){for(n.sort(compareNumber),r=0;r<i;r++){var a=n[r];e.splice(a,1),t.splice(a,1)}n.length=0}this._insideRaiseEvent=!1},Object.defineProperties(Heap.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){var t=this._length;if(e<t){for(var i=this._array,r=e;r<t;++r)i[r]=void 0;this._length=e,i.length=e}this._maximumLength=e}},comparator:{get:function(){return this._comparator}}}),Heap.prototype.reserve=function(e){e=defaultValue(e,this._length),this._array.length=e},Heap.prototype.heapify=function(e){e=defaultValue(e,0);for(var t=this._length,i=this._comparator,r=this._array,n=-1,a=!0;a;){var o=2*(e+1),s=o-1,n=s<t&&i(r[s],r[e])<0?s:e;o<t&&i(r[o],r[n])<0&&(n=o),n!==e?(swap(r,n,e),e=n):a=!1}},Heap.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);0<=t;--t)this.heapify(t)},Heap.prototype.insert=function(e){var t,i=this._array,r=this._comparator,n=this._maximumLength,a=this._length++;for(a<i.length?i[a]=e:i.push(e);0!==a;){var o=Math.floor((a-1)/2);if(!(r(i[a],i[o])<0))break;swap(i,a,o),a=o}return defined(n)&&this._length>n&&(t=i[n],this._length=n),t},Heap.prototype.pop=function(e){if(e=defaultValue(e,0),0!==this._length){var t=this._array,i=t[e];return swap(t,e,--this._length),this.heapify(e),t[this._length]=void 0,i}};var statistics={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0},priorityHeapLength=20,requestHeap=new Heap({comparator:sortRequests});requestHeap.maximumLength=priorityHeapLength,requestHeap.reserve(priorityHeapLength);var activeRequests=[],numberOfActiveRequestsByServer={},pageUri="undefined"!=typeof document?new URI(document.location.href):new URI,requestCompletedEvent=new Event;function RequestScheduler(){}function updatePriority(e){defined(e.priorityFunction)&&(e.priority=e.priorityFunction())}function serverHasOpenSlots(e){var t=defaultValue(RequestScheduler.requestsByServer[e],RequestScheduler.maximumRequestsPerServer);return numberOfActiveRequestsByServer[e]<t}function issueRequest(e){return e.state===RequestState$1.UNISSUED&&(e.state=RequestState$1.ISSUED,e.deferred=when.defer()),e.deferred.promise}function getRequestReceivedFunction(i){return function(e){var t;i.state!==RequestState$1.CANCELLED&&(t=i.deferred,--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[i.serverKey],requestCompletedEvent.raiseEvent(),i.state=RequestState$1.RECEIVED,i.deferred=void 0,t.resolve(e))}}function getRequestFailedFunction(t){return function(e){t.state!==RequestState$1.CANCELLED&&(++statistics.numberOfFailedRequests,--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[t.serverKey],requestCompletedEvent.raiseEvent(e),t.state=RequestState$1.FAILED,t.deferred.reject(e))}}function startRequest(e){var t=issueRequest(e);return e.state=RequestState$1.ACTIVE,activeRequests.push(e),++statistics.numberOfActiveRequests,++statistics.numberOfActiveRequestsEver,++numberOfActiveRequestsByServer[e.serverKey],e.requestFunction().then(getRequestReceivedFunction(e)).otherwise(getRequestFailedFunction(e)),t}function cancelRequest(e){var t,i=e.state===RequestState$1.ACTIVE;e.state=RequestState$1.CANCELLED,++statistics.numberOfCancelledRequests,defined(e.deferred)&&(t=e.deferred,e.deferred=void 0,t.reject()),i&&(--statistics.numberOfActiveRequests,--numberOfActiveRequestsByServer[e.serverKey],++statistics.numberOfCancelledActiveRequests),defined(e.cancelFunction)&&e.cancelFunction()}function updateStatistics(){RequestScheduler.debugShowStatistics&&(0===statistics.numberOfActiveRequests&&0<statistics.lastNumberOfActiveRequests&&(0<statistics.numberOfAttemptedRequests&&(console.log("Number of attempted requests: "+statistics.numberOfAttemptedRequests),statistics.numberOfAttemptedRequests=0),0<statistics.numberOfCancelledRequests&&(console.log("Number of cancelled requests: "+statistics.numberOfCancelledRequests),statistics.numberOfCancelledRequests=0),0<statistics.numberOfCancelledActiveRequests&&(console.log("Number of cancelled active requests: "+statistics.numberOfCancelledActiveRequests),statistics.numberOfCancelledActiveRequests=0),0<statistics.numberOfFailedRequests&&(console.log("Number of failed requests: "+statistics.numberOfFailedRequests),statistics.numberOfFailedRequests=0)),statistics.lastNumberOfActiveRequests=statistics.numberOfActiveRequests)}RequestScheduler.maximumRequests=50,RequestScheduler.maximumRequestsPerServer=6,RequestScheduler.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},RequestScheduler.throttleRequests=!0,RequestScheduler.debugShowStatistics=!1,RequestScheduler.requestCompletedEvent=requestCompletedEvent,Object.defineProperties(RequestScheduler,{statistics:{get:function(){return statistics}},priorityHeapLength:{get:function(){return priorityHeapLength},set:function(e){if(e<priorityHeapLength)for(;requestHeap.length>e;)cancelRequest(requestHeap.pop());priorityHeapLength=e,requestHeap.maximumLength=e,requestHeap.reserve(e)}}}),RequestScheduler.update=function(){for(var e,t=0,i=activeRequests.length,r=0;r<i;++r)(e=activeRequests[r]).cancelled&&cancelRequest(e),e.state===RequestState$1.ACTIVE?0<t&&(activeRequests[r-t]=e):++t;activeRequests.length-=t;var n=requestHeap.internalArray,a=requestHeap.length;for(r=0;r<a;++r)updatePriority(n[r]);requestHeap.resort();for(var o=Math.max(RequestScheduler.maximumRequests-activeRequests.length,0),s=0;s<o&&0<requestHeap.length;)!(e=requestHeap.pop()).cancelled&&(!e.throttleByServer||serverHasOpenSlots(e.serverKey))?(startRequest(e),++s):cancelRequest(e);updateStatistics()},RequestScheduler.getServerKey=function(e){var t=new URI(e).resolve(pageUri);t.normalize();e=t.authority;return/:/.test(e)||(e=e+":"+("https"===t.scheme?"443":"80")),defined(numberOfActiveRequestsByServer[e])||(numberOfActiveRequestsByServer[e]=0),e},RequestScheduler.request=function(e){if(isDataUri(e.url)||isBlobUri(e.url))return requestCompletedEvent.raiseEvent(),e.state=RequestState$1.RECEIVED,e.requestFunction();if(++statistics.numberOfAttemptedRequests,defined(e.serverKey)||(e.serverKey=RequestScheduler.getServerKey(e.url)),!RequestScheduler.throttleRequests||!e.throttleByServer||serverHasOpenSlots(e.serverKey)){if(!RequestScheduler.throttleRequests||!e.throttle)return startRequest(e);if(!(activeRequests.length>=RequestScheduler.maximumRequests)){updatePriority(e);var t=requestHeap.insert(e);if(defined(t)){if(t===e)return;cancelRequest(t)}return issueRequest(e)}}},RequestScheduler.clearForSpecs=function(){for(;0<requestHeap.length;)cancelRequest(requestHeap.pop());for(var e=activeRequests.length,t=0;t<e;++t)cancelRequest(activeRequests[t]);activeRequests.length=0,numberOfActiveRequestsByServer={},statistics.numberOfAttemptedRequests=0,statistics.numberOfActiveRequests=0,statistics.numberOfCancelledRequests=0,statistics.numberOfCancelledActiveRequests=0,statistics.numberOfFailedRequests=0,statistics.numberOfActiveRequestsEver=0,statistics.lastNumberOfActiveRequests=0},RequestScheduler.numberOfActiveRequestsByServer=function(e){return numberOfActiveRequestsByServer[e]},RequestScheduler.requestHeap=requestHeap;var TrustedServers={},_servers={};function getAuthority(e){var t=new URI(e);t.normalize();e=t.getAuthority();if(defined(e)){if(-1!==e.indexOf("@")&&(e=e.split("@")[1]),-1===e.indexOf(":")){t=t.getScheme();if(defined(t)||(t=(t=window.location.protocol).substring(0,t.length-1)),"http"===t)e+=":80";else{if("https"!==t)return;e+=":443"}}return e}}TrustedServers.add=function(e,t){t=e.toLowerCase()+":"+t;defined(_servers[t])||(_servers[t]=!0)},TrustedServers.remove=function(e,t){t=e.toLowerCase()+":"+t;defined(_servers[t])&&delete _servers[t]},TrustedServers.contains=function(e){e=getAuthority(e);return!(!defined(e)||!defined(_servers[e]))},TrustedServers.clear=function(){_servers={}};var xhrBlobSupported=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),(e.responseType="blob")===e.responseType}catch(e){return!1}}(),supportsImageBitmapOptionsPromise;function parseQuery(e,t,i,r){var n,a=e.query;if(!defined(a)||0===a.length)return 1;a=-1===a.indexOf("=")?((n={})[a]=void 0,n):queryToObject(a),t._queryParameters=i?combineQueryParameters(a,t._queryParameters,r):a,e.query=void 0}function stringifyQuery(e,t){var i=t._queryParameters,t=Object.keys(i);1!==t.length||defined(i[t[0]])?e.query=objectToQuery(i):e.query=t[0]}function defaultClone(e,t){return defined(e)?defined(e.clone)?e.clone():clone(e):t}function checkAndResetRequest(e){if(e.state===RequestState$1.ISSUED||e.state===RequestState$1.ACTIVE)throw new RuntimeError("The Resource is already being fetched.");e.state=RequestState$1.UNISSUED,e.deferred=void 0}function combineQueryParameters(e,t,i){if(!i)return combine(e,t);var r,n,a,o=clone(e,!0);for(r in t)t.hasOwnProperty(r)&&(n=o[r],a=t[r],defined(n)?(Array.isArray(n)||(n=o[r]=[n]),o[r]=n.concat(a)):o[r]=Array.isArray(a)?a.slice():a);return o}function Resource(e){"string"==typeof(e=defaultValue(e,defaultValue.EMPTY_OBJECT))&&(e={url:e}),this._url=void 0,this._templateValues=defaultClone(e.templateValues,{}),this._queryParameters=defaultClone(e.queryParameters,{}),this.headers=defaultClone(e.headers,{}),this.request=defaultValue(e.request,new Request),this.proxy=e.proxy,this.retryCallback=e.retryCallback,this.retryAttempts=defaultValue(e.retryAttempts,0),this._retryCount=0;e=new URI(e.url);parseQuery(e,this,!0,!0),e.fragment=void 0,this._url=e.toString()}function fetchImage(e){var i=e.resource,r=e.flipY,n=e.preferImageBitmap,a=i.request;a.url=i.url,a.requestFunction=function(){var e=!1;i.isDataUri||i.isBlobUri||(e=i.isCrossOriginUrl);var t=when.defer();return Resource._Implementations.createImage(a,e,t,r,n),t.promise};e=RequestScheduler.request(a);if(defined(e))return e.otherwise(function(t){return a.state!==RequestState$1.FAILED?when.reject(t):i.retryOnError(t).then(function(e){return e?(a.state=RequestState$1.UNISSUED,a.deferred=void 0,fetchImage({resource:i,flipY:r,preferImageBitmap:n})):when.reject(t)})})}function fetchJsonp(i,r,n){var e={};e[r]=n,i.setQueryParameters(e);var a=i.request;a.url=i.url,a.requestFunction=function(){var t=when.defer();return window[n]=function(e){t.resolve(e);try{delete window[n]}catch(e){window[n]=void 0}},Resource._Implementations.loadAndExecuteScript(i.url,n,t),t.promise};e=RequestScheduler.request(a);if(defined(e))return e.otherwise(function(t){return a.state!==RequestState$1.FAILED?when.reject(t):i.retryOnError(t).then(function(e){return e?(a.state=RequestState$1.UNISSUED,a.deferred=void 0,fetchJsonp(i,r,n)):when.reject(t)})})}Resource.createIfNeeded=function(e){return e instanceof Resource?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new Resource({url:e})},Resource.supportsImageBitmapOptions=function(){if(defined(supportsImageBitmapOptionsPromise))return supportsImageBitmapOptionsPromise;if("function"!=typeof createImageBitmap)return supportsImageBitmapOptionsPromise=when.resolve(!1);return supportsImageBitmapOptionsPromise=Resource.fetchBlob({url:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWP4////fwAJ+wP9CNHoHgAAAABJRU5ErkJggg=="}).then(function(e){return createImageBitmap(e,{imageOrientation:"flipY",premultiplyAlpha:"none"})}).then(function(e){return!0}).otherwise(function(){return!1})},Object.defineProperties(Resource,{isBlobSupported:{get:function(){return xhrBlobSupported}}}),Object.defineProperties(Resource.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(e){e=new URI(e);parseQuery(e,this,!1),e.fragment=void 0,this._url=e.toString()}},extension:{get:function(){return getExtensionFromUri(this._url)}},isDataUri:{get:function(){return isDataUri(this._url)}},isBlobUri:{get:function(){return isBlobUri(this._url)}},isCrossOriginUrl:{get:function(){return isCrossOriginUrl(this._url)}},hasHeaders:{get:function(){return 0<Object.keys(this.headers).length}}}),Resource.prototype.toString=function(){return this.getUrlComponent(!0,!0)},Resource.prototype.getUrlComponent=function(e,t){if(this.isDataUri)return this._url;var i=new URI(this._url);e&&stringifyQuery(i,this);var i=i.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),r=this._templateValues,i=i.replace(/{(.*?)}/g,function(e,t){t=r[t];return defined(t)?encodeURIComponent(t):e});return t&&defined(this.proxy)&&(i=this.proxy.getURL(i)),i},Resource.prototype.setQueryParameters=function(e,t){this._queryParameters=t?combineQueryParameters(this._queryParameters,e,!1):combineQueryParameters(e,this._queryParameters,!1)},Resource.prototype.appendQueryParameters=function(e){this._queryParameters=combineQueryParameters(e,this._queryParameters,!0)},Resource.prototype.setTemplateValues=function(e,t){this._templateValues=t?combine(this._templateValues,e):combine(e,this._templateValues)},Resource.prototype.getDerivedResource=function(e){var t,i=this.clone();return i._retryCount=0,defined(e.url)&&(parseQuery(t=new URI(e.url),i,!0,defaultValue(e.preserveQueryParameters,!1)),t.fragment=void 0,i._url=t.resolve(new URI(getAbsoluteUri(this._url))).toString()),defined(e.queryParameters)&&(i._queryParameters=combine(e.queryParameters,i._queryParameters)),defined(e.templateValues)&&(i._templateValues=combine(e.templateValues,i.templateValues)),defined(e.headers)&&(i.headers=combine(e.headers,i.headers)),defined(e.proxy)&&(i.proxy=e.proxy),defined(e.request)&&(i.request=e.request),defined(e.retryCallback)&&(i.retryCallback=e.retryCallback),defined(e.retryAttempts)&&(i.retryAttempts=e.retryAttempts),i},Resource.prototype.retryOnError=function(e){var t=this.retryCallback;if("function"!=typeof t||this._retryCount>=this.retryAttempts)return when(!1);var i=this;return when(t(this,e)).then(function(e){return++i._retryCount,e})},Resource.prototype.clone=function(e){return defined(e)||(e=new Resource({url:this._url})),e._url=this._url,e._queryParameters=clone(this._queryParameters),e._templateValues=clone(this._templateValues),e.headers=clone(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},Resource.prototype.getBaseUri=function(e){return getBaseUri(this.getUrlComponent(e),e)},Resource.prototype.appendForwardSlash=function(){this._url=appendForwardSlash(this._url)},Resource.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},Resource.fetchArrayBuffer=function(e){return new Resource(e).fetchArrayBuffer()},Resource.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},Resource.fetchBlob=function(e){return new Resource(e).fetchBlob()},Resource.prototype.fetchImage=function(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.preferImageBitmap,!1),i=defaultValue(e.preferBlob,!1),r=defaultValue(e.flipY,!1);if(checkAndResetRequest(this.request),!xhrBlobSupported||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!i)return fetchImage({resource:this,flipY:r,preferImageBitmap:t});var n,a,o,s=this.fetchBlob();return defined(s)?Resource.supportsImageBitmapOptions().then(function(e){return n=e&&t,s}).then(function(e){if(defined(e)){if(o=e,n)return Resource.createImageBitmapFromBlob(e,{flipY:r,premultiplyAlpha:!1});e=window.URL.createObjectURL(e);return fetchImage({resource:a=new Resource({url:e}),flipY:r,preferImageBitmap:!1})}}).then(function(e){if(defined(e))return e.blob=o,n||window.URL.revokeObjectURL(a.url),e}).otherwise(function(e){return defined(a)&&window.URL.revokeObjectURL(a.url),e.blob=o,when.reject(e)}):void 0},Resource.fetchImage=function(e){return new Resource(e).fetchImage({flipY:e.flipY,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})},Resource.prototype.fetchText=function(){return this.fetch({responseType:"text"})},Resource.fetchText=function(e){return new Resource(e).fetchText()},Resource.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(defined(e))return e.then(function(e){if(defined(e))return JSON.parse(e)})},Resource.fetchJson=function(e){return new Resource(e).fetchJson()},Resource.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},Resource.fetchXML=function(e){return new Resource(e).fetchXML()},Resource.prototype.fetchJsonp=function(e){var t;for(e=defaultValue(e,"callback"),checkAndResetRequest(this.request);t="loadJsonp"+Math.random().toString().substring(2,8),defined(window[t]););return fetchJsonp(this,e,t)},Resource.fetchJsonp=function(e){return new Resource(e).fetchJsonp(e.callbackParameterName)},Resource.prototype._makeRequest=function(s){var l=this;checkAndResetRequest(l.request);var c=l.request;c.url=l.url,c.requestFunction=function(){var e=s.responseType,t=combine(s.headers,l.headers),i=s.overrideMimeType,r=s.method,n=s.data,a=when.defer(),o=Resource._Implementations.loadWithXhr(l.url,e,r,n,t,a,i);return defined(o)&&defined(o.abort)&&(c.cancelFunction=function(){o.abort()}),a.promise};var e=RequestScheduler.request(c);if(defined(e))return e.then(function(e){return c.cancelFunction=void 0,e}).otherwise(function(t){return c.cancelFunction=void 0,c.state!==RequestState$1.FAILED?when.reject(t):l.retryOnError(t).then(function(e){return e?(c.state=RequestState$1.UNISSUED,c.deferred=void 0,l.fetch(s)):when.reject(t)})})};var dataUriRegex$1=/^data:(.*?)(;base64)?,(.*)$/;function decodeDataUriText(e,t){t=decodeURIComponent(t);return e?atob(t):t}function decodeDataUriArrayBuffer(e,t){for(var i=decodeDataUriText(e,t),t=new ArrayBuffer(i.length),r=new Uint8Array(t),n=0;n<i.length;n++)r[n]=i.charCodeAt(n);return t}function decodeDataUri(e,t){t=defaultValue(t,"");var i=e[1],r=!!e[2],n=e[3];switch(t){case"":case"text":return decodeDataUriText(r,n);case"arraybuffer":return decodeDataUriArrayBuffer(r,n);case"blob":var a=decodeDataUriArrayBuffer(r,n);return new Blob([a],{type:i});case"document":return(new DOMParser).parseFromString(decodeDataUriText(r,n),i);case"json":return JSON.parse(decodeDataUriText(r,n))}}function loadImageElement(e,t,i){var r=new Image;r.onload=function(){i.resolve(r)},r.onerror=function(e){i.reject(e)},t&&(TrustedServers.contains(e)?r.crossOrigin="use-credentials":r.crossOrigin=""),r.src=e}function decodeResponse(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}function loadWithHttpRequest(e,r,t,i,n,a,o){var s=require("url").parse(e),e="https:"===s.protocol?require("https"):require("http"),l=require("zlib"),n={protocol:s.protocol,hostname:s.hostname,port:s.port,path:s.path,query:s.query,method:t,headers:n};e.request(n).on("response",function(t){var i;t.statusCode<200||300<=t.statusCode?a.reject(new RequestErrorEvent(t.statusCode,t,t.headers)):(i=[],t.on("data",function(e){i.push(e)}),t.on("end",function(){var e=Buffer.concat(i);"gzip"===t.headers["content-encoding"]?l.gunzip(e,function(e,t){e?a.reject(new RuntimeError("Error decompressing response.")):a.resolve(decodeResponse(t,r))}):a.resolve(decodeResponse(e,r))}))}).on("error",function(e){a.reject(new RequestErrorEvent)}).end()}Resource.prototype.fetch=function(e){return(e=defaultClone(e,{})).method="GET",this._makeRequest(e)},Resource.fetch=function(e){return new Resource(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.delete=function(e){return(e=defaultClone(e,{})).method="DELETE",this._makeRequest(e)},Resource.delete=function(e){return new Resource(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},Resource.prototype.head=function(e){return(e=defaultClone(e,{})).method="HEAD",this._makeRequest(e)},Resource.head=function(e){return new Resource(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.options=function(e){return(e=defaultClone(e,{})).method="OPTIONS",this._makeRequest(e)},Resource.options=function(e){return new Resource(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.post=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="POST",t.data=e,this._makeRequest(t)},Resource.post=function(e){return new Resource(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.put=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="PUT",t.data=e,this._makeRequest(t)},Resource.put=function(e){return new Resource(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource.prototype.patch=function(e,t){return Check.defined("data",e),(t=defaultClone(t,{})).method="PATCH",t.data=e,this._makeRequest(t)},Resource.patch=function(e){return new Resource(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},Resource._Implementations={},Resource._Implementations.createImage=function(i,r,n,a,o){var s=i.url;Resource.supportsImageBitmapOptions().then(function(e){if(e&&o){var e=when.defer(),t=Resource._Implementations.loadWithXhr(s,"blob","GET",void 0,void 0,e,void 0,void 0,void 0);return defined(t)&&defined(t.abort)&&(i.cancelFunction=function(){t.abort()}),e.promise.then(function(e){return defined(e)?Resource.createImageBitmapFromBlob(e,{flipY:a,premultiplyAlpha:!1}):void n.reject(new RuntimeError("Successfully retrieved "+s+" but it contained no content."))}).then(n.resolve)}loadImageElement(s,r,n)}).otherwise(n.reject)},Resource.createImageBitmapFromBlob=function(e,t){return Check.defined("options",t),Check.typeOf.bool("options.flipY",t.flipY),Check.typeOf.bool("options.premultiplyAlpha",t.premultiplyAlpha),createImageBitmap(e,{imageOrientation:t.flipY?"flipY":"none",premultiplyAlpha:t.premultiplyAlpha?"premultiply":"none"})};var noXMLHttpRequest="undefined"==typeof XMLHttpRequest;Resource._Implementations.loadWithXhr=function(e,n,a,t,i,o,r){var s=dataUriRegex$1.exec(e);if(null===s){if(!noXMLHttpRequest){var l=new XMLHttpRequest;if(TrustedServers.contains(e)&&(l.withCredentials=!0),l.open(a,e,!0),defined(r)&&defined(l.overrideMimeType)&&l.overrideMimeType(r),defined(i))for(var c in i)i.hasOwnProperty(c)&&l.setRequestHeader(c,i[c]);defined(n)&&(l.responseType=n);var u=!1;return"string"==typeof e&&(u=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),l.onload=function(){if(!(l.status<200||300<=l.status)||u&&0===l.status){var e=l.response,t=l.responseType;if("HEAD"===a||"OPTIONS"===a){var i=l.getAllResponseHeaders().trim().split(/[\r\n]+/),r={};return i.forEach(function(e){var t=e.split(": "),e=t.shift();r[e]=t.join(": ")}),void o.resolve(r)}if(204===l.status)o.resolve();else if(!defined(e)||defined(n)&&t!==n)if("json"===n&&"string"==typeof e)try{o.resolve(JSON.parse(e))}catch(e){o.reject(e)}else(""===t||"document"===t)&&defined(l.responseXML)&&l.responseXML.hasChildNodes()?o.resolve(l.responseXML):""!==t&&"text"!==t||!defined(l.responseText)?o.reject(new RuntimeError("Invalid XMLHttpRequest response type.")):o.resolve(l.responseText);else o.resolve(e)}else o.reject(new RequestErrorEvent(l.status,l.response,l.getAllResponseHeaders()))},l.onerror=function(e){o.reject(new RequestErrorEvent)},l.send(t),l}loadWithHttpRequest(e,n,a,t,i,o)}else o.resolve(decodeDataUri(s,n))},Resource._Implementations.loadAndExecuteScript=function(e,t,i){return loadAndExecuteScript(e).otherwise(i.reject)},Resource._DefaultImplementations={},Resource._DefaultImplementations.createImage=Resource._Implementations.createImage,Resource._DefaultImplementations.loadWithXhr=Resource._Implementations.loadWithXhr,Resource._DefaultImplementations.loadAndExecuteScript=Resource._Implementations.loadAndExecuteScript,Resource.DEFAULT=Object.freeze(new Resource({url:"undefined"==typeof document?"":document.location.href.split("?")[0]}));var cesiumScriptRegex=/((?:.*\/)|^)Cesium\.js(?:\?|\#|$)/,a$1,baseResource,implementation;function getBaseUrlFromCesiumScript(){for(var e=document.getElementsByTagName("script"),t=0,i=e.length;t<i;++t){var r=e[t].getAttribute("src"),r=cesiumScriptRegex.exec(r);if(null!==r)return r[1]}}function tryMakeAbsolute(e){return"undefined"==typeof document?e:(defined(a$1)||(a$1=document.createElement("a")),a$1.href=e,a$1.href=a$1.href,a$1.href)}function getCesiumBaseUrl(){if(defined(baseResource))return baseResource;var e="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:"object"==typeof define&&defined(define.amd)&&!define.amd.toUrlUndefined&&defined(require.toUrl)?getAbsoluteUri("..",buildModuleUrl("Core/buildModuleUrl.js")):getBaseUrlFromCesiumScript();return(baseResource=new Resource({url:tryMakeAbsolute(e)})).appendForwardSlash(),baseResource}function buildModuleUrlFromRequireToUrl(e){return tryMakeAbsolute(require.toUrl("../"+e))}function buildModuleUrlFromBaseUrl(e){return getCesiumBaseUrl().getDerivedResource({url:e}).url}function buildModuleUrl(e){return defined(implementation)||(implementation="object"==typeof define&&defined(define.amd)&&!define.amd.toUrlUndefined&&defined(require.toUrl)?buildModuleUrlFromRequireToUrl:buildModuleUrlFromBaseUrl),implementation(e)}function Cartesian2(e,t){this.x=defaultValue(e,0),this.y=defaultValue(t,0)}buildModuleUrl._cesiumScriptRegex=cesiumScriptRegex,buildModuleUrl._buildModuleUrlFromBaseUrl=buildModuleUrlFromBaseUrl,buildModuleUrl._clearBaseResource=function(){baseResource=void 0},buildModuleUrl.setBaseUrl=function(e){baseResource=Resource.DEFAULT.getDerivedResource({url:e})},buildModuleUrl.getCesiumBaseUrl=getCesiumBaseUrl,Cartesian2.fromElements=function(e,t,i){return defined(i)?(i.x=e,i.y=t,i):new Cartesian2(e,t)},Cartesian2.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t):new Cartesian2(e.x,e.y)},Cartesian2.fromCartesian3=Cartesian2.clone,Cartesian2.fromCartesian4=Cartesian2.clone,Cartesian2.packedLength=2,Cartesian2.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i]=e.y,t},Cartesian2.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Cartesian2),i.x=e[t++],i.y=e[t],i},Cartesian2.packArray=function(e,t){var i=e.length,r=2*i;if(defined(t)){if(!Array.isArray(t)&&t.length!==r)throw new DeveloperError("If result is a typed array, it must have exactly array.length * 2 elements");t.length!==r&&(t.length=r)}else t=new Array(r);for(var n=0;n<i;++n)Cartesian2.pack(e[n],t,2*n);return t},Cartesian2.unpackArray=function(e,t){var i=e.length;defined(t)?t.length=i/2:t=new Array(i/2);for(var r=0;r<i;r+=2){var n=r/2;t[n]=Cartesian2.unpack(e,r,t[n])}return t},Cartesian2.fromArray=Cartesian2.unpack,Cartesian2.maximumComponent=function(e){return Math.max(e.x,e.y)},Cartesian2.minimumComponent=function(e){return Math.min(e.x,e.y)},Cartesian2.minimumByComponent=function(e,t,i){return i.x=Math.min(e.x,t.x),i.y=Math.min(e.y,t.y),i},Cartesian2.maximumByComponent=function(e,t,i){return i.x=Math.max(e.x,t.x),i.y=Math.max(e.y,t.y),i},Cartesian2.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},Cartesian2.magnitude=function(e){return Math.sqrt(Cartesian2.magnitudeSquared(e))};var distanceScratch$2=new Cartesian2;Cartesian2.distance=function(e,t){return Cartesian2.subtract(e,t,distanceScratch$2),Cartesian2.magnitude(distanceScratch$2)},Cartesian2.distanceSquared=function(e,t){return Cartesian2.subtract(e,t,distanceScratch$2),Cartesian2.magnitudeSquared(distanceScratch$2)},Cartesian2.normalize=function(e,t){var i=Cartesian2.magnitude(e);return t.x=e.x/i,t.y=e.y/i,t},Cartesian2.dot=function(e,t){return e.x*t.x+e.y*t.y},Cartesian2.multiplyComponents=function(e,t,i){return i.x=e.x*t.x,i.y=e.y*t.y,i},Cartesian2.divideComponents=function(e,t,i){return i.x=e.x/t.x,i.y=e.y/t.y,i},Cartesian2.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i},Cartesian2.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i},Cartesian2.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i},Cartesian2.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i},Cartesian2.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},Cartesian2.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var lerpScratch$2=new Cartesian2;Cartesian2.lerp=function(e,t,i,r){return Cartesian2.multiplyByScalar(t,i,lerpScratch$2),r=Cartesian2.multiplyByScalar(e,1-i,r),Cartesian2.add(lerpScratch$2,r,r)};var angleBetweenScratch$1=new Cartesian2,angleBetweenScratch2$1=new Cartesian2;Cartesian2.angleBetween=function(e,t){return Cartesian2.normalize(e,angleBetweenScratch$1),Cartesian2.normalize(t,angleBetweenScratch2$1),CesiumMath.acosClamped(Cartesian2.dot(angleBetweenScratch$1,angleBetweenScratch2$1))};var mostOrthogonalAxisScratch$2=new Cartesian2;function GeographicTilingScheme(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._rectangle=defaultValue(e.rectangle,Rectangle.MAX_VALUE),this._projection=new GeographicProjection(this._ellipsoid),this._numberOfLevelZeroTilesX=defaultValue(e.numberOfLevelZeroTilesX,2),this._numberOfLevelZeroTilesY=defaultValue(e.numberOfLevelZeroTilesY,1)}Cartesian2.mostOrthogonalAxis=function(e,t){e=Cartesian2.normalize(e,mostOrthogonalAxisScratch$2);return Cartesian2.abs(e,e),t=e.x<=e.y?Cartesian2.clone(Cartesian2.UNIT_X,t):Cartesian2.clone(Cartesian2.UNIT_Y,t)},Cartesian2.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y},Cartesian2.equalsArray=function(e,t,i){return e.x===t[i]&&e.y===t[i+1]},Cartesian2.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.x,t.x,i,r)&&CesiumMath.equalsEpsilon(e.y,t.y,i,r)},Cartesian2.ZERO=Object.freeze(new Cartesian2(0,0)),Cartesian2.UNIT_X=Object.freeze(new Cartesian2(1,0)),Cartesian2.UNIT_Y=Object.freeze(new Cartesian2(0,1)),Cartesian2.prototype.clone=function(e){return Cartesian2.clone(this,e)},Cartesian2.prototype.equals=function(e){return Cartesian2.equals(this,e)},Cartesian2.prototype.equalsEpsilon=function(e,t,i){return Cartesian2.equalsEpsilon(this,e,t,i)},Cartesian2.prototype.toString=function(){return"("+this.x+", "+this.y+")"},Object.defineProperties(GeographicTilingScheme.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),GeographicTilingScheme.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},GeographicTilingScheme.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},GeographicTilingScheme.prototype.rectangleToNativeRectangle=function(e,t){var i=CesiumMath.toDegrees(e.west),r=CesiumMath.toDegrees(e.south),n=CesiumMath.toDegrees(e.east),e=CesiumMath.toDegrees(e.north);return defined(t)?(t.west=i,t.south=r,t.east=n,t.north=e,t):new Rectangle(i,r,n,e)},GeographicTilingScheme.prototype.tileXYToNativeRectangle=function(e,t,i,r){r=this.tileXYToRectangle(e,t,i,r);return r.west=CesiumMath.toDegrees(r.west),r.south=CesiumMath.toDegrees(r.south),r.east=CesiumMath.toDegrees(r.east),r.north=CesiumMath.toDegrees(r.north),r},GeographicTilingScheme.prototype.tileXYToRectangle=function(e,t,i,r){var n=this._rectangle,a=this.getNumberOfXTilesAtLevel(i),o=this.getNumberOfYTilesAtLevel(i),i=n.width/a,a=e*i+n.west,e=(e+1)*i+n.west,i=n.height/o,o=n.north-t*i,i=n.north-(t+1)*i;return defined(r)||(r=new Rectangle(a,i,e,o)),r.west=a,r.south=i,r.east=e,r.north=o,r},GeographicTilingScheme.prototype.positionToTileXY=function(e,t,i){var r=this._rectangle;if(Rectangle.contains(r,e)){var n=this.getNumberOfXTilesAtLevel(t),a=this.getNumberOfYTilesAtLevel(t),o=r.width/n,s=r.height/a,t=e.longitude;r.east<r.west&&(t+=CesiumMath.TWO_PI);o=(t-r.west)/o|0;n<=o&&(o=n-1);s=(r.north-e.latitude)/s|0;return(a<=s&&(s=a-1),defined(i))?(i.x=o,i.y=s,i):new Cartesian2(o,s)}};var scratchDiagonalCartesianNE=new Cartesian3,scratchDiagonalCartesianSW=new Cartesian3,scratchDiagonalCartographic=new Cartographic,scratchCenterCartesian=new Cartesian3,scratchSurfaceCartesian=new Cartesian3,scratchBoundingSphere=new BoundingSphere,tilingScheme=new GeographicTilingScheme,scratchCorners=[new Cartographic,new Cartographic,new Cartographic,new Cartographic],scratchTileXY=new Cartesian2,ApproximateTerrainHeights={};function getTileXYLevel(e){Cartographic.fromRadians(e.east,e.north,0,scratchCorners[0]),Cartographic.fromRadians(e.west,e.north,0,scratchCorners[1]),Cartographic.fromRadians(e.east,e.south,0,scratchCorners[2]),Cartographic.fromRadians(e.west,e.south,0,scratchCorners[3]);for(var t=0,i=0,r=0,n=0,a=ApproximateTerrainHeights._terrainHeightsMaxLevel,o=0;o<=a;++o){for(var s=!1,l=0;l<4;++l){var c=scratchCorners[l];if(tilingScheme.positionToTileXY(c,o,scratchTileXY),0===l)r=scratchTileXY.x,n=scratchTileXY.y;else if(r!==scratchTileXY.x||n!==scratchTileXY.y){s=!0;break}}if(s)break;t=r,i=n}if(0!==o)return{x:t,y:i,level:a<o?a:o-1}}function _toConsumableArray(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}return Array.from(e)}ApproximateTerrainHeights.initialize=function(){var e=ApproximateTerrainHeights._initPromise;return defined(e)?e:(e=Resource.fetchJson(buildModuleUrl("Assets/approximateTerrainHeights.json")).then(function(e){ApproximateTerrainHeights._terrainHeights=e}),ApproximateTerrainHeights._initPromise=e)},ApproximateTerrainHeights.getMinimumMaximumHeights=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);var i=getTileXYLevel(e),r=ApproximateTerrainHeights._defaultMinTerrainHeight,n=ApproximateTerrainHeights._defaultMaxTerrainHeight;return defined(i)&&(i=i.level+"-"+i.x+"-"+i.y,defined(i=ApproximateTerrainHeights._terrainHeights[i])&&(r=i[0],n=i[1]),t.cartographicToCartesian(Rectangle.northeast(e,scratchDiagonalCartographic),scratchDiagonalCartesianNE),t.cartographicToCartesian(Rectangle.southwest(e,scratchDiagonalCartographic),scratchDiagonalCartesianSW),Cartesian3.midpoint(scratchDiagonalCartesianSW,scratchDiagonalCartesianNE,scratchCenterCartesian),r=defined(t=t.scaleToGeodeticSurface(scratchCenterCartesian,scratchSurfaceCartesian))?(t=Cartesian3.distance(scratchCenterCartesian,t),Math.min(r,-t)):ApproximateTerrainHeights._defaultMinTerrainHeight),{minimumTerrainHeight:r=Math.max(ApproximateTerrainHeights._defaultMinTerrainHeight,r),maximumTerrainHeight:n}},ApproximateTerrainHeights.getBoundingSphere=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);var i=getTileXYLevel(e),r=ApproximateTerrainHeights._defaultMaxTerrainHeight;defined(i)&&(n=i.level+"-"+i.x+"-"+i.y,defined(n=ApproximateTerrainHeights._terrainHeights[n])&&(r=n[1]));var n=BoundingSphere.fromRectangle3D(e,t,0);return BoundingSphere.fromRectangle3D(e,t,r,scratchBoundingSphere),BoundingSphere.union(n,scratchBoundingSphere,n)},ApproximateTerrainHeights._terrainHeightsMaxLevel=6,ApproximateTerrainHeights._defaultMaxTerrainHeight=9e3,ApproximateTerrainHeights._defaultMinTerrainHeight=-1e5,ApproximateTerrainHeights._terrainHeights=void 0,ApproximateTerrainHeights._initPromise=void 0,Object.defineProperties(ApproximateTerrainHeights,{initialized:{get:function(){return defined(ApproximateTerrainHeights._terrainHeights)}}});var hasOwnProperty=Object.hasOwnProperty,setPrototypeOf=Object.setPrototypeOf,isFrozen=Object.isFrozen,freeze=Object.freeze,seal=Object.seal,create=Object.create,_ref="undefined"!=typeof Reflect&&Reflect,apply=_ref.apply,construct=_ref.construct,apply=apply||function(e,t,i){return e.apply(t,i)},freeze=freeze||function(e){return e},seal=seal||function(e){return e},construct=construct||function(e,t){return new(Function.prototype.bind.apply(e,[null].concat(_toConsumableArray(t))))},arrayForEach=unapply(Array.prototype.forEach),arrayPop=unapply(Array.prototype.pop),arrayPush=unapply(Array.prototype.push),stringToLowerCase=unapply(String.prototype.toLowerCase),stringMatch=unapply(String.prototype.match),stringReplace=unapply(String.prototype.replace),stringIndexOf=unapply(String.prototype.indexOf),stringTrim=unapply(String.prototype.trim),regExpTest=unapply(RegExp.prototype.test),typeErrorCreate=unconstruct(TypeError);function unapply(n){return function(e){for(var t=arguments.length,i=Array(1<t?t-1:0),r=1;r<t;r++)i[r-1]=arguments[r];return apply(n,e,i)}}function unconstruct(r){return function(){for(var e=arguments.length,t=Array(e),i=0;i<e;i++)t[i]=arguments[i];return construct(r,t)}}function addToSet(e,t){setPrototypeOf&&setPrototypeOf(e,null);for(var i=t.length;i--;){var r,n=t[i];"string"!=typeof n||(r=stringToLowerCase(n))!==n&&(isFrozen(t)||(t[i]=r),n=r),e[n]=!0}return e}function clone$1(e){var t=create(null),i=void 0;for(i in e)apply(hasOwnProperty,e,[i])&&(t[i]=e[i]);return t}var html=freeze(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),svg=freeze(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","audio","canvas","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","video","view","vkern"]),svgFilters=freeze(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),mathMl=freeze(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover"]),text=freeze(["#text"]),html$1=freeze(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","face","for","headers","height","hidden","high","href","hreflang","id","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","playsinline","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","xmlns"]),svg$1=freeze(["accent-height","accumulate","additive","alignment-baseline","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","targetx","targety","transform","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),mathMl$1=freeze(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),xml=freeze(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),MUSTACHE_EXPR=seal(/\{\{[\s\S]*|[\s\S]*\}\}/gm),ERB_EXPR=seal(/<%[\s\S]*|[\s\S]*%>/gm),DATA_ATTR=seal(/^data-[\-\w.\u00B7-\uFFFF]/),ARIA_ATTR=seal(/^aria-[\-\w]+$/),IS_ALLOWED_URI=seal(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),IS_SCRIPT_OR_DATA=seal(/^(?:\w+script|data):/i),ATTR_WHITESPACE=seal(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};function _toConsumableArray$1(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}return Array.from(e)}var getGlobal=function(){return"undefined"==typeof window?null:window},_createTrustedTypesPolicy=function(e,t){if("object"!==(void 0===e?"undefined":_typeof(e))||"function"!=typeof e.createPolicy)return null;var i=null,r="data-tt-policy-suffix";t.currentScript&&t.currentScript.hasAttribute(r)&&(i=t.currentScript.getAttribute(r));var n="dompurify"+(i?"#"+i:"");try{return e.createPolicy(n,{createHTML:function(e){return e}})}catch(e){return console.warn("TrustedTypes policy "+n+" could not be created."),null}};function createDOMPurify(){function c(e){return createDOMPurify(e)}var l=0<arguments.length&&void 0!==arguments[0]?arguments[0]:getGlobal();if(c.version="2.2.2",c.removed=[],!l||!l.document||9!==l.document.nodeType)return c.isSupported=!1,c;var u=l.document,a=l.document,d=l.DocumentFragment,e=l.HTMLTemplateElement,h=l.Node,t=l.NodeFilter,i=l.NamedNodeMap,n=void 0===i?l.NamedNodeMap||l.MozNamedAttrMap:i,o=l.Text,s=l.Comment,p=l.DOMParser,i=l.trustedTypes;"function"!=typeof e||(e=a.createElement("template")).content&&e.content.ownerDocument&&(a=e.content.ownerDocument);var m=_createTrustedTypesPolicy(i,u),f=m&&re?m.createHTML(""):"",g=a.implementation,r=a.createNodeIterator,_=a.getElementsByTagName,y=a.createDocumentFragment,C=u.importNode,v={};try{v=clone$1(a).documentMode?a.documentMode:{}}catch(e){}var S={};c.isSupported=g&&void 0!==g.createHTMLDocument&&9!==v;function T(e){he&&he===e||(e&&"object"===(void 0===e?"undefined":_typeof(e))||(e={}),e=clone$1(e),U="ALLOWED_TAGS"in e?addToSet({},e.ALLOWED_TAGS):$,G="ALLOWED_ATTR"in e?addToSet({},e.ALLOWED_ATTR):H,ue="ADD_URI_SAFE_ATTR"in e?addToSet(clone$1(de),e.ADD_URI_SAFE_ATTR):de,le="ADD_DATA_URI_TAGS"in e?addToSet(clone$1(ce),e.ADD_DATA_URI_TAGS):ce,W="FORBID_TAGS"in e?addToSet({},e.FORBID_TAGS):{},q="FORBID_ATTR"in e?addToSet({},e.FORBID_ATTR):{},O="USE_PROFILES"in e&&e.USE_PROFILES,j=!1!==e.ALLOW_ARIA_ATTR,Y=!1!==e.ALLOW_DATA_ATTR,X=e.ALLOW_UNKNOWN_PROTOCOLS||!1,Q=e.SAFE_FOR_TEMPLATES||!1,J=e.WHOLE_DOCUMENT||!1,ee=e.RETURN_DOM||!1,te=e.RETURN_DOM_FRAGMENT||!1,ie=!1!==e.RETURN_DOM_IMPORT,re=e.RETURN_TRUSTED_TYPE||!1,K=e.FORCE_BODY||!1,ne=!1!==e.SANITIZE_DOM,ae=!1!==e.KEEP_CONTENT,oe=e.IN_PLACE||!1,z=e.ALLOWED_URI_REGEXP||z,Q&&(Y=!1),te&&(ee=!0),O&&(U=addToSet({},[].concat(_toConsumableArray$1(text))),G=[],!0===O.html&&(addToSet(U,html),addToSet(G,html$1)),!0===O.svg&&(addToSet(U,svg),addToSet(G,svg$1),addToSet(G,xml)),!0===O.svgFilters&&(addToSet(U,svgFilters),addToSet(G,svg$1),addToSet(G,xml)),!0===O.mathMl&&(addToSet(U,mathMl),addToSet(G,mathMl$1),addToSet(G,xml))),e.ADD_TAGS&&(U===$&&(U=clone$1(U)),addToSet(U,e.ADD_TAGS)),e.ADD_ATTR&&(G===H&&(G=clone$1(G)),addToSet(G,e.ADD_ATTR)),e.ADD_URI_SAFE_ATTR&&addToSet(ue,e.ADD_URI_SAFE_ATTR),ae&&(U["#text"]=!0),J&&addToSet(U,["html","head","body"]),U.table&&(addToSet(U,["tbody"]),delete W.tbody),freeze&&freeze(e),he=e)}function x(t){arrayPush(c.removed,{element:t});try{t.parentNode.removeChild(t)}catch(e){t.outerHTML=f}}function b(e,t){try{arrayPush(c.removed,{attribute:t.getAttributeNode(e),from:t})}catch(e){arrayPush(c.removed,{attribute:null,from:t})}t.removeAttribute(e)}function E(e){var t=void 0,i=void 0;K?e="<remove></remove>"+e:i=(r=stringMatch(e,/^[\r\n\t ]+/))&&r[0];var r,n=m?m.createHTML(e):e;try{t=(new p).parseFromString(n,"text/html")}catch(e){}return t&&t.documentElement||((r=(t=g.createHTMLDocument("")).body).parentNode.removeChild(r.parentNode.firstElementChild),r.outerHTML=n),e&&i&&t.body.insertBefore(a.createTextNode(i),t.body.childNodes[0]||null),_.call(t,J?"html":"body")[0]}function P(e){return r.call(e.ownerDocument||e,e,t.SHOW_ELEMENT|t.SHOW_COMMENT|t.SHOW_TEXT,function(){return t.FILTER_ACCEPT},!1)}function A(e){return"object"===(void 0===h?"undefined":_typeof(h))?e instanceof h:e&&"object"===(void 0===e?"undefined":_typeof(e))&&"number"==typeof e.nodeType&&"string"==typeof e.nodeName}function w(e,t,i){S[e]&&arrayForEach(S[e],function(e){e.call(c,t,i,he)})}function D(e){var t;if(w("beforeSanitizeElements",e,null),!((i=e)instanceof o||i instanceof s)&&!("string"==typeof i.nodeName&&"string"==typeof i.textContent&&"function"==typeof i.removeChild&&i.attributes instanceof n&&"function"==typeof i.removeAttribute&&"function"==typeof i.setAttribute&&"string"==typeof i.namespaceURI))return x(e),1;if(stringMatch(e.nodeName,/[\u0080-\uFFFF]/))return x(e),1;var i=stringToLowerCase(e.nodeName);if(w("uponSanitizeElement",e,{tagName:i,allowedTags:U}),("svg"===i||"math"===i)&&0!==e.querySelectorAll("p, br, form, table").length)return x(e),1;if(!A(e.firstElementChild)&&(!A(e.content)||!A(e.content.firstElementChild))&&regExpTest(/<[!/\w]/g,e.innerHTML)&&regExpTest(/<[!/\w]/g,e.textContent))return x(e),1;if(U[i]&&!W[i])return"noscript"!==i&&"noembed"!==i||!regExpTest(/<\/no(script|embed)/i,e.innerHTML)?(Q&&3===e.nodeType&&(t=e.textContent,t=stringReplace(t,L," "),t=stringReplace(t,F," "),e.textContent!==t&&(arrayPush(c.removed,{element:e.cloneNode()}),e.textContent=t)),w("afterSanitizeElements",e,null),!1):(x(e),!0);if(ae&&!se[i]&&"function"==typeof e.insertAdjacentHTML)try{var r=e.innerHTML;e.insertAdjacentHTML("AfterEnd",m?m.createHTML(r):r)}catch(e){}return x(e),1}function M(e,t,i){if(ne&&("id"===t||"name"===t)&&(i in a||i in pe))return!1;if(!(Y&&regExpTest(N,t)||j&&regExpTest(B,t))){if(!G[t]||q[t])return!1;if(!ue[t]&&!regExpTest(z,stringReplace(i,k,"")))if("src"!==t&&"xlink:href"!==t&&"href"!==t||"script"===e||0!==stringIndexOf(i,"data:")||!le[e]){if((!X||regExpTest(V,stringReplace(i,k,"")))&&i)return!1}else;}return!0}function I(e){var t=void 0,i=void 0;w("beforeSanitizeAttributes",e,null);var r=e.attributes;if(r){for(var n={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:G},i=r.length;i--;){var a=(l=r[i]).name,o=l.namespaceURI,t=stringTrim(l.value),s=stringToLowerCase(a);if(n.attrName=s,n.attrValue=t,n.keepAttr=!0,n.forceKeepAttr=void 0,w("uponSanitizeAttribute",e,n),t=n.attrValue,!n.forceKeepAttr&&(b(a,e),n.keepAttr))if(regExpTest(/\/>/i,t))b(a,e);else{Q&&(t=stringReplace(t,L," "),t=stringReplace(t,F," "));var l=e.nodeName.toLowerCase();if(M(l,s,t))try{o?e.setAttributeNS(o,a,t):e.setAttribute(a,t),arrayPop(c.removed)}catch(e){}}}w("afterSanitizeAttributes",e,null)}}function R(e){var t,i=P(e);for(w("beforeSanitizeShadowDOM",e,null);t=i.nextNode();)w("uponSanitizeShadowNode",t,null),D(t)||(t.content instanceof d&&R(t.content),I(t));w("afterSanitizeShadowDOM",e,null)}var O,L=MUSTACHE_EXPR,F=ERB_EXPR,N=DATA_ATTR,B=ARIA_ATTR,V=IS_SCRIPT_OR_DATA,k=ATTR_WHITESPACE,z=IS_ALLOWED_URI,U=null,$=addToSet({},[].concat(_toConsumableArray$1(html),_toConsumableArray$1(svg),_toConsumableArray$1(svgFilters),_toConsumableArray$1(mathMl),_toConsumableArray$1(text))),G=null,H=addToSet({},[].concat(_toConsumableArray$1(html$1),_toConsumableArray$1(svg$1),_toConsumableArray$1(mathMl$1),_toConsumableArray$1(xml))),W=null,q=null,j=!0,Y=!0,X=!1,Q=!1,J=!1,Z=!1,K=!1,ee=!1,te=!1,ie=!0,re=!1,ne=!0,ae=!0,oe=!1,se=addToSet({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","plaintext","script","style","svg","template","thead","title","video","xmp"]),le=null,ce=addToSet({},["audio","video","img","source","image","track"]),ue=null,de=addToSet({},["alt","class","for","id","label","name","pattern","placeholder","summary","title","value","style","xmlns"]),he=null,pe=a.createElement("form");return c.sanitize=function(e,t){var i,r,n=void 0,a=void 0,o=void 0;if("string"!=typeof(e=e||"\x3c!--\x3e")&&!A(e)){if("function"!=typeof e.toString)throw typeErrorCreate("toString is not a function");if("string"!=typeof(e=e.toString()))throw typeErrorCreate("dirty is not a string, aborting")}if(!c.isSupported){if("object"===_typeof(l.toStaticHTML)||"function"==typeof l.toStaticHTML){if("string"==typeof e)return l.toStaticHTML(e);if(A(e))return l.toStaticHTML(e.outerHTML)}return e}if(Z||T(t),c.removed=[],"string"==typeof e&&(oe=!1),!oe)if(e instanceof h)1===(i=(n=E("\x3c!----\x3e")).ownerDocument.importNode(e,!0)).nodeType&&"BODY"===i.nodeName||"HTML"===i.nodeName?n=i:n.appendChild(i);else{if(!ee&&!Q&&!J&&-1===e.indexOf("<"))return m&&re?m.createHTML(e):e;if(!(n=E(e)))return ee?null:f}n&&K&&x(n.firstChild);for(var s=P(oe?e:n);r=s.nextNode();)3===r.nodeType&&r===a||D(r)||(r.content instanceof d&&R(r.content),I(r),a=r);if(a=null,oe)return e;if(ee){if(te)for(o=y.call(n.ownerDocument);n.firstChild;)o.appendChild(n.firstChild);else o=n;return ie&&(o=C.call(u,o,!0)),o}e=J?n.outerHTML:n.innerHTML;return Q&&(e=stringReplace(e,L," "),e=stringReplace(e,F," ")),m&&re?m.createHTML(e):e},c.setConfig=function(e){T(e),Z=!0},c.clearConfig=function(){he=null,Z=!1},c.isValidAttribute=function(e,t,i){he||T({});e=stringToLowerCase(e),t=stringToLowerCase(t);return M(e,t,i)},c.addHook=function(e,t){"function"==typeof t&&(S[e]=S[e]||[],arrayPush(S[e],t))},c.removeHook=function(e){S[e]&&arrayPop(S[e])},c.removeHooks=function(e){S[e]&&(S[e]=[])},c.removeAllHooks=function(){S={}},c}var purify=createDOMPurify(),nextCreditId=0,creditToId={};function Credit(e,t){var i,r=e;defined(creditToId[r])?i=creditToId[r]:(i=nextCreditId++,creditToId[r]=i),t=defaultValue(t,!1),this._id=i,this._html=e,this._showOnScreen=t,this._element=void 0}Object.defineProperties(Credit.prototype,{html:{get:function(){return this._html}},id:{get:function(){return this._id}},showOnScreen:{get:function(){return this._showOnScreen}},element:{get:function(){if(!defined(this._element)){var e=purify.sanitize(this._html),t=document.createElement("div");t._creditId=this._id,t.style.display="inline",t.innerHTML=e;for(var i=t.querySelectorAll("a"),r=0;r<i.length;r++)i[r].setAttribute("target","_blank");this._element=t}return this._element}}}),Credit.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e._id===t._id},Credit.prototype.equals=function(e){return Credit.equals(this,e)},Credit.getIonCredit=function(e){var t=defined(e.collapsible)&&!e.collapsible,t=new Credit(e.html,t);return t._isIon=-1!==t.html.indexOf("ion-credit.png"),t},Credit.clone=function(e){if(defined(e))return new Credit(e.html,e.showOnScreen)};var HeightmapEncoding={NONE:0,LERC:1},HeightmapEncoding$1=Object.freeze(HeightmapEncoding);function AxisAlignedBoundingBox(e,t,i){this.minimum=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.maximum=Cartesian3.clone(defaultValue(t,Cartesian3.ZERO)),i=defined(i)?Cartesian3.clone(i):Cartesian3.midpoint(this.minimum,this.maximum,new Cartesian3),this.center=i}AxisAlignedBoundingBox.fromPoints=function(e,t){if(defined(t)||(t=new AxisAlignedBoundingBox),!defined(e)||0===e.length)return t.minimum=Cartesian3.clone(Cartesian3.ZERO,t.minimum),t.maximum=Cartesian3.clone(Cartesian3.ZERO,t.maximum),t.center=Cartesian3.clone(Cartesian3.ZERO,t.center),t;for(var i=e[0].x,r=e[0].y,n=e[0].z,a=e[0].x,o=e[0].y,s=e[0].z,l=e.length,c=1;c<l;c++)var u=e[c],d=u.x,h=u.y,u=u.z,i=Math.min(d,i),a=Math.max(d,a),r=Math.min(h,r),o=Math.max(h,o),n=Math.min(u,n),s=Math.max(u,s);var p=t.minimum;p.x=i,p.y=r,p.z=n;var m=t.maximum;return m.x=a,m.y=o,m.z=s,t.center=Cartesian3.midpoint(p,m,t.center),t},AxisAlignedBoundingBox.clone=function(e,t){if(defined(e))return defined(t)?(t.minimum=Cartesian3.clone(e.minimum,t.minimum),t.maximum=Cartesian3.clone(e.maximum,t.maximum),t.center=Cartesian3.clone(e.center,t.center),t):new AxisAlignedBoundingBox(e.minimum,e.maximum,e.center)},AxisAlignedBoundingBox.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&Cartesian3.equals(e.minimum,t.minimum)&&Cartesian3.equals(e.maximum,t.maximum)};var intersectScratch=new Cartesian3;function EllipsoidalOccluder(e,t){this._ellipsoid=e,this._cameraPosition=new Cartesian3,this._cameraPositionInScaledSpace=new Cartesian3,this._distanceToLimbInScaledSpaceSquared=0,defined(t)&&(this.cameraPosition=t)}AxisAlignedBoundingBox.intersectPlane=function(e,t){intersectScratch=Cartesian3.subtract(e.maximum,e.minimum,intersectScratch);var i=Cartesian3.multiplyByScalar(intersectScratch,.5,intersectScratch),r=t.normal,i=i.x*Math.abs(r.x)+i.y*Math.abs(r.y)+i.z*Math.abs(r.z),t=Cartesian3.dot(e.center,r)+t.distance;return 0<t-i?Intersect$1.INSIDE:t+i<0?Intersect$1.OUTSIDE:Intersect$1.INTERSECTING},AxisAlignedBoundingBox.prototype.clone=function(e){return AxisAlignedBoundingBox.clone(this,e)},AxisAlignedBoundingBox.prototype.intersectPlane=function(e){return AxisAlignedBoundingBox.intersectPlane(this,e)},AxisAlignedBoundingBox.prototype.equals=function(e){return AxisAlignedBoundingBox.equals(this,e)},Object.defineProperties(EllipsoidalOccluder.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var t=this._ellipsoid.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),i=Cartesian3.magnitudeSquared(t)-1;Cartesian3.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=t,this._distanceToLimbInScaledSpaceSquared=i}}});var scratchCartesian=new Cartesian3;EllipsoidalOccluder.prototype.isPointVisible=function(e){return isScaledSpacePointVisible(this._ellipsoid.transformPositionToScaledSpace(e,scratchCartesian),this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)},EllipsoidalOccluder.prototype.isScaledSpacePointVisible=function(e){return isScaledSpacePointVisible(e,this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)};var scratchCameraPositionInScaledSpaceShrunk=new Cartesian3;EllipsoidalOccluder.prototype.isScaledSpacePointVisiblePossiblyUnderEllipsoid=function(e,t){var i,r=this._ellipsoid,t=defined(t)&&t<0&&r.minimumRadius>-t?((i=scratchCameraPositionInScaledSpaceShrunk).x=this._cameraPosition.x/(r.radii.x+t),i.y=this._cameraPosition.y/(r.radii.y+t),i.z=this._cameraPosition.z/(r.radii.z+t),i.x*i.x+i.y*i.y+i.z*i.z-1):(i=this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared);return isScaledSpacePointVisible(e,i,t)},EllipsoidalOccluder.prototype.computeHorizonCullingPoint=function(e,t,i){return computeHorizonCullingPointFromPositions(this._ellipsoid,e,t,i)};var scratchEllipsoidShrunk=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE);EllipsoidalOccluder.prototype.computeHorizonCullingPointPossiblyUnderEllipsoid=function(e,t,i,r){return computeHorizonCullingPointFromPositions(getPossiblyShrunkEllipsoid(this._ellipsoid,i,scratchEllipsoidShrunk),e,t,r)},EllipsoidalOccluder.prototype.computeHorizonCullingPointFromVertices=function(e,t,i,r,n){return computeHorizonCullingPointFromVertices(this._ellipsoid,e,t,i,r,n)},EllipsoidalOccluder.prototype.computeHorizonCullingPointFromVerticesPossiblyUnderEllipsoid=function(e,t,i,r,n,a){return computeHorizonCullingPointFromVertices(getPossiblyShrunkEllipsoid(this._ellipsoid,n,scratchEllipsoidShrunk),e,t,i,r,a)};var subsampleScratch=[];EllipsoidalOccluder.prototype.computeHorizonCullingPointFromRectangle=function(e,t,i){var r=Rectangle.subsample(e,t,0,subsampleScratch),e=BoundingSphere.fromPoints(r);if(!(Cartesian3.magnitude(e.center)<.1*t.minimumRadius))return this.computeHorizonCullingPoint(e.center,r,i)};var scratchEllipsoidShrunkRadii=new Cartesian3;function getPossiblyShrunkEllipsoid(e,t,i){return defined(t)&&t<0&&e.minimumRadius>-t&&(t=Cartesian3.fromElements(e.radii.x+t,e.radii.y+t,e.radii.z+t,scratchEllipsoidShrunkRadii),e=Ellipsoid.fromCartesian3(t,i)),e}function computeHorizonCullingPointFromPositions(e,t,i,r){defined(r)||(r=new Cartesian3);for(var n=computeScaledSpaceDirectionToPoint(e,t),a=0,o=0,s=i.length;o<s;++o){var l=computeMagnitude(e,i[o],n);if(l<0)return;a=Math.max(a,l)}return magnitudeToPoint(n,a,r)}var positionScratch=new Cartesian3;function computeHorizonCullingPointFromVertices(e,t,i,r,n,a){defined(a)||(a=new Cartesian3),r=defaultValue(r,3),n=defaultValue(n,Cartesian3.ZERO);for(var o=computeScaledSpaceDirectionToPoint(e,t),s=0,l=0,c=i.length;l<c;l+=r){positionScratch.x=i[l]+n.x,positionScratch.y=i[l+1]+n.y,positionScratch.z=i[l+2]+n.z;var u=computeMagnitude(e,positionScratch,o);if(u<0)return;s=Math.max(s,u)}return magnitudeToPoint(o,s,a)}function isScaledSpacePointVisible(e,t,i){e=Cartesian3.subtract(e,t,scratchCartesian),t=-Cartesian3.dot(e,t);return!(i<0?0<t:i<t&&t*t/Cartesian3.magnitudeSquared(e)>i)}var scaledSpaceScratch=new Cartesian3,directionScratch=new Cartesian3;function computeMagnitude(e,t,i){var r=e.transformPositionToScaledSpace(t,scaledSpaceScratch),e=Cartesian3.magnitudeSquared(r),t=Math.sqrt(e),r=Cartesian3.divideByScalar(r,t,directionScratch),e=Math.max(1,e),t=1/(t=Math.max(1,t));return 1/(Cartesian3.dot(r,i)*t-Cartesian3.magnitude(Cartesian3.cross(r,i,r))*(Math.sqrt(e-1)*t))}function magnitudeToPoint(e,t,i){if(!(t<=0||t===1/0||t!=t))return Cartesian3.multiplyByScalar(e,t,i)}var directionToPointScratch=new Cartesian3;function computeScaledSpaceDirectionToPoint(e,t){return Cartesian3.equals(t,Cartesian3.ZERO)?t:(e.transformPositionToScaledSpace(t,directionToPointScratch),Cartesian3.normalize(directionToPointScratch,directionToPointScratch))}var QuadraticRealPolynomial={};function addWithCancellationCheck(e,t,i){var r=e+t;return CesiumMath.sign(e)!==CesiumMath.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<i?0:r}QuadraticRealPolynomial.computeDiscriminant=function(e,t,i){return t*t-4*e*i},QuadraticRealPolynomial.computeRealRoots=function(e,t,i){if(0===e)return 0===t?[]:[-i/t];if(0===t){if(0===i)return[0,0];var r=Math.abs(i),n=Math.abs(e);if(r<n&&r/n<CesiumMath.EPSILON14)return[0,0];if(n<r&&n/r<CesiumMath.EPSILON14)return[];if((n=-i/e)<0)return[];r=Math.sqrt(n);return[-r,r]}if(0===i)return(n=-t/e)<0?[n,0]:[0,n];n=addWithCancellationCheck(t*t,-(4*e*i),CesiumMath.EPSILON14);if(n<0)return[];n=-.5*addWithCancellationCheck(t,CesiumMath.sign(t)*Math.sqrt(n),CesiumMath.EPSILON14);return 0<t?[n/e,i/n]:[i/n,n/e]};var CubicRealPolynomial={};function computeRealRoots(e,t,i,r){var n=e,a=t/3,o=i/3,s=r,l=n*o,c=a*s,u=a*a,d=o*o,h=n*o-u,e=n*s-a*o,t=a*s-d,i=4*h*t-e*e;if(i<0){var r=l*d<=u*c?-2*a*(f=h)+(m=n)*e:-(m=s)*e+2*o*(f=t),p=-(r<0?-1:1)*Math.abs(m)*Math.sqrt(-i),m=(g=p-r)/2,m=m<0?-Math.pow(-m,1/3):Math.pow(m,1/3),p=g===p?-m:-f/m,p=f<=0?m+p:-r/(m*m+p*p+f);return l*d<=u*c?[(p-a)/n]:[-s/(p+o)]}var f=h,l=-2*a*h+n*e,d=t,u=-s*e+2*o*t,c=Math.sqrt(i),h=Math.sqrt(3)/2,e=Math.abs(Math.atan2(n*c,-l)/3);p=2*Math.sqrt(-f);t=Math.cos(e);g=p*t;var i=p*(-t/2-h*Math.sin(e)),l=2*a<g+i?g-a:i-a,f=n,n=l/f,e=Math.abs(Math.atan2(s*c,-u)/3),s=-s,e=(g=(p=2*Math.sqrt(-d))*(t=Math.cos(e)))+(i=p*(-t/2-h*Math.sin(e)))<2*o?g+o:i+o,g=s/e,i=-l*e-f*s,e=(o*i-a*(l*s))/(-a*i+o*(f*e));return n<=e?n<=g?e<=g?[n,e,g]:[n,g,e]:[g,n,e]:n<=g?[e,n,g]:e<=g?[e,g,n]:[g,e,n]}CubicRealPolynomial.computeDiscriminant=function(e,t,i,r){var n=t*t,a=i*i;return 18*e*t*i*r+n*a-27*(e*e)*(r*r)-4*(e*a*i+n*t*r)},CubicRealPolynomial.computeRealRoots=function(e,t,i,r){var n;if(0===e)return QuadraticRealPolynomial.computeRealRoots(t,i,r);if(0!==t)return 0===i?0===r?(a=-t/e)<0?[a,0,0]:[0,0,a]:computeRealRoots(e,t,0,r):0===r?0===(n=QuadraticRealPolynomial.computeRealRoots(e,t,i)).length?[0]:n[1]<=0?[n[0],n[1],0]:0<=n[0]?[0,n[0],n[1]]:[n[0],0,n[1]]:computeRealRoots(e,t,i,r);if(0!==i)return 0===r?0===(n=QuadraticRealPolynomial.computeRealRoots(e,0,i)).Length?[0]:[n[0],0,n[1]]:computeRealRoots(e,0,i,r);if(0===r)return[0,0,0];var a=(a=-r/e)<0?-Math.pow(-a,1/3):Math.pow(a,1/3);return[a,a,a]};var QuarticRealPolynomial={};function original(e,t,i,r){var n=e*e,a=t-3*n/8,o=i-t*e/2+n*e/8,r=r-i*e/4+t*n/16-3*n*n/256,i=CubicRealPolynomial.computeRealRoots(1,2*a,a*a-4*r,-o*o);if(0<i.length){t=-e/4,n=i[i.length-1];if(Math.abs(n)<CesiumMath.EPSILON14){e=QuadraticRealPolynomial.computeRealRoots(1,a,r);if(2===e.length){var i=e[0],s=e[1];if(0<=i&&0<=s){r=Math.sqrt(i),e=Math.sqrt(s);return[t-e,t-r,t+r,t+e]}if(0<=i&&s<0)return[t-(l=Math.sqrt(i)),t+l];if(i<0&&0<=s)return[t-(l=Math.sqrt(s)),t+l]}return[]}if(0<n){var s=Math.sqrt(n),l=(a+n-o/s)/2,o=(a+n+o/s)/2,l=QuadraticRealPolynomial.computeRealRoots(1,s,l),o=QuadraticRealPolynomial.computeRealRoots(1,-s,o);return 0!==l.length?(l[0]+=t,l[1]+=t,0!==o.length?(o[0]+=t,o[1]+=t,l[1]<=o[0]?[l[0],l[1],o[0],o[1]]:o[1]<=l[0]?[o[0],o[1],l[0],l[1]]:l[0]>=o[0]&&l[1]<=o[1]?[o[0],l[0],l[1],o[1]]:o[0]>=l[0]&&o[1]<=l[1]?[l[0],o[0],o[1],l[1]]:l[0]>o[0]&&l[0]<o[1]?[o[0],l[0],o[1],l[1]]:[l[0],o[0],l[1],o[1]]):l):0!==o.length?(o[0]+=t,o[1]+=t,o):[]}}return[]}function neumark(e,t,i,r){var n=e*e,a=-2*t,o=i*e+t*t-4*r,s=n*r-i*t*e+i*i,l=CubicRealPolynomial.computeRealRoots(1,a,o,s);if(0<l.length){var c,u,d,h,p=l[0],a=t-p,o=a*a,s=e/2,l=a/2,t=o-4*r,a=o+4*Math.abs(r),o=n-4*p,n=n+4*Math.abs(p);u=p<0||t*n<o*a?(c=(o=Math.sqrt(o))/2,0===o?0:(e*l-i)/o):(c=0===(u=Math.sqrt(t))?0:(e*l-i)/u,u/2),0==s&&0===c?h=d=0:CesiumMath.sign(s)===CesiumMath.sign(c)?h=p/(d=s+c):d=p/(h=s-c),0==l&&0===u?f=m=0:CesiumMath.sign(l)===CesiumMath.sign(u)?f=r/(m=l+u):m=r/(f=l-u);var m=QuadraticRealPolynomial.computeRealRoots(1,d,m),f=QuadraticRealPolynomial.computeRealRoots(1,h,f);if(0!==m.length)return 0!==f.length?m[1]<=f[0]?[m[0],m[1],f[0],f[1]]:f[1]<=m[0]?[f[0],f[1],m[0],m[1]]:m[0]>=f[0]&&m[1]<=f[1]?[f[0],m[0],m[1],f[1]]:f[0]>=m[0]&&f[1]<=m[1]?[m[0],f[0],f[1],m[1]]:m[0]>f[0]&&m[0]<f[1]?[f[0],m[0],f[1],m[1]]:[m[0],f[0],m[1],f[1]]:m;if(0!==f.length)return f}return[]}function Ray(e,t){t=Cartesian3.clone(defaultValue(t,Cartesian3.ZERO)),Cartesian3.equals(t,Cartesian3.ZERO)||Cartesian3.normalize(t,t),this.origin=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.direction=t}QuarticRealPolynomial.computeDiscriminant=function(e,t,i,r,n){var a=e*e,o=t*t,s=o*t,l=i*i,c=l*i,u=r*r,d=u*r,h=n*n;return o*l*u-4*s*d-4*e*c*u+18*e*t*i*d-27*a*u*u+256*(a*e)*(h*n)+n*(18*s*i*r-4*o*c+16*e*l*l-80*e*t*l*r-6*e*o*u+144*a*i*u)+h*(144*e*o*i-27*o*o-128*a*l-192*a*t*r)},QuarticRealPolynomial.computeRealRoots=function(e,t,i,r,n){if(Math.abs(e)<CesiumMath.EPSILON15)return CubicRealPolynomial.computeRealRoots(t,i,r,n);var a=t/e,o=i/e,s=r/e,l=n/e,e=a<0?1:0;switch(e+=o<0?e+1:e,e+=s<0?e+1:e,e+=l<0?e+1:e){case 0:return original(a,o,s,l);case 1:case 2:return neumark(a,o,s,l);case 3:case 4:return original(a,o,s,l);case 5:return neumark(a,o,s,l);case 6:case 7:return original(a,o,s,l);case 8:return neumark(a,o,s,l);case 9:case 10:return original(a,o,s,l);case 11:return neumark(a,o,s,l);case 12:case 13:case 14:case 15:return original(a,o,s,l);default:return}},Ray.clone=function(e,t){if(defined(e))return defined(t)?(t.origin=Cartesian3.clone(e.origin),t.direction=Cartesian3.clone(e.direction),t):new Ray(e.origin,e.direction)},Ray.getPoint=function(e,t,i){return defined(i)||(i=new Cartesian3),i=Cartesian3.multiplyByScalar(e.direction,t,i),Cartesian3.add(e.origin,i,i)};var IntersectionTests={rayPlane:function(e,t,i){defined(i)||(i=new Cartesian3);var r=e.origin,n=e.direction,a=t.normal,e=Cartesian3.dot(a,n);if(!(Math.abs(e)<CesiumMath.EPSILON15)){e=(-t.distance-Cartesian3.dot(a,r))/e;if(!(e<0))return i=Cartesian3.multiplyByScalar(n,e,i),Cartesian3.add(r,i,i)}}},scratchEdge0=new Cartesian3,scratchEdge1=new Cartesian3,scratchPVec=new Cartesian3,scratchTVec=new Cartesian3,scratchQVec=new Cartesian3;IntersectionTests.rayTriangleParametric=function(e,t,i,r,n){n=defaultValue(n,!1);var a,o,s,l=e.origin,c=e.direction,u=Cartesian3.subtract(i,t,scratchEdge0),e=Cartesian3.subtract(r,t,scratchEdge1),i=Cartesian3.cross(c,e,scratchPVec),r=Cartesian3.dot(u,i);if(n){if(r<CesiumMath.EPSILON6)return;if(h=Cartesian3.subtract(l,t,scratchTVec),(d=Cartesian3.dot(h,i))<0||r<d)return;if(a=Cartesian3.cross(h,u,scratchQVec),(o=Cartesian3.dot(c,a))<0||r<d+o)return;s=Cartesian3.dot(e,a)/r}else{if(Math.abs(r)<CesiumMath.EPSILON6)return;var d,r=1/r,h=Cartesian3.subtract(l,t,scratchTVec);if((d=Cartesian3.dot(h,i)*r)<0||1<d)return;if(a=Cartesian3.cross(h,u,scratchQVec),(o=Cartesian3.dot(c,a)*r)<0||1<d+o)return;s=Cartesian3.dot(e,a)*r}return s},IntersectionTests.rayTriangle=function(e,t,i,r,n,a){n=IntersectionTests.rayTriangleParametric(e,t,i,r,n);if(defined(n)&&!(n<0))return defined(a)||(a=new Cartesian3),Cartesian3.multiplyByScalar(e.direction,n,a),Cartesian3.add(e.origin,a,a)};var scratchLineSegmentTriangleRay=new Ray;function solveQuadratic(e,t,i,r){var n=t*t-4*e*i;if(!(n<0)){if(0<n){var a=1/(2*e),i=Math.sqrt(n),n=(-t+i)*a,a=(-t-i)*a;return n<a?(r.root0=n,r.root1=a):(r.root0=a,r.root1=n),r}e=-t/(2*e);if(0!=e)return r.root0=r.root1=e,r}}IntersectionTests.lineSegmentTriangle=function(e,t,i,r,n,a,o){var s=scratchLineSegmentTriangleRay;Cartesian3.clone(e,s.origin),Cartesian3.subtract(t,e,s.direction),Cartesian3.normalize(s.direction,s.direction);a=IntersectionTests.rayTriangleParametric(s,i,r,n,a);if(!(!defined(a)||a<0||a>Cartesian3.distance(e,t)))return defined(o)||(o=new Cartesian3),Cartesian3.multiplyByScalar(s.direction,a,o),Cartesian3.add(s.origin,o,o)};var raySphereRoots={root0:0,root1:0};function raySphere(e,t,i){defined(i)||(i=new Interval);var r=e.origin,n=e.direction,e=t.center,t=t.radius*t.radius,e=Cartesian3.subtract(r,e,scratchPVec),t=solveQuadratic(Cartesian3.dot(n,n),2*Cartesian3.dot(n,e),Cartesian3.magnitudeSquared(e)-t,raySphereRoots);if(defined(t))return i.start=t.root0,i.stop=t.root1,i}IntersectionTests.raySphere=function(e,t,i){if(defined(i=raySphere(e,t,i))&&!(i.stop<0))return i.start=Math.max(i.start,0),i};var scratchLineSegmentRay=new Ray;IntersectionTests.lineSegmentSphere=function(e,t,i,r){var n=scratchLineSegmentRay;Cartesian3.clone(e,n.origin);t=Cartesian3.subtract(t,e,n.direction),e=Cartesian3.magnitude(t);if(Cartesian3.normalize(t,t),!(!defined(r=raySphere(n,i,r))||r.stop<0||r.start>e))return r.start=Math.max(r.start,0),r.stop=Math.min(r.stop,e),r};var scratchQ=new Cartesian3,scratchW=new Cartesian3;function addWithCancellationCheck$1(e,t,i){var r=e+t;return CesiumMath.sign(e)!==CesiumMath.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<i?0:r}function quadraticVectorExpression(e,t,i,r,n){var a,o=r*r,s=n*n,l=(e[Matrix3.COLUMN1ROW1]-e[Matrix3.COLUMN2ROW2])*s,c=n*(r*addWithCancellationCheck$1(e[Matrix3.COLUMN1ROW0],e[Matrix3.COLUMN0ROW1],CesiumMath.EPSILON15)+t.y),u=e[Matrix3.COLUMN0ROW0]*o+e[Matrix3.COLUMN2ROW2]*s+r*t.x+i,d=s*addWithCancellationCheck$1(e[Matrix3.COLUMN2ROW1],e[Matrix3.COLUMN1ROW2],CesiumMath.EPSILON15),h=n*(r*addWithCancellationCheck$1(e[Matrix3.COLUMN2ROW0],e[Matrix3.COLUMN0ROW2])+t.z),p=[];if(0==h&&0==d){if(0===(a=QuadraticRealPolynomial.computeRealRoots(l,c,u)).length)return p;var m=a[0],f=Math.sqrt(Math.max(1-m*m,0));return p.push(new Cartesian3(r,n*m,n*-f)),p.push(new Cartesian3(r,n*m,n*f)),2===a.length&&(g=a[1],_=Math.sqrt(Math.max(1-g*g,0)),p.push(new Cartesian3(r,n*g,n*-_)),p.push(new Cartesian3(r,n*g,n*_))),p}var t=h*h,m=d*d,f=h*d,g=l*l+m,_=2*(c*l+f),m=2*u*l+c*c-m+t,f=2*(u*c-f),t=u*u-t;if(0==g&&0==_&&0==m&&0==f)return p;var y=(a=QuarticRealPolynomial.computeRealRoots(g,_,m,f,t)).length;if(0===y)return p;for(var C=0;C<y;++C){var v=a[C],S=v*v,T=Math.max(1-S,0),T=Math.sqrt(T),S=CesiumMath.sign(l)===CesiumMath.sign(u)?addWithCancellationCheck$1(l*S+u,c*v,CesiumMath.EPSILON12):CesiumMath.sign(u)===CesiumMath.sign(c*v)?addWithCancellationCheck$1(l*S,c*v+u,CesiumMath.EPSILON12):addWithCancellationCheck$1(l*S+c*v,u,CesiumMath.EPSILON12),S=S*addWithCancellationCheck$1(d*v,h,CesiumMath.EPSILON15);S<0?p.push(new Cartesian3(r,n*v,n*T)):0<S?p.push(new Cartesian3(r,n*v,n*-T)):0!==T?(p.push(new Cartesian3(r,n*v,n*-T)),p.push(new Cartesian3(r,n*v,n*T)),++C):p.push(new Cartesian3(r,n*v,n*T))}return p}IntersectionTests.rayEllipsoid=function(e,t){var i,r,n=t.oneOverRadii,a=Cartesian3.multiplyComponents(n,e.origin,scratchQ),t=Cartesian3.multiplyComponents(n,e.direction,scratchW),n=Cartesian3.magnitudeSquared(a),e=Cartesian3.dot(a,t);if(1<n){if(0<=e)return;var o,s,a=e*e,l=n-1;if(a<(s=(o=Cartesian3.magnitudeSquared(t))*l))return;if(s<a){i=e*e-s;var c=(r=-e+Math.sqrt(i))/o,a=l/r;return c<a?new Interval(c,a):{start:a,stop:c}}c=Math.sqrt(l/o);return new Interval(c,c)}return n<1?(l=n-1,i=e*e-(s=(o=Cartesian3.magnitudeSquared(t))*l),new Interval(0,(r=-e+Math.sqrt(i))/o)):e<0?new Interval(0,-e/(o=Cartesian3.magnitudeSquared(t))):void 0};var firstAxisScratch=new Cartesian3,secondAxisScratch=new Cartesian3,thirdAxisScratch=new Cartesian3,referenceScratch=new Cartesian3,bCart=new Cartesian3,bScratch=new Matrix3,btScratch=new Matrix3,diScratch=new Matrix3,dScratch=new Matrix3,cScratch=new Matrix3,tempMatrix=new Matrix3,aScratch=new Matrix3,sScratch=new Cartesian3,closestScratch=new Cartesian3,surfPointScratch=new Cartographic;IntersectionTests.grazingAltitudeLocation=function(e,t){var i=e.origin,r=e.direction;if(!Cartesian3.equals(i,Cartesian3.ZERO)){var n=t.geodeticSurfaceNormal(i,firstAxisScratch);if(0<=Cartesian3.dot(r,n))return i}var a=defined(this.rayEllipsoid(e,t)),o=t.transformPositionToScaledSpace(r,firstAxisScratch),n=Cartesian3.normalize(o,o),e=Cartesian3.mostOrthogonalAxis(o,referenceScratch),o=Cartesian3.normalize(Cartesian3.cross(e,n,secondAxisScratch),secondAxisScratch),e=Cartesian3.normalize(Cartesian3.cross(n,o,thirdAxisScratch),thirdAxisScratch),s=bScratch;s[0]=n.x,s[1]=n.y,s[2]=n.z,s[3]=o.x,s[4]=o.y,s[5]=o.z,s[6]=e.x,s[7]=e.y,s[8]=e.z;var n=Matrix3.transpose(s,btScratch),l=Matrix3.fromScale(t.radii,diScratch),o=Matrix3.fromScale(t.oneOverRadii,dScratch),e=cScratch;e[0]=0,e[1]=-r.z,e[2]=r.y,e[3]=r.z,e[4]=0,e[5]=-r.x,e[6]=-r.y,e[7]=r.x,e[8]=0;var c,o=Matrix3.multiply(Matrix3.multiply(n,o,tempMatrix),e,tempMatrix),e=Matrix3.multiply(Matrix3.multiply(o,l,aScratch),s,aScratch),o=Matrix3.multiplyByVector(o,i,bCart),u=quadraticVectorExpression(e,Cartesian3.negate(o,firstAxisScratch),0,0,1),d=u.length;if(0<d){for(var h=Cartesian3.clone(Cartesian3.ZERO,closestScratch),p=Number.NEGATIVE_INFINITY,m=0;m<d;++m){c=Matrix3.multiplyByVector(l,Matrix3.multiplyByVector(s,u[m],sScratch),sScratch);var f=Cartesian3.normalize(Cartesian3.subtract(c,i,referenceScratch),referenceScratch),f=Cartesian3.dot(f,r);p<f&&(p=f,h=Cartesian3.clone(c,h))}e=t.cartesianToCartographic(h,surfPointScratch),p=CesiumMath.clamp(p,0,1),o=Cartesian3.magnitude(Cartesian3.subtract(h,i,referenceScratch))*Math.sqrt(1-p*p);return o=a?-o:o,e.height=o,t.cartographicToCartesian(e,new Cartesian3)}};var lineSegmentPlaneDifference=new Cartesian3;function Plane(e,t){this.normal=Cartesian3.clone(e),this.distance=t}IntersectionTests.lineSegmentPlane=function(e,t,i,r){defined(r)||(r=new Cartesian3);var n=Cartesian3.subtract(t,e,lineSegmentPlaneDifference),a=i.normal,t=Cartesian3.dot(a,n);if(!(Math.abs(t)<CesiumMath.EPSILON6)){a=Cartesian3.dot(a,e),t=-(i.distance+a)/t;if(!(t<0||1<t))return Cartesian3.multiplyByScalar(n,t,r),Cartesian3.add(e,r,r),r}},IntersectionTests.trianglePlaneIntersection=function(e,t,i,r){var n,a,o=r.normal,s=r.distance,l=Cartesian3.dot(o,e)+s<0,c=Cartesian3.dot(o,t)+s<0,o=Cartesian3.dot(o,i)+s<0,s=0;if(s+=l?1:0,s+=c?1:0,1!=(s+=o?1:0)&&2!=s||(n=new Cartesian3,a=new Cartesian3),1==s){if(l)return IntersectionTests.lineSegmentPlane(e,t,r,n),IntersectionTests.lineSegmentPlane(e,i,r,a),{positions:[e,t,i,n,a],indices:[0,3,4,1,2,4,1,4,3]};if(c)return IntersectionTests.lineSegmentPlane(t,i,r,n),IntersectionTests.lineSegmentPlane(t,e,r,a),{positions:[e,t,i,n,a],indices:[1,3,4,2,0,4,2,4,3]};if(o)return IntersectionTests.lineSegmentPlane(i,e,r,n),IntersectionTests.lineSegmentPlane(i,t,r,a),{positions:[e,t,i,n,a],indices:[2,3,4,0,1,4,0,4,3]}}else if(2==s){if(!l)return IntersectionTests.lineSegmentPlane(t,e,r,n),IntersectionTests.lineSegmentPlane(i,e,r,a),{positions:[e,t,i,n,a],indices:[1,2,4,1,4,3,0,3,4]};if(!c)return IntersectionTests.lineSegmentPlane(i,t,r,n),IntersectionTests.lineSegmentPlane(e,t,r,a),{positions:[e,t,i,n,a],indices:[2,0,4,2,4,3,1,3,4]};if(!o)return IntersectionTests.lineSegmentPlane(e,i,r,n),IntersectionTests.lineSegmentPlane(t,i,r,a),{positions:[e,t,i,n,a],indices:[0,1,4,0,4,3,2,3,4]}}},Plane.fromPointNormal=function(e,t,i){e=-Cartesian3.dot(t,e);return defined(i)?(Cartesian3.clone(t,i.normal),i.distance=e,i):new Plane(t,e)};var scratchNormal=new Cartesian3;Plane.fromCartesian4=function(e,t){var i=Cartesian3.fromCartesian4(e,scratchNormal),e=e.w;return defined(t)?(Cartesian3.clone(i,t.normal),t.distance=e,t):new Plane(i,e)},Plane.getPointDistance=function(e,t){return Cartesian3.dot(e.normal,t)+e.distance};var scratchCartesian$1=new Cartesian3;Plane.projectPointOntoPlane=function(e,t,i){defined(i)||(i=new Cartesian3);var r=Plane.getPointDistance(e,t),r=Cartesian3.multiplyByScalar(e.normal,r,scratchCartesian$1);return Cartesian3.subtract(t,r,i)};var scratchInverseTranspose=new Matrix4,scratchPlaneCartesian4=new Cartesian4,scratchTransformNormal=new Cartesian3;function binarySearch(e,t,i){for(var r,n,a=0,o=e.length-1;a<=o;)if((n=i(e[r=~~((a+o)/2)],t))<0)a=1+r;else{if(!(0<n))return r;o=r-1}return~(o+1)}function EarthOrientationParametersSample(e,t,i,r,n){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=i,this.yPoleOffset=r,this.ut1MinusUtc=n}function sprintf(){function C(e,t,i,r){return i=i||" ",i=e.length>=t?"":Array(1+t-e.length>>>0).join(i),r?e+i:i+e}function v(e,t,i,r,n,a){var o=r-e.length;return 0<o&&(e=i||!n?C(e,r,a,i):e.slice(0,t.length)+C("",o,"0",!0)+e.slice(t.length)),e}function S(e,t,i,r,n,a,o){var s=e>>>0;return e=(i=i&&s&&{2:"0b",8:"0",16:"0x"}[t]||"")+C(s.toString(t),a||0,"0",!1),v(e,i,r,n,o)}function T(e,t,i,r,n,a){return null!=r&&(e=e.slice(0,r)),v(e,"",t,i,n,a)}var x=arguments,b=0,e=x[b++];return e.replace(/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,function(e,t,i,r,n,a,o){var s,l,c,u,d;if("%%"==e)return"%";for(var h=!1,p="",m=!1,f=!1,g=" ",_=i.length,y=0;i&&y<_;y++)switch(i.charAt(y)){case" ":p=" ";break;case"+":p="+";break;case"-":h=!0;break;case"'":g=i.charAt(y+1);break;case"0":m=!0;break;case"#":f=!0}if((r=r?"*"==r?+x[b++]:"*"==r.charAt(0)?+x[r.slice(1,-1)]:+r:0)<0&&(r=-r,h=!0),!isFinite(r))throw new Error("sprintf: (minimum-)width must be finite");switch(a=a?"*"==a?+x[b++]:"*"==a.charAt(0)?+x[a.slice(1,-1)]:+a:-1<"fFeE".indexOf(o)?6:"d"==o?0:void 0,d=t?x[t.slice(0,-1)]:x[b++],o){case"s":return T(String(d),h,r,a,m,g);case"c":return T(String.fromCharCode(+d),h,r,a,m);case"b":return S(d,2,f,h,r,a,m);case"o":return S(d,8,f,h,r,a,m);case"x":return S(d,16,f,h,r,a,m);case"X":return S(d,16,f,h,r,a,m).toUpperCase();case"u":return S(d,10,f,h,r,a,m);case"i":case"d":return s=+d||0,d=(l=(s=Math.round(s-s%1))<0?"-":p)+C(String(Math.abs(s)),a,"0",!1),v(d,l,h,r,m);case"e":case"E":case"f":case"F":case"g":case"G":return l=(s=+d)<0?"-":p,c=["toExponential","toFixed","toPrecision"]["efg".indexOf(o.toLowerCase())],u=["toString","toUpperCase"]["eEfFgG".indexOf(o)%2],d=l+Math.abs(s)[c](a),v(d,l,h,r,m)[u]();default:return e}})}function GregorianDate(e,t,i,r,n,a,o,s){this.year=e,this.month=t,this.day=i,this.hour=r,this.minute=n,this.second=a,this.millisecond=o,this.isLeapSecond=s}function isLeapYear(e){return e%4==0&&e%100!=0||e%400==0}function LeapSecond(e,t){this.julianDate=e,this.offset=t}Plane.transform=function(e,t,i){var r=e.normal,e=e.distance,t=Matrix4.inverseTranspose(t,scratchInverseTranspose),e=Cartesian4.fromElements(r.x,r.y,r.z,e,scratchPlaneCartesian4),e=Matrix4.multiplyByVector(t,e,e),t=Cartesian3.fromCartesian4(e,scratchTransformNormal);return e=Cartesian4.divideByScalar(e,Cartesian3.magnitude(t),e),Plane.fromCartesian4(e,i)},Plane.clone=function(e,t){return defined(t)?(Cartesian3.clone(e.normal,t.normal),t.distance=e.distance,t):new Plane(e.normal,e.distance)},Plane.equals=function(e,t){return e.distance===t.distance&&Cartesian3.equals(e.normal,t.normal)},Plane.ORIGIN_XY_PLANE=Object.freeze(new Plane(Cartesian3.UNIT_Z,0)),Plane.ORIGIN_YZ_PLANE=Object.freeze(new Plane(Cartesian3.UNIT_X,0)),Plane.ORIGIN_ZX_PLANE=Object.freeze(new Plane(Cartesian3.UNIT_Y,0));var TimeConstants={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5},TimeConstants$1=Object.freeze(TimeConstants),TimeStandard={UTC:0,TAI:1},TimeStandard$1=Object.freeze(TimeStandard),gregorianDateScratch=new GregorianDate,daysInMonth=[31,28,31,30,31,30,31,31,30,31,30,31],daysInLeapFeburary=29;function compareLeapSecondDates(e,t){return JulianDate.compare(e.julianDate,t.julianDate)}var binarySearchScratchLeapSecond=new LeapSecond;function convertUtcToTai(e){binarySearchScratchLeapSecond.julianDate=e;var t=JulianDate.leapSeconds,i=binarySearch(t,binarySearchScratchLeapSecond,compareLeapSecondDates);i<0&&(i=~i),i>=t.length&&(i=t.length-1);var r=t[i].offset;0<i&&r<JulianDate.secondsDifference(t[i].julianDate,e)&&(r=t[--i].offset),JulianDate.addSeconds(e,r,e)}function convertTaiToUtc(e,t){binarySearchScratchLeapSecond.julianDate=e;var i=JulianDate.leapSeconds,r=binarySearch(i,binarySearchScratchLeapSecond,compareLeapSecondDates);if(r<0&&(r=~r),0===r)return JulianDate.addSeconds(e,-i[0].offset,t);if(r>=i.length)return JulianDate.addSeconds(e,-i[r-1].offset,t);var n=JulianDate.secondsDifference(i[r].julianDate,e);return 0===n?JulianDate.addSeconds(e,-i[r].offset,t):n<=1?void 0:JulianDate.addSeconds(e,-i[--r].offset,t)}function setComponents(e,t,i){var r=t/TimeConstants$1.SECONDS_PER_DAY|0;return e+=r,(t-=TimeConstants$1.SECONDS_PER_DAY*r)<0&&(e--,t+=TimeConstants$1.SECONDS_PER_DAY),i.dayNumber=e,i.secondsOfDay=t,i}function computeJulianDateComponents(e,t,i,r,n,a,o){var s=(t-14)/12|0,e=e+4800+s,i=(1461*e/4|0)+(367*(t-2-12*s)/12|0)-(3*((e+100)/100|0)/4|0)+i-32075;(r-=12)<0&&(r+=24);o=a+(r*TimeConstants$1.SECONDS_PER_HOUR+n*TimeConstants$1.SECONDS_PER_MINUTE+o*TimeConstants$1.SECONDS_PER_MILLISECOND);return 43200<=o&&--i,[i,o]}var matchCalendarYear=/^(\d{4})$/,matchCalendarMonth=/^(\d{4})-(\d{2})$/,matchOrdinalDate=/^(\d{4})-?(\d{3})$/,matchWeekDate=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,matchCalendarDate=/^(\d{4})-?(\d{2})-?(\d{2})$/,utcOffset=/([Z+\-])?(\d{2})?:?(\d{2})?$/,matchHours=/^(\d{2})(\.\d+)?/.source+utcOffset.source,matchHoursMinutes=/^(\d{2}):?(\d{2})(\.\d+)?/.source+utcOffset.source,matchHoursMinutesSeconds=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+utcOffset.source;function JulianDate(e,t,i){this.dayNumber=void 0,this.secondsOfDay=void 0,e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,TimeStandard$1.UTC);var r=0|e;setComponents(r,t+=(e-r)*TimeConstants$1.SECONDS_PER_DAY,this),i===TimeStandard$1.UTC&&convertUtcToTai(this)}JulianDate.fromGregorianDate=function(e,t){e=computeJulianDateComponents(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return defined(t)?(setComponents(e[0],e[1],t),convertUtcToTai(t),t):new JulianDate(e[0],e[1],TimeStandard$1.UTC)},JulianDate.fromDate=function(e,t){e=computeJulianDateComponents(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return defined(t)?(setComponents(e[0],e[1],t),convertUtcToTai(t),t):new JulianDate(e[0],e[1],TimeStandard$1.UTC)},JulianDate.fromIso8601=function(e,t){var i,r,n,a,o,s=(e=e.replace(",",".")).split("T"),l=1,c=1,u=0,d=0,h=0,p=0,m=s[0],e=s[1];if(null!==(s=m.match(matchCalendarDate))?(i=+s[1],l=+s[2],c=+s[3]):null!==(s=m.match(matchCalendarMonth))?(i=+s[1],l=+s[2]):null!==(s=m.match(matchCalendarYear))?i=+s[1]:(null!==(s=m.match(matchOrdinalDate))?(i=+s[1],a=+s[2],n=isLeapYear(i)):null!==(s=m.match(matchWeekDate))&&(i=+s[1],a=7*+s[2]+(+s[3]||0)-new Date(Date.UTC(i,0,4)).getUTCDay()-3),(r=new Date(Date.UTC(i,0,1))).setUTCDate(a),l=r.getUTCMonth()+1,c=r.getUTCDate()),n=isLeapYear(i),defined(e)){null!==(s=e.match(matchHoursMinutesSeconds))?(u=+s[1],d=+s[2],h=+s[3],p=1e3*+(s[4]||0),o=5):null!==(s=e.match(matchHoursMinutes))?(u=+s[1],d=+s[2],h=60*+(s[3]||0),o=4):null!==(s=e.match(matchHours))&&(u=+s[1],d=60*+(s[2]||0),o=3);var f=s[o],g=+s[o+1],_=+(s[o+2]||0);switch(f){case"+":u-=g,d-=_;break;case"-":u+=g,d+=_;break;case"Z":break;default:d+=new Date(Date.UTC(i,l-1,c,u,d)).getTimezoneOffset()}}f=60===h;for(f&&h--;60<=d;)d-=60,u++;for(;24<=u;)u-=24,c++;for(r=n&&2===l?daysInLeapFeburary:daysInMonth[l-1];r<c;)c-=r,12<++l&&(l-=12,i++),r=n&&2===l?daysInLeapFeburary:daysInMonth[l-1];for(;d<0;)d+=60,u--;for(;u<0;)u+=24,c--;for(;c<1;)--l<1&&(l+=12,i--),c+=r=n&&2===l?daysInLeapFeburary:daysInMonth[l-1];p=computeJulianDateComponents(i,l,c,u,d,h,p);return defined(t)?(setComponents(p[0],p[1],t),convertUtcToTai(t)):t=new JulianDate(p[0],p[1],TimeStandard$1.UTC),f&&JulianDate.addSeconds(t,1,t),t},JulianDate.now=function(e){return JulianDate.fromDate(new Date,e)};var toGregorianDateScratch=new JulianDate(0,0,TimeStandard$1.TAI);function EarthOrientationParameters(e){var t,i;e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=defaultValue(e.addNewLeapSeconds,!0),defined(e.data)?onDataReady(this,e.data):defined(e.url)?(t=Resource.createIfNeeded(e.url),(i=this)._downloadPromise=t.fetchJson().then(function(e){onDataReady(i,e)}).otherwise(function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})):onDataReady(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function compareLeapSecondDates$1(e,t){return JulianDate.compare(e.julianDate,t)}function onDataReady(e,t){if(defined(t.columnNames))if(defined(t.samples)){var i=t.columnNames.indexOf("modifiedJulianDateUtc"),r=t.columnNames.indexOf("xPoleWanderRadians"),n=t.columnNames.indexOf("yPoleWanderRadians"),a=t.columnNames.indexOf("ut1MinusUtcSeconds"),o=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),s=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),l=t.columnNames.indexOf("taiMinusUtcSeconds");if(i<0||r<0||n<0||a<0||o<0||s<0||l<0)e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";else{var c,u=e._samples=t.samples,d=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=r,e._yPoleWanderRadiansColumn=n,e._ut1MinusUtcSecondsColumn=a,e._xCelestialPoleOffsetRadiansColumn=o,e._yCelestialPoleOffsetRadiansColumn=s,e._taiMinusUtcSecondsColumn=l,e._columnCount=t.columnNames.length,e._lastIndex=void 0;for(var h=e._addNewLeapSeconds,p=0,m=u.length;p<m;p+=e._columnCount){var f,g=u[p+i],_=u[p+l],y=new JulianDate(g+TimeConstants$1.MODIFIED_JULIAN_DATE_DIFFERENCE,_,TimeStandard$1.TAI);d.push(y),h&&(_===c||!defined(c)||(g=binarySearch(f=JulianDate.leapSeconds,y,compareLeapSecondDates$1))<0&&(y=new LeapSecond(y,_),f.splice(~g,0,y)),c=_)}}}else e._dataError="Error in loaded EOP data: The samples property is required.";else e._dataError="Error in loaded EOP data: The columnNames property is required."}function fillResultFromIndex(e,t,i,r,n){r*=i;n.xPoleWander=t[r+e._xPoleWanderRadiansColumn],n.yPoleWander=t[r+e._yPoleWanderRadiansColumn],n.xPoleOffset=t[r+e._xCelestialPoleOffsetRadiansColumn],n.yPoleOffset=t[r+e._yCelestialPoleOffsetRadiansColumn],n.ut1MinusUtc=t[r+e._ut1MinusUtcSecondsColumn]}function linearInterp(e,t,i){return t+e*(i-t)}function interpolate(e,t,i,r,n,a,o){var s=e._columnCount;if(a>t.length-1)return o.xPoleWander=0,o.yPoleWander=0,o.xPoleOffset=0,o.yPoleOffset=0,o.ut1MinusUtc=0,o;var l=t[n],c=t[a];if(l.equals(c)||r.equals(l))return fillResultFromIndex(e,i,n,s,o),o;if(r.equals(c))return fillResultFromIndex(e,i,a,s,o),o;var u=JulianDate.secondsDifference(r,l)/JulianDate.secondsDifference(c,l),d=n*s,t=a*s,l=i[d+e._ut1MinusUtcSecondsColumn],n=i[t+e._ut1MinusUtcSecondsColumn],a=n-l;return!(.5<a||a<-.5)||(s=i[d+e._taiMinusUtcSecondsColumn])!==(a=i[t+e._taiMinusUtcSecondsColumn])&&(c.equals(r)?l=n:n-=a-s),o.xPoleWander=linearInterp(u,i[d+e._xPoleWanderRadiansColumn],i[t+e._xPoleWanderRadiansColumn]),o.yPoleWander=linearInterp(u,i[d+e._yPoleWanderRadiansColumn],i[t+e._yPoleWanderRadiansColumn]),o.xPoleOffset=linearInterp(u,i[d+e._xCelestialPoleOffsetRadiansColumn],i[t+e._xCelestialPoleOffsetRadiansColumn]),o.yPoleOffset=linearInterp(u,i[d+e._yCelestialPoleOffsetRadiansColumn],i[t+e._yCelestialPoleOffsetRadiansColumn]),o.ut1MinusUtc=linearInterp(u,l,n),o}function HeadingPitchRoll(e,t,i){this.heading=defaultValue(e,0),this.pitch=defaultValue(t,0),this.roll=defaultValue(i,0)}function Iau2006XysSample(e,t,i){this.x=e,this.y=t,this.s=i}function Iau2006XysData(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._xysFileUrlTemplate=Resource.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=defaultValue(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=defaultValue(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new JulianDate(this._sampleZeroJulianEphemerisDate,0,TimeStandard$1.TAI),this._stepSizeDays=defaultValue(e.stepSizeDays,1),this._samplesPerXysFile=defaultValue(e.samplesPerXysFile,1e3),this._totalSamples=defaultValue(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,i=this._denominators=new Array(t+1),r=this._xTable=new Array(t+1),n=Math.pow(this._stepSizeDays,t),a=0;a<=t;++a){i[a]=n,r[a]=a*this._stepSizeDays;for(var o=0;o<=t;++o)o!==a&&(i[a]*=a-o);i[a]=1/i[a]}this._work=new Array(t+1),this._coef=new Array(t+1)}JulianDate.toGregorianDate=function(e,t){var i=!1,r=convertTaiToUtc(e,toGregorianDateScratch);defined(r)||(JulianDate.addSeconds(e,-1,toGregorianDateScratch),r=convertTaiToUtc(toGregorianDateScratch,toGregorianDateScratch),i=!0);var n=r.dayNumber,a=r.secondsOfDay;43200<=a&&(n+=1);var o=n+68569|0,s=4*o/146097|0,l=4e3*(1+(o=o-((146097*s+3)/4|0)|0))/1461001|0,e=80*(o=o-(1461*l/4|0)+31|0)/2447|0,r=o-(2447*e/80|0)|0,n=2+e-12*(o=e/11|0)|0,e=100*(s-49)+l+o|0,s=a/TimeConstants$1.SECONDS_PER_HOUR|0,l=a-s*TimeConstants$1.SECONDS_PER_HOUR,o=l/TimeConstants$1.SECONDS_PER_MINUTE|0,a=0|(l-=o*TimeConstants$1.SECONDS_PER_MINUTE),l=(l-a)/TimeConstants$1.SECONDS_PER_MILLISECOND;return 23<(s+=12)&&(s-=24),i&&(a+=1),defined(t)?(t.year=e,t.month=n,t.day=r,t.hour=s,t.minute=o,t.second=a,t.millisecond=l,t.isLeapSecond=i,t):new GregorianDate(e,n,r,s,o,a,l,i)},JulianDate.toDate=function(e){var t=JulianDate.toGregorianDate(e,gregorianDateScratch),e=t.second;return t.isLeapSecond&&--e,new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,e,t.millisecond))},JulianDate.toIso8601=function(e,t){var i=JulianDate.toGregorianDate(e,gregorianDateScratch),r=i.year,n=i.month,a=i.day,o=i.hour,s=i.minute,e=i.second,i=i.millisecond;return 1e4===r&&1===n&&1===a&&0===o&&0===s&&0===e&&0===i&&(r=9999,n=12,a=31,o=24),defined(t)||0===i?defined(t)&&0!==t?sprintf("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",r,n,a,o,s,e,(.01*i).toFixed(t).replace(".","").slice(0,t)):sprintf("%04d-%02d-%02dT%02d:%02d:%02dZ",r,n,a,o,s,e):sprintf("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",r,n,a,o,s,e,(.01*i).toString().replace(".",""))},JulianDate.clone=function(e,t){if(defined(e))return defined(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new JulianDate(e.dayNumber,e.secondsOfDay,TimeStandard$1.TAI)},JulianDate.compare=function(e,t){var i=e.dayNumber-t.dayNumber;return 0!=i?i:e.secondsOfDay-t.secondsOfDay},JulianDate.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},JulianDate.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(JulianDate.secondsDifference(e,t))<=i},JulianDate.totalDays=function(e){return e.dayNumber+e.secondsOfDay/TimeConstants$1.SECONDS_PER_DAY},JulianDate.secondsDifference=function(e,t){return(e.dayNumber-t.dayNumber)*TimeConstants$1.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},JulianDate.daysDifference=function(e,t){return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY},JulianDate.computeTaiMinusUtc=function(e){binarySearchScratchLeapSecond.julianDate=e;var t=JulianDate.leapSeconds,e=binarySearch(t,binarySearchScratchLeapSecond,compareLeapSecondDates);return e<0&&(e=~e,--e<0&&(e=0)),t[e].offset},JulianDate.addSeconds=function(e,t,i){return setComponents(e.dayNumber,e.secondsOfDay+t,i)},JulianDate.addMinutes=function(e,t,i){t=e.secondsOfDay+t*TimeConstants$1.SECONDS_PER_MINUTE;return setComponents(e.dayNumber,t,i)},JulianDate.addHours=function(e,t,i){t=e.secondsOfDay+t*TimeConstants$1.SECONDS_PER_HOUR;return setComponents(e.dayNumber,t,i)},JulianDate.addDays=function(e,t,i){return setComponents(e.dayNumber+t,e.secondsOfDay,i)},JulianDate.lessThan=function(e,t){return JulianDate.compare(e,t)<0},JulianDate.lessThanOrEquals=function(e,t){return JulianDate.compare(e,t)<=0},JulianDate.greaterThan=function(e,t){return 0<JulianDate.compare(e,t)},JulianDate.greaterThanOrEquals=function(e,t){return 0<=JulianDate.compare(e,t)},JulianDate.prototype.clone=function(e){return JulianDate.clone(this,e)},JulianDate.prototype.equals=function(e){return JulianDate.equals(this,e)},JulianDate.prototype.equalsEpsilon=function(e,t){return JulianDate.equalsEpsilon(this,e,t)},JulianDate.prototype.toString=function(){return JulianDate.toIso8601(this)},JulianDate.leapSeconds=[new LeapSecond(new JulianDate(2441317,43210,TimeStandard$1.TAI),10),new LeapSecond(new JulianDate(2441499,43211,TimeStandard$1.TAI),11),new LeapSecond(new JulianDate(2441683,43212,TimeStandard$1.TAI),12),new LeapSecond(new JulianDate(2442048,43213,TimeStandard$1.TAI),13),new LeapSecond(new JulianDate(2442413,43214,TimeStandard$1.TAI),14),new LeapSecond(new JulianDate(2442778,43215,TimeStandard$1.TAI),15),new LeapSecond(new JulianDate(2443144,43216,TimeStandard$1.TAI),16),new LeapSecond(new JulianDate(2443509,43217,TimeStandard$1.TAI),17),new LeapSecond(new JulianDate(2443874,43218,TimeStandard$1.TAI),18),new LeapSecond(new JulianDate(2444239,43219,TimeStandard$1.TAI),19),new LeapSecond(new JulianDate(2444786,43220,TimeStandard$1.TAI),20),new LeapSecond(new JulianDate(2445151,43221,TimeStandard$1.TAI),21),new LeapSecond(new JulianDate(2445516,43222,TimeStandard$1.TAI),22),new LeapSecond(new JulianDate(2446247,43223,TimeStandard$1.TAI),23),new LeapSecond(new JulianDate(2447161,43224,TimeStandard$1.TAI),24),new LeapSecond(new JulianDate(2447892,43225,TimeStandard$1.TAI),25),new LeapSecond(new JulianDate(2448257,43226,TimeStandard$1.TAI),26),new LeapSecond(new JulianDate(2448804,43227,TimeStandard$1.TAI),27),new LeapSecond(new JulianDate(2449169,43228,TimeStandard$1.TAI),28),new LeapSecond(new JulianDate(2449534,43229,TimeStandard$1.TAI),29),new LeapSecond(new JulianDate(2450083,43230,TimeStandard$1.TAI),30),new LeapSecond(new JulianDate(2450630,43231,TimeStandard$1.TAI),31),new LeapSecond(new JulianDate(2451179,43232,TimeStandard$1.TAI),32),new LeapSecond(new JulianDate(2453736,43233,TimeStandard$1.TAI),33),new LeapSecond(new JulianDate(2454832,43234,TimeStandard$1.TAI),34),new LeapSecond(new JulianDate(2456109,43235,TimeStandard$1.TAI),35),new LeapSecond(new JulianDate(2457204,43236,TimeStandard$1.TAI),36),new LeapSecond(new JulianDate(2457754,43237,TimeStandard$1.TAI),37)],EarthOrientationParameters.NONE=Object.freeze({getPromiseToLoad:function(){return when.resolve()},compute:function(e,t){return defined(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new EarthOrientationParametersSample(0,0,0,0,0),t}}),EarthOrientationParameters.prototype.getPromiseToLoad=function(){return when(this._downloadPromise)},EarthOrientationParameters.prototype.compute=function(e,t){if(defined(this._samples)){if(defined(t)||(t=new EarthOrientationParametersSample(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;var i=this._dates,r=this._lastIndex,n=0,a=0;if(defined(r)){var o=i[r],s=i[r+1],l=JulianDate.lessThanOrEquals(o,e),c=!defined(s),o=c||JulianDate.greaterThanOrEquals(s,e);if(l&&o)return n=r,!c&&s.equals(e)&&++n,a=n+1,interpolate(this,i,this._samples,e,n,a,t),t}s=binarySearch(i,e,JulianDate.compare,this._dateColumn);return 0<=s?(s<i.length-1&&i[s+1].equals(e)&&++s,a=n=s):(n=(a=~s)-1)<0&&(n=0),this._lastIndex=n,interpolate(this,i,this._samples,e,n,a,t),t}if(defined(this._dataError))throw new RuntimeError(this._dataError)},HeadingPitchRoll.fromQuaternion=function(e,t){defined(t)||(t=new HeadingPitchRoll);var i=2*(e.w*e.y-e.z*e.x),r=1-2*(e.x*e.x+e.y*e.y),n=2*(e.w*e.x+e.y*e.z),a=1-2*(e.y*e.y+e.z*e.z),e=2*(e.w*e.z+e.x*e.y);return t.heading=-Math.atan2(e,a),t.roll=Math.atan2(n,r),t.pitch=-CesiumMath.asinClamped(i),t},HeadingPitchRoll.fromDegrees=function(e,t,i,r){return defined(r)||(r=new HeadingPitchRoll),r.heading=e*CesiumMath.RADIANS_PER_DEGREE,r.pitch=t*CesiumMath.RADIANS_PER_DEGREE,r.roll=i*CesiumMath.RADIANS_PER_DEGREE,r},HeadingPitchRoll.clone=function(e,t){if(defined(e))return defined(t)?(t.heading=e.heading,t.pitch=e.pitch,t.roll=e.roll,t):new HeadingPitchRoll(e.heading,e.pitch,e.roll)},HeadingPitchRoll.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.heading===t.heading&&e.pitch===t.pitch&&e.roll===t.roll},HeadingPitchRoll.equalsEpsilon=function(e,t,i,r){return e===t||defined(e)&&defined(t)&&CesiumMath.equalsEpsilon(e.heading,t.heading,i,r)&&CesiumMath.equalsEpsilon(e.pitch,t.pitch,i,r)&&CesiumMath.equalsEpsilon(e.roll,t.roll,i,r)},HeadingPitchRoll.prototype.clone=function(e){return HeadingPitchRoll.clone(this,e)},HeadingPitchRoll.prototype.equals=function(e){return HeadingPitchRoll.equals(this,e)},HeadingPitchRoll.prototype.equalsEpsilon=function(e,t,i){return HeadingPitchRoll.equalsEpsilon(this,e,t,i)},HeadingPitchRoll.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"};var julianDateScratch=new JulianDate(0,0,TimeStandard$1.TAI),_supportsFullscreen;function getDaysSinceEpoch(e,t,i){var r=julianDateScratch;return r.dayNumber=t,r.secondsOfDay=i,JulianDate.daysDifference(r,e._sampleZeroDateTT)}function requestXysChunk(o,s){if(o._chunkDownloadsInProgress[s])return o._chunkDownloadsInProgress[s];var l=when.defer();o._chunkDownloadsInProgress[s]=l;var e=o._xysFileUrlTemplate;return when((defined(e)?e.getDerivedResource({templateValues:{0:s}}):new Resource({url:buildModuleUrl("Assets/IAU2006_XYS/IAU2006_XYS_"+s+".json")})).fetchJson(),function(e){o._chunkDownloadsInProgress[s]=!1;for(var t=o._samples,i=e.samples,r=s*o._samplesPerXysFile*3,n=0,a=i.length;n<a;++n)t[r+n]=i[n];l.resolve()}),l.promise}Iau2006XysData.prototype.preload=function(e,t,i,r){t=getDaysSinceEpoch(this,e,t),r=getDaysSinceEpoch(this,i,r),t=t/this._stepSizeDays-this._interpolationOrder/2|0;t<0&&(t=0);r=r/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;r>=this._totalSamples&&(r=this._totalSamples-1);for(var t=t/this._samplesPerXysFile|0,n=r/this._samplesPerXysFile|0,a=[],o=t;o<=n;++o)a.push(requestXysChunk(this,o));return when.all(a)},Iau2006XysData.prototype.computeXysRadians=function(e,t,i){var r=getDaysSinceEpoch(this,e,t);if(!(r<0)){e=r/this._stepSizeDays|0;if(!(e>=this._totalSamples)){var n=this._interpolationOrder,a=e-(n/2|0);a<0&&(a=0);t=a+n;t>=this._totalSamples&&(a=(t=this._totalSamples-1)-n)<0&&(a=0);var e=!1,o=this._samples;if(defined(o[3*a])||(requestXysChunk(this,a/this._samplesPerXysFile|0),e=!0),defined(o[3*t])||(requestXysChunk(this,t/this._samplesPerXysFile|0),e=!0),!e){defined(i)?(i.x=0,i.y=0,i.s=0):i=new Iau2006XysSample(0,0,0);for(var s,l=r-a*this._stepSizeDays,c=this._work,u=this._denominators,d=this._coef,h=this._xTable,p=0;p<=n;++p)c[p]=l-h[p];for(p=0;p<=n;++p){for(d[p]=1,s=0;s<=n;++s)s!==p&&(d[p]*=c[s]);d[p]*=u[p];var m=3*(a+p);i.x+=d[p]*o[m++],i.y+=d[p]*o[m++],i.s+=d[p]*o[m]}return i}}}};var _names={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},Fullscreen={},theNavigator,isChromeResult,chromeVersionResult,isSafariResult,safariVersionResult,isWebkitResult,webkitVersionResult,isInternetExplorerResult,internetExplorerVersionResult,isEdgeResult,edgeVersionResult,isFirefoxResult,firefoxVersionResult,isWindowsResult,hasPointerEvents,imageRenderingValueResult,supportsImageRenderingPixelatedResult;function extractVersion(e){for(var t=e.split("."),i=0,r=t.length;i<r;++i)t[i]=parseInt(t[i],10);return t}function isChrome(){var e;return defined(isChromeResult)||(isChromeResult=!1,isEdge()||null!==(e=/ Chrome\/([\.0-9]+)/.exec(theNavigator.userAgent))&&(isChromeResult=!0,chromeVersionResult=extractVersion(e[1]))),isChromeResult}function chromeVersion(){return isChrome()&&chromeVersionResult}function isSafari(){var e;return defined(isSafariResult)||(isSafariResult=!1,isChrome()||isEdge()||!/ Safari\/[\.0-9]+/.test(theNavigator.userAgent)||null!==(e=/ Version\/([\.0-9]+)/.exec(theNavigator.userAgent))&&(isSafariResult=!0,safariVersionResult=extractVersion(e[1]))),isSafariResult}function safariVersion(){return isSafari()&&safariVersionResult}function isWebkit(){var e;return defined(isWebkitResult)||(isWebkitResult=!1,null!==(e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(theNavigator.userAgent))&&(isWebkitResult=!0,(webkitVersionResult=extractVersion(e[1])).isNightly=!!e[2])),isWebkitResult}function webkitVersion(){return isWebkit()&&webkitVersionResult}function isInternetExplorer(){var e;return defined(isInternetExplorerResult)||(isInternetExplorerResult=!1,"Microsoft Internet Explorer"===theNavigator.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(theNavigator.userAgent))&&(isInternetExplorerResult=!0,internetExplorerVersionResult=extractVersion(e[1])):"Netscape"===theNavigator.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(theNavigator.userAgent))&&(isInternetExplorerResult=!0,internetExplorerVersionResult=extractVersion(e[1]))),isInternetExplorerResult}function internetExplorerVersion(){return isInternetExplorer()&&internetExplorerVersionResult}function isEdge(){var e;return defined(isEdgeResult)||(isEdgeResult=!1,null!==(e=/ Edge\/([\.0-9]+)/.exec(theNavigator.userAgent))&&(isEdgeResult=!0,edgeVersionResult=extractVersion(e[1]))),isEdgeResult}function edgeVersion(){return isEdge()&&edgeVersionResult}function isFirefox(){var e;return defined(isFirefoxResult)||(isFirefoxResult=!1,null!==(e=/Firefox\/([\.0-9]+)/.exec(theNavigator.userAgent))&&(isFirefoxResult=!0,firefoxVersionResult=extractVersion(e[1]))),isFirefoxResult}function isWindows(){return defined(isWindowsResult)||(isWindowsResult=/Windows/i.test(theNavigator.appVersion)),isWindowsResult}function firefoxVersion(){return isFirefox()&&firefoxVersionResult}function supportsPointerEvents(){return defined(hasPointerEvents)||(hasPointerEvents=!isFirefox()&&"undefined"!=typeof PointerEvent&&(!defined(theNavigator.pointerEnabled)||theNavigator.pointerEnabled)),hasPointerEvents}function supportsImageRenderingPixelated(){var e;return defined(supportsImageRenderingPixelatedResult)||((e=document.createElement("canvas")).setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;"),e=e.style.imageRendering,(supportsImageRenderingPixelatedResult=defined(e)&&""!==e)&&(imageRenderingValueResult=e)),supportsImageRenderingPixelatedResult}function imageRenderingValue(){return supportsImageRenderingPixelated()?imageRenderingValueResult:void 0}function supportsWebP(){return supportsWebP._result}Object.defineProperties(Fullscreen,{element:{get:function(){if(Fullscreen.supportsFullscreen())return document[_names.fullscreenElement]}},changeEventName:{get:function(){if(Fullscreen.supportsFullscreen())return _names.fullscreenchange}},errorEventName:{get:function(){if(Fullscreen.supportsFullscreen())return _names.fullscreenerror}},enabled:{get:function(){if(Fullscreen.supportsFullscreen())return document[_names.fullscreenEnabled]}},fullscreen:{get:function(){if(Fullscreen.supportsFullscreen())return null!==Fullscreen.element}}}),Fullscreen.supportsFullscreen=function(){if(defined(_supportsFullscreen))return _supportsFullscreen;_supportsFullscreen=!1;var e=document.body;if("function"==typeof e.requestFullscreen)return _names.requestFullscreen="requestFullscreen",_names.exitFullscreen="exitFullscreen",_names.fullscreenEnabled="fullscreenEnabled",_names.fullscreenElement="fullscreenElement",_names.fullscreenchange="fullscreenchange",_names.fullscreenerror="fullscreenerror",_supportsFullscreen=!0;for(var t=["webkit","moz","o","ms","khtml"],i=0,r=t.length;i<r;++i){var n,a=t[i];"function"!=typeof e[n=a+"RequestFullscreen"]&&"function"!=typeof e[n=a+"RequestFullScreen"]||(_names.requestFullscreen=n,_supportsFullscreen=!0),n=a+"ExitFullscreen","function"==typeof document[n]?_names.exitFullscreen=n:(n=a+"CancelFullScreen","function"==typeof document[n]&&(_names.exitFullscreen=n)),n=a+"FullscreenEnabled",void 0!==document[n]?_names.fullscreenEnabled=n:(n=a+"FullScreenEnabled",void 0!==document[n]&&(_names.fullscreenEnabled=n)),n=a+"FullscreenElement",void 0!==document[n]?_names.fullscreenElement=n:(n=a+"FullScreenElement",void 0!==document[n]&&(_names.fullscreenElement=n)),n=a+"fullscreenchange",void 0!==document["on"+n]&&("ms"===a&&(n="MSFullscreenChange"),_names.fullscreenchange=n),n=a+"fullscreenerror",void 0!==document["on"+n]&&("ms"===a&&(n="MSFullscreenError"),_names.fullscreenerror=n)}return _supportsFullscreen},Fullscreen.requestFullscreen=function(e,t){Fullscreen.supportsFullscreen()&&e[_names.requestFullscreen]({vrDisplay:t})},Fullscreen.exitFullscreen=function(){Fullscreen.supportsFullscreen()&&document[_names.exitFullscreen]()},Fullscreen._names=_names,theNavigator="undefined"!=typeof navigator?navigator:{},supportsWebP._promise=void 0,supportsWebP._result=void 0,supportsWebP.initialize=function(){if(defined(supportsWebP._promise))return supportsWebP._promise;var e=when.defer();if(supportsWebP._promise=e.promise,isEdge())return supportsWebP._result=!1,e.resolve(supportsWebP._result),e.promise;var t=new Image;return t.onload=function(){supportsWebP._result=0<t.width&&0<t.height,e.resolve(supportsWebP._result)},t.onerror=function(){supportsWebP._result=!1,e.resolve(supportsWebP._result)},t.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",e.promise},Object.defineProperties(supportsWebP,{initialized:{get:function(){return defined(supportsWebP._result)}}});var typedArrayTypes=[];"undefined"!=typeof ArrayBuffer&&(typedArrayTypes.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&typedArrayTypes.push(Uint8ClampedArray),"undefined"!=typeof Uint8ClampedArray&&typedArrayTypes.push(Uint8ClampedArray));var FeatureDetection={isChrome:isChrome,chromeVersion:chromeVersion,isSafari:isSafari,safariVersion:safariVersion,isWebkit:isWebkit,webkitVersion:webkitVersion,isInternetExplorer:isInternetExplorer,internetExplorerVersion:internetExplorerVersion,isEdge:isEdge,edgeVersion:edgeVersion,isFirefox:isFirefox,firefoxVersion:firefoxVersion,isWindows:isWindows,hardwareConcurrency:defaultValue(theNavigator.hardwareConcurrency,3),supportsPointerEvents:supportsPointerEvents,supportsImageRenderingPixelated:supportsImageRenderingPixelated,supportsWebP:supportsWebP,imageRenderingValue:imageRenderingValue,typedArrayTypes:typedArrayTypes};function Quaternion(e,t,i,r){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.z=defaultValue(i,0),this.w=defaultValue(r,0)}FeatureDetection.supportsFullscreen=function(){return Fullscreen.supportsFullscreen()},FeatureDetection.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},FeatureDetection.supportsWebWorkers=function(){return"undefined"!=typeof Worker},FeatureDetection.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!FeatureDetection.isEdge()};var fromAxisAngleScratch=new Cartesian3;Quaternion.fromAxisAngle=function(e,t,i){var r=t/2,n=Math.sin(r),t=(fromAxisAngleScratch=Cartesian3.normalize(e,fromAxisAngleScratch)).x*n,e=fromAxisAngleScratch.y*n,n=fromAxisAngleScratch.z*n,r=Math.cos(r);return defined(i)?(i.x=t,i.y=e,i.z=n,i.w=r,i):new Quaternion(t,e,n,r)};var fromRotationMatrixNext=[1,2,0],fromRotationMatrixQuat=new Array(3);Quaternion.fromRotationMatrix=function(e,t){var i,r,n,a,o=e[Matrix3.COLUMN0ROW0],s=e[Matrix3.COLUMN1ROW1],l=e[Matrix3.COLUMN2ROW2],c=o+s+l,u=0<c?(n=.5*(a=Math.sqrt(c+1)),a=.5/a,i=(e[Matrix3.COLUMN1ROW2]-e[Matrix3.COLUMN2ROW1])*a,r=(e[Matrix3.COLUMN2ROW0]-e[Matrix3.COLUMN0ROW2])*a,(e[Matrix3.COLUMN0ROW1]-e[Matrix3.COLUMN1ROW0])*a):(o=fromRotationMatrixNext[l=o<l&&s<l?2:o<s?1:0],s=fromRotationMatrixNext[o],a=Math.sqrt(e[Matrix3.getElementIndex(l,l)]-e[Matrix3.getElementIndex(o,o)]-e[Matrix3.getElementIndex(s,s)]+1),(u=fromRotationMatrixQuat)[l]=.5*a,a=.5/a,n=(e[Matrix3.getElementIndex(s,o)]-e[Matrix3.getElementIndex(o,s)])*a,u[o]=(e[Matrix3.getElementIndex(o,l)]+e[Matrix3.getElementIndex(l,o)])*a,u[s]=(e[Matrix3.getElementIndex(s,l)]+e[Matrix3.getElementIndex(l,s)])*a,i=-u[0],r=-u[1],-u[2]);return defined(t)?(t.x=i,t.y=r,t.z=u,t.w=n,t):new Quaternion(i,r,u,n)};var scratchHPRQuaternion=new Quaternion,scratchHeadingQuaternion=new Quaternion,scratchPitchQuaternion=new Quaternion,scratchRollQuaternion=new Quaternion;Quaternion.fromHeadingPitchRoll=function(e,t){return scratchRollQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_X,e.roll,scratchHPRQuaternion),scratchPitchQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_Y,-e.pitch,t),t=Quaternion.multiply(scratchPitchQuaternion,scratchRollQuaternion,scratchPitchQuaternion),scratchHeadingQuaternion=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,-e.heading,scratchHPRQuaternion),Quaternion.multiply(scratchHeadingQuaternion,t,t)};var sampledQuaternionAxis=new Cartesian3,sampledQuaternionRotation=new Cartesian3,sampledQuaternionTempQuaternion=new Quaternion,sampledQuaternionQuaternion0=new Quaternion,sampledQuaternionQuaternion0Conjugate=new Quaternion;Quaternion.packedLength=4,Quaternion.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.z,t[i]=e.w,t},Quaternion.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Quaternion),i.x=e[t],i.y=e[t+1],i.z=e[t+2],i.w=e[t+3],i},Quaternion.packedInterpolationLength=3,Quaternion.convertPackedArrayForInterpolation=function(e,t,i,r){Quaternion.unpack(e,4*i,sampledQuaternionQuaternion0Conjugate),Quaternion.conjugate(sampledQuaternionQuaternion0Conjugate,sampledQuaternionQuaternion0Conjugate);for(var n=0,a=i-t+1;n<a;n++){var o=3*n;Quaternion.unpack(e,4*(t+n),sampledQuaternionTempQuaternion),Quaternion.multiply(sampledQuaternionTempQuaternion,sampledQuaternionQuaternion0Conjugate,sampledQuaternionTempQuaternion),sampledQuaternionTempQuaternion.w<0&&Quaternion.negate(sampledQuaternionTempQuaternion,sampledQuaternionTempQuaternion),Quaternion.computeAxis(sampledQuaternionTempQuaternion,sampledQuaternionAxis);var s=Quaternion.computeAngle(sampledQuaternionTempQuaternion);defined(r)||(r=[]),r[o]=sampledQuaternionAxis.x*s,r[1+o]=sampledQuaternionAxis.y*s,r[2+o]=sampledQuaternionAxis.z*s}},Quaternion.unpackInterpolationResult=function(e,t,i,r,n){defined(n)||(n=new Quaternion),Cartesian3.fromArray(e,0,sampledQuaternionRotation);e=Cartesian3.magnitude(sampledQuaternionRotation);return Quaternion.unpack(t,4*r,sampledQuaternionQuaternion0),0===e?Quaternion.clone(Quaternion.IDENTITY,sampledQuaternionTempQuaternion):Quaternion.fromAxisAngle(sampledQuaternionRotation,e,sampledQuaternionTempQuaternion),Quaternion.multiply(sampledQuaternionTempQuaternion,sampledQuaternionQuaternion0,n)},Quaternion.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new Quaternion(e.x,e.y,e.z,e.w)},Quaternion.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},Quaternion.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},Quaternion.magnitude=function(e){return Math.sqrt(Quaternion.magnitudeSquared(e))},Quaternion.normalize=function(e,t){var i=1/Quaternion.magnitude(e),r=e.x*i,n=e.y*i,a=e.z*i,i=e.w*i;return t.x=r,t.y=n,t.z=a,t.w=i,t},Quaternion.inverse=function(e,t){var i=Quaternion.magnitudeSquared(e);return t=Quaternion.conjugate(e,t),Quaternion.multiplyByScalar(t,1/i,t)},Quaternion.add=function(e,t,i){return i.x=e.x+t.x,i.y=e.y+t.y,i.z=e.z+t.z,i.w=e.w+t.w,i},Quaternion.subtract=function(e,t,i){return i.x=e.x-t.x,i.y=e.y-t.y,i.z=e.z-t.z,i.w=e.w-t.w,i},Quaternion.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},Quaternion.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},Quaternion.multiply=function(e,t,i){var r=e.x,n=e.y,a=e.z,o=e.w,s=t.x,l=t.y,c=t.z,u=t.w,d=o*s+r*u+n*c-a*l,e=o*l-r*c+n*u+a*s,t=o*c+r*l-n*s+a*u,c=o*u-r*s-n*l-a*c;return i.x=d,i.y=e,i.z=t,i.w=c,i},Quaternion.multiplyByScalar=function(e,t,i){return i.x=e.x*t,i.y=e.y*t,i.z=e.z*t,i.w=e.w*t,i},Quaternion.divideByScalar=function(e,t,i){return i.x=e.x/t,i.y=e.y/t,i.z=e.z/t,i.w=e.w/t,i},Quaternion.computeAxis=function(e,t){var i=e.w;if(Math.abs(i-1)<CesiumMath.EPSILON6)return t.x=t.y=t.z=0,t;i=1/Math.sqrt(1-i*i);return t.x=e.x*i,t.y=e.y*i,t.z=e.z*i,t},Quaternion.computeAngle=function(e){return Math.abs(e.w-1)<CesiumMath.EPSILON6?0:2*Math.acos(e.w)};var lerpScratch$3=new Quaternion;Quaternion.lerp=function(e,t,i,r){return lerpScratch$3=Quaternion.multiplyByScalar(t,i,lerpScratch$3),r=Quaternion.multiplyByScalar(e,1-i,r),Quaternion.add(lerpScratch$3,r,r)};var slerpEndNegated=new Quaternion,slerpScaledP=new Quaternion,slerpScaledR=new Quaternion;Quaternion.slerp=function(e,t,i,r){var n=Quaternion.dot(e,t),a=t;if(n<0&&(n=-n,a=slerpEndNegated=Quaternion.negate(t,slerpEndNegated)),1-n<CesiumMath.EPSILON6)return Quaternion.lerp(e,a,i,r);n=Math.acos(n);return slerpScaledP=Quaternion.multiplyByScalar(e,Math.sin((1-i)*n),slerpScaledP),slerpScaledR=Quaternion.multiplyByScalar(a,Math.sin(i*n),slerpScaledR),r=Quaternion.add(slerpScaledP,slerpScaledR,r),Quaternion.multiplyByScalar(r,1/Math.sin(n),r)},Quaternion.log=function(e,t){var i=CesiumMath.acosClamped(e.w),r=0;return 0!==i&&(r=i/Math.sin(i)),Cartesian3.multiplyByScalar(e,r,t)},Quaternion.exp=function(e,t){var i=Cartesian3.magnitude(e),r=0;return 0!==i&&(r=Math.sin(i)/i),t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t.w=Math.cos(i),t};var squadScratchCartesian0=new Cartesian3,squadScratchCartesian1=new Cartesian3,squadScratchQuaternion0=new Quaternion,squadScratchQuaternion1=new Quaternion;Quaternion.computeInnerQuadrangle=function(e,t,i,r){var n=Quaternion.conjugate(t,squadScratchQuaternion0);Quaternion.multiply(n,i,squadScratchQuaternion1);i=Quaternion.log(squadScratchQuaternion1,squadScratchCartesian0);Quaternion.multiply(n,e,squadScratchQuaternion1);e=Quaternion.log(squadScratchQuaternion1,squadScratchCartesian1);return Cartesian3.add(i,e,i),Cartesian3.multiplyByScalar(i,.25,i),Cartesian3.negate(i,i),Quaternion.exp(i,squadScratchQuaternion0),Quaternion.multiply(t,squadScratchQuaternion0,r)},Quaternion.squad=function(e,t,i,r,n,a){t=Quaternion.slerp(e,t,n,squadScratchQuaternion0),r=Quaternion.slerp(i,r,n,squadScratchQuaternion1);return Quaternion.slerp(t,r,2*n*(1-n),a)};for(var fastSlerpScratchQuaternion=new Quaternion,opmu=1.9011074535173003,u=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],v=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],bT=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],bD=FeatureDetection.supportsTypedArrays()?new Float32Array(8):[],i=0;i<7;++i){var s=i+1,t=2*s+1;u[i]=1/(s*t),v[i]=s/t}u[7]=opmu/136,v[7]=8*opmu/17,Quaternion.fastSlerp=function(e,t,i,r){var n,a=Quaternion.dot(e,t);0<=a?n=1:(n=-1,a=-a);for(var o=a-1,a=1-i,s=i*i,l=a*a,c=7;0<=c;--c)bT[c]=(u[c]*s-v[c])*o,bD[c]=(u[c]*l-v[c])*o;i=n*i*(1+bT[0]*(1+bT[1]*(1+bT[2]*(1+bT[3]*(1+bT[4]*(1+bT[5]*(1+bT[6]*(1+bT[7])))))))),a*=1+bD[0]*(1+bD[1]*(1+bD[2]*(1+bD[3]*(1+bD[4]*(1+bD[5]*(1+bD[6]*(1+bD[7]))))))),a=Quaternion.multiplyByScalar(e,a,fastSlerpScratchQuaternion);return Quaternion.multiplyByScalar(t,i,r),Quaternion.add(a,r,r)},Quaternion.fastSquad=function(e,t,i,r,n,a){t=Quaternion.fastSlerp(e,t,n,squadScratchQuaternion0),r=Quaternion.fastSlerp(i,r,n,squadScratchQuaternion1);return Quaternion.fastSlerp(t,r,2*n*(1-n),a)},Quaternion.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},Quaternion.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e.x-t.x)<=i&&Math.abs(e.y-t.y)<=i&&Math.abs(e.z-t.z)<=i&&Math.abs(e.w-t.w)<=i},Quaternion.ZERO=Object.freeze(new Quaternion(0,0,0,0)),Quaternion.IDENTITY=Object.freeze(new Quaternion(0,0,0,1)),Quaternion.prototype.clone=function(e){return Quaternion.clone(this,e)},Quaternion.prototype.equals=function(e){return Quaternion.equals(this,e)},Quaternion.prototype.equalsEpsilon=function(e,t){return Quaternion.equalsEpsilon(this,e,t)},Quaternion.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var Transforms={},vectorProductLocalFrame={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},degeneratePositionLocalFrame={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},localFrameToFixedFrameCache={},scratchCalculateCartesian={east:new Cartesian3,north:new Cartesian3,up:new Cartesian3,west:new Cartesian3,south:new Cartesian3,down:new Cartesian3},scratchFirstCartesian=new Cartesian3,scratchSecondCartesian=new Cartesian3,scratchThirdCartesian=new Cartesian3;Transforms.localFrameToFixedFrameGenerator=function(n,a){if(!vectorProductLocalFrame.hasOwnProperty(n)||!vectorProductLocalFrame[n].hasOwnProperty(a))throw new DeveloperError("firstAxis and secondAxis must be east, north, up, west, south or down.");var e,o=vectorProductLocalFrame[n][a],t=n+a;return defined(localFrameToFixedFrameCache[t])?e=localFrameToFixedFrameCache[t]:(e=function(e,t,i){var r;return defined(i)||(i=new Matrix4),Cartesian3.equalsEpsilon(e,Cartesian3.ZERO,CesiumMath.EPSILON14)?(Cartesian3.unpack(degeneratePositionLocalFrame[n],0,scratchFirstCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[a],0,scratchSecondCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[o],0,scratchThirdCartesian)):CesiumMath.equalsEpsilon(e.x,0,CesiumMath.EPSILON14)&&CesiumMath.equalsEpsilon(e.y,0,CesiumMath.EPSILON14)?(r=CesiumMath.sign(e.z),Cartesian3.unpack(degeneratePositionLocalFrame[n],0,scratchFirstCartesian),"east"!==n&&"west"!==n&&Cartesian3.multiplyByScalar(scratchFirstCartesian,r,scratchFirstCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[a],0,scratchSecondCartesian),"east"!==a&&"west"!==a&&Cartesian3.multiplyByScalar(scratchSecondCartesian,r,scratchSecondCartesian),Cartesian3.unpack(degeneratePositionLocalFrame[o],0,scratchThirdCartesian),"east"!==o&&"west"!==o&&Cartesian3.multiplyByScalar(scratchThirdCartesian,r,scratchThirdCartesian)):((t=defaultValue(t,Ellipsoid.WGS84)).geodeticSurfaceNormal(e,scratchCalculateCartesian.up),r=scratchCalculateCartesian.up,(t=scratchCalculateCartesian.east).x=-e.y,t.y=e.x,t.z=0,Cartesian3.normalize(t,scratchCalculateCartesian.east),Cartesian3.cross(r,t,scratchCalculateCartesian.north),Cartesian3.multiplyByScalar(scratchCalculateCartesian.up,-1,scratchCalculateCartesian.down),Cartesian3.multiplyByScalar(scratchCalculateCartesian.east,-1,scratchCalculateCartesian.west),Cartesian3.multiplyByScalar(scratchCalculateCartesian.north,-1,scratchCalculateCartesian.south),scratchFirstCartesian=scratchCalculateCartesian[n],scratchSecondCartesian=scratchCalculateCartesian[a],scratchThirdCartesian=scratchCalculateCartesian[o]),i[0]=scratchFirstCartesian.x,i[1]=scratchFirstCartesian.y,i[2]=scratchFirstCartesian.z,i[3]=0,i[4]=scratchSecondCartesian.x,i[5]=scratchSecondCartesian.y,i[6]=scratchSecondCartesian.z,i[7]=0,i[8]=scratchThirdCartesian.x,i[9]=scratchThirdCartesian.y,i[10]=scratchThirdCartesian.z,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},localFrameToFixedFrameCache[t]=e),e},Transforms.eastNorthUpToFixedFrame=Transforms.localFrameToFixedFrameGenerator("east","north"),Transforms.northEastDownToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","east"),Transforms.northUpEastToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","up"),Transforms.northWestUpToFixedFrame=Transforms.localFrameToFixedFrameGenerator("north","west");var scratchHPRQuaternion$1=new Quaternion,scratchScale$2=new Cartesian3(1,1,1),scratchHPRMatrix4=new Matrix4;Transforms.headingPitchRollToFixedFrame=function(e,t,i,r,n){r=defaultValue(r,Transforms.eastNorthUpToFixedFrame);t=Quaternion.fromHeadingPitchRoll(t,scratchHPRQuaternion$1),t=Matrix4.fromTranslationQuaternionRotationScale(Cartesian3.ZERO,t,scratchScale$2,scratchHPRMatrix4);return n=r(e,i,n),Matrix4.multiply(n,t,n)};var scratchENUMatrix4=new Matrix4,scratchHPRMatrix3=new Matrix3;Transforms.headingPitchRollQuaternion=function(e,t,i,r,n){r=Transforms.headingPitchRollToFixedFrame(e,t,i,r,scratchENUMatrix4),r=Matrix4.getMatrix3(r,scratchHPRMatrix3);return Quaternion.fromRotationMatrix(r,n)};var noScale=new Cartesian3(1,1,1),hprCenterScratch=new Cartesian3,ffScratch=new Matrix4,hprTransformScratch=new Matrix4,hprRotationScratch=new Matrix3,hprQuaternionScratch=new Quaternion;Transforms.fixedFrameToHeadingPitchRoll=function(e,t,i,r){t=defaultValue(t,Ellipsoid.WGS84),i=defaultValue(i,Transforms.eastNorthUpToFixedFrame),defined(r)||(r=new HeadingPitchRoll);var n=Matrix4.getTranslation(e,hprCenterScratch);if(Cartesian3.equals(n,Cartesian3.ZERO))return r.heading=0,r.pitch=0,r.roll=0,r;t=Matrix4.inverseTransformation(i(n,t,ffScratch),ffScratch),e=Matrix4.setScale(e,noScale,hprTransformScratch),e=Matrix4.setTranslation(e,Cartesian3.ZERO,e),t=Matrix4.multiply(t,e,t),t=Quaternion.fromRotationMatrix(Matrix4.getMatrix3(t,hprRotationScratch),hprQuaternionScratch),t=Quaternion.normalize(t,t);return HeadingPitchRoll.fromQuaternion(t,r)};var gmstConstant0=24110.54841,gmstConstant1=8640184.812866,gmstConstant2=.093104,gmstConstant3=-62e-7,rateCoef=11772758384668e-32,wgs84WRPrecessing=72921158553e-15,twoPiOverSecondsInDay=CesiumMath.TWO_PI/86400,dateInUtc=new JulianDate;Transforms.computeTemeToPseudoFixedMatrix=function(e,t){var i=(dateInUtc=JulianDate.addSeconds(e,-JulianDate.computeTaiMinusUtc(e),dateInUtc)).dayNumber,r=dateInUtc.secondsOfDay,e=i-2451545,e=43200<=r?(.5+e)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY:(e-.5)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY,i=(gmstConstant0+e*(gmstConstant1+e*(gmstConstant2+e*gmstConstant3)))*twoPiOverSecondsInDay%CesiumMath.TWO_PI+(wgs84WRPrecessing+rateCoef*(i-2451545.5))*((r+.5*TimeConstants$1.SECONDS_PER_DAY)%TimeConstants$1.SECONDS_PER_DAY),r=Math.cos(i),i=Math.sin(i);return defined(t)?(t[0]=r,t[1]=-i,t[2]=0,t[3]=i,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new Matrix3(r,i,0,-i,r,0,0,0,1)},Transforms.iau2006XysData=new Iau2006XysData,Transforms.earthOrientationParameters=EarthOrientationParameters.NONE;var ttMinusTai=32.184,j2000ttDays=2451545;Transforms.preloadIcrfFixed=function(e){var t=e.start.dayNumber,i=e.start.secondsOfDay+ttMinusTai,r=e.stop.dayNumber,e=e.stop.secondsOfDay+ttMinusTai,r=Transforms.iau2006XysData.preload(t,i,r,e),e=Transforms.earthOrientationParameters.getPromiseToLoad();return when.all([r,e])},Transforms.computeIcrfToFixedMatrix=function(e,t){defined(t)||(t=new Matrix3);e=Transforms.computeFixedToIcrfMatrix(e,t);if(defined(e))return Matrix3.transpose(e,t)};var xysScratch=new Iau2006XysSample(0,0,0),eopScratch=new EarthOrientationParametersSample(0,0,0,0,0,0),rotation1Scratch=new Matrix3,rotation2Scratch=new Matrix3;Transforms.computeFixedToIcrfMatrix=function(e,t){defined(t)||(t=new Matrix3);var i=Transforms.earthOrientationParameters.compute(e,eopScratch);if(defined(i)){var r=e.dayNumber,n=e.secondsOfDay+ttMinusTai,a=Transforms.iau2006XysData.computeXysRadians(r,n,xysScratch);if(defined(a)){var o=a.x+i.xPoleOffset,s=a.y+i.yPoleOffset,l=1/(1+Math.sqrt(1-o*o-s*s)),c=rotation1Scratch;c[0]=1-l*o*o,c[3]=-l*o*s,c[6]=o,c[1]=-l*o*s,c[4]=1-l*s*s,c[7]=s,c[2]=-o,c[5]=-s,c[8]=1-l*(o*o+s*s);o=Matrix3.fromRotationZ(-a.s,rotation2Scratch),s=Matrix3.multiply(c,o,rotation1Scratch),a=e.dayNumber-2451545,c=(e.secondsOfDay-JulianDate.computeTaiMinusUtc(e)+i.ut1MinusUtc)/TimeConstants$1.SECONDS_PER_DAY,o=(o=.779057273264+c+.00273781191135448*(a+c))%1*CesiumMath.TWO_PI,e=Matrix3.fromRotationZ(o,rotation2Scratch),a=Matrix3.multiply(s,e,rotation1Scratch),c=Math.cos(i.xPoleWander),o=Math.cos(i.yPoleWander),s=Math.sin(i.xPoleWander),e=Math.sin(i.yPoleWander),i=r-j2000ttDays+n/TimeConstants$1.SECONDS_PER_DAY,r=-47e-6*(i/=36525)*CesiumMath.RADIANS_PER_DEGREE/3600,n=Math.cos(r),i=Math.sin(r),r=rotation2Scratch;return r[0]=c*n,r[1]=c*i,r[2]=s,r[3]=-o*i+e*s*n,r[4]=o*n+e*s*i,r[5]=-e*c,r[6]=-e*i-o*s*n,r[7]=e*n-o*s*i,r[8]=o*c,Matrix3.multiply(a,r,t)}}};var pointToWindowCoordinatesTemp=new Cartesian4;Transforms.pointToWindowCoordinates=function(e,t,i,r){return(r=Transforms.pointToGLWindowCoordinates(e,t,i,r)).y=2*t[5]-r.y,r},Transforms.pointToGLWindowCoordinates=function(e,t,i,r){defined(r)||(r=new Cartesian2);var n=pointToWindowCoordinatesTemp;return Matrix4.multiplyByVector(e,Cartesian4.fromElements(i.x,i.y,i.z,1,n),n),Cartesian4.multiplyByScalar(n,1/n.w,n),Matrix4.multiplyByVector(t,n,n),Cartesian2.fromCartesian4(n,r)};var normalScratch=new Cartesian3,rightScratch=new Cartesian3,upScratch=new Cartesian3;Transforms.rotationMatrixFromPositionVelocity=function(e,t,i,r){i=defaultValue(i,Ellipsoid.WGS84).geodeticSurfaceNormal(e,normalScratch),e=Cartesian3.cross(t,i,rightScratch);Cartesian3.equalsEpsilon(e,Cartesian3.ZERO,CesiumMath.EPSILON6)&&(e=Cartesian3.clone(Cartesian3.UNIT_X,e));i=Cartesian3.cross(e,t,upScratch);return Cartesian3.normalize(i,i),Cartesian3.cross(t,i,e),Cartesian3.negate(e,e),Cartesian3.normalize(e,e),defined(r)||(r=new Matrix3),r[0]=t.x,r[1]=t.y,r[2]=t.z,r[3]=e.x,r[4]=e.y,r[5]=e.z,r[6]=i.x,r[7]=i.y,r[8]=i.z,r};var swizzleMatrix=new Matrix4(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),scratchCartographic=new Cartographic,scratchCartesian3Projection=new Cartesian3,scratchCenter=new Cartesian3,scratchRotation=new Matrix3,scratchFromENU=new Matrix4,scratchToENU=new Matrix4;Transforms.basisTo2D=function(e,t,i){var r=Matrix4.getTranslation(t,scratchCenter),n=e.ellipsoid,a=n.cartesianToCartographic(r,scratchCartographic),a=e.project(a,scratchCartesian3Projection);Cartesian3.fromElements(a.z,a.x,a.y,a);n=Transforms.eastNorthUpToFixedFrame(r,n,scratchFromENU),n=Matrix4.inverseTransformation(n,scratchToENU),t=Matrix4.getMatrix3(t,scratchRotation),t=Matrix4.multiplyByMatrix3(n,t,i);return Matrix4.multiply(swizzleMatrix,t,i),Matrix4.setTranslation(i,a,i),i},Transforms.wgs84To2DModelMatrix=function(e,t,i){var r=e.ellipsoid,n=Transforms.eastNorthUpToFixedFrame(t,r,scratchFromENU),n=Matrix4.inverseTransformation(n,scratchToENU),t=r.cartesianToCartographic(t,scratchCartographic),t=e.project(t,scratchCartesian3Projection);Cartesian3.fromElements(t.z,t.x,t.y,t);t=Matrix4.fromTranslation(t,scratchFromENU);return Matrix4.multiply(swizzleMatrix,n,i),Matrix4.multiply(t,i,i),i};var scratchCart4=new Cartesian4;function EllipsoidTangentPlane(e,t){e=(t=defaultValue(t,Ellipsoid.WGS84)).scaleToGeodeticSurface(e);var i=Transforms.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=Cartesian3.fromCartesian4(Matrix4.getColumn(i,0,scratchCart4)),this._yAxis=Cartesian3.fromCartesian4(Matrix4.getColumn(i,1,scratchCart4));i=Cartesian3.fromCartesian4(Matrix4.getColumn(i,2,scratchCart4));this._plane=Plane.fromPointNormal(e,i)}Object.defineProperties(EllipsoidTangentPlane.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var tmp=new AxisAlignedBoundingBox;EllipsoidTangentPlane.fromPoints=function(e,t){return new EllipsoidTangentPlane(AxisAlignedBoundingBox.fromPoints(e,tmp).center,t)};var scratchProjectPointOntoPlaneRay=new Ray,scratchProjectPointOntoPlaneCartesian3=new Cartesian3;EllipsoidTangentPlane.prototype.projectPointOntoPlane=function(e,t){var i=scratchProjectPointOntoPlaneRay;i.origin=e,Cartesian3.normalize(e,i.direction);e=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3);if(defined(e)||(Cartesian3.negate(i.direction,i.direction),e=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3)),defined(e)){i=Cartesian3.subtract(e,this._origin,e),e=Cartesian3.dot(this._xAxis,i),i=Cartesian3.dot(this._yAxis,i);return defined(t)?(t.x=e,t.y=i,t):new Cartesian2(e,i)}},EllipsoidTangentPlane.prototype.projectPointsOntoPlane=function(e,t){defined(t)||(t=[]);for(var i=0,r=e.length,n=0;n<r;n++){var a=this.projectPointOntoPlane(e[n],t[i]);defined(a)&&(t[i]=a,i++)}return t.length=i,t},EllipsoidTangentPlane.prototype.projectPointToNearestOnPlane=function(e,t){defined(t)||(t=new Cartesian2);var i=scratchProjectPointOntoPlaneRay;i.origin=e,Cartesian3.clone(this._plane.normal,i.direction);e=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3);defined(e)||(Cartesian3.negate(i.direction,i.direction),e=IntersectionTests.rayPlane(i,this._plane,scratchProjectPointOntoPlaneCartesian3));i=Cartesian3.subtract(e,this._origin,e),e=Cartesian3.dot(this._xAxis,i),i=Cartesian3.dot(this._yAxis,i);return t.x=e,t.y=i,t},EllipsoidTangentPlane.prototype.projectPointsToNearestOnPlane=function(e,t){defined(t)||(t=[]);var i=e.length;t.length=i;for(var r=0;r<i;r++)t[r]=this.projectPointToNearestOnPlane(e[r],t[r]);return t};var projectPointsOntoEllipsoidScratch=new Cartesian3;function OrientedBoundingBox(e,t){this.center=Cartesian3.clone(defaultValue(e,Cartesian3.ZERO)),this.halfAxes=Matrix3.clone(defaultValue(t,Matrix3.ZERO))}EllipsoidTangentPlane.prototype.projectPointOntoEllipsoid=function(e,t){defined(t)||(t=new Cartesian3);var i=this._ellipsoid,r=this._origin,n=this._xAxis,a=this._yAxis,o=projectPointsOntoEllipsoidScratch;return Cartesian3.multiplyByScalar(n,e.x,o),t=Cartesian3.add(r,o,t),Cartesian3.multiplyByScalar(a,e.y,o),Cartesian3.add(t,o,t),i.scaleToGeocentricSurface(t,t),t},EllipsoidTangentPlane.prototype.projectPointsOntoEllipsoid=function(e,t){var i=e.length;defined(t)?t.length=i:t=new Array(i);for(var r=0;r<i;++r)t[r]=this.projectPointOntoEllipsoid(e[r],t[r]);return t},OrientedBoundingBox.packedLength=Cartesian3.packedLength+Matrix3.packedLength,OrientedBoundingBox.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e.center,t,i),Matrix3.pack(e.halfAxes,t,i+Cartesian3.packedLength),t},OrientedBoundingBox.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new OrientedBoundingBox),Cartesian3.unpack(e,t,i.center),Matrix3.unpack(e,t+Cartesian3.packedLength,i.halfAxes),i};var scratchCartesian1=new Cartesian3,scratchCartesian2=new Cartesian3,scratchCartesian3$1=new Cartesian3,scratchCartesian4=new Cartesian3,scratchCartesian5=new Cartesian3,scratchCartesian6=new Cartesian3,scratchCovarianceResult=new Matrix3,scratchEigenResult={unitary:new Matrix3,diagonal:new Matrix3};OrientedBoundingBox.fromPoints=function(e,t){if(defined(t)||(t=new OrientedBoundingBox),!defined(e)||0===e.length)return t.halfAxes=Matrix3.ZERO,t.center=Cartesian3.ZERO,t;for(var i=e.length,r=Cartesian3.clone(e[0],scratchCartesian1),n=1;n<i;n++)Cartesian3.add(r,e[n],r);var a=1/i;Cartesian3.multiplyByScalar(r,a,r);var o,s=0,l=0,c=0,u=0,d=0,h=0;for(n=0;n<i;n++)s+=(o=Cartesian3.subtract(e[n],r,scratchCartesian2)).x*o.x,l+=o.x*o.y,c+=o.x*o.z,u+=o.y*o.y,d+=o.y*o.z,h+=o.z*o.z;s*=a,l*=a,c*=a,u*=a,d*=a,h*=a;a=scratchCovarianceResult;a[0]=s,a[1]=l,a[2]=c,a[3]=l,a[4]=u,a[5]=d,a[6]=c,a[7]=d,a[8]=h;var a=Matrix3.computeEigenDecomposition(a,scratchEigenResult),a=Matrix3.clone(a.unitary,t.halfAxes),p=Matrix3.getColumn(a,0,scratchCartesian4),m=Matrix3.getColumn(a,1,scratchCartesian5),f=Matrix3.getColumn(a,2,scratchCartesian6),g=-Number.MAX_VALUE,_=-Number.MAX_VALUE,y=-Number.MAX_VALUE,C=Number.MAX_VALUE,v=Number.MAX_VALUE,S=Number.MAX_VALUE;for(n=0;n<i;n++)o=e[n],g=Math.max(Cartesian3.dot(p,o),g),_=Math.max(Cartesian3.dot(m,o),_),y=Math.max(Cartesian3.dot(f,o),y),C=Math.min(Cartesian3.dot(p,o),C),v=Math.min(Cartesian3.dot(m,o),v),S=Math.min(Cartesian3.dot(f,o),S);p=Cartesian3.multiplyByScalar(p,.5*(C+g),p),m=Cartesian3.multiplyByScalar(m,.5*(v+_),m),f=Cartesian3.multiplyByScalar(f,.5*(S+y),f);a=Cartesian3.add(p,m,t.center);Cartesian3.add(a,f,a);a=scratchCartesian3$1;return a.x=g-C,a.y=_-v,a.z=y-S,Cartesian3.multiplyByScalar(a,.5,a),Matrix3.multiplyByScale(t.halfAxes,a,t.halfAxes),t};var scratchOffset=new Cartesian3,scratchScale$3=new Cartesian3;function fromPlaneExtents(e,t,i,r,n,a,o,s,l,c,u){defined(u)||(u=new OrientedBoundingBox);var d=u.halfAxes;Matrix3.setColumn(d,0,t,d),Matrix3.setColumn(d,1,i,d),Matrix3.setColumn(d,2,r,d),(i=scratchOffset).x=(n+a)/2,i.y=(o+s)/2,i.z=(l+c)/2;r=scratchScale$3;r.x=(a-n)/2,r.y=(s-o)/2,r.z=(c-l)/2;l=u.center,i=Matrix3.multiplyByVector(d,i,i);return Cartesian3.add(e,i,l),Matrix3.multiplyByScale(d,r,d),u}var scratchRectangleCenterCartographic=new Cartographic,scratchRectangleCenter=new Cartesian3,scratchPerimeterCartographicNC=new Cartographic,scratchPerimeterCartographicNW=new Cartographic,scratchPerimeterCartographicCW=new Cartographic,scratchPerimeterCartographicSW=new Cartographic,scratchPerimeterCartographicSC=new Cartographic,scratchPerimeterCartesianNC=new Cartesian3,scratchPerimeterCartesianNW=new Cartesian3,scratchPerimeterCartesianCW=new Cartesian3,scratchPerimeterCartesianSW=new Cartesian3,scratchPerimeterCartesianSC=new Cartesian3,scratchPerimeterProjectedNC=new Cartesian2,scratchPerimeterProjectedNW=new Cartesian2,scratchPerimeterProjectedCW=new Cartesian2,scratchPerimeterProjectedSW=new Cartesian2,scratchPerimeterProjectedSC=new Cartesian2,scratchPlaneOrigin=new Cartesian3,scratchPlaneNormal=new Cartesian3,scratchPlaneXAxis=new Cartesian3,scratchHorizonCartesian=new Cartesian3,scratchHorizonProjected=new Cartesian2,scratchMaxY=new Cartesian3,scratchMinY=new Cartesian3,scratchZ=new Cartesian3,scratchPlane=new Plane(Cartesian3.UNIT_X,0);OrientedBoundingBox.fromRectangle=function(e,t,i,r,n){if(t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,Ellipsoid.WGS84),e.width<=CesiumMath.PI){var a=Rectangle.center(e,scratchRectangleCenterCartographic),o=new EllipsoidTangentPlane(r.cartographicToCartesian(a,scratchRectangleCenter),r),s=o.plane,l=a.longitude,c=e.south<0&&0<e.north?0:a.latitude,u=Cartographic.fromRadians(l,e.north,i,scratchPerimeterCartographicNC),d=Cartographic.fromRadians(e.west,e.north,i,scratchPerimeterCartographicNW),h=Cartographic.fromRadians(e.west,c,i,scratchPerimeterCartographicCW),p=Cartographic.fromRadians(e.west,e.south,i,scratchPerimeterCartographicSW),m=Cartographic.fromRadians(l,e.south,i,scratchPerimeterCartographicSC),f=r.cartographicToCartesian(u,scratchPerimeterCartesianNC),g=r.cartographicToCartesian(d,scratchPerimeterCartesianNW),_=r.cartographicToCartesian(h,scratchPerimeterCartesianCW),y=r.cartographicToCartesian(p,scratchPerimeterCartesianSW),C=r.cartographicToCartesian(m,scratchPerimeterCartesianSC),a=o.projectPointToNearestOnPlane(f,scratchPerimeterProjectedNC),c=o.projectPointToNearestOnPlane(g,scratchPerimeterProjectedNW),l=o.projectPointToNearestOnPlane(_,scratchPerimeterProjectedCW),u=o.projectPointToNearestOnPlane(y,scratchPerimeterProjectedSW),h=o.projectPointToNearestOnPlane(C,scratchPerimeterProjectedSC),f=-(m=Math.min(c.x,l.x,u.x)),_=Math.max(c.y,a.y),C=Math.min(u.y,h.y);return d.height=p.height=t,g=r.cartographicToCartesian(d,scratchPerimeterCartesianNW),y=r.cartographicToCartesian(p,scratchPerimeterCartesianSW),l=Math.min(Plane.getPointDistance(s,g),Plane.getPointDistance(s,y)),c=i,fromPlaneExtents(o.origin,o.xAxis,o.yAxis,o.zAxis,m,f,C,_,l,c,n)}a=0<e.south,u=e.north<0,h=a?e.south:u?e.north:0,d=Rectangle.center(e,scratchRectangleCenterCartographic).longitude,p=Cartesian3.fromRadians(d,h,i,r,scratchPlaneOrigin);p.z=0;g=Math.abs(p.x)<CesiumMath.EPSILON10&&Math.abs(p.y)<CesiumMath.EPSILON10?Cartesian3.UNIT_X:Cartesian3.normalize(p,scratchPlaneNormal),y=Cartesian3.UNIT_Z,o=Cartesian3.cross(g,y,scratchPlaneXAxis);s=Plane.fromPointNormal(p,g,scratchPlane);d=Cartesian3.fromRadians(d+CesiumMath.PI_OVER_TWO,h,i,r,scratchHorizonCartesian);m=-(f=Cartesian3.dot(Plane.projectPointOntoPlane(s,d,scratchHorizonProjected),o)),_=Cartesian3.fromRadians(0,e.north,u?t:i,r,scratchMaxY).z,C=Cartesian3.fromRadians(0,e.south,a?t:i,r,scratchMinY).z;r=Cartesian3.fromRadians(e.east,h,i,r,scratchZ);return fromPlaneExtents(p,o,y,g,m,f,C,_,l=Plane.getPointDistance(s,r),c=0,n)},OrientedBoundingBox.clone=function(e,t){if(defined(e))return defined(t)?(Cartesian3.clone(e.center,t.center),Matrix3.clone(e.halfAxes,t.halfAxes),t):new OrientedBoundingBox(e.center,e.halfAxes)},OrientedBoundingBox.intersectPlane=function(e,t){var i=e.center,r=t.normal,n=e.halfAxes,a=r.x,o=r.y,e=r.z,n=Math.abs(a*n[Matrix3.COLUMN0ROW0]+o*n[Matrix3.COLUMN0ROW1]+e*n[Matrix3.COLUMN0ROW2])+Math.abs(a*n[Matrix3.COLUMN1ROW0]+o*n[Matrix3.COLUMN1ROW1]+e*n[Matrix3.COLUMN1ROW2])+Math.abs(a*n[Matrix3.COLUMN2ROW0]+o*n[Matrix3.COLUMN2ROW1]+e*n[Matrix3.COLUMN2ROW2]),t=Cartesian3.dot(r,i)+t.distance;return t<=-n?Intersect$1.OUTSIDE:n<=t?Intersect$1.INSIDE:Intersect$1.INTERSECTING};var scratchCartesianU=new Cartesian3,scratchCartesianV=new Cartesian3,scratchCartesianW=new Cartesian3,scratchPPrime=new Cartesian3;OrientedBoundingBox.distanceSquaredTo=function(e,t){var i=Cartesian3.subtract(t,e.center,scratchOffset),r=e.halfAxes,n=Matrix3.getColumn(r,0,scratchCartesianU),a=Matrix3.getColumn(r,1,scratchCartesianV),o=Matrix3.getColumn(r,2,scratchCartesianW),s=Cartesian3.magnitude(n),t=Cartesian3.magnitude(a),e=Cartesian3.magnitude(o);Cartesian3.normalize(n,n),Cartesian3.normalize(a,a),Cartesian3.normalize(o,o);r=scratchPPrime;r.x=Cartesian3.dot(i,n),r.y=Cartesian3.dot(i,a),r.z=Cartesian3.dot(i,o);var l,o=0;return r.x<-s?o+=(l=r.x+s)*l:r.x>s&&(o+=(l=r.x-s)*l),r.y<-t?o+=(l=r.y+t)*l:r.y>t&&(o+=(l=r.y-t)*l),r.z<-e?o+=(l=r.z+e)*l:r.z>e&&(o+=(l=r.z-e)*l),o};var scratchCorner=new Cartesian3,scratchToCenter=new Cartesian3;OrientedBoundingBox.computePlaneDistances=function(e,t,i,r){defined(r)||(r=new Interval);var n=Number.POSITIVE_INFINITY,a=Number.NEGATIVE_INFINITY,o=e.center,s=e.halfAxes,l=Matrix3.getColumn(s,0,scratchCartesianU),c=Matrix3.getColumn(s,1,scratchCartesianV),u=Matrix3.getColumn(s,2,scratchCartesianW),d=Cartesian3.add(l,c,scratchCorner);Cartesian3.add(d,u,d),Cartesian3.add(d,o,d);e=Cartesian3.subtract(d,t,scratchToCenter),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a);return Cartesian3.add(o,l,d),Cartesian3.add(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),Cartesian3.add(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),Cartesian3.add(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),Cartesian3.subtract(o,l,d),Cartesian3.add(d,c,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),Cartesian3.subtract(o,l,d),Cartesian3.add(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),Cartesian3.subtract(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.add(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),Cartesian3.subtract(o,l,d),Cartesian3.subtract(d,c,d),Cartesian3.subtract(d,u,d),Cartesian3.subtract(d,t,e),s=Cartesian3.dot(i,e),n=Math.min(s,n),a=Math.max(s,a),r.start=n,r.stop=a,r};var scratchBoundingSphere$1=new BoundingSphere;OrientedBoundingBox.isOccluded=function(e,t){e=BoundingSphere.fromOrientedBoundingBox(e,scratchBoundingSphere$1);return!t.isBoundingSphereVisible(e)},OrientedBoundingBox.prototype.intersectPlane=function(e){return OrientedBoundingBox.intersectPlane(this,e)},OrientedBoundingBox.prototype.distanceSquaredTo=function(e){return OrientedBoundingBox.distanceSquaredTo(this,e)},OrientedBoundingBox.prototype.computePlaneDistances=function(e,t,i){return OrientedBoundingBox.computePlaneDistances(this,e,t,i)},OrientedBoundingBox.prototype.isOccluded=function(e){return OrientedBoundingBox.isOccluded(this,e)},OrientedBoundingBox.equals=function(e,t){return e===t||defined(e)&&defined(t)&&Cartesian3.equals(e.center,t.center)&&Matrix3.equals(e.halfAxes,t.halfAxes)},OrientedBoundingBox.prototype.clone=function(e){return OrientedBoundingBox.clone(this,e)},OrientedBoundingBox.prototype.equals=function(e){return OrientedBoundingBox.equals(this,e)};var RIGHT_SHIFT=1/256,LEFT_SHIFT=256,AttributeCompression={octEncodeInRange:function(e,t,i){var r;return i.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),i.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0&&(r=i.x,e=i.y,i.x=(1-Math.abs(e))*CesiumMath.signNotZero(r),i.y=(1-Math.abs(r))*CesiumMath.signNotZero(e)),i.x=CesiumMath.toSNorm(i.x,t),i.y=CesiumMath.toSNorm(i.y,t),i},octEncode:function(e,t){return AttributeCompression.octEncodeInRange(e,255,t)}},octEncodeScratch=new Cartesian2,uint8ForceArray=new Uint8Array(1);function forceUint8(e){return uint8ForceArray[0]=e,uint8ForceArray[0]}AttributeCompression.octEncodeToCartesian4=function(e,t){return AttributeCompression.octEncodeInRange(e,65535,octEncodeScratch),t.x=forceUint8(octEncodeScratch.x*RIGHT_SHIFT),t.y=forceUint8(octEncodeScratch.x),t.z=forceUint8(octEncodeScratch.y*RIGHT_SHIFT),t.w=forceUint8(octEncodeScratch.y),t},AttributeCompression.octDecodeInRange=function(e,t,i,r){return r.x=CesiumMath.fromSNorm(e,i),r.y=CesiumMath.fromSNorm(t,i),r.z=1-(Math.abs(r.x)+Math.abs(r.y)),r.z<0&&(i=r.x,r.x=(1-Math.abs(r.y))*CesiumMath.signNotZero(i),r.y=(1-Math.abs(i))*CesiumMath.signNotZero(r.y)),Cartesian3.normalize(r,r)},AttributeCompression.octDecode=function(e,t,i){return AttributeCompression.octDecodeInRange(e,t,255,i)},AttributeCompression.octDecodeFromCartesian4=function(e,t){var i=e.x,r=e.y,n=e.z,e=e.w,r=i*LEFT_SHIFT+r,e=n*LEFT_SHIFT+e;return AttributeCompression.octDecodeInRange(r,e,65535,t)},AttributeCompression.octPackFloat=function(e){return 256*e.x+e.y};var scratchEncodeCart2=new Cartesian2;function zigZagDecode(e){return e>>1^-(1&e)}AttributeCompression.octEncodeFloat=function(e){return AttributeCompression.octEncode(e,scratchEncodeCart2),AttributeCompression.octPackFloat(scratchEncodeCart2)},AttributeCompression.octDecodeFloat=function(e,t){var i=e/256,e=Math.floor(i),i=256*(i-e);return AttributeCompression.octDecode(e,i,t)},AttributeCompression.octPack=function(e,t,i,r){e=AttributeCompression.octEncodeFloat(e),t=AttributeCompression.octEncodeFloat(t),i=AttributeCompression.octEncode(i,scratchEncodeCart2);return r.x=65536*i.x+e,r.y=65536*i.y+t,r},AttributeCompression.octUnpack=function(e,t,i,r){var n=e.x/65536,a=Math.floor(n),o=65536*(n-a),n=e.y/65536,e=Math.floor(n),n=65536*(n-e);AttributeCompression.octDecodeFloat(o,t),AttributeCompression.octDecodeFloat(n,i),AttributeCompression.octDecode(a,e,r)},AttributeCompression.compressTextureCoordinates=function(e){return 4096*(4095*e.x|0)+(4095*e.y|0)},AttributeCompression.decompressTextureCoordinates=function(e,t){var i=e/4096,i=Math.floor(i);return t.x=i/4095,t.y=(e-4096*i)/4095,t},AttributeCompression.zigZagDeltaDecode=function(e,t,i){for(var r=e.length,n=0,a=0,o=0,s=0;s<r;++s)n+=zigZagDecode(e[s]),a+=zigZagDecode(t[s]),e[s]=n,t[s]=a,defined(i)&&(o+=zigZagDecode(i[s]),i[s]=o)};var WebGLConstants={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047},WebGLConstants$1=Object.freeze(WebGLConstants),ComponentDatatype={BYTE:WebGLConstants$1.BYTE,UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,SHORT:WebGLConstants$1.SHORT,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,INT:WebGLConstants$1.INT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,FLOAT:WebGLConstants$1.FLOAT,DOUBLE:WebGLConstants$1.DOUBLE,getSizeInBytes:function(e){switch(e){case ComponentDatatype.BYTE:return Int8Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case ComponentDatatype.SHORT:return Int16Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case ComponentDatatype.INT:return Int32Array.BYTES_PER_ELEMENT;case ComponentDatatype.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case ComponentDatatype.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case ComponentDatatype.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}},fromTypedArray:function(e){return e instanceof Int8Array?ComponentDatatype.BYTE:e instanceof Uint8Array?ComponentDatatype.UNSIGNED_BYTE:e instanceof Int16Array?ComponentDatatype.SHORT:e instanceof Uint16Array?ComponentDatatype.UNSIGNED_SHORT:e instanceof Int32Array?ComponentDatatype.INT:e instanceof Uint32Array?ComponentDatatype.UNSIGNED_INT:e instanceof Float32Array?ComponentDatatype.FLOAT:e instanceof Float64Array?ComponentDatatype.DOUBLE:void 0},validate:function(e){return defined(e)&&(e===ComponentDatatype.BYTE||e===ComponentDatatype.UNSIGNED_BYTE||e===ComponentDatatype.SHORT||e===ComponentDatatype.UNSIGNED_SHORT||e===ComponentDatatype.INT||e===ComponentDatatype.UNSIGNED_INT||e===ComponentDatatype.FLOAT||e===ComponentDatatype.DOUBLE)},createTypedArray:function(e,t){switch(e){case ComponentDatatype.BYTE:return new Int8Array(t);case ComponentDatatype.UNSIGNED_BYTE:return new Uint8Array(t);case ComponentDatatype.SHORT:return new Int16Array(t);case ComponentDatatype.UNSIGNED_SHORT:return new Uint16Array(t);case ComponentDatatype.INT:return new Int32Array(t);case ComponentDatatype.UNSIGNED_INT:return new Uint32Array(t);case ComponentDatatype.FLOAT:return new Float32Array(t);case ComponentDatatype.DOUBLE:return new Float64Array(t)}},createArrayBufferView:function(e,t,i,r){switch(i=defaultValue(i,0),r=defaultValue(r,(t.byteLength-i)/ComponentDatatype.getSizeInBytes(e)),e){case ComponentDatatype.BYTE:return new Int8Array(t,i,r);case ComponentDatatype.UNSIGNED_BYTE:return new Uint8Array(t,i,r);case ComponentDatatype.SHORT:return new Int16Array(t,i,r);case ComponentDatatype.UNSIGNED_SHORT:return new Uint16Array(t,i,r);case ComponentDatatype.INT:return new Int32Array(t,i,r);case ComponentDatatype.UNSIGNED_INT:return new Uint32Array(t,i,r);case ComponentDatatype.FLOAT:return new Float32Array(t,i,r);case ComponentDatatype.DOUBLE:return new Float64Array(t,i,r)}},fromName:function(e){switch(e){case"BYTE":return ComponentDatatype.BYTE;case"UNSIGNED_BYTE":return ComponentDatatype.UNSIGNED_BYTE;case"SHORT":return ComponentDatatype.SHORT;case"UNSIGNED_SHORT":return ComponentDatatype.UNSIGNED_SHORT;case"INT":return ComponentDatatype.INT;case"UNSIGNED_INT":return ComponentDatatype.UNSIGNED_INT;case"FLOAT":return ComponentDatatype.FLOAT;case"DOUBLE":return ComponentDatatype.DOUBLE}}},ComponentDatatype$1=Object.freeze(ComponentDatatype),TerrainQuantization={NONE:0,BITS12:1},TerrainQuantization$1=Object.freeze(TerrainQuantization),cartesian3Scratch=new Cartesian3,cartesian3DimScratch=new Cartesian3,cartesian2Scratch=new Cartesian2,matrix4Scratch=new Matrix4,matrix4Scratch2=new Matrix4,SHIFT_LEFT_12=Math.pow(2,12);function TerrainEncoding(e,t,i,r,n,a){var o,s,l,c,u,d=TerrainQuantization$1.NONE;defined(e)&&defined(t)&&defined(i)&&defined(r)&&(c=e.minimum,s=e.maximum,u=Cartesian3.subtract(s,c,cartesian3DimScratch),l=i-t,d=Math.max(Cartesian3.maximumComponent(u),l)<SHIFT_LEFT_12-1?TerrainQuantization$1.BITS12:TerrainQuantization$1.NONE,o=e.center,s=Matrix4.inverseTransformation(r,new Matrix4),l=Cartesian3.negate(c,cartesian3Scratch),Matrix4.multiply(Matrix4.fromTranslation(l,matrix4Scratch),s,s),(l=cartesian3Scratch).x=1/u.x,l.y=1/u.y,l.z=1/u.z,Matrix4.multiply(Matrix4.fromScale(l,matrix4Scratch),s,s),l=Matrix4.clone(r),Matrix4.setTranslation(l,Cartesian3.ZERO,l),r=Matrix4.clone(r,new Matrix4),c=Matrix4.fromTranslation(c,matrix4Scratch),u=Matrix4.fromScale(u,matrix4Scratch2),u=Matrix4.multiply(c,u,matrix4Scratch),Matrix4.multiply(r,u,r),Matrix4.multiply(l,u,l)),this.quantization=d,this.minimumHeight=t,this.maximumHeight=i,this.center=o,this.toScaledENU=s,this.fromScaledENU=r,this.matrix=l,this.hasVertexNormals=n,this.hasWebMercatorT=defaultValue(a,!1)}TerrainEncoding.prototype.encode=function(e,t,i,r,n,a,o){var s,l,c=r.x,u=r.y;return this.quantization===TerrainQuantization$1.BITS12?((i=Matrix4.multiplyByPoint(this.toScaledENU,i,cartesian3Scratch)).x=CesiumMath.clamp(i.x,0,1),i.y=CesiumMath.clamp(i.y,0,1),i.z=CesiumMath.clamp(i.z,0,1),s=this.maximumHeight-this.minimumHeight,l=CesiumMath.clamp((n-this.minimumHeight)/s,0,1),Cartesian2.fromElements(i.x,i.y,cartesian2Scratch),r=AttributeCompression.compressTextureCoordinates(cartesian2Scratch),Cartesian2.fromElements(i.z,l,cartesian2Scratch),s=AttributeCompression.compressTextureCoordinates(cartesian2Scratch),Cartesian2.fromElements(c,u,cartesian2Scratch),l=AttributeCompression.compressTextureCoordinates(cartesian2Scratch),e[t++]=r,e[t++]=s,e[t++]=l,this.hasWebMercatorT&&(Cartesian2.fromElements(o,0,cartesian2Scratch),l=AttributeCompression.compressTextureCoordinates(cartesian2Scratch),e[t++]=l)):(Cartesian3.subtract(i,this.center,cartesian3Scratch),e[t++]=cartesian3Scratch.x,e[t++]=cartesian3Scratch.y,e[t++]=cartesian3Scratch.z,e[t++]=n,e[t++]=c,e[t++]=u,this.hasWebMercatorT&&(e[t++]=o)),this.hasVertexNormals&&(e[t++]=AttributeCompression.octPackFloat(a)),t},TerrainEncoding.prototype.decodePosition=function(e,t,i){if(defined(i)||(i=new Cartesian3),t*=this.getStride(),this.quantization!==TerrainQuantization$1.BITS12)return i.x=e[t],i.y=e[t+1],i.z=e[t+2],Cartesian3.add(i,this.center,i);var r=AttributeCompression.decompressTextureCoordinates(e[t],cartesian2Scratch);i.x=r.x,i.y=r.y;t=AttributeCompression.decompressTextureCoordinates(e[t+1],cartesian2Scratch);return i.z=t.x,Matrix4.multiplyByPoint(this.fromScaledENU,i,i)},TerrainEncoding.prototype.decodeTextureCoordinates=function(e,t,i){return defined(i)||(i=new Cartesian2),t*=this.getStride(),this.quantization===TerrainQuantization$1.BITS12?AttributeCompression.decompressTextureCoordinates(e[t+2],i):Cartesian2.fromElements(e[t+4],e[t+5],i)},TerrainEncoding.prototype.decodeHeight=function(e,t){return t*=this.getStride(),this.quantization!==TerrainQuantization$1.BITS12?e[t+3]:AttributeCompression.decompressTextureCoordinates(e[t+1],cartesian2Scratch).y*(this.maximumHeight-this.minimumHeight)+this.minimumHeight},TerrainEncoding.prototype.decodeWebMercatorT=function(e,t){return t*=this.getStride(),this.quantization===TerrainQuantization$1.BITS12?AttributeCompression.decompressTextureCoordinates(e[t+3],cartesian2Scratch).x:e[t+6]},TerrainEncoding.prototype.getOctEncodedNormal=function(e,t,i){e=e[t=(t+1)*this.getStride()-1]/256,t=Math.floor(e),e=256*(e-t);return Cartesian2.fromElements(t,e,i)},TerrainEncoding.prototype.getStride=function(){var e=this.quantization===TerrainQuantization$1.BITS12?3:6;return this.hasWebMercatorT&&++e,this.hasVertexNormals&&++e,e};var attributesNone={position3DAndHeight:0,textureCoordAndEncodedNormals:1},attributes={compressed0:0,compressed1:1};function WebMercatorProjection(e){this._ellipsoid=defaultValue(e,Ellipsoid.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}TerrainEncoding.prototype.getAttributes=function(e){var t,i=ComponentDatatype$1.FLOAT,r=ComponentDatatype$1.getSizeInBytes(i);if(this.quantization===TerrainQuantization$1.NONE){var n=2;return this.hasWebMercatorT&&++n,this.hasVertexNormals&&++n,t=(4+n)*r,[{index:attributesNone.position3DAndHeight,vertexBuffer:e,componentDatatype:i,componentsPerAttribute:4,offsetInBytes:0,strideInBytes:t},{index:attributesNone.textureCoordAndEncodedNormals,vertexBuffer:e,componentDatatype:i,componentsPerAttribute:n,offsetInBytes:4*r,strideInBytes:t}]}var a=3,n=0;return(this.hasWebMercatorT||this.hasVertexNormals)&&++a,this.hasWebMercatorT&&this.hasVertexNormals?(++n,t=(a+1)*r,[{index:attributes.compressed0,vertexBuffer:e,componentDatatype:i,componentsPerAttribute:a,offsetInBytes:0,strideInBytes:t},{index:attributes.compressed1,vertexBuffer:e,componentDatatype:i,componentsPerAttribute:1,offsetInBytes:a*r,strideInBytes:t}]):[{index:attributes.compressed0,vertexBuffer:e,componentDatatype:i,componentsPerAttribute:a}]},TerrainEncoding.prototype.getAttributeLocations=function(){return this.quantization===TerrainQuantization$1.NONE?attributesNone:attributes},TerrainEncoding.clone=function(e,t){return defined(t)||(t=new TerrainEncoding),t.quantization=e.quantization,t.minimumHeight=e.minimumHeight,t.maximumHeight=e.maximumHeight,t.center=Cartesian3.clone(e.center),t.toScaledENU=Matrix4.clone(e.toScaledENU),t.fromScaledENU=Matrix4.clone(e.fromScaledENU),t.matrix=Matrix4.clone(e.matrix),t.hasVertexNormals=e.hasVertexNormals,t.hasWebMercatorT=e.hasWebMercatorT,t},Object.defineProperties(WebMercatorProjection.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),WebMercatorProjection.mercatorAngleToGeodeticLatitude=function(e){return CesiumMath.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},WebMercatorProjection.geodeticLatitudeToMercatorAngle=function(e){e>WebMercatorProjection.MaximumLatitude?e=WebMercatorProjection.MaximumLatitude:e<-WebMercatorProjection.MaximumLatitude&&(e=-WebMercatorProjection.MaximumLatitude);e=Math.sin(e);return.5*Math.log((1+e)/(1-e))},WebMercatorProjection.MaximumLatitude=WebMercatorProjection.mercatorAngleToGeodeticLatitude(Math.PI),WebMercatorProjection.prototype.project=function(e,t){var i=this._semimajorAxis,r=e.longitude*i,i=WebMercatorProjection.geodeticLatitudeToMercatorAngle(e.latitude)*i,e=e.height;return defined(t)?(t.x=r,t.y=i,t.z=e,t):new Cartesian3(r,i,e)},WebMercatorProjection.prototype.unproject=function(e,t){var i=this._oneOverSemimajorAxis,r=e.x*i,i=WebMercatorProjection.mercatorAngleToGeodeticLatitude(e.y*i),e=e.z;return defined(t)?(t.longitude=r,t.latitude=i,t.height=e,t):new Cartographic(r,i,e)};var HeightmapTessellator={};HeightmapTessellator.DEFAULT_STRUCTURE=Object.freeze({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1});var cartesian3Scratch$1=new Cartesian3,matrix4Scratch$1=new Matrix4,minimumScratch=new Cartesian3,maximumScratch=new Cartesian3;function returnTrue(){return!0}function destroyObject(e,t){function i(){}for(var r in e)"function"==typeof e[r]&&(e[r]=i);e.isDestroyed=returnTrue}function canTransferArrayBuffer(){if(!defined(TaskProcessor._canTransferArrayBuffer)){var t=new Worker(getWorkerUrl("Workers/transferTypedArrayTest.js"));t.postMessage=defaultValue(t.webkitPostMessage,t.postMessage);var e=new Int8Array([99]);try{t.postMessage({array:e},[e.buffer])}catch(e){return TaskProcessor._canTransferArrayBuffer=!1,TaskProcessor._canTransferArrayBuffer}var i=when.defer();t.onmessage=function(e){e=e.data.array,e=defined(e)&&99===e[0];i.resolve(e),t.terminate(),TaskProcessor._canTransferArrayBuffer=e},TaskProcessor._canTransferArrayBuffer=i.promise}return TaskProcessor._canTransferArrayBuffer}HeightmapTessellator.computeVertices=function(e){var t,i,r,n=Math.cos,a=Math.sin,o=Math.sqrt,s=Math.atan,l=Math.exp,c=CesiumMath.PI_OVER_TWO,u=CesiumMath.toRadians,d=e.heightmap,h=e.width,p=e.height,m=e.skirtHeight,f=defaultValue(e.isGeographic,!0),g=defaultValue(e.ellipsoid,Ellipsoid.WGS84),_=1/g.maximumRadius,y=e.nativeRectangle,C=e.rectangle,v=defined(C)?(t=C.west,i=C.south,r=C.east,C.north):f?(t=u(y.west),i=u(y.south),r=u(y.east),u(y.north)):(t=y.west*_,i=c-2*s(l(-y.south*_)),r=y.east*_,c-2*s(l(-y.north*_))),S=defined(T=e.relativeToCenter),T=S?T:Cartesian3.ZERO,x=defaultValue(e.exaggeration,1),b=defaultValue(e.includeWebMercatorT,!1),E=defaultValue(e.structure,HeightmapTessellator.DEFAULT_STRUCTURE),P=defaultValue(E.heightScale,HeightmapTessellator.DEFAULT_STRUCTURE.heightScale),A=defaultValue(E.heightOffset,HeightmapTessellator.DEFAULT_STRUCTURE.heightOffset),w=defaultValue(E.elementsPerHeight,HeightmapTessellator.DEFAULT_STRUCTURE.elementsPerHeight),D=defaultValue(E.stride,HeightmapTessellator.DEFAULT_STRUCTURE.stride),M=defaultValue(E.elementMultiplier,HeightmapTessellator.DEFAULT_STRUCTURE.elementMultiplier),I=defaultValue(E.isBigEndian,HeightmapTessellator.DEFAULT_STRUCTURE.isBigEndian),R=Rectangle.computeWidth(y),O=Rectangle.computeHeight(y),L=R/(h-1),F=O/(p-1);f||(R*=_,O*=_);var N,B,e=g.radiiSquared,V=e.x,k=e.y,z=e.z,U=65536,$=-65536,E=Transforms.eastNorthUpToFixedFrame(T,g),G=Matrix4.inverseTransformation(E,matrix4Scratch$1);b&&(N=WebMercatorProjection.geodeticLatitudeToMercatorAngle(i),B=1/(WebMercatorProjection.geodeticLatitudeToMercatorAngle(v)-N));var H=minimumScratch;H.x=Number.POSITIVE_INFINITY,H.y=Number.POSITIVE_INFINITY,H.z=Number.POSITIVE_INFINITY;var W=maximumScratch;W.x=Number.NEGATIVE_INFINITY,W.y=Number.NEGATIVE_INFINITY,W.z=Number.NEGATIVE_INFINITY;var q=Number.POSITIVE_INFINITY,j=h*p,Y=j+(0<m?2*h+2*p:0),X=new Array(Y),Q=new Array(Y),J=new Array(Y),Z=b?new Array(Y):[],K=0,ee=p,te=0,ie=h;0<m&&(--K,++ee,--te,++ie);for(var re=K;re<ee;++re){var ne=re;ne<0&&(ne=0),p<=ne&&(ne=p-1);var ae=y.north-F*ne,oe=((ae=f?u(ae):c-2*s(l(-ae*_)))-i)/(v-i),oe=CesiumMath.clamp(oe,0,1),se=re===K,le=re===ee-1;0<m&&(se?ae+=1e-5*O:le&&(ae-=1e-5*O));var ce,ue=n(ae),de=a(ae),he=z*de;b&&(ce=(WebMercatorProjection.geodeticLatitudeToMercatorAngle(ae)-N)*B);for(var pe=te;pe<ie;++pe){var me=pe;me<0&&(me=0),h<=me&&(me=h-1);var fe=ne*(h*D)+me*D;if(1===w)_e=d[fe];else{var ge,_e=0;if(I)for(ge=0;ge<w;++ge)_e=_e*M+d[fe+ge];else for(ge=w-1;0<=ge;--ge)_e=_e*M+d[fe+ge]}_e=(_e*P+A)*x,$=Math.max($,_e),U=Math.min(U,_e);var ye=y.west+L*me;f?ye=u(ye):ye*=_;var Ce=(ye-t)/(r-t),Ce=CesiumMath.clamp(Ce,0,1),ve=ne*h+me;if(0<m){var Se=pe===te,Te=pe===ie-1,xe=se||le||Se||Te;if((se||le)&&(Se||Te))continue;xe&&(_e-=m,Se?(ve=p-ne-1+j,ye-=1e-5*R):le?ve=j+p+(h-me-1):Te?(ve=j+p+h+ne,ye+=1e-5*R):se&&(ve=j+p+h+p+me))}var be=ue*n(ye),xe=ue*a(ye),Se=V*be,Te=k*xe,me=1/o(Se*be+Te*xe+he*de),ye=Se*me,Se=Te*me,Te=he*me,me=new Cartesian3;me.x=ye+be*_e,me.y=Se+xe*_e,me.z=Te+de*_e,X[ve]=me,Q[ve]=_e,J[ve]=new Cartesian2(Ce,oe),b&&(Z[ve]=ce),Matrix4.multiplyByPoint(G,me,cartesian3Scratch$1),Cartesian3.minimumByComponent(cartesian3Scratch$1,H,H),Cartesian3.maximumByComponent(cartesian3Scratch$1,W,W),q=Math.min(q,_e)}}var Ee,Pe,e=BoundingSphere.fromPoints(X);defined(C)&&(Ee=OrientedBoundingBox.fromRectangle(C,U,$,g)),S&&(Pe=new EllipsoidalOccluder(g).computeHorizonCullingPointPossiblyUnderEllipsoid(T,X,U));for(var Ae=new TerrainEncoding(new AxisAlignedBoundingBox(H,W,T),q,$,E,!1,b),we=new Float32Array(Y*Ae.getStride()),De=0,Me=0;Me<Y;++Me)De=Ae.encode(we,De,X[Me],J[Me],Q[Me],void 0,Z[Me]);return{vertices:we,maximumHeight:$,minimumHeight:U,encoding:Ae,boundingSphere3D:e,orientedBoundingBox:Ee,occludeePointInScaledSpace:Pe}};var taskCompletedEvent=new Event,bootstrapperUrlResult;function completeTask(e,t){--e._activeTasks;var i,r,n=t.id;defined(n)&&(r=(i=e._deferreds)[n],defined(t.error)?("RuntimeError"===(e=t.error).name?(e=new RuntimeError(t.error.message)).stack=t.error.stack:"DeveloperError"===e.name&&((e=new DeveloperError(t.error.message)).stack=t.error.stack),taskCompletedEvent.raiseEvent(e),r.reject(e)):(taskCompletedEvent.raiseEvent(),r.resolve(t.result)),delete i[n])}function getWorkerUrl(t){if(isCrossOriginUrl(e=buildModuleUrl(t))){var i,r='importScripts("'+e+'");';try{i=new Blob([r],{type:"application/javascript"})}catch(e){t=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder);t.append(r),i=t.getBlob("application/javascript")}var e=(window.URL||window.webkitURL).createObjectURL(i)}return e}function getBootstrapperUrl(){return defined(bootstrapperUrlResult)||(bootstrapperUrlResult=getWorkerUrl("Workers/cesiumWorkerBootstrapper.js")),bootstrapperUrlResult}function createWorker(t){var e=new Worker(getBootstrapperUrl());e.postMessage=defaultValue(e.webkitPostMessage,e.postMessage);var i={loaderConfig:{paths:{Workers:buildModuleUrl("Workers")},baseUrl:buildModuleUrl.getCesiumBaseUrl().url},workerModule:TaskProcessor._workerModulePrefix+t._workerName};return e.postMessage(i),e.onmessage=function(e){completeTask(t,e.data)},e}function getWebAssemblyLoaderConfig(e,t){var i={modulePath:void 0,wasmBinaryFile:void 0,wasmBinary:void 0};if(FeatureDetection.supportsWebAssembly())return i.modulePath=buildModuleUrl(t.modulePath),i.wasmBinaryFile=buildModuleUrl(t.wasmBinaryFile),Resource.fetchArrayBuffer({url:i.wasmBinaryFile}).then(function(e){return i.wasmBinary=e,i});if(!defined(t.fallbackModulePath))throw new RuntimeError("This browser does not support Web Assembly, and no backup module was provided for "+e._workerName);return i.modulePath=buildModuleUrl(t.fallbackModulePath),when.resolve(i)}function TaskProcessor(e,t){this._workerName=e,this._maximumActiveTasks=defaultValue(t,5),this._activeTasks=0,this._deferreds={},this._nextID=0}var emptyTransferableObjectArray=[];function TerrainMesh(e,t,i,r,n,a,o,s,l,c,u,d,h,p,m,f,g){this.center=e,this.vertices=t,this.stride=defaultValue(c,6),this.indices=i,this.indexCountWithoutSkirts=r,this.vertexCountWithoutSkirts=n,this.minimumHeight=a,this.maximumHeight=o,this.boundingSphere3D=s,this.occludeePointInScaledSpace=l,this.orientedBoundingBox=u,this.encoding=d,this.exaggeration=h,this.westIndicesSouthToNorth=p,this.southIndicesEastToWest=m,this.eastIndicesNorthToSouth=f,this.northIndicesWestToEast=g}TaskProcessor.prototype.scheduleTask=function(r,n){if(defined(this._worker)||(this._worker=createWorker(this)),!(this._activeTasks>=this._maximumActiveTasks)){++this._activeTasks;var a=this;return when(canTransferArrayBuffer(),function(e){defined(n)?e||(n.length=0):n=emptyTransferableObjectArray;var t=a._nextID++,i=when.defer();return a._deferreds[t]=i,a._worker.postMessage({id:t,parameters:r,canTransferArrayBuffer:e},n),i.promise})}},TaskProcessor.prototype.initWebAssemblyModule=function(e){defined(this._worker)||(this._worker=createWorker(this));var n=when.defer(),a=this,o=this._worker;return getWebAssemblyLoaderConfig(this,e).then(function(r){return when(canTransferArrayBuffer(),function(e){var t,i=r.wasmBinary;defined(i)&&e&&(t=[i]),o.onmessage=function(e){o.onmessage=function(e){completeTask(a,e.data)},n.resolve(e.data)},o.postMessage({webAssemblyConfig:r},t)})}),n},TaskProcessor.prototype.isDestroyed=function(){return!1},TaskProcessor.prototype.destroy=function(){return defined(this._worker)&&this._worker.terminate(),destroyObject(this)},TaskProcessor.taskCompletedEvent=taskCompletedEvent,TaskProcessor._defaultWorkerModulePrefix="Workers/",TaskProcessor._workerModulePrefix=TaskProcessor._defaultWorkerModulePrefix,TaskProcessor._canTransferArrayBuffer=void 0;var IndexDatatype={UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,getSizeInBytes:function(e){switch(e){case IndexDatatype.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case IndexDatatype.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case IndexDatatype.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},fromSizeInBytes:function(e){switch(e){case 2:return IndexDatatype.UNSIGNED_SHORT;case 4:return IndexDatatype.UNSIGNED_INT;case 1:return IndexDatatype.UNSIGNED_BYTE}},validate:function(e){return defined(e)&&(e===IndexDatatype.UNSIGNED_BYTE||e===IndexDatatype.UNSIGNED_SHORT||e===IndexDatatype.UNSIGNED_INT)},createTypedArray:function(e,t){return new(e>=CesiumMath.SIXTY_FOUR_KILOBYTES?Uint32Array:Uint16Array)(t)},createTypedArrayFromArrayBuffer:function(e,t,i,r){return new(e>=CesiumMath.SIXTY_FOUR_KILOBYTES?Uint32Array:Uint16Array)(t,i,r)}},IndexDatatype$1=Object.freeze(IndexDatatype);function TerrainProvider(){DeveloperError.throwInstantiationError()}Object.defineProperties(TerrainProvider.prototype,{errorEvent:{get:DeveloperError.throwInstantiationError},credit:{get:DeveloperError.throwInstantiationError},tilingScheme:{get:DeveloperError.throwInstantiationError},ready:{get:DeveloperError.throwInstantiationError},readyPromise:{get:DeveloperError.throwInstantiationError},hasWaterMask:{get:DeveloperError.throwInstantiationError},hasVertexNormals:{get:DeveloperError.throwInstantiationError},availability:{get:DeveloperError.throwInstantiationError}});var regularGridIndicesCache=[];TerrainProvider.getRegularGridIndices=function(e,t){var i=regularGridIndicesCache[e];defined(i)||(regularGridIndicesCache[e]=i=[]);var r=i[t];return defined(r)||addRegularGridIndices(e,t,r=e*t<CesiumMath.SIXTY_FOUR_KILOBYTES?i[t]=new Uint16Array((e-1)*(t-1)*6):i[t]=new Uint32Array((e-1)*(t-1)*6),0),r};var regularGridAndEdgeIndicesCache=[];TerrainProvider.getRegularGridIndicesAndEdgeIndices=function(e,t){var i=regularGridAndEdgeIndicesCache[e];defined(i)||(regularGridAndEdgeIndicesCache[e]=i=[]);var r,n,a,o,s=i[t];return defined(s)||(r=TerrainProvider.getRegularGridIndices(e,t),n=(o=getEdgeIndices(e,t)).westIndicesSouthToNorth,a=o.southIndicesEastToWest,e=o.eastIndicesNorthToSouth,o=o.northIndicesWestToEast,s=i[t]={indices:r,westIndicesSouthToNorth:n,southIndicesEastToWest:a,eastIndicesNorthToSouth:e,northIndicesWestToEast:o}),s};var regularGridAndSkirtAndEdgeIndicesCache=[];function getEdgeIndices(e,t){for(var i=new Array(t),r=new Array(e),n=new Array(t),a=new Array(e),o=0;o<e;++o)r[a[o]=o]=e*t-1-o;for(o=0;o<t;++o)n[o]=(o+1)*e-1,i[o]=(t-o-1)*e;return{westIndicesSouthToNorth:i,southIndicesEastToWest:r,eastIndicesNorthToSouth:n,northIndicesWestToEast:a}}function addRegularGridIndices(e,t,i,r){for(var n=0,a=0;a<t-1;++a){for(var o=0;o<e-1;++o){var s=n+e,l=s+1,c=n+1;i[r++]=n,i[r++]=s,i[r++]=c,i[r++]=c,i[r++]=s,i[r++]=l,++n}++n}}function addSkirtIndices(e,t,i,r){for(var n=e[0],a=e.length,o=1;o<a;++o){var s=e[o];i[r++]=n,i[r++]=s,i[r++]=t,i[r++]=t,i[r++]=s,i[r++]=t+1,n=s,++t}return r}function HeightmapTerrainData(e){this._buffer=e.buffer,this._width=e.width,this._height=e.height,this._childTileMask=defaultValue(e.childTileMask,15),this._encoding=defaultValue(e.encoding,HeightmapEncoding$1.NONE);var t=HeightmapTessellator.DEFAULT_STRUCTURE,i=e.structure;defined(i)?i!==t&&(i.heightScale=defaultValue(i.heightScale,t.heightScale),i.heightOffset=defaultValue(i.heightOffset,t.heightOffset),i.elementsPerHeight=defaultValue(i.elementsPerHeight,t.elementsPerHeight),i.stride=defaultValue(i.stride,t.stride),i.elementMultiplier=defaultValue(i.elementMultiplier,t.elementMultiplier),i.isBigEndian=defaultValue(i.isBigEndian,t.isBigEndian)):i=t,this._structure=i,this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._waterMask=e.waterMask,this._skirtHeight=void 0,this._bufferType=this._encoding===HeightmapEncoding$1.LERC?Float32Array:this._buffer.constructor,this._mesh=void 0}TerrainProvider.getRegularGridAndSkirtIndicesAndEdgeIndices=function(e,t){var i=regularGridAndSkirtAndEdgeIndicesCache[e];defined(i)||(regularGridAndSkirtAndEdgeIndicesCache[e]=i=[]);var r,n,a,o,s,l,c,u,d=i[t];return defined(d)||(a=(r=e*t)+(l=2*e+2*t),u=(n=(e-1)*(t-1)*6)+6*Math.max(0,l-4),o=(c=getEdgeIndices(e,t)).westIndicesSouthToNorth,s=c.southIndicesEastToWest,l=c.eastIndicesNorthToSouth,c=c.northIndicesWestToEast,addRegularGridIndices(e,t,u=IndexDatatype$1.createTypedArray(a,u),0),TerrainProvider.addSkirtIndices(o,s,l,c,r,u,n),d=i[t]={indices:u,westIndicesSouthToNorth:o,southIndicesEastToWest:s,eastIndicesNorthToSouth:l,northIndicesWestToEast:c,indexCountWithoutSkirts:n}),d},TerrainProvider.addSkirtIndices=function(e,t,i,r,n,a,o){o=addSkirtIndices(e,n,a,o),o=addSkirtIndices(t,n+=e.length,a,o),o=addSkirtIndices(i,n+=t.length,a,o),addSkirtIndices(r,n+=i.length,a,o)},TerrainProvider.heightmapTerrainQuality=.25,TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap=function(e,t,i){return 2*e.maximumRadius*Math.PI*TerrainProvider.heightmapTerrainQuality/(t*i)},TerrainProvider.prototype.requestTileGeometry=DeveloperError.throwInstantiationError,TerrainProvider.prototype.getLevelMaximumGeometricError=DeveloperError.throwInstantiationError,TerrainProvider.prototype.getTileDataAvailable=DeveloperError.throwInstantiationError,TerrainProvider.prototype.loadTileDataAvailability=DeveloperError.throwInstantiationError,Object.defineProperties(HeightmapTerrainData.prototype,{credits:{get:function(){}},waterMask:{get:function(){return this._waterMask}},childTileMask:{get:function(){return this._childTileMask}}});var taskProcessor=new TaskProcessor("createVerticesFromHeightmap");function interpolateHeight(e,t,i,r,n,a,o,s,l,c){var u=(l-a.west)*(o-1)/(a.east-a.west),d=(c-a.south)*(s-1)/(a.north-a.south),h=0|u,l=h+1;o<=l&&(l=o-1,h=o-2);c=0|d;s<=(a=c+1)&&(a=s-1,c=s-2);a=s-1-a;return triangleInterpolateHeight(u-h,d-c,getHeight(e,t,i,r,n,(c=s-1-c)*o+h),getHeight(e,t,i,r,n,c*o+l),getHeight(e,t,i,r,n,a*o+h),getHeight(e,t,i,r,n,a*o+l))}function interpolateMeshHeight(e,t,i,r,n,a,o,s,l,c){var u=(s-n.west)*(a-1)/(n.east-n.west),d=(l-n.south)*(o-1)/(n.north-n.south),h=0|u,s=h+1;a<=s&&(s=a-1,h=a-2),o<=(n=(l=0|d)+1)&&(n=o-1,l=o-2);d-=l,l=o-1-l,n=o-1-n;return triangleInterpolateHeight(u-h,d,(t.decodeHeight(e,l*a+h)/c-i)/r,(t.decodeHeight(e,l*a+s)/c-i)/r,(t.decodeHeight(e,n*a+h)/c-i)/r,(t.decodeHeight(e,n*a+s)/c-i)/r)}function triangleInterpolateHeight(e,t,i,r,n,a){return t<e?i+e*(r-i)+t*(a-r):i+e*(a-n)+t*(n-i)}function getHeight(e,t,i,r,n,a){a*=r;var o,s=0;if(n)for(o=0;o<t;++o)s=s*i+e[a+o];else for(o=t-1;0<=o;--o)s=s*i+e[a+o];return s}function setHeight(e,t,i,r,n,a,o,s){var l;if(o*=n,a)for(l=0;l<t-1;++l)e[o+l]=s/r|0,s-=e[o+l]*r,r/=i;else for(l=t-1;0<l;--l)e[o+l]=s/r|0,s-=e[o+l]*r,r/=i;e[o+l]=s}function TileAvailability(e,t){this._tilingScheme=e,this._maximumLevel=t,this._rootNodes=[]}HeightmapTerrainData.prototype.createMesh=function(e,t,i,r,n){var a=e.ellipsoid,o=e.tileXYToNativeRectangle(t,i,r),t=e.tileXYToRectangle(t,i,r);n=defaultValue(n,1);var s=a.cartographicToCartesian(Rectangle.center(t)),i=this._structure,r=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(a,this._width,e.getNumberOfXTilesAtLevel(0))/(1<<r);this._skirtHeight=Math.min(4*r,1e3);e=taskProcessor.scheduleTask({heightmap:this._buffer,structure:i,includeWebMercatorT:!0,width:this._width,height:this._height,nativeRectangle:o,rectangle:t,relativeToCenter:s,ellipsoid:a,skirtHeight:this._skirtHeight,isGeographic:e.projection instanceof GeographicProjection,exaggeration:n,encoding:this._encoding});if(defined(e)){var l=this;return when(e,function(e){var t=0<l._skirtHeight?TerrainProvider.getRegularGridAndSkirtIndicesAndEdgeIndices(e.gridWidth,e.gridHeight):TerrainProvider.getRegularGridIndicesAndEdgeIndices(e.gridWidth,e.gridHeight),i=e.gridWidth*e.gridHeight;return l._mesh=new TerrainMesh(s,new Float32Array(e.vertices),t.indices,t.indexCountWithoutSkirts,i,e.minimumHeight,e.maximumHeight,BoundingSphere.clone(e.boundingSphere3D),Cartesian3.clone(e.occludeePointInScaledSpace),e.numberOfAttributes,OrientedBoundingBox.clone(e.orientedBoundingBox),TerrainEncoding.clone(e.encoding),n,t.westIndicesSouthToNorth,t.southIndicesEastToWest,t.eastIndicesNorthToSouth,t.northIndicesWestToEast),l._buffer=void 0,l._mesh})}},HeightmapTerrainData.prototype._createMeshSync=function(e,t,i,r,n){var a=e.ellipsoid,o=e.tileXYToNativeRectangle(t,i,r),s=e.tileXYToRectangle(t,i,r);n=defaultValue(n,1);t=a.cartographicToCartesian(Rectangle.center(s)),i=this._structure,r=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(a,this._width,e.getNumberOfXTilesAtLevel(0))/(1<<r);this._skirtHeight=Math.min(4*r,1e3);s=HeightmapTessellator.computeVertices({heightmap:this._buffer,structure:i,includeWebMercatorT:!0,width:this._width,height:this._height,nativeRectangle:o,rectangle:s,relativeToCenter:t,ellipsoid:a,skirtHeight:this._skirtHeight,isGeographic:e.projection instanceof GeographicProjection,exaggeration:n});this._buffer=void 0,a=0<this._skirtHeight?TerrainProvider.getRegularGridAndSkirtIndicesAndEdgeIndices(this._width,this._height):TerrainProvider.getRegularGridIndicesAndEdgeIndices(this._width,this._height);e=s.gridWidth*s.gridHeight;return new TerrainMesh(t,s.vertices,a.indices,a.indexCountWithoutSkirts,e,s.minimumHeight,s.maximumHeight,s.boundingSphere3D,s.occludeePointInScaledSpace,s.encoding.getStride(),s.orientedBoundingBox,s.encoding,n,a.westIndicesSouthToNorth,a.southIndicesEastToWest,a.eastIndicesNorthToSouth,a.northIndicesWestToEast)},HeightmapTerrainData.prototype.interpolateHeight=function(e,t,i){var r=this._width,n=this._height,a=this._structure,o=a.stride,s=a.elementsPerHeight,l=a.elementMultiplier,c=a.isBigEndian,u=a.heightOffset,a=a.heightScale;return defined(this._mesh)?interpolateMeshHeight(this._mesh.vertices,this._mesh.encoding,u,a,e,r,n,t,i,this._mesh.exaggeration):interpolateHeight(this._buffer,s,l,o,c,e,r,n,t,i)*a+u},HeightmapTerrainData.prototype.upsample=function(e,t,i,r,n,a,o){var s=this._mesh;if(defined(s)){for(var l=this._width,c=this._height,u=this._structure,d=u.stride,h=new this._bufferType(l*c*d),p=s.vertices,m=s.encoding,f=e.tileXYToRectangle(t,i,r),g=e.tileXYToRectangle(n,a,o),_=u.heightOffset,y=u.heightScale,C=s.exaggeration,v=u.elementsPerHeight,S=u.elementMultiplier,T=u.isBigEndian,x=Math.pow(S,v-1),b=0;b<c;++b)for(var E=CesiumMath.lerp(g.north,g.south,b/(c-1)),P=0;P<l;++P){var A=interpolateMeshHeight(p,m,_,y,f,l,c,CesiumMath.lerp(g.west,g.east,P/(l-1)),E,C);setHeight(h,v,S,x,d,T,b*l+P,A=(A=A<u.lowestEncodedHeight?u.lowestEncodedHeight:A)>u.highestEncodedHeight?u.highestEncodedHeight:A)}return new HeightmapTerrainData({buffer:h,width:l,height:c,childTileMask:0,structure:this._structure,createdByUpsampling:!0})}},HeightmapTerrainData.prototype.isChildAvailable=function(e,t,i,r){var n=2;return i!==2*e&&++n,r!==2*t&&(n-=2),0!=(this._childTileMask&1<<n)},HeightmapTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};var rectangleScratch=new Rectangle;function findNode(e,t,i,r){for(var n=r.length,a=0;a<n;++a){var o=r[a];if(o.x===t&&o.y===i&&o.level===e)return 1}}TileAvailability.prototype.addAvailableTileRange=function(e,t,i,r,n){var a=this._tilingScheme,o=this._rootNodes;if(0===e)for(var s=i;s<=n;++s)for(var l=t;l<=r;++l)findNode(e,l,s,o)||o.push(new QuadtreeNode(a,void 0,0,l,s));a.tileXYToRectangle(t,i,e,rectangleScratch);var c=rectangleScratch.west,u=rectangleScratch.north;a.tileXYToRectangle(r,n,e,rectangleScratch);for(var i=rectangleScratch.east,d=new RectangleWithLevel(e,c,rectangleScratch.south,i,u),h=0;h<o.length;++h){var p=o[h];rectanglesOverlap(p.extent,d)&&putRectangleInQuadtree(this._maximumLevel,p,d)}},TileAvailability.prototype.computeMaximumLevelAtPosition=function(e){for(var t,i=0;i<this._rootNodes.length;++i){var r=this._rootNodes[i];if(rectangleContainsPosition(r.extent,e)){t=r;break}}return defined(t)?findMaxLevelFromNode(void 0,t,e):-1};var rectanglesScratch=[],remainingToCoverByLevelScratch=[],westScratch=new Rectangle,eastScratch=new Rectangle;TileAvailability.prototype.computeBestAvailableLevelOverRectangle=function(e){var t=rectanglesScratch;t.length=0,e.east<e.west?(t.push(Rectangle.fromRadians(-Math.PI,e.south,e.east,e.north,westScratch)),t.push(Rectangle.fromRadians(e.west,e.south,Math.PI,e.north,eastScratch))):t.push(e);for(var i=remainingToCoverByLevelScratch,r=i.length=0;r<this._rootNodes.length;++r)updateCoverageWithNode(i,this._rootNodes[r],t);for(r=i.length-1;0<=r;--r)if(defined(i[r])&&0===i[r].length)return r;return 0};var cartographicScratch=new Cartographic;function QuadtreeNode(e,t,i,r,n){this.tilingScheme=e,this.parent=t,this.level=i,this.x=r,this.y=n,this.extent=e.tileXYToRectangle(r,n,i),this.rectangles=[],this._sw=void 0,this._se=void 0,this._nw=void 0,this._ne=void 0}function RectangleWithLevel(e,t,i,r,n){this.level=e,this.west=t,this.south=i,this.east=r,this.north=n}function rectanglesOverlap(e,t){var i=Math.max(e.west,t.west),r=Math.max(e.south,t.south),n=Math.min(e.east,t.east);return r<Math.min(e.north,t.north)&&i<n}function putRectangleInQuadtree(e,t,i){for(;t.level<e;)if(rectangleFullyContainsRectangle(t.nw.extent,i))t=t.nw;else if(rectangleFullyContainsRectangle(t.ne.extent,i))t=t.ne;else if(rectangleFullyContainsRectangle(t.sw.extent,i))t=t.sw;else{if(!rectangleFullyContainsRectangle(t.se.extent,i))break;t=t.se}var r;0===t.rectangles.length||t.rectangles[t.rectangles.length-1].level<=i.level?t.rectangles.push(i):((r=binarySearch(t.rectangles,i.level,rectangleLevelComparator))<0&&(r=~r),t.rectangles.splice(r,0,i))}function rectangleLevelComparator(e,t){return e.level-t}function rectangleFullyContainsRectangle(e,t){return t.west>=e.west&&t.east<=e.east&&t.south>=e.south&&t.north<=e.north}function rectangleContainsPosition(e,t){return t.longitude>=e.west&&t.longitude<=e.east&&t.latitude>=e.south&&t.latitude<=e.north}function findMaxLevelFromNode(e,t,i){for(var r=0,n=!1;!n;){var a=t._nw&&rectangleContainsPosition(t._nw.extent,i),o=t._ne&&rectangleContainsPosition(t._ne.extent,i),s=t._sw&&rectangleContainsPosition(t._sw.extent,i),l=t._se&&rectangleContainsPosition(t._se.extent,i);if(1<a+o+s+l){a&&(r=Math.max(r,findMaxLevelFromNode(t,t._nw,i))),o&&(r=Math.max(r,findMaxLevelFromNode(t,t._ne,i))),s&&(r=Math.max(r,findMaxLevelFromNode(t,t._sw,i))),l&&(r=Math.max(r,findMaxLevelFromNode(t,t._se,i)));break}a?t=t._nw:o?t=t._ne:s?t=t._sw:l?t=t._se:n=!0}for(;t!==e;){for(var c=t.rectangles,u=c.length-1;0<=u&&c[u].level>r;--u){var d=c[u];rectangleContainsPosition(d,i)&&(r=d.level)}t=t.parent}return r}function updateCoverageWithNode(e,t,i){if(t){var r=!1;for(a=0;a<i.length;++a)r=r||rectanglesOverlap(t.extent,i[a]);if(r){for(var n=t.rectangles,a=0;a<n.length;++a){var o=n[a];e[o.level]||(e[o.level]=i),e[o.level]=subtractRectangle(e[o.level],o)}updateCoverageWithNode(e,t._nw,i),updateCoverageWithNode(e,t._ne,i),updateCoverageWithNode(e,t._sw,i),updateCoverageWithNode(e,t._se,i)}}}function subtractRectangle(e,t){for(var i=[],r=0;r<e.length;++r){var n=e[r];rectanglesOverlap(n,t)?(n.west<t.west&&i.push(new Rectangle(n.west,n.south,t.west,n.north)),n.east>t.east&&i.push(new Rectangle(t.east,n.south,n.east,n.north)),n.south<t.south&&i.push(new Rectangle(Math.max(t.west,n.west),n.south,Math.min(t.east,n.east),t.south)),n.north>t.north&&i.push(new Rectangle(Math.max(t.west,n.west),t.north,Math.min(t.east,n.east),n.north))):i.push(n)}return i}function formatError(e){var t=e.name,i=e.message,i=defined(t)&&defined(i)?t+": "+i:e.toString(),e=e.stack;return defined(e)&&(i+="\n"+e),i}function TileProviderError(e,t,i,r,n,a,o){this.provider=e,this.message=t,this.x=i,this.y=r,this.level=n,this.timesRetried=defaultValue(a,0),this.retry=!1,this.error=o}function WebMercatorTilingScheme(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._numberOfLevelZeroTilesX=defaultValue(e.numberOfLevelZeroTilesX,1),this._numberOfLevelZeroTilesY=defaultValue(e.numberOfLevelZeroTilesY,1),this._projection=new WebMercatorProjection(this._ellipsoid),defined(e.rectangleSouthwestInMeters)&&defined(e.rectangleNortheastInMeters)?(this._rectangleSouthwestInMeters=e.rectangleSouthwestInMeters,this._rectangleNortheastInMeters=e.rectangleNortheastInMeters):(t=this._ellipsoid.maximumRadius*Math.PI,this._rectangleSouthwestInMeters=new Cartesian2(-t,-t),this._rectangleNortheastInMeters=new Cartesian2(t,t));var e=this._projection.unproject(this._rectangleSouthwestInMeters),t=this._projection.unproject(this._rectangleNortheastInMeters);this._rectangle=new Rectangle(e.longitude,e.latitude,t.longitude,t.latitude)}TileAvailability.prototype.isTileAvailable=function(e,t,i){i=this._tilingScheme.tileXYToRectangle(t,i,e,rectangleScratch);return Rectangle.center(i,cartographicScratch),this.computeMaximumLevelAtPosition(cartographicScratch)>=e},TileAvailability.prototype.computeChildMaskForTile=function(e,t,i){var r=e+1;if(r>=this._maximumLevel)return 0;e=0;return e|=this.isTileAvailable(r,2*t,2*i+1)?1:0,e|=this.isTileAvailable(r,2*t+1,2*i+1)?2:0,e|=this.isTileAvailable(r,2*t,2*i)?4:0,e|=this.isTileAvailable(r,2*t+1,2*i)?8:0},Object.defineProperties(QuadtreeNode.prototype,{nw:{get:function(){return this._nw||(this._nw=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x,2*this.y)),this._nw}},ne:{get:function(){return this._ne||(this._ne=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x+1,2*this.y)),this._ne}},sw:{get:function(){return this._sw||(this._sw=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x,2*this.y+1)),this._sw}},se:{get:function(){return this._se||(this._se=new QuadtreeNode(this.tilingScheme,this,this.level+1,2*this.x+1,2*this.y+1)),this._se}}}),TileProviderError.handleError=function(e,t,i,r,n,a,o,s,l){var c=e;return defined(e)?(c.provider=t,c.message=r,c.x=n,c.y=a,c.level=o,c.retry=!1,c.error=l,++c.timesRetried):c=new TileProviderError(t,r,n,a,o,0,l),0<i.numberOfListeners?i.raiseEvent(c):console.log('An error occurred in "'+t.constructor.name+'": '+formatError(r)),c.retry&&defined(s)&&s(),c},TileProviderError.handleSuccess=function(e){defined(e)&&(e.timesRetried=-1)},Object.defineProperties(WebMercatorTilingScheme.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),WebMercatorTilingScheme.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},WebMercatorTilingScheme.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},WebMercatorTilingScheme.prototype.rectangleToNativeRectangle=function(e,t){var i=this._projection,r=i.project(Rectangle.southwest(e)),e=i.project(Rectangle.northeast(e));return defined(t)?(t.west=r.x,t.south=r.y,t.east=e.x,t.north=e.y,t):new Rectangle(r.x,r.y,e.x,e.y)},WebMercatorTilingScheme.prototype.tileXYToNativeRectangle=function(e,t,i,r){var n=this.getNumberOfXTilesAtLevel(i),a=this.getNumberOfYTilesAtLevel(i),i=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/n,n=this._rectangleSouthwestInMeters.x+e*i,e=this._rectangleSouthwestInMeters.x+(e+1)*i,i=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/a,a=this._rectangleNortheastInMeters.y-t*i,i=this._rectangleNortheastInMeters.y-(t+1)*i;return defined(r)?(r.west=n,r.south=i,r.east=e,r.north=a,r):new Rectangle(n,i,e,a)},WebMercatorTilingScheme.prototype.tileXYToRectangle=function(e,t,i,r){t=this.tileXYToNativeRectangle(e,t,i,r),i=this._projection,r=i.unproject(new Cartesian2(t.west,t.south)),i=i.unproject(new Cartesian2(t.east,t.north));return t.west=r.longitude,t.south=r.latitude,t.east=i.longitude,t.north=i.latitude,t},WebMercatorTilingScheme.prototype.positionToTileXY=function(e,t,i){var r=this._rectangle;if(Rectangle.contains(r,e)){var n=this.getNumberOfXTilesAtLevel(t),a=this.getNumberOfYTilesAtLevel(t),r=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/n,t=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/a,e=this._projection.project(e),r=(e.x-this._rectangleSouthwestInMeters.x)/r|0;n<=r&&(r=n-1);t=(this._rectangleNortheastInMeters.y-e.y)/t|0;return(a<=t&&(t=a-1),defined(i))?(i.x=r,i.y=t,i):new Cartesian2(r,t)}};var ALL_CHILDREN=15;function ArcGISTiledElevationTerrainProvider(e){this._resource=void 0,this._credit=void 0,this._tilingScheme=void 0,this._levelZeroMaximumGeometricError=void 0,this._maxLevel=void 0,this._terrainDataStructure=void 0,this._ready=!1,this._width=void 0,this._height=void 0,this._encoding=void 0;var t=e.token;this._hasAvailability=!1,this._tilesAvailable=void 0,this._tilesAvailablityLoaded=void 0,this._availableCache={};var n=this,a=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._readyPromise=when(e.url).then(function(e){e=Resource.createIfNeeded(e);return e.appendForwardSlash(),defined(t)&&(e=e.getDerivedResource({queryParameters:{token:t}})),(n._resource=e).getDerivedResource({queryParameters:{f:"pjson"}}).fetchJson()}).then(function(e){var t=e.copyrightText;defined(t)&&(n._credit=new Credit(t));var i=e.spatialReference,r=defaultValue(i.latestWkid,i.wkid),t=e.extent,i={ellipsoid:a};if(4326===r)i.rectangle=Rectangle.fromDegrees(t.xmin,t.ymin,t.xmax,t.ymax),n._tilingScheme=new GeographicTilingScheme(i);else{if(3857!==r)return when.reject(new RuntimeError("Invalid spatial reference"));i.rectangleSouthwestInMeters=new Cartesian2(t.xmin,t.ymin),i.rectangleNortheastInMeters=new Cartesian2(t.xmax,t.ymax),n._tilingScheme=new WebMercatorTilingScheme(i)}i=e.tileInfo;return defined(i)?(n._width=i.rows+1,n._height=i.cols+1,n._encoding="LERC"===i.format?HeightmapEncoding$1.LERC:HeightmapEncoding$1.NONE,n._lodCount=i.lods.length-1,(n._hasAvailability=-1!==e.capabilities.indexOf("Tilemap"))&&(n._tilesAvailable=new TileAvailability(n._tilingScheme,n._lodCount),n._tilesAvailable.addAvailableTileRange(0,0,0,n._tilingScheme.getNumberOfXTilesAtLevel(0),n._tilingScheme.getNumberOfYTilesAtLevel(0)),n._tilesAvailablityLoaded=new TileAvailability(n._tilingScheme,n._lodCount)),n._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(n._tilingScheme.ellipsoid,n._width,n._tilingScheme.getNumberOfXTilesAtLevel(0)),1<e.bandCount&&console.log("ArcGISTiledElevationTerrainProvider: Terrain data has more than 1 band. Using the first one."),n._terrainDataStructure={elementMultiplier:1,lowestEncodedHeight:e.minValues[0],highestEncodedHeight:e.maxValues[0]},n._ready=!0):when.reject(new RuntimeError("tileInfo is required"))}).otherwise(function(e){var t="An error occurred while accessing "+n._resource.url+".";return TileProviderError.handleError(void 0,n,n._errorEvent,t),when.reject(e)}),this._errorEvent=new Event}function isTileAvailable(e,t,i,r){if(e._hasAvailability){var n=e._tilesAvailablityLoaded,a=e._tilesAvailable;return!(t>e._lodCount)&&(!!a.isTileAvailable(t,i,r)||!n.isTileAvailable(t,i,r)&&void 0)}}function findRange(e,t,i,r){for(var n=t-1,a=i-1,o=r[e.y*t+e.x],s=[],l={startX:e.x,startY:e.y,endX:0,endY:0},c=new Cartesian2(e.x+1,e.y+1),u=!1,d=!1;!u||!d;){var h=c.x,p=d?c.y+1:c.y;if(!u){for(var m=e.y;m<p;++m)if(r[m*t+c.x]!==o){u=!0;break}u?(s.push(new Cartesian2(c.x,e.y)),--c.x,--h,l.endX=c.x):c.x===n?(l.endX=c.x,u=!0):++c.x}if(!d){for(var f=c.y*t,g=e.x;g<=h;++g)if(r[f+g]!==o){d=!0;break}d?(s.push(new Cartesian2(e.x,c.y)),--c.y,l.endY=c.y):c.y===a?(l.endY=c.y,d=!0):++c.y}}return{endingIndices:s,range:l,value:o}}function computeAvailability(e,t,i,r,n){var a=[];if(n.every(function(e){return e===n[0]}))return 1===n[0]&&a.push({startX:e,startY:t,endX:e+i-1,endY:t+r-1}),a;for(var o=[new Cartesian2(0,0)];0<o.length;){var s,l=findRange(o.pop(),i,r,n);1===l.value&&((s=l.range).startX+=e,s.endX+=e,s.startY+=t,s.endY+=t,a.push(s));l=l.endingIndices;0<l.length&&(o=o.concat(l))}return a}function requestAvailability(a,o,s,l){if(!a._hasAvailability)return{};var c=128*Math.floor(s/128),u=128*Math.floor(l/128),d=Math.min(1<<o,128),t="tilemap/"+o+"/"+u+"/"+c+"/"+d+"/"+d,i=a._availableCache;if(defined(i[t]))return i[t];var e=new Request({throttle:!1,throttleByServer:!0,type:RequestType$1.TERRAIN}),r=a._resource.getDerivedResource({url:t,request:e}).fetchJson();return defined(r)?(r=r.then(function(e){var t=computeAvailability(c,u,d,d,e.data);a._tilesAvailablityLoaded.addAvailableTileRange(c,u,c+d,u+d);for(var i=a._tilesAvailable,r=0;r<t.length;++r){var n=t[r];i.addAvailableTileRange(o,n.startX,n.startY,n.endX,n.endY)}return isTileAvailable(a,o,s,l)}),i[t]={promise:r,request:e},{promise:r=r.always(function(e){return delete i[t],e}),request:e}):{}}Object.defineProperties(ArcGISTiledElevationTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}}),ArcGISTiledElevationTerrainProvider.prototype.requestTileGeometry=function(t,i,r,n){var e,a,o=this._resource.getDerivedResource({url:"tile/"+r+"/"+i+"/"+t,request:n}),s=this._hasAvailability,l=when.resolve(!0);s&&!defined(isTileAvailable(this,r+1,2*t,2*i))&&(l=(e=requestAvailability(this,r+1,2*t,2*i)).promise,a=e.request);o=o.fetchArrayBuffer();if(defined(o)&&defined(l)){var c=this,u=this._tilesAvailable;return when.join(o,l).then(function(e){return new HeightmapTerrainData({buffer:e[0],width:c._width,height:c._height,childTileMask:s?u.computeChildMaskForTile(r,t,i):ALL_CHILDREN,structure:c._terrainDataStructure,encoding:c._encoding})}).otherwise(function(e){return defined(a)&&a.state===RequestState$1.CANCELLED?(n.cancel(),n.deferred.promise.always(function(){return n.state=RequestState$1.CANCELLED,when.reject(e)})):when.reject(e)})}},ArcGISTiledElevationTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},ArcGISTiledElevationTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){if(this._hasAvailability){var r=isTileAvailable(this,i,e,t);if(defined(r))return r;requestAvailability(this,i,e,t)}},ArcGISTiledElevationTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){};var ArcType={NONE:0,GEODESIC:1,RHUMB:2},ArcType$1=Object.freeze(ArcType);function AssociativeArray(){this._array=[],this._hash={}}Object.defineProperties(AssociativeArray.prototype,{length:{get:function(){return this._array.length}},values:{get:function(){return this._array}}}),AssociativeArray.prototype.contains=function(e){return defined(this._hash[e])},AssociativeArray.prototype.set=function(e,t){t!==this._hash[e]&&(this.remove(e),this._hash[e]=t,this._array.push(t))},AssociativeArray.prototype.get=function(e){return this._hash[e]},AssociativeArray.prototype.remove=function(e){var t,i=this._hash[e],r=defined(i);return r&&((t=this._array).splice(t.indexOf(i),1),delete this._hash[e]),r},AssociativeArray.prototype.removeAll=function(){var e=this._array;0<e.length&&(this._hash={},e.length=0)};var url="https://dev.virtualearth.net/REST/v1/Locations";function BingMapsGeocoderService(e){e=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).key;this._key=e,this._resource=new Resource({url:url,queryParameters:{key:e}})}function BoundingRectangle(e,t,i,r){this.x=defaultValue(e,0),this.y=defaultValue(t,0),this.width=defaultValue(i,0),this.height=defaultValue(r,0)}Object.defineProperties(BingMapsGeocoderService.prototype,{url:{get:function(){return url}},key:{get:function(){return this._key}}}),BingMapsGeocoderService.prototype.geocode=function(e){return this._resource.getDerivedResource({queryParameters:{query:e}}).fetchJsonp("jsonp").then(function(e){return 0===e.resourceSets.length?[]:e.resourceSets[0].resources.map(function(e){var t=e.bbox,i=t[0],r=t[1],n=t[2],t=t[3];return{displayName:e.name,destination:Rectangle.fromDegrees(r,i,t,n)}})})},BoundingRectangle.packedLength=4,BoundingRectangle.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.x,t[i++]=e.y,t[i++]=e.width,t[i]=e.height,t},BoundingRectangle.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new BoundingRectangle),i.x=e[t++],i.y=e[t++],i.width=e[t++],i.height=e[t],i},BoundingRectangle.fromPoints=function(e,t){if(defined(t)||(t=new BoundingRectangle),!defined(e)||0===e.length)return t.x=0,t.y=0,t.width=0,t.height=0,t;for(var i=e.length,r=e[0].x,n=e[0].y,a=e[0].x,o=e[0].y,s=1;s<i;s++)var l=e[s],c=l.x,l=l.y,r=Math.min(c,r),a=Math.max(c,a),n=Math.min(l,n),o=Math.max(l,o);return t.x=r,t.y=n,t.width=a-r,t.height=o-n,t};var defaultProjection$1=new GeographicProjection,fromRectangleLowerLeft=new Cartographic,fromRectangleUpperRight=new Cartographic;function arrayFill(e,t,i,r){if("function"==typeof e.fill)return e.fill(t,i,r);for(var n=e.length>>>0,i=defaultValue(i,0),a=i<0?Math.max(n+i,0):Math.min(i,n),r=defaultValue(r,n),o=r<0?Math.max(n+r,0):Math.min(r,n);a<o;)e[a]=t,a++;return e}BoundingRectangle.fromRectangle=function(e,t,i){if(defined(i)||(i=new BoundingRectangle),!defined(e))return i.x=0,i.y=0,i.width=0,i.height=0,i;var r=(t=defaultValue(t,defaultProjection$1)).project(Rectangle.southwest(e,fromRectangleLowerLeft)),e=t.project(Rectangle.northeast(e,fromRectangleUpperRight));return Cartesian2.subtract(e,r,e),i.x=r.x,i.y=r.y,i.width=e.x,i.height=e.y,i},BoundingRectangle.clone=function(e,t){if(defined(e))return defined(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new BoundingRectangle(e.x,e.y,e.width,e.height)},BoundingRectangle.union=function(e,t,i){defined(i)||(i=new BoundingRectangle);var r=Math.min(e.x,t.x),n=Math.min(e.y,t.y),a=Math.max(e.x+e.width,t.x+t.width),t=Math.max(e.y+e.height,t.y+t.height);return i.x=r,i.y=n,i.width=a-r,i.height=t-n,i},BoundingRectangle.expand=function(e,t,i){i=BoundingRectangle.clone(e,i);var r=t.x-i.x,e=t.y-i.y;return r>i.width?i.width=r:r<0&&(i.width-=r,i.x=t.x),e>i.height?i.height=e:e<0&&(i.height-=e,i.y=t.y),i},BoundingRectangle.intersect=function(e,t){var i=e.x,r=e.y,n=t.x,a=t.y;return i>n+t.width||i+e.width<n||r+e.height<a||r>a+t.height?Intersect$1.OUTSIDE:Intersect$1.INTERSECTING},BoundingRectangle.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height},BoundingRectangle.prototype.clone=function(e){return BoundingRectangle.clone(this,e)},BoundingRectangle.prototype.intersect=function(e){return BoundingRectangle.intersect(this,e)},BoundingRectangle.prototype.equals=function(e){return BoundingRectangle.equals(this,e)};var GeometryType={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3},GeometryType$1=Object.freeze(GeometryType);function Matrix2(e,t,i,r){this[0]=defaultValue(e,0),this[1]=defaultValue(i,0),this[2]=defaultValue(t,0),this[3]=defaultValue(r,0)}Matrix2.packedLength=4,Matrix2.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t},Matrix2.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix2),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i},Matrix2.clone=function(e,t){if(defined(e))return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new Matrix2(e[0],e[2],e[1],e[3])},Matrix2.fromArray=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Matrix2),i[0]=e[t],i[1]=e[t+1],i[2]=e[t+2],i[3]=e[t+3],i},Matrix2.fromColumnMajorArray=function(e,t){return Matrix2.clone(e,t)},Matrix2.fromRowMajorArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new Matrix2(e[0],e[1],e[2],e[3])},Matrix2.fromScale=function(e,t){return defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new Matrix2(e.x,0,0,e.y)},Matrix2.fromUniformScale=function(e,t){return defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new Matrix2(e,0,0,e)},Matrix2.fromRotation=function(e,t){var i=Math.cos(e),e=Math.sin(e);return defined(t)?(t[0]=i,t[1]=e,t[2]=-e,t[3]=i,t):new Matrix2(i,-e,e,i)},Matrix2.toArray=function(e,t){return defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},Matrix2.getElementIndex=function(e,t){return 2*e+t},Matrix2.getColumn=function(e,t,i){var r=2*t,t=e[r],r=e[1+r];return i.x=t,i.y=r,i},Matrix2.setColumn=function(e,t,i,r){t*=2;return(r=Matrix2.clone(e,r))[t]=i.x,r[1+t]=i.y,r},Matrix2.getRow=function(e,t,i){var r=e[t],t=e[t+2];return i.x=r,i.y=t,i},Matrix2.setRow=function(e,t,i,r){return(r=Matrix2.clone(e,r))[t]=i.x,r[t+2]=i.y,r};var scratchColumn$2=new Cartesian2;Matrix2.getScale=function(e,t){return t.x=Cartesian2.magnitude(Cartesian2.fromElements(e[0],e[1],scratchColumn$2)),t.y=Cartesian2.magnitude(Cartesian2.fromElements(e[2],e[3],scratchColumn$2)),t};var scratchScale$4=new Cartesian2;Matrix2.getMaximumScale=function(e){return Matrix2.getScale(e,scratchScale$4),Cartesian2.maximumComponent(scratchScale$4)},Matrix2.multiply=function(e,t,i){var r=e[0]*t[0]+e[2]*t[1],n=e[0]*t[2]+e[2]*t[3],a=e[1]*t[0]+e[3]*t[1],t=e[1]*t[2]+e[3]*t[3];return i[0]=r,i[1]=a,i[2]=n,i[3]=t,i},Matrix2.add=function(e,t,i){return i[0]=e[0]+t[0],i[1]=e[1]+t[1],i[2]=e[2]+t[2],i[3]=e[3]+t[3],i},Matrix2.subtract=function(e,t,i){return i[0]=e[0]-t[0],i[1]=e[1]-t[1],i[2]=e[2]-t[2],i[3]=e[3]-t[3],i},Matrix2.multiplyByVector=function(e,t,i){var r=e[0]*t.x+e[2]*t.y,t=e[1]*t.x+e[3]*t.y;return i.x=r,i.y=t,i},Matrix2.multiplyByScalar=function(e,t,i){return i[0]=e[0]*t,i[1]=e[1]*t,i[2]=e[2]*t,i[3]=e[3]*t,i},Matrix2.multiplyByScale=function(e,t,i){return i[0]=e[0]*t.x,i[1]=e[1]*t.x,i[2]=e[2]*t.y,i[3]=e[3]*t.y,i},Matrix2.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},Matrix2.transpose=function(e,t){var i=e[0],r=e[2],n=e[1],e=e[3];return t[0]=i,t[1]=r,t[2]=n,t[3]=e,t},Matrix2.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t},Matrix2.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},Matrix2.equalsArray=function(e,t,i){return e[0]===t[i]&&e[1]===t[i+1]&&e[2]===t[i+2]&&e[3]===t[i+3]},Matrix2.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e[0]-t[0])<=i&&Math.abs(e[1]-t[1])<=i&&Math.abs(e[2]-t[2])<=i&&Math.abs(e[3]-t[3])<=i},Matrix2.IDENTITY=Object.freeze(new Matrix2(1,0,0,1)),Matrix2.ZERO=Object.freeze(new Matrix2(0,0,0,0)),Matrix2.COLUMN0ROW0=0,Matrix2.COLUMN0ROW1=1,Matrix2.COLUMN1ROW0=2,Matrix2.COLUMN1ROW1=3,Object.defineProperties(Matrix2.prototype,{length:{get:function(){return Matrix2.packedLength}}}),Matrix2.prototype.clone=function(e){return Matrix2.clone(this,e)},Matrix2.prototype.equals=function(e){return Matrix2.equals(this,e)},Matrix2.prototype.equalsEpsilon=function(e,t){return Matrix2.equalsEpsilon(this,e,t)},Matrix2.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"};var PrimitiveType={POINTS:WebGLConstants$1.POINTS,LINES:WebGLConstants$1.LINES,LINE_LOOP:WebGLConstants$1.LINE_LOOP,LINE_STRIP:WebGLConstants$1.LINE_STRIP,TRIANGLES:WebGLConstants$1.TRIANGLES,TRIANGLE_STRIP:WebGLConstants$1.TRIANGLE_STRIP,TRIANGLE_FAN:WebGLConstants$1.TRIANGLE_FAN,validate:function(e){return e===PrimitiveType.POINTS||e===PrimitiveType.LINES||e===PrimitiveType.LINE_LOOP||e===PrimitiveType.LINE_STRIP||e===PrimitiveType.TRIANGLES||e===PrimitiveType.TRIANGLE_STRIP||e===PrimitiveType.TRIANGLE_FAN}},PrimitiveType$1=Object.freeze(PrimitiveType);function Geometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=defaultValue(e.primitiveType,PrimitiveType$1.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=defaultValue(e.geometryType,GeometryType$1.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}Geometry.computeNumberOfVertices=function(e){var t,i,r=-1;for(t in e.attributes)e.attributes.hasOwnProperty(t)&&defined(e.attributes[t])&&defined(e.attributes[t].values)&&(r=(i=e.attributes[t]).values.length/i.componentsPerAttribute);return r};var rectangleCenterScratch=new Cartographic,enuCenterScratch=new Cartesian3,fixedFrameToEnuScratch=new Matrix4,boundingRectanglePointsCartographicScratch=[new Cartographic,new Cartographic,new Cartographic],boundingRectanglePointsEnuScratch=[new Cartesian2,new Cartesian2,new Cartesian2],points2DScratch=[new Cartesian2,new Cartesian2,new Cartesian2],pointEnuScratch=new Cartesian3,enuRotationScratch=new Quaternion,enuRotationMatrixScratch=new Matrix4,rotation2DScratch=new Matrix2;function GeometryAttribute(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=defaultValue(e.normalize,!1),this.values=e.values}function GeometryAttributes(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.position=e.position,this.normal=e.normal,this.st=e.st,this.bitangent=e.bitangent,this.tangent=e.tangent,this.color=e.color}Geometry._textureCoordinateRotationPoints=function(e,t,i,r){var n=Rectangle.center(r,rectangleCenterScratch),a=Cartographic.toCartesian(n,i,enuCenterScratch),n=Transforms.eastNorthUpToFixedFrame(a,i,fixedFrameToEnuScratch),o=Matrix4.inverse(n,fixedFrameToEnuScratch),s=boundingRectanglePointsEnuScratch,l=boundingRectanglePointsCartographicScratch;l[0].longitude=r.west,l[0].latitude=r.south,l[1].longitude=r.west,l[1].latitude=r.north,l[2].longitude=r.east,l[2].latitude=r.south;for(var c=pointEnuScratch,u=0;u<3;u++)Cartographic.toCartesian(l[u],i,c),c=Matrix4.multiplyByPointAsVector(o,c,c),s[u].x=c.x,s[u].y=c.y;var a=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,-t,enuRotationScratch),d=Matrix3.fromQuaternion(a,enuRotationMatrixScratch),h=e.length,p=Number.POSITIVE_INFINITY,m=Number.POSITIVE_INFINITY,f=Number.NEGATIVE_INFINITY,g=Number.NEGATIVE_INFINITY;for(u=0;u<h;u++)c=Matrix4.multiplyByPointAsVector(o,e[u],c),c=Matrix3.multiplyByVector(d,c,c),p=Math.min(p,c.x),m=Math.min(m,c.y),f=Math.max(f,c.x),g=Math.max(g,c.y);var _=Matrix2.fromRotation(t,rotation2DScratch),y=points2DScratch;y[0].x=p,y[0].y=m,y[1].x=p,y[1].y=g,y[2].x=f,y[2].y=m;var C=s[0],v=s[2].x-C.x,S=s[1].y-C.y;for(u=0;u<3;u++){var T=y[u];Matrix2.multiplyByVector(_,T,T),T.x=(T.x-C.x)/v,T.y=(T.y-C.y)/S}n=y[0],r=y[1],a=y[2],t=new Array(6);return Cartesian2.pack(n,t),Cartesian2.pack(r,t,2),Cartesian2.pack(a,t,4),t};var GeometryOffsetAttribute={NONE:0,TOP:1,ALL:2},GeometryOffsetAttribute$1=Object.freeze(GeometryOffsetAttribute);function VertexFormat(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.position=defaultValue(e.position,!1),this.normal=defaultValue(e.normal,!1),this.st=defaultValue(e.st,!1),this.bitangent=defaultValue(e.bitangent,!1),this.tangent=defaultValue(e.tangent,!1),this.color=defaultValue(e.color,!1)}VertexFormat.POSITION_ONLY=Object.freeze(new VertexFormat({position:!0})),VertexFormat.POSITION_AND_NORMAL=Object.freeze(new VertexFormat({position:!0,normal:!0})),VertexFormat.POSITION_NORMAL_AND_ST=Object.freeze(new VertexFormat({position:!0,normal:!0,st:!0})),VertexFormat.POSITION_AND_ST=Object.freeze(new VertexFormat({position:!0,st:!0})),VertexFormat.POSITION_AND_COLOR=Object.freeze(new VertexFormat({position:!0,color:!0})),VertexFormat.ALL=Object.freeze(new VertexFormat({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),VertexFormat.DEFAULT=VertexFormat.POSITION_NORMAL_AND_ST,VertexFormat.packedLength=6,VertexFormat.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.position?1:0,t[i++]=e.normal?1:0,t[i++]=e.st?1:0,t[i++]=e.tangent?1:0,t[i++]=e.bitangent?1:0,t[i]=e.color?1:0,t},VertexFormat.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new VertexFormat),i.position=1===e[t++],i.normal=1===e[t++],i.st=1===e[t++],i.tangent=1===e[t++],i.bitangent=1===e[t++],i.color=1===e[t],i},VertexFormat.clone=function(e,t){if(defined(e))return defined(t)||(t=new VertexFormat),t.position=e.position,t.normal=e.normal,t.st=e.st,t.tangent=e.tangent,t.bitangent=e.bitangent,t.color=e.color,t};var diffScratch=new Cartesian3;function BoxGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).minimum,i=e.maximum,r=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._minimum=Cartesian3.clone(t),this._maximum=Cartesian3.clone(i),this._vertexFormat=r,this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxGeometry"}BoxGeometry.fromDimensions=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).dimensions,t=Cartesian3.multiplyByScalar(t,.5,new Cartesian3);return new BoxGeometry({minimum:Cartesian3.negate(t,new Cartesian3),maximum:t,vertexFormat:e.vertexFormat,offsetAttribute:e.offsetAttribute})},BoxGeometry.fromAxisAlignedBoundingBox=function(e){return new BoxGeometry({minimum:e.minimum,maximum:e.maximum})},BoxGeometry.packedLength=2*Cartesian3.packedLength+VertexFormat.packedLength+1,BoxGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._minimum,t,i),Cartesian3.pack(e._maximum,t,i+Cartesian3.packedLength),VertexFormat.pack(e._vertexFormat,t,i+2*Cartesian3.packedLength),t[i+2*Cartesian3.packedLength+VertexFormat.packedLength]=defaultValue(e._offsetAttribute,-1),t};var scratchMin=new Cartesian3,scratchMax=new Cartesian3,scratchVertexFormat=new VertexFormat,scratchOptions={minimum:scratchMin,maximum:scratchMax,vertexFormat:scratchVertexFormat,offsetAttribute:void 0},unitBoxGeometry;BoxGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchMin),n=Cartesian3.unpack(e,t+Cartesian3.packedLength,scratchMax),a=VertexFormat.unpack(e,t+2*Cartesian3.packedLength,scratchVertexFormat),t=e[t+2*Cartesian3.packedLength+VertexFormat.packedLength];return defined(i)?(i._minimum=Cartesian3.clone(r,i._minimum),i._maximum=Cartesian3.clone(n,i._maximum),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions.offsetAttribute=-1===t?void 0:t,new BoxGeometry(scratchOptions))},BoxGeometry.createGeometry=function(e){var t=e._minimum,i=e._maximum,r=e._vertexFormat;if(!Cartesian3.equals(t,i)){var n,a,o,s=new GeometryAttributes;r.position&&(r.st||r.normal||r.tangent||r.bitangent)?(r.position&&((l=new Float64Array(72))[0]=t.x,l[1]=t.y,l[2]=i.z,l[3]=i.x,l[4]=t.y,l[5]=i.z,l[6]=i.x,l[7]=i.y,l[8]=i.z,l[9]=t.x,l[10]=i.y,l[11]=i.z,l[12]=t.x,l[13]=t.y,l[14]=t.z,l[15]=i.x,l[16]=t.y,l[17]=t.z,l[18]=i.x,l[19]=i.y,l[20]=t.z,l[21]=t.x,l[22]=i.y,l[23]=t.z,l[24]=i.x,l[25]=t.y,l[26]=t.z,l[27]=i.x,l[28]=i.y,l[29]=t.z,l[30]=i.x,l[31]=i.y,l[32]=i.z,l[33]=i.x,l[34]=t.y,l[35]=i.z,l[36]=t.x,l[37]=t.y,l[38]=t.z,l[39]=t.x,l[40]=i.y,l[41]=t.z,l[42]=t.x,l[43]=i.y,l[44]=i.z,l[45]=t.x,l[46]=t.y,l[47]=i.z,l[48]=t.x,l[49]=i.y,l[50]=t.z,l[51]=i.x,l[52]=i.y,l[53]=t.z,l[54]=i.x,l[55]=i.y,l[56]=i.z,l[57]=t.x,l[58]=i.y,l[59]=i.z,l[60]=t.x,l[61]=t.y,l[62]=t.z,l[63]=i.x,l[64]=t.y,l[65]=t.z,l[66]=i.x,l[67]=t.y,l[68]=i.z,l[69]=t.x,l[70]=t.y,l[71]=i.z,s.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l})),r.normal&&((n=new Float32Array(72))[0]=0,n[1]=0,n[2]=1,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=1,n[9]=0,n[10]=0,n[11]=1,n[12]=0,n[13]=0,n[14]=-1,n[15]=0,n[16]=0,n[17]=-1,n[18]=0,n[19]=0,n[20]=-1,n[21]=0,n[22]=0,n[23]=-1,n[24]=1,n[25]=0,n[26]=0,n[27]=1,n[28]=0,n[29]=0,n[30]=1,n[31]=0,n[32]=0,n[33]=1,n[34]=0,n[35]=0,n[36]=-1,n[37]=0,n[38]=0,n[39]=-1,n[40]=0,n[41]=0,n[42]=-1,n[43]=0,n[44]=0,n[45]=-1,n[46]=0,n[47]=0,n[48]=0,n[49]=1,n[50]=0,n[51]=0,n[52]=1,n[53]=0,n[54]=0,n[55]=1,n[56]=0,n[57]=0,n[58]=1,n[59]=0,n[60]=0,n[61]=-1,n[62]=0,n[63]=0,n[64]=-1,n[65]=0,n[66]=0,n[67]=-1,n[68]=0,n[69]=0,n[70]=-1,n[71]=0,s.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:n})),r.st&&((a=new Float32Array(48))[0]=0,a[1]=0,a[2]=1,a[3]=0,a[4]=1,a[5]=1,a[6]=0,a[7]=1,a[8]=1,a[9]=0,a[10]=0,a[11]=0,a[12]=0,a[13]=1,a[14]=1,a[15]=1,a[16]=0,a[17]=0,a[18]=1,a[19]=0,a[20]=1,a[21]=1,a[22]=0,a[23]=1,a[24]=1,a[25]=0,a[26]=0,a[27]=0,a[28]=0,a[29]=1,a[30]=1,a[31]=1,a[32]=1,a[33]=0,a[34]=0,a[35]=0,a[36]=0,a[37]=1,a[38]=1,a[39]=1,a[40]=0,a[41]=0,a[42]=1,a[43]=0,a[44]=1,a[45]=1,a[46]=0,a[47]=1,s.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:a})),r.tangent&&((a=new Float32Array(72))[0]=1,a[1]=0,a[2]=0,a[3]=1,a[4]=0,a[5]=0,a[6]=1,a[7]=0,a[8]=0,a[9]=1,a[10]=0,a[11]=0,a[12]=-1,a[13]=0,a[14]=0,a[15]=-1,a[16]=0,a[17]=0,a[18]=-1,a[19]=0,a[20]=0,a[21]=-1,a[22]=0,a[23]=0,a[24]=0,a[25]=1,a[26]=0,a[27]=0,a[28]=1,a[29]=0,a[30]=0,a[31]=1,a[32]=0,a[33]=0,a[34]=1,a[35]=0,a[36]=0,a[37]=-1,a[38]=0,a[39]=0,a[40]=-1,a[41]=0,a[42]=0,a[43]=-1,a[44]=0,a[45]=0,a[46]=-1,a[47]=0,a[48]=-1,a[49]=0,a[50]=0,a[51]=-1,a[52]=0,a[53]=0,a[54]=-1,a[55]=0,a[56]=0,a[57]=-1,a[58]=0,a[59]=0,a[60]=1,a[61]=0,a[62]=0,a[63]=1,a[64]=0,a[65]=0,a[66]=1,a[67]=0,a[68]=0,a[69]=1,a[70]=0,a[71]=0,s.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:a})),r.bitangent&&((o=new Float32Array(72))[0]=0,o[1]=1,o[2]=0,o[3]=0,o[4]=1,o[5]=0,o[6]=0,o[7]=1,o[8]=0,o[9]=0,o[10]=1,o[11]=0,o[12]=0,o[13]=1,o[14]=0,o[15]=0,o[16]=1,o[17]=0,o[18]=0,o[19]=1,o[20]=0,o[21]=0,o[22]=1,o[23]=0,o[24]=0,o[25]=0,o[26]=1,o[27]=0,o[28]=0,o[29]=1,o[30]=0,o[31]=0,o[32]=1,o[33]=0,o[34]=0,o[35]=1,o[36]=0,o[37]=0,o[38]=1,o[39]=0,o[40]=0,o[41]=1,o[42]=0,o[43]=0,o[44]=1,o[45]=0,o[46]=0,o[47]=1,o[48]=0,o[49]=0,o[50]=1,o[51]=0,o[52]=0,o[53]=1,o[54]=0,o[55]=0,o[56]=1,o[57]=0,o[58]=0,o[59]=1,o[60]=0,o[61]=0,o[62]=1,o[63]=0,o[64]=0,o[65]=1,o[66]=0,o[67]=0,o[68]=1,o[69]=0,o[70]=0,o[71]=1,s.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:o})),(o=new Uint16Array(36))[0]=0,o[1]=1,o[2]=2,o[3]=0,o[4]=2,o[5]=3,o[6]=6,o[7]=5,o[8]=4,o[9]=7,o[10]=6,o[11]=4,o[12]=8,o[13]=9,o[14]=10,o[15]=8,o[16]=10,o[17]=11,o[18]=14,o[19]=13,o[20]=12,o[21]=15,o[22]=14,o[23]=12,o[24]=18,o[25]=17,o[26]=16,o[27]=19,o[28]=18,o[29]=16,o[30]=20,o[31]=21,o[32]=22,o[33]=20,o[34]=22,o[35]=23):((l=new Float64Array(24))[0]=t.x,l[1]=t.y,l[2]=t.z,l[3]=i.x,l[4]=t.y,l[5]=t.z,l[6]=i.x,l[7]=i.y,l[8]=t.z,l[9]=t.x,l[10]=i.y,l[11]=t.z,l[12]=t.x,l[13]=t.y,l[14]=i.z,l[15]=i.x,l[16]=t.y,l[17]=i.z,l[18]=i.x,l[19]=i.y,l[20]=i.z,l[21]=t.x,l[22]=i.y,l[23]=i.z,s.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l}),(o=new Uint16Array(36))[0]=4,o[1]=5,o[2]=6,o[3]=4,o[4]=6,o[5]=7,o[6]=1,o[7]=0,o[8]=3,o[9]=1,o[10]=3,o[11]=2,o[12]=1,o[13]=6,o[14]=5,o[15]=1,o[16]=2,o[17]=6,o[18]=2,o[19]=3,o[20]=7,o[21]=2,o[22]=7,o[23]=6,o[24]=3,o[25]=0,o[26]=4,o[27]=3,o[28]=4,o[29]=7,o[30]=0,o[31]=1,o[32]=5,o[33]=0,o[34]=5,o[35]=4);var l,t=Cartesian3.subtract(i,t,diffScratch),t=.5*Cartesian3.magnitude(t);return defined(e._offsetAttribute)&&(l=l.length,arrayFill(l=new Uint8Array(l/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),s.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:l})),new Geometry({attributes:s,indices:o,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,t),offsetAttribute:e._offsetAttribute})}},BoxGeometry.getUnitBox=function(){return defined(unitBoxGeometry)||(unitBoxGeometry=BoxGeometry.createGeometry(BoxGeometry.fromDimensions({dimensions:new Cartesian3(1,1,1),vertexFormat:VertexFormat.POSITION_ONLY}))),unitBoxGeometry};var diffScratch$1=new Cartesian3;function BoxOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).minimum,i=e.maximum;this._min=Cartesian3.clone(t),this._max=Cartesian3.clone(i),this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxOutlineGeometry"}BoxOutlineGeometry.fromDimensions=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).dimensions,t=Cartesian3.multiplyByScalar(t,.5,new Cartesian3);return new BoxOutlineGeometry({minimum:Cartesian3.negate(t,new Cartesian3),maximum:t,offsetAttribute:e.offsetAttribute})},BoxOutlineGeometry.fromAxisAlignedBoundingBox=function(e){return new BoxOutlineGeometry({minimum:e.minimum,maximum:e.maximum})},BoxOutlineGeometry.packedLength=2*Cartesian3.packedLength+1,BoxOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._min,t,i),Cartesian3.pack(e._max,t,i+Cartesian3.packedLength),t[i+2*Cartesian3.packedLength]=defaultValue(e._offsetAttribute,-1),t};var scratchMin$1=new Cartesian3,scratchMax$1=new Cartesian3,scratchOptions$1={minimum:scratchMin$1,maximum:scratchMax$1,offsetAttribute:void 0};function CartographicGeocoderService(){}function Spline(){this.times=void 0,this.points=void 0,DeveloperError.throwInstantiationError()}function LinearSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,e=e.times;this._times=e,this._points=t,this._lastTimeIndex=0}BoxOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchMin$1),n=Cartesian3.unpack(e,t+Cartesian3.packedLength,scratchMax$1),t=e[t+2*Cartesian3.packedLength];return defined(i)?(i._min=Cartesian3.clone(r,i._min),i._max=Cartesian3.clone(n,i._max),i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$1.offsetAttribute=-1===t?void 0:t,new BoxOutlineGeometry(scratchOptions$1))},BoxOutlineGeometry.createGeometry=function(e){var t=e._min,i=e._max;if(!Cartesian3.equals(t,i)){var r=new GeometryAttributes,n=new Uint16Array(24),a=new Float64Array(24);a[0]=t.x,a[1]=t.y,a[2]=t.z,a[3]=i.x,a[4]=t.y,a[5]=t.z,a[6]=i.x,a[7]=i.y,a[8]=t.z,a[9]=t.x,a[10]=i.y,a[11]=t.z,a[12]=t.x,a[13]=t.y,a[14]=i.z,a[15]=i.x,a[16]=t.y,a[17]=i.z,a[18]=i.x,a[19]=i.y,a[20]=i.z,a[21]=t.x,a[22]=i.y,a[23]=i.z,r.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a}),n[0]=4,n[1]=5,n[2]=5,n[3]=6,n[4]=6,n[5]=7,n[6]=7,n[7]=4,n[8]=0,n[9]=1,n[10]=1,n[11]=2,n[12]=2,n[13]=3,n[14]=3,n[15]=0,n[16]=0,n[17]=4,n[18]=1,n[19]=5,n[20]=2,n[21]=6,n[22]=3,n[23]=7;t=Cartesian3.subtract(i,t,diffScratch$1),t=.5*Cartesian3.magnitude(t);return defined(e._offsetAttribute)&&(a=a.length,arrayFill(a=new Uint8Array(a/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),r.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:a})),new Geometry({attributes:r,indices:n,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,t),offsetAttribute:e._offsetAttribute})}},CartographicGeocoderService.prototype.geocode=function(e){var t=e.match(/[^\s,\n]+/g);if(2===t.length||3===t.length){var i=+t[0],r=+t[1],n=3===t.length?+t[2]:300;if(isNaN(i)&&isNaN(r))for(var a=/^(\d+.?\d*)([nsew])/i,o=0;o<t.length;++o){var s=t[o].match(a);a.test(t[o])&&3===s.length&&(/^[ns]/i.test(s[2])?r=/^[n]/i.test(s[2])?+s[1]:-s[1]:/^[ew]/i.test(s[2])&&(i=/^[e]/i.test(s[2])?+s[1]:-s[1]))}if(!isNaN(i)&&!isNaN(r)&&!isNaN(n)){n={displayName:e,destination:Cartesian3.fromDegrees(i,r,n)};return when.resolve([n])}}return when.resolve([])},Spline.prototype.evaluate=DeveloperError.throwInstantiationError,Spline.prototype.findTimeInterval=function(e,t){var i,r=this.times,n=r.length;if(e>=r[t=defaultValue(t,0)]){if(t+1<n&&e<r[t+1])return t;if(t+2<n&&e<r[t+2])return t+1}else if(0<=t-1&&e>=r[t-1])return t-1;if(e>r[t])for(i=t;i<n-1&&!(e>=r[i]&&e<r[i+1]);++i);else for(i=t-1;0<=i&&!(e>=r[i]&&e<r[i+1]);--i);return i===n-1&&(i=n-2),i},Spline.prototype.wrapTime=function(e){var t=this.times,i=t[t.length-1],r=t[0],t=i-r;return e<r&&(e+=(Math.floor((r-e)/t)+1)*t),i<e&&(e-=(Math.floor((e-i)/t)+1)*t),e},Spline.prototype.clampTime=function(e){var t=this.times;return CesiumMath.clamp(e,t[0],t[t.length-1])},Object.defineProperties(LinearSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}}),LinearSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,LinearSpline.prototype.wrapTime=Spline.prototype.wrapTime,LinearSpline.prototype.clampTime=Spline.prototype.clampTime,LinearSpline.prototype.evaluate=function(e,t){var i=this.points,r=this.times,n=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),r=(e-r[n])/(r[n+1]-r[n]);return defined(t)||(t=new Cartesian3),Cartesian3.lerp(i[n],i[n+1],r,t)};var TridiagonalSystemSolver={solve:function(e,t,i,r){for(var n,a=new Array(i.length),o=new Array(r.length),s=new Array(r.length),l=0;l<o.length;l++)o[l]=new Cartesian3,s[l]=new Cartesian3;for(a[0]=i[0]/t[0],o[0]=Cartesian3.multiplyByScalar(r[0],1/t[0],o[0]),l=1;l<a.length;++l)n=1/(t[l]-a[l-1]*e[l-1]),a[l]=i[l]*n,o[l]=Cartesian3.subtract(r[l],Cartesian3.multiplyByScalar(o[l-1],e[l-1],o[l]),o[l]),o[l]=Cartesian3.multiplyByScalar(o[l],n,o[l]);for(n=1/(t[l]-a[l-1]*e[l-1]),o[l]=Cartesian3.subtract(r[l],Cartesian3.multiplyByScalar(o[l-1],e[l-1],o[l]),o[l]),o[l]=Cartesian3.multiplyByScalar(o[l],n,o[l]),s[s.length-1]=o[o.length-1],l=s.length-2;0<=l;--l)s[l]=Cartesian3.subtract(o[l],Cartesian3.multiplyByScalar(s[l+1],a[l],s[l]),s[l]);return s}},scratchLower=[],scratchDiagonal=[],scratchUpper=[],scratchRight=[];function generateClamped(e,t,i){var r,n=scratchLower,a=scratchUpper,o=scratchDiagonal,s=scratchRight;n.length=a.length=e.length-1,o.length=s.length=e.length,n[0]=o[0]=1;var l=s[a[0]=0];for(defined(l)||(l=s[0]=new Cartesian3),Cartesian3.clone(t,l),r=1;r<n.length-1;++r)n[r]=a[r]=1,o[r]=4,defined(l=s[r])||(l=s[r]=new Cartesian3),Cartesian3.subtract(e[r+1],e[r-1],l),Cartesian3.multiplyByScalar(l,3,l);return n[r]=0,a[r]=1,o[r]=4,defined(l=s[r])||(l=s[r]=new Cartesian3),Cartesian3.subtract(e[r+1],e[r-1],l),Cartesian3.multiplyByScalar(l,3,l),defined(l=s[r+(o[r+1]=1)])||(l=s[r+1]=new Cartesian3),Cartesian3.clone(i,l),TridiagonalSystemSolver.solve(n,o,a,s)}function generateNatural(e){var t,i=scratchLower,r=scratchUpper,n=scratchDiagonal,a=scratchRight;i.length=r.length=e.length-1,n.length=a.length=e.length,i[0]=r[0]=1,n[0]=2;var o=a[0];for(defined(o)||(o=a[0]=new Cartesian3),Cartesian3.subtract(e[1],e[0],o),Cartesian3.multiplyByScalar(o,3,o),t=1;t<i.length;++t)i[t]=r[t]=1,n[t]=4,defined(o=a[t])||(o=a[t]=new Cartesian3),Cartesian3.subtract(e[t+1],e[t-1],o),Cartesian3.multiplyByScalar(o,3,o);return n[t]=2,defined(o=a[t])||(o=a[t]=new Cartesian3),Cartesian3.subtract(e[t],e[t-1],o),Cartesian3.multiplyByScalar(o,3,o),TridiagonalSystemSolver.solve(i,n,r,a)}function HermiteSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,i=e.times,r=e.inTangents,e=e.outTangents;this._times=i,this._points=t,this._inTangents=r,this._outTangents=e,this._lastTimeIndex=0}Object.defineProperties(HermiteSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},inTangents:{get:function(){return this._inTangents}},outTangents:{get:function(){return this._outTangents}}}),HermiteSpline.createC1=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,i=e.points,r=e.tangents,e=r.slice(0,r.length-1);return new HermiteSpline({times:t,points:i,inTangents:r.slice(1,r.length),outTangents:e})},HermiteSpline.createNaturalCubic=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,i=e.points;if(i.length<3)return new LinearSpline({points:i,times:t});var r=generateNatural(i),e=r.slice(0,r.length-1);return new HermiteSpline({times:t,points:i,inTangents:r.slice(1,r.length),outTangents:e})},HermiteSpline.createClampedCubic=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).times,i=e.points,r=e.firstTangent,e=e.lastTangent;if(i.length<3)return new LinearSpline({points:i,times:t});r=generateClamped(i,r,e),e=r.slice(0,r.length-1);return new HermiteSpline({times:t,points:i,inTangents:r.slice(1,r.length),outTangents:e})},HermiteSpline.hermiteCoefficientMatrix=new Matrix4(2,-3,0,1,-2,3,0,0,1,-2,1,0,1,-1,0,0),HermiteSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval;var scratchTimeVec=new Cartesian4,scratchTemp=new Cartesian3;HermiteSpline.prototype.wrapTime=Spline.prototype.wrapTime,HermiteSpline.prototype.clampTime=Spline.prototype.clampTime,HermiteSpline.prototype.evaluate=function(e,t){defined(t)||(t=new Cartesian3);var i=this.points,r=this.times,n=this.inTangents,a=this.outTangents,o=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),e=(e-r[o])/(r[o+1]-r[o]),r=scratchTimeVec;r.z=e,r.y=e*e,r.x=r.y*e,r.w=1;r=Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,r,r);return t=Cartesian3.multiplyByScalar(i[o],r.x,t),Cartesian3.multiplyByScalar(i[o+1],r.y,scratchTemp),Cartesian3.add(t,scratchTemp,t),Cartesian3.multiplyByScalar(a[o],r.z,scratchTemp),Cartesian3.add(t,scratchTemp,t),Cartesian3.multiplyByScalar(n[o],r.w,scratchTemp),Cartesian3.add(t,scratchTemp,t)};var scratchTimeVec$1=new Cartesian4,scratchTemp0=new Cartesian3,scratchTemp1=new Cartesian3;function createEvaluateFunction(l){var c=l.points,u=l.times;if(c.length<3){var i=u[0],r=1/(u[1]-i),n=c[0],a=c[1];return function(e,t){defined(t)||(t=new Cartesian3);e=(e-i)*r;return Cartesian3.lerp(n,a,e,t)}}return function(e,t){defined(t)||(t=new Cartesian3);var i,r,n,a,o=l._lastTimeIndex=l.findTimeInterval(e,l._lastTimeIndex),s=(e-u[o])/(u[o+1]-u[o]),e=scratchTimeVec$1;return e.z=s,e.y=s*s,e.x=e.y*s,e.w=1,e=0===o?(i=c[0],r=c[1],n=l.firstTangent,a=Cartesian3.subtract(c[2],i,scratchTemp0),Cartesian3.multiplyByScalar(a,.5,a),Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,e,e)):o===c.length-2?(i=c[o],r=c[o+1],a=l.lastTangent,n=Cartesian3.subtract(r,c[o-1],scratchTemp0),Cartesian3.multiplyByScalar(n,.5,n),Matrix4.multiplyByVector(HermiteSpline.hermiteCoefficientMatrix,e,e)):(i=c[o-1],r=c[o],n=c[o+1],a=c[o+2],Matrix4.multiplyByVector(CatmullRomSpline.catmullRomCoefficientMatrix,e,e)),t=Cartesian3.multiplyByScalar(i,e.x,t),Cartesian3.multiplyByScalar(r,e.y,scratchTemp1),Cartesian3.add(t,scratchTemp1,t),Cartesian3.multiplyByScalar(n,e.z,scratchTemp1),Cartesian3.add(t,scratchTemp1,t),Cartesian3.multiplyByScalar(a,e.w,scratchTemp1),Cartesian3.add(t,scratchTemp1,t)}}var firstTangentScratch=new Cartesian3,lastTangentScratch=new Cartesian3;function CatmullRomSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,i=e.times,r=e.firstTangent,n=e.lastTangent;2<t.length&&(defined(r)||(r=firstTangentScratch,Cartesian3.multiplyByScalar(t[1],2,r),Cartesian3.subtract(r,t[2],r),Cartesian3.subtract(r,t[0],r),Cartesian3.multiplyByScalar(r,.5,r)),defined(n)||(e=t.length-1,n=lastTangentScratch,Cartesian3.multiplyByScalar(t[e-1],2,n),Cartesian3.subtract(t[e],n,n),Cartesian3.add(n,t[e-2],n),Cartesian3.multiplyByScalar(n,.5,n))),this._times=i,this._points=t,this._firstTangent=Cartesian3.clone(r),this._lastTangent=Cartesian3.clone(n),this._evaluateFunction=createEvaluateFunction(this),this._lastTimeIndex=0}function getStringFromTypedArray(e,t,i){return t=defaultValue(t,0),i=defaultValue(i,e.byteLength-t),e=e.subarray(t,t+i),getStringFromTypedArray.decode(e)}function inRange(e,t,i){return t<=e&&e<=i}function utf8Handler(e){for(var t=0,i=0,r=0,n=128,a=191,o=[],s=e.length,l=0;l<s;++l){var c=e[l];if(0===r){if(inRange(c,0,127)){o.push(c);continue}if(inRange(c,194,223)){r=1,t=31&c;continue}if(inRange(c,224,239)){224===c&&(n=160),237===c&&(a=159),r=2,t=15&c;continue}if(inRange(c,240,244)){240===c&&(n=144),244===c&&(a=143),r=3,t=7&c;continue}throw new RuntimeError("String decoding failed.")}inRange(c,n,a)?(n=128,a=191,t=t<<6|63&c,++i===r&&(o.push(t),t=r=i=0)):(t=r=i=0,n=128,a=191,--l)}return o}Object.defineProperties(CatmullRomSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},firstTangent:{get:function(){return this._firstTangent}},lastTangent:{get:function(){return this._lastTangent}}}),CatmullRomSpline.catmullRomCoefficientMatrix=new Matrix4(-.5,1,-.5,0,1.5,-2.5,0,1,-1.5,2,.5,0,.5,-.5,0,0),CatmullRomSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,CatmullRomSpline.prototype.wrapTime=Spline.prototype.wrapTime,CatmullRomSpline.prototype.clampTime=Spline.prototype.clampTime,CatmullRomSpline.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},getStringFromTypedArray.decodeWithTextDecoder=function(e){return new TextDecoder("utf-8").decode(e)},getStringFromTypedArray.decodeWithFromCharCode=function(e){for(var t="",i=utf8Handler(e),r=i.length,n=0;n<r;++n){var a=i[n];a<=65535?t+=String.fromCharCode(a):(a-=65536,t+=String.fromCharCode(55296+(a>>10),56320+(1023&a)))}return t},"undefined"!=typeof TextDecoder?getStringFromTypedArray.decode=getStringFromTypedArray.decodeWithTextDecoder:getStringFromTypedArray.decode=getStringFromTypedArray.decodeWithFromCharCode;var Intersections2D={};function QuantizedMeshTerrainData(e){this._quantizedVertices=e.quantizedVertices,this._encodedNormals=e.encodedNormals,this._indices=e.indices,this._minimumHeight=e.minimumHeight,this._maximumHeight=e.maximumHeight,this._boundingSphere=e.boundingSphere,this._orientedBoundingBox=e.orientedBoundingBox,this._horizonOcclusionPoint=e.horizonOcclusionPoint,this._credits=e.credits;var t=this._quantizedVertices.length/3,i=this._uValues=this._quantizedVertices.subarray(0,t),r=this._vValues=this._quantizedVertices.subarray(t,2*t);function n(e,t){return r[e]-r[t]}function a(e,t){return i[e]-i[t]}this._heightValues=this._quantizedVertices.subarray(2*t,3*t),this._westIndices=sortIndicesIfNecessary(e.westIndices,n,t),this._southIndices=sortIndicesIfNecessary(e.southIndices,a,t),this._eastIndices=sortIndicesIfNecessary(e.eastIndices,n,t),this._northIndices=sortIndicesIfNecessary(e.northIndices,a,t),this._westSkirtHeight=e.westSkirtHeight,this._southSkirtHeight=e.southSkirtHeight,this._eastSkirtHeight=e.eastSkirtHeight,this._northSkirtHeight=e.northSkirtHeight,this._childTileMask=defaultValue(e.childTileMask,15),this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._waterMask=e.waterMask,this._mesh=void 0}Intersections2D.clipTriangleAtAxisAlignedThreshold=function(e,t,i,r,n,a){var o,s,l;defined(a)?a.length=0:a=[],l=t?(o=i<e,s=r<e,n<e):(o=e<i,s=e<r,e<n);var c,u,d,h,p,m,t=o+s+l;return 1===t?o?(c=(e-i)/(r-i),u=(e-i)/(n-i),a.push(1),a.push(2),1!==u&&(a.push(-1),a.push(0),a.push(2),a.push(u)),1!==c&&(a.push(-1),a.push(0),a.push(1),a.push(c))):s?(d=(e-r)/(n-r),h=(e-r)/(i-r),a.push(2),a.push(0),1!==h&&(a.push(-1),a.push(1),a.push(0),a.push(h)),1!==d&&(a.push(-1),a.push(1),a.push(2),a.push(d))):l&&(p=(e-n)/(i-n),m=(e-n)/(r-n),a.push(0),a.push(1),1!==m&&(a.push(-1),a.push(2),a.push(1),a.push(m)),1!==p&&(a.push(-1),a.push(2),a.push(0),a.push(p))):2===t?o||i===e?s||r===e?l||n===e||(u=(e-i)/(n-i),d=(e-r)/(n-r),a.push(2),a.push(-1),a.push(0),a.push(2),a.push(u),a.push(-1),a.push(1),a.push(2),a.push(d)):(m=(e-n)/(r-n),c=(e-i)/(r-i),a.push(1),a.push(-1),a.push(2),a.push(1),a.push(m),a.push(-1),a.push(0),a.push(1),a.push(c)):(h=(e-r)/(i-r),p=(e-n)/(i-n),a.push(0),a.push(-1),a.push(1),a.push(0),a.push(h),a.push(-1),a.push(2),a.push(0),a.push(p)):3!==t&&(a.push(0),a.push(1),a.push(2)),a},Intersections2D.computeBarycentricCoordinates=function(e,t,i,r,n,a,o,s,l){var c=i-o,i=o-n,n=a-s,a=r-s,r=1/(n*c+i*a),s=t-s,o=e-o,i=(n*o+i*s)*r,s=(-a*o+c*s)*r,r=1-i-s;return defined(l)?(l.x=i,l.y=s,l.z=r,l):new Cartesian3(i,s,r)},Intersections2D.computeLineSegmentLineSegmentIntersection=function(e,t,i,r,n,a,o,s,l){var c=(o-n)*(t-a)-(s-a)*(e-n),u=(i-e)*(t-a)-(r-t)*(e-n),n=(s-a)*(i-e)-(o-n)*(r-t);if(0!=n){c=c/n,n=u/n;return 0<=c&&c<=1&&0<=n&&n<=1?(defined(l)||(l=new Cartesian2),l.x=e+c*(i-e),l.y=t+c*(r-t),l):void 0}},Object.defineProperties(QuantizedMeshTerrainData.prototype,{credits:{get:function(){return this._credits}},waterMask:{get:function(){return this._waterMask}},childTileMask:{get:function(){return this._childTileMask}},canUpsample:{get:function(){return defined(this._mesh)}}});var arrayScratch=[];function sortIndicesIfNecessary(e,t,i){arrayScratch.length=e.length;for(var r=!1,n=0,a=e.length;n<a;++n)arrayScratch[n]=e[n],r=r||0<n&&0<t(e[n-1],e[n]);return r?(arrayScratch.sort(t),IndexDatatype$1.createTypedArray(i,arrayScratch)):e}var createMeshTaskProcessor=new TaskProcessor("createVerticesFromQuantizedTerrainMesh");QuantizedMeshTerrainData.prototype.createMesh=function(e,t,i,r,h){var n=e.ellipsoid,r=e.tileXYToRectangle(t,i,r);h=defaultValue(h,1);n=createMeshTaskProcessor.scheduleTask({minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,quantizedVertices:this._quantizedVertices,octEncodedNormals:this._encodedNormals,includeWebMercatorT:!0,indices:this._indices,westIndices:this._westIndices,southIndices:this._southIndices,eastIndices:this._eastIndices,northIndices:this._northIndices,westSkirtHeight:this._westSkirtHeight,southSkirtHeight:this._southSkirtHeight,eastSkirtHeight:this._eastSkirtHeight,northSkirtHeight:this._northSkirtHeight,rectangle:r,relativeToCenter:this._boundingSphere.center,ellipsoid:n,exaggeration:h});if(defined(n)){var p=this;return when(n,function(e){var t=p._quantizedVertices.length/3,i=t+p._westIndices.length+p._southIndices.length+p._eastIndices.length+p._northIndices.length,r=IndexDatatype$1.createTypedArray(i,e.indices),n=new Float32Array(e.vertices),a=e.center,o=e.minimumHeight,s=e.maximumHeight,l=defaultValue(BoundingSphere.clone(e.boundingSphere),p._boundingSphere),c=defaultValue(OrientedBoundingBox.clone(e.orientedBoundingBox),p._orientedBoundingBox),u=defaultValue(Cartesian3.clone(e.occludeePointInScaledSpace),p._horizonOcclusionPoint),d=e.vertexStride,i=TerrainEncoding.clone(e.encoding);return p._mesh=new TerrainMesh(a,n,r,e.indexCountWithoutSkirts,t,o,s,l,u,d,c,i,h,e.westIndicesSouthToNorth,e.southIndicesEastToWest,e.eastIndicesNorthToSouth,e.northIndicesWestToEast),p._quantizedVertices=void 0,p._encodedNormals=void 0,p._indices=void 0,p._uValues=void 0,p._vValues=void 0,p._heightValues=void 0,p._westIndices=void 0,p._southIndices=void 0,p._eastIndices=void 0,p._northIndices=void 0,p._mesh})}};var upsampleTaskProcessor=new TaskProcessor("upsampleQuantizedTerrainMesh");QuantizedMeshTerrainData.prototype.upsample=function(e,t,i,r,n,a,o){var s=this._mesh;if(defined(this._mesh)){var l=2*t!==n,t=2*i===a,i=e.ellipsoid,o=e.tileXYToRectangle(n,a,o),i=upsampleTaskProcessor.scheduleTask({vertices:s.vertices,vertexCountWithoutSkirts:s.vertexCountWithoutSkirts,indices:s.indices,indexCountWithoutSkirts:s.indexCountWithoutSkirts,encoding:s.encoding,minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,isEastChild:l,isNorthChild:t,childRectangle:o,ellipsoid:i,exaggeration:s.exaggeration});if(defined(i)){s=Math.min(this._westSkirtHeight,this._eastSkirtHeight),s=Math.min(s,this._southSkirtHeight);s=Math.min(s,this._northSkirtHeight);var c=l?.5*s:this._westSkirtHeight,u=t?.5*s:this._southSkirtHeight,d=l?this._eastSkirtHeight:.5*s,h=t?this._northSkirtHeight:.5*s,p=this._credits;return when(i).then(function(e){var t,i=new Uint16Array(e.vertices),r=IndexDatatype$1.createTypedArray(i.length/3,e.indices);return defined(e.encodedNormals)&&(t=new Uint8Array(e.encodedNormals)),new QuantizedMeshTerrainData({quantizedVertices:i,indices:r,encodedNormals:t,minimumHeight:e.minimumHeight,maximumHeight:e.maximumHeight,boundingSphere:BoundingSphere.clone(e.boundingSphere),orientedBoundingBox:OrientedBoundingBox.clone(e.orientedBoundingBox),horizonOcclusionPoint:Cartesian3.clone(e.horizonOcclusionPoint),westIndices:e.westIndices,southIndices:e.southIndices,eastIndices:e.eastIndices,northIndices:e.northIndices,westSkirtHeight:c,southSkirtHeight:u,eastSkirtHeight:d,northSkirtHeight:h,childTileMask:0,credits:p,createdByUpsampling:!0})})}}};var maxShort=32767,barycentricCoordinateScratch=new Cartesian3;function pointInBoundingBox(e,t,i,r,n,a,o,s){var l=Math.min(i,n,o),n=Math.max(i,n,o),o=Math.min(r,a,s),s=Math.max(r,a,s);return l<=e&&e<=n&&o<=t&&t<=s}QuantizedMeshTerrainData.prototype.interpolateHeight=function(e,t,i){t=CesiumMath.clamp((t-e.west)/e.width,0,1);t*=maxShort;e=CesiumMath.clamp((i-e.south)/e.height,0,1);return e*=maxShort,(defined(this._mesh)?interpolateMeshHeight$1:interpolateHeight$1)(this,t,e)};var texCoordScratch0=new Cartesian2,texCoordScratch1=new Cartesian2,texCoordScratch2=new Cartesian2;function interpolateMeshHeight$1(e,t,i){for(var e=e._mesh,r=e.vertices,n=e.encoding,a=e.indices,o=0,s=a.length;o<s;o+=3){var l=a[o],c=a[o+1],u=a[o+2],d=n.decodeTextureCoordinates(r,l,texCoordScratch0),h=n.decodeTextureCoordinates(r,c,texCoordScratch1),p=n.decodeTextureCoordinates(r,u,texCoordScratch2);if(pointInBoundingBox(t,i,d.x,d.y,h.x,h.y,p.x,p.y)){p=Intersections2D.computeBarycentricCoordinates(t,i,d.x,d.y,h.x,h.y,p.x,p.y,barycentricCoordinateScratch);if(-1e-15<=p.x&&-1e-15<=p.y&&-1e-15<=p.z){l=n.decodeHeight(r,l),c=n.decodeHeight(r,c),u=n.decodeHeight(r,u);return p.x*l+p.y*c+p.z*u}}}}function interpolateHeight$1(e,t,i){for(var r=e._uValues,n=e._vValues,a=e._heightValues,o=e._indices,s=0,l=o.length;s<l;s+=3){var c=o[s],u=o[s+1],d=o[s+2],h=r[c],p=r[u],m=r[d],f=n[c],g=n[u],_=n[d];if(pointInBoundingBox(t,i,h,f,p,g,m,_)){_=Intersections2D.computeBarycentricCoordinates(t,i,h,f,p,g,m,_,barycentricCoordinateScratch);if(-1e-15<=_.x&&-1e-15<=_.y&&-1e-15<=_.z){d=_.x*a[c]+_.y*a[u]+_.z*a[d];return CesiumMath.lerp(e._minimumHeight,e._maximumHeight,d/maxShort)}}}}function LayerInformation(e){this.resource=e.resource,this.version=e.version,this.isHeightmap=e.isHeightmap,this.tileUrlTemplates=e.tileUrlTemplates,this.availability=e.availability,this.hasVertexNormals=e.hasVertexNormals,this.hasWaterMask=e.hasWaterMask,this.hasMetadata=e.hasMetadata,this.availabilityLevels=e.availabilityLevels,this.availabilityTilesLoaded=e.availabilityTilesLoaded,this.littleEndianExtensionSize=e.littleEndianExtensionSize,this.availabilityPromiseCache={}}function CesiumTerrainProvider(e){this._heightmapWidth=65,this._heightmapStructure=void 0,this._hasWaterMask=!1,this._hasVertexNormals=!1,this._ellipsoid=e.ellipsoid,this._requestVertexNormals=defaultValue(e.requestVertexNormals,!1),this._requestWaterMask=defaultValue(e.requestWaterMask,!1),this._requestMetadata=defaultValue(e.requestMetadata,!0),this._errorEvent=new Event;var t=e.credit;"string"==typeof t&&(t=new Credit(t)),this._credit=t,this._availability=void 0;var i=when.defer();this._ready=!1,this._readyPromise=i,this._tileCredits=void 0;var C,v,S,T=this,x=this._layers=[],b="",E=[],P=0;function A(e){if(!e.format)return u="The tile format is not specified in the layer.json file.",void(S=TileProviderError.handleError(S,T,T._errorEvent,u,void 0,void 0,void 0,D));if(!e.tiles||0===e.tiles.length)return u="The layer.json file does not specify any tile URL templates.",void(S=TileProviderError.handleError(S,T,T._errorEvent,u,void 0,void 0,void 0,D));var t=!1,i=!1,r=!1,n=!0,a=!1;if("heightmap-1.0"===e.format)a=!0,defined(T._heightmapStructure)||(T._heightmapStructure={heightScale:.2,heightOffset:-1e3,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1,lowestEncodedHeight:0,highestEncodedHeight:65535}),i=!0,T._requestWaterMask=!0;else if(0!==e.format.indexOf("quantized-mesh-1."))return u='The tile format "'+e.format+'" is invalid or not supported.',void(S=TileProviderError.handleError(S,T,T._errorEvent,u,void 0,void 0,void 0,D));var o,s=e.tiles,l=e.maxzoom;if(P=Math.max(P,l),e.projection&&"EPSG:4326"!==e.projection){if("EPSG:3857"!==e.projection)return u='The projection "'+e.projection+'" is invalid or not supported.',void(S=TileProviderError.handleError(S,T,T._errorEvent,u,void 0,void 0,void 0,D));T._tilingScheme=new WebMercatorTilingScheme({numberOfLevelZeroTilesX:1,numberOfLevelZeroTilesY:1,ellipsoid:T._ellipsoid})}else T._tilingScheme=new GeographicTilingScheme({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:1,ellipsoid:T._ellipsoid});if(T._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(T._tilingScheme.ellipsoid,T._heightmapWidth,T._tilingScheme.getNumberOfXTilesAtLevel(0)),e.scheme&&"tms"!==e.scheme&&"slippyMap"!==e.scheme)return u='The scheme "'+e.scheme+'" is invalid or not supported.',void(S=TileProviderError.handleError(S,T,T._errorEvent,u,void 0,void 0,void 0,D));T._scheme=e.scheme,defined(e.extensions)&&-1!==e.extensions.indexOf("octvertexnormals")?t=!0:defined(e.extensions)&&-1!==e.extensions.indexOf("vertexnormals")&&(n=!(t=!0)),defined(e.extensions)&&-1!==e.extensions.indexOf("watermask")&&(i=!0),defined(e.extensions)&&-1!==e.extensions.indexOf("metadata")&&(r=!0);var c,u=e.metadataAvailability,d=e.available;if(defined(d)&&!defined(u)){c=new TileAvailability(T._tilingScheme,d.length);for(var h=0;h<d.length;++h){var p=d[h],m=T._tilingScheme.getNumberOfYTilesAtLevel(h);defined(E[h])||(E[h]=[]);for(var f=0;f<p.length;++f){var g=p[f],_=m-g.endY-1,y=m-g.startY-1;E[h].push([g.startX,_,g.endX,y]),c.addAvailableTileRange(h,g.startX,_,g.endX,y)}}}else defined(u)&&(o=new TileAvailability(T._tilingScheme,l),c=new TileAvailability(T._tilingScheme,l),E[0]=[[0,0,1,0]],c.addAvailableTileRange(0,0,0,1,0));T._hasWaterMask=T._hasWaterMask||i,T._hasVertexNormals=T._hasVertexNormals||t,T._hasMetadata=T._hasMetadata||r,defined(e.attribution)&&(0<b.length&&(b+=" "),b+=e.attribution),x.push(new LayerInformation({resource:C,version:e.version,isHeightmap:a,tileUrlTemplates:s,availability:c,hasVertexNormals:t,hasWaterMask:i,hasMetadata:r,availabilityLevels:u,availabilityTilesLoaded:o,littleEndianExtensionSize:n}));e=e.parentUrl;return defined(e)?defined(c)?((C=C.getDerivedResource({url:e})).appendForwardSlash(),when((v=C.getDerivedResource({url:"layer.json"})).fetchJson(),A,w)):(console.log("A layer.json can't have a parentUrl if it does't have an available array."),when.resolve()):when.resolve()}function w(e){var t="An error occurred while accessing "+v.url+".";S=TileProviderError.handleError(S,T,T._errorEvent,t,void 0,void 0,void 0,D)}function r(e){A(e).then(function(){if(!defined(S)){var e,t=E.length;if(0<t)for(var i=T._availability=new TileAvailability(T._tilingScheme,P),r=0;r<t;++r)for(var n=E[r],a=0;a<n.length;++a){var o=n[a];i.addAvailableTileRange(r,o[0],o[1],o[2],o[3])}0<b.length&&(e=new Credit(b),defined(T._tileCredits)?T._tileCredits.push(e):T._tileCredits=[e]),T._ready=!0,T._readyPromise.resolve(!0)}})}function n(e){defined(e)&&404===e.statusCode?r({tilejson:"2.1.0",format:"heightmap-1.0",version:"1.0.0",scheme:"tms",tiles:["{z}/{x}/{y}.terrain?v={version}"]}):w()}function D(){when(v.fetchJson()).then(r).otherwise(n)}when(e.url).then(function(e){e=Resource.createIfNeeded(e);e.appendForwardSlash(),v=(C=e).getDerivedResource({url:"layer.json"}),T._tileCredits=e.credits,D()}).otherwise(function(e){i.reject(e)})}QuantizedMeshTerrainData.prototype.isChildAvailable=function(e,t,i,r){var n=2;return i!==2*e&&++n,r!==2*t&&(n-=2),0!=(this._childTileMask&1<<n)},QuantizedMeshTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};var QuantizedMeshExtensionIds={OCT_VERTEX_NORMALS:1,WATER_MASK:2,METADATA:4};function getRequestHeader(e){return defined(e)&&0!==e.length?{Accept:"application/vnd.quantized-mesh;extensions="+e.join("-")+",application/octet-stream;q=0.9,*/*;q=0.01"}:{Accept:"application/vnd.quantized-mesh,application/octet-stream;q=0.9,*/*;q=0.01"}}function createHeightmapTerrainData(e,t,i,r,n){var a=new Uint16Array(t,0,e._heightmapWidth*e._heightmapWidth);return new HeightmapTerrainData({buffer:a,childTileMask:new Uint8Array(t,a.byteLength,1)[0],waterMask:new Uint8Array(t,a.byteLength+1,t.byteLength-a.byteLength-1),width:e._heightmapWidth,height:e._heightmapWidth,structure:e._heightmapStructure,credits:e._tileCredits})}function createQuantizedMeshTerrainData(e,t,i,r,n,a){var o=a.littleEndianExtensionSize,s=0,l=3*Float64Array.BYTES_PER_ELEMENT,c=4*Float64Array.BYTES_PER_ELEMENT,u=3*Uint16Array.BYTES_PER_ELEMENT,d=Uint16Array.BYTES_PER_ELEMENT,h=3*d,p=new DataView(t),m=new Cartesian3(p.getFloat64(s,!0),p.getFloat64(s+8,!0),p.getFloat64(s+16,!0));s+=l;var f=p.getFloat32(s,!0);s+=Float32Array.BYTES_PER_ELEMENT;var g=p.getFloat32(s,!0);s+=Float32Array.BYTES_PER_ELEMENT;var _=new BoundingSphere(new Cartesian3(p.getFloat64(s,!0),p.getFloat64(s+8,!0),p.getFloat64(s+16,!0)),p.getFloat64(s+l,!0));s+=c;var y=new Cartesian3(p.getFloat64(s,!0),p.getFloat64(s+8,!0),p.getFloat64(s+16,!0));s+=l;var C=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;var v=new Uint16Array(t,s,3*C);s+=C*u,65536<C&&(h=3*(d=Uint32Array.BYTES_PER_ELEMENT));var S=v.subarray(0,C),c=v.subarray(C,2*C),l=v.subarray(2*C,3*C);AttributeCompression.zigZagDeltaDecode(S,c,l),s%d!=0&&(s+=d-s%d);u=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;var T=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,3*u);s+=u*h;for(var x=0,b=T.length,E=0;E<b;++E){var P=T[E];T[E]=x-P,0===P&&++x}S=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;c=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,S);s+=S*d;l=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;u=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,l);s+=l*d;h=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;S=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,h);s+=h*d;l=p.getUint32(s,!0);s+=Uint32Array.BYTES_PER_ELEMENT;var A,w,h=IndexDatatype$1.createTypedArrayFromArrayBuffer(C,t,s,l);for(s+=l*d;s<p.byteLength;){var D=p.getUint8(s,!0);s+=Uint8Array.BYTES_PER_ELEMENT;var M=p.getUint32(s,o);if(s+=Uint32Array.BYTES_PER_ELEMENT,D===QuantizedMeshExtensionIds.OCT_VERTEX_NORMALS&&e._requestVertexNormals)A=new Uint8Array(t,s,2*C);else if(D===QuantizedMeshExtensionIds.WATER_MASK&&e._requestWaterMask)w=new Uint8Array(t,s,M);else if(D===QuantizedMeshExtensionIds.METADATA&&e._requestMetadata){D=p.getUint32(s,!0);if(0<D){var D=getStringFromTypedArray(new Uint8Array(t),s+Uint32Array.BYTES_PER_ELEMENT,D),I=JSON.parse(D).available;if(defined(I))for(var R=0;R<I.length;++R)for(var O=i+R+1,L=I[R],F=e._tilingScheme.getNumberOfYTilesAtLevel(O),N=0;N<L.length;++N){var B=L[N],V=F-B.endY-1,k=F-B.startY-1;e.availability.addAvailableTileRange(O,B.startX,V,B.endX,k),a.availability.addAvailableTileRange(O,B.startX,V,B.endX,k)}}a.availabilityTilesLoaded.addAvailableTileRange(i,r,n,r,n)}s+=M}l=5*e.getLevelMaximumGeometricError(i),d=e._tilingScheme.tileXYToRectangle(r,n,i);return new QuantizedMeshTerrainData({center:m,minimumHeight:f,maximumHeight:g,boundingSphere:_,orientedBoundingBox:OrientedBoundingBox.fromRectangle(d,f,g,e._tilingScheme.ellipsoid),horizonOcclusionPoint:y,quantizedVertices:v,encodedNormals:A,indices:T,westIndices:c,southIndices:u,eastIndices:S,northIndices:h,westSkirtHeight:l,southSkirtHeight:l,eastSkirtHeight:l,northSkirtHeight:l,childTileMask:e.availability.computeChildMaskForTile(i,r,n),waterMask:w,credits:e._tileCredits})}function requestTileGeometry(t,i,r,n,a,e){if(!defined(a))return when.reject(new RuntimeError("Terrain tile doesn't exist"));var o,s=a.tileUrlTemplates;if(0!==s.length){o=t._scheme&&"tms"!==t._scheme?r:t._tilingScheme.getNumberOfYTilesAtLevel(n)-r-1;var l,c=[];t._requestVertexNormals&&a.hasVertexNormals&&c.push(a.littleEndianExtensionSize?"octvertexnormals":"vertexnormals"),t._requestWaterMask&&a.hasWaterMask&&c.push("watermask"),t._requestMetadata&&a.hasMetadata&&c.push("metadata");var u=s[(i+o+n)%s.length],s=a.resource,c=defined(s._ionEndpoint)&&!defined(s._ionEndpoint.externalType)?(0!==c.length&&(l={extensions:c.join("-")}),getRequestHeader(void 0)):getRequestHeader(c),e=s.getDerivedResource({url:u,templateValues:{version:a.version,z:n,x:i,y:o},queryParameters:l,headers:c,request:e}).fetchArrayBuffer();if(defined(e))return e.then(function(e){return defined(t._heightmapStructure)?createHeightmapTerrainData(t,e):createQuantizedMeshTerrainData(t,e,n,i,r,a)})}}function getAvailabilityTile(e,t,i,r){if(0!==r){e=e.availabilityLevels,e=r%e==0?r-e:(r/e|0)*e,r=1<<r-e;return{level:e,x:t/r|0,y:i/r|0}}}function checkLayer(e,t,i,r,n,a){if(!defined(n.availabilityLevels))return{result:!1};for(var o,s,l,c=function(){delete n.availabilityPromiseCache[l]},u=n.availabilityTilesLoaded,d=n.availability,h=getAvailabilityTile(n,t,i,r);defined(h);){if(d.isTileAvailable(h.level,h.x,h.y)&&!u.isTileAvailable(h.level,h.x,h.y))return a||(l=h.level+"-"+h.x+"-"+h.y,defined(s=n.availabilityPromiseCache[l])||(o=new Request({throttle:!1,throttleByServer:!0,type:RequestType$1.TERRAIN}),defined(s=requestTileGeometry(e,h.x,h.y,h.level,n,o))&&(n.availabilityPromiseCache[l]=s).then(c))),{result:!0,promise:s};h=getAvailabilityTile(n,h.x,h.y,h.level)}return{result:!1}}CesiumTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){var n,a=this._layers,o=a.length;if(1===o)n=a[0];else for(var s=0;s<o;++s){var l=a[s];if(!defined(l.availability)||l.availability.isTileAvailable(i,e,t)){n=l;break}}return requestTileGeometry(this,e,t,i,n,r)},Object.defineProperties(CesiumTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},hasWaterMask:{get:function(){return this._hasWaterMask&&this._requestWaterMask}},hasVertexNormals:{get:function(){return this._hasVertexNormals&&this._requestVertexNormals}},hasMetadata:{get:function(){return this._hasMetadata&&this._requestMetadata}},requestVertexNormals:{get:function(){return this._requestVertexNormals}},requestWaterMask:{get:function(){return this._requestWaterMask}},requestMetadata:{get:function(){return this._requestMetadata}},availability:{get:function(){return this._availability}}}),CesiumTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},CesiumTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){if(defined(this._availability)){if(i>this._availability._maximumLevel)return!1;if(this._availability.isTileAvailable(i,e,t))return!0;if(!this._hasMetadata)return!1;for(var r=this._layers,n=r.length,a=0;a<n;++a)if(checkLayer(this,e,t,i,r[a],0===a).result)return;return!1}},CesiumTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){if(!(!defined(this._availability)||i>this._availability._maximumLevel||this._availability.isTileAvailable(i,e,t))&&this._hasMetadata)for(var r=this._layers,n=r.length,a=0;a<n;++a){var o=checkLayer(this,e,t,i,r[a],0===a);if(defined(o.promise))return o.promise}},CesiumTerrainProvider._getAvailabilityTile=getAvailabilityTile;var EllipseGeometryLibrary={},rotAxis=new Cartesian3,tempVec=new Cartesian3,unitQuat=new Quaternion,rotMtx=new Matrix3;function pointOnEllipsoid(e,t,i,r,n,a,o,s,l,c){t=e+t;Cartesian3.multiplyByScalar(r,Math.cos(t),rotAxis),Cartesian3.multiplyByScalar(i,Math.sin(t),tempVec),Cartesian3.add(rotAxis,tempVec,rotAxis);t=Math.cos(e);t*=t;e=Math.sin(e);e*=e;e=a/Math.sqrt(o*t+n*e)/s;return Quaternion.fromAxisAngle(rotAxis,e,unitQuat),Matrix3.fromQuaternion(unitQuat,rotMtx),Matrix3.multiplyByVector(rotMtx,l,c),Cartesian3.normalize(c,c),Cartesian3.multiplyByScalar(c,s,c),c}var scratchCartesian1$1=new Cartesian3,scratchCartesian2$1=new Cartesian3,scratchCartesian3$2=new Cartesian3,scratchNormal$1=new Cartesian3;EllipseGeometryLibrary.raisePositionsToHeight=function(e,t,i){for(var r=t.ellipsoid,n=t.height,a=t.extrudedHeight,t=i?e.length/3*2:e.length/3,o=new Float64Array(3*t),s=e.length,l=i?s:0,c=0;c<s;c+=3){var u=c+1,d=c+2,h=Cartesian3.fromArray(e,c,scratchCartesian1$1);r.scaleToGeodeticSurface(h,h);var p=Cartesian3.clone(h,scratchCartesian2$1),m=r.geodeticSurfaceNormal(h,scratchNormal$1),f=Cartesian3.multiplyByScalar(m,n,scratchCartesian3$2);Cartesian3.add(h,f,h),i&&(Cartesian3.multiplyByScalar(m,a,f),Cartesian3.add(p,f,p),o[c+l]=p.x,o[u+l]=p.y,o[d+l]=p.z),o[c]=h.x,o[u]=h.y,o[d]=h.z}return o};var unitPosScratch=new Cartesian3,eastVecScratch=new Cartesian3,northVecScratch=new Cartesian3;function GeometryInstance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.geometry=e.geometry,this.modelMatrix=Matrix4.clone(defaultValue(e.modelMatrix,Matrix4.IDENTITY)),this.id=e.id,this.pickPrimitive=e.pickPrimitive,this.attributes=defaultValue(e.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}EllipseGeometryLibrary.computeEllipsePositions=function(e,t,i){var r=e.semiMinorAxis,n=e.semiMajorAxis,a=e.rotation,o=e.center,e=8*e.granularity,s=r*r,l=n*n,c=n*r,u=Cartesian3.magnitude(o),d=Cartesian3.normalize(o,unitPosScratch),h=Cartesian3.cross(Cartesian3.UNIT_Z,o,eastVecScratch),h=Cartesian3.normalize(h,h),p=Cartesian3.cross(d,h,northVecScratch),m=1+Math.ceil(CesiumMath.PI_OVER_TWO/e),f=CesiumMath.PI_OVER_TWO/(m-1),g=CesiumMath.PI_OVER_TWO-m*f;g<0&&(m-=Math.ceil(Math.abs(g)/f));var _,y,C,v,S,T=t?new Array(3*(m*(m+2)*2)):void 0,x=0,b=scratchCartesian1$1,E=scratchCartesian2$1,e=4*m*3,P=e-1,A=0,w=i?new Array(e):void 0,b=pointOnEllipsoid(g=CesiumMath.PI_OVER_TWO,a,p,h,s,c,l,u,d,b);for(t&&(T[x++]=b.x,T[x++]=b.y,T[x++]=b.z),i&&(w[P--]=b.z,w[P--]=b.y,w[P--]=b.x),g=CesiumMath.PI_OVER_TWO-f,_=1;_<m+1;++_){if(b=pointOnEllipsoid(g,a,p,h,s,c,l,u,d,b),E=pointOnEllipsoid(Math.PI-g,a,p,h,s,c,l,u,d,E),t){for(T[x++]=b.x,T[x++]=b.y,T[x++]=b.z,C=2*_+2,y=1;y<C-1;++y)v=y/(C-1),S=Cartesian3.lerp(b,E,v,scratchCartesian3$2),T[x++]=S.x,T[x++]=S.y,T[x++]=S.z;T[x++]=E.x,T[x++]=E.y,T[x++]=E.z}i&&(w[P--]=b.z,w[P--]=b.y,w[P--]=b.x,w[A++]=E.x,w[A++]=E.y,w[A++]=E.z),g=CesiumMath.PI_OVER_TWO-(_+1)*f}for(_=m;1<_;--_){if(b=pointOnEllipsoid(-(g=CesiumMath.PI_OVER_TWO-(_-1)*f),a,p,h,s,c,l,u,d,b),E=pointOnEllipsoid(g+Math.PI,a,p,h,s,c,l,u,d,E),t){for(T[x++]=b.x,T[x++]=b.y,T[x++]=b.z,C=2*(_-1)+2,y=1;y<C-1;++y)v=y/(C-1),S=Cartesian3.lerp(b,E,v,scratchCartesian3$2),T[x++]=S.x,T[x++]=S.y,T[x++]=S.z;T[x++]=E.x,T[x++]=E.y,T[x++]=E.z}i&&(w[P--]=b.z,w[P--]=b.y,w[P--]=b.x,w[A++]=E.x,w[A++]=E.y,w[A++]=E.z)}b=pointOnEllipsoid(-(g=CesiumMath.PI_OVER_TWO),a,p,h,s,c,l,u,d,b);e={};return t&&(T[x++]=b.x,T[x++]=b.y,T[x++]=b.z,e.positions=T,e.numPts=m),i&&(w[P--]=b.z,w[P--]=b.y,w[P--]=b.x,e.outerPositions=w),e};var scratchCartesian1$2=new Cartesian3,scratchCartesian2$2=new Cartesian3,scratchCartesian3$3=new Cartesian3;function barycentricCoordinates(e,t,i,r,n){var a,o,s,l,c,u,d;if(defined(n)||(n=new Cartesian3),defined(t.z)){if(Cartesian3.equalsEpsilon(e,t,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_X,n);if(Cartesian3.equalsEpsilon(e,i,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Y,n);if(Cartesian3.equalsEpsilon(e,r,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Z,n);a=Cartesian3.subtract(i,t,scratchCartesian1$2),o=Cartesian3.subtract(r,t,scratchCartesian2$2),s=Cartesian3.subtract(e,t,scratchCartesian3$3),l=Cartesian3.dot(a,a),h=Cartesian3.dot(a,o),c=Cartesian3.dot(a,s),u=Cartesian3.dot(o,o),d=Cartesian3.dot(o,s)}else{if(Cartesian2.equalsEpsilon(e,t,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_X,n);if(Cartesian2.equalsEpsilon(e,i,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Y,n);if(Cartesian2.equalsEpsilon(e,r,CesiumMath.EPSILON14))return Cartesian3.clone(Cartesian3.UNIT_Z,n);a=Cartesian2.subtract(i,t,scratchCartesian1$2),o=Cartesian2.subtract(r,t,scratchCartesian2$2),s=Cartesian2.subtract(e,t,scratchCartesian3$3),l=Cartesian2.dot(a,a),h=Cartesian2.dot(a,o),c=Cartesian2.dot(a,s),u=Cartesian2.dot(o,o),d=Cartesian2.dot(o,s)}n.y=u*c-h*d,n.z=l*d-h*c;var h=l*u-h*h;return 0!==n.y&&(n.y/=h),0!==n.z&&(n.z/=h),n.x=1-n.y-n.z,n}function EncodedCartesian3(){this.high=Cartesian3.clone(Cartesian3.ZERO),this.low=Cartesian3.clone(Cartesian3.ZERO)}EncodedCartesian3.encode=function(e,t){var i;return defined(t)||(t={high:0,low:0}),0<=e?(i=65536*Math.floor(e/65536),t.high=i,t.low=e-i):(i=65536*Math.floor(-e/65536),t.high=-i,t.low=e+i),t};var scratchEncode={high:0,low:0};EncodedCartesian3.fromCartesian=function(e,t){defined(t)||(t=new EncodedCartesian3);var i=t.high,r=t.low;return EncodedCartesian3.encode(e.x,scratchEncode),i.x=scratchEncode.high,r.x=scratchEncode.low,EncodedCartesian3.encode(e.y,scratchEncode),i.y=scratchEncode.high,r.y=scratchEncode.low,EncodedCartesian3.encode(e.z,scratchEncode),i.z=scratchEncode.high,r.z=scratchEncode.low,t};var encodedP=new EncodedCartesian3;EncodedCartesian3.writeElements=function(e,t,i){EncodedCartesian3.fromCartesian(e,encodedP);var r=encodedP.high,e=encodedP.low;t[i]=r.x,t[i+1]=r.y,t[i+2]=r.z,t[i+3]=e.x,t[i+4]=e.y,t[i+5]=e.z};var Tipsify={calculateACMR:function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).indices,i=e.maximumIndex,r=defaultValue(e.cacheSize,24),n=t.length;if(!defined(i))for(var a=i=0,o=t[a];a<n;)i<o&&(i=o),o=t[++a];for(var s=[],l=0;l<i+1;l++)s[l]=0;for(var c=r+1,u=0;u<n;++u)c-s[t[u]]>r&&(s[t[u]]=c,++c);return(c-r+1)/(n/3)}};Tipsify.tipsify=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).indices,i=e.maximumIndex,r=defaultValue(e.cacheSize,24);function n(e,t,i,r,n,a,o){for(var s,l=-1,c=-1,u=0;u<i.length;){var d=i[u];r[d].numLiveTriangles&&(s=0,n-r[d].timeStamp+2*r[d].numLiveTriangles<=t&&(s=n-r[d].timeStamp),(c<s||-1===c)&&(c=s,l=d)),++u}return-1===l?function(e,t,i){for(;1<=t.length;){var r=t[t.length-1];if(t.splice(t.length-1,1),0<e[r].numLiveTriangles)return r}for(;_<i;){if(0<e[_].numLiveTriangles)return++_-1;++_}return-1}(r,a,o):l}var e=t.length,a=0,o=0,s=t[o],l=e;if(defined(i))a=i+1;else{for(;o<l;)a<s&&(a=s),s=t[++o];if(-1===a)return 0;++a}for(var c=[],u=0;u<a;u++)c[u]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};for(var d=o=0;o<l;)c[t[o]].vertexTriangles.push(d),++c[t[o]].numLiveTriangles,c[t[o+1]].vertexTriangles.push(d),++c[t[o+1]].numLiveTriangles,c[t[o+2]].vertexTriangles.push(d),++c[t[o+2]].numLiveTriangles,++d,o+=3;var h,p,m,f=0,g=r+1,_=1,y=[],C=[],v=0,S=[],T=e/3,x=[];for(u=0;u<T;u++)x[u]=!1;for(;-1!==f;){y=[],m=(h=c[f]).vertexTriangles.length;for(var b=0;b<m;++b)if(!x[d=h.vertexTriangles[b]]){x[d]=!0,o=d+d+d;for(var E=0;E<3;++E)p=t[o],y.push(p),C.push(p),S[v]=p,++v,--(p=c[p]).numLiveTriangles,g-p.timeStamp>r&&(p.timeStamp=g,++g),++o}f=n(0,r,y,c,g,C,a)}return S};var GeometryPipeline={};function addTriangle(e,t,i,r,n){e[t++]=i,e[t++]=r,e[t++]=r,e[t++]=n,e[t++]=n,e[t]=i}function trianglesToLines(e){for(var t=e.length,i=t/3*6,r=IndexDatatype$1.createTypedArray(t,i),n=0,a=0;a<t;a+=3,n+=6)addTriangle(r,n,e[a],e[a+1],e[a+2]);return r}function triangleStripToLines(e){var t=e.length;if(3<=t){var i=6*(t-2),r=IndexDatatype$1.createTypedArray(t,i);addTriangle(r,0,e[0],e[1],e[2]);for(var n=6,a=3;a<t;++a,n+=6)addTriangle(r,n,e[a-1],e[a],e[a-2]);return r}return new Uint16Array}function triangleFanToLines(e){if(0<e.length){for(var t=e.length-1,i=6*(t-1),r=IndexDatatype$1.createTypedArray(t,i),n=e[0],a=0,o=1;o<t;++o,a+=6)addTriangle(r,a,n,e[o],e[o+1]);return r}return new Uint16Array}function copyAttributesDescriptions(e){var t,i,r={};for(t in e)e.hasOwnProperty(t)&&defined(e[t])&&defined(e[t].values)&&(i=e[t],r[t]=new GeometryAttribute({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]}));return r}function copyVertex(e,t,i){for(var r in t)if(t.hasOwnProperty(r)&&defined(t[r])&&defined(t[r].values))for(var n=t[r],a=0;a<n.componentsPerAttribute;++a)e[r].values.push(n.values[i*n.componentsPerAttribute+a])}GeometryPipeline.toWireframe=function(e){var t=e.indices;if(defined(t)){switch(e.primitiveType){case PrimitiveType$1.TRIANGLES:e.indices=trianglesToLines(t);break;case PrimitiveType$1.TRIANGLE_STRIP:e.indices=triangleStripToLines(t);break;case PrimitiveType$1.TRIANGLE_FAN:e.indices=triangleFanToLines(t)}e.primitiveType=PrimitiveType$1.LINES}return e},GeometryPipeline.createLineSegmentsForVectors=function(e,t,i){t=defaultValue(t,"normal"),i=defaultValue(i,1e4);for(var r,n=e.attributes.position.values,a=e.attributes[t].values,o=n.length,s=new Float64Array(2*o),l=0,c=0;c<o;c+=3)s[l++]=n[c],s[l++]=n[c+1],s[l++]=n[c+2],s[l++]=n[c]+a[c]*i,s[l++]=n[c+1]+a[c+1]*i,s[l++]=n[c+2]+a[c+2]*i;e=e.boundingSphere;return defined(e)&&(r=new BoundingSphere(e.center,e.radius+i)),new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:s})},primitiveType:PrimitiveType$1.LINES,boundingSphere:r})},GeometryPipeline.createAttributeLocations=function(e){for(var t,i=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],r=e.attributes,n={},a=0,o=i.length,s=0;s<o;++s){var l=i[s];defined(r[l])&&(n[l]=a++)}for(t in r)r.hasOwnProperty(t)&&!defined(n[t])&&(n[t]=a++);return n},GeometryPipeline.reorderForPreVertexCache=function(e){var t=Geometry.computeNumberOfVertices(e),i=e.indices;if(defined(i)){for(var r=new Int32Array(t),n=0;n<t;n++)r[n]=-1;for(var a,o=i,s=o.length,l=IndexDatatype$1.createTypedArray(t,s),c=0,u=0,d=0;c<s;)-1!==(a=r[o[c]])?l[u]=a:(r[a=o[c]]=d,l[u]=d,++d),++c,++u;e.indices=l;var h,p=e.attributes;for(h in p)if(p.hasOwnProperty(h)&&defined(p[h])&&defined(p[h].values)){for(var m=p[h],f=m.values,g=0,_=m.componentsPerAttribute,y=ComponentDatatype$1.createTypedArray(m.componentDatatype,d*_);g<t;){var C=r[g];if(-1!==C)for(var v=0;v<_;v++)y[_*C+v]=f[_*g+v];++g}m.values=y}}return e},GeometryPipeline.reorderForPostVertexCache=function(e,t){var i=e.indices;if(e.primitiveType===PrimitiveType$1.TRIANGLES&&defined(i)){for(var r=i.length,n=0,a=0;a<r;a++)i[a]>n&&(n=i[a]);e.indices=Tipsify.tipsify({indices:i,maximumIndex:n,cacheSize:t})}return e},GeometryPipeline.fitToUnsignedShortIndices=function(e){var t=[],i=Geometry.computeNumberOfVertices(e);if(defined(e.indices)&&i>=CesiumMath.SIXTY_FOUR_KILOBYTES){var r,n=[],a=[],o=0,s=copyAttributesDescriptions(e.attributes),l=e.indices,c=l.length;e.primitiveType===PrimitiveType$1.TRIANGLES?r=3:e.primitiveType===PrimitiveType$1.LINES?r=2:e.primitiveType===PrimitiveType$1.POINTS&&(r=1);for(var u=0;u<c;u+=r){for(var d=0;d<r;++d){var h=l[u+d],p=n[h];defined(p)||(p=o++,n[h]=p,copyVertex(s,e.attributes,h)),a.push(p)}o+r>=CesiumMath.SIXTY_FOUR_KILOBYTES&&(t.push(new Geometry({attributes:s,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),n=[],a=[],o=0,s=copyAttributesDescriptions(e.attributes))}0!==a.length&&t.push(new Geometry({attributes:s,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var scratchProjectTo2DCartesian3=new Cartesian3,scratchProjectTo2DCartographic=new Cartographic;GeometryPipeline.projectTo2D=function(e,t,i,r,n){for(var a=e.attributes[t],o=(n=defined(n)?n:new GeographicProjection).ellipsoid,s=a.values,l=new Float64Array(s.length),c=0,u=0;u<s.length;u+=3){var d=Cartesian3.fromArray(s,u,scratchProjectTo2DCartesian3),d=o.cartesianToCartographic(d,scratchProjectTo2DCartographic),d=n.project(d,scratchProjectTo2DCartesian3);l[c++]=d.x,l[c++]=d.y,l[c++]=d.z}return e.attributes[i]=a,e.attributes[r]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l}),delete e.attributes[t],e};var encodedResult={high:0,low:0};GeometryPipeline.encodeAttribute=function(e,t,i,r){for(var n=e.attributes[t],a=n.values,o=a.length,s=new Float32Array(o),l=new Float32Array(o),c=0;c<o;++c)EncodedCartesian3.encode(a[c],encodedResult),s[c]=encodedResult.high,l[c]=encodedResult.low;n=n.componentsPerAttribute;return e.attributes[i]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:n,values:s}),e.attributes[r]=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:n,values:l}),delete e.attributes[t],e};var scratchCartesian3$4=new Cartesian3;function transformPoint(e,t){if(defined(t))for(var i=t.values,r=i.length,n=0;n<r;n+=3)Cartesian3.unpack(i,n,scratchCartesian3$4),Matrix4.multiplyByPoint(e,scratchCartesian3$4,scratchCartesian3$4),Cartesian3.pack(scratchCartesian3$4,i,n)}function transformVector(e,t){if(defined(t))for(var i=t.values,r=i.length,n=0;n<r;n+=3)Cartesian3.unpack(i,n,scratchCartesian3$4),Matrix3.multiplyByVector(e,scratchCartesian3$4,scratchCartesian3$4),scratchCartesian3$4=Cartesian3.normalize(scratchCartesian3$4,scratchCartesian3$4),Cartesian3.pack(scratchCartesian3$4,i,n)}var inverseTranspose=new Matrix4,normalMatrix=new Matrix3;function findAttributesInAllGeometries(e,t){var i,r=e.length,n={},a=e[0][t].attributes;for(i in a)if(a.hasOwnProperty(i)&&defined(a[i])&&defined(a[i].values)){for(var o=a[i],s=o.values.length,l=!0,c=1;c<r;++c){var u=e[c][t].attributes[i];if(!defined(u)||o.componentDatatype!==u.componentDatatype||o.componentsPerAttribute!==u.componentsPerAttribute||o.normalize!==u.normalize){l=!1;break}s+=u.values.length}l&&(n[i]=new GeometryAttribute({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:ComponentDatatype$1.createTypedArray(o.componentDatatype,s)}))}return n}GeometryPipeline.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(Matrix4.equals(t,Matrix4.IDENTITY))return e;var i=e.geometry.attributes;transformPoint(t,i.position),transformPoint(t,i.prevPosition),transformPoint(t,i.nextPosition),(defined(i.normal)||defined(i.tangent)||defined(i.bitangent))&&(Matrix4.inverse(t,inverseTranspose),Matrix4.transpose(inverseTranspose,inverseTranspose),Matrix4.getMatrix3(inverseTranspose,normalMatrix),transformVector(normalMatrix,i.normal),transformVector(normalMatrix,i.tangent),transformVector(normalMatrix,i.bitangent));i=e.geometry.boundingSphere;return defined(i)&&(e.geometry.boundingSphere=BoundingSphere.transform(i,t,i)),e.modelMatrix=Matrix4.clone(Matrix4.IDENTITY),e};var tempScratch=new Cartesian3;function combineGeometries(e,t){var i,r,n,a,o,s=e.length,l=(e[0].modelMatrix,defined(e[0][t].indices)),c=e[0][t].primitiveType,u=findAttributesInAllGeometries(e,t);for(i in u)if(u.hasOwnProperty(i))for(n=u[i].values,h=C=0;h<s;++h)for(o=(a=e[h][t].attributes[i].values).length,r=0;r<o;++r)n[C++]=a[r];if(l){for(var d=0,h=0;h<s;++h)d+=e[h][t].indices.length;var p=Geometry.computeNumberOfVertices(new Geometry({attributes:u,primitiveType:PrimitiveType$1.POINTS})),m=IndexDatatype$1.createTypedArray(p,d),f=0,g=0;for(h=0;h<s;++h){for(var _=e[h][t].indices,y=_.length,C=0;C<y;++C)m[f++]=g+_[C];g+=Geometry.computeNumberOfVertices(e[h][t])}p=m}var v,S=new Cartesian3,T=0;for(h=0;h<s;++h){if(!defined(v=e[h][t].boundingSphere)){S=void 0;break}Cartesian3.add(v.center,S,S)}if(defined(S))for(Cartesian3.divideByScalar(S,s,S),h=0;h<s;++h){v=e[h][t].boundingSphere;var x=Cartesian3.magnitude(Cartesian3.subtract(v.center,S,tempScratch))+v.radius;T<x&&(T=x)}return new Geometry({attributes:u,indices:p,primitiveType:c,boundingSphere:defined(S)?new BoundingSphere(S,T):void 0})}GeometryPipeline.combineInstances=function(e){for(var t=[],i=[],r=e.length,n=0;n<r;++n){var a=e[n];defined(a.geometry)?t.push(a):defined(a.westHemisphereGeometry)&&defined(a.eastHemisphereGeometry)&&i.push(a)}var o=[];return 0<t.length&&o.push(combineGeometries(t,"geometry")),0<i.length&&(o.push(combineGeometries(i,"westHemisphereGeometry")),o.push(combineGeometries(i,"eastHemisphereGeometry"))),o};var normal=new Cartesian3,v0=new Cartesian3,v1=new Cartesian3,v2=new Cartesian3;GeometryPipeline.computeNormal=function(e){for(var t=e.indices,i=e.attributes,r=i.position.values,n=i.position.values.length/3,a=t.length,o=new Array(n),s=new Array(a/3),l=new Array(a),c=0;c<n;c++)o[c]={indexOffset:0,count:0,currentCount:0};var u=0;for(c=0;c<a;c+=3){var d=t[c],h=t[c+1],p=t[c+2],m=3*d,f=3*h,g=3*p;v0.x=r[m],v0.y=r[1+m],v0.z=r[2+m],v1.x=r[f],v1.y=r[1+f],v1.z=r[2+f],v2.x=r[g],v2.y=r[1+g],v2.z=r[2+g],o[d].count++,o[h].count++,o[p].count++,Cartesian3.subtract(v1,v0,v1),Cartesian3.subtract(v2,v0,v2),s[u]=Cartesian3.cross(v1,v2,new Cartesian3),u++}var _=0;for(c=0;c<n;c++)o[c].indexOffset+=_,_+=o[c].count;for(c=u=0;c<a;c+=3){var y=(S=o[t[c]]).indexOffset+S.currentCount;l[y]=u,S.currentCount++,l[(S=o[t[c+1]]).indexOffset+S.currentCount]=u,S.currentCount++,l[(S=o[t[c+2]]).indexOffset+S.currentCount]=u,S.currentCount++,u++}var C=new Float32Array(3*n);for(c=0;c<n;c++){var v=3*c,S=o[c];if(Cartesian3.clone(Cartesian3.ZERO,normal),0<S.count){for(u=0;u<S.count;u++)Cartesian3.add(normal,s[l[S.indexOffset+u]],normal);Cartesian3.equalsEpsilon(Cartesian3.ZERO,normal,CesiumMath.EPSILON10)&&Cartesian3.clone(s[l[S.indexOffset]],normal)}Cartesian3.equalsEpsilon(Cartesian3.ZERO,normal,CesiumMath.EPSILON10)&&(normal.z=1),Cartesian3.normalize(normal,normal),C[v]=normal.x,C[1+v]=normal.y,C[2+v]=normal.z}return e.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:C}),e};var normalScratch$1=new Cartesian3,normalScale=new Cartesian3,tScratch=new Cartesian3;GeometryPipeline.computeTangentAndBitangent=function(e){e.attributes;for(var t=e.indices,i=e.attributes.position.values,r=e.attributes.normal.values,n=e.attributes.st.values,a=e.attributes.position.values.length/3,o=t.length,s=new Array(3*a),l=0;l<s.length;l++)s[l]=0;for(l=0;l<o;l+=3){var c,u=t[l],d=t[l+1],h=t[l+2],p=3*d,m=3*h,f=2*u,g=2*d,_=2*h,y=i[c=3*u],C=i[c+1],d=i[c+2],h=n[f],u=n[1+f],f=n[1+g]-u,u=n[1+_]-u,h=1/((n[g]-h)*u-(n[_]-h)*f),y=(u*(i[p]-y)-f*(i[m]-y))*h,C=(u*(i[p+1]-C)-f*(i[m+1]-C))*h,h=(u*(i[p+2]-d)-f*(i[m+2]-d))*h;s[c]+=y,s[c+1]+=C,s[c+2]+=h,s[p]+=y,s[p+1]+=C,s[p+2]+=h,s[m]+=y,s[m+1]+=C,s[m+2]+=h}var v=new Float32Array(3*a),S=new Float32Array(3*a);for(l=0;l<a;l++){p=(c=3*l)+1,m=c+2;var T=Cartesian3.fromArray(r,c,normalScratch$1),x=Cartesian3.fromArray(s,c,tScratch),b=Cartesian3.dot(T,x);Cartesian3.multiplyByScalar(T,b,normalScale),Cartesian3.normalize(Cartesian3.subtract(x,normalScale,x),x),v[c]=x.x,v[p]=x.y,v[m]=x.z,Cartesian3.normalize(Cartesian3.cross(T,x,x),x),S[c]=x.x,S[p]=x.y,S[m]=x.z}return e.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:v}),e.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:S}),e};var scratchCartesian2$3=new Cartesian2,toEncode1=new Cartesian3,toEncode2=new Cartesian3,toEncode3=new Cartesian3,encodeResult2=new Cartesian2;function indexTriangles(e){if(defined(e.indices))return e;for(var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,t),r=0;r<t;++r)i[r]=r;return e.indices=i,e}function indexTriangleFan(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,3*(t-2));i[0]=1,i[1]=0,i[2]=2;for(var r=3,n=3;n<t;++n)i[r++]=n-1,i[r++]=0,i[r++]=n;return e.indices=i,e.primitiveType=PrimitiveType$1.TRIANGLES,e}function indexTriangleStrip(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,3*(t-2));i[0]=0,i[1]=1,i[2]=2,3<t&&(i[3]=0,i[4]=2,i[5]=3);for(var r=6,n=3;n<t-1;n+=2)i[r++]=n,i[r++]=n-1,i[r++]=n+1,n+2<t&&(i[r++]=n,i[r++]=n+1,i[r++]=n+2);return e.indices=i,e.primitiveType=PrimitiveType$1.TRIANGLES,e}function indexLines(e){if(defined(e.indices))return e;for(var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,t),r=0;r<t;++r)i[r]=r;return e.indices=i,e}function indexLineStrip(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,2*(t-1));i[0]=0,i[1]=1;for(var r=2,n=2;n<t;++n)i[r++]=n-1,i[r++]=n;return e.indices=i,e.primitiveType=PrimitiveType$1.LINES,e}function indexLineLoop(e){var t=Geometry.computeNumberOfVertices(e),i=IndexDatatype$1.createTypedArray(t,2*t);i[0]=0,i[1]=1;for(var r=2,n=2;n<t;++n)i[r++]=n-1,i[r++]=n;return i[r++]=t-1,i[r]=0,e.indices=i,e.primitiveType=PrimitiveType$1.LINES,e}function indexPrimitive(e){switch(e.primitiveType){case PrimitiveType$1.TRIANGLE_FAN:return indexTriangleFan(e);case PrimitiveType$1.TRIANGLE_STRIP:return indexTriangleStrip(e);case PrimitiveType$1.TRIANGLES:return indexTriangles(e);case PrimitiveType$1.LINE_STRIP:return indexLineStrip(e);case PrimitiveType$1.LINE_LOOP:return indexLineLoop(e);case PrimitiveType$1.LINES:return indexLines(e)}return e}function offsetPointFromXZPlane(e,t){Math.abs(e.y)<CesiumMath.EPSILON6&&(e.y=t?-CesiumMath.EPSILON6:CesiumMath.EPSILON6)}function offsetTriangleFromXZPlane(e,t,i){if(0!==e.y&&0!==t.y&&0!==i.y)return offsetPointFromXZPlane(e,e.y<0),offsetPointFromXZPlane(t,t.y<0),void offsetPointFromXZPlane(i,i.y<0);var r=Math.abs(e.y),n=Math.abs(t.y),a=Math.abs(i.y),n=n<r?a<r?CesiumMath.sign(e.y):CesiumMath.sign(i.y):a<n?CesiumMath.sign(t.y):CesiumMath.sign(i.y),n=n<0;offsetPointFromXZPlane(e,n),offsetPointFromXZPlane(t,n),offsetPointFromXZPlane(i,n)}GeometryPipeline.compressVertices=function(e){var t=e.attributes.extrudeDirection;if(defined(t)){for(var i=t.values,r=i.length/3,n=new Float32Array(2*r),a=0,o=0;o<r;++o)Cartesian3.fromArray(i,3*o,toEncode1),Cartesian3.equals(toEncode1,Cartesian3.ZERO)?a+=2:(encodeResult2=AttributeCompression.octEncodeInRange(toEncode1,65535,encodeResult2),n[a++]=encodeResult2.x,n[a++]=encodeResult2.y);return e.attributes.compressedAttributes=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:n}),delete e.attributes.extrudeDirection,e}var s=e.attributes.normal,l=e.attributes.st,c=defined(s),u=defined(l);if(!c&&!u)return e;var d,h,p,m,f=e.attributes.tangent,t=e.attributes.bitangent,g=defined(f),_=defined(t);c&&(d=s.values),u&&(h=l.values),g&&(p=f.values),_&&(m=t.values);f=r=(c?d:h).length/(c?3:2),t=u&&c?2:1;f*=t+=g||_?1:0;var y=new Float32Array(f),C=0;for(o=0;o<r;++o){u&&(Cartesian2.fromArray(h,2*o,scratchCartesian2$3),y[C++]=AttributeCompression.compressTextureCoordinates(scratchCartesian2$3));var v=3*o;c&&defined(p)&&defined(m)?(Cartesian3.fromArray(d,v,toEncode1),Cartesian3.fromArray(p,v,toEncode2),Cartesian3.fromArray(m,v,toEncode3),AttributeCompression.octPack(toEncode1,toEncode2,toEncode3,scratchCartesian2$3),y[C++]=scratchCartesian2$3.x,y[C++]=scratchCartesian2$3.y):(c&&(Cartesian3.fromArray(d,v,toEncode1),y[C++]=AttributeCompression.octEncodeFloat(toEncode1)),g&&(Cartesian3.fromArray(p,v,toEncode1),y[C++]=AttributeCompression.octEncodeFloat(toEncode1)),_&&(Cartesian3.fromArray(m,v,toEncode1),y[C++]=AttributeCompression.octEncodeFloat(toEncode1)))}return e.attributes.compressedAttributes=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:t,values:y}),c&&delete e.attributes.normal,u&&delete e.attributes.st,_&&delete e.attributes.bitangent,g&&delete e.attributes.tangent,e};var c3=new Cartesian3;function getXZIntersectionOffsetPoints(e,t,i,r){Cartesian3.add(e,Cartesian3.multiplyByScalar(Cartesian3.subtract(t,e,c3),e.y/(e.y-t.y),c3),i),Cartesian3.clone(i,r),offsetPointFromXZPlane(i,!0),offsetPointFromXZPlane(r,!1)}var u1=new Cartesian3,u2=new Cartesian3,q1=new Cartesian3,q2=new Cartesian3,splitTriangleResult={positions:new Array(7),indices:new Array(9)};function splitTriangle(e,t,i){if(!(0<=e.x||0<=t.x||0<=i.x)){offsetTriangleFromXZPlane(e,t,i);var r=e.y<0,n=t.y<0,a=i.y<0,o=0;o+=r?1:0,o+=n?1:0,o+=a?1:0;var s=splitTriangleResult.indices;1==o?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,r?(getXZIntersectionOffsetPoints(e,t,u1,q1),getXZIntersectionOffsetPoints(e,i,u2,q2),s[0]=0,s[3]=1,s[4]=2,s[6]=1):n?(getXZIntersectionOffsetPoints(t,i,u1,q1),getXZIntersectionOffsetPoints(t,e,u2,q2),s[0]=1,s[3]=2,s[4]=0,s[6]=2):a&&(getXZIntersectionOffsetPoints(i,e,u1,q1),getXZIntersectionOffsetPoints(i,t,u2,q2),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2==o&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,r?n?a||(getXZIntersectionOffsetPoints(i,e,u1,q1),getXZIntersectionOffsetPoints(i,t,u2,q2),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(getXZIntersectionOffsetPoints(t,i,u1,q1),getXZIntersectionOffsetPoints(t,e,u2,q2),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(getXZIntersectionOffsetPoints(e,t,u1,q1),getXZIntersectionOffsetPoints(e,i,u2,q2),s[0]=1,s[1]=2,s[3]=1,s[6]=0));s=splitTriangleResult.positions;return s[0]=e,s[1]=t,s[2]=i,s.length=3,1!=o&&2!=o||(s[3]=u1,s[4]=u2,s[5]=q1,s[6]=q2,s.length=7),splitTriangleResult}}function updateGeometryAfterSplit(e,t){var i,r=e.attributes;if(0!==r.position.values.length){for(var n in r)r.hasOwnProperty(n)&&defined(r[n])&&defined(r[n].values)&&((i=r[n]).values=ComponentDatatype$1.createTypedArray(i.componentDatatype,i.values));var a=Geometry.computeNumberOfVertices(e);return e.indices=IndexDatatype$1.createTypedArray(a,e.indices),t&&(e.boundingSphere=BoundingSphere.fromVertices(r.position.values)),e}}function copyGeometryForSplit(e){var t,i,r=e.attributes,n={};for(t in r)r.hasOwnProperty(t)&&defined(r[t])&&defined(r[t].values)&&(i=r[t],n[t]=new GeometryAttribute({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]}));return new Geometry({attributes:n,indices:[],primitiveType:e.primitiveType})}function updateInstanceAfterSplit(e,t,i){var r=defined(e.geometry.boundingSphere);t=updateGeometryAfterSplit(t,r),defined(i=updateGeometryAfterSplit(i,r))&&!defined(t)?e.geometry=i:!defined(i)&&defined(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=i,e.geometry=void 0)}function generateBarycentricInterpolateFunction(l,c){var u=new l,d=new l,h=new l;return function(e,t,i,r,n,a,o,s){e=l.fromArray(n,e*c,u),t=l.fromArray(n,t*c,d),i=l.fromArray(n,i*c,h);l.multiplyByScalar(e,r.x,e),l.multiplyByScalar(t,r.y,t),l.multiplyByScalar(i,r.z,i);e=l.add(e,t,e);l.add(e,i,e),s&&l.normalize(e,e),l.pack(e,a,o*c)}}var interpolateAndPackCartesian4=generateBarycentricInterpolateFunction(Cartesian4,4),interpolateAndPackCartesian3=generateBarycentricInterpolateFunction(Cartesian3,3),interpolateAndPackCartesian2=generateBarycentricInterpolateFunction(Cartesian2,2),interpolateAndPackBoolean=function(e,t,i,r,n,a,o){e=n[e]*r.x,t=n[t]*r.y,r=n[i]*r.z;a[o]=e+t+r>CesiumMath.EPSILON6?1:0},p0Scratch=new Cartesian3,p1Scratch=new Cartesian3,p2Scratch=new Cartesian3,barycentricScratch=new Cartesian3;function computeTriangleAttributes(e,t,i,r,n,a,o,s,l,c,u,d,h,p,m,f){if(defined(a)||defined(o)||defined(s)||defined(l)||defined(c)||0!==p){var g,_=barycentricCoordinates(r,Cartesian3.fromArray(n,3*e,p0Scratch),Cartesian3.fromArray(n,3*t,p1Scratch),Cartesian3.fromArray(n,3*i,p2Scratch),barycentricScratch);if(defined(a)&&interpolateAndPackCartesian3(e,t,i,_,a,d.normal.values,f,!0),defined(c)&&(n=Cartesian3.fromArray(c,3*e,p0Scratch),a=Cartesian3.fromArray(c,3*t,p1Scratch),c=Cartesian3.fromArray(c,3*i,p2Scratch),Cartesian3.multiplyByScalar(n,_.x,n),Cartesian3.multiplyByScalar(a,_.y,a),Cartesian3.multiplyByScalar(c,_.z,c),Cartesian3.equals(n,Cartesian3.ZERO)&&Cartesian3.equals(a,Cartesian3.ZERO)&&Cartesian3.equals(c,Cartesian3.ZERO)?((g=p0Scratch).x=0,g.y=0,g.z=0):(g=Cartesian3.add(n,a,n),Cartesian3.add(g,c,g),Cartesian3.normalize(g,g)),Cartesian3.pack(g,d.extrudeDirection.values,3*f)),defined(u)&&interpolateAndPackBoolean(e,t,i,_,u,d.applyOffset.values,f),defined(o)&&interpolateAndPackCartesian3(e,t,i,_,o,d.tangent.values,f,!0),defined(s)&&interpolateAndPackCartesian3(e,t,i,_,s,d.bitangent.values,f,!0),defined(l)&&interpolateAndPackCartesian2(e,t,i,_,l,d.st.values,f),0<p)for(var y=0;y<p;y++){var C=h[y];genericInterpolate(e,t,i,_,f,m[C],d[C])}}}function genericInterpolate(e,t,i,r,n,a,o){var s=a.componentsPerAttribute,l=a.values,c=o.values;switch(s){case 4:interpolateAndPackCartesian4(e,t,i,r,l,c,n,!1);break;case 3:interpolateAndPackCartesian3(e,t,i,r,l,c,n,!1);break;case 2:interpolateAndPackCartesian2(e,t,i,r,l,c,n,!1);break;default:c[n]=l[e]*r.x+l[t]*r.y+l[i]*r.z}}function insertSplitPoint(e,t,i,r,n,a){var o=e.position.values.length/3;if(-1===n)return e.position.values.push(a.x,a.y,a.z),t.push(o),o;r=r[n],n=i[r];return-1===n?(i[r]=o,e.position.values.push(a.x,a.y,a.z),t.push(o),o):(t.push(n),n)}var NAMED_ATTRIBUTES={position:!0,normal:!0,bitangent:!0,tangent:!0,st:!0,extrudeDirection:!0,applyOffset:!0};function splitLongitudeTriangles(e){var t,i=e.geometry,r=i.attributes,n=r.position.values,a=defined(r.normal)?r.normal.values:void 0,o=defined(r.bitangent)?r.bitangent.values:void 0,s=defined(r.tangent)?r.tangent.values:void 0,l=defined(r.st)?r.st.values:void 0,c=defined(r.extrudeDirection)?r.extrudeDirection.values:void 0,u=defined(r.applyOffset)?r.applyOffset.values:void 0,d=i.indices,h=[];for(t in r)r.hasOwnProperty(t)&&!NAMED_ATTRIBUTES[t]&&defined(r[t])&&h.push(t);var p,m,f=h.length,g=copyGeometryForSplit(i),_=copyGeometryForSplit(i),y=[];y.length=n.length/3;var C=[];for(C.length=n.length/3,S=0;S<y.length;++S)y[S]=-1,C[S]=-1;for(var v=d.length,S=0;S<v;S+=3){var T=d[S],x=d[S+1],b=d[S+2],E=Cartesian3.fromArray(n,3*T),P=Cartesian3.fromArray(n,3*x),A=Cartesian3.fromArray(n,3*b),w=splitTriangle(E,P,A);if(defined(w)&&3<w.positions.length)for(var D=w.positions,M=w.indices,I=M.length,R=0;R<I;++R){var O=M[R],L=D[O],F=L.y<0?(p=_.attributes,m=_.indices,y):(p=g.attributes,m=g.indices,C);computeTriangleAttributes(T,x,b,L,n,a,s,o,l,c,u,p,h,f,r,insertSplitPoint(p,m,F,d,O<3?S+O:-1,L))}else defined(w)&&(E=w.positions[0],P=w.positions[1],A=w.positions[2]),F=E.y<0?(p=_.attributes,m=_.indices,y):(p=g.attributes,m=g.indices,C),computeTriangleAttributes(T,x,b,E,n,a,s,o,l,c,u,p,h,f,r,insertSplitPoint(p,m,F,d,S,E)),computeTriangleAttributes(T,x,b,P,n,a,s,o,l,c,u,p,h,f,r,insertSplitPoint(p,m,F,d,S+1,P)),computeTriangleAttributes(T,x,b,A,n,a,s,o,l,c,u,p,h,f,r,insertSplitPoint(p,m,F,d,S+2,A))}updateInstanceAfterSplit(e,_,g)}var xzPlane=Plane.fromPointNormal(Cartesian3.ZERO,Cartesian3.UNIT_Y),offsetScratch=new Cartesian3,offsetPointScratch=new Cartesian3;function computeLineAttributes(e,t,i,r,n,a,o){defined(o)&&(r=Cartesian3.fromArray(r,3*e,p0Scratch),Cartesian3.equalsEpsilon(r,i,CesiumMath.EPSILON10)?a.applyOffset.values[n]=o[e]:a.applyOffset.values[n]=o[t])}function splitLongitudeLines(e){var t,i=e.geometry,r=i.attributes,n=r.position.values,a=defined(r.applyOffset)?r.applyOffset.values:void 0,o=i.indices,s=copyGeometryForSplit(i),l=copyGeometryForSplit(i),c=o.length,u=[];u.length=n.length/3;var d=[];for(d.length=n.length/3,t=0;t<u.length;++t)u[t]=-1,d[t]=-1;for(t=0;t<c;t+=2){var h=o[t],p=o[t+1],m=Cartesian3.fromArray(n,3*h,p0Scratch),f=Cartesian3.fromArray(n,3*p,p1Scratch);Math.abs(m.y)<CesiumMath.EPSILON6&&(m.y<0?m.y=-CesiumMath.EPSILON6:m.y=CesiumMath.EPSILON6),Math.abs(f.y)<CesiumMath.EPSILON6&&(f.y<0?f.y=-CesiumMath.EPSILON6:f.y=CesiumMath.EPSILON6);var g,_,y,C,v=s.attributes,S=s.indices,T=d,x=l.attributes,b=l.indices,E=u,P=IntersectionTests.lineSegmentPlane(m,f,xzPlane,p2Scratch);defined(P)?(g=Cartesian3.multiplyByScalar(Cartesian3.UNIT_Y,5*CesiumMath.EPSILON9,offsetScratch),m.y<0&&(Cartesian3.negate(g,g),v=l.attributes,S=l.indices,T=u,x=s.attributes,b=s.indices,E=d),_=Cartesian3.add(P,g,offsetPointScratch),computeLineAttributes(h,p,m,n,insertSplitPoint(v,S,T,o,t,m),v,a),computeLineAttributes(h,p,_,n,insertSplitPoint(v,S,T,o,-1,_),v,a),Cartesian3.negate(g,g),Cartesian3.add(P,g,_),computeLineAttributes(h,p,_,n,insertSplitPoint(x,b,E,o,-1,_),x,a),computeLineAttributes(h,p,f,n,insertSplitPoint(x,b,E,o,t+1,f),x,a)):(x=m.y<0?(y=l.attributes,C=l.indices,u):(y=s.attributes,C=s.indices,d),computeLineAttributes(h,p,m,n,insertSplitPoint(y,C,x,o,t,m),y,a),computeLineAttributes(h,p,f,n,insertSplitPoint(y,C,x,o,t+1,f),y,a))}updateInstanceAfterSplit(e,l,s)}var cartesian2Scratch0=new Cartesian2,cartesian2Scratch1=new Cartesian2,cartesian3Scratch0=new Cartesian3,cartesian3Scratch2=new Cartesian3,cartesian3Scratch3=new Cartesian3,cartesian3Scratch4=new Cartesian3,cartesian3Scratch5=new Cartesian3,cartesian3Scratch6=new Cartesian3,cartesian4Scratch0=new Cartesian4;function updateAdjacencyAfterSplit(e){for(var e=e.attributes,t=e.position.values,i=e.prevPosition.values,r=e.nextPosition.values,n=t.length,a=0;a<n;a+=3){var o,s=Cartesian3.unpack(t,a,cartesian3Scratch0);0<s.x||(o=Cartesian3.unpack(i,a,cartesian3Scratch2),(s.y<0&&0<o.y||0<s.y&&o.y<0)&&(0<a-3?(i[a]=t[a-3],i[a+1]=t[a-2],i[a+2]=t[a-1]):Cartesian3.pack(s,i,a)),o=Cartesian3.unpack(r,a,cartesian3Scratch3),(s.y<0&&0<o.y||0<s.y&&o.y<0)&&(a+3<n?(r[a]=t[a+3],r[a+1]=t[a+4],r[a+2]=t[a+5]):Cartesian3.pack(s,r,a)))}}var offsetScalar=5*CesiumMath.EPSILON9,coplanarOffset=CesiumMath.EPSILON6;function splitLongitudePolyline(e){for(var t=e.geometry,i=t.attributes,r=i.position.values,n=i.prevPosition.values,a=i.nextPosition.values,o=i.expandAndWidth.values,s=defined(i.st)?i.st.values:void 0,l=defined(i.color)?i.color.values:void 0,c=copyGeometryForSplit(t),u=copyGeometryForSplit(t),d=!1,h=r.length/3,p=0;p<h;p+=4){var m=p,f=p+2,g=Cartesian3.fromArray(r,3*m,cartesian3Scratch0),_=Cartesian3.fromArray(r,3*f,cartesian3Scratch2);if(Math.abs(g.y)<coplanarOffset)for(g.y=coplanarOffset*(_.y<0?-1:1),r[3*p+1]=g.y,r[3*(p+1)+1]=g.y,w=3*m;w<3*m+12;w+=3)n[w]=r[3*p],n[w+1]=r[3*p+1],n[w+2]=r[3*p+2];if(Math.abs(_.y)<coplanarOffset)for(_.y=coplanarOffset*(g.y<0?-1:1),r[3*(p+2)+1]=_.y,r[3*(p+3)+1]=_.y,w=3*m;w<3*m+12;w+=3)a[w]=r[3*(p+2)],a[w+1]=r[3*(p+2)+1],a[w+2]=r[3*(p+2)+2];var y=c.attributes,C=c.indices,v=u.attributes,S=u.indices,T=IntersectionTests.lineSegmentPlane(g,_,xzPlane,cartesian3Scratch4);if(defined(T)){d=!0;var x=Cartesian3.multiplyByScalar(Cartesian3.UNIT_Y,offsetScalar,cartesian3Scratch5);g.y<0&&(Cartesian3.negate(x,x),y=u.attributes,C=u.indices,v=c.attributes,S=c.indices);var b=Cartesian3.add(T,x,cartesian3Scratch6);y.position.values.push(g.x,g.y,g.z,g.x,g.y,g.z),y.position.values.push(b.x,b.y,b.z),y.position.values.push(b.x,b.y,b.z),y.prevPosition.values.push(n[3*m],n[3*m+1],n[3*m+2]),y.prevPosition.values.push(n[3*m+3],n[3*m+4],n[3*m+5]),y.prevPosition.values.push(g.x,g.y,g.z,g.x,g.y,g.z),y.nextPosition.values.push(b.x,b.y,b.z),y.nextPosition.values.push(b.x,b.y,b.z),y.nextPosition.values.push(b.x,b.y,b.z),y.nextPosition.values.push(b.x,b.y,b.z),Cartesian3.negate(x,x),Cartesian3.add(T,x,b),v.position.values.push(b.x,b.y,b.z),v.position.values.push(b.x,b.y,b.z),v.position.values.push(_.x,_.y,_.z,_.x,_.y,_.z),v.prevPosition.values.push(b.x,b.y,b.z),v.prevPosition.values.push(b.x,b.y,b.z),v.prevPosition.values.push(b.x,b.y,b.z),v.prevPosition.values.push(b.x,b.y,b.z),v.nextPosition.values.push(_.x,_.y,_.z,_.x,_.y,_.z),v.nextPosition.values.push(a[3*f],a[3*f+1],a[3*f+2]),v.nextPosition.values.push(a[3*f+3],a[3*f+4],a[3*f+5]);var E=Cartesian2.fromArray(o,2*m,cartesian2Scratch0),P=Math.abs(E.y);y.expandAndWidth.values.push(-1,P,1,P),y.expandAndWidth.values.push(-1,-P,1,-P),v.expandAndWidth.values.push(-1,P,1,P),v.expandAndWidth.values.push(-1,-P,1,-P);x=Cartesian3.magnitudeSquared(Cartesian3.subtract(T,g,cartesian3Scratch3));if(x/=Cartesian3.magnitudeSquared(Cartesian3.subtract(_,g,cartesian3Scratch3)),defined(l)){for(var b=Cartesian4.fromArray(l,4*m,cartesian4Scratch0),A=Cartesian4.fromArray(l,4*f,cartesian4Scratch0),E=CesiumMath.lerp(b.x,A.x,x),P=CesiumMath.lerp(b.y,A.y,x),T=CesiumMath.lerp(b.z,A.z,x),A=CesiumMath.lerp(b.w,A.w,x),w=4*m;w<4*m+8;++w)y.color.values.push(l[w]);for(y.color.values.push(E,P,T,A),y.color.values.push(E,P,T,A),v.color.values.push(E,P,T,A),v.color.values.push(E,P,T,A),w=4*f;w<4*f+8;++w)v.color.values.push(l[w])}if(defined(s)){var A=Cartesian2.fromArray(s,2*m,cartesian2Scratch0),D=Cartesian2.fromArray(s,2*(p+3),cartesian2Scratch1),x=CesiumMath.lerp(A.x,D.x,x);for(w=2*m;w<2*m+4;++w)y.st.values.push(s[w]);for(y.st.values.push(x,A.y),y.st.values.push(x,D.y),v.st.values.push(x,A.y),v.st.values.push(x,D.y),w=2*f;w<2*f+4;++w)v.st.values.push(s[w])}D=y.position.values.length/3-4,C.push(D,D+2,D+1),C.push(D+1,D+2,D+3),D=v.position.values.length/3-4,S.push(D,D+2,D+1),S.push(D+1,D+2,D+3)}else{var M,S=g.y<0?(M=u.attributes,u.indices):(M=c.attributes,c.indices);for(M.position.values.push(g.x,g.y,g.z),M.position.values.push(g.x,g.y,g.z),M.position.values.push(_.x,_.y,_.z),M.position.values.push(_.x,_.y,_.z),w=3*p;w<3*p+12;++w)M.prevPosition.values.push(n[w]),M.nextPosition.values.push(a[w]);for(w=2*p;w<2*p+8;++w)M.expandAndWidth.values.push(o[w]),defined(s)&&M.st.values.push(s[w]);if(defined(l))for(w=4*p;w<4*p+16;++w)M.color.values.push(l[w]);D=M.position.values.length/3-4,S.push(D,D+2,D+1),S.push(D+1,D+2,D+3)}}d&&(updateAdjacencyAfterSplit(u),updateAdjacencyAfterSplit(c)),updateInstanceAfterSplit(e,u,c)}GeometryPipeline.splitLongitude=function(e){var t=e.geometry,i=t.boundingSphere;if(defined(i)&&(0<i.center.x-i.radius||BoundingSphere.intersectPlane(i,Plane.ORIGIN_ZX_PLANE)!==Intersect$1.INTERSECTING))return e;if(t.geometryType!==GeometryType$1.NONE)switch(t.geometryType){case GeometryType$1.POLYLINES:splitLongitudePolyline(e);break;case GeometryType$1.TRIANGLES:splitLongitudeTriangles(e);break;case GeometryType$1.LINES:splitLongitudeLines(e)}else indexPrimitive(t),t.primitiveType===PrimitiveType$1.TRIANGLES?splitLongitudeTriangles(e):t.primitiveType===PrimitiveType$1.LINES&&splitLongitudeLines(e);return e};var scratchCartesian1$3=new Cartesian3,scratchCartesian2$4=new Cartesian3,scratchCartesian3$5=new Cartesian3,scratchCartesian4$1=new Cartesian3,texCoordScratch=new Cartesian2,textureMatrixScratch=new Matrix3,tangentMatrixScratch=new Matrix3,quaternionScratch=new Quaternion,scratchNormal$2=new Cartesian3,scratchTangent=new Cartesian3,scratchBitangent=new Cartesian3,scratchCartographic$1=new Cartographic,projectedCenterScratch=new Cartesian3,scratchMinTexCoord=new Cartesian2,scratchMaxTexCoord=new Cartesian2;function computeTopBottomAttributes(e,t,i){var r=t.vertexFormat,n=t.center,a=t.semiMajorAxis,o=t.semiMinorAxis,s=t.ellipsoid,l=t.stRotation,c=i?e.length/3*2:e.length/3,u=t.shadowVolume,d=r.st?new Float32Array(2*c):void 0,h=r.normal?new Float32Array(3*c):void 0,p=r.tangent?new Float32Array(3*c):void 0,m=r.bitangent?new Float32Array(3*c):void 0,f=u?new Float32Array(3*c):void 0,g=0,_=scratchNormal$2,y=scratchTangent,C=scratchBitangent,v=new GeographicProjection(s),S=v.project(s.cartesianToCartographic(n,scratchCartographic$1),projectedCenterScratch),n=s.scaleToGeodeticSurface(n,scratchCartesian1$3);s.geodeticSurfaceNormal(n,n);var T=textureMatrixScratch,x=tangentMatrixScratch;x=0!==l?(N=Quaternion.fromAxisAngle(n,l,quaternionScratch),T=Matrix3.fromQuaternion(N,T),N=Quaternion.fromAxisAngle(n,-l,quaternionScratch),Matrix3.fromQuaternion(N,x)):(T=Matrix3.clone(Matrix3.IDENTITY,T),Matrix3.clone(Matrix3.IDENTITY,x));for(var b=Cartesian2.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,scratchMinTexCoord),E=Cartesian2.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,scratchMaxTexCoord),P=e.length,A=i?P:0,w=A/3*2,D=0;D<P;D+=3){var M,I=D+1,R=D+2,O=Cartesian3.fromArray(e,D,scratchCartesian1$3);r.st&&(M=Matrix3.multiplyByVector(T,O,scratchCartesian2$4),M=v.project(s.cartesianToCartographic(M,scratchCartographic$1),scratchCartesian3$5),Cartesian3.subtract(M,S,M),texCoordScratch.x=(M.x+a)/(2*a),texCoordScratch.y=(M.y+o)/(2*o),b.x=Math.min(texCoordScratch.x,b.x),b.y=Math.min(texCoordScratch.y,b.y),E.x=Math.max(texCoordScratch.x,E.x),E.y=Math.max(texCoordScratch.y,E.y),i&&(d[g+w]=texCoordScratch.x,d[g+1+w]=texCoordScratch.y),d[g++]=texCoordScratch.x,d[g++]=texCoordScratch.y),(r.normal||r.tangent||r.bitangent||u)&&(_=s.geodeticSurfaceNormal(O,_),u&&(f[D+A]=-_.x,f[I+A]=-_.y,f[R+A]=-_.z),(r.normal||r.tangent||r.bitangent)&&((r.tangent||r.bitangent)&&(y=Cartesian3.normalize(Cartesian3.cross(Cartesian3.UNIT_Z,_,y),y),Matrix3.multiplyByVector(x,y,y)),r.normal&&(h[D]=_.x,h[I]=_.y,h[R]=_.z,i&&(h[D+A]=-_.x,h[I+A]=-_.y,h[R+A]=-_.z)),r.tangent&&(p[D]=y.x,p[I]=y.y,p[R]=y.z,i&&(p[D+A]=-y.x,p[I+A]=-y.y,p[R+A]=-y.z)),r.bitangent&&(C=Cartesian3.normalize(Cartesian3.cross(_,y,C),C),m[D]=C.x,m[I]=C.y,m[R]=C.z,i&&(m[D+A]=C.x,m[I+A]=C.y,m[R+A]=C.z))))}if(r.st){P=d.length;for(var L=0;L<P;L+=2)d[L]=(d[L]-b.x)/(E.x-b.x),d[L+1]=(d[L+1]-b.y)/(E.y-b.y)}var F,N=new GeometryAttributes;return r.position&&(F=EllipseGeometryLibrary.raisePositionsToHeight(e,t,i),N.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:F})),r.st&&(N.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:d})),r.normal&&(N.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),r.tangent&&(N.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),r.bitangent&&(N.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),u&&(N.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),i&&defined(t.offsetAttribute)&&(F=new Uint8Array(c),F=t.offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(F,1,0,c/2):arrayFill(F,t.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),N.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:F})),N}function topIndices(e){for(var t,i,r=new Array(e*(e+1)*12-6),n=0,a=0,o=1,s=0;s<3;s++)r[n++]=o++,r[n++]=a,r[n++]=o;for(s=2;s<e+1;++s){for(o=s*(s+1)-1,a=(s-1)*s-1,r[n++]=o++,r[n++]=a,r[n++]=o,t=2*s,i=0;i<t-1;++i)r[n++]=o,r[n++]=a++,r[n++]=a,r[n++]=o++,r[n++]=a,r[n++]=o;r[n++]=o++,r[n++]=a,r[n++]=o}for(t=2*e,++o,++a,s=0;s<t-1;++s)r[n++]=o,r[n++]=a++,r[n++]=a,r[n++]=o++,r[n++]=a,r[n++]=o;for(r[n++]=o,r[n++]=a++,r[n++]=a,r[n++]=o++,r[n++]=a++,r[n++]=a,++a,s=e-1;1<s;--s){for(r[n++]=a++,r[n++]=a,r[n++]=o,t=2*s,i=0;i<t-1;++i)r[n++]=o,r[n++]=a++,r[n++]=a,r[n++]=o++,r[n++]=a,r[n++]=o;r[n++]=a++,r[n++]=a++,r[n++]=o++}for(s=0;s<3;s++)r[n++]=a++,r[n++]=a,r[n++]=o;return r}var boundingSphereCenter=new Cartesian3;function computeEllipse(e){var t=e.center;boundingSphereCenter=Cartesian3.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,boundingSphereCenter),e.height,boundingSphereCenter);var i=new BoundingSphere(boundingSphereCenter=Cartesian3.add(t,boundingSphereCenter,boundingSphereCenter),e.semiMajorAxis),r=EllipseGeometryLibrary.computeEllipsePositions(e,!0,!1),t=r.positions,r=r.numPts,e=computeTopBottomAttributes(t,e,!1),r=topIndices(r);return{boundingSphere:i,attributes:e,indices:r=IndexDatatype$1.createTypedArray(t.length/3,r)}}function computeWallAttributes(e,t){var i=t.vertexFormat,r=t.center,n=t.semiMajorAxis,a=t.semiMinorAxis,o=t.ellipsoid,s=t.height,l=t.extrudedHeight,c=t.stRotation,u=e.length/3*2,d=new Float64Array(3*u),h=i.st?new Float32Array(2*u):void 0,p=i.normal?new Float32Array(3*u):void 0,m=i.tangent?new Float32Array(3*u):void 0,f=i.bitangent?new Float32Array(3*u):void 0,g=t.shadowVolume,_=g?new Float32Array(3*u):void 0,y=0,C=scratchNormal$2,v=scratchTangent,S=scratchBitangent,T=new GeographicProjection(o),x=T.project(o.cartesianToCartographic(r,scratchCartographic$1),projectedCenterScratch),r=o.scaleToGeodeticSurface(r,scratchCartesian1$3);o.geodeticSurfaceNormal(r,r);for(var r=Quaternion.fromAxisAngle(r,c,quaternionScratch),b=Matrix3.fromQuaternion(r,textureMatrixScratch),E=Cartesian2.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,scratchMinTexCoord),P=Cartesian2.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,scratchMaxTexCoord),A=e.length,w=A/3*2,D=0;D<A;D+=3){var M=D+1,I=D+2,R=Cartesian3.fromArray(e,D,scratchCartesian1$3);i.st&&(L=Matrix3.multiplyByVector(b,R,scratchCartesian2$4),O=T.project(o.cartesianToCartographic(L,scratchCartographic$1),scratchCartesian3$5),Cartesian3.subtract(O,x,O),texCoordScratch.x=(O.x+n)/(2*n),texCoordScratch.y=(O.y+a)/(2*a),E.x=Math.min(texCoordScratch.x,E.x),E.y=Math.min(texCoordScratch.y,E.y),P.x=Math.max(texCoordScratch.x,P.x),P.y=Math.max(texCoordScratch.y,P.y),h[y+w]=texCoordScratch.x,h[y+1+w]=texCoordScratch.y,h[y++]=texCoordScratch.x,h[y++]=texCoordScratch.y),R=o.scaleToGeodeticSurface(R,R),L=Cartesian3.clone(R,scratchCartesian2$4),C=o.geodeticSurfaceNormal(R,C),g&&(_[D+A]=-C.x,_[M+A]=-C.y,_[I+A]=-C.z);var O=Cartesian3.multiplyByScalar(C,s,scratchCartesian4$1),R=Cartesian3.add(R,O,R),O=Cartesian3.multiplyByScalar(C,l,O),L=Cartesian3.add(L,O,L);i.position&&(d[D+A]=L.x,d[M+A]=L.y,d[I+A]=L.z,d[D]=R.x,d[M]=R.y,d[I]=R.z),(i.normal||i.tangent||i.bitangent)&&(S=Cartesian3.clone(C,S),O=Cartesian3.fromArray(e,(D+3)%A,scratchCartesian4$1),Cartesian3.subtract(O,R,O),R=Cartesian3.subtract(L,R,scratchCartesian3$5),C=Cartesian3.normalize(Cartesian3.cross(R,O,C),C),i.normal&&(p[D]=C.x,p[M]=C.y,p[I]=C.z,p[D+A]=C.x,p[M+A]=C.y,p[I+A]=C.z),i.tangent&&(v=Cartesian3.normalize(Cartesian3.cross(S,C,v),v),m[D]=v.x,m[M]=v.y,m[I]=v.z,m[D+A]=v.x,m[D+1+A]=v.y,m[D+2+A]=v.z),i.bitangent&&(f[D]=S.x,f[M]=S.y,f[I]=S.z,f[D+A]=S.x,f[M+A]=S.y,f[I+A]=S.z))}if(i.st){A=h.length;for(var F=0;F<A;F+=2)h[F]=(h[F]-E.x)/(P.x-E.x),h[F+1]=(h[F+1]-E.y)/(P.y-E.y)}c=new GeometryAttributes;return i.position&&(c.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:d})),i.st&&(c.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:h})),i.normal&&(c.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),i.tangent&&(c.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:m})),i.bitangent&&(c.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),g&&(c.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_})),defined(t.offsetAttribute)&&(r=new Uint8Array(u),r=t.offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(r,1,0,u/2):arrayFill(r,t.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),c.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:r})),c}function computeWallIndices(e){for(var t=e.length/3,i=IndexDatatype$1.createTypedArray(t,6*t),r=0,n=0;n<t;n++){var a=n+t,o=(n+1)%t,s=o+t;i[r++]=n,i[r++]=a,i[r++]=o,i[r++]=o,i[r++]=a,i[r++]=s}return i}var topBoundingSphere=new BoundingSphere,bottomBoundingSphere=new BoundingSphere;function computeExtrudedEllipse(e){var t=e.center,i=e.ellipsoid,r=e.semiMajorAxis,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,scratchCartesian1$3),e.height,scratchCartesian1$3);topBoundingSphere.center=Cartesian3.add(t,n,topBoundingSphere.center),topBoundingSphere.radius=r,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,n),e.extrudedHeight,n),bottomBoundingSphere.center=Cartesian3.add(t,n,bottomBoundingSphere.center),bottomBoundingSphere.radius=r;var a=EllipseGeometryLibrary.computeEllipsePositions(e,!0,!0),i=a.positions,t=a.numPts,n=a.outerPositions,r=BoundingSphere.union(topBoundingSphere,bottomBoundingSphere),a=computeTopBottomAttributes(i,e,!0),o=(c=topIndices(t)).length;c.length=2*o;for(var s=i.length/3,l=0;l<o;l+=3)c[l+o]=c[l+2]+s,c[l+1+o]=c[l+1]+s,c[l+2+o]=c[l]+s;var a=new Geometry({attributes:a,indices:IndexDatatype$1.createTypedArray(2*s/3,c),primitiveType:PrimitiveType$1.TRIANGLES}),e=computeWallAttributes(n,e),c=computeWallIndices(n),n=new Geometry({attributes:e,indices:IndexDatatype$1.createTypedArray(2*n.length/3,c),primitiveType:PrimitiveType$1.TRIANGLES}),n=GeometryPipeline.combineInstances([new GeometryInstance({geometry:a}),new GeometryInstance({geometry:n})]);return{boundingSphere:r,attributes:n[0].attributes,indices:n[0].indices}}function computeRectangle(e,t,i,r,n,a,o){for(var s=EllipseGeometryLibrary.computeEllipsePositions({center:e,semiMajorAxis:t,semiMinorAxis:i,rotation:r,granularity:n},!1,!0).outerPositions,l=s.length/3,c=new Array(l),u=0;u<l;++u)c[u]=Cartesian3.fromArray(s,3*u);o=Rectangle.fromCartesianArray(c,a,o);return o.width>CesiumMath.PI&&(o.north=0<o.north?CesiumMath.PI_OVER_TWO-CesiumMath.EPSILON7:o.north,o.south=o.south<0?CesiumMath.EPSILON7-CesiumMath.PI_OVER_TWO:o.south,o.east=CesiumMath.PI,o.west=-CesiumMath.PI),o}function EllipseGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84),r=e.semiMajorAxis,n=e.semiMinorAxis,a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),s=defaultValue(e.height,0),l=defaultValue(e.extrudedHeight,s);this._center=Cartesian3.clone(t),this._semiMajorAxis=r,this._semiMinorAxis=n,this._ellipsoid=Ellipsoid.clone(i),this._rotation=defaultValue(e.rotation,0),this._stRotation=defaultValue(e.stRotation,0),this._height=Math.max(l,s),this._granularity=a,this._vertexFormat=VertexFormat.clone(o),this._extrudedHeight=Math.min(l,s),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createEllipseGeometry",this._offsetAttribute=e.offsetAttribute,this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0}EllipseGeometry.packedLength=Cartesian3.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+9,EllipseGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._center,t,i),i+=Cartesian3.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._semiMajorAxis,t[i++]=e._semiMinorAxis,t[i++]=e._rotation,t[i++]=e._stRotation,t[i++]=e._height,t[i++]=e._granularity,t[i++]=e._extrudedHeight,t[i++]=e._shadowVolume?1:0,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchCenter$1=new Cartesian3,scratchEllipsoid=new Ellipsoid,scratchVertexFormat$1=new VertexFormat,scratchOptions$2={center:scratchCenter$1,ellipsoid:scratchEllipsoid,vertexFormat:scratchVertexFormat$1,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,shadowVolume:void 0,offsetAttribute:void 0};function textureCoordinateRotationPoints(e){var t=-e._stRotation;if(0==t)return[0,0,0,1,1,0];for(var i=EllipseGeometryLibrary.computeEllipsePositions({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,rotation:e._rotation,granularity:e._granularity},!1,!0).outerPositions,r=i.length/3,n=new Array(r),a=0;a<r;++a)n[a]=Cartesian3.fromArray(i,3*a);var o=e._ellipsoid,e=e.rectangle;return Geometry._textureCoordinateRotationPoints(n,t,o,e)}function CircleGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).radius,e={center:e.center,semiMajorAxis:t,semiMinorAxis:t,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,vertexFormat:e.vertexFormat,stRotation:e.stRotation,shadowVolume:e.shadowVolume};this._ellipseGeometry=new EllipseGeometry(e),this._workerName="createCircleGeometry"}EllipseGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchCenter$1);t+=Cartesian3.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$1);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t++],p=1===e[t++],t=e[t];return defined(i)?(i._center=Cartesian3.clone(r,i._center),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._semiMajorAxis=o,i._semiMinorAxis=s,i._rotation=l,i._stRotation=c,i._height=u,i._granularity=d,i._extrudedHeight=h,i._shadowVolume=p,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$2.height=u,scratchOptions$2.extrudedHeight=h,scratchOptions$2.granularity=d,scratchOptions$2.stRotation=c,scratchOptions$2.rotation=l,scratchOptions$2.semiMajorAxis=o,scratchOptions$2.semiMinorAxis=s,scratchOptions$2.shadowVolume=p,scratchOptions$2.offsetAttribute=-1===t?void 0:t,new EllipseGeometry(scratchOptions$2))},EllipseGeometry.computeRectangle=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=e.semiMajorAxis,a=e.semiMinorAxis,o=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE);return computeRectangle(i,n,a,defaultValue(e.rotation,0),o,r,t)},EllipseGeometry.createGeometry=function(e){if(!(e._semiMajorAxis<=0||e._semiMinorAxis<=0)){var t=e._height,i=e._extrudedHeight,r=!CesiumMath.equalsEpsilon(t,i,0,CesiumMath.EPSILON2);e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var n,t={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:t,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};return r?(t.extrudedHeight=i,t.shadowVolume=e._shadowVolume,t.offsetAttribute=e._offsetAttribute,n=computeExtrudedEllipse(t)):(n=computeEllipse(t),defined(e._offsetAttribute)&&(t=n.attributes.position.values.length,arrayFill(t=new Uint8Array(t/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),n.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t}))),new Geometry({attributes:n.attributes,indices:n.indices,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:n.boundingSphere,offsetAttribute:e._offsetAttribute})}},EllipseGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,t=t(r,n),i=i(r,n);return new EllipseGeometry({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:n,rotation:e._rotation,stRotation:e._stRotation,granularity:r,extrudedHeight:t,height:i,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(EllipseGeometry.prototype,{rectangle:{get:function(){return defined(this._rectangle)||(this._rectangle=computeRectangle(this._center,this._semiMajorAxis,this._semiMinorAxis,this._rotation,this._granularity,this._ellipsoid)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints(this)),this._textureCoordinateRotationPoints}}}),CircleGeometry.packedLength=EllipseGeometry.packedLength,CircleGeometry.pack=function(e,t,i){return EllipseGeometry.pack(e._ellipseGeometry,t,i)};var scratchEllipseGeometry=new EllipseGeometry({center:new Cartesian3,semiMajorAxis:1,semiMinorAxis:1}),scratchOptions$3={center:new Cartesian3,radius:void 0,ellipsoid:Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,vertexFormat:new VertexFormat,stRotation:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0,shadowVolume:void 0};CircleGeometry.unpack=function(e,t,i){t=EllipseGeometry.unpack(e,t,scratchEllipseGeometry);return scratchOptions$3.center=Cartesian3.clone(t._center,scratchOptions$3.center),scratchOptions$3.ellipsoid=Ellipsoid.clone(t._ellipsoid,scratchOptions$3.ellipsoid),scratchOptions$3.height=t._height,scratchOptions$3.extrudedHeight=t._extrudedHeight,scratchOptions$3.granularity=t._granularity,scratchOptions$3.vertexFormat=VertexFormat.clone(t._vertexFormat,scratchOptions$3.vertexFormat),scratchOptions$3.stRotation=t._stRotation,scratchOptions$3.shadowVolume=t._shadowVolume,defined(i)?(scratchOptions$3.semiMajorAxis=t._semiMajorAxis,scratchOptions$3.semiMinorAxis=t._semiMinorAxis,i._ellipseGeometry=new EllipseGeometry(scratchOptions$3),i):(scratchOptions$3.radius=t._semiMajorAxis,new CircleGeometry(scratchOptions$3))},CircleGeometry.createGeometry=function(e){return EllipseGeometry.createGeometry(e._ellipseGeometry)},CircleGeometry.createShadowVolume=function(e,t,i){var r=e._ellipseGeometry._granularity,n=e._ellipseGeometry._ellipsoid,t=t(r,n),i=i(r,n);return new CircleGeometry({center:e._ellipseGeometry._center,radius:e._ellipseGeometry._semiMajorAxis,ellipsoid:n,stRotation:e._ellipseGeometry._stRotation,granularity:r,extrudedHeight:t,height:i,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(CircleGeometry.prototype,{rectangle:{get:function(){return this._ellipseGeometry.rectangle}},textureCoordinateRotationPoints:{get:function(){return this._ellipseGeometry.textureCoordinateRotationPoints}}});var scratchCartesian1$4=new Cartesian3,boundingSphereCenter$1=new Cartesian3;function computeEllipse$1(e){var t=e.center;boundingSphereCenter$1=Cartesian3.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,boundingSphereCenter$1),e.height,boundingSphereCenter$1);for(var i=new BoundingSphere(boundingSphereCenter$1=Cartesian3.add(t,boundingSphereCenter$1,boundingSphereCenter$1),e.semiMajorAxis),t=EllipseGeometryLibrary.computeEllipsePositions(e,!1,!0).outerPositions,e=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:EllipseGeometryLibrary.raisePositionsToHeight(t,e,!1)})}),r=t.length/3,n=IndexDatatype$1.createTypedArray(r,2*r),a=0,o=0;o<r;++o)n[a++]=o,n[a++]=(o+1)%r;return{boundingSphere:i,attributes:e,indices:n}}var topBoundingSphere$1=new BoundingSphere,bottomBoundingSphere$1=new BoundingSphere;function computeExtrudedEllipse$1(e){var t=e.center,i=e.ellipsoid,r=e.semiMajorAxis,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,scratchCartesian1$4),e.height,scratchCartesian1$4);topBoundingSphere$1.center=Cartesian3.add(t,n,topBoundingSphere$1.center),topBoundingSphere$1.radius=r,n=Cartesian3.multiplyByScalar(i.geodeticSurfaceNormal(t,n),e.extrudedHeight,n),bottomBoundingSphere$1.center=Cartesian3.add(t,n,bottomBoundingSphere$1.center),bottomBoundingSphere$1.radius=r;var t=EllipseGeometryLibrary.computeEllipsePositions(e,!1,!0).outerPositions,n=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:EllipseGeometryLibrary.raisePositionsToHeight(t,e,!0)})}),t=n.position.values,r=BoundingSphere.union(topBoundingSphere$1,bottomBoundingSphere$1),a=t.length/3;defined(e.offsetAttribute)&&(o=new Uint8Array(a),o=e.offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(o,1,0,a/2):arrayFill(o,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),n.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:o}));var o=defaultValue(e.numberOfVerticalLines,16),o=CesiumMath.clamp(o,0,a/2),s=IndexDatatype$1.createTypedArray(a,2*a+2*o);a/=2;var l=0;for(d=0;d<a;++d)s[l++]=d,s[l++]=(d+1)%a,s[l++]=d+a,s[l++]=(d+1)%a+a;if(0<o)for(var e=Math.min(o,a),c=Math.round(a/e),u=Math.min(c*o,a),d=0;d<u;d+=c)s[l++]=d,s[l++]=d+a;return{boundingSphere:r,attributes:n,indices:s}}function EllipseOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).center,i=defaultValue(e.ellipsoid,Ellipsoid.WGS84),r=e.semiMajorAxis,n=e.semiMinorAxis,a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.height,0),s=defaultValue(e.extrudedHeight,o);this._center=Cartesian3.clone(t),this._semiMajorAxis=r,this._semiMinorAxis=n,this._ellipsoid=Ellipsoid.clone(i),this._rotation=defaultValue(e.rotation,0),this._height=Math.max(s,o),this._granularity=a,this._extrudedHeight=Math.min(s,o),this._numberOfVerticalLines=Math.max(defaultValue(e.numberOfVerticalLines,16),0),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipseOutlineGeometry"}EllipseOutlineGeometry.packedLength=Cartesian3.packedLength+Ellipsoid.packedLength+8,EllipseOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._center,t,i),i+=Cartesian3.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._semiMajorAxis,t[i++]=e._semiMinorAxis,t[i++]=e._rotation,t[i++]=e._height,t[i++]=e._granularity,t[i++]=e._extrudedHeight,t[i++]=e._numberOfVerticalLines,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchCenter$2=new Cartesian3,scratchEllipsoid$1=new Ellipsoid,scratchOptions$4={center:scratchCenter$2,ellipsoid:scratchEllipsoid$1,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,numberOfVerticalLines:void 0,offsetAttribute:void 0};function CircleOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).radius,e={center:e.center,semiMajorAxis:t,semiMinorAxis:t,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,numberOfVerticalLines:e.numberOfVerticalLines};this._ellipseGeometry=new EllipseOutlineGeometry(e),this._workerName="createCircleOutlineGeometry"}EllipseOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchCenter$2);t+=Cartesian3.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$1);t+=Ellipsoid.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],t=e[t];return defined(i)?(i._center=Cartesian3.clone(r,i._center),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._semiMajorAxis=a,i._semiMinorAxis=o,i._rotation=s,i._height=l,i._granularity=c,i._extrudedHeight=u,i._numberOfVerticalLines=d,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$4.height=l,scratchOptions$4.extrudedHeight=u,scratchOptions$4.granularity=c,scratchOptions$4.rotation=s,scratchOptions$4.semiMajorAxis=a,scratchOptions$4.semiMinorAxis=o,scratchOptions$4.numberOfVerticalLines=d,scratchOptions$4.offsetAttribute=-1===t?void 0:t,new EllipseOutlineGeometry(scratchOptions$4))},EllipseOutlineGeometry.createGeometry=function(e){if(!(e._semiMajorAxis<=0||e._semiMinorAxis<=0)){var t=e._height,i=e._extrudedHeight,r=!CesiumMath.equalsEpsilon(t,i,0,CesiumMath.EPSILON2);e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var n,t={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:t,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines};return r?(t.extrudedHeight=i,t.offsetAttribute=e._offsetAttribute,n=computeExtrudedEllipse$1(t)):(n=computeEllipse$1(t),defined(e._offsetAttribute)&&(t=n.attributes.position.values.length,arrayFill(t=new Uint8Array(t/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),n.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t}))),new Geometry({attributes:n.attributes,indices:n.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:n.boundingSphere,offsetAttribute:e._offsetAttribute})}},CircleOutlineGeometry.packedLength=EllipseOutlineGeometry.packedLength,CircleOutlineGeometry.pack=function(e,t,i){return EllipseOutlineGeometry.pack(e._ellipseGeometry,t,i)};var scratchEllipseGeometry$1=new EllipseOutlineGeometry({center:new Cartesian3,semiMajorAxis:1,semiMinorAxis:1}),scratchOptions$5={center:new Cartesian3,radius:void 0,ellipsoid:Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,numberOfVerticalLines:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0};CircleOutlineGeometry.unpack=function(e,t,i){t=EllipseOutlineGeometry.unpack(e,t,scratchEllipseGeometry$1);return scratchOptions$5.center=Cartesian3.clone(t._center,scratchOptions$5.center),scratchOptions$5.ellipsoid=Ellipsoid.clone(t._ellipsoid,scratchOptions$5.ellipsoid),scratchOptions$5.height=t._height,scratchOptions$5.extrudedHeight=t._extrudedHeight,scratchOptions$5.granularity=t._granularity,scratchOptions$5.numberOfVerticalLines=t._numberOfVerticalLines,defined(i)?(scratchOptions$5.semiMajorAxis=t._semiMajorAxis,scratchOptions$5.semiMinorAxis=t._semiMinorAxis,i._ellipseGeometry=new EllipseOutlineGeometry(scratchOptions$5),i):(scratchOptions$5.radius=t._semiMajorAxis,new CircleOutlineGeometry(scratchOptions$5))},CircleOutlineGeometry.createGeometry=function(e){return EllipseOutlineGeometry.createGeometry(e._ellipseGeometry)};var ClockRange={UNBOUNDED:0,CLAMPED:1,LOOP_STOP:2},ClockRange$1=Object.freeze(ClockRange),ClockStep={TICK_DEPENDENT:0,SYSTEM_CLOCK_MULTIPLIER:1,SYSTEM_CLOCK:2},ClockStep$1=Object.freeze(ClockStep),getTimestamp,getTimestamp="undefined"!=typeof performance&&"function"==typeof performance.now&&isFinite(performance.now())?function(){return performance.now()}:function(){return Date.now()},getTimestamp$1=getTimestamp,scratchArrayBuffer,scratchUint32Array,scratchUint8Array;function Clock(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).currentTime,i=e.startTime,r=e.stopTime,t=defined(t)?JulianDate.clone(t):defined(i)?JulianDate.clone(i):defined(r)?JulianDate.addDays(r,-1,new JulianDate):JulianDate.now(),i=defined(i)?JulianDate.clone(i):JulianDate.clone(t),r=defined(r)?JulianDate.clone(r):JulianDate.addDays(i,1,new JulianDate);this.startTime=i,this.stopTime=r,this.clockRange=defaultValue(e.clockRange,ClockRange$1.UNBOUNDED),this.canAnimate=defaultValue(e.canAnimate,!0),this.onTick=new Event,this.onStop=new Event,this._currentTime=void 0,this._multiplier=void 0,this._clockStep=void 0,this._shouldAnimate=void 0,this._lastSystemTime=getTimestamp$1(),this.currentTime=t,this.multiplier=defaultValue(e.multiplier,1),this.shouldAnimate=defaultValue(e.shouldAnimate,!1),this.clockStep=defaultValue(e.clockStep,ClockStep$1.SYSTEM_CLOCK_MULTIPLIER)}function hue2rgb(e,t,i){return i<0&&(i+=1),1<i&&--i,6*i<1?e+6*(t-e)*i:2*i<1?t:3*i<2?e+(t-e)*(2/3-i)*6:e}function Color(e,t,i,r){this.red=defaultValue(e,1),this.green=defaultValue(t,1),this.blue=defaultValue(i,1),this.alpha=defaultValue(r,1)}Object.defineProperties(Clock.prototype,{currentTime:{get:function(){return this._currentTime},set:function(e){JulianDate.equals(this._currentTime,e)||(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._currentTime=e)}},multiplier:{get:function(){return this._multiplier},set:function(e){this._multiplier!==e&&(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._multiplier=e)}},clockStep:{get:function(){return this._clockStep},set:function(e){e===ClockStep$1.SYSTEM_CLOCK&&(this._multiplier=1,this._shouldAnimate=!0,this._currentTime=JulianDate.now()),this._clockStep=e}},shouldAnimate:{get:function(){return this._shouldAnimate},set:function(e){this._shouldAnimate!==e&&(this._clockStep===ClockStep$1.SYSTEM_CLOCK&&(this._clockStep=ClockStep$1.SYSTEM_CLOCK_MULTIPLIER),this._shouldAnimate=e)}}}),Clock.prototype.tick=function(){var e=getTimestamp$1(),t=JulianDate.clone(this._currentTime);if(this.canAnimate&&this._shouldAnimate){var i=this._clockStep;if(i===ClockStep$1.SYSTEM_CLOCK)t=JulianDate.now(t);else{var r=this._multiplier;t=i===ClockStep$1.TICK_DEPENDENT?JulianDate.addSeconds(t,r,t):(n=e-this._lastSystemTime,JulianDate.addSeconds(t,r*(n/1e3),t));var n=this.clockRange,a=this.startTime,o=this.stopTime;if(n===ClockRange$1.CLAMPED)JulianDate.lessThan(t,a)?t=JulianDate.clone(a,t):JulianDate.greaterThan(t,o)&&(t=JulianDate.clone(o,t),this.onStop.raiseEvent(this));else if(n===ClockRange$1.LOOP_STOP)for(JulianDate.lessThan(t,a)&&(t=JulianDate.clone(a,t));JulianDate.greaterThan(t,o);)t=JulianDate.addSeconds(a,JulianDate.secondsDifference(t,o),t),this.onStop.raiseEvent(this)}}return this._currentTime=t,this._lastSystemTime=e,this.onTick.raiseEvent(this),t},Color.fromCartesian4=function(e,t){return defined(t)?(t.red=e.x,t.green=e.y,t.blue=e.z,t.alpha=e.w,t):new Color(e.x,e.y,e.z,e.w)},Color.fromBytes=function(e,t,i,r,n){return e=Color.byteToFloat(defaultValue(e,255)),t=Color.byteToFloat(defaultValue(t,255)),i=Color.byteToFloat(defaultValue(i,255)),r=Color.byteToFloat(defaultValue(r,255)),defined(n)?(n.red=e,n.green=t,n.blue=i,n.alpha=r,n):new Color(e,t,i,r)},Color.fromAlpha=function(e,t,i){return defined(i)?(i.red=e.red,i.green=e.green,i.blue=e.blue,i.alpha=t,i):new Color(e.red,e.green,e.blue,t)},FeatureDetection.supportsTypedArrays()&&(scratchArrayBuffer=new ArrayBuffer(4),scratchUint32Array=new Uint32Array(scratchArrayBuffer),scratchUint8Array=new Uint8Array(scratchArrayBuffer)),Color.fromRgba=function(e,t){return scratchUint32Array[0]=e,Color.fromBytes(scratchUint8Array[0],scratchUint8Array[1],scratchUint8Array[2],scratchUint8Array[3],t)},Color.fromHsl=function(e,t,i,r,n){e=defaultValue(e,0)%1,t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,1);var a=i,o=i,s=i;return 0!==t&&(a=hue2rgb(t=2*i-(i=i<.5?i*(1+t):i+t-i*t),i,e+1/3),o=hue2rgb(t,i,e),s=hue2rgb(t,i,e-1/3)),defined(n)?(n.red=a,n.green=o,n.blue=s,n.alpha=r,n):new Color(a,o,s,r)},Color.fromRandom=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).red;defined(i)||(r=defaultValue(e.minimumRed,0),n=defaultValue(e.maximumRed,1),i=r+CesiumMath.nextRandomNumber()*(n-r));var r,n=e.green;defined(n)||(a=defaultValue(e.minimumGreen,0),r=defaultValue(e.maximumGreen,1),n=a+CesiumMath.nextRandomNumber()*(r-a));var a=e.blue;defined(a)||(o=defaultValue(e.minimumBlue,0),s=defaultValue(e.maximumBlue,1),a=o+CesiumMath.nextRandomNumber()*(s-o));var o,s=e.alpha;return defined(s)||(o=defaultValue(e.minimumAlpha,0),e=defaultValue(e.maximumAlpha,1),s=o+CesiumMath.nextRandomNumber()*(e-o)),defined(t)?(t.red=i,t.green=n,t.blue=a,t.alpha=s,t):new Color(i,n,a,s)};var rgbaMatcher=/^#([0-9a-f])([0-9a-f])([0-9a-f])([0-9a-f])?$/i,rrggbbaaMatcher=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})?$/i,rgbParenthesesMatcher=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,hslParenthesesMatcher=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;function ColorGeometryInstanceAttribute(e,t,i,r){e=defaultValue(e,1),t=defaultValue(t,1),i=defaultValue(i,1),r=defaultValue(r,1),this.value=new Uint8Array([Color.floatToByte(e),Color.floatToByte(t),Color.floatToByte(i),Color.floatToByte(r)])}function CompressedTextureBuffer(e,t,i,r){this._format=e,this._width=t,this._height=i,this._buffer=r}Color.fromCssColorString=function(e,t){defined(t)||(t=new Color);var i=Color[(e=e.replace(/\s/g,"")).toUpperCase()];if(defined(i))return Color.clone(i,t),t;i=rgbaMatcher.exec(e);return null!==i?(t.red=parseInt(i[1],16)/15,t.green=parseInt(i[2],16)/15,t.blue=parseInt(i[3],16)/15,t.alpha=parseInt(defaultValue(i[4],"f"),16)/15,t):null!==(i=rrggbbaaMatcher.exec(e))?(t.red=parseInt(i[1],16)/255,t.green=parseInt(i[2],16)/255,t.blue=parseInt(i[3],16)/255,t.alpha=parseInt(defaultValue(i[4],"ff"),16)/255,t):null!==(i=rgbParenthesesMatcher.exec(e))?(t.red=parseFloat(i[1])/("%"===i[1].substr(-1)?100:255),t.green=parseFloat(i[2])/("%"===i[2].substr(-1)?100:255),t.blue=parseFloat(i[3])/("%"===i[3].substr(-1)?100:255),t.alpha=parseFloat(defaultValue(i[4],"1.0")),t):null!==(i=hslParenthesesMatcher.exec(e))?Color.fromHsl(parseFloat(i[1])/360,parseFloat(i[2])/100,parseFloat(i[3])/100,parseFloat(defaultValue(i[4],"1.0")),t):t=void 0},Color.packedLength=4,Color.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.red,t[i++]=e.green,t[i++]=e.blue,t[i]=e.alpha,t},Color.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new Color),i.red=e[t++],i.green=e[t++],i.blue=e[t++],i.alpha=e[t],i},Color.byteToFloat=function(e){return e/255},Color.floatToByte=function(e){return 1===e?255:256*e|0},Color.clone=function(e,t){if(defined(e))return defined(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new Color(e.red,e.green,e.blue,e.alpha)},Color.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},Color.equalsArray=function(e,t,i){return e.red===t[i]&&e.green===t[i+1]&&e.blue===t[i+2]&&e.alpha===t[i+3]},Color.prototype.clone=function(e){return Color.clone(this,e)},Color.prototype.equals=function(e){return Color.equals(this,e)},Color.prototype.equalsEpsilon=function(e,t){return this===e||defined(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},Color.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},Color.prototype.toCssColorString=function(){var e=Color.floatToByte(this.red),t=Color.floatToByte(this.green),i=Color.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+i+")":"rgba("+e+","+t+","+i+","+this.alpha+")"},Color.prototype.toCssHexString=function(){var e=Color.floatToByte(this.red).toString(16);e.length<2&&(e="0"+e);var t=Color.floatToByte(this.green).toString(16);t.length<2&&(t="0"+t);var i=Color.floatToByte(this.blue).toString(16);if(i.length<2&&(i="0"+i),this.alpha<1){var r=Color.floatToByte(this.alpha).toString(16);return r.length<2&&(r="0"+r),"#"+e+t+i+r}return"#"+e+t+i},Color.prototype.toBytes=function(e){var t=Color.floatToByte(this.red),i=Color.floatToByte(this.green),r=Color.floatToByte(this.blue),n=Color.floatToByte(this.alpha);return defined(e)?(e[0]=t,e[1]=i,e[2]=r,e[3]=n,e):[t,i,r,n]},Color.prototype.toRgba=function(){return scratchUint8Array[0]=Color.floatToByte(this.red),scratchUint8Array[1]=Color.floatToByte(this.green),scratchUint8Array[2]=Color.floatToByte(this.blue),scratchUint8Array[3]=Color.floatToByte(this.alpha),scratchUint32Array[0]},Color.prototype.brighten=function(e,t){return e=1-e,t.red=1-(1-this.red)*e,t.green=1-(1-this.green)*e,t.blue=1-(1-this.blue)*e,t.alpha=this.alpha,t},Color.prototype.darken=function(e,t){return e=1-e,t.red=this.red*e,t.green=this.green*e,t.blue=this.blue*e,t.alpha=this.alpha,t},Color.prototype.withAlpha=function(e,t){return Color.fromAlpha(this,e,t)},Color.add=function(e,t,i){return i.red=e.red+t.red,i.green=e.green+t.green,i.blue=e.blue+t.blue,i.alpha=e.alpha+t.alpha,i},Color.subtract=function(e,t,i){return i.red=e.red-t.red,i.green=e.green-t.green,i.blue=e.blue-t.blue,i.alpha=e.alpha-t.alpha,i},Color.multiply=function(e,t,i){return i.red=e.red*t.red,i.green=e.green*t.green,i.blue=e.blue*t.blue,i.alpha=e.alpha*t.alpha,i},Color.divide=function(e,t,i){return i.red=e.red/t.red,i.green=e.green/t.green,i.blue=e.blue/t.blue,i.alpha=e.alpha/t.alpha,i},Color.mod=function(e,t,i){return i.red=e.red%t.red,i.green=e.green%t.green,i.blue=e.blue%t.blue,i.alpha=e.alpha%t.alpha,i},Color.lerp=function(e,t,i,r){return r.red=CesiumMath.lerp(e.red,t.red,i),r.green=CesiumMath.lerp(e.green,t.green,i),r.blue=CesiumMath.lerp(e.blue,t.blue,i),r.alpha=CesiumMath.lerp(e.alpha,t.alpha,i),r},Color.multiplyByScalar=function(e,t,i){return i.red=e.red*t,i.green=e.green*t,i.blue=e.blue*t,i.alpha=e.alpha*t,i},Color.divideByScalar=function(e,t,i){return i.red=e.red/t,i.green=e.green/t,i.blue=e.blue/t,i.alpha=e.alpha/t,i},Color.ALICEBLUE=Object.freeze(Color.fromCssColorString("#F0F8FF")),Color.ANTIQUEWHITE=Object.freeze(Color.fromCssColorString("#FAEBD7")),Color.AQUA=Object.freeze(Color.fromCssColorString("#00FFFF")),Color.AQUAMARINE=Object.freeze(Color.fromCssColorString("#7FFFD4")),Color.AZURE=Object.freeze(Color.fromCssColorString("#F0FFFF")),Color.BEIGE=Object.freeze(Color.fromCssColorString("#F5F5DC")),Color.BISQUE=Object.freeze(Color.fromCssColorString("#FFE4C4")),Color.BLACK=Object.freeze(Color.fromCssColorString("#000000")),Color.BLANCHEDALMOND=Object.freeze(Color.fromCssColorString("#FFEBCD")),Color.BLUE=Object.freeze(Color.fromCssColorString("#0000FF")),Color.BLUEVIOLET=Object.freeze(Color.fromCssColorString("#8A2BE2")),Color.BROWN=Object.freeze(Color.fromCssColorString("#A52A2A")),Color.BURLYWOOD=Object.freeze(Color.fromCssColorString("#DEB887")),Color.CADETBLUE=Object.freeze(Color.fromCssColorString("#5F9EA0")),Color.CHARTREUSE=Object.freeze(Color.fromCssColorString("#7FFF00")),Color.CHOCOLATE=Object.freeze(Color.fromCssColorString("#D2691E")),Color.CORAL=Object.freeze(Color.fromCssColorString("#FF7F50")),Color.CORNFLOWERBLUE=Object.freeze(Color.fromCssColorString("#6495ED")),Color.CORNSILK=Object.freeze(Color.fromCssColorString("#FFF8DC")),Color.CRIMSON=Object.freeze(Color.fromCssColorString("#DC143C")),Color.CYAN=Object.freeze(Color.fromCssColorString("#00FFFF")),Color.DARKBLUE=Object.freeze(Color.fromCssColorString("#00008B")),Color.DARKCYAN=Object.freeze(Color.fromCssColorString("#008B8B")),Color.DARKGOLDENROD=Object.freeze(Color.fromCssColorString("#B8860B")),Color.DARKGRAY=Object.freeze(Color.fromCssColorString("#A9A9A9")),Color.DARKGREEN=Object.freeze(Color.fromCssColorString("#006400")),Color.DARKGREY=Color.DARKGRAY,Color.DARKKHAKI=Object.freeze(Color.fromCssColorString("#BDB76B")),Color.DARKMAGENTA=Object.freeze(Color.fromCssColorString("#8B008B")),Color.DARKOLIVEGREEN=Object.freeze(Color.fromCssColorString("#556B2F")),Color.DARKORANGE=Object.freeze(Color.fromCssColorString("#FF8C00")),Color.DARKORCHID=Object.freeze(Color.fromCssColorString("#9932CC")),Color.DARKRED=Object.freeze(Color.fromCssColorString("#8B0000")),Color.DARKSALMON=Object.freeze(Color.fromCssColorString("#E9967A")),Color.DARKSEAGREEN=Object.freeze(Color.fromCssColorString("#8FBC8F")),Color.DARKSLATEBLUE=Object.freeze(Color.fromCssColorString("#483D8B")),Color.DARKSLATEGRAY=Object.freeze(Color.fromCssColorString("#2F4F4F")),Color.DARKSLATEGREY=Color.DARKSLATEGRAY,Color.DARKTURQUOISE=Object.freeze(Color.fromCssColorString("#00CED1")),Color.DARKVIOLET=Object.freeze(Color.fromCssColorString("#9400D3")),Color.DEEPPINK=Object.freeze(Color.fromCssColorString("#FF1493")),Color.DEEPSKYBLUE=Object.freeze(Color.fromCssColorString("#00BFFF")),Color.DIMGRAY=Object.freeze(Color.fromCssColorString("#696969")),Color.DIMGREY=Color.DIMGRAY,Color.DODGERBLUE=Object.freeze(Color.fromCssColorString("#1E90FF")),Color.FIREBRICK=Object.freeze(Color.fromCssColorString("#B22222")),Color.FLORALWHITE=Object.freeze(Color.fromCssColorString("#FFFAF0")),Color.FORESTGREEN=Object.freeze(Color.fromCssColorString("#228B22")),Color.FUCHSIA=Object.freeze(Color.fromCssColorString("#FF00FF")),Color.GAINSBORO=Object.freeze(Color.fromCssColorString("#DCDCDC")),Color.GHOSTWHITE=Object.freeze(Color.fromCssColorString("#F8F8FF")),Color.GOLD=Object.freeze(Color.fromCssColorString("#FFD700")),Color.GOLDENROD=Object.freeze(Color.fromCssColorString("#DAA520")),Color.GRAY=Object.freeze(Color.fromCssColorString("#808080")),Color.GREEN=Object.freeze(Color.fromCssColorString("#008000")),Color.GREENYELLOW=Object.freeze(Color.fromCssColorString("#ADFF2F")),Color.GREY=Color.GRAY,Color.HONEYDEW=Object.freeze(Color.fromCssColorString("#F0FFF0")),Color.HOTPINK=Object.freeze(Color.fromCssColorString("#FF69B4")),Color.INDIANRED=Object.freeze(Color.fromCssColorString("#CD5C5C")),Color.INDIGO=Object.freeze(Color.fromCssColorString("#4B0082")),Color.IVORY=Object.freeze(Color.fromCssColorString("#FFFFF0")),Color.KHAKI=Object.freeze(Color.fromCssColorString("#F0E68C")),Color.LAVENDER=Object.freeze(Color.fromCssColorString("#E6E6FA")),Color.LAVENDAR_BLUSH=Object.freeze(Color.fromCssColorString("#FFF0F5")),Color.LAWNGREEN=Object.freeze(Color.fromCssColorString("#7CFC00")),Color.LEMONCHIFFON=Object.freeze(Color.fromCssColorString("#FFFACD")),Color.LIGHTBLUE=Object.freeze(Color.fromCssColorString("#ADD8E6")),Color.LIGHTCORAL=Object.freeze(Color.fromCssColorString("#F08080")),Color.LIGHTCYAN=Object.freeze(Color.fromCssColorString("#E0FFFF")),Color.LIGHTGOLDENRODYELLOW=Object.freeze(Color.fromCssColorString("#FAFAD2")),Color.LIGHTGRAY=Object.freeze(Color.fromCssColorString("#D3D3D3")),Color.LIGHTGREEN=Object.freeze(Color.fromCssColorString("#90EE90")),Color.LIGHTGREY=Color.LIGHTGRAY,Color.LIGHTPINK=Object.freeze(Color.fromCssColorString("#FFB6C1")),Color.LIGHTSEAGREEN=Object.freeze(Color.fromCssColorString("#20B2AA")),Color.LIGHTSKYBLUE=Object.freeze(Color.fromCssColorString("#87CEFA")),Color.LIGHTSLATEGRAY=Object.freeze(Color.fromCssColorString("#778899")),Color.LIGHTSLATEGREY=Color.LIGHTSLATEGRAY,Color.LIGHTSTEELBLUE=Object.freeze(Color.fromCssColorString("#B0C4DE")),Color.LIGHTYELLOW=Object.freeze(Color.fromCssColorString("#FFFFE0")),Color.LIME=Object.freeze(Color.fromCssColorString("#00FF00")),Color.LIMEGREEN=Object.freeze(Color.fromCssColorString("#32CD32")),Color.LINEN=Object.freeze(Color.fromCssColorString("#FAF0E6")),Color.MAGENTA=Object.freeze(Color.fromCssColorString("#FF00FF")),Color.MAROON=Object.freeze(Color.fromCssColorString("#800000")),Color.MEDIUMAQUAMARINE=Object.freeze(Color.fromCssColorString("#66CDAA")),Color.MEDIUMBLUE=Object.freeze(Color.fromCssColorString("#0000CD")),Color.MEDIUMORCHID=Object.freeze(Color.fromCssColorString("#BA55D3")),Color.MEDIUMPURPLE=Object.freeze(Color.fromCssColorString("#9370DB")),Color.MEDIUMSEAGREEN=Object.freeze(Color.fromCssColorString("#3CB371")),Color.MEDIUMSLATEBLUE=Object.freeze(Color.fromCssColorString("#7B68EE")),Color.MEDIUMSPRINGGREEN=Object.freeze(Color.fromCssColorString("#00FA9A")),Color.MEDIUMTURQUOISE=Object.freeze(Color.fromCssColorString("#48D1CC")),Color.MEDIUMVIOLETRED=Object.freeze(Color.fromCssColorString("#C71585")),Color.MIDNIGHTBLUE=Object.freeze(Color.fromCssColorString("#191970")),Color.MINTCREAM=Object.freeze(Color.fromCssColorString("#F5FFFA")),Color.MISTYROSE=Object.freeze(Color.fromCssColorString("#FFE4E1")),Color.MOCCASIN=Object.freeze(Color.fromCssColorString("#FFE4B5")),Color.NAVAJOWHITE=Object.freeze(Color.fromCssColorString("#FFDEAD")),Color.NAVY=Object.freeze(Color.fromCssColorString("#000080")),Color.OLDLACE=Object.freeze(Color.fromCssColorString("#FDF5E6")),Color.OLIVE=Object.freeze(Color.fromCssColorString("#808000")),Color.OLIVEDRAB=Object.freeze(Color.fromCssColorString("#6B8E23")),Color.ORANGE=Object.freeze(Color.fromCssColorString("#FFA500")),Color.ORANGERED=Object.freeze(Color.fromCssColorString("#FF4500")),Color.ORCHID=Object.freeze(Color.fromCssColorString("#DA70D6")),Color.PALEGOLDENROD=Object.freeze(Color.fromCssColorString("#EEE8AA")),Color.PALEGREEN=Object.freeze(Color.fromCssColorString("#98FB98")),Color.PALETURQUOISE=Object.freeze(Color.fromCssColorString("#AFEEEE")),Color.PALEVIOLETRED=Object.freeze(Color.fromCssColorString("#DB7093")),Color.PAPAYAWHIP=Object.freeze(Color.fromCssColorString("#FFEFD5")),Color.PEACHPUFF=Object.freeze(Color.fromCssColorString("#FFDAB9")),Color.PERU=Object.freeze(Color.fromCssColorString("#CD853F")),Color.PINK=Object.freeze(Color.fromCssColorString("#FFC0CB")),Color.PLUM=Object.freeze(Color.fromCssColorString("#DDA0DD")),Color.POWDERBLUE=Object.freeze(Color.fromCssColorString("#B0E0E6")),Color.PURPLE=Object.freeze(Color.fromCssColorString("#800080")),Color.RED=Object.freeze(Color.fromCssColorString("#FF0000")),Color.ROSYBROWN=Object.freeze(Color.fromCssColorString("#BC8F8F")),Color.ROYALBLUE=Object.freeze(Color.fromCssColorString("#4169E1")),Color.SADDLEBROWN=Object.freeze(Color.fromCssColorString("#8B4513")),Color.SALMON=Object.freeze(Color.fromCssColorString("#FA8072")),Color.SANDYBROWN=Object.freeze(Color.fromCssColorString("#F4A460")),Color.SEAGREEN=Object.freeze(Color.fromCssColorString("#2E8B57")),Color.SEASHELL=Object.freeze(Color.fromCssColorString("#FFF5EE")),Color.SIENNA=Object.freeze(Color.fromCssColorString("#A0522D")),Color.SILVER=Object.freeze(Color.fromCssColorString("#C0C0C0")),Color.SKYBLUE=Object.freeze(Color.fromCssColorString("#87CEEB")),Color.SLATEBLUE=Object.freeze(Color.fromCssColorString("#6A5ACD")),Color.SLATEGRAY=Object.freeze(Color.fromCssColorString("#708090")),Color.SLATEGREY=Color.SLATEGRAY,Color.SNOW=Object.freeze(Color.fromCssColorString("#FFFAFA")),Color.SPRINGGREEN=Object.freeze(Color.fromCssColorString("#00FF7F")),Color.STEELBLUE=Object.freeze(Color.fromCssColorString("#4682B4")),Color.TAN=Object.freeze(Color.fromCssColorString("#D2B48C")),Color.TEAL=Object.freeze(Color.fromCssColorString("#008080")),Color.THISTLE=Object.freeze(Color.fromCssColorString("#D8BFD8")),Color.TOMATO=Object.freeze(Color.fromCssColorString("#FF6347")),Color.TURQUOISE=Object.freeze(Color.fromCssColorString("#40E0D0")),Color.VIOLET=Object.freeze(Color.fromCssColorString("#EE82EE")),Color.WHEAT=Object.freeze(Color.fromCssColorString("#F5DEB3")),Color.WHITE=Object.freeze(Color.fromCssColorString("#FFFFFF")),Color.WHITESMOKE=Object.freeze(Color.fromCssColorString("#F5F5F5")),Color.YELLOW=Object.freeze(Color.fromCssColorString("#FFFF00")),Color.YELLOWGREEN=Object.freeze(Color.fromCssColorString("#9ACD32")),Color.TRANSPARENT=Object.freeze(new Color(0,0,0,0)),Object.defineProperties(ColorGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 4}},normalize:{get:function(){return!0}}}),ColorGeometryInstanceAttribute.fromColor=function(e){return new ColorGeometryInstanceAttribute(e.red,e.green,e.blue,e.alpha)},ColorGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?e.toBytes(t):new Uint8Array(e.toBytes())},ColorGeometryInstanceAttribute.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.value[0]===t.value[0]&&e.value[1]===t.value[1]&&e.value[2]===t.value[2]&&e.value[3]===t.value[3]},Object.defineProperties(CompressedTextureBuffer.prototype,{internalFormat:{get:function(){return this._format}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},bufferView:{get:function(){return this._buffer}}}),CompressedTextureBuffer.clone=function(e){if(defined(e))return new CompressedTextureBuffer(e._format,e._width,e._height,e._buffer)},CompressedTextureBuffer.prototype.clone=function(){return CompressedTextureBuffer.clone(this)};var removeDuplicatesEpsilon=CesiumMath.EPSILON10;function arrayRemoveDuplicates(e,t,i){if(defined(e)){i=defaultValue(i,!1);var r,n,a,o=e.length;if(o<2)return e;for(r=1;r<o&&!t(n=e[r-1],a=e[r],removeDuplicatesEpsilon);++r);if(r===o)return i&&t(e[0],e[e.length-1],removeDuplicatesEpsilon)?e.slice(1):e;for(var s=e.slice(0,r);r<o;++r)t(n,a=e[r],removeDuplicatesEpsilon)||(s.push(a),n=a);return i&&1<s.length&&t(s[0],s[s.length-1],removeDuplicatesEpsilon)&&s.shift(),s}}var CoplanarPolygonGeometryLibrary={},scratchIntersectionPoint=new Cartesian3,scratchXAxis=new Cartesian3,scratchYAxis=new Cartesian3,scratchZAxis=new Cartesian3,obbScratch=new OrientedBoundingBox;function projectTo2D(e,t,i,r,n){t=Cartesian3.subtract(e,t,scratchIntersectionPoint),i=Cartesian3.dot(i,t),t=Cartesian3.dot(r,t);return Cartesian2.fromElements(i,t,n)}function calculateM(e,t,i){if(0===e)return t*i;var r=e*e,n=r*r,a=n*r,o=a*r,s=o*r,e=s*r,i=i;return t*((1-r/4-3*n/64-5*a/256-175*o/16384-441*s/65536-4851*e/1048576)*i-(3*r/8+3*n/32+45*a/1024+105*o/4096+2205*s/131072+6237*e/524288)*Math.sin(2*i)+(15*n/256+45*a/1024+525*o/16384+1575*s/65536+155925*e/8388608)*Math.sin(4*i)-(35*a/3072+175*o/12288+3675*s/262144+13475*e/1048576)*Math.sin(6*i)+(315*o/131072+2205*s/524288+43659*e/8388608)*Math.sin(8*i)-(693*s/1310720+6237*e/5242880)*Math.sin(10*i)+1001*e/8388608*Math.sin(12*i))}function calculateInverseM(e,t,i){var r=e/i;if(0===t)return r;var n=r*r,a=n*r,o=a*r,s=t*t,l=s*s,c=l*s,u=c*s,d=u*s,h=d*s,p=Math.sin(2*r),m=Math.cos(2*r),f=Math.sin(4*r),g=Math.cos(4*r),_=Math.sin(6*r),y=Math.cos(6*r),e=Math.sin(8*r),i=Math.cos(8*r),t=Math.sin(10*r);return r+r*s/4+7*r*l/64+15*r*c/256+579*r*u/16384+1515*r*d/65536+16837*r*h/1048576+(3*r*l/16+45*r*c/256-r*(32*n-561)*u/4096-r*(232*n-1677)*d/16384+r*(399985-90560*n+512*o)*h/5242880)*m+(21*r*c/256+483*r*u/4096-r*(224*n-1969)*d/16384-r*(33152*n-112599)*h/1048576)*g+(151*r*u/4096+4681*r*d/65536+1479*r*h/16384-453*a*h/32768)*y+(1097*r*d/65536+42783*r*h/1048576)*i+8011*r*h/1048576*Math.cos(10*r)+(3*s/8+3*l/16+213*c/2048-3*n*c/64+255*u/4096-33*n*u/512+20861*d/524288-33*n*d/512+o*d/1024+28273*h/1048576-471*n*h/8192+9*o*h/4096)*p+(21*l/256+21*c/256+533*u/8192-21*n*u/512+197*d/4096-315*n*d/4096+584039*h/16777216-12517*n*h/131072+7*o*h/2048)*f+(151*c/6144+151*u/4096+5019*d/131072-453*n*d/16384+26965*h/786432-8607*n*h/131072)*_+(1097*u/131072+1097*d/65536+225797*h/10485760-1097*n*h/65536)*e+(8011*d/2621440+8011*h/1048576)*t+293393*h/251658240*Math.sin(12*r)}function calculateSigma(e,t){if(0===e)return Math.log(Math.tan(.5*(CesiumMath.PI_OVER_TWO+t)));var i=e*Math.sin(t);return Math.log(Math.tan(.5*(CesiumMath.PI_OVER_TWO+t)))-e/2*Math.log((1+i)/(1-i))}function calculateHeading(e,t,i,r,n){i=calculateSigma(e._ellipticity,i),n=calculateSigma(e._ellipticity,n);return Math.atan2(CesiumMath.negativePiToPi(r-t),n-i)}function calculateArcLength(e,t,i,r,n,a,o){var s=e._heading,a=a-r,r=0;return r=CesiumMath.equalsEpsilon(Math.abs(s),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8)?t===i?t*Math.cos(n)*CesiumMath.negativePiToPi(a):(i=Math.sin(n),t*Math.cos(n)*CesiumMath.negativePiToPi(a)/Math.sqrt(1-e._ellipticitySquared*i*i)):(n=calculateM(e._ellipticity,t,n),(calculateM(e._ellipticity,t,o)-n)/Math.cos(s)),Math.abs(r)}CoplanarPolygonGeometryLibrary.validOutline=function(e){var t=OrientedBoundingBox.fromPoints(e,obbScratch).halfAxes,i=Matrix3.getColumn(t,0,scratchXAxis),e=Matrix3.getColumn(t,1,scratchYAxis),t=Matrix3.getColumn(t,2,scratchZAxis),i=Cartesian3.magnitude(i),e=Cartesian3.magnitude(e),t=Cartesian3.magnitude(t);return!(0===i&&(0===e||0===t)||0===e&&0===t)},CoplanarPolygonGeometryLibrary.computeProjectTo2DArguments=function(e,t,i,r){var n,a,o=OrientedBoundingBox.fromPoints(e,obbScratch),s=o.halfAxes,l=Matrix3.getColumn(s,0,scratchXAxis),c=Matrix3.getColumn(s,1,scratchYAxis),u=Matrix3.getColumn(s,2,scratchZAxis),d=Cartesian3.magnitude(l),h=Cartesian3.magnitude(c),e=Cartesian3.magnitude(u),s=Math.min(d,h,e);return(0!==d||0!==h&&0!==e)&&(0!==h||0!==e)&&(s!==h&&s!==e||(n=l),s===d?n=c:s===e&&(a=c),s!==d&&s!==h||(a=u),Cartesian3.normalize(n,i),Cartesian3.normalize(a,r),Cartesian3.clone(o.center,t),!0)},CoplanarPolygonGeometryLibrary.createProjectPointsTo2DFunction=function(r,n,a){return function(e){for(var t=new Array(e.length),i=0;i<e.length;i++)t[i]=projectTo2D(e[i],r,n,a);return t}},CoplanarPolygonGeometryLibrary.createProjectPointTo2DFunction=function(i,r,n){return function(e,t){return projectTo2D(e,i,r,n,t)}};var scratchCart1=new Cartesian3,scratchCart2=new Cartesian3;function computeProperties(e,t,i,r){Cartesian3.normalize(r.cartographicToCartesian(t,scratchCart2),scratchCart1),Cartesian3.normalize(r.cartographicToCartesian(i,scratchCart2),scratchCart2);var n=r.maximumRadius,a=r.minimumRadius,n=n*n,a=a*a;e._ellipticitySquared=(n-a)/n,e._ellipticity=Math.sqrt(e._ellipticitySquared),e._start=Cartographic.clone(t,e._start),e._start.height=0,e._end=Cartographic.clone(i,e._end),e._end.height=0,e._heading=calculateHeading(e,t.longitude,t.latitude,i.longitude,i.latitude),e._distance=calculateArcLength(e,r.maximumRadius,r.minimumRadius,t.longitude,t.latitude,i.longitude,i.latitude)}function interpolateUsingSurfaceDistance(e,t,i,r,n,a){var o,s,l,c=n*n;return l=Math.abs(CesiumMath.PI_OVER_TWO-Math.abs(t))>CesiumMath.EPSILON8?(o=calculateInverseM(calculateM(n,r,e.latitude)+i*Math.cos(t),n,r),l=calculateSigma(n,e.latitude),s=calculateSigma(n,o),l=Math.tan(t)*(s-l),CesiumMath.negativePiToPi(e.longitude+l)):(o=e.latitude,l=i/(0===n?r*Math.cos(e.latitude):(n=Math.sin(e.latitude),r*Math.cos(e.latitude)/Math.sqrt(1-c*n*n))),0<t?CesiumMath.negativePiToPi(e.longitude+l):CesiumMath.negativePiToPi(e.longitude-l)),defined(a)?(a.longitude=l,a.latitude=o,a.height=0,a):new Cartographic(l,o,0)}function EllipsoidRhumbLine(e,t,i){i=defaultValue(i,Ellipsoid.WGS84);this._ellipsoid=i,this._start=new Cartographic,this._end=new Cartographic,this._heading=void 0,this._distance=void 0,this._ellipticity=void 0,this._ellipticitySquared=void 0,defined(e)&&defined(t)&&computeProperties(this,e,t,i)}function earcut(e,t,i){i=i||2;var r,n,a,o,s,l,c,u=t&&t.length,d=u?t[0]*i:e.length,h=linkedList(e,0,d,i,!0),p=[];if(!h||h.next===h.prev)return p;if(u&&(h=eliminateHoles(e,t,h,i)),e.length>80*i){r=a=e[0],n=o=e[1];for(var m=i;m<d;m+=i)(s=e[m])<r&&(r=s),(l=e[m+1])<n&&(n=l),a<s&&(a=s),o<l&&(o=l);c=0!==(c=Math.max(a-r,o-n))?1/c:0}return earcutLinked(h,p,i,r,n,c),p}function linkedList(e,t,i,r,n){var a,o;if(n===0<signedArea(e,t,i,r))for(a=t;a<i;a+=r)o=insertNode(a,e[a],e[a+1],o);else for(a=i-r;t<=a;a-=r)o=insertNode(a,e[a],e[a+1],o);return o&&equals(o,o.next)&&(removeNode(o),o=o.next),o}function filterPoints(e,t){if(!e)return e;t=t||e;var i,r=e;do{if(i=!1,r.steiner||!equals(r,r.next)&&0!==area(r.prev,r,r.next))r=r.next;else{if(removeNode(r),(r=t=r.prev)===r.next)break;i=!0}}while(i||r!==t);return t}function earcutLinked(e,t,i,r,n,a,o){if(e){!o&&a&&indexCurve(e,r,n,a);for(var s,l,c=e;e.prev!==e.next;)if(s=e.prev,l=e.next,a?isEarHashed(e,r,n,a):isEar(e))t.push(s.i/i),t.push(e.i/i),t.push(l.i/i),removeNode(e),e=l.next,c=l.next;else if((e=l)===c){o?1===o?earcutLinked(e=cureLocalIntersections(filterPoints(e),t,i),t,i,r,n,a,2):2===o&&splitEarcut(e,t,i,r,n,a):earcutLinked(filterPoints(e),t,i,r,n,a,1);break}}}function isEar(e){var t=e.prev,i=e,r=e.next;if(!(0<=area(t,i,r))){for(var n=e.next.next;n!==e.prev;){if(pointInTriangle(t.x,t.y,i.x,i.y,r.x,r.y,n.x,n.y)&&0<=area(n.prev,n,n.next))return;n=n.next}return 1}}function isEarHashed(e,t,i,r){var n=e.prev,a=e,o=e.next;if(!(0<=area(n,a,o))){for(var s=(n.x<a.x?n.x<o.x?n:o:a.x<o.x?a:o).x,l=(n.y<a.y?n.y<o.y?n:o:a.y<o.y?a:o).y,c=(n.x>a.x?n.x>o.x?n:o:a.x>o.x?a:o).x,u=(n.y>a.y?n.y>o.y?n:o:a.y>o.y?a:o).y,d=zOrder(s,l,t,i,r),h=zOrder(c,u,t,i,r),p=e.prevZ,m=e.nextZ;p&&p.z>=d&&m&&m.z<=h;){if(p!==e.prev&&p!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,p.x,p.y)&&0<=area(p.prev,p,p.next))return;if(p=p.prevZ,m!==e.prev&&m!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,m.x,m.y)&&0<=area(m.prev,m,m.next))return;m=m.nextZ}for(;p&&p.z>=d;){if(p!==e.prev&&p!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,p.x,p.y)&&0<=area(p.prev,p,p.next))return;p=p.prevZ}for(;m&&m.z<=h;){if(m!==e.prev&&m!==e.next&&pointInTriangle(n.x,n.y,a.x,a.y,o.x,o.y,m.x,m.y)&&0<=area(m.prev,m,m.next))return;m=m.nextZ}return 1}}function cureLocalIntersections(e,t,i){var r=e;do{var n=r.prev,a=r.next.next}while(!equals(n,a)&&intersects(n,r,r.next,a)&&locallyInside(n,a)&&locallyInside(a,n)&&(t.push(n.i/i),t.push(r.i/i),t.push(a.i/i),removeNode(r),removeNode(r.next),r=e=a),(r=r.next)!==e);return filterPoints(r)}function splitEarcut(e,t,i,r,n,a){var o=e;do{for(var s=o.next.next;s!==o.prev;){if(o.i!==s.i&&isValidDiagonal(o,s)){var l=splitPolygon(o,s),o=filterPoints(o,o.next),l=filterPoints(l,l.next);return earcutLinked(o,t,i,r,n,a),void earcutLinked(l,t,i,r,n,a)}s=s.next}}while((o=o.next)!==e)}function eliminateHoles(e,t,i,r){for(var n,a=[],o=0,s=t.length;o<s;o++)(n=linkedList(e,t[o]*r,o<s-1?t[o+1]*r:e.length,r,!1))===n.next&&(n.steiner=!0),a.push(getLeftmost(n));for(a.sort(compareX),o=0;o<a.length;o++)eliminateHole(a[o],i),i=filterPoints(i,i.next);return i}function compareX(e,t){return e.x-t.x}function eliminateHole(e,t){(t=findHoleBridge(e,t))&&filterPoints(e=splitPolygon(t,e),e.next)}function findHoleBridge(e,t){var i,r=t,n=e.x,a=e.y,o=-1/0;do{if(a<=r.y&&a>=r.next.y&&r.next.y!==r.y){var s=r.x+(a-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(s<=n&&o<s){if((o=s)===n){if(a===r.y)return r;if(a===r.next.y)return r.next}i=r.x<r.next.x?r:r.next}}}while((r=r.next)!==t);if(!i)return null;if(n===o)return i;for(var l,c=i,u=i.x,d=i.y,h=1/0,r=i;n>=r.x&&r.x>=u&&n!==r.x&&pointInTriangle(a<d?n:o,a,u,d,a<d?o:n,a,r.x,r.y)&&(l=Math.abs(a-r.y)/(n-r.x),locallyInside(r,e)&&(l<h||l===h&&(r.x>i.x||r.x===i.x&&sectorContainsSector(i,r)))&&(i=r,h=l)),r=r.next,r!==c;);return i}function sectorContainsSector(e,t){return area(e.prev,e,t.prev)<0&&area(t.next,e,e.next)<0}function indexCurve(e,t,i,r){for(var n=e;null===n.z&&(n.z=zOrder(n.x,n.y,t,i,r)),n.prevZ=n.prev,n.nextZ=n.next,n=n.next,n!==e;);n.prevZ.nextZ=null,n.prevZ=null,sortLinked(n)}function sortLinked(e){var t,i,r,n,a,o,s,l,c=1;do{for(i=e,a=e=null,o=0;i;){for(o++,r=i,t=s=0;t<c&&(s++,r=r.nextZ);t++);for(l=c;0<s||0<l&&r;)0!==s&&(0===l||!r||i.z<=r.z)?(i=(n=i).nextZ,s--):(r=(n=r).nextZ,l--),a?a.nextZ=n:e=n,n.prevZ=a,a=n;i=r}}while(a.nextZ=null,c*=2,1<o);return e}function zOrder(e,t,i,r,n){return(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-i)*n)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-r)*n)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function getLeftmost(e){for(var t=e,i=e;(t.x<i.x||t.x===i.x&&t.y<i.y)&&(i=t),t=t.next,t!==e;);return i}function pointInTriangle(e,t,i,r,n,a,o,s){return 0<=(n-o)*(t-s)-(e-o)*(a-s)&&0<=(e-o)*(r-s)-(i-o)*(t-s)&&0<=(i-o)*(a-s)-(n-o)*(r-s)}function isValidDiagonal(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!intersectsPolygon(e,t)&&(locallyInside(e,t)&&locallyInside(t,e)&&middleInside(e,t)&&(area(e.prev,e,t.prev)||area(e,t.prev,t))||equals(e,t)&&0<area(e.prev,e,e.next)&&0<area(t.prev,t,t.next))}function area(e,t,i){return(t.y-e.y)*(i.x-t.x)-(t.x-e.x)*(i.y-t.y)}function equals(e,t){return e.x===t.x&&e.y===t.y}function intersects(e,t,i,r){var n=sign(area(e,t,i)),a=sign(area(e,t,r)),o=sign(area(i,r,e)),s=sign(area(i,r,t));return n!==a&&o!==s||(0===n&&onSegment(e,i,t)||(0===a&&onSegment(e,r,t)||(0===o&&onSegment(i,e,r)||!(0!==s||!onSegment(i,t,r)))))}function onSegment(e,t,i){return t.x<=Math.max(e.x,i.x)&&t.x>=Math.min(e.x,i.x)&&t.y<=Math.max(e.y,i.y)&&t.y>=Math.min(e.y,i.y)}function sign(e){return 0<e?1:e<0?-1:0}function intersectsPolygon(e,t){var i=e;do{if(i.i!==e.i&&i.next.i!==e.i&&i.i!==t.i&&i.next.i!==t.i&&intersects(i,i.next,e,t))return 1}while((i=i.next)!==e)}function locallyInside(e,t){return area(e.prev,e,e.next)<0?0<=area(e,t,e.next)&&0<=area(e,e.prev,t):area(e,t,e.prev)<0||area(e,e.next,t)<0}function middleInside(e,t){for(var i=e,r=!1,n=(e.x+t.x)/2,a=(e.y+t.y)/2;i.y>a!=i.next.y>a&&i.next.y!==i.y&&n<(i.next.x-i.x)*(a-i.y)/(i.next.y-i.y)+i.x&&(r=!r),i=i.next,i!==e;);return r}function splitPolygon(e,t){var i=new Node$1(e.i,e.x,e.y),r=new Node$1(t.i,t.x,t.y),n=e.next,a=t.prev;return(e.next=t).prev=e,(i.next=n).prev=i,(r.next=i).prev=r,(a.next=r).prev=a,r}function insertNode(e,t,i,r){i=new Node$1(e,t,i);return r?(i.next=r.next,(i.prev=r).next.prev=i,r.next=i):(i.prev=i).next=i,i}function removeNode(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function Node$1(e,t,i){this.i=e,this.x=t,this.y=i,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}function signedArea(e,t,i,r){for(var n=0,a=t,o=i-r;a<i;a+=r)n+=(e[o]-e[a])*(e[a+1]+e[o+1]),o=a;return n}Object.defineProperties(EllipsoidRhumbLine.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},heading:{get:function(){return this._heading}}}),EllipsoidRhumbLine.fromStartHeadingDistance=function(e,t,i,r,n){var a=defaultValue(r,Ellipsoid.WGS84),o=a.maximumRadius,s=a.minimumRadius,o=o*o,s=s*s,o=Math.sqrt((o-s)/o),o=interpolateUsingSurfaceDistance(e,t=CesiumMath.negativePiToPi(t),i,a.maximumRadius,o);return!defined(n)||defined(r)&&!r.equals(n.ellipsoid)?new EllipsoidRhumbLine(e,o,a):(n.setEndPoints(e,o),n)},EllipsoidRhumbLine.prototype.setEndPoints=function(e,t){computeProperties(this,e,t,this._ellipsoid)},EllipsoidRhumbLine.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(e*this._distance,t)},EllipsoidRhumbLine.prototype.interpolateUsingSurfaceDistance=function(e,t){return interpolateUsingSurfaceDistance(this._start,this._heading,e,this._ellipsoid.maximumRadius,this._ellipticity,t)},EllipsoidRhumbLine.prototype.findIntersectionWithLongitude=function(e,t){var i=this._ellipticity,r=this._heading,n=Math.abs(r),a=this._start;if(e=CesiumMath.negativePiToPi(e),CesiumMath.equalsEpsilon(Math.abs(e),Math.PI,CesiumMath.EPSILON14)&&(e=CesiumMath.sign(a.longitude)*Math.PI),defined(t)||(t=new Cartographic),Math.abs(CesiumMath.PI_OVER_TWO-n)<=CesiumMath.EPSILON8)return t.longitude=e,t.latitude=a.latitude,t.height=0,t;if(CesiumMath.equalsEpsilon(Math.abs(CesiumMath.PI_OVER_TWO-n),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8))return CesiumMath.equalsEpsilon(e,a.longitude,CesiumMath.EPSILON12)?void 0:(t.longitude=e,t.latitude=CesiumMath.PI_OVER_TWO*CesiumMath.sign(CesiumMath.PI_OVER_TWO-r),t.height=0,t);var o,s=a.latitude,n=i*Math.sin(s),l=Math.tan(.5*(CesiumMath.PI_OVER_TWO+s))*Math.exp((e-a.longitude)/Math.tan(r)),c=(1+n)/(1-n),u=a.latitude;do{o=u;var d=i*Math.sin(o),d=(1+d)/(1-d),u=2*Math.atan(l*Math.pow(d/c,i/2))-CesiumMath.PI_OVER_TWO}while(!CesiumMath.equalsEpsilon(u,o,CesiumMath.EPSILON12));return t.longitude=e,t.latitude=u,t.height=0,t},EllipsoidRhumbLine.prototype.findIntersectionWithLatitude=function(e,t){var i=this._ellipticity,r=this._heading,n=this._start;if(!CesiumMath.equalsEpsilon(Math.abs(r),CesiumMath.PI_OVER_TWO,CesiumMath.EPSILON8)){var a=calculateSigma(i,n.latitude),i=calculateSigma(i,e),a=Math.tan(r)*(i-a),a=CesiumMath.negativePiToPi(n.longitude+a);return defined(t)?(t.longitude=a,t.latitude=e,t.height=0,t):new Cartographic(a,e,0)}},earcut.deviation=function(e,t,i,r){var n=t&&t.length,a=n?t[0]*i:e.length,o=Math.abs(signedArea(e,0,a,i));if(n)for(var s=0,l=t.length;s<l;s++){var c=t[s]*i,u=s<l-1?t[s+1]*i:e.length;o-=Math.abs(signedArea(e,c,u,i))}for(var d=0,s=0;s<r.length;s+=3){var h=r[s]*i,p=r[s+1]*i,m=r[s+2]*i;d+=Math.abs((e[h]-e[m])*(e[1+p]-e[1+h])-(e[h]-e[p])*(e[1+m]-e[1+h]))}return 0===o&&0===d?0:Math.abs((d-o)/o)},earcut.flatten=function(e){for(var t=e[0][0].length,i={vertices:[],holes:[],dimensions:t},r=0,n=0;n<e.length;n++){for(var a=0;a<e[n].length;a++)for(var o=0;o<t;o++)i.vertices.push(e[n][a][o]);0<n&&(r+=e[n-1].length,i.holes.push(r))}return i};var WindingOrder={CLOCKWISE:WebGLConstants$1.CW,COUNTER_CLOCKWISE:WebGLConstants$1.CCW,validate:function(e){return e===WindingOrder.CLOCKWISE||e===WindingOrder.COUNTER_CLOCKWISE}},WindingOrder$1=Object.freeze(WindingOrder),scaleToGeodeticHeightN=new Cartesian3,scaleToGeodeticHeightP=new Cartesian3,PolygonPipeline={computeArea2D:function(e){for(var t=e.length,i=0,r=t-1,n=0;n<t;r=n++){var a=e[r],o=e[n];i+=a.x*o.y-o.x*a.y}return.5*i},computeWindingOrder2D:function(e){return 0<PolygonPipeline.computeArea2D(e)?WindingOrder$1.COUNTER_CLOCKWISE:WindingOrder$1.CLOCKWISE},triangulate:function(e,t){return earcut(Cartesian2.packArray(e),t,2)}},subdivisionV0Scratch=new Cartesian3,subdivisionV1Scratch=new Cartesian3,subdivisionV2Scratch=new Cartesian3,subdivisionS0Scratch=new Cartesian3,subdivisionS1Scratch=new Cartesian3,subdivisionS2Scratch=new Cartesian3,subdivisionMidScratch=new Cartesian3;PolygonPipeline.computeSubdivision=function(e,t,i,r){r=defaultValue(r,CesiumMath.RADIANS_PER_DEGREE);for(var n=i.slice(0),a=t.length,o=new Array(3*a),s=0,l=0;l<a;l++){var c=t[l];o[s++]=c.x,o[s++]=c.y,o[s++]=c.z}for(var u=[],d={},h=e.maximumRadius,r=CesiumMath.chordLength(r,h),p=r*r;0<n.length;){var m,f,g=n.pop(),_=n.pop(),y=n.pop(),C=Cartesian3.fromArray(o,3*y,subdivisionV0Scratch),v=Cartesian3.fromArray(o,3*_,subdivisionV1Scratch),S=Cartesian3.fromArray(o,3*g,subdivisionV2Scratch),T=Cartesian3.multiplyByScalar(Cartesian3.normalize(C,subdivisionS0Scratch),h,subdivisionS0Scratch),x=Cartesian3.multiplyByScalar(Cartesian3.normalize(v,subdivisionS1Scratch),h,subdivisionS1Scratch),b=Cartesian3.multiplyByScalar(Cartesian3.normalize(S,subdivisionS2Scratch),h,subdivisionS2Scratch),E=Cartesian3.magnitudeSquared(Cartesian3.subtract(T,x,subdivisionMidScratch)),x=Cartesian3.magnitudeSquared(Cartesian3.subtract(x,b,subdivisionMidScratch)),b=Cartesian3.magnitudeSquared(Cartesian3.subtract(b,T,subdivisionMidScratch)),T=Math.max(E,x,b);p<T?E===T?(defined(l=d[m=Math.min(y,_)+" "+Math.max(y,_)])||(f=Cartesian3.add(C,v,subdivisionMidScratch),Cartesian3.multiplyByScalar(f,.5,f),o.push(f.x,f.y,f.z),l=o.length/3-1,d[m]=l),n.push(y,l,g),n.push(l,_,g)):x===T?(defined(l=d[m=Math.min(_,g)+" "+Math.max(_,g)])||(f=Cartesian3.add(v,S,subdivisionMidScratch),Cartesian3.multiplyByScalar(f,.5,f),o.push(f.x,f.y,f.z),l=o.length/3-1,d[m]=l),n.push(_,l,y),n.push(l,g,y)):b===T&&(defined(l=d[m=Math.min(g,y)+" "+Math.max(g,y)])||(f=Cartesian3.add(S,C,subdivisionMidScratch),Cartesian3.multiplyByScalar(f,.5,f),o.push(f.x,f.y,f.z),l=o.length/3-1,d[m]=l),n.push(g,l,_),n.push(l,y,_)):(u.push(y),u.push(_),u.push(g))}return new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:o})},indices:u,primitiveType:PrimitiveType$1.TRIANGLES})};var subdivisionC0Scratch=new Cartographic,subdivisionC1Scratch=new Cartographic,subdivisionC2Scratch=new Cartographic,subdivisionCartographicScratch=new Cartographic;function Queue(){this._array=[],this._offset=0,this._length=0}PolygonPipeline.computeRhumbLineSubdivision=function(e,t,i,r){r=defaultValue(r,CesiumMath.RADIANS_PER_DEGREE);for(var n=i.slice(0),a=t.length,o=new Array(3*a),s=0,l=0;l<a;l++){var c=t[l];o[s++]=c.x,o[s++]=c.y,o[s++]=c.z}for(var u=[],d={},i=e.maximumRadius,h=CesiumMath.chordLength(r,i),p=new EllipsoidRhumbLine(void 0,void 0,e),m=new EllipsoidRhumbLine(void 0,void 0,e),f=new EllipsoidRhumbLine(void 0,void 0,e);0<n.length;){var g=n.pop(),_=n.pop(),y=n.pop(),C=Cartesian3.fromArray(o,3*y,subdivisionV0Scratch),v=Cartesian3.fromArray(o,3*_,subdivisionV1Scratch),S=Cartesian3.fromArray(o,3*g,subdivisionV2Scratch),T=e.cartesianToCartographic(C,subdivisionC0Scratch),x=e.cartesianToCartographic(v,subdivisionC1Scratch),b=e.cartesianToCartographic(S,subdivisionC2Scratch);p.setEndPoints(T,x);var E=p.surfaceDistance;m.setEndPoints(x,b);C=m.surfaceDistance;f.setEndPoints(b,T);var P,A,w,D,v=f.surfaceDistance,S=Math.max(E,C,v);h<S?E===S?(defined(l=d[P=Math.min(y,_)+" "+Math.max(y,_)])||(A=p.interpolateUsingFraction(.5,subdivisionCartographicScratch),w=.5*(T.height+x.height),D=Cartesian3.fromRadians(A.longitude,A.latitude,w,e,subdivisionMidScratch),o.push(D.x,D.y,D.z),l=o.length/3-1,d[P]=l),n.push(y,l,g),n.push(l,_,g)):C===S?(defined(l=d[P=Math.min(_,g)+" "+Math.max(_,g)])||(A=m.interpolateUsingFraction(.5,subdivisionCartographicScratch),w=.5*(x.height+b.height),D=Cartesian3.fromRadians(A.longitude,A.latitude,w,e,subdivisionMidScratch),o.push(D.x,D.y,D.z),l=o.length/3-1,d[P]=l),n.push(_,l,y),n.push(l,g,y)):v===S&&(defined(l=d[P=Math.min(g,y)+" "+Math.max(g,y)])||(A=f.interpolateUsingFraction(.5,subdivisionCartographicScratch),w=.5*(b.height+T.height),D=Cartesian3.fromRadians(A.longitude,A.latitude,w,e,subdivisionMidScratch),o.push(D.x,D.y,D.z),l=o.length/3-1,d[P]=l),n.push(g,l,_),n.push(l,y,_)):(u.push(y),u.push(_),u.push(g))}return new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:o})},indices:u,primitiveType:PrimitiveType$1.TRIANGLES})},PolygonPipeline.scaleToGeodeticHeight=function(e,t,i,r){i=defaultValue(i,Ellipsoid.WGS84);var n=scaleToGeodeticHeightN,a=scaleToGeodeticHeightP;if(t=defaultValue(t,0),r=defaultValue(r,!0),defined(e))for(var o=e.length,s=0;s<o;s+=3)Cartesian3.fromArray(e,s,a),r&&(a=i.scaleToGeodeticSurface(a,a)),0!==t&&(n=i.geodeticSurfaceNormal(a,n),Cartesian3.multiplyByScalar(n,t,n),Cartesian3.add(a,n,a)),e[s]=a.x,e[s+1]=a.y,e[s+2]=a.z;return e},Object.defineProperties(Queue.prototype,{length:{get:function(){return this._length}}}),Queue.prototype.enqueue=function(e){this._array.push(e),this._length++},Queue.prototype.dequeue=function(){if(0!==this._length){var e=this._array,t=this._offset,i=e[t];return e[t]=void 0,10<++t&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this._length--,i}},Queue.prototype.peek=function(){if(0!==this._length)return this._array[this._offset]},Queue.prototype.contains=function(e){return-1!==this._array.indexOf(e)},Queue.prototype.clear=function(){this._array.length=this._offset=this._length=0},Queue.prototype.sort=function(e){0<this._offset&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)};var PolygonGeometryLibrary={computeHierarchyPackedLength:function(e){for(var t=0,i=[e];0<i.length;){var r=i.pop();if(defined(r)){t+=2;var n=r.positions,a=r.holes;if(defined(n)&&(t+=n.length*Cartesian3.packedLength),defined(a))for(var o=a.length,s=0;s<o;++s)i.push(a[s])}}return t},packPolygonHierarchy:function(e,t,i){for(var r=[e];0<r.length;){var n=r.pop();if(defined(n)){var a=n.positions,o=n.holes;if(t[i++]=defined(a)?a.length:0,t[i++]=defined(o)?o.length:0,defined(a))for(var s=a.length,l=0;l<s;++l,i+=3)Cartesian3.pack(a[l],t,i);if(defined(o))for(var c=o.length,u=0;u<c;++u)r.push(o[u])}}return i},unpackPolygonHierarchy:function(e,t){for(var i=e[t++],r=e[t++],n=new Array(i),a=0<r?new Array(r):void 0,o=0;o<i;++o,t+=Cartesian3.packedLength)n[o]=Cartesian3.unpack(e,t);for(var s=0;s<r;++s)a[s]=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t),t=a[s].startingIndex,delete a[s].startingIndex;return{positions:n,holes:a,startingIndex:t}}},distanceScratch$3=new Cartesian3;function getPointAtDistance(e,t,i,r){return Cartesian3.subtract(t,e,distanceScratch$3),Cartesian3.multiplyByScalar(distanceScratch$3,i/r,distanceScratch$3),Cartesian3.add(e,distanceScratch$3,distanceScratch$3),[distanceScratch$3.x,distanceScratch$3.y,distanceScratch$3.z]}PolygonGeometryLibrary.subdivideLineCount=function(e,t,i){i=Cartesian3.distance(e,t)/i,i=Math.max(0,Math.ceil(CesiumMath.log2(i)));return Math.pow(2,i)};var scratchCartographic0=new Cartographic,scratchCartographic1=new Cartographic,scratchCartographic2=new Cartographic,scratchCartesian0=new Cartesian3;PolygonGeometryLibrary.subdivideRhumbLineCount=function(e,t,i,r){r=new EllipsoidRhumbLine(e.cartesianToCartographic(t,scratchCartographic0),e.cartesianToCartographic(i,scratchCartographic1),e).surfaceDistance/r,r=Math.max(0,Math.ceil(CesiumMath.log2(r)));return Math.pow(2,r)},PolygonGeometryLibrary.subdivideLine=function(e,t,i,r){var n=PolygonGeometryLibrary.subdivideLineCount(e,t,i),a=Cartesian3.distance(e,t),o=a/n;defined(r)||(r=[]);var s=r;s.length=3*n;for(var l=0,c=0;c<n;c++){var u=getPointAtDistance(e,t,c*o,a);s[l++]=u[0],s[l++]=u[1],s[l++]=u[2]}return s},PolygonGeometryLibrary.subdivideRhumbLine=function(e,t,i,r,n){var a=new EllipsoidRhumbLine(e.cartesianToCartographic(t,scratchCartographic0),e.cartesianToCartographic(i,scratchCartographic1),e),r=a.surfaceDistance/r,r=Math.max(0,Math.ceil(CesiumMath.log2(r))),o=Math.pow(2,r),s=a.surfaceDistance/o;defined(n)||(n=[]);var l=n;l.length=3*o;for(var c=0,u=0;u<o;u++){var d=a.interpolateUsingSurfaceDistance(u*s,scratchCartographic2),d=e.cartographicToCartesian(d,scratchCartesian0);l[c++]=d.x,l[c++]=d.y,l[c++]=d.z}return l};var scaleToGeodeticHeightN1=new Cartesian3,scaleToGeodeticHeightN2=new Cartesian3,scaleToGeodeticHeightP1=new Cartesian3,scaleToGeodeticHeightP2=new Cartesian3;PolygonGeometryLibrary.scaleToGeodeticHeightExtruded=function(e,t,i,r,n){r=defaultValue(r,Ellipsoid.WGS84);var a=scaleToGeodeticHeightN1,o=scaleToGeodeticHeightN2,s=scaleToGeodeticHeightP1,l=scaleToGeodeticHeightP2;if(defined(e)&&defined(e.attributes)&&defined(e.attributes.position))for(var c=e.attributes.position.values,u=c.length/2,d=0;d<u;d+=3)Cartesian3.fromArray(c,d,s),r.geodeticSurfaceNormal(s,a),l=r.scaleToGeodeticSurface(s,l),o=Cartesian3.multiplyByScalar(a,i,o),o=Cartesian3.add(l,o,o),c[d+u]=o.x,c[d+1+u]=o.y,c[d+2+u]=o.z,n&&(l=Cartesian3.clone(s,l)),o=Cartesian3.multiplyByScalar(a,t,o),o=Cartesian3.add(l,o,o),c[d]=o.x,c[d+1]=o.y,c[d+2]=o.z;return e},PolygonGeometryLibrary.polygonOutlinesFromHierarchy=function(e,t,i){var r,n,a=[],o=new Queue;for(o.enqueue(e);0!==o.length;){var s=o.dequeue(),l=s.positions;if(t)for(n=l.length,u=0;u<n;u++)i.scaleToGeodeticSurface(l[u],l[u]);if(!((l=arrayRemoveDuplicates(l,Cartesian3.equalsEpsilon,!0)).length<3)){for(var c=s.holes?s.holes.length:0,u=0;u<c;u++){var d=s.holes[u],h=d.positions;if(t)for(n=h.length,r=0;r<n;++r)i.scaleToGeodeticSurface(h[r],h[r]);if(!((h=arrayRemoveDuplicates(h,Cartesian3.equalsEpsilon,!0)).length<3)){a.push(h);var p=0;for(defined(d.holes)&&(p=d.holes.length),r=0;r<p;r++)o.enqueue(d.holes[r])}}a.push(l)}}return a},PolygonGeometryLibrary.polygonsFromHierarchy=function(e,t,i,r){var n=[],a=[],o=new Queue;for(o.enqueue(e);0!==o.length;){var s,l=o.dequeue(),c=l.positions,u=l.holes;if(i)for(s=c.length,y=0;y<s;y++)r.scaleToGeodeticSurface(c[y],c[y]);if(!((c=arrayRemoveDuplicates(c,Cartesian3.equalsEpsilon,!0)).length<3)){var d=t(c);if(defined(d)){var h=[],p=PolygonPipeline.computeWindingOrder2D(d);p===WindingOrder$1.CLOCKWISE&&(d.reverse(),c=c.slice().reverse());for(var m,f=c.slice(),g=defined(u)?u.length:0,_=[],y=0;y<g;y++){var C=u[y],v=C.positions;if(i)for(s=v.length,m=0;m<s;++m)r.scaleToGeodeticSurface(v[m],v[m]);if(!((v=arrayRemoveDuplicates(v,Cartesian3.equalsEpsilon,!0)).length<3)){var S=t(v);if(defined(S)){PolygonPipeline.computeWindingOrder2D(S)===WindingOrder$1.CLOCKWISE&&(S.reverse(),v=v.slice().reverse()),_.push(v),h.push(f.length),f=f.concat(v),d=d.concat(S);var T=0;for(defined(C.holes)&&(T=C.holes.length),m=0;m<T;m++)o.enqueue(C.holes[m])}}}n.push({outerRing:c,holes:_}),a.push({positions:f,positions2D:d,holes:h})}}}return{hierarchy:n,polygons:a}};var computeBoundingRectangleCartesian2=new Cartesian2,computeBoundingRectangleCartesian3=new Cartesian3,computeBoundingRectangleQuaternion=new Quaternion,computeBoundingRectangleMatrix3=new Matrix3;PolygonGeometryLibrary.computeBoundingRectangle=function(e,t,i,r,n){for(var r=Quaternion.fromAxisAngle(e,r,computeBoundingRectangleQuaternion),a=Matrix3.fromQuaternion(r,computeBoundingRectangleMatrix3),o=Number.POSITIVE_INFINITY,s=Number.NEGATIVE_INFINITY,l=Number.POSITIVE_INFINITY,c=Number.NEGATIVE_INFINITY,u=i.length,d=0;d<u;++d){var h=Cartesian3.clone(i[d],computeBoundingRectangleCartesian3);Matrix3.multiplyByVector(a,h,h);h=t(h,computeBoundingRectangleCartesian2);defined(h)&&(o=Math.min(o,h.x),s=Math.max(s,h.x),l=Math.min(l,h.y),c=Math.max(c,h.y))}return n.x=o,n.y=l,n.width=s-o,n.height=c-l,n},PolygonGeometryLibrary.createGeometryFromPositions=function(e,t,i,r,n,a){var o=PolygonPipeline.triangulate(t.positions2D,t.holes);o.length<3&&(o=[0,1,2]);var s=t.positions;if(r){for(var l=s.length,c=new Array(3*l),u=0,d=0;d<l;d++){var h=s[d];c[u++]=h.x,c[u++]=h.y,c[u++]=h.z}r=new Geometry({attributes:{position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:c})},indices:o,primitiveType:PrimitiveType$1.TRIANGLES});return n.normal?GeometryPipeline.computeNormal(r):r}return a===ArcType$1.GEODESIC?PolygonPipeline.computeSubdivision(e,s,o,i):a===ArcType$1.RHUMB?PolygonPipeline.computeRhumbLineSubdivision(e,s,o,i):void 0};var computeWallIndicesSubdivided=[],p1Scratch$1=new Cartesian3,p2Scratch$1=new Cartesian3;PolygonGeometryLibrary.computeWallGeometry=function(e,t,i,r,n){var a,o,s,l=e.length,c=0;if(r)for(o=3*l*2,a=new Array(2*o),s=0;s<l;s++)p=e[s],m=e[(s+1)%l],a[c]=a[c+o]=p.x,a[++c]=a[c+o]=p.y,a[++c]=a[c+o]=p.z,a[++c]=a[c+o]=m.x,a[++c]=a[c+o]=m.y,a[++c]=a[c+o]=m.z,++c;else{var u=CesiumMath.chordLength(i,t.maximumRadius),d=0;if(n===ArcType$1.GEODESIC)for(s=0;s<l;s++)d+=PolygonGeometryLibrary.subdivideLineCount(e[s],e[(s+1)%l],u);else if(n===ArcType$1.RHUMB)for(s=0;s<l;s++)d+=PolygonGeometryLibrary.subdivideRhumbLineCount(t,e[s],e[(s+1)%l],u);for(o=3*(d+l),a=new Array(2*o),s=0;s<l;s++){var h,p=e[s],m=e[(s+1)%l];n===ArcType$1.GEODESIC?h=PolygonGeometryLibrary.subdivideLine(p,m,u,computeWallIndicesSubdivided):n===ArcType$1.RHUMB&&(h=PolygonGeometryLibrary.subdivideRhumbLine(t,p,m,u,computeWallIndicesSubdivided));for(var f=h.length,g=0;g<f;++g,++c)a[c]=h[g],a[c+o]=h[g];a[c]=m.x,a[c+o]=m.x,a[++c]=m.y,a[c+o]=m.y,a[++c]=m.z,a[c+o]=m.z,++c}}l=a.length;var _=IndexDatatype$1.createTypedArray(l/3,l-6*e.length),y=0;for(l/=6,s=0;s<l;s++){var C=s,v=C+1,S=C+l,T=S+1;p=Cartesian3.fromArray(a,3*C,p1Scratch$1),m=Cartesian3.fromArray(a,3*v,p2Scratch$1),Cartesian3.equalsEpsilon(p,m,CesiumMath.EPSILON10,CesiumMath.EPSILON10)||(_[y++]=C,_[y++]=S,_[y++]=v,_[y++]=v,_[y++]=S,_[y++]=T)}return new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:_,primitiveType:PrimitiveType$1.TRIANGLES})};var scratchPosition=new Cartesian3,scratchBR=new BoundingRectangle,stScratch=new Cartesian2,textureCoordinatesOrigin=new Cartesian2,scratchNormal$3=new Cartesian3,scratchTangent$1=new Cartesian3,scratchBitangent$1=new Cartesian3,centerScratch=new Cartesian3,axis1Scratch=new Cartesian3,axis2Scratch=new Cartesian3,quaternionScratch$1=new Quaternion,textureMatrixScratch$1=new Matrix3,tangentRotationScratch=new Matrix3,surfaceNormalScratch=new Cartesian3;function createGeometryFromPolygon(e,t,i,r,n,a,o,s){var l=e.positions,c=PolygonPipeline.triangulate(e.positions2D,e.holes);c.length<3&&(c=[0,1,2]);e=IndexDatatype$1.createTypedArray(l.length,c.length);e.set(c);var u=textureMatrixScratch$1;0!==r?(c=Quaternion.fromAxisAngle(a,r,quaternionScratch$1),u=Matrix3.fromQuaternion(c,u),(t.tangent||t.bitangent)&&(c=Quaternion.fromAxisAngle(a,-r,quaternionScratch$1),p=Matrix3.fromQuaternion(c,tangentRotationScratch),o=Cartesian3.normalize(Matrix3.multiplyByVector(p,o,o),o),t.bitangent&&(s=Cartesian3.normalize(Cartesian3.cross(a,o,s),s)))):u=Matrix3.clone(Matrix3.IDENTITY,u);var d=textureCoordinatesOrigin;t.st&&(d.x=i.x,d.y=i.y);for(var h=l.length,p=3*h,m=new Float64Array(p),f=t.normal?new Float32Array(p):void 0,g=t.tangent?new Float32Array(p):void 0,_=t.bitangent?new Float32Array(p):void 0,y=t.st?new Float32Array(2*h):void 0,C=0,v=0,S=0,T=0,x=0,b=0;b<h;b++){var E,P=l[b];m[C++]=P.x,m[C++]=P.y,m[C++]=P.z,t.st&&(E=n(Matrix3.multiplyByVector(u,P,scratchPosition),stScratch),Cartesian2.subtract(E,d,E),P=CesiumMath.clamp(E.x/i.width,0,1),E=CesiumMath.clamp(E.y/i.height,0,1),y[x++]=P,y[x++]=E),t.normal&&(f[v++]=a.x,f[v++]=a.y,f[v++]=a.z),t.tangent&&(g[T++]=o.x,g[T++]=o.y,g[T++]=o.z),t.bitangent&&(_[S++]=s.x,_[S++]=s.y,_[S++]=s.z)}p=new GeometryAttributes;return t.position&&(p.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:m})),t.normal&&(p.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),t.tangent&&(p.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:g})),t.bitangent&&(p.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:_})),t.st&&(p.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:y})),new Geometry({attributes:p,indices:e,primitiveType:PrimitiveType$1.TRIANGLES})}function CoplanarPolygonGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polygonHierarchy,i=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._vertexFormat=VertexFormat.clone(i),this._polygonHierarchy=t,this._stRotation=defaultValue(e.stRotation,0),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._workerName="createCoplanarPolygonGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(t)+VertexFormat.packedLength+Ellipsoid.packedLength+2}CoplanarPolygonGeometry.fromPositions=function(e){return new CoplanarPolygonGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid})},CoplanarPolygonGeometry.pack=function(e,t,i){return i=defaultValue(i,0),i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i),Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._stRotation,t[i]=e.packedLength,t};var scratchEllipsoid$2=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$2=new VertexFormat,scratchOptions$6={polygonHierarchy:{}};function createGeometryFromPositions(e){for(var t=e.length,i=new Float64Array(3*t),r=IndexDatatype$1.createTypedArray(t,2*t),n=0,a=0,o=0;o<t;o++){var s=e[o];i[n++]=s.x,i[n++]=s.y,i[n++]=s.z,r[a++]=o,r[a++]=(o+1)%t}return new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:i})}),indices:r,primitiveType:PrimitiveType$1.LINES})}function CoplanarPolygonOutlineGeometry(e){e=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polygonHierarchy;this._polygonHierarchy=e,this._workerName="createCoplanarPolygonOutlineGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(e)+1}CoplanarPolygonGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$2);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$2);t+=VertexFormat.packedLength;var o=e[t++],t=e[t];return defined(i)||(i=new CoplanarPolygonGeometry(scratchOptions$6)),i._polygonHierarchy=r,i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._stRotation=o,i.packedLength=t,i},CoplanarPolygonGeometry.createGeometry=function(e){var t=e._vertexFormat,i=e._polygonHierarchy,r=e._stRotation,n=i.positions;if(!((n=arrayRemoveDuplicates(n,Cartesian3.equalsEpsilon,!0)).length<3)){var a=scratchNormal$3,o=scratchTangent$1,s=scratchBitangent$1,l=axis1Scratch,c=axis2Scratch;if(CoplanarPolygonGeometryLibrary.computeProjectTo2DArguments(n,centerScratch,l,c)){a=Cartesian3.cross(l,c,a);a=Cartesian3.normalize(a,a),Cartesian3.equalsEpsilon(centerScratch,Cartesian3.ZERO,CesiumMath.EPSILON6)||(u=e._ellipsoid.geodeticSurfaceNormal(centerScratch,surfaceNormalScratch),Cartesian3.dot(a,u)<0&&(a=Cartesian3.negate(a,a),l=Cartesian3.negate(l,l)));var u=CoplanarPolygonGeometryLibrary.createProjectPointsTo2DFunction(centerScratch,l,c),d=CoplanarPolygonGeometryLibrary.createProjectPointTo2DFunction(centerScratch,l,c);t.tangent&&(o=Cartesian3.clone(l,o)),t.bitangent&&(s=Cartesian3.clone(c,s));var i=PolygonGeometryLibrary.polygonsFromHierarchy(i,u,!1),u=i.hierarchy,h=i.polygons;if(0!==u.length){n=u[0].outerRing;for(var i=BoundingSphere.fromPoints(n),p=PolygonGeometryLibrary.computeBoundingRectangle(a,d,n,r,scratchBR),m=[],f=0;f<h.length;f++){var g=new GeometryInstance({geometry:createGeometryFromPolygon(h[f],t,p,r,d,a,o,s)});m.push(g)}u=GeometryPipeline.combineInstances(m)[0];u.attributes.position.values=new Float64Array(u.attributes.position.values),u.indices=IndexDatatype$1.createTypedArray(u.attributes.position.values.length/3,u.indices);n=u.attributes;return t.position||delete n.position,new Geometry({attributes:n,indices:u.indices,primitiveType:u.primitiveType,boundingSphere:i})}}}},CoplanarPolygonOutlineGeometry.fromPositions=function(e){return new CoplanarPolygonOutlineGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions}})},CoplanarPolygonOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),t[i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i)]=e.packedLength,t};var scratchOptions$7={polygonHierarchy:{}};CoplanarPolygonOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;t=e[t];return defined(i)||(i=new CoplanarPolygonOutlineGeometry(scratchOptions$7)),i._polygonHierarchy=r,i.packedLength=t,i},CoplanarPolygonOutlineGeometry.createGeometry=function(e){var t=e._polygonHierarchy,e=arrayRemoveDuplicates(e=t.positions,Cartesian3.equalsEpsilon,!0);if(!(e.length<3)&&CoplanarPolygonGeometryLibrary.validOutline(e)){var i=PolygonGeometryLibrary.polygonOutlinesFromHierarchy(t,!1);if(0!==i.length){for(var r=[],n=0;n<i.length;n++){var a=new GeometryInstance({geometry:createGeometryFromPositions(i[n])});r.push(a)}e=GeometryPipeline.combineInstances(r)[0],t=BoundingSphere.fromPoints(t.positions);return new Geometry({attributes:e.attributes,indices:e.indices,primitiveType:e.primitiveType,boundingSphere:t})}}};var CornerType={ROUNDED:0,MITERED:1,BEVELED:2},CornerType$1=Object.freeze(CornerType);function setConstants(e){var t=e._uSquared,i=e._ellipsoid.maximumRadius,r=e._ellipsoid.minimumRadius,n=(i-r)/i,a=Math.cos(e._startHeading),o=Math.sin(e._startHeading),s=(1-n)*Math.tan(e._start.latitude),l=1/Math.sqrt(1+s*s),c=l*s,u=Math.atan2(s,a),d=l*o,h=d*d,p=1-h,m=Math.sqrt(p),f=t/4,g=f*f,_=g*f,y=g*g,C=1+f-3*g/4+5*_/4-175*y/64,v=1-f+15*g/8-35*_/8,S=1-3*f+35*g/4,T=1-5*f,t=C*u-v*Math.sin(2*u)*f/2-S*Math.sin(4*u)*g/16-T*Math.sin(6*u)*_/48-5*Math.sin(8*u)*y/512,e=e._constants;e.a=i,e.b=r,e.f=n,e.cosineHeading=a,e.sineHeading=o,e.tanU=s,e.cosineU=l,e.sineU=c,e.sigma=u,e.sineAlpha=d,e.sineSquaredAlpha=h,e.cosineSquaredAlpha=p,e.cosineAlpha=m,e.u2Over4=f,e.u4Over16=g,e.u6Over64=_,e.u8Over256=y,e.a0=C,e.a1=v,e.a2=S,e.a3=T,e.distanceRatio=t}function computeC(e,t){return e*t*(4+e*(4-3*t))/16}function computeDeltaLambda(e,t,i,r,n,a,o){i=computeC(e,i);return(1-i)*e*t*(r+i*n*(o+i*a*(2*o*o-1)))}function vincentyInverseFormula(e,t,i,r,n,a,o){var s=(t-i)/t,l=a-r,r=Math.atan((1-s)*Math.tan(n)),n=Math.atan((1-s)*Math.tan(o)),o=Math.cos(r),r=Math.sin(r),c=Math.cos(n),n=Math.sin(n),u=o*c,d=o*n,h=r*n,p=r*c,m=l,f=CesiumMath.TWO_PI,g=Math.cos(m),_=Math.sin(m);do{g=Math.cos(m),_=Math.sin(m);var y,C,v=d-p*g,S=Math.sqrt(c*c*_*_+v*v),T=h+u*g,x=Math.atan2(S,T),f=m,b=T-2*h/(C=0===S?(y=0,1):1-(y=u*_/S)*y)}while(isNaN(b)&&(b=0),m=l+computeDeltaLambda(s,y,C,x,S,T,b),Math.abs(m-f)>CesiumMath.EPSILON12);n=C*(t*t-i*i)/(i*i),r=n*(256+n*(n*(74-47*n)-128))/1024,t=b*b,r=i*(1+n*(4096+n*(n*(320-175*n)-768))/16384)*(x-r*S*(b+r*(T*(2*t-1)-r*b*(4*S*S-3)*(4*t-3)/6)/4)),t=Math.atan2(c*_,d-p*g),o=Math.atan2(o*_,d*g-p);e._distance=r,e._startHeading=t,e._endHeading=o,e._uSquared=n}var scratchCart1$1=new Cartesian3,scratchCart2$1=new Cartesian3;function computeProperties$1(e,t,i,r){Cartesian3.normalize(r.cartographicToCartesian(t,scratchCart2$1),scratchCart1$1),Cartesian3.normalize(r.cartographicToCartesian(i,scratchCart2$1),scratchCart2$1);vincentyInverseFormula(e,r.maximumRadius,r.minimumRadius,t.longitude,t.latitude,i.longitude,i.latitude),e._start=Cartographic.clone(t,e._start),e._end=Cartographic.clone(i,e._end),e._start.height=0,e._end.height=0,setConstants(e)}function EllipsoidGeodesic(e,t,i){i=defaultValue(i,Ellipsoid.WGS84);this._ellipsoid=i,this._start=new Cartographic,this._end=new Cartographic,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,defined(e)&&defined(t)&&computeProperties$1(this,e,t,i)}Object.defineProperties(EllipsoidGeodesic.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return this._startHeading}},endHeading:{get:function(){return this._endHeading}}}),EllipsoidGeodesic.prototype.setEndPoints=function(e,t){computeProperties$1(this,e,t,this._ellipsoid)},EllipsoidGeodesic.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},EllipsoidGeodesic.prototype.interpolateUsingSurfaceDistance=function(e,t){var i=this._constants,r=i.distanceRatio+e/i.b,n=Math.cos(2*r),a=Math.cos(4*r),o=Math.cos(6*r),s=Math.sin(2*r),l=Math.sin(4*r),c=Math.sin(6*r),u=Math.sin(8*r),d=r*r,h=r*d,p=i.u8Over256,m=i.u2Over4,f=i.u6Over64,e=i.u4Over16,d=2*h*p*n/3+r*(1-m+7*e/4-15*f/4+579*p/64-(e-15*f/4+187*p/16)*n-(5*f/4-115*p/16)*a-29*p*o/16)+(m/2-e+71*f/32-85*p/16)*s+(5*e/16-5*f/4+383*p/96)*l-d*((f-11*p/2)*s+5*p*l/2)+(29*f/96-29*p/16)*c+539*p*u/1536,s=Math.asin(Math.sin(d)*i.cosineAlpha),l=Math.atan(i.a/i.b*Math.tan(s));d-=i.sigma;f=Math.cos(2*i.sigma+d),c=Math.sin(d),p=Math.cos(d),u=i.cosineU*p,s=i.sineU*c,f=Math.atan2(c*i.sineHeading,u-s*i.cosineHeading)-computeDeltaLambda(i.f,i.sineAlpha,i.cosineSquaredAlpha,d,c,p,f);return defined(t)?(t.longitude=this._start.longitude+f,t.latitude=l,t.height=0,t):new Cartographic(this._start.longitude+f,l,0)};var PolylinePipeline={numberOfPoints:function(e,t,i){t=Cartesian3.distance(e,t);return Math.ceil(t/i)},numberOfPointsRhumbLine:function(e,t,i){t=Math.pow(e.longitude-t.longitude,2)+Math.pow(e.latitude-t.latitude,2);return Math.max(1,Math.ceil(Math.sqrt(t/(i*i))))}},cartoScratch=new Cartographic;PolylinePipeline.extractHeights=function(e,t){for(var i=e.length,r=new Array(i),n=0;n<i;n++){var a=e[n];r[n]=t.cartesianToCartographic(a,cartoScratch).height}return r};var wrapLongitudeInversMatrix=new Matrix4,wrapLongitudeOrigin=new Cartesian3,wrapLongitudeXZNormal=new Cartesian3,wrapLongitudeXZPlane=new Plane(Cartesian3.UNIT_X,0),wrapLongitudeYZNormal=new Cartesian3,wrapLongitudeYZPlane=new Plane(Cartesian3.UNIT_X,0),wrapLongitudeIntersection=new Cartesian3,wrapLongitudeOffset=new Cartesian3,subdivideHeightsScratchArray=[];function subdivideHeights(e,t,i){var r=subdivideHeightsScratchArray;if(r.length=e,t===i){for(a=0;a<e;a++)r[a]=t;return r}for(var n=(i-t)/e,a=0;a<e;a++){var o=t+a*n;r[a]=o}return r}var carto1=new Cartographic,carto2=new Cartographic,cartesian=new Cartesian3,scaleFirst=new Cartesian3,scaleLast=new Cartesian3,ellipsoidGeodesic=new EllipsoidGeodesic,ellipsoidRhumb=new EllipsoidRhumbLine;function generateCartesianArc(e,t,i,r,n,a,o,s){var l=r.scaleToGeodeticSurface(e,scaleFirst),c=r.scaleToGeodeticSurface(t,scaleLast),u=PolylinePipeline.numberOfPoints(e,t,i),l=r.cartesianToCartographic(l,carto1),c=r.cartesianToCartographic(c,carto2),d=subdivideHeights(u,n,a);ellipsoidGeodesic.setEndPoints(l,c);var h=ellipsoidGeodesic.surfaceDistance/u,p=s;l.height=n;var m=r.cartographicToCartesian(l,cartesian);Cartesian3.pack(m,o,p),p+=3;for(var f=1;f<u;f++){var g=ellipsoidGeodesic.interpolateUsingSurfaceDistance(f*h,carto2);g.height=d[f],m=r.cartographicToCartesian(g,cartesian),Cartesian3.pack(m,o,p),p+=3}return p}function generateCartesianRhumbArc(e,t,i,r,n,a,o,s){var e=r.cartesianToCartographic(e,carto1),t=r.cartesianToCartographic(t,carto2),l=PolylinePipeline.numberOfPointsRhumbLine(e,t,i);e.height=0,t.height=0;var c=subdivideHeights(l,n,a);ellipsoidRhumb.ellipsoid.equals(r)||(ellipsoidRhumb=new EllipsoidRhumbLine(void 0,void 0,r)),ellipsoidRhumb.setEndPoints(e,t);var u=ellipsoidRhumb.surfaceDistance/l,d=s;e.height=n;var h=r.cartographicToCartesian(e,cartesian);Cartesian3.pack(h,o,d),d+=3;for(var p=1;p<l;p++){var m=ellipsoidRhumb.interpolateUsingSurfaceDistance(p*u,carto2);m.height=c[p],h=r.cartographicToCartesian(m,cartesian),Cartesian3.pack(h,o,d),d+=3}return d}PolylinePipeline.wrapLongitude=function(e,t){var i=[],r=[];if(defined(e)&&0<e.length){t=defaultValue(t,Matrix4.IDENTITY);var n=Matrix4.inverseTransformation(t,wrapLongitudeInversMatrix),t=Matrix4.multiplyByPoint(n,Cartesian3.ZERO,wrapLongitudeOrigin),a=Cartesian3.normalize(Matrix4.multiplyByPointAsVector(n,Cartesian3.UNIT_Y,wrapLongitudeXZNormal),wrapLongitudeXZNormal),o=Plane.fromPointNormal(t,a,wrapLongitudeXZPlane),n=Cartesian3.normalize(Matrix4.multiplyByPointAsVector(n,Cartesian3.UNIT_X,wrapLongitudeYZNormal),wrapLongitudeYZNormal),s=Plane.fromPointNormal(t,n,wrapLongitudeYZPlane),l=1;i.push(Cartesian3.clone(e[0]));for(var c=i[0],u=e.length,d=1;d<u;++d){var h,p,m=e[d];!(Plane.getPointDistance(s,c)<0||Plane.getPointDistance(s,m)<0)||defined(h=IntersectionTests.lineSegmentPlane(c,m,o,wrapLongitudeIntersection))&&(p=Cartesian3.multiplyByScalar(a,5e-9,wrapLongitudeOffset),Plane.getPointDistance(o,c)<0&&Cartesian3.negate(p,p),i.push(Cartesian3.add(h,p,new Cartesian3)),r.push(l+1),Cartesian3.negate(p,p),i.push(Cartesian3.add(h,p,new Cartesian3)),l=1),i.push(Cartesian3.clone(e[d])),l++,c=m}r.push(l)}return{positions:i,lengths:r}},PolylinePipeline.generateArc=function(e){defined(e)||(e={});var t=e.positions,i=t.length,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.height,0),a=Array.isArray(n);if(i<1)return[];if(1===i){var o,s=r.scaleToGeodeticSurface(t[0],scaleFirst);return 0!==(n=a?n[0]:n)&&(o=r.geodeticSurfaceNormal(s,cartesian),Cartesian3.multiplyByScalar(o,n,o),Cartesian3.add(s,o,s)),[s.x,s.y,s.z]}var l=e.minDistance;defined(l)||(p=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),l=CesiumMath.chordLength(p,r.maximumRadius));for(var c=0,u=0;u<i-1;u++)c+=PolylinePipeline.numberOfPoints(t[u],t[u+1],l);var e=3*(c+1),d=new Array(e),h=0;for(u=0;u<i-1;u++)h=generateCartesianArc(t[u],t[u+1],l,r,a?n[u]:n,a?n[u+1]:n,d,h);subdivideHeightsScratchArray.length=0;var p=t[i-1],p=r.cartesianToCartographic(p,carto1);p.height=a?n[i-1]:n;p=r.cartographicToCartesian(p,cartesian);return Cartesian3.pack(p,d,e-3),d};var scratchCartographic0$1=new Cartographic,scratchCartographic1$1=new Cartographic;PolylinePipeline.generateRhumbArc=function(e){defined(e)||(e={});var t=e.positions,i=t.length,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.height,0),a=Array.isArray(n);if(i<1)return[];if(1===i){var o,s=r.scaleToGeodeticSurface(t[0],scaleFirst);return 0!==(n=a?n[0]:n)&&(o=r.geodeticSurfaceNormal(s,cartesian),Cartesian3.multiplyByScalar(o,n,o),Cartesian3.add(s,o,s)),[s.x,s.y,s.z]}for(var l,c=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),u=0,d=r.cartesianToCartographic(t[0],scratchCartographic0$1),h=0;h<i-1;h++)l=r.cartesianToCartographic(t[h+1],scratchCartographic1$1),u+=PolylinePipeline.numberOfPointsRhumbLine(d,l,c),d=Cartographic.clone(l,scratchCartographic0$1);var s=3*(u+1),p=new Array(s),m=0;for(h=0;h<i-1;h++)m=generateCartesianRhumbArc(t[h],t[h+1],c,r,a?n[h]:n,a?n[h+1]:n,p,m);subdivideHeightsScratchArray.length=0;e=t[i-1],e=r.cartesianToCartographic(e,carto1);e.height=a?n[i-1]:n;e=r.cartographicToCartesian(e,cartesian);return Cartesian3.pack(e,p,s-3),p},PolylinePipeline.generateCartesianArc=function(e){for(var t=PolylinePipeline.generateArc(e),i=t.length/3,r=new Array(i),n=0;n<i;n++)r[n]=Cartesian3.unpack(t,3*n);return r},PolylinePipeline.generateCartesianRhumbArc=function(e){for(var t=PolylinePipeline.generateRhumbArc(e),i=t.length/3,r=new Array(i),n=0;n<i;n++)r[n]=Cartesian3.unpack(t,3*n);return r};var scratch2Array=[new Cartesian3,new Cartesian3],scratchCartesian1$5=new Cartesian3,scratchCartesian2$5=new Cartesian3,scratchCartesian3$6=new Cartesian3,scratchCartesian4$2=new Cartesian3,scratchCartesian5$1=new Cartesian3,scratchCartesian6$1=new Cartesian3,scratchCartesian7=new Cartesian3,scratchCartesian8=new Cartesian3,scratchCartesian9=new Cartesian3,scratch1=new Cartesian3,scratch2=new Cartesian3,PolylineVolumeGeometryLibrary={},cartographic=new Cartographic;function scaleToSurface(e,t){for(var i=new Array(e.length),r=0;r<e.length;r++){var n=e[r];cartographic=t.cartesianToCartographic(n,cartographic),i[r]=cartographic.height,e[r]=t.scaleToGeodeticSurface(n,n)}return i}function subdivideHeights$1(e,t,i,r){var n=e[0],e=e[1],e=Cartesian3.angleBetween(n,e),a=Math.ceil(e/r),o=new Array(a);if(t===i){for(l=0;l<a;l++)o[l]=t;return o.push(i),o}for(var s=(i-t)/a,l=1;l<a;l++){var c=t+l*s;o[l]=c}return o[0]=t,o.push(i),o}var nextScratch=new Cartesian3,prevScratch=new Cartesian3;function computeRotationAngle(e,t,i,r){r=new EllipsoidTangentPlane(i,r),e=r.projectPointOntoPlane(Cartesian3.add(i,e,nextScratch),nextScratch),i=r.projectPointOntoPlane(Cartesian3.add(i,t,prevScratch),prevScratch),t=Cartesian2.angleBetween(e,i);return 0<=i.x*e.y-i.y*e.x?-t:t}var negativeX=new Cartesian3(-1,0,0),transform=new Matrix4,translation=new Matrix4,rotationZ=new Matrix3,scaleMatrix=Matrix3.IDENTITY.clone(),westScratch$1=new Cartesian3,finalPosScratch=new Cartesian4,heightCartesian=new Cartesian3;function addPosition(e,t,i,r,n,a,o,s){var l=westScratch$1,c=finalPosScratch;transform=Transforms.eastNorthUpToFixedFrame(e,n,transform),l=Matrix4.multiplyByPointAsVector(transform,negativeX,l);n=computeRotationAngle(Cartesian3.normalize(l,l),t,e,n);rotationZ=Matrix3.fromRotationZ(n,rotationZ),heightCartesian.z=a,transform=Matrix4.multiplyTransformation(transform,Matrix4.fromRotationTranslation(rotationZ,heightCartesian,translation),transform);var u=scaleMatrix;u[0]=o;for(var d=0;d<s;d++)for(var h=0;h<i.length;h+=3)c=Cartesian3.fromArray(i,h,c),c=Matrix3.multiplyByVector(u,c,c),c=Matrix4.multiplyByPoint(transform,c,c),r.push(c.x,c.y,c.z);return r}var centerScratch$1=new Cartesian3;function addPositions(e,t,i,r,n,a,o){for(var s=0;s<e.length;s+=3)r=addPosition(Cartesian3.fromArray(e,s,centerScratch$1),t,i,r,n,a[s/3],o,1);return r}function convertShapeTo3DDuplicate(e,t){var i=e.length,r=new Array(6*i),n=0,a=t.x+t.width/2,o=t.y+t.height/2,s=e[0];r[n++]=s.x-a,r[n++]=0,r[n++]=s.y-o;for(var l=1;l<i;l++){var c=(s=e[l]).x-a,u=s.y-o;r[n++]=c,r[n++]=0,r[n++]=u,r[n++]=c,r[n++]=0,r[n++]=u}return s=e[0],r[n++]=s.x-a,r[n++]=0,r[n++]=s.y-o,r}function convertShapeTo3D(e,t){for(var i=e.length,r=new Array(3*i),n=0,a=t.x+t.width/2,o=t.y+t.height/2,s=0;s<i;s++)r[n++]=e[s].x-a,r[n++]=0,r[n++]=e[s].y-o;return r}var quaterion=new Quaternion,startPointScratch=new Cartesian3,rotMatrix=new Matrix3;function computeRoundCorner(e,t,i,r,n,a,o,s,l,c){var u,d=Cartesian3.angleBetween(Cartesian3.subtract(t,e,scratch1),Cartesian3.subtract(i,e,scratch2)),h=r===CornerType$1.BEVELED?0:Math.ceil(d/CesiumMath.toRadians(5)),p=n?Matrix3.fromQuaternion(Quaternion.fromAxisAngle(Cartesian3.negate(e,scratch1),d/(h+1),quaterion),rotMatrix):Matrix3.fromQuaternion(Quaternion.fromAxisAngle(e,d/(h+1),quaterion),rotMatrix);if(t=Cartesian3.clone(t,startPointScratch),0<h)for(var m=c?2:1,f=0;f<h;f++)t=Matrix3.multiplyByVector(p,t,t),u=Cartesian3.subtract(t,e,scratch1),u=Cartesian3.normalize(u,u),n||(u=Cartesian3.negate(u,u)),o=addPosition(a.scaleToGeodeticSurface(t,scratch2),u,s,o,a,l,1,m);else u=Cartesian3.subtract(t,e,scratch1),u=Cartesian3.normalize(u,u),n||(u=Cartesian3.negate(u,u)),o=addPosition(a.scaleToGeodeticSurface(t,scratch2),u,s,o,a,l,1,1),i=Cartesian3.clone(i,startPointScratch),u=Cartesian3.subtract(i,e,scratch1),u=Cartesian3.normalize(u,u),n||(u=Cartesian3.negate(u,u)),o=addPosition(a.scaleToGeodeticSurface(i,scratch2),u,s,o,a,l,1,1);return o}PolylineVolumeGeometryLibrary.removeDuplicatesFromShape=function(e){for(var t=e.length,i=[],r=t-1,n=0;n<t;r=n++){var a=e[r],o=e[n];Cartesian2.equals(a,o)||i.push(o)}return i},PolylineVolumeGeometryLibrary.angleIsGreaterThanPi=function(e,t,i,r){r=new EllipsoidTangentPlane(i,r),e=r.projectPointOntoPlane(Cartesian3.add(i,e,nextScratch),nextScratch),t=r.projectPointOntoPlane(Cartesian3.add(i,t,prevScratch),prevScratch);return 0<=t.x*e.y-t.y*e.x};var scratchForwardProjection=new Cartesian3,scratchBackwardProjection=new Cartesian3;PolylineVolumeGeometryLibrary.computePositions=function(e,t,i,r,n){var a=r._ellipsoid,o=scaleToSurface(e,a),s=r._granularity,l=r._cornerType,c=(n?convertShapeTo3DDuplicate:convertShapeTo3D)(t,i),t=n?convertShapeTo3D(t,i):void 0,u=i.height/2,d=i.width/2,h=e.length,p=[],i=n?[]:void 0,m=scratchCartesian1$5,f=scratchCartesian2$5,g=scratchCartesian3$6,_=scratchCartesian4$2,y=scratchCartesian5$1,C=scratchCartesian6$1,v=scratchCartesian7,S=scratchCartesian8,T=scratchCartesian9,x=e[0],b=e[1],_=a.geodeticSurfaceNormal(x,_);m=Cartesian3.subtract(b,x,m),m=Cartesian3.normalize(m,m),S=Cartesian3.cross(_,m,S),S=Cartesian3.normalize(S,S);var E,P=o[0],A=o[1];n&&(i=addPosition(x,S,t,i,a,P+u,1,1)),T=Cartesian3.clone(x,T),x=b,f=Cartesian3.negate(m,f);for(var w=1;w<h-1;w++){var D=n?2:1,b=e[w+1],m=Cartesian3.subtract(b,x,m);m=Cartesian3.normalize(m,m),g=Cartesian3.add(m,f,g),g=Cartesian3.normalize(g,g),_=a.geodeticSurfaceNormal(x,_);var M=Cartesian3.multiplyByScalar(_,Cartesian3.dot(m,_),scratchForwardProjection);Cartesian3.subtract(m,M,M),Cartesian3.normalize(M,M);var I=Cartesian3.multiplyByScalar(_,Cartesian3.dot(f,_),scratchBackwardProjection);Cartesian3.subtract(f,I,I),Cartesian3.normalize(I,I),!CesiumMath.equalsEpsilon(Math.abs(Cartesian3.dot(M,I)),1,CesiumMath.EPSILON7)?(g=Cartesian3.cross(g,_,g),g=Cartesian3.cross(_,g,g),g=Cartesian3.normalize(g,g),M=1/Math.max(.25,Cartesian3.magnitude(Cartesian3.cross(g,f,scratch1))),(I=PolylineVolumeGeometryLibrary.angleIsGreaterThanPi(m,f,x,a))?(y=Cartesian3.add(x,Cartesian3.multiplyByScalar(g,M*d,g),y),C=Cartesian3.add(y,Cartesian3.multiplyByScalar(S,d,C),C),scratch2Array[0]=Cartesian3.clone(T,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(C,scratch2Array[1]),E=subdivideHeights$1(scratch2Array,P+u,A+u,s),p=addPositions(PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:a}),S,c,p,a,E,1),S=Cartesian3.cross(_,m,S),S=Cartesian3.normalize(S,S),v=Cartesian3.add(y,Cartesian3.multiplyByScalar(S,d,v),v),l===CornerType$1.ROUNDED||l===CornerType$1.BEVELED?computeRoundCorner(y,C,v,l,I,a,p,c,A+u,n):p=addPosition(x,g=Cartesian3.negate(g,g),c,p,a,A+u,M,D)):(y=Cartesian3.add(x,Cartesian3.multiplyByScalar(g,M*d,g),y),C=Cartesian3.add(y,Cartesian3.multiplyByScalar(S,-d,C),C),scratch2Array[0]=Cartesian3.clone(T,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(C,scratch2Array[1]),E=subdivideHeights$1(scratch2Array,P+u,A+u,s),p=addPositions(PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:a}),S,c,p,a,E,1),S=Cartesian3.cross(_,m,S),S=Cartesian3.normalize(S,S),v=Cartesian3.add(y,Cartesian3.multiplyByScalar(S,-d,v),v),l===CornerType$1.ROUNDED||l===CornerType$1.BEVELED?computeRoundCorner(y,C,v,l,I,a,p,c,A+u,n):p=addPosition(x,g,c,p,a,A+u,M,D)),T=Cartesian3.clone(v,T),f=Cartesian3.negate(m,f)):(p=addPosition(T,S,c,p,a,P+u,1,1),T=x),P=A,A=o[w+1],x=b}scratch2Array[0]=Cartesian3.clone(T,scratch2Array[0]),scratch2Array[1]=Cartesian3.clone(x,scratch2Array[1]),E=subdivideHeights$1(scratch2Array,P+u,A+u,s),p=addPositions(PolylinePipeline.generateArc({positions:scratch2Array,granularity:s,ellipsoid:a}),S,c,p,a,E,1),n&&(i=addPosition(x,S,t,i,a,A+u,1,1)),h=p.length;t=n?h+i.length:h,t=new Float64Array(t);return t.set(p),n&&t.set(i,h),t};var CorridorGeometryLibrary={},scratch1$1=new Cartesian3,scratch2$1=new Cartesian3,scratch3=new Cartesian3,scratch4=new Cartesian3,scaleArray2=[new Cartesian3,new Cartesian3],cartesian1=new Cartesian3,cartesian2=new Cartesian3,cartesian3=new Cartesian3,cartesian4=new Cartesian3,cartesian5=new Cartesian3,cartesian6=new Cartesian3,cartesian7=new Cartesian3,cartesian8=new Cartesian3,cartesian9=new Cartesian3,cartesian10=new Cartesian3,quaterion$1=new Quaternion,rotMatrix$1=new Matrix3;function computeRoundCorner$1(e,t,i,r,n){var a,o=Cartesian3.angleBetween(Cartesian3.subtract(t,e,scratch1$1),Cartesian3.subtract(i,e,scratch2$1)),s=r===CornerType$1.BEVELED?1:Math.ceil(o/CesiumMath.toRadians(5))+1,r=3*s,l=new Array(r);l[r-3]=i.x,l[r-2]=i.y,l[r-1]=i.z,a=n?Matrix3.fromQuaternion(Quaternion.fromAxisAngle(Cartesian3.negate(e,scratch1$1),o/s,quaterion$1),rotMatrix$1):Matrix3.fromQuaternion(Quaternion.fromAxisAngle(e,o/s,quaterion$1),rotMatrix$1);var c=0;t=Cartesian3.clone(t,scratch1$1);for(var u=0;u<s;u++)t=Matrix3.multiplyByVector(a,t,t),l[c++]=t.x,l[c++]=t.y,l[c++]=t.z;return l}function addEndCaps(e){var t=cartesian1,i=cartesian2,r=cartesian3,n=e[1],i=Cartesian3.fromArray(e[1],n.length-3,i),r=Cartesian3.fromArray(e[0],0,r),a=computeRoundCorner$1(t=Cartesian3.midpoint(i,r,t),i,r,CornerType$1.ROUNDED,!1),o=e.length-1,s=e[o-1],n=e[o];return i=Cartesian3.fromArray(s,s.length-3,i),r=Cartesian3.fromArray(n,0,r),[a,computeRoundCorner$1(t=Cartesian3.midpoint(i,r,t),i,r,CornerType$1.ROUNDED,!1)]}function computeMiteredCorner(e,t,i,r){var n=scratch1$1;return[(n=(r||(t=Cartesian3.negate(t,t)),Cartesian3.add(e,t,n))).x,n.y,n.z,i.x,i.y,i.z]}function addShiftedPositions(e,t,i,r){for(var n=new Array(e.length),a=new Array(e.length),o=Cartesian3.multiplyByScalar(t,i,scratch1$1),s=Cartesian3.negate(o,scratch2$1),l=0,c=e.length-1,u=0;u<e.length;u+=3){var d=Cartesian3.fromArray(e,u,scratch3),h=Cartesian3.add(d,s,scratch4);n[l++]=h.x,n[l++]=h.y,n[l++]=h.z;d=Cartesian3.add(d,o,scratch4);a[c--]=d.z,a[c--]=d.y,a[c--]=d.x}return r.push(n,a),r}CorridorGeometryLibrary.addAttribute=function(e,t,i,r){var n=t.x,a=t.y,t=t.z;defined(i)&&(e[i]=n,e[i+1]=a,e[i+2]=t),defined(r)&&(e[r]=t,e[r-1]=a,e[r-2]=n)};var scratchForwardProjection$1=new Cartesian3,scratchBackwardProjection$1=new Cartesian3;CorridorGeometryLibrary.computePositions=function(e){var t=e.granularity,i=e.positions,r=e.ellipsoid,n=e.width/2,a=e.cornerType,o=e.saveAttributes,s=cartesian1,l=cartesian2,c=cartesian3,u=cartesian4,d=cartesian5,h=cartesian6,p=cartesian7,m=cartesian8,f=cartesian9,g=cartesian10,_=[],y=o?[]:void 0,C=o?[]:void 0,v=i[0],S=i[1],l=Cartesian3.normalize(Cartesian3.subtract(S,v,l),l),s=r.geodeticSurfaceNormal(v,s),u=Cartesian3.normalize(Cartesian3.cross(s,l,u),u);o&&(y.push(u.x,u.y,u.z),C.push(s.x,s.y,s.z)),p=Cartesian3.clone(v,p),v=S,c=Cartesian3.negate(l,c);for(var T,x=[],b=i.length,E=1;E<b-1;E++){s=r.geodeticSurfaceNormal(v,s),S=i[E+1],l=Cartesian3.normalize(Cartesian3.subtract(S,v,l),l),d=Cartesian3.normalize(Cartesian3.add(l,c,d),d);var P=Cartesian3.multiplyByScalar(s,Cartesian3.dot(l,s),scratchForwardProjection$1);Cartesian3.subtract(l,P,P),Cartesian3.normalize(P,P);var A=Cartesian3.multiplyByScalar(s,Cartesian3.dot(c,s),scratchBackwardProjection$1);Cartesian3.subtract(c,A,A),Cartesian3.normalize(A,A),CesiumMath.equalsEpsilon(Math.abs(Cartesian3.dot(P,A)),1,CesiumMath.EPSILON7)||(d=Cartesian3.cross(d,s,d),d=Cartesian3.cross(s,d,d),d=Cartesian3.normalize(d,d),P=n/Math.max(.25,Cartesian3.magnitude(Cartesian3.cross(d,c,scratch1$1))),A=PolylineVolumeGeometryLibrary.angleIsGreaterThanPi(l,c,v,r),d=Cartesian3.multiplyByScalar(d,P,d),A?(m=Cartesian3.add(v,d,m),g=Cartesian3.add(m,Cartesian3.multiplyByScalar(u,n,g),g),f=Cartesian3.add(m,Cartesian3.multiplyByScalar(u,2*n,f),f),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(g,scaleArray2[1]),_=addShiftedPositions(PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:r}),u,n,_),o&&(y.push(u.x,u.y,u.z),C.push(s.x,s.y,s.z)),h=Cartesian3.clone(f,h),u=Cartesian3.normalize(Cartesian3.cross(s,l,u),u),f=Cartesian3.add(m,Cartesian3.multiplyByScalar(u,2*n,f),f),p=Cartesian3.add(m,Cartesian3.multiplyByScalar(u,n,p),p),a===CornerType$1.ROUNDED||a===CornerType$1.BEVELED?x.push({leftPositions:computeRoundCorner$1(m,h,f,a,A)}):x.push({leftPositions:computeMiteredCorner(v,Cartesian3.negate(d,d),f,A)})):(f=Cartesian3.add(v,d,f),g=Cartesian3.add(f,Cartesian3.negate(Cartesian3.multiplyByScalar(u,n,g),g),g),m=Cartesian3.add(f,Cartesian3.negate(Cartesian3.multiplyByScalar(u,2*n,m),m),m),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(g,scaleArray2[1]),_=addShiftedPositions(PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:r}),u,n,_),o&&(y.push(u.x,u.y,u.z),C.push(s.x,s.y,s.z)),h=Cartesian3.clone(m,h),u=Cartesian3.normalize(Cartesian3.cross(s,l,u),u),m=Cartesian3.add(f,Cartesian3.negate(Cartesian3.multiplyByScalar(u,2*n,m),m),m),p=Cartesian3.add(f,Cartesian3.negate(Cartesian3.multiplyByScalar(u,n,p),p),p),a===CornerType$1.ROUNDED||a===CornerType$1.BEVELED?x.push({rightPositions:computeRoundCorner$1(f,h,m,a,A)}):x.push({rightPositions:computeMiteredCorner(v,d,m,A)})),c=Cartesian3.negate(l,c)),v=S}return s=r.geodeticSurfaceNormal(v,s),scaleArray2[0]=Cartesian3.clone(p,scaleArray2[0]),scaleArray2[1]=Cartesian3.clone(v,scaleArray2[1]),_=addShiftedPositions(PolylinePipeline.generateArc({positions:scaleArray2,granularity:t,ellipsoid:r}),u,n,_),o&&(y.push(u.x,u.y,u.z),C.push(s.x,s.y,s.z)),a===CornerType$1.ROUNDED&&(T=addEndCaps(_)),{positions:_,corners:x,lefts:y,normals:C,endPositions:T}};var cartesian1$1=new Cartesian3,cartesian2$1=new Cartesian3,cartesian3$1=new Cartesian3,cartesian4$1=new Cartesian3,cartesian5$1=new Cartesian3,cartesian6$1=new Cartesian3,scratch1$2=new Cartesian3,scratch2$2=new Cartesian3;function scaleToSurface$1(e,t){for(var i=0;i<e.length;i++)e[i]=t.scaleToGeodeticSurface(e[i],e[i]);return e}function addNormals(e,t,i,r,n,a){var o=e.normals,s=e.tangents,l=e.bitangents,e=Cartesian3.normalize(Cartesian3.cross(i,t,scratch1$2),scratch1$2);a.normal&&CorridorGeometryLibrary.addAttribute(o,t,r,n),a.tangent&&CorridorGeometryLibrary.addAttribute(s,e,r,n),a.bitangent&&CorridorGeometryLibrary.addAttribute(l,i,r,n)}function combine$1(e,t,i){var r,n=e.positions,a=e.corners,o=e.endPositions,s=e.lefts,l=e.normals,c=new GeometryAttributes,u=0,d=0,h=0;for(R=0;R<n.length;R+=2)u+=r=n[R].length-3,h+=2*r,d+=n[R+1].length-3;for(u+=3,d+=3,R=0;R<a.length;R++){z=a[R];var p=a[R].leftPositions;defined(p)?u+=r=p.length:d+=r=a[R].rightPositions.length,h+=r}var m,f=defined(o);f&&(u+=m=o[0].length-3,d+=m,h+=6*(m/=3));var g,_,y,C,v,S,e=u+d,T=new Float64Array(e),x={normals:t.normal?new Float32Array(e):void 0,tangents:t.tangent?new Float32Array(e):void 0,bitangents:t.bitangent?new Float32Array(e):void 0},b=0,E=e-1,P=cartesian1$1,A=cartesian2$1,w=m/2,D=IndexDatatype$1.createTypedArray(e/3,h),M=0;if(f){S=cartesian3$1,v=cartesian4$1;for(var I=o[0],P=Cartesian3.fromArray(l,0,P),A=Cartesian3.fromArray(s,0,A),R=0;R<w;R++)S=Cartesian3.fromArray(I,3*(w-1-R),S),v=Cartesian3.fromArray(I,3*(w+R),v),CorridorGeometryLibrary.addAttribute(T,v,b),CorridorGeometryLibrary.addAttribute(T,S,void 0,E),addNormals(x,P,A,b,E,t),C=(_=b/3)+1,y=(g=(E-2)/3)-1,D[M++]=g,D[M++]=_,D[M++]=y,D[M++]=y,D[M++]=_,D[M++]=C,b+=3,E-=3}var O,L,F=0,N=0,B=n[F++],V=n[F++];for(T.set(B,b),T.set(V,E-V.length+1),A=Cartesian3.fromArray(s,N,A),r=V.length-3,R=0;R<r;R+=3)O=i.geodeticSurfaceNormal(Cartesian3.fromArray(B,R,scratch1$2),scratch1$2),L=i.geodeticSurfaceNormal(Cartesian3.fromArray(V,r-R,scratch2$2),scratch2$2),addNormals(x,P=Cartesian3.normalize(Cartesian3.add(O,L,P),P),A,b,E,t),C=(_=b/3)+1,y=(g=(E-2)/3)-1,D[M++]=g,D[M++]=_,D[M++]=y,D[M++]=y,D[M++]=_,D[M++]=C,b+=3,E-=3;for(O=i.geodeticSurfaceNormal(Cartesian3.fromArray(B,r,scratch1$2),scratch1$2),L=i.geodeticSurfaceNormal(Cartesian3.fromArray(V,r,scratch2$2),scratch2$2),P=Cartesian3.normalize(Cartesian3.add(O,L,P),P),N+=3,R=0;R<a.length;R++){var k,z,U,$,G=(z=a[R]).leftPositions,H=z.rightPositions,W=cartesian6$1,q=cartesian3$1,j=cartesian4$1;if(P=Cartesian3.fromArray(l,N,P),defined(G)){for(addNormals(x,P,A,void 0,E,t),E-=3,U=C,$=y,k=0;k<G.length/3;k++)W=Cartesian3.fromArray(G,3*k,W),D[M++]=U,D[M++]=$-k-1,D[M++]=$-k,CorridorGeometryLibrary.addAttribute(T,W,void 0,E),q=Cartesian3.fromArray(T,3*($-k-1),q),j=Cartesian3.fromArray(T,3*U,j),addNormals(x,P,A=Cartesian3.normalize(Cartesian3.subtract(q,j,A),A),void 0,E,t),E-=3;W=Cartesian3.fromArray(T,3*U,W),q=Cartesian3.subtract(Cartesian3.fromArray(T,3*$,q),W,q),j=Cartesian3.subtract(Cartesian3.fromArray(T,3*($-k),j),W,j),addNormals(x,P,A=Cartesian3.normalize(Cartesian3.add(q,j,A),A),b,void 0,t),b+=3}else{for(addNormals(x,P,A,b,void 0,t),b+=3,U=y,$=C,k=0;k<H.length/3;k++)W=Cartesian3.fromArray(H,3*k,W),D[M++]=U,D[M++]=$+k,D[M++]=$+k+1,CorridorGeometryLibrary.addAttribute(T,W,b),q=Cartesian3.fromArray(T,3*U,q),j=Cartesian3.fromArray(T,3*($+k),j),addNormals(x,P,A=Cartesian3.normalize(Cartesian3.subtract(q,j,A),A),b,void 0,t),b+=3;W=Cartesian3.fromArray(T,3*U,W),q=Cartesian3.subtract(Cartesian3.fromArray(T,3*($+k),q),W,q),j=Cartesian3.subtract(Cartesian3.fromArray(T,3*$,j),W,j),addNormals(x,P,A=Cartesian3.normalize(Cartesian3.negate(Cartesian3.add(j,q,A),A),A),void 0,E,t),E-=3}for(B=n[F++],V=n[F++],B.splice(0,3),V.splice(V.length-3,3),T.set(B,b),T.set(V,E-V.length+1),r=V.length-3,N+=3,A=Cartesian3.fromArray(s,N,A),k=0;k<V.length;k+=3)O=i.geodeticSurfaceNormal(Cartesian3.fromArray(B,k,scratch1$2),scratch1$2),L=i.geodeticSurfaceNormal(Cartesian3.fromArray(V,r-k,scratch2$2),scratch2$2),addNormals(x,P=Cartesian3.normalize(Cartesian3.add(O,L,P),P),A,b,E,t),_=(C=b/3)-1,g=(y=(E-2)/3)+1,D[M++]=g,D[M++]=_,D[M++]=y,D[M++]=y,D[M++]=_,D[M++]=C,b+=3,E-=3;b-=3,E+=3}if(addNormals(x,P=Cartesian3.fromArray(l,l.length-3,P),A,b,E,t),f){b+=3,E-=3,S=cartesian3$1,v=cartesian4$1;var Y=o[1];for(R=0;R<w;R++)S=Cartesian3.fromArray(Y,3*(m-R-1),S),v=Cartesian3.fromArray(Y,3*R,v),CorridorGeometryLibrary.addAttribute(T,S,void 0,E),CorridorGeometryLibrary.addAttribute(T,v,b),addNormals(x,P,A,b,E,t),_=(C=b/3)-1,g=(y=(E-2)/3)+1,D[M++]=g,D[M++]=_,D[M++]=y,D[M++]=y,D[M++]=_,D[M++]=C,b+=3,E-=3}if(c.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:T}),t.st){var X=new Float32Array(e/3*2),Q=0;if(f){u/=3,d/=3;var J,Z=Math.PI/(m+1),K=1/(u-m+1),ee=1/(d-m+1),te=m/2;for(R=1+te;R<m+1;R++)J=CesiumMath.PI_OVER_TWO+Z*R,X[Q++]=ee*(1+Math.cos(J)),X[Q++]=.5*(1+Math.sin(J));for(R=1;R<d-m+1;R++)X[Q++]=R*ee,X[Q++]=0;for(R=m;te<R;R--)J=CesiumMath.PI_OVER_TWO-R*Z,X[Q++]=1-ee*(1+Math.cos(J)),X[Q++]=.5*(1+Math.sin(J));for(R=te;0<R;R--)J=CesiumMath.PI_OVER_TWO-Z*R,X[Q++]=1-K*(1+Math.cos(J)),X[Q++]=.5*(1+Math.sin(J));for(R=u-m;0<R;R--)X[Q++]=R*K,X[Q++]=1;for(R=1;R<1+te;R++)J=CesiumMath.PI_OVER_TWO+Z*R,X[Q++]=K*(1+Math.cos(J)),X[Q++]=.5*(1+Math.sin(J))}else{for(K=1/((u/=3)-1),ee=1/((d/=3)-1),R=0;R<d;R++)X[Q++]=R*ee,X[Q++]=0;for(R=u;0<R;R--)X[Q++]=(R-1)*K,X[Q++]=1}c.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:X})}return t.normal&&(c.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:x.normals})),t.tangent&&(c.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:x.tangents})),t.bitangent&&(c.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:x.bitangents})),{attributes:c,indices:D}}function extrudedAttributes(e,t){if(!(t.normal||t.tangent||t.bitangent||t.st))return e;var i,r=e.position.values;(t.normal||t.bitangent)&&(i=e.normal.values,l=e.bitangent.values);var n=e.position.values.length/18,a=3*n,o=2*n,s=2*a;if(t.normal||t.bitangent||t.tangent){for(var l,c=t.normal?new Float32Array(6*a):void 0,u=t.tangent?new Float32Array(6*a):void 0,d=t.bitangent?new Float32Array(6*a):void 0,h=cartesian1$1,p=cartesian2$1,m=cartesian3$1,f=cartesian4$1,g=cartesian5$1,_=cartesian6$1,y=s,C=0;C<a;C+=3){var v=y+s,h=Cartesian3.fromArray(r,C,h),p=Cartesian3.fromArray(r,C+a,p),m=Cartesian3.fromArray(r,(C+3)%a,m);p=Cartesian3.subtract(p,h,p),m=Cartesian3.subtract(m,h,m),f=Cartesian3.normalize(Cartesian3.cross(p,m,f),f),t.normal&&(CorridorGeometryLibrary.addAttribute(c,f,v),CorridorGeometryLibrary.addAttribute(c,f,v+3),CorridorGeometryLibrary.addAttribute(c,f,y),CorridorGeometryLibrary.addAttribute(c,f,y+3)),(t.tangent||t.bitangent)&&(_=Cartesian3.fromArray(i,C,_),t.bitangent&&(CorridorGeometryLibrary.addAttribute(d,_,v),CorridorGeometryLibrary.addAttribute(d,_,v+3),CorridorGeometryLibrary.addAttribute(d,_,y),CorridorGeometryLibrary.addAttribute(d,_,y+3)),t.tangent&&(g=Cartesian3.normalize(Cartesian3.cross(_,f,g),g),CorridorGeometryLibrary.addAttribute(u,g,v),CorridorGeometryLibrary.addAttribute(u,g,v+3),CorridorGeometryLibrary.addAttribute(u,g,y),CorridorGeometryLibrary.addAttribute(u,g,y+3))),y+=6}if(t.normal){for(c.set(i),C=0;C<a;C+=3)c[C+a]=-i[C],c[C+a+1]=-i[C+1],c[C+a+2]=-i[C+2];e.normal.values=c}else e.normal=void 0;t.bitangent?(d.set(l),d.set(l,a),e.bitangent.values=d):e.bitangent=void 0,t.tangent&&(l=e.tangent.values,u.set(l),u.set(l,a),e.tangent.values=u)}if(t.st){var S=e.st.values,T=new Float32Array(6*o);T.set(S),T.set(S,o);for(var x=2*o,b=0;b<2;b++){for(T[x++]=S[0],T[x++]=S[1],C=2;C<o;C+=2){var E=S[C],P=S[C+1];T[x++]=E,T[x++]=P,T[x++]=E,T[x++]=P}T[x++]=S[0],T[x++]=S[1]}e.st.values=T}return e}function addWallPositions(e,t,i){i[t++]=e[0],i[t++]=e[1],i[t++]=e[2];for(var r=3;r<e.length;r+=3){var n=e[r],a=e[r+1],o=e[r+2];i[t++]=n,i[t++]=a,i[t++]=o,i[t++]=n,i[t++]=a,i[t++]=o}return i[t++]=e[0],i[t++]=e[1],i[t++]=e[2],i}function computePositionsExtruded(e,t){var i=new VertexFormat({position:t.position,normal:t.normal||t.bitangent||e.shadowVolume,tangent:t.tangent,bitangent:t.normal||t.bitangent,st:t.st}),r=e.ellipsoid,n=combine$1(CorridorGeometryLibrary.computePositions(e),i,r),a=e.height,o=e.extrudedHeight,s=n.attributes,l=n.indices,c=s.position.values,u=c.length,d=new Float64Array(6*u),i=new Float64Array(u);i.set(c);n=new Float64Array(4*u),n=addWallPositions(c=PolygonPipeline.scaleToGeodeticHeight(c,a,r),0,n);n=addWallPositions(i=PolygonPipeline.scaleToGeodeticHeight(i,o,r),2*u,n),d.set(c),d.set(i,u),d.set(n,2*u),s.position.values=d,s=extrudedAttributes(s,t);var h=u/3;if(e.shadowVolume){for(var p=s.normal.values,u=p.length,n=new Float32Array(6*u),m=0;m<u;m++)p[m]=-p[m];n.set(p,u),n=addWallPositions(p,4*u,n),s.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:n}),t.normal||(s.normal=void 0)}defined(e.offsetAttribute)&&(t=new Uint8Array(6*h),t=e.offsetAttribute===GeometryOffsetAttribute$1.TOP?(t=arrayFill(t,1,0,h),arrayFill(t,1,2*h,4*h)):arrayFill(t,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),s.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t}));var f=l.length,g=h+h,_=IndexDatatype$1.createTypedArray(d.length/3,2*f+3*g);_.set(l);var y,C,v,S,T=f;for(m=0;m<f;m+=3){var x=l[m],b=l[m+1],E=l[m+2];_[T++]=E+h,_[T++]=b+h,_[T++]=x+h}for(m=0;m<g;m+=2)v=(y=m+g)+1,S=(C=y+g)+1,_[T++]=y,_[T++]=C,_[T++]=v,_[T++]=v,_[T++]=C,_[T++]=S;return{attributes:s,indices:_}}var scratchCartesian1$6=new Cartesian3,scratchCartesian2$6=new Cartesian3,scratchCartographic$2=new Cartographic;function computeOffsetPoints(e,t,i,r,n,a){var o=Cartesian3.subtract(t,e,scratchCartesian1$6);Cartesian3.normalize(o,o);var s=i.geodeticSurfaceNormal(e,scratchCartesian2$6),l=Cartesian3.cross(o,s,scratchCartesian1$6);Cartesian3.multiplyByScalar(l,r,l);var c=n.latitude,u=n.longitude,t=a.latitude,o=a.longitude;Cartesian3.add(e,l,scratchCartesian2$6),i.cartesianToCartographic(scratchCartesian2$6,scratchCartographic$2);s=scratchCartographic$2.latitude,r=scratchCartographic$2.longitude,c=Math.min(c,s),u=Math.min(u,r),t=Math.max(t,s),o=Math.max(o,r);Cartesian3.subtract(e,l,scratchCartesian2$6),i.cartesianToCartographic(scratchCartesian2$6,scratchCartographic$2),s=scratchCartographic$2.latitude,r=scratchCartographic$2.longitude,c=Math.min(c,s),u=Math.min(u,r),t=Math.max(t,s),o=Math.max(o,r),n.latitude=c,n.longitude=u,a.latitude=t,a.longitude=o}var scratchCartesianOffset=new Cartesian3,scratchCartesianEnds=new Cartesian3,scratchCartographicMin=new Cartographic,scratchCartographicMax=new Cartographic;function computeRectangle$1(e,t,i,r,n){var a=arrayRemoveDuplicates(e=scaleToSurface$1(e,t),Cartesian3.equalsEpsilon),o=a.length;if(o<2||i<=0)return new Rectangle;var s,l,c=.5*i;scratchCartographicMin.latitude=Number.POSITIVE_INFINITY,scratchCartographicMin.longitude=Number.POSITIVE_INFINITY,scratchCartographicMax.latitude=Number.NEGATIVE_INFINITY,scratchCartographicMax.longitude=Number.NEGATIVE_INFINITY,r===CornerType$1.ROUNDED&&(d=a[0],Cartesian3.subtract(d,a[1],scratchCartesianOffset),Cartesian3.normalize(scratchCartesianOffset,scratchCartesianOffset),Cartesian3.multiplyByScalar(scratchCartesianOffset,c,scratchCartesianOffset),Cartesian3.add(d,scratchCartesianOffset,scratchCartesianEnds),t.cartesianToCartographic(scratchCartesianEnds,scratchCartographic$2),s=scratchCartographic$2.latitude,l=scratchCartographic$2.longitude,scratchCartographicMin.latitude=Math.min(scratchCartographicMin.latitude,s),scratchCartographicMin.longitude=Math.min(scratchCartographicMin.longitude,l),scratchCartographicMax.latitude=Math.max(scratchCartographicMax.latitude,s),scratchCartographicMax.longitude=Math.max(scratchCartographicMax.longitude,l));for(var u=0;u<o-1;++u)computeOffsetPoints(a[u],a[u+1],t,c,scratchCartographicMin,scratchCartographicMax);var d=a[o-1];Cartesian3.subtract(d,a[o-2],scratchCartesianOffset),Cartesian3.normalize(scratchCartesianOffset,scratchCartesianOffset),Cartesian3.multiplyByScalar(scratchCartesianOffset,c,scratchCartesianOffset),Cartesian3.add(d,scratchCartesianOffset,scratchCartesianEnds),computeOffsetPoints(d,scratchCartesianEnds,t,c,scratchCartographicMin,scratchCartographicMax),r===CornerType$1.ROUNDED&&(t.cartesianToCartographic(scratchCartesianEnds,scratchCartographic$2),s=scratchCartographic$2.latitude,l=scratchCartographic$2.longitude,scratchCartographicMin.latitude=Math.min(scratchCartographicMin.latitude,s),scratchCartographicMin.longitude=Math.min(scratchCartographicMin.longitude,l),scratchCartographicMax.latitude=Math.max(scratchCartographicMax.latitude,s),scratchCartographicMax.longitude=Math.max(scratchCartographicMax.longitude,l));n=defined(n)?n:new Rectangle;return n.north=scratchCartographicMax.latitude,n.south=scratchCartographicMin.latitude,n.east=scratchCartographicMax.longitude,n.west=scratchCartographicMin.longitude,n}function CorridorGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.width,r=defaultValue(e.height,0),n=defaultValue(e.extrudedHeight,r);this._positions=t,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._width=i,this._height=Math.max(r,n),this._extrudedHeight=Math.min(r,n),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createCorridorGeometry",this._offsetAttribute=e.offsetAttribute,this._rectangle=void 0,this.packedLength=1+t.length*Cartesian3.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+7}CorridorGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._positions,n=r.length;t[i++]=n;for(var a=0;a<n;++a,i+=Cartesian3.packedLength)Cartesian3.pack(r[a],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._width,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._cornerType,t[i++]=e._granularity,t[i++]=e._shadowVolume?1:0,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchEllipsoid$3=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$3=new VertexFormat,scratchOptions$8={positions:void 0,ellipsoid:scratchEllipsoid$3,vertexFormat:scratchVertexFormat$3,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,shadowVolume:void 0,offsetAttribute:void 0};CorridorGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var o=Ellipsoid.unpack(e,t,scratchEllipsoid$3);t+=Ellipsoid.packedLength;var s=VertexFormat.unpack(e,t,scratchVertexFormat$3);t+=VertexFormat.packedLength;var l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t++],p=1===e[t++],m=e[t];return defined(i)?(i._positions=n,i._ellipsoid=Ellipsoid.clone(o,i._ellipsoid),i._vertexFormat=VertexFormat.clone(s,i._vertexFormat),i._width=l,i._height=c,i._extrudedHeight=u,i._cornerType=d,i._granularity=h,i._shadowVolume=p,i._offsetAttribute=-1===m?void 0:m,i):(scratchOptions$8.positions=n,scratchOptions$8.width=l,scratchOptions$8.height=c,scratchOptions$8.extrudedHeight=u,scratchOptions$8.cornerType=d,scratchOptions$8.granularity=h,scratchOptions$8.shadowVolume=p,scratchOptions$8.offsetAttribute=-1===m?void 0:m,new CorridorGeometry(scratchOptions$8))},CorridorGeometry.computeRectangle=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,r=e.width;return computeRectangle$1(i,defaultValue(e.ellipsoid,Ellipsoid.WGS84),r,defaultValue(e.cornerType,CornerType$1.ROUNDED),t)},CorridorGeometry.createGeometry=function(e){var t=e._positions,i=e._width,r=e._ellipsoid,n=arrayRemoveDuplicates(t=scaleToSurface$1(t,r),Cartesian3.equalsEpsilon);if(!(n.length<2||i<=0)){var a,o=e._height,s=e._extrudedHeight,l=!CesiumMath.equalsEpsilon(o,s,0,CesiumMath.EPSILON2),t=e._vertexFormat,i={ellipsoid:r,positions:n,width:i,cornerType:e._cornerType,granularity:e._granularity,saveAttributes:!0};l?(i.height=o,i.extrudedHeight=s,i.shadowVolume=e._shadowVolume,i.offsetAttribute=e._offsetAttribute,a=computePositionsExtruded(i,t)):((a=combine$1(CorridorGeometryLibrary.computePositions(i),t,r)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(a.attributes.position.values,o,r),defined(e._offsetAttribute)&&(c=e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1,u=a.attributes.position.values.length,arrayFill(u=new Uint8Array(u/3),c),a.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:u})));var c=a.attributes,u=BoundingSphere.fromVertices(c.position.values,void 0,3);return t.position||(a.attributes.position.values=void 0),new Geometry({attributes:c,indices:a.indices,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:u,offsetAttribute:e._offsetAttribute})}},CorridorGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,t=t(r,n),i=i(r,n);return new CorridorGeometry({positions:e._positions,width:e._width,cornerType:e._cornerType,ellipsoid:n,granularity:r,extrudedHeight:t,height:i,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(CorridorGeometry.prototype,{rectangle:{get:function(){return defined(this._rectangle)||(this._rectangle=computeRectangle$1(this._positions,this._ellipsoid,this._width,this._cornerType)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return[0,0,0,1,1,0]}}});var cartesian1$2=new Cartesian3,cartesian2$2=new Cartesian3,cartesian3$2=new Cartesian3;function scaleToSurface$2(e,t){for(var i=0;i<e.length;i++)e[i]=t.scaleToGeodeticSurface(e[i],e[i]);return e}function combine$2(e,t){var i,r=[],n=e.positions,a=e.corners,o=e.endPositions,s=new GeometryAttributes,l=0,c=0,u=0;for(A=0;A<n.length;A+=2)l+=i=n[A].length-3,u+=i/3*4,c+=n[A+1].length-3;for(l+=3,c+=3,A=0;A<a.length;A++){R=a[A];var d=a[A].leftPositions;defined(d)?l+=i=d.length:c+=i=a[A].rightPositions.length,u+=i/3*2}var h,p=defined(o);p&&(l+=h=o[0].length-3,c+=h,u+=4*(h/=3));var m,f,g,_,y,C,e=l+c,v=new Float64Array(e),S=0,T=e-1,x=h/2,b=IndexDatatype$1.createTypedArray(e/3,u+4),E=0;if(b[E++]=S/3,b[E++]=(T-2)/3,p){r.push(S/3),C=cartesian1$2,y=cartesian2$2;for(var P=o[0],A=0;A<x;A++)C=Cartesian3.fromArray(P,3*(x-1-A),C),y=Cartesian3.fromArray(P,3*(x+A),y),CorridorGeometryLibrary.addAttribute(v,y,S),CorridorGeometryLibrary.addAttribute(v,C,void 0,T),_=(f=S/3)+1,g=(m=(T-2)/3)-1,b[E++]=m,b[E++]=g,b[E++]=f,b[E++]=_,S+=3,T-=3}var w=0,D=n[w++],M=n[w++];for(v.set(D,S),v.set(M,T-M.length+1),i=M.length-3,r.push(S/3,(T-2)/3),A=0;A<i;A+=3)_=(f=S/3)+1,g=(m=(T-2)/3)-1,b[E++]=m,b[E++]=g,b[E++]=f,b[E++]=_,S+=3,T-=3;for(A=0;A<a.length;A++){var I,R,O,L=(R=a[A]).leftPositions,F=R.rightPositions,N=cartesian3$2;if(defined(L)){for(T-=3,O=g,r.push(_),I=0;I<L.length/3;I++)N=Cartesian3.fromArray(L,3*I,N),b[E++]=O-I-1,b[E++]=O-I,CorridorGeometryLibrary.addAttribute(v,N,void 0,T),T-=3;r.push(O-Math.floor(L.length/6)),t===CornerType$1.BEVELED&&r.push((T-2)/3+1),S+=3}else{for(S+=3,O=_,r.push(g),I=0;I<F.length/3;I++)N=Cartesian3.fromArray(F,3*I,N),b[E++]=O+I,b[E++]=O+I+1,CorridorGeometryLibrary.addAttribute(v,N,S),S+=3;r.push(O+Math.floor(F.length/6)),t===CornerType$1.BEVELED&&r.push(S/3-1),T-=3}for(D=n[w++],M=n[w++],D.splice(0,3),M.splice(M.length-3,3),v.set(D,S),v.set(M,T-M.length+1),i=M.length-3,I=0;I<M.length;I+=3)f=(_=S/3)-1,m=(g=(T-2)/3)+1,b[E++]=m,b[E++]=g,b[E++]=f,b[E++]=_,S+=3,T-=3;S-=3,T+=3,r.push(S/3,(T-2)/3)}if(p){S+=3,T-=3,C=cartesian1$2,y=cartesian2$2;var B=o[1];for(A=0;A<x;A++)C=Cartesian3.fromArray(B,3*(h-A-1),C),y=Cartesian3.fromArray(B,3*A,y),CorridorGeometryLibrary.addAttribute(v,C,void 0,T),CorridorGeometryLibrary.addAttribute(v,y,S),f=(_=S/3)-1,m=(g=(T-2)/3)+1,b[E++]=m,b[E++]=g,b[E++]=f,b[E++]=_,S+=3,T-=3;r.push(S/3)}else r.push(S/3,(T-2)/3);return b[E++]=S/3,b[E++]=(T-2)/3,s.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:v}),{attributes:s,indices:b,wallIndices:r}}function computePositionsExtruded$1(e){var t=e.ellipsoid,i=combine$2(CorridorGeometryLibrary.computePositions(e),e.cornerType),r=i.wallIndices,n=e.height,a=e.extrudedHeight,o=i.attributes,s=i.indices,l=(c=o.position.values).length;(u=new Float64Array(l)).set(c);var i=new Float64Array(2*l),c=PolygonPipeline.scaleToGeodeticHeight(c,n,t),u=PolygonPipeline.scaleToGeodeticHeight(u,a,t);i.set(c),i.set(u,l),o.position.values=i,l/=3,defined(e.offsetAttribute)&&(u=new Uint8Array(2*l),u=e.offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(u,1,0,l):arrayFill(u,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),o.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:u}));var d=s.length,h=IndexDatatype$1.createTypedArray(i.length/3,2*(d+r.length));h.set(s);for(var p,m,f=d,g=0;g<d;g+=2){var _=s[g],y=s[g+1];h[f++]=_+l,h[f++]=y+l}for(g=0;g<r.length;g++)m=(p=r[g])+l,h[f++]=p,h[f++]=m;return{attributes:o,indices:h}}function CorridorOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.width,r=defaultValue(e.height,0),n=defaultValue(e.extrudedHeight,r);this._positions=t,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._width=i,this._height=Math.max(r,n),this._extrudedHeight=Math.min(r,n),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._offsetAttribute=e.offsetAttribute,this._workerName="createCorridorOutlineGeometry",this.packedLength=1+t.length*Cartesian3.packedLength+Ellipsoid.packedLength+6}CorridorOutlineGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._positions,n=r.length;t[i++]=n;for(var a=0;a<n;++a,i+=Cartesian3.packedLength)Cartesian3.pack(r[a],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._width,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._cornerType,t[i++]=e._granularity,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchEllipsoid$4=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$9={positions:void 0,ellipsoid:scratchEllipsoid$4,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,offsetAttribute:void 0};function CullingVolume(e){this.planes=defaultValue(e,[])}CorridorOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var o=Ellipsoid.unpack(e,t,scratchEllipsoid$4);t+=Ellipsoid.packedLength;var s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],h=e[t];return defined(i)?(i._positions=n,i._ellipsoid=Ellipsoid.clone(o,i._ellipsoid),i._width=s,i._height=l,i._extrudedHeight=c,i._cornerType=u,i._granularity=d,i._offsetAttribute=-1===h?void 0:h,i):(scratchOptions$9.positions=n,scratchOptions$9.width=s,scratchOptions$9.height=l,scratchOptions$9.extrudedHeight=c,scratchOptions$9.cornerType=u,scratchOptions$9.granularity=d,scratchOptions$9.offsetAttribute=-1===h?void 0:h,new CorridorOutlineGeometry(scratchOptions$9))},CorridorOutlineGeometry.createGeometry=function(e){var t=e._positions,i=e._width,r=e._ellipsoid,n=arrayRemoveDuplicates(t=scaleToSurface$2(t,r),Cartesian3.equalsEpsilon);if(!(n.length<2||i<=0)){var a,o=e._height,s=e._extrudedHeight,t=!CesiumMath.equalsEpsilon(o,s,0,CesiumMath.EPSILON2),i={ellipsoid:r,positions:n,width:i,cornerType:e._cornerType,granularity:e._granularity,saveAttributes:!1};t?(i.height=o,i.extrudedHeight=s,i.offsetAttribute=e._offsetAttribute,a=computePositionsExtruded$1(i)):((a=combine$2(CorridorGeometryLibrary.computePositions(i),i.cornerType)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(a.attributes.position.values,o,r),defined(e._offsetAttribute)&&(l=a.attributes.position.values.length,arrayFill(c=new Uint8Array(l/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),a.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:c})));var l=a.attributes,c=BoundingSphere.fromVertices(l.position.values,void 0,3);return new Geometry({attributes:l,indices:a.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:c,offsetAttribute:e._offsetAttribute})}};var faces=[new Cartesian3,new Cartesian3,new Cartesian3];Cartesian3.clone(Cartesian3.UNIT_X,faces[0]),Cartesian3.clone(Cartesian3.UNIT_Y,faces[1]),Cartesian3.clone(Cartesian3.UNIT_Z,faces[2]);var scratchPlaneCenter=new Cartesian3,scratchPlaneNormal$1=new Cartesian3,scratchPlane$1=new Plane(new Cartesian3(1,0,0),0);CullingVolume.fromBoundingSphere=function(e,t){defined(t)||(t=new CullingVolume);var i=faces.length,r=t.planes;r.length=2*i;for(var n=e.center,a=e.radius,o=0,s=0;s<i;++s){var l=faces[s],c=r[o],u=r[o+1];defined(c)||(c=r[o]=new Cartesian4),defined(u)||(u=r[o+1]=new Cartesian4),Cartesian3.multiplyByScalar(l,-a,scratchPlaneCenter),Cartesian3.add(n,scratchPlaneCenter,scratchPlaneCenter),c.x=l.x,c.y=l.y,c.z=l.z,c.w=-Cartesian3.dot(l,scratchPlaneCenter),Cartesian3.multiplyByScalar(l,a,scratchPlaneCenter),Cartesian3.add(n,scratchPlaneCenter,scratchPlaneCenter),u.x=-l.x,u.y=-l.y,u.z=-l.z,u.w=-Cartesian3.dot(Cartesian3.negate(l,scratchPlaneNormal$1),scratchPlaneCenter),o+=2}return t},CullingVolume.prototype.computeVisibility=function(e){for(var t=this.planes,i=!1,r=0,n=t.length;r<n;++r){var a=e.intersectPlane(Plane.fromCartesian4(t[r],scratchPlane$1));if(a===Intersect$1.OUTSIDE)return Intersect$1.OUTSIDE;a===Intersect$1.INTERSECTING&&(i=!0)}return i?Intersect$1.INTERSECTING:Intersect$1.INSIDE},CullingVolume.prototype.computeVisibilityWithPlaneMask=function(e,t){if(t===CullingVolume.MASK_OUTSIDE||t===CullingVolume.MASK_INSIDE)return t;for(var i=CullingVolume.MASK_INSIDE,r=this.planes,n=0,a=r.length;n<a;++n){var o=n<31?1<<n:0;if(!(n<31&&0==(t&o))){var s=e.intersectPlane(Plane.fromCartesian4(r[n],scratchPlane$1));if(s===Intersect$1.OUTSIDE)return CullingVolume.MASK_OUTSIDE;s===Intersect$1.INTERSECTING&&(i|=o)}}return i},CullingVolume.MASK_OUTSIDE=4294967295,CullingVolume.MASK_INSIDE=0,CullingVolume.MASK_INDETERMINATE=2147483647;var CylinderGeometryLibrary={computePositions:function(e,t,i,r,n){for(var a=.5*e,o=-a,e=r+r,s=new Float64Array(3*(n?2*e:e)),l=0,c=0,u=n?3*e:0,d=n?3*(e+r):3*r,h=0;h<r;h++){var p=h/r*CesiumMath.TWO_PI,m=Math.cos(p),f=Math.sin(p),g=m*i,p=f*i,m=m*t,f=f*t;s[c+u]=g,s[c+u+1]=p,s[c+u+2]=o,s[c+d]=m,s[c+d+1]=f,s[c+d+2]=a,c+=3,n&&(s[l++]=g,s[l++]=p,s[l++]=o,s[l++]=m,s[l++]=f,s[l++]=a)}return s}},radiusScratch=new Cartesian2,normalScratch$2=new Cartesian3,bitangentScratch=new Cartesian3,tangentScratch=new Cartesian3,positionScratch$1=new Cartesian3;function CylinderGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).length,i=e.topRadius,r=e.bottomRadius,n=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),a=defaultValue(e.slices,128);this._length=t,this._topRadius=i,this._bottomRadius=r,this._vertexFormat=VertexFormat.clone(n),this._slices=a,this._offsetAttribute=e.offsetAttribute,this._workerName="createCylinderGeometry"}CylinderGeometry.packedLength=VertexFormat.packedLength+5,CylinderGeometry.pack=function(e,t,i){return i=defaultValue(i,0),VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._length,t[i++]=e._topRadius,t[i++]=e._bottomRadius,t[i++]=e._slices,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchVertexFormat$4=new VertexFormat,scratchOptions$a={vertexFormat:scratchVertexFormat$4,length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,offsetAttribute:void 0},unitCylinderGeometry;CylinderGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=VertexFormat.unpack(e,t,scratchVertexFormat$4);t+=VertexFormat.packedLength;var n=e[t++],a=e[t++],o=e[t++],s=e[t++],t=e[t];return defined(i)?(i._vertexFormat=VertexFormat.clone(r,i._vertexFormat),i._length=n,i._topRadius=a,i._bottomRadius=o,i._slices=s,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$a.length=n,scratchOptions$a.topRadius=a,scratchOptions$a.bottomRadius=o,scratchOptions$a.slices=s,scratchOptions$a.offsetAttribute=-1===t?void 0:t,new CylinderGeometry(scratchOptions$a))},CylinderGeometry.createGeometry=function(e){var t=e._length,i=e._topRadius,r=e._bottomRadius,n=e._vertexFormat,a=e._slices;if(!(t<=0||i<0||r<0||0===i&&0===r)){var o=a+a,s=a+o,l=o+o,c=CylinderGeometryLibrary.computePositions(t,i,r,a,!0),u=n.st?new Float32Array(2*l):void 0,d=n.normal?new Float32Array(3*l):void 0,h=n.tangent?new Float32Array(3*l):void 0,p=n.bitangent?new Float32Array(3*l):void 0,m=n.normal||n.tangent||n.bitangent;if(m){var f=n.tangent||n.bitangent,g=0,_=0,y=0,C=Math.atan2(r-i,t),v=normalScratch$2;v.z=Math.sin(C);for(var S=Math.cos(C),T=tangentScratch,x=bitangentScratch,b=0;b<a;b++){var E=b/a*CesiumMath.TWO_PI,P=S*Math.cos(E),E=S*Math.sin(E);m&&(v.x=P,v.y=E,f&&(T=Cartesian3.normalize(Cartesian3.cross(Cartesian3.UNIT_Z,v,T),T)),n.normal&&(d[g++]=v.x,d[g++]=v.y,d[g++]=v.z,d[g++]=v.x,d[g++]=v.y,d[g++]=v.z),n.tangent&&(h[_++]=T.x,h[_++]=T.y,h[_++]=T.z,h[_++]=T.x,h[_++]=T.y,h[_++]=T.z),n.bitangent&&(x=Cartesian3.normalize(Cartesian3.cross(v,T,x),x),p[y++]=x.x,p[y++]=x.y,p[y++]=x.z,p[y++]=x.x,p[y++]=x.y,p[y++]=x.z))}for(b=0;b<a;b++)n.normal&&(d[g++]=0,d[g++]=0,d[g++]=-1),n.tangent&&(h[_++]=1,h[_++]=0,h[_++]=0),n.bitangent&&(p[y++]=0,p[y++]=-1,p[y++]=0);for(b=0;b<a;b++)n.normal&&(d[g++]=0,d[g++]=0,d[g++]=1),n.tangent&&(h[_++]=1,h[_++]=0,h[_++]=0),n.bitangent&&(p[y++]=0,p[y++]=1,p[y++]=0)}var C=12*a-12,A=IndexDatatype$1.createTypedArray(l,C),w=0,D=0;for(b=0;b<a-1;b++)A[w++]=D,A[w++]=D+2,A[w++]=D+3,A[w++]=D,A[w++]=D+3,A[w++]=D+1,D+=2;for(A[w++]=o-2,A[w++]=0,A[w++]=1,A[w++]=o-2,A[w++]=1,A[w++]=o-1,b=1;b<a-1;b++)A[w++]=o+b+1,A[w++]=o+b,A[w++]=o;for(b=1;b<a-1;b++)A[w++]=s,A[w++]=s+b,A[w++]=s+b+1;var M=0;if(n.st){var I=Math.max(i,r);for(b=0;b<l;b++){var R=Cartesian3.fromArray(c,3*b,positionScratch$1);u[M++]=(R.x+I)/(2*I),u[M++]=(R.y+I)/(2*I)}}C=new GeometryAttributes;n.position&&(C.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:c})),n.normal&&(C.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:d})),n.tangent&&(C.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),n.bitangent&&(C.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),n.st&&(C.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:u})),radiusScratch.x=.5*t,radiusScratch.y=Math.max(r,i);i=new BoundingSphere(Cartesian3.ZERO,Cartesian2.magnitude(radiusScratch));return defined(e._offsetAttribute)&&(t=c.length,arrayFill(t=new Uint8Array(t/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),C.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t})),new Geometry({attributes:C,indices:A,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:i,offsetAttribute:e._offsetAttribute})}},CylinderGeometry.getUnitCylinder=function(){return defined(unitCylinderGeometry)||(unitCylinderGeometry=CylinderGeometry.createGeometry(new CylinderGeometry({topRadius:1,bottomRadius:1,length:1,vertexFormat:VertexFormat.POSITION_ONLY}))),unitCylinderGeometry};var radiusScratch$1=new Cartesian2;function CylinderOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).length,i=e.topRadius,r=e.bottomRadius,n=defaultValue(e.slices,128),a=Math.max(defaultValue(e.numberOfVerticalLines,16),0);this._length=t,this._topRadius=i,this._bottomRadius=r,this._slices=n,this._numberOfVerticalLines=a,this._offsetAttribute=e.offsetAttribute,this._workerName="createCylinderOutlineGeometry"}CylinderOutlineGeometry.packedLength=6,CylinderOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e._length,t[i++]=e._topRadius,t[i++]=e._bottomRadius,t[i++]=e._slices,t[i++]=e._numberOfVerticalLines,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchOptions$b={length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,numberOfVerticalLines:void 0,offsetAttribute:void 0};function DefaultProxy(e){this.proxy=e}function DistanceDisplayCondition(e,t){e=defaultValue(e,0),this._near=e,t=defaultValue(t,Number.MAX_VALUE),this._far=t}function DistanceDisplayConditionGeometryInstanceAttribute(e,t){e=defaultValue(e,0),t=defaultValue(t,Number.MAX_VALUE),this.value=new Float32Array([e,t])}function DoublyLinkedList(){this.head=void 0,this.tail=void 0,this._length=0}function DoublyLinkedListNode(e,t,i){this.item=e,this.previous=t,this.next=i}function remove(e,t){defined(t.previous)&&defined(t.next)?(t.previous.next=t.next,t.next.previous=t.previous):defined(t.previous)?(t.previous.next=void 0,e.tail=t.previous):defined(t.next)?(t.next.previous=void 0,e.head=t.next):(e.head=void 0,e.tail=void 0),t.next=void 0,t.previous=void 0}CylinderOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=e[t++],n=e[t++],a=e[t++],o=e[t++],s=e[t++],t=e[t];return defined(i)?(i._length=r,i._topRadius=n,i._bottomRadius=a,i._slices=o,i._numberOfVerticalLines=s,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$b.length=r,scratchOptions$b.topRadius=n,scratchOptions$b.bottomRadius=a,scratchOptions$b.slices=o,scratchOptions$b.numberOfVerticalLines=s,scratchOptions$b.offsetAttribute=-1===t?void 0:t,new CylinderOutlineGeometry(scratchOptions$b))},CylinderOutlineGeometry.createGeometry=function(e){var t=e._length,i=e._topRadius,r=e._bottomRadius,n=e._slices,a=e._numberOfVerticalLines;if(!(t<=0||i<0||r<0||0===i&&0===r)){var o,s,l=2*n,c=CylinderGeometryLibrary.computePositions(t,i,r,n,!1),u=2*n;0<a&&(o=Math.min(a,n),s=Math.round(n/o),u+=o);for(var d=IndexDatatype$1.createTypedArray(l,2*u),h=0,p=0;p<n-1;p++)d[h++]=p,d[h++]=p+1,d[h++]=p+n,d[h++]=p+1+n;if(d[h++]=n-1,d[h++]=0,d[h++]=n+n-1,d[h++]=n,0<a)for(p=0;p<n;p+=s)d[h++]=p,d[h++]=p+n;a=new GeometryAttributes;a.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:c}),radiusScratch$1.x=.5*t,radiusScratch$1.y=Math.max(r,i);i=new BoundingSphere(Cartesian3.ZERO,Cartesian2.magnitude(radiusScratch$1));return defined(e._offsetAttribute)&&(t=c.length,arrayFill(t=new Uint8Array(t/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),a.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:t})),new Geometry({attributes:a,indices:d,primitiveType:PrimitiveType$1.LINES,boundingSphere:i,offsetAttribute:e._offsetAttribute})}},DefaultProxy.prototype.getURL=function(e){var t=-1===this.proxy.indexOf("?")?"?":"";return this.proxy+t+encodeURIComponent(e)},Object.defineProperties(DistanceDisplayCondition.prototype,{near:{get:function(){return this._near},set:function(e){this._near=e}},far:{get:function(){return this._far},set:function(e){this._far=e}}}),DistanceDisplayCondition.packedLength=2,DistanceDisplayCondition.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.near,t[i]=e.far,t},DistanceDisplayCondition.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new DistanceDisplayCondition),i.near=e[t++],i.far=e[t],i},DistanceDisplayCondition.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.near===t.near&&e.far===t.far},DistanceDisplayCondition.clone=function(e,t){if(defined(e))return defined(t)||(t=new DistanceDisplayCondition),t.near=e.near,t.far=e.far,t},DistanceDisplayCondition.prototype.clone=function(e){return DistanceDisplayCondition.clone(this,e)},DistanceDisplayCondition.prototype.equals=function(e){return DistanceDisplayCondition.equals(this,e)},Object.defineProperties(DistanceDisplayConditionGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.FLOAT}},componentsPerAttribute:{get:function(){return 2}},normalize:{get:function(){return!1}}}),DistanceDisplayConditionGeometryInstanceAttribute.fromDistanceDisplayCondition=function(e){return new DistanceDisplayConditionGeometryInstanceAttribute(e.near,e.far)},DistanceDisplayConditionGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?(t[0]=e.near,t[1]=e.far,t):new Float32Array([e.near,e.far])},Object.defineProperties(DoublyLinkedList.prototype,{length:{get:function(){return this._length}}}),DoublyLinkedList.prototype.add=function(e){e=new DoublyLinkedListNode(e,this.tail,void 0);return defined(this.tail)?this.tail.next=e:this.head=e,this.tail=e,++this._length,e},DoublyLinkedList.prototype.remove=function(e){defined(e)&&(remove(this,e),--this._length)},DoublyLinkedList.prototype.splice=function(e,t){var i;e!==t&&(remove(this,t),i=e.next,e.next=t,this.tail===e?this.tail=t:i.previous=t,t.next=i,t.previous=e)},void 0===Date.now&&(Date.now=function(){return(new Date).valueOf()});var TWEEN=TWEEN||(Zzb=[],{REVISION:"13",getAll:function(){return Zzb},removeAll:function(){Zzb=[]},add:function(e){Zzb.push(e)},remove:function(e){e=Zzb.indexOf(e);-1!==e&&Zzb.splice(e,1)},update:function(e){if(0===Zzb.length)return!1;var t=0;for(e=void 0!==e?e:("undefined"!=typeof window&&void 0!==window.performance&&void 0!==window.performance.now?window.performance:Date).now();t<Zzb.length;)Zzb[t].update(e)?t++:Zzb.splice(t,1);return!0}}),Zzb,hCb;TWEEN.Tween=function(e){var t,c=e,u={},d={},h={},p=1e3,m=0,f=!1,i=!1,g=0,_=null,y=TWEEN.Easing.Linear.None,C=TWEEN.Interpolation.Linear,v=[],S=null,T=!1,x=null,b=null,r=null;for(t in e)u[t]=parseFloat(e[t],10);this.to=function(e,t){return void 0!==t&&(p=t),d=e,this},this.start=function(e){for(var t in TWEEN.add(this),T=!(i=!0),_=void 0!==e?e:("undefined"!=typeof window&&void 0!==window.performance&&void 0!==window.performance.now?window.performance:Date).now(),_+=g,d){if(d[t]instanceof Array){if(0===d[t].length)continue;d[t]=[c[t]].concat(d[t])}u[t]=c[t],u[t]instanceof Array==!1&&(u[t]*=1),h[t]=u[t]||0}return this},this.stop=function(){return i&&(TWEEN.remove(this),i=!1,null!==r&&r.call(c),this.stopChainedTweens()),this},this.stopChainedTweens=function(){for(var e=0,t=v.length;e<t;e++)v[e].stop()},this.delay=function(e){return g=e,this},this.repeat=function(e){return m=e,this},this.yoyo=function(e){return f=e,this},this.easing=function(e){return y=e,this},this.interpolation=function(e){return C=e,this},this.chain=function(){return v=arguments,this},this.onStart=function(e){return S=e,this},this.onUpdate=function(e){return x=e,this},this.onComplete=function(e){return b=e,this},this.onStop=function(e){return r=e,this},this.update=function(e){if(e<_)return!0;!1===T&&(null!==S&&S.call(c),T=!0);var t,i=(e-_)/p,r=y(i=1<i?1:i);for(var n in d){var a=u[n]||0,o=d[n];o instanceof Array?c[n]=C(o,r):("string"==typeof o&&(o=a+parseFloat(o,10)),"number"==typeof o&&(c[n]=a+(o-a)*r))}if(null!==x&&x.call(c,r),1!=i)return!0;if(0<m){for(n in isFinite(m)&&m--,h)"string"==typeof d[n]&&(h[n]=h[n]+parseFloat(d[n],10)),f&&(t=h[n],h[n]=d[n],d[n]=t),u[n]=h[n];return _=e+g,!0}null!==b&&b.call(c);for(var s=0,l=v.length;s<l;s++)v[s].start(e);return!1}},TWEEN.Easing={Linear:{None:function(e){return e}},Quadratic:{In:function(e){return e*e},Out:function(e){return e*(2-e)},InOut:function(e){return(e*=2)<1?.5*e*e:-.5*(--e*(e-2)-1)}},Cubic:{In:function(e){return e*e*e},Out:function(e){return--e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e:.5*((e-=2)*e*e+2)}},Quartic:{In:function(e){return e*e*e*e},Out:function(e){return 1- --e*e*e*e},InOut:function(e){return(e*=2)<1?.5*e*e*e*e:-.5*((e-=2)*e*e*e-2)}},Quintic:{In:function(e){return e*e*e*e*e},Out:function(e){return--e*e*e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2)}},Sinusoidal:{In:function(e){return 1-Math.cos(e*Math.PI/2)},Out:function(e){return Math.sin(e*Math.PI/2)},InOut:function(e){return.5*(1-Math.cos(Math.PI*e))}},Exponential:{In:function(e){return 0===e?0:Math.pow(1024,e-1)},Out:function(e){return 1===e?1:1-Math.pow(2,-10*e)},InOut:function(e){return 0===e?0:1===e?1:(e*=2)<1?.5*Math.pow(1024,e-1):.5*(2-Math.pow(2,-10*(e-1)))}},Circular:{In:function(e){return 1-Math.sqrt(1-e*e)},Out:function(e){return Math.sqrt(1- --e*e)},InOut:function(e){return(e*=2)<1?-.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1)}},Elastic:{In:function(e){var t,i=.1;return 0===e?0:1===e?1:(t=!i||i<1?(i=1,.1):.4*Math.asin(1/i)/(2*Math.PI),-(i*Math.pow(2,10*--e)*Math.sin((e-t)*(2*Math.PI)/.4)))},Out:function(e){var t,i=.1;return 0===e?0:1===e?1:(t=!i||i<1?(i=1,.1):.4*Math.asin(1/i)/(2*Math.PI),i*Math.pow(2,-10*e)*Math.sin((e-t)*(2*Math.PI)/.4)+1)},InOut:function(e){var t,i=.1;return 0===e?0:1===e?1:(t=!i||i<1?(i=1,.1):.4*Math.asin(1/i)/(2*Math.PI),(e*=2)<1?i*Math.pow(2,10*--e)*Math.sin((e-t)*(2*Math.PI)/.4)*-.5:i*Math.pow(2,-10*--e)*Math.sin((e-t)*(2*Math.PI)/.4)*.5+1)}},Back:{In:function(e){return e*e*(2.70158*e-1.70158)},Out:function(e){return--e*e*(2.70158*e+1.70158)+1},InOut:function(e){var t=2.5949095;return(e*=2)<1?e*e*((1+t)*e-t)*.5:.5*((e-=2)*e*((1+t)*e+t)+2)}},Bounce:{In:function(e){return 1-TWEEN.Easing.Bounce.Out(1-e)},Out:function(e){return e<1/2.75?7.5625*e*e:e<2/2.75?7.5625*(e-=1.5/2.75)*e+.75:e<2.5/2.75?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375},InOut:function(e){return e<.5?.5*TWEEN.Easing.Bounce.In(2*e):.5*TWEEN.Easing.Bounce.Out(2*e-1)+.5}}},TWEEN.Interpolation={Linear:function(e,t){var i=e.length-1,r=i*t,n=Math.floor(r),a=TWEEN.Interpolation.Utils.Linear;return t<0?a(e[0],e[1],r):1<t?a(e[i],e[i-1],i-r):a(e[n],e[i<n+1?i:n+1],r-n)},Bezier:function(e,t){for(var i=0,r=e.length-1,n=Math.pow,a=TWEEN.Interpolation.Utils.Bernstein,o=0;o<=r;o++)i+=n(1-t,r-o)*n(t,o)*e[o]*a(r,o);return i},CatmullRom:function(e,t){var i=e.length-1,r=i*t,n=Math.floor(r),a=TWEEN.Interpolation.Utils.CatmullRom;return e[0]===e[i]?(t<0&&(n=Math.floor(r=i*(1+t))),a(e[(n-1+i)%i],e[n],e[(n+1)%i],e[(n+2)%i],r-n)):t<0?e[0]-(a(e[0],e[0],e[1],e[1],-r)-e[0]):1<t?e[i]-(a(e[i],e[i],e[i-1],e[i-1],r-i)-e[i]):a(e[n?n-1:0],e[n],e[i<n+1?i:n+1],e[i<n+2?i:n+2],r-n)},Utils:{Linear:function(e,t,i){return(t-e)*i+e},Bernstein:function(e,t){var i=TWEEN.Interpolation.Utils.Factorial;return i(e)/i(t)/i(e-t)},Factorial:(hCb=[1],function(e){var t,i=1;if(hCb[e])return hCb[e];for(t=e;1<t;t--)i*=t;return hCb[e]=i}),CatmullRom:function(e,t,i,r,n){var a=.5*(i-e),e=.5*(r-t),r=n*n;return(2*t-2*i+a+e)*(n*r)+(-3*t+3*i-2*a-e)*r+a*n+t}}};var warnings={};function oneTimeWarning(e,t){defined(warnings[e])||(warnings[e]=!0,console.warn(defaultValue(t,e)))}function deprecationWarning(e,t){oneTimeWarning(e,t)}oneTimeWarning.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",oneTimeWarning.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",oneTimeWarning.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",oneTimeWarning.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored";var EasingFunction={LINEAR_NONE:TWEEN.Easing.Linear.None,QUADRATIC_IN:TWEEN.Easing.Quadratic.In,QUADRATIC_OUT:TWEEN.Easing.Quadratic.Out,QUADRATIC_IN_OUT:TWEEN.Easing.Quadratic.InOut,CUBIC_IN:TWEEN.Easing.Cubic.In,CUBIC_OUT:TWEEN.Easing.Cubic.Out,CUBIC_IN_OUT:TWEEN.Easing.Cubic.InOut,QUARTIC_IN:TWEEN.Easing.Quartic.In,QUARTIC_OUT:TWEEN.Easing.Quartic.Out,QUARTIC_IN_OUT:TWEEN.Easing.Quartic.InOut,QUINTIC_IN:TWEEN.Easing.Quintic.In,QUINTIC_OUT:TWEEN.Easing.Quintic.Out,QUINTIC_IN_OUT:TWEEN.Easing.Quintic.InOut,SINUSOIDAL_IN:TWEEN.Easing.Sinusoidal.In,SINUSOIDAL_OUT:TWEEN.Easing.Sinusoidal.Out,SINUSOIDAL_IN_OUT:TWEEN.Easing.Sinusoidal.InOut,EXPONENTIAL_IN:TWEEN.Easing.Exponential.In,EXPONENTIAL_OUT:TWEEN.Easing.Exponential.Out,EXPONENTIAL_IN_OUT:TWEEN.Easing.Exponential.InOut,CIRCULAR_IN:TWEEN.Easing.Circular.In,CIRCULAR_OUT:TWEEN.Easing.Circular.Out,CIRCULAR_IN_OUT:TWEEN.Easing.Circular.InOut,ELASTIC_IN:TWEEN.Easing.Elastic.In,ELASTIC_OUT:TWEEN.Easing.Elastic.Out,ELASTIC_IN_OUT:TWEEN.Easing.Elastic.InOut,BACK_IN:TWEEN.Easing.Back.In,BACK_OUT:TWEEN.Easing.Back.Out,BACK_IN_OUT:TWEEN.Easing.Back.InOut,BOUNCE_IN:TWEEN.Easing.Bounce.In,BOUNCE_OUT:TWEEN.Easing.Bounce.Out,BOUNCE_IN_OUT:TWEEN.Easing.Bounce.InOut};Object.defineProperties(EasingFunction,{QUADRACTIC_IN:{get:function(){return deprecationWarning("QUADRACTIC_IN","QUADRACTIC_IN is deprecated and will be removed in Cesium 1.79. Use QUADRATIC_IN instead."),TWEEN.Easing.Quadratic.In}},QUADRACTIC_OUT:{get:function(){return deprecationWarning("QUADRACTIC_OUT","QUADRACTIC_OUT is deprecated and will be removed in Cesium 1.79. Use QUADRATIC_OUT instead."),TWEEN.Easing.Quadratic.Out}},QUADRACTIC_IN_OUT:{get:function(){return deprecationWarning("QUADRACTIC_IN_OUT","QUADRACTIC_IN_OUT is deprecated and will be removed in Cesium 1.79. Use QUADRATIC_IN_OUT instead."),TWEEN.Easing.Quadratic.InOut}}});var EasingFunction$1=Object.freeze(EasingFunction),scratchPosition$1=new Cartesian3,scratchNormal$4=new Cartesian3,scratchTangent$2=new Cartesian3,scratchBitangent$2=new Cartesian3,scratchNormalST=new Cartesian3,defaultRadii=new Cartesian3(1,1,1),cos=Math.cos,sin=Math.sin;function EllipsoidGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.radii,defaultRadii),i=defaultValue(e.innerRadii,t),r=defaultValue(e.minimumClock,0),n=defaultValue(e.maximumClock,CesiumMath.TWO_PI),a=defaultValue(e.minimumCone,0),o=defaultValue(e.maximumCone,CesiumMath.PI),s=Math.round(defaultValue(e.stackPartitions,64)),l=Math.round(defaultValue(e.slicePartitions,64)),c=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._radii=Cartesian3.clone(t),this._innerRadii=Cartesian3.clone(i),this._minimumClock=r,this._maximumClock=n,this._minimumCone=a,this._maximumCone=o,this._stackPartitions=s,this._slicePartitions=l,this._vertexFormat=VertexFormat.clone(c),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipsoidGeometry"}EllipsoidGeometry.packedLength=2*Cartesian3.packedLength+VertexFormat.packedLength+7,EllipsoidGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._radii,t,i),i+=Cartesian3.packedLength,Cartesian3.pack(e._innerRadii,t,i),i+=Cartesian3.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._minimumClock,t[i++]=e._maximumClock,t[i++]=e._minimumCone,t[i++]=e._maximumCone,t[i++]=e._stackPartitions,t[i++]=e._slicePartitions,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRadii=new Cartesian3,scratchInnerRadii=new Cartesian3,scratchVertexFormat$5=new VertexFormat,scratchOptions$c={radii:scratchRadii,innerRadii:scratchInnerRadii,vertexFormat:scratchVertexFormat$5,minimumClock:void 0,maximumClock:void 0,minimumCone:void 0,maximumCone:void 0,stackPartitions:void 0,slicePartitions:void 0,offsetAttribute:void 0},unitEllipsoidGeometry;EllipsoidGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchRadii);t+=Cartesian3.packedLength;var n=Cartesian3.unpack(e,t,scratchInnerRadii);t+=Cartesian3.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$5);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],t=e[t];return defined(i)?(i._radii=Cartesian3.clone(r,i._radii),i._innerRadii=Cartesian3.clone(n,i._innerRadii),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._minimumClock=o,i._maximumClock=s,i._minimumCone=l,i._maximumCone=c,i._stackPartitions=u,i._slicePartitions=d,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$c.minimumClock=o,scratchOptions$c.maximumClock=s,scratchOptions$c.minimumCone=l,scratchOptions$c.maximumCone=c,scratchOptions$c.stackPartitions=u,scratchOptions$c.slicePartitions=d,scratchOptions$c.offsetAttribute=-1===t?void 0:t,new EllipsoidGeometry(scratchOptions$c))},EllipsoidGeometry.createGeometry=function(e){var t=e._radii;if(!(t.x<=0||t.y<=0||t.z<=0)){var i=e._innerRadii;if(!(i.x<=0||i.y<=0||i.z<=0)){var r=e._minimumClock,n=e._maximumClock,a=e._minimumCone,o=e._maximumCone,s=e._vertexFormat,l=e._slicePartitions+1,c=e._stackPartitions+1;(l=Math.round(l*Math.abs(n-r)/CesiumMath.TWO_PI))<2&&(l=2),(c=Math.round(c*Math.abs(o-a)/CesiumMath.PI))<2&&(c=2);var u=0,d=[a],h=[r];for($=0;$<c;$++)d.push(a+$*(o-a)/(c-1));for(d.push(o),F=0;F<l;F++)h.push(r+F*(n-r)/(l-1));h.push(n);var p=d.length,m=h.length,f=0,g=1,_=i.x!==t.x||i.y!==t.y||i.z!==t.z,y=!1,C=!1,v=!1;_&&(g=2,0<a&&(y=!0,f+=l-1),o<Math.PI&&(C=!0,f+=l-1),(n-r)%CesiumMath.TWO_PI?(v=!0,f+=2*(c-1)+1):f+=1);var S=m*p*g,T=new Float64Array(3*S),x=arrayFill(new Array(S),!1),b=arrayFill(new Array(S),!1),E=l*c*g,f=6*(E+f+1-(l+c)*g),P=IndexDatatype$1.createTypedArray(E,f),A=s.normal?new Float32Array(3*S):void 0,w=s.tangent?new Float32Array(3*S):void 0,D=s.bitangent?new Float32Array(3*S):void 0,M=s.st?new Float32Array(2*S):void 0,I=new Array(p),R=new Array(p);for($=0;$<p;$++)I[$]=sin(d[$]),R[$]=cos(d[$]);for(var O=new Array(m),L=new Array(m),F=0;F<m;F++)L[F]=cos(h[F]),O[F]=sin(h[F]);for($=0;$<p;$++)for(F=0;F<m;F++)T[u++]=t.x*I[$]*L[F],T[u++]=t.y*I[$]*O[F],T[u++]=t.z*R[$];var N,B,V,k,z=S/2;if(_)for($=0;$<p;$++)for(F=0;F<m;F++)T[u++]=i.x*I[$]*L[F],T[u++]=i.y*I[$]*O[F],T[u++]=i.z*R[$],x[z]=!0,0<$&&$!==p-1&&0!==F&&F!==m-1&&(b[z]=!0),z++;for(u=0,$=1;$<p-2;$++)for(N=$*m,B=($+1)*m,F=1;F<m-2;F++)P[u++]=B+F,P[u++]=B+F+1,P[u++]=N+F+1,P[u++]=B+F,P[u++]=N+F+1,P[u++]=N+F;if(_)for(var U=p*m,$=1;$<p-2;$++)for(N=U+$*m,B=U+($+1)*m,F=1;F<m-2;F++)P[u++]=B+F,P[u++]=N+F,P[u++]=N+F+1,P[u++]=B+F,P[u++]=N+F+1,P[u++]=B+F+1;if(_){if(y)for(k=p*m,$=1;$<m-2;$++)P[u++]=$,P[u++]=$+1,P[u++]=k+$+1,P[u++]=$,P[u++]=k+$+1,P[u++]=k+$;if(C)for(V=p*m-m,k=p*m*g-m,$=1;$<m-2;$++)P[u++]=V+$+1,P[u++]=V+$,P[u++]=k+$,P[u++]=V+$+1,P[u++]=k+$,P[u++]=k+$+1}if(v){for($=1;$<p-2;$++)k=m*p+m*$,V=m*$,P[u++]=k,P[u++]=V+m,P[u++]=V,P[u++]=k,P[u++]=k+m,P[u++]=V+m;for($=1;$<p-2;$++)k=m*p+m*($+1)-1,V=m*($+1)-1,P[u++]=V+m,P[u++]=k,P[u++]=V,P[u++]=V+m,P[u++]=k+m,P[u++]=k}g=new GeometryAttributes;s.position&&(g.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:T}));var G=0,H=0,W=0,q=0,j=S/2,Y=Ellipsoid.fromCartesian3(t),X=Ellipsoid.fromCartesian3(i);if(s.st||s.normal||s.tangent||s.bitangent){for($=0;$<S;$++){Z=x[$]?X:Y;var Q,J=Cartesian3.fromArray(T,3*$,scratchPosition$1),Z=Z.geodeticSurfaceNormal(J,scratchNormal$4);b[$]&&Cartesian3.negate(Z,Z),s.st&&(Q=Cartesian2.negate(Z,scratchNormalST),M[G++]=Math.atan2(Q.y,Q.x)/CesiumMath.TWO_PI+.5,M[G++]=Math.asin(Z.z)/Math.PI+.5),s.normal&&(A[H++]=Z.x,A[H++]=Z.y,A[H++]=Z.z),(s.tangent||s.bitangent)&&(J=scratchTangent$2,Q=0,x[$]&&(Q=j),Q=!y&&Q<=$&&$<Q+2*m?Cartesian3.UNIT_X:Cartesian3.UNIT_Z,Cartesian3.cross(Q,Z,J),Cartesian3.normalize(J,J),s.tangent&&(w[W++]=J.x,w[W++]=J.y,w[W++]=J.z),s.bitangent&&(J=Cartesian3.cross(Z,J,scratchBitangent$2),Cartesian3.normalize(J,J),D[q++]=J.x,D[q++]=J.y,D[q++]=J.z))}s.st&&(g.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:M})),s.normal&&(g.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:A})),s.tangent&&(g.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:w})),s.bitangent&&(g.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:D}))}return defined(e._offsetAttribute)&&(v=T.length,arrayFill(v=new Uint8Array(v/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),g.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:v})),new Geometry({attributes:g,indices:P,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromEllipsoid(Y),offsetAttribute:e._offsetAttribute})}}},EllipsoidGeometry.getUnitEllipsoid=function(){return defined(unitEllipsoidGeometry)||(unitEllipsoidGeometry=EllipsoidGeometry.createGeometry(new EllipsoidGeometry({radii:new Cartesian3(1,1,1),vertexFormat:VertexFormat.POSITION_ONLY}))),unitEllipsoidGeometry};var defaultRadii$1=new Cartesian3(1,1,1),cos$1=Math.cos,sin$1=Math.sin;function EllipsoidOutlineGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.radii,defaultRadii$1),i=defaultValue(e.innerRadii,t),r=defaultValue(e.minimumClock,0),n=defaultValue(e.maximumClock,CesiumMath.TWO_PI),a=defaultValue(e.minimumCone,0),o=defaultValue(e.maximumCone,CesiumMath.PI),s=Math.round(defaultValue(e.stackPartitions,10)),l=Math.round(defaultValue(e.slicePartitions,8)),c=Math.round(defaultValue(e.subdivisions,128));this._radii=Cartesian3.clone(t),this._innerRadii=Cartesian3.clone(i),this._minimumClock=r,this._maximumClock=n,this._minimumCone=a,this._maximumCone=o,this._stackPartitions=s,this._slicePartitions=l,this._subdivisions=c,this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipsoidOutlineGeometry"}EllipsoidOutlineGeometry.packedLength=2*Cartesian3.packedLength+8,EllipsoidOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Cartesian3.pack(e._radii,t,i),i+=Cartesian3.packedLength,Cartesian3.pack(e._innerRadii,t,i),i+=Cartesian3.packedLength,t[i++]=e._minimumClock,t[i++]=e._maximumClock,t[i++]=e._minimumCone,t[i++]=e._maximumCone,t[i++]=e._stackPartitions,t[i++]=e._slicePartitions,t[i++]=e._subdivisions,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRadii$1=new Cartesian3,scratchInnerRadii$1=new Cartesian3,scratchOptions$d={radii:scratchRadii$1,innerRadii:scratchInnerRadii$1,minimumClock:void 0,maximumClock:void 0,minimumCone:void 0,maximumCone:void 0,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0,offsetAttribute:void 0};function EllipsoidTerrainProvider(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._tilingScheme=e.tilingScheme,defined(this._tilingScheme)||(this._tilingScheme=new GeographicTilingScheme({ellipsoid:defaultValue(e.ellipsoid,Ellipsoid.WGS84)})),this._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,64,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._errorEvent=new Event,this._readyPromise=when.resolve(!0)}function EventHelper(){this._removalFunctions=[]}EllipsoidOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Cartesian3.unpack(e,t,scratchRadii$1);t+=Cartesian3.packedLength;var n=Cartesian3.unpack(e,t,scratchInnerRadii$1);t+=Cartesian3.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=e[t++],t=e[t];return defined(i)?(i._radii=Cartesian3.clone(r,i._radii),i._innerRadii=Cartesian3.clone(n,i._innerRadii),i._minimumClock=a,i._maximumClock=o,i._minimumCone=s,i._maximumCone=l,i._stackPartitions=c,i._slicePartitions=u,i._subdivisions=d,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$d.minimumClock=a,scratchOptions$d.maximumClock=o,scratchOptions$d.minimumCone=s,scratchOptions$d.maximumCone=l,scratchOptions$d.stackPartitions=c,scratchOptions$d.slicePartitions=u,scratchOptions$d.subdivisions=d,scratchOptions$d.offsetAttribute=-1===t?void 0:t,new EllipsoidOutlineGeometry(scratchOptions$d))},EllipsoidOutlineGeometry.createGeometry=function(e){var t=e._radii;if(!(t.x<=0||t.y<=0||t.z<=0)){var i=e._innerRadii;if(!(i.x<=0||i.y<=0||i.z<=0)){var r=e._minimumClock,n=e._maximumClock,a=e._minimumCone,o=e._maximumCone,s=e._subdivisions,l=Ellipsoid.fromCartesian3(t),c=e._slicePartitions+1,u=e._stackPartitions+1;(c=Math.round(c*Math.abs(n-r)/CesiumMath.TWO_PI))<2&&(c=2),(u=Math.round(u*Math.abs(o-a)/CesiumMath.PI))<2&&(u=2);var d=0,h=1,p=i.x!==t.x||i.y!==t.y||i.z!==t.z,m=!1,f=!1;p&&(h=2,0<a&&(m=!0,d+=c),o<Math.PI&&(f=!0,d+=c));for(var g,_,y=s*h*(u+c),C=new Float64Array(3*y),d=2*(y+d-(c+u)*h),v=IndexDatatype$1.createTypedArray(y,d),S=0,T=new Array(u),x=new Array(u),b=0;b<u;b++)_=a+b*(o-a)/(u-1),T[b]=sin$1(_),x[b]=cos$1(_);var E=new Array(s),P=new Array(s);for(b=0;b<s;b++)g=r+b*(n-r)/(s-1),E[b]=sin$1(g),P[b]=cos$1(g);for(b=0;b<u;b++)for(w=0;w<s;w++)C[S++]=t.x*T[b]*P[w],C[S++]=t.y*T[b]*E[w],C[S++]=t.z*x[b];if(p)for(b=0;b<u;b++)for(w=0;w<s;w++)C[S++]=i.x*T[b]*P[w],C[S++]=i.y*T[b]*E[w],C[S++]=i.z*x[b];for(T.length=s,x.length=s,b=0;b<s;b++)_=a+b*(o-a)/(s-1),T[b]=sin$1(_),x[b]=cos$1(_);for(E.length=c,P.length=c,b=0;b<c;b++)g=r+b*(n-r)/(c-1),E[b]=sin$1(g),P[b]=cos$1(g);for(b=0;b<s;b++)for(w=0;w<c;w++)C[S++]=t.x*T[b]*P[w],C[S++]=t.y*T[b]*E[w],C[S++]=t.z*x[b];if(p)for(b=0;b<s;b++)for(w=0;w<c;w++)C[S++]=i.x*T[b]*P[w],C[S++]=i.y*T[b]*E[w],C[S++]=i.z*x[b];for(b=S=0;b<u*h;b++)for(var A=b*s,w=0;w<s-1;w++)v[S++]=A+w,v[S++]=A+w+1;var D=u*s*h;for(b=0;b<c;b++)for(w=0;w<s-1;w++)v[S++]=D+b+w*c,v[S++]=D+b+(w+1)*c;if(p)for(D=u*s*h+c*s,b=0;b<c;b++)for(w=0;w<s-1;w++)v[S++]=D+b+w*c,v[S++]=D+b+(w+1)*c;if(p){var M=u*s*h,I=M+s*c;if(m)for(b=0;b<c;b++)v[S++]=M+b,v[S++]=I+b;if(f)for(M+=s*c-c,I+=s*c-c,b=0;b<c;b++)v[S++]=M+b,v[S++]=I+b}m=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:C})});return defined(e._offsetAttribute)&&(f=C.length,arrayFill(f=new Uint8Array(f/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),m.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:f})),new Geometry({attributes:m,indices:v,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromEllipsoid(l),offsetAttribute:e._offsetAttribute})}}},Object.defineProperties(EllipsoidTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return!0}},readyPromise:{get:function(){return this._readyPromise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}}),EllipsoidTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){return when.resolve(new HeightmapTerrainData({buffer:new Uint8Array(256),width:16,height:16}))},EllipsoidTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},EllipsoidTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){},EllipsoidTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){},EventHelper.prototype.add=function(e,t,i){var r=e.addEventListener(t,i);this._removalFunctions.push(r);var n=this;return function(){r();var e=n._removalFunctions;e.splice(e.indexOf(r),1)}},EventHelper.prototype.removeAll=function(){for(var e=this._removalFunctions,t=0,i=e.length;t<i;++t)e[t]();e.length=0};var ExtrapolationType={NONE:0,HOLD:1,EXTRAPOLATE:2},ExtrapolationType$1=Object.freeze(ExtrapolationType);function OrthographicOffCenterFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this._cullingVolume=new CullingVolume,this._orthographicMatrix=new Matrix4}function update(e){e.top===e._top&&e.bottom===e._bottom&&e.left===e._left&&e.right===e._right&&e.near===e._near&&e.far===e._far||(e._left=e.left,e._right=e.right,e._top=e.top,e._bottom=e.bottom,e._near=e.near,e._far=e.far,e._orthographicMatrix=Matrix4.computeOrthographicOffCenter(e.left,e.right,e.bottom,e.top,e.near,e.far,e._orthographicMatrix))}Object.defineProperties(OrthographicOffCenterFrustum.prototype,{projectionMatrix:{get:function(){return update(this),this._orthographicMatrix}}});var getPlanesRight=new Cartesian3,getPlanesNearCenter=new Cartesian3,getPlanesPoint=new Cartesian3,negateScratch=new Cartesian3;function OrthographicFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._offCenterFrustum=new OrthographicOffCenterFrustum,this.width=e.width,this._width=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far}function update$1(e){var t,i=e._offCenterFrustum;e.width===e._width&&e.aspectRatio===e._aspectRatio&&e.near===e._near&&e.far===e._far||(e._aspectRatio=e.aspectRatio,e._width=e.width,e._near=e.near,e._far=e.far,t=1/e.aspectRatio,i.right=.5*e.width,i.left=-i.right,i.top=t*i.right,i.bottom=-i.top,i.near=e.near,i.far=e.far)}function PerspectiveOffCenterFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this._cullingVolume=new CullingVolume,this._perspectiveMatrix=new Matrix4,this._infinitePerspective=new Matrix4}function update$2(e){var t=e.top,i=e.bottom,r=e.right,n=e.left,a=e.near,o=e.far;t===e._top&&i===e._bottom&&n===e._left&&r===e._right&&a===e._near&&o===e._far||(e._left=n,e._right=r,e._top=t,e._bottom=i,e._near=a,e._far=o,e._perspectiveMatrix=Matrix4.computePerspectiveOffCenter(n,r,i,t,a,o,e._perspectiveMatrix),e._infinitePerspective=Matrix4.computeInfinitePerspectiveOffCenter(n,r,i,t,a,e._infinitePerspective))}OrthographicOffCenterFrustum.prototype.computeCullingVolume=function(e,t,i){var r=this._cullingVolume.planes,n=this.top,a=this.bottom,o=this.right,s=this.left,l=this.near,c=this.far,u=Cartesian3.cross(t,i,getPlanesRight);Cartesian3.normalize(u,u);var d=getPlanesNearCenter;Cartesian3.multiplyByScalar(t,l,d),Cartesian3.add(e,d,d);l=getPlanesPoint;Cartesian3.multiplyByScalar(u,s,l),Cartesian3.add(d,l,l);s=r[0];return defined(s)||(s=r[0]=new Cartesian4),s.x=u.x,s.y=u.y,s.z=u.z,s.w=-Cartesian3.dot(u,l),Cartesian3.multiplyByScalar(u,o,l),Cartesian3.add(d,l,l),defined(s=r[1])||(s=r[1]=new Cartesian4),s.x=-u.x,s.y=-u.y,s.z=-u.z,s.w=-Cartesian3.dot(Cartesian3.negate(u,negateScratch),l),Cartesian3.multiplyByScalar(i,a,l),Cartesian3.add(d,l,l),defined(s=r[2])||(s=r[2]=new Cartesian4),s.x=i.x,s.y=i.y,s.z=i.z,s.w=-Cartesian3.dot(i,l),Cartesian3.multiplyByScalar(i,n,l),Cartesian3.add(d,l,l),defined(s=r[3])||(s=r[3]=new Cartesian4),s.x=-i.x,s.y=-i.y,s.z=-i.z,s.w=-Cartesian3.dot(Cartesian3.negate(i,negateScratch),l),defined(s=r[4])||(s=r[4]=new Cartesian4),s.x=t.x,s.y=t.y,s.z=t.z,s.w=-Cartesian3.dot(t,d),Cartesian3.multiplyByScalar(t,c,l),Cartesian3.add(e,l,l),defined(s=r[5])||(s=r[5]=new Cartesian4),s.x=-t.x,s.y=-t.y,s.z=-t.z,s.w=-Cartesian3.dot(Cartesian3.negate(t,negateScratch),l),this._cullingVolume},OrthographicOffCenterFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){update(this);e=r*(this.right-this.left)/e,t=r*(this.top-this.bottom)/t;return n.x=e,n.y=t,n},OrthographicOffCenterFrustum.prototype.clone=function(e){return defined(e)||(e=new OrthographicOffCenterFrustum),e.left=this.left,e.right=this.right,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e},OrthographicOffCenterFrustum.prototype.equals=function(e){return defined(e)&&e instanceof OrthographicOffCenterFrustum&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far},OrthographicOffCenterFrustum.prototype.equalsEpsilon=function(e,t,i){return e===this||defined(e)&&e instanceof OrthographicOffCenterFrustum&&CesiumMath.equalsEpsilon(this.right,e.right,t,i)&&CesiumMath.equalsEpsilon(this.left,e.left,t,i)&&CesiumMath.equalsEpsilon(this.top,e.top,t,i)&&CesiumMath.equalsEpsilon(this.bottom,e.bottom,t,i)&&CesiumMath.equalsEpsilon(this.near,e.near,t,i)&&CesiumMath.equalsEpsilon(this.far,e.far,t,i)},OrthographicFrustum.packedLength=4,OrthographicFrustum.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.width,t[i++]=e.aspectRatio,t[i++]=e.near,t[i]=e.far,t},OrthographicFrustum.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new OrthographicFrustum),i.width=e[t++],i.aspectRatio=e[t++],i.near=e[t++],i.far=e[t],i},Object.defineProperties(OrthographicFrustum.prototype,{projectionMatrix:{get:function(){return update$1(this),this._offCenterFrustum.projectionMatrix}}}),OrthographicFrustum.prototype.computeCullingVolume=function(e,t,i){return update$1(this),this._offCenterFrustum.computeCullingVolume(e,t,i)},OrthographicFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){return update$1(this),this._offCenterFrustum.getPixelDimensions(e,t,i,r,n)},OrthographicFrustum.prototype.clone=function(e){return defined(e)||(e=new OrthographicFrustum),e.aspectRatio=this.aspectRatio,e.width=this.width,e.near=this.near,e.far=this.far,e._aspectRatio=void 0,e._width=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e},OrthographicFrustum.prototype.equals=function(e){return!!(defined(e)&&e instanceof OrthographicFrustum)&&(update$1(this),update$1(e),this.width===e.width&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum))},OrthographicFrustum.prototype.equalsEpsilon=function(e,t,i){return!!(defined(e)&&e instanceof OrthographicFrustum)&&(update$1(this),update$1(e),CesiumMath.equalsEpsilon(this.width,e.width,t,i)&&CesiumMath.equalsEpsilon(this.aspectRatio,e.aspectRatio,t,i)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,t,i))},Object.defineProperties(PerspectiveOffCenterFrustum.prototype,{projectionMatrix:{get:function(){return update$2(this),this._perspectiveMatrix}},infiniteProjectionMatrix:{get:function(){return update$2(this),this._infinitePerspective}}});var getPlanesRight$1=new Cartesian3,getPlanesNearCenter$1=new Cartesian3,getPlanesFarCenter=new Cartesian3,getPlanesNormal=new Cartesian3;function PerspectiveFrustum(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._offCenterFrustum=new PerspectiveOffCenterFrustum,this.fov=e.fov,this._fov=void 0,this._fovy=void 0,this._sseDenominator=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=defaultValue(e.near,1),this._near=this.near,this.far=defaultValue(e.far,5e8),this._far=this.far,this.xOffset=defaultValue(e.xOffset,0),this._xOffset=this.xOffset,this.yOffset=defaultValue(e.yOffset,0),this._yOffset=this.yOffset}function update$3(e){var t=e._offCenterFrustum;e.fov===e._fov&&e.aspectRatio===e._aspectRatio&&e.near===e._near&&e.far===e._far&&e.xOffset===e._xOffset&&e.yOffset===e._yOffset||(e._aspectRatio=e.aspectRatio,e._fov=e.fov,e._fovy=e.aspectRatio<=1?e.fov:2*Math.atan(Math.tan(.5*e.fov)/e.aspectRatio),e._near=e.near,e._far=e.far,e._sseDenominator=2*Math.tan(.5*e._fovy),e._xOffset=e.xOffset,e._yOffset=e.yOffset,t.top=e.near*Math.tan(.5*e._fovy),t.bottom=-t.top,t.right=e.aspectRatio*t.top,t.left=-t.right,t.near=e.near,t.far=e.far,t.right+=e.xOffset,t.left+=e.xOffset,t.top+=e.yOffset,t.bottom+=e.yOffset)}PerspectiveOffCenterFrustum.prototype.computeCullingVolume=function(e,t,i){var r=this._cullingVolume.planes,n=this.top,a=this.bottom,o=this.right,s=this.left,l=this.near,c=this.far,u=Cartesian3.cross(t,i,getPlanesRight$1),d=getPlanesNearCenter$1;Cartesian3.multiplyByScalar(t,l,d),Cartesian3.add(e,d,d);l=getPlanesFarCenter;Cartesian3.multiplyByScalar(t,c,l),Cartesian3.add(e,l,l);c=getPlanesNormal;Cartesian3.multiplyByScalar(u,s,c),Cartesian3.add(d,c,c),Cartesian3.subtract(c,e,c),Cartesian3.normalize(c,c),Cartesian3.cross(c,i,c),Cartesian3.normalize(c,c);s=r[0];return defined(s)||(s=r[0]=new Cartesian4),s.x=c.x,s.y=c.y,s.z=c.z,s.w=-Cartesian3.dot(c,e),Cartesian3.multiplyByScalar(u,o,c),Cartesian3.add(d,c,c),Cartesian3.subtract(c,e,c),Cartesian3.cross(i,c,c),Cartesian3.normalize(c,c),defined(s=r[1])||(s=r[1]=new Cartesian4),s.x=c.x,s.y=c.y,s.z=c.z,s.w=-Cartesian3.dot(c,e),Cartesian3.multiplyByScalar(i,a,c),Cartesian3.add(d,c,c),Cartesian3.subtract(c,e,c),Cartesian3.cross(u,c,c),Cartesian3.normalize(c,c),defined(s=r[2])||(s=r[2]=new Cartesian4),s.x=c.x,s.y=c.y,s.z=c.z,s.w=-Cartesian3.dot(c,e),Cartesian3.multiplyByScalar(i,n,c),Cartesian3.add(d,c,c),Cartesian3.subtract(c,e,c),Cartesian3.cross(c,u,c),Cartesian3.normalize(c,c),defined(s=r[3])||(s=r[3]=new Cartesian4),s.x=c.x,s.y=c.y,s.z=c.z,s.w=-Cartesian3.dot(c,e),defined(s=r[4])||(s=r[4]=new Cartesian4),s.x=t.x,s.y=t.y,s.z=t.z,s.w=-Cartesian3.dot(t,d),Cartesian3.negate(t,c),defined(s=r[5])||(s=r[5]=new Cartesian4),s.x=c.x,s.y=c.y,s.z=c.z,s.w=-Cartesian3.dot(c,l),this._cullingVolume},PerspectiveOffCenterFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){update$2(this);var a=1/this.near,t=2*r*i*(this.top*a)/t,e=2*r*i*(this.right*a)/e;return n.x=e,n.y=t,n},PerspectiveOffCenterFrustum.prototype.clone=function(e){return defined(e)||(e=new PerspectiveOffCenterFrustum),e.right=this.right,e.left=this.left,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e},PerspectiveOffCenterFrustum.prototype.equals=function(e){return defined(e)&&e instanceof PerspectiveOffCenterFrustum&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far},PerspectiveOffCenterFrustum.prototype.equalsEpsilon=function(e,t,i){return e===this||defined(e)&&e instanceof PerspectiveOffCenterFrustum&&CesiumMath.equalsEpsilon(this.right,e.right,t,i)&&CesiumMath.equalsEpsilon(this.left,e.left,t,i)&&CesiumMath.equalsEpsilon(this.top,e.top,t,i)&&CesiumMath.equalsEpsilon(this.bottom,e.bottom,t,i)&&CesiumMath.equalsEpsilon(this.near,e.near,t,i)&&CesiumMath.equalsEpsilon(this.far,e.far,t,i)},PerspectiveFrustum.packedLength=6,PerspectiveFrustum.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.fov,t[i++]=e.aspectRatio,t[i++]=e.near,t[i++]=e.far,t[i++]=e.xOffset,t[i]=e.yOffset,t},PerspectiveFrustum.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new PerspectiveFrustum),i.fov=e[t++],i.aspectRatio=e[t++],i.near=e[t++],i.far=e[t++],i.xOffset=e[t++],i.yOffset=e[t],i},Object.defineProperties(PerspectiveFrustum.prototype,{projectionMatrix:{get:function(){return update$3(this),this._offCenterFrustum.projectionMatrix}},infiniteProjectionMatrix:{get:function(){return update$3(this),this._offCenterFrustum.infiniteProjectionMatrix}},fovy:{get:function(){return update$3(this),this._fovy}},sseDenominator:{get:function(){return update$3(this),this._sseDenominator}}}),PerspectiveFrustum.prototype.computeCullingVolume=function(e,t,i){return update$3(this),this._offCenterFrustum.computeCullingVolume(e,t,i)},PerspectiveFrustum.prototype.getPixelDimensions=function(e,t,i,r,n){return update$3(this),this._offCenterFrustum.getPixelDimensions(e,t,i,r,n)},PerspectiveFrustum.prototype.clone=function(e){return defined(e)||(e=new PerspectiveFrustum),e.aspectRatio=this.aspectRatio,e.fov=this.fov,e.near=this.near,e.far=this.far,e._aspectRatio=void 0,e._fov=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e},PerspectiveFrustum.prototype.equals=function(e){return!!(defined(e)&&e instanceof PerspectiveFrustum)&&(update$3(this),update$3(e),this.fov===e.fov&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum))},PerspectiveFrustum.prototype.equalsEpsilon=function(e,t,i){return!!(defined(e)&&e instanceof PerspectiveFrustum)&&(update$3(this),update$3(e),CesiumMath.equalsEpsilon(this.fov,e.fov,t,i)&&CesiumMath.equalsEpsilon(this.aspectRatio,e.aspectRatio,t,i)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,t,i))};var PERSPECTIVE=0,ORTHOGRAPHIC=1;function FrustumGeometry(e){var t,i,r=e.frustum,n=e.orientation,a=e.origin,o=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),e=defaultValue(e._drawNearPlane,!0);r instanceof PerspectiveFrustum?(t=PERSPECTIVE,i=PerspectiveFrustum.packedLength):r instanceof OrthographicFrustum&&(t=ORTHOGRAPHIC,i=OrthographicFrustum.packedLength),this._frustumType=t,this._frustum=r.clone(),this._origin=Cartesian3.clone(a),this._orientation=Quaternion.clone(n),this._drawNearPlane=e,this._vertexFormat=o,this._workerName="createFrustumGeometry",this.packedLength=2+i+Cartesian3.packedLength+Quaternion.packedLength+VertexFormat.packedLength}FrustumGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._frustumType,n=e._frustum;return(t[i++]=r)===PERSPECTIVE?(PerspectiveFrustum.pack(n,t,i),i+=PerspectiveFrustum.packedLength):(OrthographicFrustum.pack(n,t,i),i+=OrthographicFrustum.packedLength),Cartesian3.pack(e._origin,t,i),i+=Cartesian3.packedLength,Quaternion.pack(e._orientation,t,i),i+=Quaternion.packedLength,VertexFormat.pack(e._vertexFormat,t,i),t[i+=VertexFormat.packedLength]=e._drawNearPlane?1:0,t};var scratchPackPerspective=new PerspectiveFrustum,scratchPackOrthographic=new OrthographicFrustum,scratchPackQuaternion=new Quaternion,scratchPackorigin=new Cartesian3,scratchVertexFormat$6=new VertexFormat;function getAttributes(e,t,i,r,n,a,o,s){for(var l=e/3*2,c=0;c<4;++c)defined(t)&&(t[e]=a.x,t[e+1]=a.y,t[e+2]=a.z),defined(i)&&(i[e]=o.x,i[e+1]=o.y,i[e+2]=o.z),defined(r)&&(r[e]=s.x,r[e+1]=s.y,r[e+2]=s.z),e+=3;n[l]=0,n[1+l]=0,n[2+l]=1,n[3+l]=0,n[4+l]=1,n[5+l]=1,n[6+l]=0,n[7+l]=1}FrustumGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r,n=e[t++];n===PERSPECTIVE?(r=PerspectiveFrustum.unpack(e,t,scratchPackPerspective),t+=PerspectiveFrustum.packedLength):(r=OrthographicFrustum.unpack(e,t,scratchPackOrthographic),t+=OrthographicFrustum.packedLength);var a=Cartesian3.unpack(e,t,scratchPackorigin);t+=Cartesian3.packedLength;var o=Quaternion.unpack(e,t,scratchPackQuaternion);t+=Quaternion.packedLength;var s=VertexFormat.unpack(e,t,scratchVertexFormat$6),e=1===e[t+=VertexFormat.packedLength];if(!defined(i))return new FrustumGeometry({frustum:r,origin:a,orientation:o,vertexFormat:s,_drawNearPlane:e});t=n===i._frustumType?i._frustum:void 0;return i._frustum=r.clone(t),i._frustumType=n,i._origin=Cartesian3.clone(a,i._origin),i._orientation=Quaternion.clone(o,i._orientation),i._vertexFormat=VertexFormat.clone(s,i._vertexFormat),i._drawNearPlane=e,i};var scratchRotationMatrix=new Matrix3,scratchViewMatrix=new Matrix4,scratchInverseMatrix=new Matrix4,scratchXDirection=new Cartesian3,scratchYDirection=new Cartesian3,scratchZDirection=new Cartesian3,scratchNegativeX=new Cartesian3,scratchNegativeY=new Cartesian3,scratchNegativeZ=new Cartesian3,frustumSplits=new Array(3),frustumCornersNDC=new Array(4);frustumCornersNDC[0]=new Cartesian4(-1,-1,1,1),frustumCornersNDC[1]=new Cartesian4(1,-1,1,1),frustumCornersNDC[2]=new Cartesian4(1,1,1,1),frustumCornersNDC[3]=new Cartesian4(-1,1,1,1);for(var scratchFrustumCorners=new Array(4),i$1=0;i$1<4;++i$1)scratchFrustumCorners[i$1]=new Cartesian4;FrustumGeometry._computeNearFarPlanes=function(e,t,i,r,n,a,o,s){var t=Matrix3.fromQuaternion(t,scratchRotationMatrix),a=defaultValue(a,scratchXDirection),o=defaultValue(o,scratchYDirection),l=defaultValue(s,scratchZDirection),a=Matrix3.getColumn(t,0,a),o=Matrix3.getColumn(t,1,o),l=Matrix3.getColumn(t,2,l);Cartesian3.normalize(a,a),Cartesian3.normalize(o,o),Cartesian3.normalize(l,l),Cartesian3.negate(a,a);var c,u,a=Matrix4.computeView(e,l,o,a,scratchViewMatrix);i===PERSPECTIVE?(i=r.projectionMatrix,i=Matrix4.multiply(i,a,scratchInverseMatrix),u=Matrix4.inverse(i,scratchInverseMatrix)):c=Matrix4.inverseTransformation(a,scratchInverseMatrix),defined(u)?(frustumSplits[0]=r.near,frustumSplits[1]=r.far):(frustumSplits[0]=0,frustumSplits[1]=r.near,frustumSplits[2]=r.far);for(var d=0;d<2;++d)for(var h=0;h<4;++h){var p,m,f=Cartesian4.clone(frustumCornersNDC[h],scratchFrustumCorners[h]);defined(u)?(p=1/(f=Matrix4.multiplyByVector(u,f,f)).w,Cartesian3.multiplyByScalar(f,p,f),Cartesian3.subtract(f,e,f),Cartesian3.normalize(f,f),m=Cartesian3.dot(l,f),Cartesian3.multiplyByScalar(f,frustumSplits[d]/m,f),Cartesian3.add(f,e,f)):(defined(r._offCenterFrustum)&&(r=r._offCenterFrustum),p=frustumSplits[d],m=frustumSplits[d+1],f.x=.5*(f.x*(r.right-r.left)+r.left+r.right),f.y=.5*(f.y*(r.top-r.bottom)+r.bottom+r.top),f.z=.5*(f.z*(p-m)-p-m),f.w=1,Matrix4.multiplyByVector(c,f,f)),n[12*d+3*h]=f.x,n[12*d+3*h+1]=f.y,n[12*d+3*h+2]=f.z}},FrustumGeometry.createGeometry=function(e){var t=e._frustumType,i=e._frustum,r=e._origin,n=e._orientation,a=e._drawNearPlane,o=e._vertexFormat,s=a?6:5,l=new Float64Array(72);FrustumGeometry._computeNearFarPlanes(r,n,t,i,l);var c=24;l[c]=l[12],l[c+1]=l[13],l[c+2]=l[14],l[c+3]=l[0],l[c+4]=l[1],l[c+5]=l[2],l[c+6]=l[9],l[c+7]=l[10],l[c+8]=l[11],l[c+9]=l[21],l[c+10]=l[22],l[c+11]=l[23],l[c+=12]=l[15],l[c+1]=l[16],l[c+2]=l[17],l[c+3]=l[3],l[c+4]=l[4],l[c+5]=l[5],l[c+6]=l[0],l[c+7]=l[1],l[c+8]=l[2],l[c+9]=l[12],l[c+10]=l[13],l[c+11]=l[14],l[c+=12]=l[3],l[c+1]=l[4],l[c+2]=l[5],l[c+3]=l[15],l[c+4]=l[16],l[c+5]=l[17],l[c+6]=l[18],l[c+7]=l[19],l[c+8]=l[20],l[c+9]=l[6],l[c+10]=l[7],l[c+11]=l[8],l[c+=12]=l[6],l[c+1]=l[7],l[c+2]=l[8],l[c+3]=l[18],l[c+4]=l[19],l[c+5]=l[20],l[c+6]=l[21],l[c+7]=l[22],l[c+8]=l[23],l[c+9]=l[9],l[c+10]=l[10],l[c+11]=l[11],a||(l=l.subarray(12));var u,d,h,p,m=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l})});(defined(o.normal)||defined(o.tangent)||defined(o.bitangent)||defined(o.st))&&(u=defined(o.normal)?new Float32Array(12*s):void 0,d=defined(o.tangent)?new Float32Array(12*s):void 0,h=defined(o.bitangent)?new Float32Array(12*s):void 0,p=defined(o.st)?new Float32Array(8*s):void 0,e=scratchXDirection,r=scratchYDirection,n=scratchZDirection,t=Cartesian3.negate(e,scratchNegativeX),i=Cartesian3.negate(r,scratchNegativeY),o=Cartesian3.negate(n,scratchNegativeZ),c=0,a&&(getAttributes(c,u,d,h,p,o,e,r),c+=12),getAttributes(c,u,d,h,p,n,t,r),getAttributes(c+=12,u,d,h,p,t,o,r),getAttributes(c+=12,u,d,h,p,i,o,t),getAttributes(c+=12,u,d,h,p,e,n,r),getAttributes(c+=12,u,d,h,p,r,n,t),defined(u)&&(m.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:u})),defined(d)&&(m.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:d})),defined(h)&&(m.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),defined(p)&&(m.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:p})));for(var f=new Uint16Array(6*s),g=0;g<s;++g){var _=6*g,y=4*g;f[_]=y,f[1+_]=1+y,f[2+_]=2+y,f[3+_]=y,f[4+_]=2+y,f[5+_]=3+y}return new Geometry({attributes:m,indices:f,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromVertices(l)})};var PERSPECTIVE$1=0,ORTHOGRAPHIC$1=1;function FrustumOutlineGeometry(e){var t,i,r=e.frustum,n=e.orientation,a=e.origin,e=defaultValue(e._drawNearPlane,!0);r instanceof PerspectiveFrustum?(t=PERSPECTIVE$1,i=PerspectiveFrustum.packedLength):r instanceof OrthographicFrustum&&(t=ORTHOGRAPHIC$1,i=OrthographicFrustum.packedLength),this._frustumType=t,this._frustum=r.clone(),this._origin=Cartesian3.clone(a),this._orientation=Quaternion.clone(n),this._drawNearPlane=e,this._workerName="createFrustumOutlineGeometry",this.packedLength=2+i+Cartesian3.packedLength+Quaternion.packedLength}FrustumOutlineGeometry.pack=function(e,t,i){i=defaultValue(i,0);var r=e._frustumType,n=e._frustum;return(t[i++]=r)===PERSPECTIVE$1?(PerspectiveFrustum.pack(n,t,i),i+=PerspectiveFrustum.packedLength):(OrthographicFrustum.pack(n,t,i),i+=OrthographicFrustum.packedLength),Cartesian3.pack(e._origin,t,i),i+=Cartesian3.packedLength,Quaternion.pack(e._orientation,t,i),t[i+=Quaternion.packedLength]=e._drawNearPlane?1:0,t};var scratchPackPerspective$1=new PerspectiveFrustum,scratchPackOrthographic$1=new OrthographicFrustum,scratchPackQuaternion$1=new Quaternion,scratchPackorigin$1=new Cartesian3;FrustumOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r,n=e[t++];n===PERSPECTIVE$1?(r=PerspectiveFrustum.unpack(e,t,scratchPackPerspective$1),t+=PerspectiveFrustum.packedLength):(r=OrthographicFrustum.unpack(e,t,scratchPackOrthographic$1),t+=OrthographicFrustum.packedLength);var a=Cartesian3.unpack(e,t,scratchPackorigin$1);t+=Cartesian3.packedLength;var o=Quaternion.unpack(e,t,scratchPackQuaternion$1),e=1===e[t+=Quaternion.packedLength];if(!defined(i))return new FrustumOutlineGeometry({frustum:r,origin:a,orientation:o,_drawNearPlane:e});t=n===i._frustumType?i._frustum:void 0;return i._frustum=r.clone(t),i._frustumType=n,i._origin=Cartesian3.clone(a,i._origin),i._orientation=Quaternion.clone(o,i._orientation),i._drawNearPlane=e,i},FrustumOutlineGeometry.createGeometry=function(e){var t=e._frustumType,i=e._frustum,r=e._origin,n=e._orientation,a=e._drawNearPlane,e=new Float64Array(24);FrustumGeometry._computeNearFarPlanes(r,n,t,i,e);for(var o,s,i=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e})}),l=a?2:1,c=new Uint16Array(8*(1+l)),u=a?0:1;u<2;++u)s=4*u,c[o=a?8*u:0]=s,c[o+1]=s+1,c[o+2]=s+1,c[o+3]=s+2,c[o+4]=s+2,c[o+5]=s+3,c[o+6]=s+3,c[o+7]=s;for(u=0;u<2;++u)s=4*u,c[o=8*(l+u)]=s,c[o+1]=s+4,c[o+2]=s+1,c[o+3]=s+5,c[o+4]=s+2,c[o+5]=s+6,c[o+6]=s+3,c[o+7]=s+7;return new Geometry({attributes:i,indices:c,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromVertices(e)})};var GeocodeType={SEARCH:0,AUTOCOMPLETE:1},GeocodeType$1=Object.freeze(GeocodeType);function GeocoderService(){}function GeometryFactory(){DeveloperError.throwInstantiationError()}function GeometryInstanceAttribute(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=defaultValue(e.normalize,!1),this.value=e.value}GeocoderService.prototype.geocode=DeveloperError.throwInstantiationError,GeometryFactory.createGeometry=function(e){DeveloperError.throwInstantiationError()};var tmp$1={};!function(global,undefined$1){var $Jb,_Jb,aKb;$Jb={1:[function(e,t,i){t.exports=function(e,t){for(var i=[],r=2;r<arguments.length;)i.push(arguments[r++]);var a=!0;return new Promise(function(r,n){i.push(function(e){if(a)if(a=!1,e)n(e);else{for(var t=[],i=1;i<arguments.length;)t.push(arguments[i++]);r.apply(null,t)}});try{e.apply(t||this,i)}catch(e){a&&(a=!1,n(e))}})}},{}],2:[function(e,t,i){i.length=function(e){var t=e.length;if(!t)return 0;for(var i=0;1<--t%4&&"="===e.charAt(t);)++i;return Math.ceil(3*e.length)/4-i};for(var l=new Array(64),c=new Array(123),r=0;r<64;)c[l[r]=r<26?r+65:r<52?r+71:r<62?r-4:r-59|43]=r++;i.encode=function(e,t,i){for(var r,n=[],a=0,o=0;t<i;){var s=e[t++];switch(o){case 0:n[a++]=l[s>>2],r=(3&s)<<4,o=1;break;case 1:n[a++]=l[r|s>>4],r=(15&s)<<2,o=2;break;case 2:n[a++]=l[r|s>>6],n[a++]=l[63&s],o=0}}return o&&(n[a++]=l[r],n[a]=61,1===o&&(n[a+1]=61)),String.fromCharCode.apply(String,n)};var u="invalid encoding";i.decode=function(e,t,i){for(var r,n=i,a=0,o=0;o<e.length;){var s=e.charCodeAt(o++);if(61===s&&1<a)break;if((s=c[s])===undefined$1)throw Error(u);switch(a){case 0:r=s,a=1;break;case 1:t[i++]=r<<2|(48&s)>>4,r=s,a=2;break;case 2:t[i++]=(15&r)<<4|(60&s)>>2,r=s,a=3;break;case 3:t[i++]=(3&r)<<6|s,a=0}}if(1===a)throw Error(u);return i-n},i.test=function(e){return/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(e)}},{}],3:[function(e,t,i){function r(){this._listeners={}}(t.exports=r).prototype.on=function(e,t,i){return(this._listeners[e]||(this._listeners[e]=[])).push({fn:t,ctx:i||this}),this},r.prototype.off=function(e,t){if(e===undefined$1)this._listeners={};else if(t===undefined$1)this._listeners[e]=[];else for(var i=this._listeners[e],r=0;r<i.length;)i[r].fn===t?i.splice(r,1):++r;return this},r.prototype.emit=function(e){var t=this._listeners[e];if(t){for(var i=[],r=1;r<arguments.length;)i.push(arguments[r++]);for(r=0;r<t.length;)t[r].fn.apply(t[r++].ctx,i)}return this}},{}],4:[function(require,module,exports){function inquire(moduleName){try{var mod=eval("quire".replace(/^/,"re"))(moduleName);if(mod&&(mod.length||Object.keys(mod).length))return mod}catch(e){}return null}module.exports=inquire},{}],5:[function(e,t,i){t.exports=function(t,i,e){var r=e||8192,n=r>>>1,a=null,o=r;return function(e){if(e<1||n<e)return t(e);r<o+e&&(a=t(r),o=0);e=i.call(a,o,o+=e);return 7&o&&(o=1+(7|o)),e}}},{}],6:[function(e,t,i){i.length=function(e){for(var t,i=0,r=0;r<e.length;++r)(t=e.charCodeAt(r))<128?i+=1:t<2048?i+=2:55296==(64512&t)&&56320==(64512&e.charCodeAt(r+1))?(++r,i+=4):i+=3;return i},i.read=function(e,t,i){if(i-t<1)return"";for(var r,n=null,a=[],o=0;t<i;)(r=e[t++])<128?a[o++]=r:191<r&&r<224?a[o++]=(31&r)<<6|63&e[t++]:239<r&&r<365?(r=((7&r)<<18|(63&e[t++])<<12|(63&e[t++])<<6|63&e[t++])-65536,a[o++]=55296+(r>>10),a[o++]=56320+(1023&r)):a[o++]=(15&r)<<12|(63&e[t++])<<6|63&e[t++],8191<o&&((n=n||[]).push(String.fromCharCode.apply(String,a)),o=0);return n?(o&&n.push(String.fromCharCode.apply(String,a.slice(0,o))),n.join("")):String.fromCharCode.apply(String,a.slice(0,o))},i.write=function(e,t,i){for(var r,n,a=i,o=0;o<e.length;++o)(r=e.charCodeAt(o))<128?t[i++]=r:(r<2048?t[i++]=r>>6|192:(55296==(64512&r)&&56320==(64512&(n=e.charCodeAt(o+1)))?(r=65536+((1023&r)<<10)+(1023&n),++o,t[i++]=r>>18|240,t[i++]=r>>12&63|128):t[i++]=r>>12|224,t[i++]=r>>6&63|128),t[i++]=63&r|128);return i-a}},{}],7:[function(e,t,i){var r=i;function n(){r.Reader._configure(r.BufferReader),r.util._configure()}r.build="minimal",r.roots={},r.Writer=e(14),r.BufferWriter=e(15),r.Reader=e(8),r.BufferReader=e(9),r.util=e(13),r.rpc=e(10),r.configure=n,r.Writer._configure(r.BufferWriter),n()},{10:10,13:13,14:14,15:15,8:8,9:9}],8:[function(e,t,i){t.exports=l;var r,n=e(13),a=n.LongBits,o=n.utf8;function s(e,t){return RangeError("index out of range: "+e.pos+" + "+(t||1)+" > "+e.len)}function l(e){this.buf=e,this.pos=0,this.len=e.length}var c,u="undefined"!=typeof Uint8Array?function(e){if(e instanceof Uint8Array||Array.isArray(e))return new l(e);throw Error("illegal buffer")}:function(e){if(Array.isArray(e))return new l(e);throw Error("illegal buffer")};function d(){var e=new a(0,0),t=0;if(!(4<this.len-this.pos)){for(;t<3;++t){if(this.pos>=this.len)throw s(this);if(e.lo=(e.lo|(127&this.buf[this.pos])<<7*t)>>>0,this.buf[this.pos++]<128)return e}return e.lo=(e.lo|(127&this.buf[this.pos++])<<7*t)>>>0,e}for(;t<4;++t)if(e.lo=(e.lo|(127&this.buf[this.pos])<<7*t)>>>0,this.buf[this.pos++]<128)return e;if(e.lo=(e.lo|(127&this.buf[this.pos])<<28)>>>0,e.hi=(e.hi|(127&this.buf[this.pos])>>4)>>>0,this.buf[this.pos++]<128)return e;if(t=0,4<this.len-this.pos){for(;t<5;++t)if(e.hi=(e.hi|(127&this.buf[this.pos])<<7*t+3)>>>0,this.buf[this.pos++]<128)return e}else for(;t<5;++t){if(this.pos>=this.len)throw s(this);if(e.hi=(e.hi|(127&this.buf[this.pos])<<7*t+3)>>>0,this.buf[this.pos++]<128)return e}throw Error("invalid varint encoding")}function h(e,t){return(e[t-4]|e[t-3]<<8|e[t-2]<<16|e[t-1]<<24)>>>0}function p(){if(this.pos+8>this.len)throw s(this,8);return new a(h(this.buf,this.pos+=4),h(this.buf,this.pos+=4))}l.create=n.Buffer?function(e){return(l.create=function(e){return n.Buffer.isBuffer(e)?new r(e):u(e)})(e)}:u,l.prototype._slice=n.Array.prototype.subarray||n.Array.prototype.slice,l.prototype.uint32=(c=4294967295,function(){if(c=(127&this.buf[this.pos])>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<7)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<14)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<21)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(15&this.buf[this.pos])<<28)>>>0,this.buf[this.pos++]<128)return c;if((this.pos+=5)>this.len)throw this.pos=this.len,s(this,10);return c}),l.prototype.int32=function(){return 0|this.uint32()},l.prototype.sint32=function(){var e=this.uint32();return e>>>1^-(1&e)|0},l.prototype.bool=function(){return 0!==this.uint32()},l.prototype.fixed32=function(){if(this.pos+4>this.len)throw s(this,4);return h(this.buf,this.pos+=4)},l.prototype.sfixed32=function(){if(this.pos+4>this.len)throw s(this,4);return 0|h(this.buf,this.pos+=4)};var m,f,g="undefined"!=typeof Float32Array?(m=new Float32Array(1),f=new Uint8Array(m.buffer),m[0]=-0,f[3]?function(e,t){return f[0]=e[t],f[1]=e[t+1],f[2]=e[t+2],f[3]=e[t+3],m[0]}:function(e,t){return f[0]=e[t+3],f[1]=e[t+2],f[2]=e[t+1],f[3]=e[t],m[0]}):function(e,t){var i=h(e,t+4),e=2*(i>>31)+1,t=i>>>23&255,i=8388607&i;return 255==t?i?NaN:1/0*e:0==t?1401298464324817e-60*e*i:e*Math.pow(2,t-150)*(8388608+i)};l.prototype.float=function(){if(this.pos+4>this.len)throw s(this,4);var e=g(this.buf,this.pos);return this.pos+=4,e};var _,y,C="undefined"!=typeof Float64Array?(_=new Float64Array(1),y=new Uint8Array(_.buffer),_[0]=-0,y[7]?function(e,t){return y[0]=e[t],y[1]=e[t+1],y[2]=e[t+2],y[3]=e[t+3],y[4]=e[t+4],y[5]=e[t+5],y[6]=e[t+6],y[7]=e[t+7],_[0]}:function(e,t){return y[0]=e[t+7],y[1]=e[t+6],y[2]=e[t+5],y[3]=e[t+4],y[4]=e[t+3],y[5]=e[t+2],y[6]=e[t+1],y[7]=e[t],_[0]}):function(e,t){var i=h(e,t+4),r=h(e,t+8),e=2*(r>>31)+1,t=r>>>20&2047,i=4294967296*(1048575&r)+i;return 2047==t?i?NaN:1/0*e:0==t?5e-324*e*i:e*Math.pow(2,t-1075)*(i+4503599627370496)};l.prototype.double=function(){if(this.pos+8>this.len)throw s(this,4);var e=C(this.buf,this.pos);return this.pos+=8,e},l.prototype.bytes=function(){var e=this.uint32(),t=this.pos,i=this.pos+e;if(i>this.len)throw s(this,e);return this.pos+=e,t===i?new this.buf.constructor(0):this._slice.call(this.buf,t,i)},l.prototype.string=function(){var e=this.bytes();return o.read(e,0,e.length)},l.prototype.skip=function(e){if("number"==typeof e){if(this.pos+e>this.len)throw s(this,e);this.pos+=e}else do{if(this.pos>=this.len)throw s(this)}while(128&this.buf[this.pos++]);return this},l.prototype.skipType=function(e){switch(e){case 0:this.skip();break;case 1:this.skip(8);break;case 2:this.skip(this.uint32());break;case 3:for(;;){if(4==(e=7&this.uint32()))break;this.skipType(e)}break;case 5:this.skip(4);break;default:throw Error("invalid wire type "+e+" at offset "+this.pos)}return this},l._configure=function(e){r=e;var t=n.Long?"toLong":"toNumber";n.merge(l.prototype,{int64:function(){return d.call(this)[t](!1)},uint64:function(){return d.call(this)[t](!0)},sint64:function(){return d.call(this).zzDecode()[t](!1)},fixed64:function(){return p.call(this)[t](!0)},sfixed64:function(){return p.call(this)[t](!1)}})}},{13:13}],9:[function(e,t,i){t.exports=n;var r=e(8);(n.prototype=Object.create(r.prototype)).constructor=n;e=e(13);function n(e){r.call(this,e)}e.Buffer&&(n.prototype._slice=e.Buffer.prototype.slice),n.prototype.string=function(){var e=this.uint32();return this.buf.utf8Slice(this.pos,this.pos=Math.min(this.pos+e,this.len))}},{13:13,8:8}],10:[function(e,t,i){i.Service=e(11)},{11:11}],11:[function(e,t,i){t.exports=r;var s=e(13);function r(e,t,i){if("function"!=typeof e)throw TypeError("rpcImpl must be a function");s.EventEmitter.call(this),this.rpcImpl=e,this.requestDelimited=Boolean(t),this.responseDelimited=Boolean(i)}((r.prototype=Object.create(s.EventEmitter.prototype)).constructor=r).prototype.rpcCall=function e(i,t,r,n,a){if(!n)throw TypeError("request must be specified");var o=this;if(!a)return s.asPromise(e,o,i,t,r,n);if(!o.rpcImpl)return setTimeout(function(){a(Error("already ended"))},0),undefined$1;try{return o.rpcImpl(i,t[o.requestDelimited?"encodeDelimited":"encode"](n).finish(),function(e,t){if(e)return o.emit("error",e,i),a(e);if(null===t)return o.end(!0),undefined$1;if(!(t instanceof r))try{t=r[o.responseDelimited?"decodeDelimited":"decode"](t)}catch(e){return o.emit("error",e,i),a(e)}return o.emit("data",t,i),a(null,t)})}catch(e){return o.emit("error",e,i),setTimeout(function(){a(e)},0),undefined$1}},r.prototype.end=function(e){return this.rpcImpl&&(e||this.rpcImpl(null,null,null),this.rpcImpl=null,this.emit("end").off()),this}},{13:13}],12:[function(e,t,i){t.exports=n;var r=e(13);function n(e,t){this.lo=e>>>0,this.hi=t>>>0}var a=n.zero=new n(0,0);a.toNumber=function(){return 0},a.zzEncode=a.zzDecode=function(){return this},a.length=function(){return 1};n.zeroHash="\0\0\0\0\0\0\0\0";n.fromNumber=function(e){if(0===e)return a;var t=e<0;t&&(e=-e);var i=e>>>0,e=(e-i)/4294967296>>>0;return t&&(e=~e>>>0,i=~i>>>0,4294967295<++i&&(i=0,4294967295<++e&&(e=0))),new n(i,e)},n.from=function(e){if("number"==typeof e)return n.fromNumber(e);if(r.isString(e)){if(!r.Long)return n.fromNumber(parseInt(e,10));e=r.Long.fromString(e)}return e.low||e.high?new n(e.low>>>0,e.high>>>0):a},n.prototype.toNumber=function(e){if(!e&&this.hi>>>31){var t=1+~this.lo>>>0,e=~this.hi>>>0;return t||(e=e+1>>>0),-(t+4294967296*e)}return this.lo+4294967296*this.hi},n.prototype.toLong=function(e){return r.Long?new r.Long(0|this.lo,0|this.hi,Boolean(e)):{low:0|this.lo,high:0|this.hi,unsigned:Boolean(e)}};var o=String.prototype.charCodeAt;n.fromHash=function(e){return"\0\0\0\0\0\0\0\0"===e?a:new n((o.call(e,0)|o.call(e,1)<<8|o.call(e,2)<<16|o.call(e,3)<<24)>>>0,(o.call(e,4)|o.call(e,5)<<8|o.call(e,6)<<16|o.call(e,7)<<24)>>>0)},n.prototype.toHash=function(){return String.fromCharCode(255&this.lo,this.lo>>>8&255,this.lo>>>16&255,this.lo>>>24,255&this.hi,this.hi>>>8&255,this.hi>>>16&255,this.hi>>>24)},n.prototype.zzEncode=function(){var e=this.hi>>31;return this.hi=((this.hi<<1|this.lo>>>31)^e)>>>0,this.lo=(this.lo<<1^e)>>>0,this},n.prototype.zzDecode=function(){var e=-(1&this.lo);return this.lo=((this.lo>>>1|this.hi<<31)^e)>>>0,this.hi=(this.hi>>>1^e)>>>0,this},n.prototype.length=function(){var e=this.lo,t=(this.lo>>>28|this.hi<<4)>>>0,i=this.hi>>>24;return 0==i?0==t?e<16384?e<128?1:2:e<2097152?3:4:t<16384?t<128?5:6:t<2097152?7:8:i<128?9:10}},{13:13}],13:[function(e,t,i){var r=i;function n(e,t,i){for(var r=Object.keys(t),n=0;n<r.length;++n)e[r[n]]!==undefined$1&&i||(e[r[n]]=t[r[n]]);return e}function a(e){function i(e,t){if(!(this instanceof i))return new i(e,t);Object.defineProperty(this,"message",{get:function(){return e}}),Error.captureStackTrace?Error.captureStackTrace(this,i):Object.defineProperty(this,"stack",{value:(new Error).stack||""}),t&&n(this,t)}return(i.prototype=Object.create(Error.prototype)).constructor=i,Object.defineProperty(i.prototype,"name",{get:function(){return e}}),i.prototype.toString=function(){return this.name+": "+this.message},i}r.asPromise=e(1),r.base64=e(2),r.EventEmitter=e(3),r.inquire=e(4),r.utf8=e(6),r.pool=e(5),r.LongBits=e(12),r.emptyArray=Object.freeze?Object.freeze([]):[],r.emptyObject=Object.freeze?Object.freeze({}):{},r.isNode=Boolean(global.process&&global.process.versions&&global.process.versions.node),r.isInteger=Number.isInteger||function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},r.isString=function(e){return"string"==typeof e||e instanceof String},r.isObject=function(e){return e&&"object"==typeof e},r.Buffer=function(){try{var e=r.inquire("buffer").Buffer;return e.prototype.utf8Write?e:null}catch(e){return null}}(),r._Buffer_from=null,r._Buffer_allocUnsafe=null,r.newBuffer=function(e){return"number"==typeof e?r.Buffer?r._Buffer_allocUnsafe(e):new r.Array(e):r.Buffer?r._Buffer_from(e):"undefined"==typeof Uint8Array?e:new Uint8Array(e)},r.Array="undefined"!=typeof Uint8Array?Uint8Array:Array,r.Long=global.dcodeIO&&global.dcodeIO.Long||r.inquire("long"),r.key2Re=/^true|false|0|1$/,r.key32Re=/^-?(?:0|[1-9][0-9]*)$/,r.key64Re=/^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/,r.longToHash=function(e){return e?r.LongBits.from(e).toHash():r.LongBits.zeroHash},r.longFromHash=function(e,t){e=r.LongBits.fromHash(e);return r.Long?r.Long.fromBits(e.lo,e.hi,t):e.toNumber(Boolean(t))},r.merge=n,r.lcFirst=function(e){return e.charAt(0).toLowerCase()+e.substring(1)},r.newError=a,r.ProtocolError=a("ProtocolError"),r.oneOfGetter=function(e){for(var i={},t=0;t<e.length;++t)i[e[t]]=1;return function(){for(var e=Object.keys(this),t=e.length-1;-1<t;--t)if(1===i[e[t]]&&this[e[t]]!==undefined$1&&null!==this[e[t]])return e[t]}},r.oneOfSetter=function(i){return function(e){for(var t=0;t<i.length;++t)i[t]!==e&&delete this[i[t]]}},r.lazyResolve=function(e,t){for(var i=0;i<t.length;++i)for(var r=Object.keys(t[i]),n=0;n<r.length;++n){for(var a=t[i][r[n]].split("."),o=e;a.length;)o=o[a.shift()];t[i][r[n]]=o}},r.toJSONOptions={longs:String,enums:String,bytes:String},r._configure=function(){var i=r.Buffer;i?(r._Buffer_from=i.from!==Uint8Array.from&&i.from||function(e,t){return new i(e,t)},r._Buffer_allocUnsafe=i.allocUnsafe||function(e){return new i(e)}):r._Buffer_from=r._Buffer_allocUnsafe=null}},{1:1,12:12,2:2,3:3,4:4,5:5,6:6}],14:[function(e,t,i){t.exports=d;var r,n=e(13),a=n.LongBits,o=n.base64,s=n.utf8;function l(e,t,i){this.fn=e,this.len=t,this.next=undefined$1,this.val=i}function c(){}function u(e){this.head=e.head,this.tail=e.tail,this.len=e.len,this.next=e.states}function d(){this.len=0,this.head=new l(c,0,0),this.tail=this.head,this.states=null}function h(e,t,i){t[i]=255&e}function p(e,t){this.len=e,this.next=undefined$1,this.val=t}function m(e,t,i){for(;e.hi;)t[i++]=127&e.lo|128,e.lo=(e.lo>>>7|e.hi<<25)>>>0,e.hi>>>=7;for(;127<e.lo;)t[i++]=127&e.lo|128,e.lo=e.lo>>>7;t[i++]=e.lo}function f(e,t,i){t[i++]=255&e,t[i++]=e>>>8&255,t[i++]=e>>>16&255,t[i]=e>>>24}d.create=n.Buffer?function(){return(d.create=function(){return new r})()}:function(){return new d},d.alloc=function(e){return new n.Array(e)},n.Array!==Array&&(d.alloc=n.pool(d.alloc,n.Array.prototype.subarray)),d.prototype.push=function(e,t,i){return this.tail=this.tail.next=new l(e,t,i),this.len+=t,this},(p.prototype=Object.create(l.prototype)).fn=function(e,t,i){for(;127<e;)t[i++]=127&e|128,e>>>=7;t[i]=e},d.prototype.uint32=function(e){return this.len+=(this.tail=this.tail.next=new p((e>>>=0)<128?1:e<16384?2:e<2097152?3:e<268435456?4:5,e)).len,this},d.prototype.int32=function(e){return e<0?this.push(m,10,a.fromNumber(e)):this.uint32(e)},d.prototype.sint32=function(e){return this.uint32((e<<1^e>>31)>>>0)},d.prototype.int64=d.prototype.uint64=function(e){e=a.from(e);return this.push(m,e.length(),e)},d.prototype.sint64=function(e){e=a.from(e).zzEncode();return this.push(m,e.length(),e)},d.prototype.bool=function(e){return this.push(h,1,e?1:0)},d.prototype.sfixed32=d.prototype.fixed32=function(e){return this.push(f,4,e>>>0)},d.prototype.sfixed64=d.prototype.fixed64=function(e){e=a.from(e);return this.push(f,4,e.lo).push(f,4,e.hi)};var g,_,y="undefined"!=typeof Float32Array?(g=new Float32Array(1),_=new Uint8Array(g.buffer),g[0]=-0,_[3]?function(e,t,i){g[0]=e,t[i++]=_[0],t[i++]=_[1],t[i++]=_[2],t[i]=_[3]}:function(e,t,i){g[0]=e,t[i++]=_[3],t[i++]=_[2],t[i++]=_[1],t[i]=_[0]}):function(e,t,i){var r=e<0?1:0;r&&(e=-e),0===e?f(0<1/e?0:2147483648,t,i):isNaN(e)?f(2147483647,t,i):f(34028234663852886e22<e?(r<<31|2139095040)>>>0:e<11754943508222875e-54?(r<<31|Math.round(e/1401298464324817e-60))>>>0:(r<<31|(r=Math.floor(Math.log(e)/Math.LN2))+127<<23|8388607&Math.round(e*Math.pow(2,-r)*8388608))>>>0,t,i)};d.prototype.float=function(e){return this.push(y,4,e)};var C,v,S="undefined"!=typeof Float64Array?(C=new Float64Array(1),v=new Uint8Array(C.buffer),C[0]=-0,v[7]?function(e,t,i){C[0]=e,t[i++]=v[0],t[i++]=v[1],t[i++]=v[2],t[i++]=v[3],t[i++]=v[4],t[i++]=v[5],t[i++]=v[6],t[i]=v[7]}:function(e,t,i){C[0]=e,t[i++]=v[7],t[i++]=v[6],t[i++]=v[5],t[i++]=v[4],t[i++]=v[3],t[i++]=v[2],t[i++]=v[1],t[i]=v[0]}):function(e,t,i){var r,n,a=e<0?1:0;a&&(e=-e),0===e?(f(0,t,i),f(0<1/e?0:2147483648,t,i+4)):isNaN(e)?(f(4294967295,t,i),f(2147483647,t,i+4)):17976931348623157e292<e?(f(0,t,i),f((a<<31|2146435072)>>>0,t,i+4)):e<22250738585072014e-324?(f((r=e/5e-324)>>>0,t,i),f((a<<31|r/4294967296)>>>0,t,i+4)):(1024===(n=Math.floor(Math.log(e)/Math.LN2))&&(n=1023),f(4503599627370496*(r=e*Math.pow(2,-n))>>>0,t,i),f((a<<31|n+1023<<20|1048576*r&1048575)>>>0,t,i+4))};d.prototype.double=function(e){return this.push(S,8,e)};var T=n.Array.prototype.set?function(e,t,i){t.set(e,i)}:function(e,t,i){for(var r=0;r<e.length;++r)t[i+r]=e[r]};d.prototype.bytes=function(e){var t,i=e.length>>>0;return i?(n.isString(e)&&(t=d.alloc(i=o.length(e)),o.decode(e,t,0),e=t),this.uint32(i).push(T,i,e)):this.push(h,1,0)},d.prototype.string=function(e){var t=s.length(e);return t?this.uint32(t).push(s.write,t,e):this.push(h,1,0)},d.prototype.fork=function(){return this.states=new u(this),this.head=this.tail=new l(c,0,0),this.len=0,this},d.prototype.reset=function(){return this.states?(this.head=this.states.head,this.tail=this.states.tail,this.len=this.states.len,this.states=this.states.next):(this.head=this.tail=new l(c,0,0),this.len=0),this},d.prototype.ldelim=function(){var e=this.head,t=this.tail,i=this.len;return this.reset().uint32(i),i&&(this.tail.next=e.next,this.tail=t,this.len+=i),this},d.prototype.finish=function(){for(var e=this.head.next,t=this.constructor.alloc(this.len),i=0;e;)e.fn(e.val,t,i),i+=e.len,e=e.next;return t},d._configure=function(e){r=e}},{13:13}],15:[function(e,t,i){t.exports=o;var r=e(14);(o.prototype=Object.create(r.prototype)).constructor=o;var n=e(13),a=n.Buffer;function o(){r.call(this)}o.alloc=function(e){return(o.alloc=n._Buffer_allocUnsafe)(e)};var s=a&&a.prototype instanceof Uint8Array&&"set"===a.prototype.set.name?function(e,t,i){t.set(e,i)}:function(e,t,i){if(e.copy)e.copy(t,i,0,e.length);else for(var r=0;r<e.length;)t[i++]=e[r++]};function l(e,t,i){e.length<40?n.utf8.write(e,t,i):t.utf8Write(e,i)}o.prototype.bytes=function(e){n.isString(e)&&(e=n._Buffer_from(e,"base64"));var t=e.length>>>0;return this.uint32(t),t&&this.push(s,t,e),this},o.prototype.string=function(e){var t=a.byteLength(e);return this.uint32(t),t&&this.push(l,t,e),this}},{13:13,14:14}]},_Jb={},aKb=[7],global.protobuf=function e(t){var i=_Jb[t];return i||$Jb[t][0].call(i=_Jb[t]={exports:{}},e,i,i.exports),i.exports}(aKb[0])}(tmp$1);var protobuf=tmp$1.protobuf;function isBitSet(e,t){return 0!=(e&t)}var childrenBitmasks=[1,2,4,8],anyChildBitmask=15,cacheFlagBitmask=16,imageBitmask=64,terrainBitmask=128;function GoogleEarthEnterpriseTileInformation(e,t,i,r,n,a){this._bits=e,this.cnodeVersion=t,this.imageryVersion=i,this.terrainVersion=r,this.imageryProvider=n,this.terrainProvider=a,this.ancestorHasTerrain=!1,this.terrainState=void 0}function stringToBuffer(e){for(var t=e.length,i=new ArrayBuffer(t),r=new Uint8Array(i),n=0;n<t;++n)r[n]=e.charCodeAt(n);return i}GoogleEarthEnterpriseTileInformation.clone=function(e,t){return defined(t)?(t._bits=e._bits,t.cnodeVersion=e.cnodeVersion,t.imageryVersion=e.imageryVersion,t.terrainVersion=e.terrainVersion,t.imageryProvider=e.imageryProvider,t.terrainProvider=e.terrainProvider):t=new GoogleEarthEnterpriseTileInformation(e._bits,e.cnodeVersion,e.imageryVersion,e.terrainVersion,e.imageryProvider,e.terrainProvider),t.ancestorHasTerrain=e.ancestorHasTerrain,t.terrainState=e.terrainState,t},GoogleEarthEnterpriseTileInformation.prototype.setParent=function(e){this.ancestorHasTerrain=e.ancestorHasTerrain||this.hasTerrain()},GoogleEarthEnterpriseTileInformation.prototype.hasSubtree=function(){return isBitSet(this._bits,cacheFlagBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasImagery=function(){return isBitSet(this._bits,imageBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasTerrain=function(){return isBitSet(this._bits,terrainBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasChildren=function(){return isBitSet(this._bits,anyChildBitmask)},GoogleEarthEnterpriseTileInformation.prototype.hasChild=function(e){return isBitSet(this._bits,childrenBitmasks[e])},GoogleEarthEnterpriseTileInformation.prototype.getChildBitmask=function(){return this._bits&anyChildBitmask};var defaultKey=stringToBuffer('Eô½\vyâjE",ÍqøIFgQ\0B%Æèa,f)\bÆ4Üjb%y\nwmiÖðk¡½NuàA[ß@V\fÙ»r|3SîOlÔq°{ÀEVZ­wUe\v3*¬l5Å0sø3>mF8J´Ýð.ÝuÚDt"úa"\f3"So¯9D\v9Ù9L¹¿«\\P_"uxéqh;ÁÄð<VqH\'UfYNeu£aF}a?A\0×´4MÎF°Õ¸\'{Ü+»Mg0ÈÑö\\Pú[/Fn5/\'C.ë\n\f^¥se4ål.jC\'c#U©?q{gC}:¯ÍâTUýKÆâ/(íË\\Æ-f§;/*"N°k.Ý\r}}GºC²²+>Mª>}æÎIÆæx\fa1-¤O¥~q ì\r1èN\v\0nPh}=\b\r¦n£h$[kó#ó¶s³\r\v@ÀØQ]ú".jßI\0¹ wUÆïj¿{GLîÜÜF©­S+S4ÿYä8è1N¹XFkË-#p\x005"Ï1²&/çÃu-6,rt°#G·ÓÑ&7râ\0DÏÚ3-Þ`i#i*|ÍKQ\rT9w.)ê¦P¢joP\\>TûïP[\vEm(w7ÛJfJo åpâ¹q~\fmI-zþrÇòY0»]såÉ êxì ðB|G`°½&·q¶ÇÑ3=Ó«îcÈ+S D\\qÆÌD2O<ÊÀ)=RÓaX©}e´ÜÏ\rô=ñ\b©BÚ#\tØ¿^PIøMÀËGLO÷{+ØÅ1;µoÜl\rÑÛ?âéÚ_ÔâFaZÞUÏ¤\0¾ýÎgñJiæ HØ]~®q N®ÀV©<rçvì)IÖ]-ãÛ6©;fjÕ¶=P^R¹KÇsWxÉô.YoÐKW>\'\'Ç`Û;íSD>?mw¢\në?R¨ÆU^1I7ôÅ&-©¿\'TÚÃj å*x°Öprªh½÷_H±~ÀXL?fù>áeÀp§Ï8i¯ðVldI\'­xtOÂÞV9\0Úw\vË-û5Oõ\bQ`Á\nZGM&30xÚÀFGâ[y`In7gS\n>éìF9²ñ4\rÆSuná\fYÙÞ){II¥wy¾IV.6ç\v:»Ob{ÒM1/½8{¨O!áìFpv})"x\nÝ\\ÚÞQÏðüYRe|3ßóHÚ»*uÛ`²Ôüíì5¨ÿ(1-ÈÜF|["');function GoogleEarthEnterpriseMetadata(e){var t=e;"string"==typeof t||t instanceof Resource||(t=e.url);t=Resource.createIfNeeded(t);t.appendForwardSlash(),this._resource=t,this.imageryPresent=!0,this.protoImagery=void 0,this.terrainPresent=!0,this.negativeAltitudeExponentBias=32,this.negativeAltitudeThreshold=CesiumMath.EPSILON12,this.providers={},this.key=void 0,this._quadPacketVersion=1,this._tileInfo={},this._subtreePromises={};var i=this;this._readyPromise=requestDbRoot(this).then(function(){return i.getQuadTreePacket("",i._quadPacketVersion)}).then(function(){return!0}).otherwise(function(e){var t="An error occurred while accessing "+getMetadataResource(i,"",1).url+".";return when.reject(new RuntimeError(t))})}Object.defineProperties(GoogleEarthEnterpriseMetadata.prototype,{url:{get:function(){return this._resource.url}},proxy:{get:function(){return this._resource.proxy}},resource:{get:function(){return this._resource}},readyPromise:{get:function(){return this._readyPromise}}}),GoogleEarthEnterpriseMetadata.tileXYToQuadKey=function(e,t,i){for(var r="",n=i;0<=n;--n){var a=1<<n,o=0;isBitSet(t,a)?isBitSet(e,a)&&(o|=1):(o|=2,isBitSet(e,a)||(o|=1)),r+=o}return r},GoogleEarthEnterpriseMetadata.quadKeyToTileXY=function(e){for(var t=0,i=0,r=e.length-1,n=r;0<=n;--n){var a=1<<n,o=+e[r-n];isBitSet(o,2)?isBitSet(o,1)||(t|=a):(i|=a,isBitSet(o,1)&&(t|=a))}return{x:t,y:i,level:r}},GoogleEarthEnterpriseMetadata.prototype.isValid=function(e){var t=this.getTileInformationFromQuadKey(e);if(defined(t))return null!==t;for(var i,r=!0,n=e;1<n.length;){if(i=n.substring(n.length-1),n=n.substring(0,n.length-1),defined(t=this.getTileInformationFromQuadKey(n))){t.hasSubtree()||t.hasChild(parseInt(i))||(r=!1);break}if(null===t){r=!1;break}}return r};var taskProcessor$1=new TaskProcessor("decodeGoogleEarthEnterprisePacket",Number.POSITIVE_INFINITY),dbrootParser,dbrootParserPromise;function populateSubtree(e,t,i){var r,n=e._tileInfo,a=t,o=n[a];if(defined(o)&&(!o.hasSubtree()||o.hasChildren()))return o;for(;void 0===o&&1<a.length;)o=n[a=a.substring(0,a.length-1)];var s=e._subtreePromises,l=s[a];return defined(l)?l.then(function(){return r=new Request({throttle:i.throttle,throttleByServer:i.throttleByServer,type:i.type,priorityFunction:i.priorityFunction}),populateSubtree(e,t,r)}):defined(o)&&o.hasSubtree()?defined(l=e.getQuadTreePacket(a,o.cnodeVersion,i))?(s[a]=l).then(function(){return r=new Request({throttle:i.throttle,throttleByServer:i.throttleByServer,type:i.type,priorityFunction:i.priorityFunction}),populateSubtree(e,t,r)}).always(function(){delete s[a]}):void 0:when.reject(new RuntimeError("Couldn't load metadata for tile "+t))}function getMetadataResource(e,t,i,r){return e._resource.getDerivedResource({url:"flatfile?q2-0"+t+"-q."+i.toString(),request:r})}function requestDbRoot(l){var e,t,i=l._resource.getDerivedResource({url:"dbRoot.v5",queryParameters:{output:"proto"}});return defined(dbrootParserPromise)||(e=buildModuleUrl("ThirdParty/google-earth-dbroot-parser.js"),t=window.cesiumGoogleEarthDbRootParser,dbrootParserPromise=loadAndExecuteScript(e).then(function(){dbrootParser=window.cesiumGoogleEarthDbRootParser(protobuf),defined(t)?window.cesiumGoogleEarthDbRootParser=t:delete window.cesiumGoogleEarthDbRootParser})),dbrootParserPromise.then(function(){return i.fetchArrayBuffer()}).then(function(e){var t=dbrootParser.EncryptedDbRootProto.decode(new Uint8Array(e)),i=t.encryptionData,r=i.byteOffset,n=r+i.byteLength,e=l.key=i.buffer.slice(r,n),n=(r=(i=t.dbrootData).byteOffset)+i.byteLength,n=i.buffer.slice(r,n);return taskProcessor$1.scheduleTask({buffer:n,type:"DbRoot",key:e},[n])}).then(function(e){var t=dbrootParser.DbRootProto.decode(new Uint8Array(e.buffer));l.imageryPresent=defaultValue(t.imageryPresent,l.imageryPresent),l.protoImagery=t.protoImagery,l.terrainPresent=defaultValue(t.terrainPresent,l.terrainPresent),defined(t.endSnippet)&&defined(t.endSnippet.model)&&(e=t.endSnippet.model,l.negativeAltitudeExponentBias=defaultValue(e.negativeAltitudeExponentBias,l.negativeAltitudeExponentBias),l.negativeAltitudeThreshold=defaultValue(e.compressedNegativeAltitudeThreshold,l.negativeAltitudeThreshold)),defined(t.databaseVersion)&&(l._quadPacketVersion=defaultValue(t.databaseVersion.quadtreeVersion,l._quadPacketVersion));for(var i=l.providers,r=defaultValue(t.providerInfo,[]),n=r.length,a=0;a<n;++a){var o=r[a],s=o.copyrightString;defined(s)&&(i[o.providerId]=new Credit(s.value))}}).otherwise(function(){console.log("Failed to retrieve "+i.url+". Using defaults."),l.key=defaultKey})}function GoogleEarthEnterpriseTerrainData(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._buffer=e.buffer,this._credits=e.credits,this._negativeAltitudeExponentBias=e.negativeAltitudeExponentBias,this._negativeElevationThreshold=e.negativeElevationThreshold;var t=defaultValue(e.childTileMask,15),i=3&t;i|=4&t?8:0,i|=8&t?4:0,this._childTileMask=i,this._createdByUpsampling=defaultValue(e.createdByUpsampling,!1),this._skirtHeight=void 0,this._bufferType=this._buffer.constructor,this._mesh=void 0,this._minimumHeight=void 0,this._maximumHeight=void 0}GoogleEarthEnterpriseMetadata.prototype.getQuadTreePacket=function(u,e,t){e=defaultValue(e,1);t=getMetadataResource(this,u=defaultValue(u,""),e,t).fetchArrayBuffer();if(defined(t)){var d=this._tileInfo,i=this.key;return t.then(function(e){return taskProcessor$1.scheduleTask({buffer:e,quadKey:u,type:"Metadata",key:i},[e]).then(function(e){var t,i,r=-1;""!==u&&(r=u.length+1,t=e[u],(i=d[u])._bits|=t._bits,delete e[u]);var n=Object.keys(e);n.sort(function(e,t){return e.length-t.length});for(var a=n.length,o=0;o<a;++o){var s,l,c=n[o];null!==e[c]?(s=GoogleEarthEnterpriseTileInformation.clone(e[c]),(l=c.length)===r?s.setParent(i):1<l&&(l=d[c.substring(0,c.length-1)],s.setParent(l)),d[c]=s):d[c]=null}})})}},GoogleEarthEnterpriseMetadata.prototype.populateSubtree=function(e,t,i,r){return populateSubtree(this,GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i),r)},GoogleEarthEnterpriseMetadata.prototype.getTileInformation=function(e,t,i){i=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i);return this._tileInfo[i]},GoogleEarthEnterpriseMetadata.prototype.getTileInformationFromQuadKey=function(e){return this._tileInfo[e]},Object.defineProperties(GoogleEarthEnterpriseTerrainData.prototype,{credits:{get:function(){return this._credits}},waterMask:{get:function(){}}});var taskProcessor$2=new TaskProcessor("createVerticesFromGoogleEarthEnterpriseBuffer"),nativeRectangleScratch=new Rectangle,rectangleScratch$1=new Rectangle;GoogleEarthEnterpriseTerrainData.prototype.createMesh=function(e,t,i,r,n){var a=e.ellipsoid;e.tileXYToNativeRectangle(t,i,r,nativeRectangleScratch),e.tileXYToRectangle(t,i,r,rectangleScratch$1),n=defaultValue(n,1);var o=a.cartographicToCartesian(Rectangle.center(rectangleScratch$1)),r=40075.16/(1<<r);this._skirtHeight=Math.min(8*r,1e3);a=taskProcessor$2.scheduleTask({buffer:this._buffer,nativeRectangle:nativeRectangleScratch,rectangle:rectangleScratch$1,relativeToCenter:o,ellipsoid:a,skirtHeight:this._skirtHeight,exaggeration:n,includeWebMercatorT:!0,negativeAltitudeExponentBias:this._negativeAltitudeExponentBias,negativeElevationThreshold:this._negativeElevationThreshold});if(defined(a)){var s=this;return a.then(function(e){return s._mesh=new TerrainMesh(o,new Float32Array(e.vertices),new Uint16Array(e.indices),e.indexCountWithoutSkirts,e.vertexCountWithoutSkirts,e.minimumHeight,e.maximumHeight,BoundingSphere.clone(e.boundingSphere3D),Cartesian3.clone(e.occludeePointInScaledSpace),e.numberOfAttributes,OrientedBoundingBox.clone(e.orientedBoundingBox),TerrainEncoding.clone(e.encoding),n,e.westIndicesSouthToNorth,e.southIndicesEastToWest,e.eastIndicesNorthToSouth,e.northIndicesWestToEast),s._minimumHeight=e.minimumHeight,s._maximumHeight=e.maximumHeight,s._buffer=void 0,s._mesh})}},GoogleEarthEnterpriseTerrainData.prototype.interpolateHeight=function(e,t,i){t=CesiumMath.clamp((t-e.west)/e.width,0,1),i=CesiumMath.clamp((i-e.south)/e.height,0,1);return defined(this._mesh)?interpolateMeshHeight$2(this,t,i):interpolateHeight$2(this,t,i,e)};var upsampleTaskProcessor$1=new TaskProcessor("upsampleQuantizedTerrainMesh");GoogleEarthEnterpriseTerrainData.prototype.upsample=function(e,t,i,r,n,a,o){var s=this._mesh;if(defined(this._mesh)){var l=2*t!==n,t=2*i===a,i=e.ellipsoid,o=e.tileXYToRectangle(n,a,o),s=upsampleTaskProcessor$1.scheduleTask({vertices:s.vertices,indices:s.indices,indexCountWithoutSkirts:s.indexCountWithoutSkirts,vertexCountWithoutSkirts:s.vertexCountWithoutSkirts,encoding:s.encoding,minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,isEastChild:l,isNorthChild:t,childRectangle:o,ellipsoid:i,exaggeration:s.exaggeration});if(defined(s)){var c=this;return s.then(function(e){var t=new Uint16Array(e.vertices),i=IndexDatatype$1.createTypedArray(t.length/3,e.indices),r=c._skirtHeight;return new QuantizedMeshTerrainData({quantizedVertices:t,indices:i,minimumHeight:e.minimumHeight,maximumHeight:e.maximumHeight,boundingSphere:BoundingSphere.clone(e.boundingSphere),orientedBoundingBox:OrientedBoundingBox.clone(e.orientedBoundingBox),horizonOcclusionPoint:Cartesian3.clone(e.horizonOcclusionPoint),westIndices:e.westIndices,southIndices:e.southIndices,eastIndices:e.eastIndices,northIndices:e.northIndices,westSkirtHeight:r,southSkirtHeight:r,eastSkirtHeight:r,northSkirtHeight:r,childTileMask:0,createdByUpsampling:!0,credits:c._credits})})}}},GoogleEarthEnterpriseTerrainData.prototype.isChildAvailable=function(e,t,i,r){var n=2;return i!==2*e&&++n,r!==2*t&&(n-=2),0!=(this._childTileMask&1<<n)},GoogleEarthEnterpriseTerrainData.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling};var texCoordScratch0$1=new Cartesian2,texCoordScratch1$1=new Cartesian2,texCoordScratch2$1=new Cartesian2,barycentricCoordinateScratch$1=new Cartesian3;function interpolateMeshHeight$2(e,t,i){for(var e=e._mesh,r=e.vertices,n=e.encoding,a=e.indices,o=0,s=a.length;o<s;o+=3){var l=a[o],c=a[o+1],u=a[o+2],d=n.decodeTextureCoordinates(r,l,texCoordScratch0$1),h=n.decodeTextureCoordinates(r,c,texCoordScratch1$1),p=n.decodeTextureCoordinates(r,u,texCoordScratch2$1),p=Intersections2D.computeBarycentricCoordinates(t,i,d.x,d.y,h.x,h.y,p.x,p.y,barycentricCoordinateScratch$1);if(-1e-15<=p.x&&-1e-15<=p.y&&-1e-15<=p.z){l=n.decodeHeight(r,l),c=n.decodeHeight(r,c),u=n.decodeHeight(r,u);return p.x*l+p.y*c+p.z*u}}}var sizeOfUint16=Uint16Array.BYTES_PER_ELEMENT,sizeOfUint32=Uint32Array.BYTES_PER_ELEMENT,sizeOfInt32=Int32Array.BYTES_PER_ELEMENT,sizeOfFloat=Float32Array.BYTES_PER_ELEMENT,sizeOfDouble=Float64Array.BYTES_PER_ELEMENT;function interpolateHeight$2(e,t,i,r){var n=e._buffer,a=0,o=0,s=0;.5<i?(.5<t?(a=2,o=.5):a=3,s=.5):.5<t&&(a=1,o=.5);for(var l=new DataView(n),c=0,u=0;u<a;++u)c+=l.getUint32(c,!0),c+=sizeOfUint32;c+=sizeOfUint32,c+=2*sizeOfDouble;e=CesiumMath.toRadians(180*l.getFloat64(c,!0));c+=sizeOfDouble;n=CesiumMath.toRadians(180*l.getFloat64(c,!0));c+=sizeOfDouble;var d=r.width/e/2,h=r.height/n/2,p=l.getInt32(c,!0);c+=sizeOfInt32;var m=3*l.getInt32(c,!0);c+=sizeOfInt32,c+=sizeOfInt32;for(var f=new Array(p),g=new Array(p),_=new Array(p),y=0;y<p;++y)f[y]=o+l.getUint8(c++)*d,g[y]=s+l.getUint8(c++)*h,_[y]=6371010*l.getFloat32(c,!0),c+=sizeOfFloat;var C=new Array(m);for(y=0;y<m;++y)C[y]=l.getUint16(c,!0),c+=sizeOfUint16;for(y=0;y<m;y+=3){var v=C[y],S=C[y+1],T=C[y+2],x=f[v],b=f[S],E=f[T],P=g[v],A=g[S],w=g[T],w=Intersections2D.computeBarycentricCoordinates(t,i,x,P,b,A,E,w,barycentricCoordinateScratch$1);if(-1e-15<=w.x&&-1e-15<=w.y&&-1e-15<=w.z)return w.x*_[v]+w.y*_[S]+w.z*_[T]}}var TerrainState={UNKNOWN:0,NONE:1,SELF:2,PARENT:3},julianDateScratch$1=new JulianDate;function TerrainCache(){this._terrainCache={},this._lastTidy=JulianDate.now()}function GoogleEarthEnterpriseTerrainProvider(e){var t;e=defaultValue(e,defaultValue.EMPTY_OBJECT),t=defined(e.metadata)?e.metadata:new GoogleEarthEnterpriseMetadata(Resource.createIfNeeded(e.url)),this._metadata=t,this._tilingScheme=new GeographicTilingScheme({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:2,rectangle:new Rectangle(-CesiumMath.PI,-CesiumMath.PI,CesiumMath.PI,CesiumMath.PI),ellipsoid:e.ellipsoid});e=e.credit;"string"==typeof e&&(e=new Credit(e)),this._credit=e,this._levelZeroMaximumGeometricError=40075.16,this._terrainCache=new TerrainCache,this._terrainPromises={},this._terrainRequests={},this._errorEvent=new Event,this._ready=!1;var i,r=this;this._readyPromise=t.readyPromise.then(function(e){if(t.terrainPresent)return TileProviderError.handleSuccess(i),r._ready=e;e=new RuntimeError("The server "+t.url+" doesn't have terrain");return i=TileProviderError.handleError(i,r,r._errorEvent,e.message,void 0,void 0,void 0,e),when.reject(e)}).otherwise(function(e){return i=TileProviderError.handleError(i,r,r._errorEvent,e.message,void 0,void 0,void 0,e),when.reject(e)})}TerrainCache.prototype.add=function(e,t){this._terrainCache[e]={buffer:t,timestamp:JulianDate.now()}},TerrainCache.prototype.get=function(e){var t=this._terrainCache[e];if(defined(t))return delete this._terrainCache[e],t.buffer},TerrainCache.prototype.tidy=function(){if(JulianDate.now(julianDateScratch$1),10<JulianDate.secondsDifference(julianDateScratch$1,this._lastTidy)){for(var e=this._terrainCache,t=Object.keys(e),i=t.length,r=0;r<i;++r){var n=t[r],a=e[n];10<JulianDate.secondsDifference(julianDateScratch$1,a.timestamp)&&delete e[n]}JulianDate.clone(julianDateScratch$1,this._lastTidy)}},Object.defineProperties(GoogleEarthEnterpriseTerrainProvider.prototype,{url:{get:function(){return this._metadata.url}},proxy:{get:function(){return this._metadata.proxy}},tilingScheme:{get:function(){return this._tilingScheme}},errorEvent:{get:function(){return this._errorEvent}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}},credit:{get:function(){return this._credit}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}});var taskProcessor$3=new TaskProcessor("decodeGoogleEarthEnterprisePacket",Number.POSITIVE_INFINITY);function computeChildMask(e,t,i){var r=t.getChildBitmask();if(t.terrainState===TerrainState.PARENT)for(var n=r=0;n<4;++n){var a=i.getTileInformationFromQuadKey(e+n.toString());defined(a)&&a.hasTerrain()&&(r|=1<<n)}return r}function buildTerrainResource(e,t,i,r){return i=defined(i)&&0<i?i:1,e._metadata.resource.getDerivedResource({url:"flatfile?f1c-0"+t+"-t."+i.toString(),request:r})}GoogleEarthEnterpriseTerrainProvider.prototype.requestTileGeometry=function(e,t,i,r){var n=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i),s=this._terrainCache,l=this._metadata,a=l.getTileInformationFromQuadKey(n);if(!defined(a))return when.reject(new RuntimeError("Terrain tile doesn't exist"));e=a.terrainState;defined(e)||(e=a.terrainState=TerrainState.UNKNOWN);var o,t=s.get(n);if(defined(t)){i=l.providers[a.terrainProvider];return when.resolve(new GoogleEarthEnterpriseTerrainData({buffer:t,childTileMask:computeChildMask(n,a,l),credits:defined(i)?[i]:void 0,negativeAltitudeExponentBias:l.negativeAltitudeExponentBias,negativeElevationThreshold:l.negativeAltitudeThreshold}))}if(s.tidy(),!a.ancestorHasTerrain)return when.resolve(new HeightmapTerrainData({buffer:new Uint8Array(256),width:16,height:16}));if(e===TerrainState.NONE)return when.reject(new RuntimeError("Terrain tile doesn't exist"));var c=n,u=-1;switch(e){case TerrainState.SELF:u=a.terrainVersion;break;case TerrainState.PARENT:c=c.substring(0,c.length-1),u=(o=l.getTileInformationFromQuadKey(c)).terrainVersion;break;case TerrainState.UNKNOWN:a.hasTerrain()?u=a.terrainVersion:(c=c.substring(0,c.length-1),defined(o=l.getTileInformationFromQuadKey(c))&&o.hasTerrain()&&(u=o.terrainVersion))}if(u<0)return when.reject(new RuntimeError("Terrain tile doesn't exist"));var d,h,p=this._terrainPromises,m=this._terrainRequests;if(defined(p[c]))d=p[c],h=m[c];else{e=buildTerrainResource(this,c,u,h=r).fetchArrayBuffer();if(!defined(e))return;d=e.then(function(e){return defined(e)?taskProcessor$3.scheduleTask({buffer:e,type:"Terrain",key:l.key},[e]).then(function(e){var t=l.getTileInformationFromQuadKey(c);t.terrainState=TerrainState.SELF,s.add(c,e[0]);for(var i=t.terrainProvider,r=e.length-1,n=0;n<r;++n){var a=c+n.toString(),o=l.getTileInformationFromQuadKey(a);defined(o)&&(s.add(a,e[n+1]),o.terrainState=TerrainState.PARENT,0===o.terrainProvider&&(o.terrainProvider=i))}}):when.reject(new RuntimeError("Failed to load terrain."))}),p[c]=d,m[c]=h,d=d.always(function(){delete p[c],delete m[c]})}return d.then(function(){var e=s.get(n);if(defined(e)){var t=l.providers[a.terrainProvider];return new GoogleEarthEnterpriseTerrainData({buffer:e,childTileMask:computeChildMask(n,a,l),credits:defined(t)?[t]:void 0,negativeAltitudeExponentBias:l.negativeAltitudeExponentBias,negativeElevationThreshold:l.negativeAltitudeThreshold})}return when.reject(new RuntimeError("Failed to load terrain."))}).otherwise(function(e){return h.state===RequestState$1.CANCELLED?r.state=h.state:a.terrainState=TerrainState.NONE,when.reject(e)})},GoogleEarthEnterpriseTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},GoogleEarthEnterpriseTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){var r=this._metadata,n=GoogleEarthEnterpriseMetadata.tileXYToQuadKey(e,t,i),a=r.getTileInformation(e,t,i);if(null===a)return!1;if(defined(a)){if(!a.ancestorHasTerrain)return!0;var o=a.terrainState;if(o===TerrainState.NONE)return!1;if(!(defined(o)&&o!==TerrainState.UNKNOWN||(a.terrainState=TerrainState.UNKNOWN,a.hasTerrain()))){n=n.substring(0,n.length-1);a=r.getTileInformationFromQuadKey(n);if(!defined(a)||!a.hasTerrain())return!1}return!0}return r.isValid(n)&&(n=new Request({throttle:!1,throttleByServer:!0,type:RequestType$1.TERRAIN}),r.populateSubtree(e,t,i,n)),!1},GoogleEarthEnterpriseTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){};var PROJECTIONS=[GeographicProjection,WebMercatorProjection],PROJECTION_COUNT=PROJECTIONS.length,MITER_BREAK_SMALL=Math.cos(CesiumMath.toRadians(30)),MITER_BREAK_LARGE=Math.cos(CesiumMath.toRadians(150)),WALL_INITIAL_MIN_HEIGHT=0,WALL_INITIAL_MAX_HEIGHT=1e3;function GroundPolylineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions;this.width=defaultValue(e.width,1),this._positions=t,this.granularity=defaultValue(e.granularity,9999),this.loop=defaultValue(e.loop,!1),this.arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._ellipsoid=Ellipsoid.WGS84,this._projectionIndex=0,this._workerName="createGroundPolylineGeometry",this._scene3DOnly=!1}Object.defineProperties(GroundPolylineGeometry.prototype,{packedLength:{get:function(){return 1+3*this._positions.length+1+1+1+Ellipsoid.packedLength+1+1}}}),GroundPolylineGeometry.setProjectionAndEllipsoid=function(e,t){for(var i=0,r=0;r<PROJECTION_COUNT;r++)if(t instanceof PROJECTIONS[r]){i=r;break}e._projectionIndex=i,e._ellipsoid=t.ellipsoid};var cart3Scratch1=new Cartesian3,cart3Scratch2=new Cartesian3,cart3Scratch3=new Cartesian3;function computeRightNormal(e,t,i,r,n){var a=getPosition(r,e,0,cart3Scratch1),i=getPosition(r,e,i,cart3Scratch2),t=getPosition(r,t,0,cart3Scratch3),i=direction(i,a,cart3Scratch2),a=direction(t,a,cart3Scratch3);return Cartesian3.cross(a,i,n),Cartesian3.normalize(n,n)}var interpolatedCartographicScratch=new Cartographic,interpolatedBottomScratch=new Cartesian3,interpolatedTopScratch=new Cartesian3,interpolatedNormalScratch=new Cartesian3;function interpolateSegment(e,t,i,r,n,a,o,s,l,c,u){if(0!==n){var d;a===ArcType$1.GEODESIC?d=new EllipsoidGeodesic(e,t,o):a===ArcType$1.RHUMB&&(d=new EllipsoidRhumbLine(e,t,o));a=d.surfaceDistance;if(!(a<n))for(var h=computeRightNormal(e,t,r,o,interpolatedNormalScratch),n=Math.ceil(a/n),p=a/n,m=p,f=n-1,g=s.length,_=0;_<f;_++){var y=d.interpolateUsingSurfaceDistance(m,interpolatedCartographicScratch),C=getPosition(o,y,i,interpolatedBottomScratch),v=getPosition(o,y,r,interpolatedTopScratch);Cartesian3.pack(h,s,g),Cartesian3.pack(C,l,g),Cartesian3.pack(v,c,g),u.push(y.latitude),u.push(y.longitude),g+=3,m+=p}}}var heightlessCartographicScratch=new Cartographic;function getPosition(e,t,i,r){return Cartographic.clone(t,heightlessCartographicScratch),heightlessCartographicScratch.height=i,Cartographic.toCartesian(heightlessCartographicScratch,e,r)}function direction(e,t,i){return Cartesian3.subtract(e,t,i),Cartesian3.normalize(i,i),i}function tangentDirection(e,t,i,r){return r=direction(e,t,r),r=Cartesian3.cross(r,i,r),r=Cartesian3.normalize(r,r),r=Cartesian3.cross(i,r,r)}GroundPolylineGeometry.pack=function(e,t,i){var r=defaultValue(i,0),n=e._positions,a=n.length;t[r++]=a;for(var o=0;o<a;++o){var s=n[o];Cartesian3.pack(s,t,r),r+=3}return t[r++]=e.granularity,t[r++]=e.loop?1:0,t[r++]=e.arcType,Ellipsoid.pack(e._ellipsoid,t,r),r+=Ellipsoid.packedLength,t[r++]=e._projectionIndex,t[r++]=e._scene3DOnly?1:0,t},GroundPolylineGeometry.unpack=function(e,t,i){for(var r=defaultValue(t,0),n=e[r++],a=new Array(n),o=0;o<n;o++)a[o]=Cartesian3.unpack(e,r),r+=3;var s=e[r++],l=1===e[r++],c=e[r++],u=Ellipsoid.unpack(e,r);r+=Ellipsoid.packedLength;var d=e[r++],t=1===e[r++];return defined(i)||(i=new GroundPolylineGeometry({positions:a})),i._positions=a,i.granularity=s,i.loop=l,i.arcType=c,i._ellipsoid=u,i._projectionIndex=d,i._scene3DOnly=t,i};var toPreviousScratch=new Cartesian3,toNextScratch=new Cartesian3,forwardScratch=new Cartesian3,vertexUpScratch=new Cartesian3,cosine90=0,cosine180=-1;function computeVertexMiterNormal(e,t,i,r,n){i=direction(i,t,vertexUpScratch),e=tangentDirection(e,t,i,toPreviousScratch),t=tangentDirection(r,t,i,toNextScratch);if(CesiumMath.equalsEpsilon(Cartesian3.dot(e,t),cosine180,CesiumMath.EPSILON5))return n=Cartesian3.cross(i,e,n),n=Cartesian3.normalize(n,n);n=Cartesian3.add(t,e,n),n=Cartesian3.normalize(n,n);i=Cartesian3.cross(i,n,forwardScratch);return Cartesian3.dot(t,i)<cosine90&&(n=Cartesian3.negate(n,n)),n}var XZ_PLANE=Plane.fromPointNormal(Cartesian3.ZERO,Cartesian3.UNIT_Y),previousBottomScratch=new Cartesian3,vertexBottomScratch=new Cartesian3,vertexTopScratch=new Cartesian3,nextBottomScratch=new Cartesian3,vertexNormalScratch=new Cartesian3,intersectionScratch=new Cartesian3,cartographicScratch0=new Cartographic,cartographicScratch1=new Cartographic,cartographicIntersectionScratch=new Cartographic;GroundPolylineGeometry.createGeometry=function(e){var t,i,r,n,a,o=!e._scene3DOnly,s=e.loop,l=e._ellipsoid,c=e.granularity,u=e.arcType,d=new PROJECTIONS[e._projectionIndex](l),h=WALL_INITIAL_MIN_HEIGHT,p=WALL_INITIAL_MAX_HEIGHT,m=e._positions,f=m.length;2===f&&(s=!1);for(var g,_,y,C=new EllipsoidRhumbLine(void 0,void 0,l),v=[m[0]],S=0;S<f-1;S++)i=m[S],r=m[S+1],!defined(g=IntersectionTests.lineSegmentPlane(i,r,XZ_PLANE,intersectionScratch))||Cartesian3.equalsEpsilon(g,i,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(g,r,CesiumMath.EPSILON7)||(e.arcType===ArcType$1.GEODESIC?v.push(Cartesian3.clone(g)):e.arcType===ArcType$1.RHUMB&&(y=l.cartesianToCartographic(g,cartographicScratch0).longitude,n=l.cartesianToCartographic(i,cartographicScratch0),a=l.cartesianToCartographic(r,cartographicScratch1),C.setEndPoints(n,a),_=C.findIntersectionWithLongitude(y,cartographicIntersectionScratch),!defined(g=l.cartographicToCartesian(_,intersectionScratch))||Cartesian3.equalsEpsilon(g,i,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(g,r,CesiumMath.EPSILON7)||v.push(Cartesian3.clone(g)))),v.push(r);s&&(i=m[f-1],r=m[0],!defined(g=IntersectionTests.lineSegmentPlane(i,r,XZ_PLANE,intersectionScratch))||Cartesian3.equalsEpsilon(g,i,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(g,r,CesiumMath.EPSILON7)||(e.arcType===ArcType$1.GEODESIC?v.push(Cartesian3.clone(g)):e.arcType===ArcType$1.RHUMB&&(y=l.cartesianToCartographic(g,cartographicScratch0).longitude,n=l.cartesianToCartographic(i,cartographicScratch0),a=l.cartesianToCartographic(r,cartographicScratch1),C.setEndPoints(n,a),_=C.findIntersectionWithLongitude(y,cartographicIntersectionScratch),!defined(g=l.cartographicToCartesian(_,intersectionScratch))||Cartesian3.equalsEpsilon(g,i,CesiumMath.EPSILON7)||Cartesian3.equalsEpsilon(g,r,CesiumMath.EPSILON7)||v.push(Cartesian3.clone(g)))));var T=v.length,x=new Array(T);for(S=0;S<T;S++){var b=Cartographic.fromCartesian(v[S],l);b.height=0,x[S]=b}if(!((T=(x=arrayRemoveDuplicates(x,Cartographic.equalsEpsilon)).length)<2)){var E=[],P=[],A=[],w=[],D=previousBottomScratch,M=vertexBottomScratch,I=vertexTopScratch,R=nextBottomScratch,O=vertexNormalScratch,L=x[0],F=x[1];for(D=getPosition(l,x[T-1],h,D),R=getPosition(l,F,h,R),M=getPosition(l,L,h,M),I=getPosition(l,L,p,I),O=s?computeVertexMiterNormal(D,M,I,R,O):computeRightNormal(L,F,p,l,O),Cartesian3.pack(O,P,0),Cartesian3.pack(M,A,0),Cartesian3.pack(I,w,0),E.push(L.latitude),E.push(L.longitude),interpolateSegment(L,F,h,p,c,u,l,P,A,w,E),S=1;S<T-1;++S){D=Cartesian3.clone(M,D),M=Cartesian3.clone(R,M);var N=x[S];getPosition(l,N,p,I),getPosition(l,x[S+1],h,R),computeVertexMiterNormal(D,M,I,R,O),t=P.length,Cartesian3.pack(O,P,t),Cartesian3.pack(M,A,t),Cartesian3.pack(I,w,t),E.push(N.latitude),E.push(N.longitude),interpolateSegment(x[S],x[S+1],h,p,c,u,l,P,A,w,E)}var B=x[T-1],V=x[T-2],M=getPosition(l,B,h,M),I=getPosition(l,B,p,I);if(O=s?(F=x[0],computeVertexMiterNormal(D=getPosition(l,V,h,D),M,I,R=getPosition(l,F,h,R),O)):computeRightNormal(V,B,p,l,O),t=P.length,Cartesian3.pack(O,P,t),Cartesian3.pack(M,A,t),Cartesian3.pack(I,w,t),E.push(B.latitude),E.push(B.longitude),s){for(interpolateSegment(B,L,h,p,c,u,l,P,A,w,E),t=P.length,S=0;S<3;++S)P[t+S]=P[S],A[t+S]=A[S],w[t+S]=w[S];E.push(L.latitude),E.push(L.longitude)}return generateGeometryAttributes(s,d,A,w,P,E,o)}};var lineDirectionScratch=new Cartesian3,matrix3Scratch=new Matrix3,quaternionScratch$2=new Quaternion;function breakMiter(e,t,i,r){t=direction(i,t,lineDirectionScratch),t=Cartesian3.dot(t,e);if(MITER_BREAK_SMALL<t||t<MITER_BREAK_LARGE){i=direction(r,i,vertexUpScratch),t=t<MITER_BREAK_LARGE?CesiumMath.PI_OVER_TWO:-CesiumMath.PI_OVER_TWO,t=Quaternion.fromAxisAngle(i,t,quaternionScratch$2),t=Matrix3.fromQuaternion(t,matrix3Scratch);return Matrix3.multiplyByVector(t,e,e),!0}return!1}var endPosCartographicScratch=new Cartographic,normalStartpointScratch=new Cartesian3,normalEndpointScratch=new Cartesian3;function projectNormal(e,t,i,r,n){var a=Cartographic.toCartesian(t,e._ellipsoid,normalStartpointScratch),o=Cartesian3.add(a,i,normalEndpointScratch),s=!1,l=e._ellipsoid,c=l.cartesianToCartographic(o,endPosCartographicScratch);Math.abs(t.longitude-c.longitude)>CesiumMath.PI_OVER_TWO&&(s=!0,o=Cartesian3.subtract(a,i,normalEndpointScratch),c=l.cartesianToCartographic(o,endPosCartographicScratch)),c.height=0;c=e.project(c,n);return(n=Cartesian3.subtract(c,r,n)).z=0,n=Cartesian3.normalize(n,n),s&&Cartesian3.negate(n,n),n}var adjustHeightNormalScratch=new Cartesian3,adjustHeightOffsetScratch=new Cartesian3;function adjustHeights(e,t,i,r,n,a){var o=Cartesian3.subtract(t,e,adjustHeightNormalScratch);Cartesian3.normalize(o,o);i-=WALL_INITIAL_MIN_HEIGHT,i=Cartesian3.multiplyByScalar(o,i,adjustHeightOffsetScratch);Cartesian3.add(e,i,n);r-=WALL_INITIAL_MAX_HEIGHT,i=Cartesian3.multiplyByScalar(o,r,adjustHeightOffsetScratch);Cartesian3.add(t,i,a)}var nudgeDirectionScratch=new Cartesian3;function nudgeXZ(e,t){var i=Plane.getPointDistance(XZ_PLANE,e),r=Plane.getPointDistance(XZ_PLANE,t),n=nudgeDirectionScratch;CesiumMath.equalsEpsilon(i,0,CesiumMath.EPSILON2)?(n=direction(t,e,n),Cartesian3.multiplyByScalar(n,CesiumMath.EPSILON2,n),Cartesian3.add(e,n,e)):CesiumMath.equalsEpsilon(r,0,CesiumMath.EPSILON2)&&(n=direction(e,t,n),Cartesian3.multiplyByScalar(n,CesiumMath.EPSILON2,n),Cartesian3.add(t,n,t))}function nudgeCartographic(e,t){var i=Math.abs(e.longitude),r=Math.abs(t.longitude);if(CesiumMath.equalsEpsilon(i,CesiumMath.PI,CesiumMath.EPSILON11)){var n=CesiumMath.sign(t.longitude);return e.longitude=n*(i-CesiumMath.EPSILON11),1}if(CesiumMath.equalsEpsilon(r,CesiumMath.PI,CesiumMath.EPSILON11)){e=CesiumMath.sign(e.longitude);return t.longitude=e*(r-CesiumMath.EPSILON11),2}return 0}var startCartographicScratch=new Cartographic,endCartographicScratch=new Cartographic,segmentStartTopScratch=new Cartesian3,segmentEndTopScratch=new Cartesian3,segmentStartBottomScratch=new Cartesian3,segmentEndBottomScratch=new Cartesian3,segmentStartNormalScratch=new Cartesian3,segmentEndNormalScratch=new Cartesian3,getHeightCartographics=[startCartographicScratch,endCartographicScratch],getHeightRectangleScratch=new Rectangle,adjustHeightStartTopScratch=new Cartesian3,adjustHeightEndTopScratch=new Cartesian3,adjustHeightStartBottomScratch=new Cartesian3,adjustHeightEndBottomScratch=new Cartesian3,segmentStart2DScratch=new Cartesian3,segmentEnd2DScratch=new Cartesian3,segmentStartNormal2DScratch=new Cartesian3,segmentEndNormal2DScratch=new Cartesian3,offsetScratch$1=new Cartesian3,startUpScratch=new Cartesian3,endUpScratch=new Cartesian3,rightScratch$1=new Cartesian3,startPlaneNormalScratch=new Cartesian3,endPlaneNormalScratch=new Cartesian3,encodeScratch=new EncodedCartesian3,encodeScratch2D=new EncodedCartesian3,forwardOffset2DScratch=new Cartesian3,right2DScratch=new Cartesian3,normalNudgeScratch=new Cartesian3,scratchBoundingSpheres=[new BoundingSphere,new BoundingSphere],REFERENCE_INDICES=[0,2,1,0,3,2,0,7,3,0,4,7,0,5,4,0,1,5,5,7,4,5,6,7,5,2,6,5,1,2,3,6,2,3,7,6],REFERENCE_INDICES_LENGTH=REFERENCE_INDICES.length;function generateGeometryAttributes(e,t,i,r,n,a,o){var s,l,c,u,d=t._ellipsoid,h=i.length/3-1,p=8*h,m=4*p,f=36*h,g=new(65535<p?Uint32Array:Uint16Array)(f),_=new Float64Array(3*p),y=new Float32Array(m),C=new Float32Array(m),v=new Float32Array(m),S=new Float32Array(m),T=new Float32Array(m);o&&(s=new Float32Array(m),l=new Float32Array(m),c=new Float32Array(m),u=new Float32Array(2*p));var x=a.length/2,b=0,E=startCartographicScratch;E.height=0;var P=endCartographicScratch;P.height=0;var A=segmentStartTopScratch,w=segmentEndTopScratch;if(o)for(R=0,O=1;O<x;O++)E.latitude=a[R],E.longitude=a[R+1],P.latitude=a[R+2],P.longitude=a[R+3],A=t.project(E,A),w=t.project(P,w),b+=Cartesian3.distance(A,w),R+=2;for(var D,M=r.length/3,w=Cartesian3.unpack(r,0,w),I=0,R=3,O=1;O<M;O++)A=Cartesian3.clone(w,A),w=Cartesian3.unpack(r,R,w),I+=Cartesian3.distance(A,w),R+=3;var L=0,F=0,N=0,B=0,V=!(R=3),k=Cartesian3.unpack(i,0,segmentEndBottomScratch),z=Cartesian3.unpack(r,0,segmentEndTopScratch),U=Cartesian3.unpack(n,0,segmentEndNormalScratch);e&&breakMiter(U,Cartesian3.unpack(i,i.length-6,segmentStartBottomScratch),k,z)&&(U=Cartesian3.negate(U,U));var $=0,G=0,H=0;for(O=0;O<h;O++){var W,q,j,Y,X=Cartesian3.clone(k,segmentStartBottomScratch),Q=Cartesian3.clone(z,segmentStartTopScratch),J=Cartesian3.clone(U,segmentStartNormalScratch);V&&(J=Cartesian3.negate(J,J)),k=Cartesian3.unpack(i,R,segmentEndBottomScratch),z=Cartesian3.unpack(r,R,segmentEndTopScratch),V=breakMiter(U=Cartesian3.unpack(n,R,segmentEndNormalScratch),X,k,z),E.latitude=a[L],E.longitude=a[L+1],P.latitude=a[L+2],P.longitude=a[L+3],o&&(Se=nudgeCartographic(E,P),j=t.project(E,segmentStart2DScratch),(he=direction(Y=t.project(P,segmentEnd2DScratch),j,forwardOffset2DScratch)).y=Math.abs(he.y),W=segmentStartNormal2DScratch,q=segmentEndNormal2DScratch,0===Se||Cartesian3.dot(he,Cartesian3.UNIT_Y)>MITER_BREAK_SMALL?(W=projectNormal(t,E,J,j,segmentStartNormal2DScratch),q=projectNormal(t,P,U,Y,segmentEndNormal2DScratch)):1===Se?(q=projectNormal(t,P,U,Y,segmentEndNormal2DScratch),W.x=0,W.y=CesiumMath.sign(E.longitude-Math.abs(P.longitude)),W.z=0):(W=projectNormal(t,E,J,j,segmentStartNormal2DScratch),q.x=0,q.y=CesiumMath.sign(E.longitude-P.longitude),q.z=0));var Z,K,ee,te=Cartesian3.distance(Q,z),ie=EncodedCartesian3.fromCartesian(X,encodeScratch),re=Cartesian3.subtract(k,X,offsetScratch$1),ne=Cartesian3.normalize(re,rightScratch$1),ae=Cartesian3.subtract(Q,X,startUpScratch),ae=Cartesian3.normalize(ae,ae),oe=Cartesian3.cross(ne,ae,rightScratch$1),oe=Cartesian3.normalize(oe,oe),se=Cartesian3.cross(ae,J,startPlaneNormalScratch),se=Cartesian3.normalize(se,se),le=Cartesian3.subtract(z,k,endUpScratch),le=Cartesian3.normalize(le,le),ce=Cartesian3.cross(U,le,endPlaneNormalScratch),ce=Cartesian3.normalize(ce,ce),ue=te/I,de=$/I,he=0,pe=0,me=0;for(o&&(he=Cartesian3.distance(j,Y),Z=EncodedCartesian3.fromCartesian(j,encodeScratch2D),K=Cartesian3.subtract(Y,j,forwardOffset2DScratch),Te=(ee=Cartesian3.normalize(K,right2DScratch)).x,ee.x=ee.y,ee.y=-Te,pe=he/b,me=G/b),D=0;D<8;D++){var fe=B+4*D,ge=F+2*D,_e=fe+3,ye=D<4?1:-1,Ce=2===D||3===D||6===D||7===D?1:-1;Cartesian3.pack(ie.high,y,fe),y[_e]=re.x,Cartesian3.pack(ie.low,C,fe),C[_e]=re.y,Cartesian3.pack(se,v,fe),v[_e]=re.z,Cartesian3.pack(ce,S,fe),S[_e]=ue*ye,Cartesian3.pack(oe,T,fe);var ve=de*Ce;0===ve&&Ce<0&&(ve=9),T[_e]=ve,o&&(s[fe]=Z.high.x,s[fe+1]=Z.high.y,s[fe+2]=Z.low.x,s[fe+3]=Z.low.y,c[fe]=-W.y,c[fe+1]=W.x,c[fe+2]=q.y,c[fe+3]=-q.x,l[fe]=K.x,l[fe+1]=K.y,l[fe+2]=ee.x,l[fe+3]=ee.y,u[ge]=pe*ye,0===(ve=me*Ce)&&Ce<0&&(ve=9),u[ge+1]=ve)}var Se=adjustHeightStartBottomScratch,ne=adjustHeightEndBottomScratch,ae=adjustHeightStartTopScratch,J=adjustHeightEndTopScratch,le=Rectangle.fromCartographicArray(getHeightCartographics,getHeightRectangleScratch),Te=ApproximateTerrainHeights.getMinimumMaximumHeights(le,d),le=Te.minimumTerrainHeight,Te=Te.maximumTerrainHeight;H+=le,H+=Te,adjustHeights(X,Q,le,Te,Se,ae),adjustHeights(k,z,le,Te,ne,J);Te=Cartesian3.multiplyByScalar(oe,CesiumMath.EPSILON5,normalNudgeScratch);Cartesian3.add(Se,Te,Se),Cartesian3.add(ne,Te,ne),Cartesian3.add(ae,Te,ae),Cartesian3.add(J,Te,J),nudgeXZ(Se,ne),nudgeXZ(ae,J),Cartesian3.pack(Se,_,N),Cartesian3.pack(ne,_,N+3),Cartesian3.pack(J,_,N+6),Cartesian3.pack(ae,_,N+9),Te=Cartesian3.multiplyByScalar(oe,-2*CesiumMath.EPSILON5,normalNudgeScratch),Cartesian3.add(Se,Te,Se),Cartesian3.add(ne,Te,ne),Cartesian3.add(ae,Te,ae),Cartesian3.add(J,Te,J),nudgeXZ(Se,ne),nudgeXZ(ae,J),Cartesian3.pack(Se,_,N+12),Cartesian3.pack(ne,_,N+15),Cartesian3.pack(J,_,N+18),Cartesian3.pack(ae,_,N+21),L+=2,R+=3,F+=16,N+=24,B+=32,$+=te,G+=he}var xe=R=0;for(O=0;O<h;O++){for(D=0;D<REFERENCE_INDICES_LENGTH;D++)g[R+D]=REFERENCE_INDICES[D]+xe;xe+=8,R+=REFERENCE_INDICES_LENGTH}p=scratchBoundingSpheres;BoundingSphere.fromVertices(i,Cartesian3.ZERO,3,p[0]),BoundingSphere.fromVertices(r,Cartesian3.ZERO,3,p[1]);e=BoundingSphere.fromBoundingSpheres(p);e.radius+=H/(2*h);p={position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,normalize:!1,values:_}),startHiAndForwardOffsetX:getVec4GeometryAttribute(y),startLoAndForwardOffsetY:getVec4GeometryAttribute(C),startNormalAndForwardOffsetZ:getVec4GeometryAttribute(v),endNormalAndTextureCoordinateNormalizationX:getVec4GeometryAttribute(S),rightNormalAndTextureCoordinateNormalizationY:getVec4GeometryAttribute(T)};return o&&(p.startHiLo2D=getVec4GeometryAttribute(s),p.offsetAndRight2D=getVec4GeometryAttribute(l),p.startEndNormals2D=getVec4GeometryAttribute(c),p.texcoordNormalization2D=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,normalize:!1,values:u})),new Geometry({attributes:p,indices:g,boundingSphere:e})}function getVec4GeometryAttribute(e){return new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:4,normalize:!1,values:e})}function HeadingPitchRange(e,t,i){this.heading=defaultValue(e,0),this.pitch=defaultValue(t,0),this.range=defaultValue(i,0)}GroundPolylineGeometry._projectNormal=projectNormal,HeadingPitchRange.clone=function(e,t){if(defined(e))return defined(t)||(t=new HeadingPitchRange),t.heading=e.heading,t.pitch=e.pitch,t.range=e.range,t};var factorial=CesiumMath.factorial;function calculateCoefficientTerm(e,t,i,r,n,a){var o,s,l,c=0;if(0<r){for(s=0;s<n;s++){for(o=!1,l=0;l<a.length&&!o;l++)s===a[l]&&(o=!0);o||(a.push(s),c+=calculateCoefficientTerm(e,t,i,r-1,n,a),a.splice(a.length-1,1))}return c}for(c=1,s=0;s<n;s++){for(o=!1,l=0;l<a.length&&!o;l++)s===a[l]&&(o=!0);o||(c*=e-i[t[s]])}return c}var HermitePolynomialApproximation={type:"Hermite",getRequiredDataPoints:function(e,t){return t=defaultValue(t,0),Math.max(Math.floor((e+1)/(t+1)),2)},interpolateOrderZero:function(e,t,i,r,n){var a,o;defined(n)||(n=new Array(r));for(var s=t.length,l=new Array(r),c=0;c<r;c++){n[c]=0;var u=new Array(s);for(l[c]=u,f=0;f<s;f++)u[f]=[]}var d=s,h=new Array(d);for(c=0;c<d;c++)h[c]=c;var p=s-1;for(v=0;v<r;v++){for(f=0;f<d;f++)o=h[f]*r+v,l[v][0].push(i[o]);for(c=1;c<d;c++){for(var m=!1,f=0;f<d-c;f++){var g,_=t[h[f]],y=t[h[f+c]];y-_<=0?(g=i[o=h[f]*r+r*c+v],l[v][c].push(g/factorial(c))):(g=l[v][c-1][f+1]-l[v][c-1][f],l[v][c].push(g/(y-_))),m=m||0!==g}m||(p=c-1)}}for(a=0;a<=0;a++)for(c=a;c<=p;c++)for(var C=calculateCoefficientTerm(e,h,t,a,c,[]),v=0;v<r;v++){var S=l[v][c][0];n[v+a*r]+=S*C}return n}},arrayScratch$1=[];function fillCoefficientList(e,t,i,r,n,a){for(var o,s=-1,l=t.length,c=l*(l+1)/2,u=0;u<n;u++){var d=Math.floor(u*c);for(g=0;g<l;g++)o=t[g]*n*(a+1)+u,e[d+g]=r[o];for(var h=1;h<l;h++){for(var p=0,m=Math.floor(h*(1-h)/2)+l*h,f=!1,g=0;g<l-h;g++){var _,y,C=i[t[g]],v=i[t[g+h]];C=v-C<=0?(y=r[o=t[g]*n*(a+1)+n*h+u])/CesiumMath.factorial(h):(y=e[d+(_=Math.floor((h-1)*(2-h)/2)+l*(h-1))+g+1]-e[d+_+g])/(v-C),e[d+m+p]=C,p++,f=f||0!==y}f&&(s=Math.max(s,h))}}return s}function IauOrientationParameters(e,t,i,r){this.rightAscension=e,this.declination=t,this.rotation=i,this.rotationRate=r}HermitePolynomialApproximation.interpolate=function(e,t,i,r,n,a,o){var s=r*(a+1);defined(o)||(o=new Array(s));for(var l=0;l<s;l++)o[l]=0;for(var c=t.length,u=new Array(c*(n+1)),d=0;d<c;d++)for(var h=0;h<n+1;h++)u[d*(n+1)+h]=d;for(var p=u.length,m=arrayScratch$1,f=fillCoefficientList(m,u,t,i,r,n),g=[],_=p*(p+1)/2,y=Math.min(f,a),C=0;C<=y;C++)for(d=C;d<=f;d++){g.length=0;for(var v=calculateCoefficientTerm(e,u,t,C,d,g),S=Math.floor(d*(1-d)/2)+p*d,T=0;T<r;T++){var x=m[Math.floor(T*_)+S];o[T+C*r]+=x*v}}return o};var Iau2000Orientation={},TdtMinusTai=32.184,J2000d=2451545,c1=-.0529921,c2=-.1059842,c3$1=13.0120009,c4=13.3407154,c5=.9856003,c6=26.4057084,c7=13.064993,c8=.3287146,c9=1.7484877,c10=-.1589763,c11=.0036096,c12=.1643573,c13=12.9590088,dateTT=new JulianDate;function IauOrientationAxes(e){defined(e)&&"function"==typeof e||(e=Iau2000Orientation.ComputeMoon),this._computeFunction=e}Iau2000Orientation.ComputeMoon=function(e,t){defined(e)||(e=JulianDate.now()),dateTT=JulianDate.addSeconds(e,TdtMinusTai,dateTT);var i=JulianDate.totalDays(dateTT)-J2000d,r=i/TimeConstants$1.DAYS_PER_JULIAN_CENTURY,n=(125.045+c1*i)*CesiumMath.RADIANS_PER_DEGREE,a=(250.089+c2*i)*CesiumMath.RADIANS_PER_DEGREE,o=(260.008+c3$1*i)*CesiumMath.RADIANS_PER_DEGREE,s=(176.625+c4*i)*CesiumMath.RADIANS_PER_DEGREE,l=(357.529+c5*i)*CesiumMath.RADIANS_PER_DEGREE,c=(311.589+c6*i)*CesiumMath.RADIANS_PER_DEGREE,u=(134.963+c7*i)*CesiumMath.RADIANS_PER_DEGREE,d=(276.617+c8*i)*CesiumMath.RADIANS_PER_DEGREE,h=(34.226+c9*i)*CesiumMath.RADIANS_PER_DEGREE,p=(15.134+c10*i)*CesiumMath.RADIANS_PER_DEGREE,m=(119.743+c11*i)*CesiumMath.RADIANS_PER_DEGREE,f=(239.961+c12*i)*CesiumMath.RADIANS_PER_DEGREE,g=(25.053+c13*i)*CesiumMath.RADIANS_PER_DEGREE,_=Math.sin(n),y=Math.sin(a),C=Math.sin(o),v=Math.sin(s),S=Math.sin(l),T=Math.sin(c),x=Math.sin(u),b=Math.sin(d),E=Math.sin(h),P=Math.sin(p),A=Math.sin(m),w=Math.sin(f),D=Math.sin(g),e=Math.cos(n),n=Math.cos(a),a=Math.cos(o),o=Math.cos(s),s=Math.cos(l),l=Math.cos(c),c=Math.cos(u),u=Math.cos(d),d=Math.cos(h),h=Math.cos(p),p=Math.cos(m),m=Math.cos(f),f=Math.cos(g),g=(269.9949+.0031*r-3.8787*_-.1204*y+.07*C-.0172*v+.0072*T-.0052*P+.0043*D)*CesiumMath.RADIANS_PER_DEGREE,r=(66.5392+.013*r+1.5419*e+.0239*n-.0278*a+.0068*o-.0029*l+9e-4*c+8e-4*h-9e-4*f)*CesiumMath.RADIANS_PER_DEGREE,D=(38.3213+13.17635815*i-14e-13*i*i+3.561*_+.1208*y-.0642*C+.0158*v+.0252*S-.0066*T-.0047*x-.0046*b+.0028*E+.0052*P+.004*A+.0019*w-.0044*D)*CesiumMath.RADIANS_PER_DEGREE,f=(13.17635815-2*i*14e-13+3.561*e*c1+.1208*n*c2-.0642*a*c3$1+.0158*o*c4+.0252*s*c5-.0066*l*c6-.0047*c*c7-.0046*u*c8+.0028*d*c9+.0052*h*c10+.004*p*c11+.0019*m*c12-.0044*f*c13)/86400*CesiumMath.RADIANS_PER_DEGREE;return defined(t)||(t=new IauOrientationParameters),t.rightAscension=g,t.declination=r,t.rotation=D,t.rotationRate=f,t};var xAxisScratch=new Cartesian3,yAxisScratch=new Cartesian3,zAxisScratch=new Cartesian3;function computeRotationMatrix(e,t,i){var r=xAxisScratch;r.x=Math.cos(e+CesiumMath.PI_OVER_TWO),r.y=Math.sin(e+CesiumMath.PI_OVER_TWO),r.z=0;var n=Math.cos(t),a=zAxisScratch;a.x=n*Math.cos(e),a.y=n*Math.sin(e),a.z=Math.sin(t);t=Cartesian3.cross(a,r,yAxisScratch);return defined(i)||(i=new Matrix3),i[0]=r.x,i[1]=t.x,i[2]=a.x,i[3]=r.y,i[4]=t.y,i[5]=a.y,i[6]=r.z,i[7]=t.z,i[8]=a.z,i}var rotMtxScratch=new Matrix3,quatScratch=new Quaternion;IauOrientationAxes.prototype.evaluate=function(e,t){defined(e)||(e=JulianDate.now());e=this._computeFunction(e),t=computeRotationMatrix(e.rightAscension,e.declination,t),e=CesiumMath.zeroToTwoPi(e.rotation),e=Quaternion.fromAxisAngle(Cartesian3.UNIT_Z,e,quatScratch),e=Matrix3.fromQuaternion(Quaternion.conjugate(e,e),rotMtxScratch);return Matrix3.multiply(e,t,t)};var InterpolationAlgorithm={type:void 0},defaultTokenCredit;InterpolationAlgorithm.getRequiredDataPoints=DeveloperError.throwInstantiationError,InterpolationAlgorithm.interpolateOrderZero=DeveloperError.throwInstantiationError,InterpolationAlgorithm.interpolate=DeveloperError.throwInstantiationError;var defaultAccessToken="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiIxMmVkZTQ0Ni1kOWJlLTRmY2ItOTc1Ny03ZDEwOTcyYmIzY2IiLCJpZCI6MjU5LCJpYXQiOjE2MDk3NzQ1OTZ9.8lY9m6O6CY1lpmW5SSNmQmHdxuzNL20N9vUtsbBGezA",Ion={};function PeliasGeocoderService(e){this._url=Resource.createIfNeeded(e),this._url.appendForwardSlash()}function IonGeocoderService(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.accessToken,Ion.defaultAccessToken),i=Resource.createIfNeeded(defaultValue(e.server,Ion.defaultServer));i.appendForwardSlash();var r=Ion.getDefaultTokenCredit(t);defined(r)&&e.scene.frameState.creditDisplay.addDefaultCredit(Credit.clone(r));r=i.getDerivedResource({url:"v1/geocode"});defined(t)&&r.appendQueryParameters({access_token:t}),this._accessToken=t,this._server=i,this._pelias=new PeliasGeocoderService(r)}function IonResource(e,t){var i,r=e.externalType,n=defined(r);if(n){if("3DTILES"!==r&&"STK_TERRAIN_SERVER"!==r)throw new RuntimeError("Ion.createResource does not support external imagery assets; use IonImageryProvider instead.");i={url:e.options.url}}else i={url:e.url,retryAttempts:1,retryCallback:retryCallback};Resource.call(this,i),this._ionEndpoint=e,this._ionEndpointDomain=n?void 0:new URI(e.url).authority,this._ionEndpointResource=t,this._ionRoot=void 0,this._pendingPromise=void 0,this._credits=void 0,this._isExternal=n}function retryCallback(t,e){var i=defaultValue(t._ionRoot,t),r=i._ionEndpointResource;return defined(e)&&(401===e.statusCode||e.target instanceof Image)?(defined(i._pendingPromise)||(i._pendingPromise=r.fetchJson().then(function(e){return i._ionEndpoint=e}).always(function(e){return i._pendingPromise=void 0,e})),i._pendingPromise.then(function(e){return t._ionEndpoint=e,!0})):when.resolve(!1)}function TimeInterval(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.start=defined(e.start)?JulianDate.clone(e.start):new JulianDate,this.stop=defined(e.stop)?JulianDate.clone(e.stop):new JulianDate,this.data=e.data,this.isStartIncluded=defaultValue(e.isStartIncluded,!0),this.isStopIncluded=defaultValue(e.isStopIncluded,!0)}Ion.defaultAccessToken=defaultAccessToken,Ion.defaultServer=new Resource({url:"https://api.cesium.com/"}),Ion.getDefaultTokenCredit=function(e){if(e===defaultAccessToken)return defined(defaultTokenCredit)||(defaultTokenCredit=new Credit('<b>             This application is using Cesium\'s default ion access token. Please assign <i>Cesium.Ion.defaultAccessToken</i>             with an access token from your ion account before making any Cesium API calls.             You can sign up for a free ion account at <a href="https://cesium.com">https://cesium.com</a>.</b>',!0)),defaultTokenCredit},Object.defineProperties(PeliasGeocoderService.prototype,{url:{get:function(){return this._url}}}),PeliasGeocoderService.prototype.geocode=function(e,t){return this._url.getDerivedResource({url:t===GeocodeType$1.AUTOCOMPLETE?"autocomplete":"search",queryParameters:{text:e}}).fetchJson().then(function(e){return e.features.map(function(e){var t,i=e.bbox;return t=defined(i)?Rectangle.fromDegrees(i[0],i[1],i[2],i[3]):(i=e.geometry.coordinates[0],t=e.geometry.coordinates[1],Cartesian3.fromDegrees(i,t)),{displayName:e.properties.label,destination:t}})})},IonGeocoderService.prototype.geocode=function(e,t){return this._pelias.geocode(e,t)},defined(Object.create)&&(IonResource.prototype=Object.create(Resource.prototype),IonResource.prototype.constructor=IonResource),IonResource.fromAssetId=function(e,t){var i=IonResource._createEndpointResource(e,t);return i.fetchJson().then(function(e){return new IonResource(e,i)})},Object.defineProperties(IonResource.prototype,{credits:{get:function(){return defined(this._ionRoot)?this._ionRoot.credits:(defined(this._credits)||(this._credits=IonResource.getCreditsFromEndpoint(this._ionEndpoint,this._ionEndpointResource)),this._credits)}}}),IonResource.getCreditsFromEndpoint=function(e,t){e=e.attributions.map(Credit.getIonCredit),t=Ion.getDefaultTokenCredit(t.queryParameters.access_token);return defined(t)&&e.push(Credit.clone(t)),e},IonResource.prototype.clone=function(e){var t=defaultValue(this._ionRoot,this);return defined(e)||(e=new IonResource(t._ionEndpoint,t._ionEndpointResource)),(e=Resource.prototype.clone.call(this,e))._ionRoot=t,e._isExternal=this._isExternal,e},IonResource.prototype.fetchImage=function(e){var t;return this._isExternal||(t=e,e={preferBlob:!0},defined(t)&&(e.flipY=t.flipY,e.preferImageBitmap=t.preferImageBitmap)),Resource.prototype.fetchImage.call(this,e)},IonResource.prototype._makeRequest=function(e){return this._isExternal||new URI(this.url).authority!==this._ionEndpointDomain||(defined(e.headers)||(e.headers={}),e.headers.Authorization="Bearer "+this._ionEndpoint.accessToken),Resource.prototype._makeRequest.call(this,e)},IonResource._createEndpointResource=function(e,t){t=defaultValue(t,defaultValue.EMPTY_OBJECT);var i=defaultValue(t.server,Ion.defaultServer),t=defaultValue(t.accessToken,Ion.defaultAccessToken),i=Resource.createIfNeeded(i),e={url:"v1/assets/"+e+"/endpoint"};return defined(t)&&(e.queryParameters={access_token:t}),i.getDerivedResource(e)},Object.defineProperties(TimeInterval.prototype,{isEmpty:{get:function(){var e=JulianDate.compare(this.stop,this.start);return e<0||0===e&&(!this.isStartIncluded||!this.isStopIncluded)}}});var scratchInterval={start:void 0,stop:void 0,isStartIncluded:void 0,isStopIncluded:void 0,data:void 0};TimeInterval.fromIso8601=function(e,t){var i=e.iso8601.split("/");if(2!==i.length)throw new DeveloperError("options.iso8601 is an invalid ISO 8601 interval.");var r=JulianDate.fromIso8601(i[0]),n=JulianDate.fromIso8601(i[1]),a=defaultValue(e.isStartIncluded,!0),i=defaultValue(e.isStopIncluded,!0),e=e.data;return defined(t)?(t.start=r,t.stop=n,t.isStartIncluded=a,t.isStopIncluded=i,t.data=e,t):(scratchInterval.start=r,scratchInterval.stop=n,scratchInterval.isStartIncluded=a,scratchInterval.isStopIncluded=i,scratchInterval.data=e,new TimeInterval(scratchInterval))},TimeInterval.toIso8601=function(e,t){return JulianDate.toIso8601(e.start,t)+"/"+JulianDate.toIso8601(e.stop,t)},TimeInterval.clone=function(e,t){if(defined(e))return defined(t)?(t.start=e.start,t.stop=e.stop,t.isStartIncluded=e.isStartIncluded,t.isStopIncluded=e.isStopIncluded,t.data=e.data,t):new TimeInterval(e)},TimeInterval.equals=function(e,t,i){return e===t||defined(e)&&defined(t)&&(e.isEmpty&&t.isEmpty||e.isStartIncluded===t.isStartIncluded&&e.isStopIncluded===t.isStopIncluded&&JulianDate.equals(e.start,t.start)&&JulianDate.equals(e.stop,t.stop)&&(e.data===t.data||defined(i)&&i(e.data,t.data)))},TimeInterval.equalsEpsilon=function(e,t,i,r){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&(e.isEmpty&&t.isEmpty||e.isStartIncluded===t.isStartIncluded&&e.isStopIncluded===t.isStopIncluded&&JulianDate.equalsEpsilon(e.start,t.start,i)&&JulianDate.equalsEpsilon(e.stop,t.stop,i)&&(e.data===t.data||defined(r)&&r(e.data,t.data)))},TimeInterval.intersect=function(e,t,i,r){if(!defined(t))return TimeInterval.clone(TimeInterval.EMPTY,i);var n=e.start,a=e.stop,o=t.start,s=t.stop,l=JulianDate.greaterThanOrEquals(o,n)&&JulianDate.greaterThanOrEquals(a,o),c=!l&&JulianDate.lessThanOrEquals(o,n)&&JulianDate.lessThanOrEquals(n,s);if(!l&&!c)return TimeInterval.clone(TimeInterval.EMPTY,i);var u=e.isStartIncluded,d=e.isStopIncluded,h=t.isStartIncluded,p=t.isStopIncluded,m=JulianDate.lessThan(a,s);return defined(i)||(i=new TimeInterval),i.start=l?o:n,i.isStartIncluded=u&&h||!JulianDate.equals(o,n)&&(l&&h||c&&u),i.stop=m?a:s,i.isStopIncluded=m?d:d&&p||!JulianDate.equals(s,a)&&p,i.data=defined(r)?r(e.data,t.data):e.data,i},TimeInterval.contains=function(e,t){if(e.isEmpty)return!1;var i=JulianDate.compare(e.start,t);if(0===i)return e.isStartIncluded;t=JulianDate.compare(t,e.stop);return 0===t?e.isStopIncluded:i<0&&t<0},TimeInterval.prototype.clone=function(e){return TimeInterval.clone(this,e)},TimeInterval.prototype.equals=function(e,t){return TimeInterval.equals(this,e,t)},TimeInterval.prototype.equalsEpsilon=function(e,t,i){return TimeInterval.equalsEpsilon(this,e,t,i)},TimeInterval.prototype.toString=function(){return TimeInterval.toIso8601(this)},TimeInterval.EMPTY=Object.freeze(new TimeInterval({start:new JulianDate,stop:new JulianDate,isStartIncluded:!1,isStopIncluded:!1}));var MINIMUM_VALUE=Object.freeze(JulianDate.fromIso8601("0000-01-01T00:00:00Z")),MAXIMUM_VALUE=Object.freeze(JulianDate.fromIso8601("9999-12-31T24:00:00Z")),MAXIMUM_INTERVAL=Object.freeze(new TimeInterval({start:MINIMUM_VALUE,stop:MAXIMUM_VALUE})),Iso8601={MINIMUM_VALUE:MINIMUM_VALUE,MAXIMUM_VALUE:MAXIMUM_VALUE,MAXIMUM_INTERVAL:MAXIMUM_INTERVAL},KeyboardEventModifier={SHIFT:0,CTRL:1,ALT:2},KeyboardEventModifier$1=Object.freeze(KeyboardEventModifier),LagrangePolynomialApproximation={type:"Lagrange",getRequiredDataPoints:function(e){return Math.max(e+1,2)},interpolateOrderZero:function(e,t,i,r,n){defined(n)||(n=new Array(r));for(var a=t.length,o=0;o<r;o++)n[o]=0;for(o=0;o<a;o++){for(var s,l=1,c=0;c<a;c++)c!==o&&(s=t[o]-t[c],l*=(e-t[c])/s);for(c=0;c<r;c++)n[c]+=l*i[o*r+c]}return n}},LinearApproximation={type:"Linear"};function ManagedArray(e){e=defaultValue(e,0),this._array=new Array(e),this._length=e}function MapProjection(){DeveloperError.throwInstantiationError()}function NearFarScalar(e,t,i,r){this.near=defaultValue(e,0),this.nearValue=defaultValue(t,0),this.far=defaultValue(i,1),this.farValue=defaultValue(r,0)}LinearApproximation.getRequiredDataPoints=function(e){return 2},LinearApproximation.interpolateOrderZero=function(e,t,i,r,n){var a,o;defined(n)||(n=new Array(r));for(var s=t[0],l=t[1],c=0;c<r;c++)a=i[c],o=i[c+r],n[c]=((o-a)*e+l*a-s*o)/(l-s);return n},Object.defineProperties(ManagedArray.prototype,{length:{get:function(){return this._length},set:function(e){var t=this._array,i=this._length;if(e<i)for(var r=e;r<i;++r)t[r]=void 0;else e>t.length&&(t.length=e);this._length=e}},values:{get:function(){return this._array}}}),ManagedArray.prototype.get=function(e){return this._array[e]},ManagedArray.prototype.set=function(e,t){e>=this._length&&(this.length=e+1),this._array[e]=t},ManagedArray.prototype.peek=function(){return this._array[this._length-1]},ManagedArray.prototype.push=function(e){var t=this.length++;this._array[t]=e},ManagedArray.prototype.pop=function(){if(0!==this._length){var e=this._array[this._length-1];return--this.length,e}},ManagedArray.prototype.reserve=function(e){e>this._array.length&&(this._array.length=e)},ManagedArray.prototype.resize=function(e){this.length=e},ManagedArray.prototype.trim=function(e){e=defaultValue(e,this._length),this._array.length=e},Object.defineProperties(MapProjection.prototype,{ellipsoid:{get:DeveloperError.throwInstantiationError}}),MapProjection.prototype.project=DeveloperError.throwInstantiationError,MapProjection.prototype.unproject=DeveloperError.throwInstantiationError,NearFarScalar.clone=function(e,t){if(defined(e))return defined(t)?(t.near=e.near,t.nearValue=e.nearValue,t.far=e.far,t.farValue=e.farValue,t):new NearFarScalar(e.near,e.nearValue,e.far,e.farValue)},NearFarScalar.packedLength=4,NearFarScalar.pack=function(e,t,i){return i=defaultValue(i,0),t[i++]=e.near,t[i++]=e.nearValue,t[i++]=e.far,t[i]=e.farValue,t},NearFarScalar.unpack=function(e,t,i){return t=defaultValue(t,0),defined(i)||(i=new NearFarScalar),i.near=e[t++],i.nearValue=e[t++],i.far=e[t++],i.farValue=e[t],i},NearFarScalar.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.near===t.near&&e.nearValue===t.nearValue&&e.far===t.far&&e.farValue===t.farValue},NearFarScalar.prototype.clone=function(e){return NearFarScalar.clone(this,e)},NearFarScalar.prototype.equals=function(e){return NearFarScalar.equals(this,e)};var Visibility={NONE:-1,PARTIAL:0,FULL:1},Visibility$1=Object.freeze(Visibility);function Occluder(e,t){this._occluderPosition=Cartesian3.clone(e.center),this._occluderRadius=e.radius,this._horizonDistance=0,this._horizonPlaneNormal=void 0,this._horizonPlanePosition=void 0,this._cameraPosition=void 0,this.cameraPosition=t}var scratchCartesian3$7=new Cartesian3;Object.defineProperties(Occluder.prototype,{position:{get:function(){return this._occluderPosition}},radius:{get:function(){return this._occluderRadius}},cameraPosition:{set:function(e){e=Cartesian3.clone(e,this._cameraPosition);var t,i,r,n=Cartesian3.subtract(this._occluderPosition,e,scratchCartesian3$7),a=Cartesian3.magnitudeSquared(n),o=this._occluderRadius*this._occluderRadius;o<a?(t=Math.sqrt(a-o),a=1/Math.sqrt(a),i=Cartesian3.multiplyByScalar(n,a,scratchCartesian3$7),r=t*t*a,r=Cartesian3.add(e,Cartesian3.multiplyByScalar(i,r,scratchCartesian3$7),scratchCartesian3$7)):t=Number.MAX_VALUE,this._horizonDistance=t,this._horizonPlaneNormal=i,this._horizonPlanePosition=r,this._cameraPosition=e}}}),Occluder.fromBoundingSphere=function(e,t,i){return defined(i)?(Cartesian3.clone(e.center,i._occluderPosition),i._occluderRadius=e.radius,i.cameraPosition=t,i):new Occluder(e,t)};var tempVecScratch=new Cartesian3;Occluder.prototype.isPointVisible=function(e){if(this._horizonDistance!==Number.MAX_VALUE){var t=Cartesian3.subtract(e,this._occluderPosition,tempVecScratch),i=this._occluderRadius;if(0<(i=Cartesian3.magnitudeSquared(t)-i*i))return i=Math.sqrt(i)+this._horizonDistance,t=Cartesian3.subtract(e,this._cameraPosition,t),i*i>Cartesian3.magnitudeSquared(t)}return!1};var occludeePositionScratch=new Cartesian3;Occluder.prototype.isBoundingSphereVisible=function(e){var t=Cartesian3.clone(e.center,occludeePositionScratch),i=e.radius;if(this._horizonDistance===Number.MAX_VALUE)return!1;var r=Cartesian3.subtract(t,this._occluderPosition,tempVecScratch),e=this._occluderRadius-i,e=Cartesian3.magnitudeSquared(r)-e*e;if(i<this._occluderRadius)return 0<e&&(e=Math.sqrt(e)+this._horizonDistance,r=Cartesian3.subtract(t,this._cameraPosition,r),e*e+i*i>Cartesian3.magnitudeSquared(r));if(0<e){r=Cartesian3.subtract(t,this._cameraPosition,r);t=Cartesian3.magnitudeSquared(r),r=this._occluderRadius*this._occluderRadius,i=i*i;return(this._horizonDistance*this._horizonDistance+r)*i>t*r?!0:t<(e=Math.sqrt(e)+this._horizonDistance)*e+i}return!0};var tempScratch$1=new Cartesian3;Occluder.prototype.computeVisibility=function(e){var t=Cartesian3.clone(e.center),i=e.radius;if(i>this._occluderRadius)return Visibility$1.FULL;if(this._horizonDistance!==Number.MAX_VALUE){var r=Cartesian3.subtract(t,this._occluderPosition,tempScratch$1),n=this._occluderRadius-i,a=Cartesian3.magnitudeSquared(r);if(0<(n=a-n*n)){n=Math.sqrt(n)+this._horizonDistance,r=Cartesian3.subtract(t,this._cameraPosition,r);e=Cartesian3.magnitudeSquared(r);return n*n+i*i<e?Visibility$1.NONE:0<(n=a-(n=this._occluderRadius+i)*n)?e<(n=Math.sqrt(n)+this._horizonDistance)*n+i*i?Visibility$1.FULL:Visibility$1.PARTIAL:(r=Cartesian3.subtract(t,this._horizonPlanePosition,r),Cartesian3.dot(r,this._horizonPlaneNormal)>-i?Visibility$1.PARTIAL:Visibility$1.FULL)}}return Visibility$1.NONE};var occludeePointScratch=new Cartesian3;Occluder.computeOccludeePoint=function(e,t,i){var r=Cartesian3.clone(t),n=Cartesian3.clone(e.center),t=e.radius,a=i.length,o=Cartesian3.normalize(Cartesian3.subtract(r,n,occludeePointScratch),occludeePointScratch),s=-Cartesian3.dot(o,n),l=Occluder._anyRotationVector(n,o,s),c=Occluder._horizonToPlaneNormalDotProduct(e,o,s,l,i[0]);if(c){for(var u,d=1;d<a;++d){if(!(u=Occluder._horizonToPlaneNormalDotProduct(e,o,s,l,i[d])))return;u<c&&(c=u)}if(!(c<.0017453283658983088)){t=t/c;return Cartesian3.add(n,Cartesian3.multiplyByScalar(o,t,occludeePointScratch),occludeePointScratch)}}};var computeOccludeePointFromRectangleScratch=[];Occluder.computeOccludeePointFromRectangle=function(e,t){t=defaultValue(t,Ellipsoid.WGS84);var i=Rectangle.subsample(e,t,0,computeOccludeePointFromRectangleScratch),r=BoundingSphere.fromPoints(i),e=Cartesian3.ZERO;if(!Cartesian3.equals(e,r.center))return Occluder.computeOccludeePoint(new BoundingSphere(e,t.minimumRadius),r.center,i)};var tempVec0Scratch=new Cartesian3;Occluder._anyRotationVector=function(e,t,i){var r=Cartesian3.abs(t,tempVec0Scratch),n=r.x>r.y?0:1;(0===n&&r.z>r.x||1===n&&r.z>r.y)&&(n=2);var a=new Cartesian3,n=0===n?(r.x=e.x,r.y=e.y+1,r.z=e.z+1,Cartesian3.UNIT_X):1===n?(r.x=e.x+1,r.y=e.y,r.z=e.z+1,Cartesian3.UNIT_Y):(r.x=e.x+1,r.y=e.y+1,r.z=e.z,Cartesian3.UNIT_Z),t=(Cartesian3.dot(t,r)+i)/-Cartesian3.dot(t,n);return Cartesian3.normalize(Cartesian3.subtract(Cartesian3.add(r,Cartesian3.multiplyByScalar(n,t,a),r),e,r),r)};var posDirectionScratch=new Cartesian3;Occluder._rotationVector=function(e,t,i,r,n){e=Cartesian3.subtract(r,e,posDirectionScratch),e=Cartesian3.normalize(e,e);if(Cartesian3.dot(t,e)<.9999999847691291){e=Cartesian3.cross(t,e,e);if(Cartesian3.magnitude(e)>CesiumMath.EPSILON13)return Cartesian3.normalize(e,new Cartesian3)}return n};var posScratch1=new Cartesian3,occluerPosScratch=new Cartesian3,posScratch2=new Cartesian3,horizonPlanePosScratch=new Cartesian3;function OffsetGeometryInstanceAttribute(e,t,i){e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,0),this.value=new Float32Array([e,t,i])}function OpenCageGeocoderService(e,t,i){(e=Resource.createIfNeeded(e)).appendForwardSlash(),e.setQueryParameters({key:t}),this._url=e,this._params=defaultValue(i,{})}Occluder._horizonToPlaneNormalDotProduct=function(e,t,i,r,n){var a=Cartesian3.clone(n,posScratch1),o=Cartesian3.clone(e.center,occluerPosScratch),s=e.radius,l=Cartesian3.subtract(o,a,posScratch2),n=Cartesian3.magnitudeSquared(l),e=s*s;if(n<e)return!1;s=n-e,e=Math.sqrt(s),n=e*(1/Math.sqrt(n))*e,l=Cartesian3.normalize(l,l),e=Cartesian3.add(a,Cartesian3.multiplyByScalar(l,n,horizonPlanePosScratch),horizonPlanePosScratch),n=Math.sqrt(s-n*n),r=this._rotationVector(o,t,i,a,r),l=Cartesian3.fromElements(r.x*r.x*l.x+(r.x*r.y-r.z)*l.y+(r.x*r.z+r.y)*l.z,(r.x*r.y+r.z)*l.x+r.y*r.y*l.y+(r.y*r.z-r.x)*l.z,(r.x*r.z-r.y)*l.x+(r.y*r.z+r.x)*l.y+r.z*r.z*l.z,posScratch1),l=Cartesian3.normalize(l,l),l=Cartesian3.multiplyByScalar(l,n,posScratch1),r=Cartesian3.normalize(Cartesian3.subtract(Cartesian3.add(e,l,posScratch2),o,posScratch2),posScratch2),n=Cartesian3.dot(t,r);r=Cartesian3.normalize(Cartesian3.subtract(Cartesian3.subtract(e,l,r),o,r),r);r=Cartesian3.dot(t,r);return n<r?n:r},Object.defineProperties(OffsetGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.FLOAT}},componentsPerAttribute:{get:function(){return 3}},normalize:{get:function(){return!1}}}),OffsetGeometryInstanceAttribute.fromCartesian3=function(e){return new OffsetGeometryInstanceAttribute(e.x,e.y,e.z)},OffsetGeometryInstanceAttribute.toValue=function(e,t){return defined(t)||(t=new Float32Array([e.x,e.y,e.z])),t[0]=e.x,t[1]=e.y,t[2]=e.z,t},Object.defineProperties(OpenCageGeocoderService.prototype,{url:{get:function(){return this._url}},params:{get:function(){return this._params}}}),OpenCageGeocoderService.prototype.geocode=function(e){return this._url.getDerivedResource({url:"json",queryParameters:combine(this._params,{q:e})}).fetchJson().then(function(e){return e.results.map(function(e){var t,i=e.bounds;return t=defined(i)?Rectangle.fromDegrees(i.southwest.lng,i.southwest.lat,i.northeast.lng,i.northeast.lat):(i=e.geometry.lat,t=e.geometry.lng,Cartesian3.fromDegrees(i,t)),{displayName:e.formatted,destination:t}})})};var Packable={packedLength:void 0,pack:DeveloperError.throwInstantiationError,unpack:DeveloperError.throwInstantiationError},PackableForInterpolation={packedInterpolationLength:void 0,convertPackedArrayForInterpolation:DeveloperError.throwInstantiationError,unpackInterpolationResult:DeveloperError.throwInstantiationError},getCSSValue=function(e,t){return document.defaultView.getComputedStyle(e,null).getPropertyValue(t)},measureText=function(e,t,i,r){var n=e.measureText(t),a=getCSSValue(e.canvas,"font-family"),o=getCSSValue(e.canvas,"font-size").replace("px",""),s=getCSSValue(e.canvas,"font-style"),l=getCSSValue(e.canvas,"font-weight"),c=!/\S/.test(t);n.fontsize=o;var u=document.createElement("div");u.style.position="absolute",u.style.opacity=0,u.style.font=s+" "+l+" "+o+"px "+a,u.innerHTML=t+"<br/>"+t,document.body.appendChild(u),n.leading=1.2*o;var d=getCSSValue(u,"height");if(2*o<=(d=d.replace("px",""))&&(n.leading=d/2|0),document.body.removeChild(u),c)n.ascent=0,n.descent=0,n.bounds={minx:0,maxx:n.width,miny:0,maxy:0},n.height=0;else{u=document.createElement("canvas");u.width=n.width+100,u.height=3*o,u.style.opacity=1,u.style.fontFamily=a,u.style.fontSize=o,u.style.fontStyle=s,u.style.fontWeight=l;c=u.getContext("2d");c.font=s+" "+l+" "+o+"px "+a;o=u.width,a=u.height,u=a/2;c.fillStyle="white",c.fillRect(-1,-1,o+2,a+2),i&&(c.strokeStyle="black",c.lineWidth=e.lineWidth,c.strokeText(t,50,u)),r&&(c.fillStyle="black",c.fillText(t,50,u));for(var h=c.getImageData(0,0,o,a).data,p=0,m=4*o,f=h.length;++p<f&&255===h[p];);for(t=p/m|0,p=f-1;0<--p&&255===h[p];);c=p/m|0;for(p=0;p<f&&255===h[p];)f<=(p+=m)&&(p=p-f+4);var a=p%m/4|0,g=1;for(p=f-3;0<=p&&255===h[p];)(p-=m)<0&&(p=f-3-4*g++);o=p%m/4+1|0;n.ascent=u-t,n.descent=c-u,n.bounds={minx:a-50,maxx:o-50,miny:0,maxy:c-t},n.height=c-t+1}return n},imageSmoothingEnabledName;function writeTextToCanvas(e,t){if(""!==e){t=defaultValue(t,defaultValue.EMPTY_OBJECT);var i=defaultValue(t.font,"10px sans-serif"),r=defaultValue(t.stroke,!1),n=defaultValue(t.fill,!0),a=defaultValue(t.strokeWidth,1),o=defaultValue(t.backgroundColor,Color.TRANSPARENT),s=defaultValue(t.padding,0),l=2*s,c=document.createElement("canvas");c.width=1,c.height=1,c.style.font=i;var u=c.getContext("2d");defined(imageSmoothingEnabledName)||(defined(u.imageSmoothingEnabled)?imageSmoothingEnabledName="imageSmoothingEnabled":defined(u.mozImageSmoothingEnabled)?imageSmoothingEnabledName="mozImageSmoothingEnabled":defined(u.webkitImageSmoothingEnabled)?imageSmoothingEnabledName="webkitImageSmoothingEnabled":defined(u.msImageSmoothingEnabled)&&(imageSmoothingEnabledName="msImageSmoothingEnabled")),u.font=i,u.lineJoin="round",u.lineWidth=a,u[imageSmoothingEnabledName]=!1,u.textBaseline=defaultValue(t.textBaseline,"bottom"),c.style.visibility="hidden",document.body.appendChild(c);var d=measureText(u,e,r,n);c.dimensions=d,document.body.removeChild(c),c.style.visibility="";var h=-d.bounds.minx,p=Math.ceil(d.width)+h+l,m=d.height+l,l=m-(m-d.ascent+s)+l;return c.width=p,c.height=m,u.font=i,u.lineJoin="round",u.lineWidth=a,u[imageSmoothingEnabledName]=!1,o!==Color.TRANSPARENT&&(u.fillStyle=o.toCssColorString(),u.fillRect(0,0,c.width,c.height)),r&&(r=defaultValue(t.strokeColor,Color.BLACK),u.strokeStyle=r.toCssColorString(),u.strokeText(e,h+s,l)),n&&(t=defaultValue(t.fillColor,Color.WHITE),u.fillStyle=t.toCssColorString(),u.fillText(e,h+s,l)),c}}function PinBuilder(){this._cache={}}PinBuilder.prototype.fromColor=function(e,t){return createPin(void 0,void 0,e,t,this._cache)},PinBuilder.prototype.fromUrl=function(e,t,i){return createPin(e,void 0,t,i,this._cache)},PinBuilder.prototype.fromMakiIconId=function(e,t,i){return createPin(buildModuleUrl("Assets/Textures/maki/"+encodeURIComponent(e)+".png"),void 0,t,i,this._cache)},PinBuilder.prototype.fromText=function(e,t,i){return createPin(void 0,e,t,i,this._cache)};var colorScratch=new Color;function drawPin(e,t,i){e.save(),e.scale(i/24,i/24),e.fillStyle=t.toCssColorString(),e.strokeStyle=t.brighten(.6,colorScratch).toCssColorString(),e.lineWidth=.846,e.beginPath(),e.moveTo(6.72,.422),e.lineTo(17.28,.422),e.bezierCurveTo(18.553,.422,19.577,1.758,19.577,3.415),e.lineTo(19.577,10.973),e.bezierCurveTo(19.577,12.63,18.553,13.966,17.282,13.966),e.lineTo(14.386,14.008),e.lineTo(11.826,23.578),e.lineTo(9.614,14.008),e.lineTo(6.719,13.965),e.bezierCurveTo(5.446,13.983,4.422,12.629,4.422,10.972),e.lineTo(4.422,3.416),e.bezierCurveTo(4.423,1.76,5.447,.423,6.718,.423),e.closePath(),e.fill(),e.stroke(),e.restore()}function drawIcon(e,t,i){var r=i/2.5,n=r,a=r;t.width>t.height?a=r*(t.height/t.width):t.width<t.height&&(n=r*(t.width/t.height));r=Math.round((i-n)/2),i=Math.round(7/24*i-a/2);e.globalCompositeOperation="destination-out",e.drawImage(t,r-1,i,n,a),e.drawImage(t,r,i-1,n,a),e.drawImage(t,r+1,i,n,a),e.drawImage(t,r,i+1,n,a),e.globalCompositeOperation="destination-over",e.fillStyle=Color.BLACK.toCssColorString(),e.fillRect(r-1,i-1,n+2,a+2),e.globalCompositeOperation="destination-out",e.drawImage(t,r,i,n,a),e.globalCompositeOperation="destination-over",e.fillStyle=Color.WHITE.toCssColorString(),e.fillRect(r-1,i-2,n+2,a+2)}var stringifyScratch=new Array(4);function createPin(e,t,i,r,n){stringifyScratch[0]=e,stringifyScratch[1]=t,stringifyScratch[2]=i,stringifyScratch[3]=r;var a=JSON.stringify(stringifyScratch),o=n[a];if(defined(o))return o;var s=document.createElement("canvas");s.width=r,s.height=r;var l=s.getContext("2d");if(drawPin(l,i,r),defined(e)){e=Resource.createIfNeeded(e).fetchImage().then(function(e){return drawIcon(l,e,r),n[a]=s});return n[a]=e}return defined(t)&&(t=writeTextToCanvas(t,{font:"bold "+r+"px sans-serif"}),drawIcon(l,t,r)),n[a]=s}var PixelDatatype={UNSIGNED_BYTE:WebGLConstants$1.UNSIGNED_BYTE,UNSIGNED_SHORT:WebGLConstants$1.UNSIGNED_SHORT,UNSIGNED_INT:WebGLConstants$1.UNSIGNED_INT,FLOAT:WebGLConstants$1.FLOAT,HALF_FLOAT:WebGLConstants$1.HALF_FLOAT_OES,UNSIGNED_INT_24_8:WebGLConstants$1.UNSIGNED_INT_24_8,UNSIGNED_SHORT_4_4_4_4:WebGLConstants$1.UNSIGNED_SHORT_4_4_4_4,UNSIGNED_SHORT_5_5_5_1:WebGLConstants$1.UNSIGNED_SHORT_5_5_5_1,UNSIGNED_SHORT_5_6_5:WebGLConstants$1.UNSIGNED_SHORT_5_6_5,toWebGLConstant:function(e,t){switch(e){case PixelDatatype.UNSIGNED_BYTE:return WebGLConstants$1.UNSIGNED_BYTE;case PixelDatatype.UNSIGNED_SHORT:return WebGLConstants$1.UNSIGNED_SHORT;case PixelDatatype.UNSIGNED_INT:return WebGLConstants$1.UNSIGNED_INT;case PixelDatatype.FLOAT:return WebGLConstants$1.FLOAT;case PixelDatatype.HALF_FLOAT:return t.webgl2?WebGLConstants$1.HALF_FLOAT:WebGLConstants$1.HALF_FLOAT_OES;case PixelDatatype.UNSIGNED_INT_24_8:return WebGLConstants$1.UNSIGNED_INT_24_8;case PixelDatatype.UNSIGNED_SHORT_4_4_4_4:return WebGLConstants$1.UNSIGNED_SHORT_4_4_4_4;case PixelDatatype.UNSIGNED_SHORT_5_5_5_1:return WebGLConstants$1.UNSIGNED_SHORT_5_5_5_1;case PixelDatatype.UNSIGNED_SHORT_5_6_5:return PixelDatatype.UNSIGNED_SHORT_5_6_5}},isPacked:function(e){return e===PixelDatatype.UNSIGNED_INT_24_8||e===PixelDatatype.UNSIGNED_SHORT_4_4_4_4||e===PixelDatatype.UNSIGNED_SHORT_5_5_5_1||e===PixelDatatype.UNSIGNED_SHORT_5_6_5},sizeInBytes:function(e){switch(e){case PixelDatatype.UNSIGNED_BYTE:return 1;case PixelDatatype.UNSIGNED_SHORT:case PixelDatatype.UNSIGNED_SHORT_4_4_4_4:case PixelDatatype.UNSIGNED_SHORT_5_5_5_1:case PixelDatatype.UNSIGNED_SHORT_5_6_5:case PixelDatatype.HALF_FLOAT:return 2;case PixelDatatype.UNSIGNED_INT:case PixelDatatype.FLOAT:case PixelDatatype.UNSIGNED_INT_24_8:return 4}},validate:function(e){return e===PixelDatatype.UNSIGNED_BYTE||e===PixelDatatype.UNSIGNED_SHORT||e===PixelDatatype.UNSIGNED_INT||e===PixelDatatype.FLOAT||e===PixelDatatype.HALF_FLOAT||e===PixelDatatype.UNSIGNED_INT_24_8||e===PixelDatatype.UNSIGNED_SHORT_4_4_4_4||e===PixelDatatype.UNSIGNED_SHORT_5_5_5_1||e===PixelDatatype.UNSIGNED_SHORT_5_6_5}},PixelDatatype$1=Object.freeze(PixelDatatype),PixelFormat={DEPTH_COMPONENT:WebGLConstants$1.DEPTH_COMPONENT,DEPTH_STENCIL:WebGLConstants$1.DEPTH_STENCIL,ALPHA:WebGLConstants$1.ALPHA,RGB:WebGLConstants$1.RGB,RGBA:WebGLConstants$1.RGBA,LUMINANCE:WebGLConstants$1.LUMINANCE,LUMINANCE_ALPHA:WebGLConstants$1.LUMINANCE_ALPHA,RGB_DXT1:WebGLConstants$1.COMPRESSED_RGB_S3TC_DXT1_EXT,RGBA_DXT1:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT1_EXT,RGBA_DXT3:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT3_EXT,RGBA_DXT5:WebGLConstants$1.COMPRESSED_RGBA_S3TC_DXT5_EXT,RGB_PVRTC_4BPPV1:WebGLConstants$1.COMPRESSED_RGB_PVRTC_4BPPV1_IMG,RGB_PVRTC_2BPPV1:WebGLConstants$1.COMPRESSED_RGB_PVRTC_2BPPV1_IMG,RGBA_PVRTC_4BPPV1:WebGLConstants$1.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,RGBA_PVRTC_2BPPV1:WebGLConstants$1.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG,RGB_ETC1:WebGLConstants$1.COMPRESSED_RGB_ETC1_WEBGL,componentsLength:function(e){switch(e){case PixelFormat.RGB:return 3;case PixelFormat.RGBA:return 4;case PixelFormat.LUMINANCE_ALPHA:return 2;case PixelFormat.ALPHA:case PixelFormat.LUMINANCE:default:return 1}},validate:function(e){return e===PixelFormat.DEPTH_COMPONENT||e===PixelFormat.DEPTH_STENCIL||e===PixelFormat.ALPHA||e===PixelFormat.RGB||e===PixelFormat.RGBA||e===PixelFormat.LUMINANCE||e===PixelFormat.LUMINANCE_ALPHA||e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5||e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1||e===PixelFormat.RGB_ETC1},isColorFormat:function(e){return e===PixelFormat.ALPHA||e===PixelFormat.RGB||e===PixelFormat.RGBA||e===PixelFormat.LUMINANCE||e===PixelFormat.LUMINANCE_ALPHA},isDepthFormat:function(e){return e===PixelFormat.DEPTH_COMPONENT||e===PixelFormat.DEPTH_STENCIL},isCompressedFormat:function(e){return e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5||e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1||e===PixelFormat.RGB_ETC1},isDXTFormat:function(e){return e===PixelFormat.RGB_DXT1||e===PixelFormat.RGBA_DXT1||e===PixelFormat.RGBA_DXT3||e===PixelFormat.RGBA_DXT5},isPVRTCFormat:function(e){return e===PixelFormat.RGB_PVRTC_4BPPV1||e===PixelFormat.RGB_PVRTC_2BPPV1||e===PixelFormat.RGBA_PVRTC_4BPPV1||e===PixelFormat.RGBA_PVRTC_2BPPV1},isETC1Format:function(e){return e===PixelFormat.RGB_ETC1},compressedTextureSizeInBytes:function(e,t,i){switch(e){case PixelFormat.RGB_DXT1:case PixelFormat.RGBA_DXT1:case PixelFormat.RGB_ETC1:return Math.floor((t+3)/4)*Math.floor((i+3)/4)*8;case PixelFormat.RGBA_DXT3:case PixelFormat.RGBA_DXT5:return Math.floor((t+3)/4)*Math.floor((i+3)/4)*16;case PixelFormat.RGB_PVRTC_4BPPV1:case PixelFormat.RGBA_PVRTC_4BPPV1:return Math.floor((Math.max(t,8)*Math.max(i,8)*4+7)/8);case PixelFormat.RGB_PVRTC_2BPPV1:case PixelFormat.RGBA_PVRTC_2BPPV1:return Math.floor((Math.max(t,16)*Math.max(i,8)*2+7)/8);default:return 0}},textureSizeInBytes:function(e,t,i,r){e=PixelFormat.componentsLength(e);return PixelDatatype$1.isPacked(t)&&(e=1),e*PixelDatatype$1.sizeInBytes(t)*i*r},alignmentInBytes:function(e,t,i){i=PixelFormat.textureSizeInBytes(e,t,i,1)%4;return 0==i?4:2==i?2:1},createTypedArray:function(e,t,i,r){var n=PixelDatatype$1.sizeInBytes(t),t=n===Uint8Array.BYTES_PER_ELEMENT?Uint8Array:n===Uint16Array.BYTES_PER_ELEMENT?Uint16Array:n===Float32Array.BYTES_PER_ELEMENT&&t===PixelDatatype$1.FLOAT?Float32Array:Uint32Array;return new t(PixelFormat.componentsLength(e)*i*r)},flipY:function(e,t,i,r,n){if(1===n)return e;for(var a=PixelFormat.createTypedArray(t,i,r,n),o=PixelFormat.componentsLength(t),s=r*o,l=0;l<n;++l)for(var c=l*r*o,u=(n-l-1)*r*o,d=0;d<s;++d)a[u+d]=e[c+d];return a},toInternalFormat:function(e,t,i){if(!i.webgl2)return e;if(e===PixelFormat.DEPTH_STENCIL)return WebGLConstants$1.DEPTH24_STENCIL8;if(e===PixelFormat.DEPTH_COMPONENT){if(t===PixelDatatype$1.UNSIGNED_SHORT)return WebGLConstants$1.DEPTH_COMPONENT16;if(t===PixelDatatype$1.UNSIGNED_INT)return WebGLConstants$1.DEPTH_COMPONENT24}if(t===PixelDatatype$1.FLOAT)switch(e){case PixelFormat.RGBA:return WebGLConstants$1.RGBA32F;case PixelFormat.RGB:return WebGLConstants$1.RGB32F;case PixelFormat.RG:return WebGLConstants$1.RG32F;case PixelFormat.R:return WebGLConstants$1.R32F}if(t===PixelDatatype$1.HALF_FLOAT)switch(e){case PixelFormat.RGBA:return WebGLConstants$1.RGBA16F;case PixelFormat.RGB:return WebGLConstants$1.RGB16F;case PixelFormat.RG:return WebGLConstants$1.RG16F;case PixelFormat.R:return WebGLConstants$1.R16F}return e}},PixelFormat$1=Object.freeze(PixelFormat);function PlaneGeometry(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);e=defaultValue(e.vertexFormat,VertexFormat.DEFAULT);this._vertexFormat=e,this._workerName="createPlaneGeometry"}PlaneGeometry.packedLength=VertexFormat.packedLength,PlaneGeometry.pack=function(e,t,i){return i=defaultValue(i,0),VertexFormat.pack(e._vertexFormat,t,i),t};var scratchVertexFormat$7=new VertexFormat,scratchOptions$e={vertexFormat:scratchVertexFormat$7};PlaneGeometry.unpack=function(e,t,i){t=defaultValue(t,0);t=VertexFormat.unpack(e,t,scratchVertexFormat$7);return defined(i)?(i._vertexFormat=VertexFormat.clone(t,i._vertexFormat),i):new PlaneGeometry(scratchOptions$e)};var min=new Cartesian3(-.5,-.5,0),max=new Cartesian3(.5,.5,0);function PlaneOutlineGeometry(){this._workerName="createPlaneOutlineGeometry"}PlaneGeometry.createGeometry=function(e){var t,i,r=e._vertexFormat,n=new GeometryAttributes;return r.position&&((e=new Float64Array(12))[0]=min.x,e[1]=min.y,e[2]=0,e[3]=max.x,e[4]=min.y,e[5]=0,e[6]=max.x,e[7]=max.y,e[8]=0,e[9]=min.x,e[10]=max.y,e[11]=0,n.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e}),r.normal&&((e=new Float32Array(12))[0]=0,e[1]=0,e[2]=1,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=1,e[9]=0,e[10]=0,e[11]=1,n.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:e})),r.st&&((t=new Float32Array(8))[0]=0,t[1]=0,t[2]=1,t[3]=0,t[4]=1,t[5]=1,t[6]=0,t[7]=1,n.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:t})),r.tangent&&((t=new Float32Array(12))[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t[6]=1,t[7]=0,t[8]=0,t[9]=1,t[10]=0,t[11]=0,n.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t})),r.bitangent&&((i=new Float32Array(12))[0]=0,i[1]=1,i[2]=0,i[3]=0,i[4]=1,i[5]=0,i[6]=0,i[7]=1,i[8]=0,i[9]=0,i[10]=1,i[11]=0,n.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:i})),(i=new Uint16Array(6))[0]=0,i[1]=1,i[2]=2,i[3]=0,i[4]=2,i[5]=3),new Geometry({attributes:n,indices:i,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,Math.sqrt(2))})},PlaneOutlineGeometry.packedLength=0,PlaneOutlineGeometry.pack=function(e,t){return t},PlaneOutlineGeometry.unpack=function(e,t,i){return defined(i)?i:new PlaneOutlineGeometry};var min$1=new Cartesian3(-.5,-.5,0),max$1=new Cartesian3(.5,.5,0);PlaneOutlineGeometry.createGeometry=function(){var e=new GeometryAttributes,t=new Uint16Array(8),i=new Float64Array(12);return i[0]=min$1.x,i[1]=min$1.y,i[2]=min$1.z,i[3]=max$1.x,i[4]=min$1.y,i[5]=min$1.z,i[6]=max$1.x,i[7]=max$1.y,i[8]=min$1.z,i[9]=min$1.x,i[10]=max$1.y,i[11]=min$1.z,e.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:i}),t[0]=0,t[1]=1,t[2]=1,t[3]=2,t[4]=2,t[5]=3,t[6]=3,t[7]=0,new Geometry({attributes:e,indices:t,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere(Cartesian3.ZERO,Math.sqrt(2))})};var scratchCarto1=new Cartographic,scratchCarto2=new Cartographic;function adjustPosHeightsForNormal(e,t,i,r){var n=r.cartesianToCartographic(e,scratchCarto1).height,e=r.cartesianToCartographic(t,scratchCarto2);e.height=n,r.cartographicToCartesian(e,t);t=r.cartesianToCartographic(i,scratchCarto2);t.height=n-100,r.cartographicToCartesian(t,i)}var scratchBoundingRectangle=new BoundingRectangle,scratchPosition$2=new Cartesian3,scratchNormal$5=new Cartesian3,scratchTangent$3=new Cartesian3,scratchBitangent$3=new Cartesian3,p1Scratch$2=new Cartesian3,p2Scratch$2=new Cartesian3,scratchPerPosNormal=new Cartesian3,scratchPerPosTangent=new Cartesian3,scratchPerPosBitangent=new Cartesian3,appendTextureCoordinatesOrigin=new Cartesian2,appendTextureCoordinatesCartesian2=new Cartesian2,appendTextureCoordinatesCartesian3=new Cartesian3,appendTextureCoordinatesQuaternion=new Quaternion,appendTextureCoordinatesMatrix3=new Matrix3,tangentMatrixScratch$1=new Matrix3;function computeAttributes(e){var t=e.vertexFormat,i=e.geometry,r=e.shadowVolume,n=i.attributes.position.values,a=n.length,o=e.wall,s=e.top||o,l=e.bottom||o;if(t.st||t.normal||t.tangent||t.bitangent||r){var c=e.boundingRectangle,u=e.tangentPlane,d=e.ellipsoid,h=e.stRotation,p=e.perPositionHeight,m=appendTextureCoordinatesOrigin;m.x=c.x,m.y=c.y;var f,g=t.st?new Float32Array(a/3*2):void 0;t.normal&&(f=p&&s&&!o?i.attributes.normal.values:new Float32Array(a));var _,y=t.tangent?new Float32Array(a):void 0,C=t.bitangent?new Float32Array(a):void 0,v=r?new Float32Array(a):void 0,S=0,T=0,x=scratchNormal$5,b=scratchTangent$3,E=scratchBitangent$3,P=!0,A=appendTextureCoordinatesMatrix3,w=tangentMatrixScratch$1;w=0!==h?(_=Quaternion.fromAxisAngle(u._plane.normal,h,appendTextureCoordinatesQuaternion),A=Matrix3.fromQuaternion(_,A),_=Quaternion.fromAxisAngle(u._plane.normal,-h,appendTextureCoordinatesQuaternion),Matrix3.fromQuaternion(_,w)):(A=Matrix3.clone(Matrix3.IDENTITY,A),Matrix3.clone(Matrix3.IDENTITY,w));var D=0,M=0;s&&l&&(D=a/2,M=a/3,a/=2);for(var I=0;I<a;I+=3){var R,O,L,F,N=Cartesian3.fromArray(n,I,appendTextureCoordinatesCartesian3);t.st&&(R=Matrix3.multiplyByVector(A,N,scratchPosition$2),R=d.scaleToGeodeticSurface(R,R),O=u.projectPointOntoPlane(R,appendTextureCoordinatesCartesian2),Cartesian2.subtract(O,m,O),L=CesiumMath.clamp(O.x/c.width,0,1),F=CesiumMath.clamp(O.y/c.height,0,1),l&&(g[S+M]=L,g[S+1+M]=F),s&&(g[S]=L,g[S+1]=F),S+=2),(t.normal||t.tangent||t.bitangent||r)&&(R=T+1,O=T+2,o?(I+3<a&&(L=Cartesian3.fromArray(n,I+3,p1Scratch$2),P&&(F=Cartesian3.fromArray(n,I+a,p2Scratch$2),p&&adjustPosHeightsForNormal(N,L,F,d),Cartesian3.subtract(L,N,L),Cartesian3.subtract(F,N,F),x=Cartesian3.normalize(Cartesian3.cross(F,L,x),x),P=!1),Cartesian3.equalsEpsilon(L,N,CesiumMath.EPSILON10)&&(P=!0)),(t.tangent||t.bitangent)&&(E=d.geodeticSurfaceNormal(N,E),t.tangent&&(b=Cartesian3.normalize(Cartesian3.cross(E,x,b),b)))):(x=d.geodeticSurfaceNormal(N,x),(t.tangent||t.bitangent)&&(p&&(scratchPerPosNormal=Cartesian3.fromArray(f,T,scratchPerPosNormal),scratchPerPosTangent=Cartesian3.cross(Cartesian3.UNIT_Z,scratchPerPosNormal,scratchPerPosTangent),scratchPerPosTangent=Cartesian3.normalize(Matrix3.multiplyByVector(w,scratchPerPosTangent,scratchPerPosTangent),scratchPerPosTangent),t.bitangent&&(scratchPerPosBitangent=Cartesian3.normalize(Cartesian3.cross(scratchPerPosNormal,scratchPerPosTangent,scratchPerPosBitangent),scratchPerPosBitangent))),b=Cartesian3.cross(Cartesian3.UNIT_Z,x,b),b=Cartesian3.normalize(Matrix3.multiplyByVector(w,b,b),b),t.bitangent&&(E=Cartesian3.normalize(Cartesian3.cross(x,b,E),E)))),t.normal&&(e.wall?(f[T+D]=x.x,f[R+D]=x.y,f[O+D]=x.z):l&&(f[T+D]=-x.x,f[R+D]=-x.y,f[O+D]=-x.z),(s&&!p||o)&&(f[T]=x.x,f[R]=x.y,f[O]=x.z)),r&&(o&&(x=d.geodeticSurfaceNormal(N,x)),v[T+D]=-x.x,v[R+D]=-x.y,v[O+D]=-x.z),t.tangent&&(e.wall?(y[T+D]=b.x,y[R+D]=b.y,y[O+D]=b.z):l&&(y[T+D]=-b.x,y[R+D]=-b.y,y[O+D]=-b.z),s&&(p?(y[T]=scratchPerPosTangent.x,y[R]=scratchPerPosTangent.y,y[O]=scratchPerPosTangent.z):(y[T]=b.x,y[R]=b.y,y[O]=b.z))),t.bitangent&&(l&&(C[T+D]=E.x,C[R+D]=E.y,C[O+D]=E.z),s&&(p?(C[T]=scratchPerPosBitangent.x,C[R]=scratchPerPosBitangent.y,C[O]=scratchPerPosBitangent.z):(C[T]=E.x,C[R]=E.y,C[O]=E.z))),T+=3)}t.st&&(i.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:g})),t.normal&&(i.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:f})),t.tangent&&(i.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:y})),t.bitangent&&(i.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:C})),r&&(i.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:v}))}return e.extrude&&defined(e.offsetAttribute)&&(h=n.length/3,_=new Uint8Array(h),e.offsetAttribute===GeometryOffsetAttribute$1.TOP?s&&l||o?_=arrayFill(_,1,0,h/2):s&&(_=arrayFill(_,1)):_=arrayFill(_,e.offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),i.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:_})),i}var startCartographicScratch$1=new Cartographic,endCartographicScratch$1=new Cartographic,idlCross={westOverIDL:0,eastOverIDL:0},ellipsoidGeodesic$1=new EllipsoidGeodesic;function computeRectangle$2(e,t,i,r,n){if(n=defaultValue(n,new Rectangle),!defined(e)||e.length<3)return n.west=0,n.north=0,n.south=0,n.east=0,n;if(i===ArcType$1.RHUMB)return Rectangle.fromCartesianArray(e,t,n);ellipsoidGeodesic$1.ellipsoid.equals(t)||(ellipsoidGeodesic$1=new EllipsoidGeodesic(void 0,void 0,t)),n.west=Number.POSITIVE_INFINITY,n.east=Number.NEGATIVE_INFINITY,n.south=Number.POSITIVE_INFINITY,n.north=Number.NEGATIVE_INFINITY,idlCross.westOverIDL=Number.POSITIVE_INFINITY,idlCross.eastOverIDL=Number.NEGATIVE_INFINITY;for(var a,o=1/CesiumMath.chordLength(r,t.maximumRadius),s=e.length,l=t.cartesianToCartographic(e[0],endCartographicScratch$1),c=startCartographicScratch$1,u=1;u<s;u++)a=c,c=l,l=t.cartesianToCartographic(e[u],a),ellipsoidGeodesic$1.setEndPoints(c,l),interpolateAndGrowRectangle(ellipsoidGeodesic$1,o,n,idlCross);return a=c,c=l,l=t.cartesianToCartographic(e[0],a),ellipsoidGeodesic$1.setEndPoints(c,l),interpolateAndGrowRectangle(ellipsoidGeodesic$1,o,n,idlCross),n.east-n.west>idlCross.eastOverIDL-idlCross.westOverIDL&&(n.west=idlCross.westOverIDL,n.east=idlCross.eastOverIDL,n.east>CesiumMath.PI&&(n.east=n.east-CesiumMath.TWO_PI),n.west>CesiumMath.PI&&(n.west=n.west-CesiumMath.TWO_PI)),n}var interpolatedCartographicScratch$1=new Cartographic;function interpolateAndGrowRectangle(e,t,i,r){for(var n=e.surfaceDistance,a=Math.ceil(n*t),o=0<a?n/(a-1):Number.POSITIVE_INFINITY,s=0,l=0;l<a;l++){var c=e.interpolateUsingSurfaceDistance(s,interpolatedCartographicScratch$1);s+=o;var u=c.longitude,c=c.latitude;i.west=Math.min(i.west,u),i.east=Math.max(i.east,u),i.south=Math.min(i.south,c),i.north=Math.max(i.north,c);u=0<=u?u:u+CesiumMath.TWO_PI;r.westOverIDL=Math.min(r.westOverIDL,u),r.eastOverIDL=Math.max(r.eastOverIDL,u)}}var createGeometryFromPositionsExtrudedPositions=[];function createGeometryFromPositionsExtruded(e,t,i,r,n,a,o,s,l){var c={walls:[]};if(a||o){var u=PolygonGeometryLibrary.createGeometryFromPositions(e,t,i,n,s,l),t=u.attributes.position.values,d=u.indices;if(a&&o){var h,a=t.concat(t),p=a.length/3;(h=IndexDatatype$1.createTypedArray(p,2*d.length)).set(d);for(var m=d.length,f=p/2,g=0;g<m;g+=3){var _=h[g]+f,y=h[g+1]+f,C=h[g+2]+f;h[g+m]=C,h[g+1+m]=y,h[g+2+m]=_}u.attributes.position.values=a,n&&s.normal&&(s=u.attributes.normal.values,u.attributes.normal.values=new Float32Array(a.length),u.attributes.normal.values.set(s)),u.indices=h}else if(o){for(p=t.length/3,h=IndexDatatype$1.createTypedArray(p,d.length),g=0;g<d.length;g+=3)h[g]=d[g+2],h[g+1]=d[g+1],h[g+2]=d[g];u.indices=h}c.topAndBottom=new GeometryInstance({geometry:u})}var u=r.outerRing,v=EllipsoidTangentPlane.fromPoints(u,e).projectPointsOntoPlane(u,createGeometryFromPositionsExtrudedPositions);PolygonPipeline.computeWindingOrder2D(v)===WindingOrder$1.CLOCKWISE&&(u=u.slice().reverse());var S=PolygonGeometryLibrary.computeWallGeometry(u,e,i,n,l);c.walls.push(new GeometryInstance({geometry:S}));var T=r.holes;for(g=0;g<T.length;g++){var x=T[g],v=EllipsoidTangentPlane.fromPoints(x,e).projectPointsOntoPlane(x,createGeometryFromPositionsExtrudedPositions);PolygonPipeline.computeWindingOrder2D(v)===WindingOrder$1.COUNTER_CLOCKWISE&&(x=x.slice().reverse()),S=PolygonGeometryLibrary.computeWallGeometry(x,e,i,n,l),c.walls.push(new GeometryInstance({geometry:S}))}return c}function PolygonGeometry(e){var t,i=e.polygonHierarchy,r=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),n=defaultValue(e.ellipsoid,Ellipsoid.WGS84),a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),o=defaultValue(e.stRotation,0),s=defaultValue(e.perPositionHeight,!1),l=s&&defined(e.extrudedHeight),c=defaultValue(e.height,0),u=defaultValue(e.extrudedHeight,c);l||(t=Math.max(c,u),u=Math.min(c,u),c=t),this._vertexFormat=VertexFormat.clone(r),this._ellipsoid=Ellipsoid.clone(n),this._granularity=a,this._stRotation=o,this._height=c,this._extrudedHeight=u,this._closeTop=defaultValue(e.closeTop,!0),this._closeBottom=defaultValue(e.closeBottom,!0),this._polygonHierarchy=i,this._perPositionHeight=s,this._perPositionHeightExtrude=l,this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createPolygonGeometry",this._offsetAttribute=e.offsetAttribute,this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0,this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(i)+Ellipsoid.packedLength+VertexFormat.packedLength+12}PolygonGeometry.fromPositions=function(e){return new PolygonGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},height:e.height,extrudedHeight:e.extrudedHeight,vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight,closeTop:e.closeTop,closeBottom:e.closeBottom,offsetAttribute:e.offsetAttribute,arcType:e.arcType})},PolygonGeometry.pack=function(e,t,i){return i=defaultValue(i,0),i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i),Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._granularity,t[i++]=e._stRotation,t[i++]=e._perPositionHeightExtrude?1:0,t[i++]=e._perPositionHeight?1:0,t[i++]=e._closeTop?1:0,t[i++]=e._closeBottom?1:0,t[i++]=e._shadowVolume?1:0,t[i++]=defaultValue(e._offsetAttribute,-1),t[i++]=e._arcType,t[i]=e.packedLength,t};var scratchEllipsoid$5=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$8=new VertexFormat,dummyOptions={polygonHierarchy:{}};function textureCoordinateRotationPoints$1(e){var t=-e._stRotation;if(0==t)return[0,0,0,1,1,0];var i=e._ellipsoid,r=e._polygonHierarchy.positions,e=e.rectangle;return Geometry._textureCoordinateRotationPoints(r,t,i,e)}function PolygonHierarchy(e,t){this.positions=defined(e)?e:[],this.holes=defined(t)?t:[]}PolygonGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$5);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$8);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=1===e[t++],d=1===e[t++],h=1===e[t++],p=1===e[t++],m=1===e[t++],f=e[t++],g=e[t++],t=e[t];return defined(i)||(i=new PolygonGeometry(dummyOptions)),i._polygonHierarchy=r,i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._height=o,i._extrudedHeight=s,i._granularity=l,i._stRotation=c,i._perPositionHeightExtrude=u,i._perPositionHeight=d,i._closeTop=h,i._closeBottom=p,i._shadowVolume=m,i._offsetAttribute=-1===f?void 0:f,i._arcType=g,i.packedLength=t,i},PolygonGeometry.computeRectangle=function(e,t){var i=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),r=defaultValue(e.arcType,ArcType$1.GEODESIC),n=e.polygonHierarchy,e=defaultValue(e.ellipsoid,Ellipsoid.WGS84);return computeRectangle$2(n.positions,e,r,i,t)},PolygonGeometry.createGeometry=function(e){var t=e._vertexFormat,i=e._ellipsoid,r=e._granularity,n=e._stRotation,a=e._polygonHierarchy,o=e._perPositionHeight,s=e._closeTop,l=e._closeBottom,c=e._arcType,u=a.positions;if(!(u.length<3)){var d=EllipsoidTangentPlane.fromPoints(u,i),a=PolygonGeometryLibrary.polygonsFromHierarchy(a,d.projectPointsOntoPlane.bind(d),!o,i),h=a.hierarchy,p=a.polygons;if(0!==h.length){u=h[0].outerRing;var m,u=PolygonGeometryLibrary.computeBoundingRectangle(d.plane.normal,d.projectPointOntoPlane.bind(d),u,n,scratchBoundingRectangle),f=[],g=e._height,_=e._extrudedHeight,y={perPositionHeight:o,vertexFormat:t,geometry:void 0,tangentPlane:d,boundingRectangle:u,ellipsoid:i,stRotation:n,bottom:!1,top:!0,wall:!1,extrude:!1,arcType:c};if(e._perPositionHeightExtrude||!CesiumMath.equalsEpsilon(g,_,0,CesiumMath.EPSILON2))for(y.extrude=!0,y.top=s,y.bottom=l,y.shadowVolume=e._shadowVolume,y.offsetAttribute=e._offsetAttribute,m=0;m<p.length;m++){var C,v=createGeometryFromPositionsExtruded(i,p[m],r,h[m],o,s,l,t,c);s&&l?(C=v.topAndBottom,y.geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(C.geometry,g,_,i,o)):s?((C=v.topAndBottom).geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(C.geometry.attributes.position.values,g,i,!o),y.geometry=C.geometry):l&&((C=v.topAndBottom).geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(C.geometry.attributes.position.values,_,i,!0),y.geometry=C.geometry),(s||l)&&(y.wall=!1,C.geometry=computeAttributes(y),f.push(C));var S=v.walls;y.wall=!0;for(var T=0;T<S.length;T++){var x=S[T];y.geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(x.geometry,g,_,i,o),x.geometry=computeAttributes(y),f.push(x)}}else for(m=0;m<p.length;m++){var b,E=new GeometryInstance({geometry:PolygonGeometryLibrary.createGeometryFromPositions(i,p[m],r,o,t,c)});E.geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(E.geometry.attributes.position.values,g,i,!o),y.geometry=E.geometry,E.geometry=computeAttributes(y),defined(e._offsetAttribute)&&(b=E.geometry.attributes.position.values.length,arrayFill(b=new Uint8Array(b/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),E.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:b})),f.push(E)}d=GeometryPipeline.combineInstances(f)[0];d.attributes.position.values=new Float64Array(d.attributes.position.values),d.indices=IndexDatatype$1.createTypedArray(d.attributes.position.values.length/3,d.indices);u=d.attributes,n=BoundingSphere.fromVertices(u.position.values);return t.position||delete u.position,new Geometry({attributes:u,indices:d.indices,primitiveType:d.primitiveType,boundingSphere:n,offsetAttribute:e._offsetAttribute})}}},PolygonGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,t=t(r,n),i=i(r,n);return new PolygonGeometry({polygonHierarchy:e._polygonHierarchy,ellipsoid:n,stRotation:e._stRotation,granularity:r,perPositionHeight:!1,extrudedHeight:t,height:i,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0,arcType:e._arcType})},Object.defineProperties(PolygonGeometry.prototype,{rectangle:{get:function(){var e;return defined(this._rectangle)||(e=this._polygonHierarchy.positions,this._rectangle=computeRectangle$2(e,this._ellipsoid,this._arcType,this._granularity)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints$1(this)),this._textureCoordinateRotationPoints}}});var createGeometryFromPositionsPositions=[],createGeometryFromPositionsSubdivided=[];function createGeometryFromPositions$1(e,t,i,r,n){var a,o=EllipsoidTangentPlane.fromPoints(t,e).projectPointsOntoPlane(t,createGeometryFromPositionsPositions);PolygonPipeline.computeWindingOrder2D(o)===WindingOrder$1.CLOCKWISE&&(o.reverse(),t=t.slice().reverse());var s=t.length,l=0;if(r)for(a=new Float64Array(2*s*3),g=0;g<s;g++){var c=t[g],u=t[(g+1)%s];a[l++]=c.x,a[l++]=c.y,a[l++]=c.z,a[l++]=u.x,a[l++]=u.y,a[l++]=u.z}else{var d,h=0;if(n===ArcType$1.GEODESIC)for(g=0;g<s;g++)h+=PolygonGeometryLibrary.subdivideLineCount(t[g],t[(g+1)%s],i);else if(n===ArcType$1.RHUMB)for(g=0;g<s;g++)h+=PolygonGeometryLibrary.subdivideRhumbLineCount(e,t[g],t[(g+1)%s],i);for(a=new Float64Array(3*h),g=0;g<s;g++){n===ArcType$1.GEODESIC?d=PolygonGeometryLibrary.subdivideLine(t[g],t[(g+1)%s],i,createGeometryFromPositionsSubdivided):n===ArcType$1.RHUMB&&(d=PolygonGeometryLibrary.subdivideRhumbLine(e,t[g],t[(g+1)%s],i,createGeometryFromPositionsSubdivided));for(var p=d.length,m=0;m<p;++m)a[l++]=d[m]}}for(var r=2*(s=a.length/3),f=IndexDatatype$1.createTypedArray(s,r),l=0,g=0;g<s-1;g++)f[l++]=g,f[l++]=g+1;return f[l++]=s-1,f[l++]=0,new GeometryInstance({geometry:new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:f,primitiveType:PrimitiveType$1.LINES})})}function createGeometryFromPositionsExtruded$1(e,t,i,r,n){var a,o=EllipsoidTangentPlane.fromPoints(t,e).projectPointsOntoPlane(t,createGeometryFromPositionsPositions);PolygonPipeline.computeWindingOrder2D(o)===WindingOrder$1.CLOCKWISE&&(o.reverse(),t=t.slice().reverse());var s=t.length,l=new Array(s),c=0;if(r)for(a=new Float64Array(2*s*3*2),y=0;y<s;++y){l[y]=c/3;var u=t[y],d=t[(y+1)%s];a[c++]=u.x,a[c++]=u.y,a[c++]=u.z,a[c++]=d.x,a[c++]=d.y,a[c++]=d.z}else{var h,p=0;if(n===ArcType$1.GEODESIC)for(y=0;y<s;y++)p+=PolygonGeometryLibrary.subdivideLineCount(t[y],t[(y+1)%s],i);else if(n===ArcType$1.RHUMB)for(y=0;y<s;y++)p+=PolygonGeometryLibrary.subdivideRhumbLineCount(e,t[y],t[(y+1)%s],i);for(a=new Float64Array(3*p*2),y=0;y<s;++y){l[y]=c/3,n===ArcType$1.GEODESIC?h=PolygonGeometryLibrary.subdivideLine(t[y],t[(y+1)%s],i,createGeometryFromPositionsSubdivided):n===ArcType$1.RHUMB&&(h=PolygonGeometryLibrary.subdivideRhumbLine(e,t[y],t[(y+1)%s],i,createGeometryFromPositionsSubdivided));for(var m=h.length,f=0;f<m;++f)a[c++]=h[f]}}s=a.length/6;for(var g=l.length,r=2*(2*s+g),_=IndexDatatype$1.createTypedArray(s+g,r),c=0,y=0;y<s;++y)_[c++]=y,_[c++]=(y+1)%s,_[c++]=y+s,_[c++]=(y+1)%s+s;for(y=0;y<g;y++){var C=l[y];_[c++]=C,_[c++]=C+s}return new GeometryInstance({geometry:new Geometry({attributes:new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:a})}),indices:_,primitiveType:PrimitiveType$1.LINES})})}function PolygonOutlineGeometry(e){var t,i=e.polygonHierarchy,r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),a=defaultValue(e.perPositionHeight,!1),o=a&&defined(e.extrudedHeight),s=defaultValue(e.arcType,ArcType$1.GEODESIC),l=defaultValue(e.height,0),c=defaultValue(e.extrudedHeight,l);o||(t=Math.max(l,c),c=Math.min(l,c),l=t),this._ellipsoid=Ellipsoid.clone(r),this._granularity=n,this._height=l,this._extrudedHeight=c,this._arcType=s,this._polygonHierarchy=i,this._perPositionHeight=a,this._perPositionHeightExtrude=o,this._offsetAttribute=e.offsetAttribute,this._workerName="createPolygonOutlineGeometry",this.packedLength=PolygonGeometryLibrary.computeHierarchyPackedLength(i)+Ellipsoid.packedLength+8}PolygonOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),i=PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,i),Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._granularity,t[i++]=e._perPositionHeightExtrude?1:0,t[i++]=e._perPositionHeight?1:0,t[i++]=e._arcType,t[i++]=defaultValue(e._offsetAttribute,-1),t[i]=e.packedLength,t};var scratchEllipsoid$6=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),dummyOptions$1={polygonHierarchy:{}};PolygonOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=PolygonGeometryLibrary.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$6);t+=Ellipsoid.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=1===e[t++],c=1===e[t++],u=e[t++],d=e[t++],t=e[t];return defined(i)||(i=new PolygonOutlineGeometry(dummyOptions$1)),i._polygonHierarchy=r,i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._height=a,i._extrudedHeight=o,i._granularity=s,i._perPositionHeight=c,i._perPositionHeightExtrude=l,i._arcType=u,i._offsetAttribute=-1===d?void 0:d,i.packedLength=t,i},PolygonOutlineGeometry.fromPositions=function(e){return new PolygonOutlineGeometry({polygonHierarchy:{positions:(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions},height:e.height,extrudedHeight:e.extrudedHeight,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight,arcType:e.arcType,offsetAttribute:e.offsetAttribute})},PolygonOutlineGeometry.createGeometry=function(e){var t=e._ellipsoid,i=e._granularity,r=e._polygonHierarchy,n=e._perPositionHeight,a=e._arcType,o=PolygonGeometryLibrary.polygonOutlinesFromHierarchy(r,!n,t);if(0!==o.length){var s,l,c,u,d,h=[],p=CesiumMath.chordLength(i,t.maximumRadius),m=e._height,f=e._extrudedHeight;if(e._perPositionHeightExtrude||!CesiumMath.equalsEpsilon(m,f,0,CesiumMath.EPSILON2))for(s=0;s<o.length;s++)(u=createGeometryFromPositionsExtruded$1(t,o[s],p,n,a)).geometry=PolygonGeometryLibrary.scaleToGeodeticHeightExtruded(u.geometry,m,f,t,n),defined(e._offsetAttribute)&&(l=u.geometry.attributes.position.values.length/3,c=new Uint8Array(l),c=e._offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(c,1,0,l/2):arrayFill(c,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),u.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:c})),h.push(u);else for(s=0;s<o.length;s++)(u=createGeometryFromPositions$1(t,o[s],p,n,a)).geometry.attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(u.geometry.attributes.position.values,m,t,!n),defined(e._offsetAttribute)&&(d=u.geometry.attributes.position.values.length,arrayFill(d=new Uint8Array(d/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),u.geometry.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:d})),h.push(u);r=GeometryPipeline.combineInstances(h)[0],i=BoundingSphere.fromVertices(r.attributes.position.values);return new Geometry({attributes:r.attributes,indices:r.indices,primitiveType:r.primitiveType,boundingSphere:i,offsetAttribute:e._offsetAttribute})}};var scratchInterpolateColorsArray=[];function interpolateColors(e,t,i,r,n){var a=scratchInterpolateColorsArray;a.length=n;var o=i.red,s=i.green,l=i.blue,c=i.alpha,u=r.red,d=r.green,h=r.blue,p=r.alpha;if(Color.equals(i,r)){for(y=0;y<n;y++)a[y]=Color.clone(i);return a}for(var m=(u-o)/n,f=(d-s)/n,g=(h-l)/n,_=(p-c)/n,y=0;y<n;y++)a[y]=new Color(o+y*m,s+y*f,l+y*g,c+y*_);return a}function PolylineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.colors,r=defaultValue(e.width,1),n=defaultValue(e.colorsPerVertex,!1);this._positions=t,this._colors=i,this._width=r,this._colorsPerVertex=n,this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._workerName="createPolylineGeometry";t=1+t.length*Cartesian3.packedLength;t+=defined(i)?1+i.length*Color.packedLength:1,this.packedLength=t+Ellipsoid.packedLength+VertexFormat.packedLength+4}PolylineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._colors,a=defined(o)?o.length:0;for(t[i++]=a,r=0;r<a;++r,i+=Color.packedLength)Color.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._width,t[i++]=e._colorsPerVertex?1:0,t[i++]=e._arcType,t[i]=e._granularity,t};var scratchEllipsoid$7=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$9=new VertexFormat,scratchOptions$f={positions:void 0,colors:void 0,ellipsoid:scratchEllipsoid$7,vertexFormat:scratchVertexFormat$9,width:void 0,colorsPerVertex:void 0,arcType:void 0,granularity:void 0};PolylineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var o=0<(r=e[t++])?new Array(r):void 0;for(a=0;a<r;++a,t+=Color.packedLength)o[a]=Color.unpack(e,t);var s=Ellipsoid.unpack(e,t,scratchEllipsoid$7);t+=Ellipsoid.packedLength;var l=VertexFormat.unpack(e,t,scratchVertexFormat$9);t+=VertexFormat.packedLength;var c=e[t++],u=1===e[t++],d=e[t++],h=e[t];return defined(i)?(i._positions=n,i._colors=o,i._ellipsoid=Ellipsoid.clone(s,i._ellipsoid),i._vertexFormat=VertexFormat.clone(l,i._vertexFormat),i._width=c,i._colorsPerVertex=u,i._arcType=d,i._granularity=h,i):(scratchOptions$f.positions=n,scratchOptions$f.colors=o,scratchOptions$f.width=c,scratchOptions$f.colorsPerVertex=u,scratchOptions$f.arcType=d,scratchOptions$f.granularity=h,new PolylineGeometry(scratchOptions$f))};var scratchCartesian3$8=new Cartesian3,scratchPosition$3=new Cartesian3,scratchPrevPosition=new Cartesian3,scratchNextPosition=new Cartesian3;function computeAttributes$1(e,t,i,r){var n=new GeometryAttributes;r.position&&(n.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e}));var a,o,s,l,c,u=t.length,d=e.length/3,h=(d-2*u)/(2*u),p=PolygonPipeline.triangulate(t),m=(h-1)*u*6+2*p.length,f=IndexDatatype$1.createTypedArray(d,m),g=2*u,_=0;for(E=0;E<h-1;E++){for(a=0;a<u-1;a++)c=(o=2*a+E*u*2)+g,l=(s=o+1)+g,f[_++]=s,f[_++]=o,f[_++]=l,f[_++]=l,f[_++]=o,f[_++]=c;l=(s=(o=2*u-2+E*u*2)+1)+g,c=o+g,f[_++]=s,f[_++]=o,f[_++]=l,f[_++]=l,f[_++]=o,f[_++]=c}if(r.st||r.tangent||r.bitangent){for(var y,C,v=new Float32Array(2*d),S=1/(h-1),T=1/i.height,x=i.height/2,b=0,E=0;E<h;E++){for(y=E*S,C=T*(t[0].y+x),v[b++]=y,v[b++]=C,a=1;a<u;a++)C=T*(t[a].y+x),v[b++]=y,v[b++]=C,v[b++]=y,v[b++]=C;C=T*(t[0].y+x),v[b++]=y,v[b++]=C}for(a=0;a<u;a++)y=0,C=T*(t[a].y+x),v[b++]=y,v[b++]=C;for(a=0;a<u;a++)y=(h-1)*S,C=T*(t[a].y+x),v[b++]=y,v[b++]=C;n.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:new Float32Array(v)})}var P=d-2*u;for(E=0;E<p.length;E+=3){var A=p[E]+P,w=p[E+1]+P,D=p[E+2]+P;f[_++]=A,f[_++]=w,f[_++]=D,f[_++]=D+u,f[_++]=w+u,f[_++]=A+u}var M=new Geometry({attributes:n,indices:f,boundingSphere:BoundingSphere.fromVertices(e),primitiveType:PrimitiveType$1.TRIANGLES});if(r.normal&&(M=GeometryPipeline.computeNormal(M)),r.tangent||r.bitangent){try{M=GeometryPipeline.computeTangentAndBitangent(M)}catch(e){oneTimeWarning("polyline-volume-tangent-bitangent","Unable to compute tangents and bitangents for polyline volume geometry")}r.tangent||(M.attributes.tangent=void 0),r.bitangent||(M.attributes.bitangent=void 0),r.st||(M.attributes.st=void 0)}return M}function PolylineVolumeGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polylinePositions,i=e.shapePositions;this._positions=t,this._shape=i,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeGeometry";t=1+t.length*Cartesian3.packedLength;t+=1+i.length*Cartesian2.packedLength,this.packedLength=t+Ellipsoid.packedLength+VertexFormat.packedLength+2}PolylineGeometry.createGeometry=function(e){var t=e._width,i=e._vertexFormat,r=e._colors,n=e._colorsPerVertex,a=e._arcType,o=e._granularity,s=e._ellipsoid,l=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon),c=l.length;if(!(c<2||t<=0)){if(a===ArcType$1.GEODESIC||a===ArcType$1.RHUMB){var u,d=a===ArcType$1.GEODESIC?(u=CesiumMath.chordLength(o,s.maximumRadius),PolylinePipeline.numberOfPoints):(u=o,PolylinePipeline.numberOfPointsRhumbLine),h=PolylinePipeline.extractHeights(l,s);if(defined(r)){for(var p=1,m=0;m<c-1;++m)p+=d(l[m],l[m+1],u);var f=new Array(p),g=0;for(m=0;m<c-1;++m){var _=l[m],y=l[m+1],C=r[m],v=d(_,y,u);if(n&&m<p)for(var S=interpolateColors(_,y,C,r[m+1],v),T=S.length,x=0;x<T;++x)f[g++]=S[x];else for(x=0;x<v;++x)f[g++]=Color.clone(C)}f[g]=Color.clone(r[r.length-1]),r=f,scratchInterpolateColorsArray.length=0}l=a===ArcType$1.GEODESIC?PolylinePipeline.generateCartesianArc({positions:l,minDistance:u,ellipsoid:s,height:h}):PolylinePipeline.generateCartesianRhumbArc({positions:l,granularity:u,ellipsoid:s,height:h})}var b,E,P,s=4*(c=l.length)-4,A=new Float64Array(3*s),w=new Float64Array(3*s),D=new Float64Array(3*s),M=new Float32Array(2*s),I=i.st?new Float32Array(2*s):void 0,R=defined(r)?new Uint8Array(4*s):void 0,O=0,L=0,F=0,N=0;for(x=0;x<c;++x){0===x?(b=scratchCartesian3$8,Cartesian3.subtract(l[0],l[1],b),Cartesian3.add(l[0],b,b)):b=l[x-1],Cartesian3.clone(b,scratchPrevPosition),Cartesian3.clone(l[x],scratchPosition$3),x===c-1?(b=scratchCartesian3$8,Cartesian3.subtract(l[c-1],l[c-2],b),Cartesian3.add(l[c-1],b,b)):b=l[x+1],Cartesian3.clone(b,scratchNextPosition),defined(R)&&(E=0===x||n?r[x]:r[x-1],x!==c-1&&(P=r[x]));for(var B=x===c-1?2:4,V=0===x?2:0;V<B;++V){Cartesian3.pack(scratchPosition$3,A,O),Cartesian3.pack(scratchPrevPosition,w,O),Cartesian3.pack(scratchNextPosition,D,O),O+=3;var k=V-2<0?-1:1;M[L++]=V%2*2-1,M[L++]=k*t,i.st&&(I[F++]=x/(c-1),I[F++]=Math.max(M[L-2],0)),defined(R)&&(k=V<2?E:P,R[N++]=Color.floatToByte(k.red),R[N++]=Color.floatToByte(k.green),R[N++]=Color.floatToByte(k.blue),R[N++]=Color.floatToByte(k.alpha))}}h=new GeometryAttributes;h.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:A}),h.prevPosition=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:w}),h.nextPosition=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:D}),h.expandAndWidth=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:M}),i.st&&(h.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:I})),defined(R)&&(h.color=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:4,values:R,normalize:!0}));var z=IndexDatatype$1.createTypedArray(s,6*c-6),U=0,$=0,G=c-1;for(x=0;x<G;++x)z[$++]=U,z[$++]=U+2,z[$++]=U+1,z[$++]=U+1,z[$++]=U+2,z[$++]=U+3,U+=4;return new Geometry({attributes:h,indices:z,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:BoundingSphere.fromPoints(l),geometryType:GeometryType$1.POLYLINES})}},PolylineVolumeGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._shape,a=o.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian2.packedLength)Cartesian2.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._cornerType,t[i]=e._granularity,t};var scratchEllipsoid$8=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$a=new VertexFormat,scratchOptions$g={polylinePositions:void 0,shapePositions:void 0,ellipsoid:scratchEllipsoid$8,vertexFormat:scratchVertexFormat$a,cornerType:void 0,granularity:void 0};PolylineVolumeGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);r=e[t++];var o=new Array(r);for(a=0;a<r;++a,t+=Cartesian2.packedLength)o[a]=Cartesian2.unpack(e,t);var s=Ellipsoid.unpack(e,t,scratchEllipsoid$8);t+=Ellipsoid.packedLength;var l=VertexFormat.unpack(e,t,scratchVertexFormat$a);t+=VertexFormat.packedLength;var c=e[t++],u=e[t];return defined(i)?(i._positions=n,i._shape=o,i._ellipsoid=Ellipsoid.clone(s,i._ellipsoid),i._vertexFormat=VertexFormat.clone(l,i._vertexFormat),i._cornerType=c,i._granularity=u,i):(scratchOptions$g.polylinePositions=n,scratchOptions$g.shapePositions=o,scratchOptions$g.cornerType=c,scratchOptions$g.granularity=u,new PolylineVolumeGeometry(scratchOptions$g))};var brScratch=new BoundingRectangle;function computeAttributes$2(e,t){var i=new GeometryAttributes;i.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:e});var r=t.length,t=i.position.values.length/3,n=e.length/3/r,a=IndexDatatype$1.createTypedArray(t,2*r*(1+n)),o=0,s=0,l=s*r;for(d=0;d<r-1;d++)a[o++]=d+l,a[o++]=d+l+1;for(a[o++]=r-1+l,a[o++]=l,l=(s=n-1)*r,d=0;d<r-1;d++)a[o++]=d+l,a[o++]=d+l+1;for(a[o++]=r-1+l,a[o++]=l,s=0;s<n-1;s++)for(var c=r*s,u=c+r,d=0;d<r;d++)a[o++]=d+c,a[o++]=d+u;return new Geometry({attributes:i,indices:IndexDatatype$1.createTypedArray(t,a),boundingSphere:BoundingSphere.fromVertices(e),primitiveType:PrimitiveType$1.LINES})}function PolylineVolumeOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).polylinePositions,i=e.shapePositions;this._positions=t,this._shape=i,this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._cornerType=defaultValue(e.cornerType,CornerType$1.ROUNDED),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeOutlineGeometry";t=1+t.length*Cartesian3.packedLength;t+=1+i.length*Cartesian2.packedLength,this.packedLength=t+Ellipsoid.packedLength+2}PolylineVolumeGeometry.createGeometry=function(e){var t=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon),i=e._shape,i=PolylineVolumeGeometryLibrary.removeDuplicatesFromShape(i);if(!(t.length<2||i.length<3)){PolygonPipeline.computeWindingOrder2D(i)===WindingOrder$1.CLOCKWISE&&i.reverse();var r=BoundingRectangle.fromPoints(i,brScratch);return computeAttributes$1(PolylineVolumeGeometryLibrary.computePositions(t,i,r,e,!0),i,r,e._vertexFormat)}},PolylineVolumeOutlineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._shape,a=o.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian2.packedLength)Cartesian2.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._cornerType,t[i]=e._granularity,t};var scratchEllipsoid$9=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$h={polylinePositions:void 0,shapePositions:void 0,ellipsoid:scratchEllipsoid$9,height:void 0,cornerType:void 0,granularity:void 0};PolylineVolumeOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);r=e[t++];var o=new Array(r);for(a=0;a<r;++a,t+=Cartesian2.packedLength)o[a]=Cartesian2.unpack(e,t);var s=Ellipsoid.unpack(e,t,scratchEllipsoid$9);t+=Ellipsoid.packedLength;var l=e[t++],c=e[t];return defined(i)?(i._positions=n,i._shape=o,i._ellipsoid=Ellipsoid.clone(s,i._ellipsoid),i._cornerType=l,i._granularity=c,i):(scratchOptions$h.polylinePositions=n,scratchOptions$h.shapePositions=o,scratchOptions$h.cornerType=l,scratchOptions$h.granularity=c,new PolylineVolumeOutlineGeometry(scratchOptions$h))};var brScratch$1=new BoundingRectangle;function Proxy(){DeveloperError.throwInstantiationError()}function createEvaluateFunction$1(n){var a=n.points,o=n.times;return function(e,t){defined(t)||(t=new Quaternion);var i=n._lastTimeIndex=n.findTimeInterval(e,n._lastTimeIndex),r=(e-o[i])/(o[i+1]-o[i]),e=a[i],i=a[i+1];return Quaternion.fastSlerp(e,i,r,t)}}function QuaternionSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).points,e=e.times;this._times=e,this._points=t,this._evaluateFunction=createEvaluateFunction$1(this),this._lastTimeIndex=0}function quickselect(e,t,i,r,n){quickselectStep(e,t,i||0,r||e.length-1,n||defaultCompare)}function quickselectStep(e,t,i,r,n){for(;i<r;){var a,o,s,l;600<r-i&&(a=r-i+1,o=t-i+1,l=Math.log(a),s=.5*Math.exp(2*l/3),l=.5*Math.sqrt(l*s*(a-s)/a)*(o-a/2<0?-1:1),quickselectStep(e,t,Math.max(i,Math.floor(t-o*s/a+l)),Math.min(r,Math.floor(t+(a-o)*s/a+l)),n));var c=e[t],u=i,d=r;for(swap$1(e,i,t),0<n(e[r],c)&&swap$1(e,i,r);u<d;){for(swap$1(e,u,d),u++,d--;n(e[u],c)<0;)u++;for(;0<n(e[d],c);)d--}0===n(e[i],c)?swap$1(e,i,d):swap$1(e,++d,r),d<=t&&(i=d+1),t<=d&&(r=d-1)}}function swap$1(e,t,i){var r=e[t];e[t]=e[i],e[i]=r}function defaultCompare(e,t){return e<t?-1:t<e?1:0}function RBush(e){void 0===e&&(e=9),this._maxEntries=Math.max(4,e),this._minEntries=Math.max(2,Math.ceil(.4*this._maxEntries)),this.clear()}function findItem(e,t,i){if(!i)return t.indexOf(e);for(var r=0;r<t.length;r++)if(i(e,t[r]))return r;return-1}function calcBBox(e,t){distBBox(e,0,e.children.length,t,e)}function distBBox(e,t,i,r,n){(n=n||createNode(null)).minX=1/0,n.minY=1/0,n.maxX=-1/0,n.maxY=-1/0;for(var a=t;a<i;a++){var o=e.children[a];extend(n,e.leaf?r(o):o)}return n}function extend(e,t){return e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),e}function compareNodeMinX(e,t){return e.minX-t.minX}function compareNodeMinY(e,t){return e.minY-t.minY}function bboxArea(e){return(e.maxX-e.minX)*(e.maxY-e.minY)}function bboxMargin(e){return e.maxX-e.minX+(e.maxY-e.minY)}function enlargedArea(e,t){return(Math.max(t.maxX,e.maxX)-Math.min(t.minX,e.minX))*(Math.max(t.maxY,e.maxY)-Math.min(t.minY,e.minY))}function intersectionArea(e,t){var i=Math.max(e.minX,t.minX),r=Math.max(e.minY,t.minY),n=Math.min(e.maxX,t.maxX),t=Math.min(e.maxY,t.maxY);return Math.max(0,n-i)*Math.max(0,t-r)}function contains(e,t){return e.minX<=t.minX&&e.minY<=t.minY&&t.maxX<=e.maxX&&t.maxY<=e.maxY}function intersects$1(e,t){return t.minX<=e.maxX&&t.minY<=e.maxY&&t.maxX>=e.minX&&t.maxY>=e.minY}function createNode(e){return{children:e,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function multiSelect(e,t,i,r,n){for(var a,o=[t,i];o.length;)(i=o.pop())-(t=o.pop())<=r||(quickselect(e,a=t+Math.ceil((i-t)/r/2)*r,t,i,n),o.push(t,a,a,i))}function RectangleCollisionChecker(){this._tree=new RBush}function RectangleWithId(){this.minX=0,this.minY=0,this.maxX=0,this.maxY=0,this.id=""}function idCompare(e,t){return e.id===t.id}PolylineVolumeOutlineGeometry.createGeometry=function(e){var t=arrayRemoveDuplicates(e._positions,Cartesian3.equalsEpsilon),i=e._shape,i=PolylineVolumeGeometryLibrary.removeDuplicatesFromShape(i);if(!(t.length<2||i.length<3)){PolygonPipeline.computeWindingOrder2D(i)===WindingOrder$1.CLOCKWISE&&i.reverse();var r=BoundingRectangle.fromPoints(i,brScratch$1);return computeAttributes$2(PolylineVolumeGeometryLibrary.computePositions(t,i,r,e,!1),i)}},Proxy.prototype.getURL=DeveloperError.throwInstantiationError,Object.defineProperties(QuaternionSpline.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}}),QuaternionSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,QuaternionSpline.prototype.wrapTime=Spline.prototype.wrapTime,QuaternionSpline.prototype.clampTime=Spline.prototype.clampTime,QuaternionSpline.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},RBush.prototype.all=function(){return this._all(this.data,[])},RBush.prototype.search=function(e){var t=this.data,i=[];if(!intersects$1(e,t))return i;for(var r=this.toBBox,n=[];t;){for(var a=0;a<t.children.length;a++){var o=t.children[a],s=t.leaf?r(o):o;intersects$1(e,s)&&(t.leaf?i.push(o):contains(e,s)?this._all(o,i):n.push(o))}t=n.pop()}return i},RBush.prototype.collides=function(e){var t=this.data;if(!intersects$1(e,t))return!1;for(var i=[];t;){for(var r=0;r<t.children.length;r++){var n=t.children[r],a=t.leaf?this.toBBox(n):n;if(intersects$1(e,a)){if(t.leaf||contains(e,a))return!0;i.push(n)}}t=i.pop()}return!1},RBush.prototype.load=function(e){if(!e||!e.length)return this;if(e.length<this._minEntries){for(var t=0;t<e.length;t++)this.insert(e[t]);return this}var i,r=this._build(e.slice(),0,e.length-1,0);return this.data.children.length?this.data.height===r.height?this._splitRoot(this.data,r):(this.data.height<r.height&&(i=this.data,this.data=r,r=i),this._insert(r,this.data.height-r.height-1,!0)):this.data=r,this},RBush.prototype.insert=function(e){return e&&this._insert(e,this.data.height-1),this},RBush.prototype.clear=function(){return this.data=createNode([]),this},RBush.prototype.remove=function(e,t){if(!e)return this;for(var i,r,n,a=this.data,o=this.toBBox(e),s=[],l=[];a||s.length;){if(a||(a=s.pop(),r=s[s.length-1],i=l.pop(),n=!0),a.leaf){var c=findItem(e,a.children,t);if(-1!==c)return a.children.splice(c,1),s.push(a),this._condense(s),this}n||a.leaf||!contains(a,o)?r?(i++,a=r.children[i],n=!1):a=null:(s.push(a),l.push(i),i=0,a=(r=a).children[0])}return this},RBush.prototype.toBBox=function(e){return e},RBush.prototype.compareMinX=function(e,t){return e.minX-t.minX},RBush.prototype.compareMinY=function(e,t){return e.minY-t.minY},RBush.prototype.toJSON=function(){return this.data},RBush.prototype.fromJSON=function(e){return this.data=e,this},RBush.prototype._all=function(e,t){for(var i=[];e;)e.leaf?t.push.apply(t,e.children):i.push.apply(i,e.children),e=i.pop();return t},RBush.prototype._build=function(e,t,i,r){var n,a=i-t+1,o=this._maxEntries;if(a<=o)return calcBBox(n=createNode(e.slice(t,i+1)),this.toBBox),n;r||(r=Math.ceil(Math.log(a)/Math.log(o)),o=Math.ceil(a/Math.pow(o,r-1))),(n=createNode([])).leaf=!1,n.height=r;var s=Math.ceil(a/o),l=s*Math.ceil(Math.sqrt(o));multiSelect(e,t,i,l,this.compareMinX);for(var c=t;c<=i;c+=l){var u=Math.min(c+l-1,i);multiSelect(e,c,u,s,this.compareMinY);for(var d=c;d<=u;d+=s){var h=Math.min(d+s-1,u);n.children.push(this._build(e,d,h,r-1))}}return calcBBox(n,this.toBBox),n},RBush.prototype._chooseSubtree=function(e,t,i,r){for(;r.push(t),!t.leaf&&r.length-1!==i;){for(var n=1/0,a=1/0,o=void 0,s=0;s<t.children.length;s++){var l=t.children[s],c=bboxArea(l),u=enlargedArea(e,l)-c;u<a?(a=u,n=c<n?c:n,o=l):u===a&&c<n&&(n=c,o=l)}t=o||t.children[0]}return t},RBush.prototype._insert=function(e,t,i){var r=i?e:this.toBBox(e),n=[],i=this._chooseSubtree(r,this.data,t,n);for(i.children.push(e),extend(i,r);0<=t&&n[t].children.length>this._maxEntries;)this._split(n,t),t--;this._adjustParentBBoxes(r,n,t)},RBush.prototype._split=function(e,t){var i=e[t],r=i.children.length,n=this._minEntries;this._chooseSplitAxis(i,n,r);r=this._chooseSplitIndex(i,n,r),r=createNode(i.children.splice(r,i.children.length-r));r.height=i.height,r.leaf=i.leaf,calcBBox(i,this.toBBox),calcBBox(r,this.toBBox),t?e[t-1].children.push(r):this._splitRoot(i,r)},RBush.prototype._splitRoot=function(e,t){this.data=createNode([e,t]),this.data.height=e.height+1,this.data.leaf=!1,calcBBox(this.data,this.toBBox)},RBush.prototype._chooseSplitIndex=function(e,t,i){for(var r,n=1/0,a=1/0,o=t;o<=i-t;o++){var s=distBBox(e,0,o,this.toBBox),l=distBBox(e,o,i,this.toBBox),c=intersectionArea(s,l),l=bboxArea(s)+bboxArea(l);c<n?(n=c,r=o,a=l<a?l:a):c===n&&l<a&&(a=l,r=o)}return r||i-t},RBush.prototype._chooseSplitAxis=function(e,t,i){var r=e.leaf?this.compareMinX:compareNodeMinX,n=e.leaf?this.compareMinY:compareNodeMinY;this._allDistMargin(e,t,i,r)<this._allDistMargin(e,t,i,n)&&e.children.sort(r)},RBush.prototype._allDistMargin=function(e,t,i,r){e.children.sort(r);for(var n=this.toBBox,a=distBBox(e,0,t,n),o=distBBox(e,i-t,i,n),s=bboxMargin(a)+bboxMargin(o),l=t;l<i-t;l++){var c=e.children[l];extend(a,e.leaf?n(c):c),s+=bboxMargin(a)}for(var u=i-t-1;t<=u;u--){var d=e.children[u];extend(o,e.leaf?n(d):d),s+=bboxMargin(o)}return s},RBush.prototype._adjustParentBBoxes=function(e,t,i){for(var r=i;0<=r;r--)extend(t[r],e)},RBush.prototype._condense=function(e){for(var t=e.length-1,i=void 0;0<=t;t--)0===e[t].children.length?0<t?(i=e[t-1].children).splice(i.indexOf(e[t]),1):this.clear():calcBBox(e[t],this.toBBox)},RectangleWithId.fromRectangleAndId=function(e,t,i){return i.minX=t.west,i.minY=t.south,i.maxX=t.east,i.maxY=t.north,i.id=e,i},RectangleCollisionChecker.prototype.insert=function(e,t){t=RectangleWithId.fromRectangleAndId(e,t,new RectangleWithId);this._tree.insert(t)};var removalScratch=new RectangleWithId;RectangleCollisionChecker.prototype.remove=function(e,t){t=RectangleWithId.fromRectangleAndId(e,t,removalScratch);this._tree.remove(t,idCompare)};var collisionScratch=new RectangleWithId;RectangleCollisionChecker.prototype.collides=function(e){e=RectangleWithId.fromRectangleAndId("",e,collisionScratch);return this._tree.collides(e)};var cos$2=Math.cos,sin$2=Math.sin,sqrt=Math.sqrt,RectangleGeometryLibrary={computePosition:function(e,t,i,r,n,a,o){var s=t.radiiSquared,l=e.nwCorner,c=e.boundingRectangle,u=l.latitude-e.granYCos*r+n*e.granXSin,d=cos$2(u),h=sin$2(u),p=s.z*h,m=l.longitude+r*e.granYSin+n*e.granXCos,t=d*cos$2(m),l=d*sin$2(m),d=s.x*t,s=s.y*l,h=sqrt(d*t+s*l+p*h);a.x=d/h,a.y=s/h,a.z=p/h,i&&(defined(i=e.stNwCorner)?(u=i.latitude-e.stGranYCos*r+n*e.stGranXSin,m=i.longitude+r*e.stGranYSin+n*e.stGranXCos,o.x=(m-e.stWest)*e.lonScalar,o.y=(u-e.stSouth)*e.latScalar):(o.x=(m-c.west)*e.lonScalar,o.y=(u-c.south)*e.latScalar))}},rotationMatrixScratch=new Matrix2,nwCartesian=new Cartesian3,centerScratch$2=new Cartographic,centerCartesian=new Cartesian3,proj=new GeographicProjection;function getRotationOptions(e,t,i,r,n,a,o){var s=Math.cos(t),l=r*s,c=i*s,u=Math.sin(t),d=r*u,h=i*u;nwCartesian=proj.project(e,nwCartesian),nwCartesian=Cartesian3.subtract(nwCartesian,centerCartesian,nwCartesian);s=Matrix2.fromRotation(t,rotationMatrixScratch);nwCartesian=Matrix2.multiplyByVector(s,nwCartesian,nwCartesian),nwCartesian=Cartesian3.add(nwCartesian,centerCartesian,nwCartesian),--a,--o;r=(e=proj.unproject(nwCartesian,e)).latitude,i=r+a*h,u=r-l*o,t=r-l*o+a*h,s=Math.max(r,i,u,t),r=Math.min(r,i,u,t),i=e.longitude,u=i+a*c,t=i+o*d,a=i+o*d+a*c;return{north:s,south:r,east:Math.max(i,u,t,a),west:Math.min(i,u,t,a),granYCos:l,granYSin:d,granXCos:c,granXSin:h,nwCorner:e}}RectangleGeometryLibrary.computeOptions=function(e,t,i,r,n,a,o){var s=e.east,l=e.west,c=e.north,u=e.south,d=!1,h=!1;c===CesiumMath.PI_OVER_TWO&&(d=!0),u===-CesiumMath.PI_OVER_TWO&&(h=!0);var p,m=c-u,f=(_=s<l?CesiumMath.TWO_PI-l+s:s-l)/((p=Math.ceil(_/t)+1)-1),g=m/((y=Math.ceil(m/t)+1)-1),_=Rectangle.northwest(e,a),m=Rectangle.center(e,centerScratch$2);0===i&&0===r||(m.longitude<_.longitude&&(m.longitude+=CesiumMath.TWO_PI),centerCartesian=proj.project(m,centerCartesian));var y,t=g,a=f,n=Rectangle.clone(e,n),h={granYCos:t,granYSin:0,granXCos:a,granXSin:0,nwCorner:_,boundingRectangle:n,width:p,height:y,northCap:d,southCap:h};return 0!==i&&(c=(_=getRotationOptions(_,i,f,g,m,p,y)).north,u=_.south,s=_.east,l=_.west,h.granYCos=_.granYCos,h.granYSin=_.granYSin,h.granXCos=_.granXCos,h.granXSin=_.granXSin,n.north=c,n.south=u,n.east=s,n.west=l),0!==r&&(i-=r,y=getRotationOptions(o=Rectangle.northwest(n,o),i,f,g,m,p,y),h.stGranYCos=y.granYCos,h.stGranXCos=y.granXCos,h.stGranYSin=y.granYSin,h.stGranXSin=y.granXSin,h.stNwCorner=o,h.stWest=y.west,h.stSouth=y.south),h};var positionScratch$2=new Cartesian3,normalScratch$3=new Cartesian3,tangentScratch$1=new Cartesian3,bitangentScratch$1=new Cartesian3,rectangleScratch$2=new Rectangle,stScratch$1=new Cartesian2,bottomBoundingSphere$2=new BoundingSphere,topBoundingSphere$2=new BoundingSphere;function createAttributes(e,t){var i=new Geometry({attributes:new GeometryAttributes,primitiveType:PrimitiveType$1.TRIANGLES});return i.attributes.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:t.positions}),e.normal&&(i.attributes.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.normals})),e.tangent&&(i.attributes.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.tangents})),e.bitangent&&(i.attributes.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:t.bitangents})),i}function calculateAttributes(e,t,i,r){var n=e.length,a=t.normal?new Float32Array(n):void 0,o=t.tangent?new Float32Array(n):void 0,s=t.bitangent?new Float32Array(n):void 0,l=0,c=bitangentScratch$1,u=tangentScratch$1,d=normalScratch$3;if(t.normal||t.tangent||t.bitangent)for(var h=0;h<n;h+=3){var p=Cartesian3.fromArray(e,h,positionScratch$2),m=l+1,f=l+2,d=i.geodeticSurfaceNormal(p,d);(t.tangent||t.bitangent)&&(Cartesian3.cross(Cartesian3.UNIT_Z,d,u),Matrix3.multiplyByVector(r,u,u),Cartesian3.normalize(u,u),t.bitangent&&Cartesian3.normalize(Cartesian3.cross(d,u,c),c)),t.normal&&(a[l]=d.x,a[m]=d.y,a[f]=d.z),t.tangent&&(o[l]=u.x,o[m]=u.y,o[f]=u.z),t.bitangent&&(s[l]=c.x,s[m]=c.y,s[f]=c.z),l+=3}return createAttributes(t,{positions:e,normals:a,tangents:o,bitangents:s})}var v1Scratch=new Cartesian3,v2Scratch=new Cartesian3;function calculateAttributesWall(e,t,i){var r=e.length,n=t.normal?new Float32Array(r):void 0,a=t.tangent?new Float32Array(r):void 0,o=t.bitangent?new Float32Array(r):void 0,s=0,l=0,c=0,u=!0,d=bitangentScratch$1,h=tangentScratch$1,p=normalScratch$3;if(t.normal||t.tangent||t.bitangent)for(var m=0;m<r;m+=6){var f,g=Cartesian3.fromArray(e,m,positionScratch$2),_=Cartesian3.fromArray(e,(m+6)%r,v1Scratch);u&&(f=Cartesian3.fromArray(e,(m+3)%r,v2Scratch),Cartesian3.subtract(_,g,_),Cartesian3.subtract(f,g,f),p=Cartesian3.normalize(Cartesian3.cross(f,_,p),p),u=!1),Cartesian3.equalsEpsilon(_,g,CesiumMath.EPSILON10)&&(u=!0),(t.tangent||t.bitangent)&&(d=i.geodeticSurfaceNormal(g,d),t.tangent&&(h=Cartesian3.normalize(Cartesian3.cross(d,p,h),h))),t.normal&&(n[s++]=p.x,n[s++]=p.y,n[s++]=p.z,n[s++]=p.x,n[s++]=p.y,n[s++]=p.z),t.tangent&&(a[l++]=h.x,a[l++]=h.y,a[l++]=h.z,a[l++]=h.x,a[l++]=h.y,a[l++]=h.z),t.bitangent&&(o[c++]=d.x,o[c++]=d.y,o[c++]=d.z,o[c++]=d.x,o[c++]=d.y,o[c++]=d.z)}return createAttributes(t,{positions:e,normals:n,tangents:a,bitangents:o})}function constructRectangle(e,t){var i=e._vertexFormat,r=e._ellipsoid,n=t.height,a=t.width,o=t.northCap,s=t.southCap,l=0,c=n,u=n,e=0;o&&(--u,e+=l=1),s&&(--c,--u,e+=1),e+=a*u;for(var d=i.position?new Float64Array(3*e):void 0,h=i.st?new Float32Array(2*e):void 0,p=0,m=0,f=positionScratch$2,g=stScratch$1,_=Number.MAX_VALUE,y=Number.MAX_VALUE,C=-Number.MAX_VALUE,v=-Number.MAX_VALUE,S=l;S<c;++S)for(var T=0;T<a;++T)RectangleGeometryLibrary.computePosition(t,r,i.st,S,T,f,g),d[p++]=f.x,d[p++]=f.y,d[p++]=f.z,i.st&&(h[m++]=g.x,h[m++]=g.y,_=Math.min(_,g.x),y=Math.min(y,g.y),C=Math.max(C,g.x),v=Math.max(v,g.y));if(o&&(RectangleGeometryLibrary.computePosition(t,r,i.st,0,0,f,g),d[p++]=f.x,d[p++]=f.y,d[p++]=f.z,i.st&&(h[m++]=g.x,h[m++]=g.y,_=g.x,y=g.y,C=g.x,v=g.y)),s&&(RectangleGeometryLibrary.computePosition(t,r,i.st,n-1,0,f,g),d[p++]=f.x,d[p++]=f.y,d[p]=f.z,i.st&&(h[m++]=g.x,h[m]=g.y,_=Math.min(_,g.x),y=Math.min(y,g.y),C=Math.max(C,g.x),v=Math.max(v,g.y))),i.st&&(_<0||y<0||1<C||1<v))for(var x=0;x<h.length;x+=2)h[x]=(h[x]-_)/(C-_),h[x+1]=(h[x+1]-y)/(v-y);l=calculateAttributes(d,i,r,t.tangentRotationMatrix),n=6*(a-1)*(u-1);o&&(n+=3*(a-1)),s&&(n+=3*(a-1));for(var b=IndexDatatype$1.createTypedArray(e,n),E=0,P=0,A=0;A<u-1;++A){for(var w=0;w<a-1;++w){var D=E+a,M=D+1,I=E+1;b[P++]=E,b[P++]=D,b[P++]=I,b[P++]=I,b[P++]=D,b[P++]=M,++E}++E}if(o||s){var R,O,L=e-1,F=e-1;if(o&&s&&(L=e-2),E=0,o)for(A=0;A<a-1;A++)O=(R=E)+1,b[P++]=L,b[P++]=R,b[P++]=O,++E;if(s)for(E=(u-1)*a,A=0;A<a-1;A++)O=(R=E)+1,b[P++]=R,b[P++]=F,b[P++]=O,++E}return l.indices=b,i.st&&(l.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:h})),l}function addWallPositions$1(e,t,i,r,n){return e[t++]=r[i],e[t++]=r[i+1],e[t++]=r[i+2],e[t++]=n[i],e[t++]=n[i+1],e[t]=n[i+2],e}function addWallTextureCoordinates(e,t,i,r){return e[t++]=r[i],e[t++]=r[i+1],e[t++]=r[i],e[t]=r[i+1],e}var scratchVertexFormat$b=new VertexFormat;function constructExtrudedRectangle(e,t){var i=e._shadowVolume,r=e._offsetAttribute,n=e._vertexFormat,a=e._extrudedHeight,o=e._surfaceHeight,s=e._ellipsoid,l=t.height,c=t.width;i&&((_=VertexFormat.clone(n,scratchVertexFormat$b)).normal=!0,e._vertexFormat=_);var u=constructRectangle(e,t);i&&(e._vertexFormat=n);var d=PolygonPipeline.scaleToGeodeticHeight(u.attributes.position.values,o,s,!1),h=2*($=(d=new Float64Array(d)).length),p=new Float64Array(h);p.set(d);var m=PolygonPipeline.scaleToGeodeticHeight(u.attributes.position.values,a,s);p.set(m,$),u.attributes.position.values=p;var f,g,_=n.normal?new Float32Array(h):void 0,e=n.tangent?new Float32Array(h):void 0,o=n.bitangent?new Float32Array(h):void 0,a=n.st?new Float32Array(h/3*2):void 0;if(n.normal){for(g=u.attributes.normal.values,_.set(g),C=0;C<$;C++)g[C]=-g[C];_.set(g,$),u.attributes.normal.values=_}if(i){g=u.attributes.normal.values,n.normal||(u.attributes.normal=void 0);for(var y=new Float32Array(h),C=0;C<$;C++)g[C]=-g[C];y.set(g,$),u.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:y})}p=defined(r);if(p&&(_=$/3*2,y=new Uint8Array(_),y=r===GeometryOffsetAttribute$1.TOP?arrayFill(y,1,0,_/2):arrayFill(y,r===GeometryOffsetAttribute$1.NONE?0:1),u.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:y})),n.tangent){var v=u.attributes.tangent.values;for(e.set(v),C=0;C<$;C++)v[C]=-v[C];e.set(v,$),u.attributes.tangent.values=e}n.bitangent&&(E=u.attributes.bitangent.values,o.set(E),o.set(E,$),u.attributes.bitangent.values=o),n.st&&(f=u.attributes.st.values,a.set(f),a.set(f,$/3*2),u.attributes.st.values=a);var S=u.indices,T=S.length,x=$/3,b=IndexDatatype$1.createTypedArray(h/3,2*T);for(b.set(S),C=0;C<T;C+=3)b[C+T]=S[C+2]+x,b[C+1+T]=S[C+1]+x,b[C+2+T]=S[C]+x;u.indices=b;var e=t.northCap,E=t.southCap,o=l,a=2,h=0,t=4,l=4;e&&(--a,--o,h+=1,t-=2,--l),E&&(--a,--o,h+=1,t-=2,--l);var l=2*((h+=a*c+2*o-t)+l),P=new Float64Array(3*l),A=i?new Float32Array(3*l):void 0,w=p?new Uint8Array(l):void 0,D=n.st?new Float32Array(2*l):void 0,M=r===GeometryOffsetAttribute$1.TOP;p&&!M&&(w=arrayFill(w,r===GeometryOffsetAttribute$1.ALL?1:0));var I=0,R=0,O=0,L=0,F=c*o;for(C=0;C<F;C+=c)P=addWallPositions$1(P,I,B=3*C,d,m),I+=6,n.st&&(D=addWallTextureCoordinates(D,R,2*C,f),R+=4),i&&(O+=3,A[O++]=g[B],A[O++]=g[B+1],A[O++]=g[B+2]),M&&(w[L++]=1,L+=1);if(E){var N=e?1+F:F,B=3*N;for(C=0;C<2;C++)P=addWallPositions$1(P,I,B,d,m),I+=6,n.st&&(D=addWallTextureCoordinates(D,R,2*N,f),R+=4),i&&(O+=3,A[O++]=g[B],A[O++]=g[B+1],A[O++]=g[B+2]),M&&(w[L++]=1,L+=1)}else for(C=F-c;C<F;C++)P=addWallPositions$1(P,I,B=3*C,d,m),I+=6,n.st&&(D=addWallTextureCoordinates(D,R,2*C,f),R+=4),i&&(O+=3,A[O++]=g[B],A[O++]=g[B+1],A[O++]=g[B+2]),M&&(w[L++]=1,L+=1);for(C=F-1;0<C;C-=c)P=addWallPositions$1(P,I,B=3*C,d,m),I+=6,n.st&&(D=addWallTextureCoordinates(D,R,2*C,f),R+=4),i&&(O+=3,A[O++]=g[B],A[O++]=g[B+1],A[O++]=g[B+2]),M&&(w[L++]=1,L+=1);if(e){var V=F;for(B=3*V,C=0;C<2;C++)P=addWallPositions$1(P,I,B,d,m),I+=6,n.st&&(D=addWallTextureCoordinates(D,R,2*V,f),R+=4),i&&(O+=3,A[O++]=g[B],A[O++]=g[B+1],A[O++]=g[B+2]),M&&(w[L++]=1,L+=1)}else for(C=c-1;0<=C;C--)P=addWallPositions$1(P,I,B=3*C,d,m),I+=6,n.st&&(D=addWallTextureCoordinates(D,R,2*C,f),R+=4),i&&(O+=3,A[O++]=g[B],A[O++]=g[B+1],A[O++]=g[B+2]),M&&(w[L++]=1,L+=1);s=calculateAttributesWall(P,n,s);n.st&&(s.attributes.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:D})),i&&(s.attributes.extrudeDirection=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:A})),p&&(s.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:w}));var k,z,U=IndexDatatype$1.createTypedArray(l,6*h),$=P.length/3,G=0;for(C=0;C<$-1;C+=2){z=((k=C)+2)%$;var H=Cartesian3.fromArray(P,3*k,v1Scratch),W=Cartesian3.fromArray(P,3*z,v2Scratch);Cartesian3.equalsEpsilon(H,W,CesiumMath.EPSILON10)||(W=(2+(H=(k+1)%$))%$,U[G++]=k,U[G++]=H,U[G++]=z,U[G++]=z,U[G++]=H,U[G++]=W)}return s.indices=U,(s=GeometryPipeline.combineInstances([new GeometryInstance({geometry:u}),new GeometryInstance({geometry:s})]))[0]}var scratchRectanglePoints=[new Cartesian3,new Cartesian3,new Cartesian3,new Cartesian3],nwScratch=new Cartographic,stNwScratch=new Cartographic;function computeRectangle$3(e,t,i,r,n){if(0===i)return Rectangle.clone(e,n);var a=RectangleGeometryLibrary.computeOptions(e,t,i,0,rectangleScratch$2,nwScratch),e=a.height,t=a.width,i=scratchRectanglePoints;return RectangleGeometryLibrary.computePosition(a,r,!1,0,0,i[0]),RectangleGeometryLibrary.computePosition(a,r,!1,0,t-1,i[1]),RectangleGeometryLibrary.computePosition(a,r,!1,e-1,0,i[2]),RectangleGeometryLibrary.computePosition(a,r,!1,e-1,t-1,i[3]),Rectangle.fromCartesianArray(i,r,n)}function RectangleGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,i=defaultValue(e.height,0),r=defaultValue(e.extrudedHeight,i);this._rectangle=Rectangle.clone(t),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=Ellipsoid.clone(defaultValue(e.ellipsoid,Ellipsoid.WGS84)),this._surfaceHeight=Math.max(i,r),this._rotation=defaultValue(e.rotation,0),this._stRotation=defaultValue(e.stRotation,0),this._vertexFormat=VertexFormat.clone(defaultValue(e.vertexFormat,VertexFormat.DEFAULT)),this._extrudedHeight=Math.min(i,r),this._shadowVolume=defaultValue(e.shadowVolume,!1),this._workerName="createRectangleGeometry",this._offsetAttribute=e.offsetAttribute,this._rotatedRectangle=void 0,this._textureCoordinateRotationPoints=void 0}RectangleGeometry.packedLength=Rectangle.packedLength+Ellipsoid.packedLength+VertexFormat.packedLength+7,RectangleGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Rectangle.pack(e._rectangle,t,i),i+=Rectangle.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),i+=VertexFormat.packedLength,t[i++]=e._granularity,t[i++]=e._surfaceHeight,t[i++]=e._rotation,t[i++]=e._stRotation,t[i++]=e._extrudedHeight,t[i++]=e._shadowVolume?1:0,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRectangle=new Rectangle,scratchEllipsoid$a=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$i={rectangle:scratchRectangle,ellipsoid:scratchEllipsoid$a,vertexFormat:scratchVertexFormat$b,granularity:void 0,height:void 0,rotation:void 0,stRotation:void 0,extrudedHeight:void 0,shadowVolume:void 0,offsetAttribute:void 0};RectangleGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Rectangle.unpack(e,t,scratchRectangle);t+=Rectangle.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$a);t+=Ellipsoid.packedLength;var a=VertexFormat.unpack(e,t,scratchVertexFormat$b);t+=VertexFormat.packedLength;var o=e[t++],s=e[t++],l=e[t++],c=e[t++],u=e[t++],d=1===e[t++],t=e[t];return defined(i)?(i._rectangle=Rectangle.clone(r,i._rectangle),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._vertexFormat=VertexFormat.clone(a,i._vertexFormat),i._granularity=o,i._surfaceHeight=s,i._rotation=l,i._stRotation=c,i._extrudedHeight=u,i._shadowVolume=d,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$i.granularity=o,scratchOptions$i.height=s,scratchOptions$i.rotation=l,scratchOptions$i.stRotation=c,scratchOptions$i.extrudedHeight=u,scratchOptions$i.shadowVolume=d,scratchOptions$i.offsetAttribute=-1===t?void 0:t,new RectangleGeometry(scratchOptions$i))},RectangleGeometry.computeRectangle=function(e,t){var i=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,r=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),n=defaultValue(e.ellipsoid,Ellipsoid.WGS84);return computeRectangle$3(i,r,defaultValue(e.rotation,0),n,t)};var tangentRotationMatrixScratch=new Matrix3,quaternionScratch$3=new Quaternion,centerScratch$3=new Cartographic;RectangleGeometry.createGeometry=function(e){if(!CesiumMath.equalsEpsilon(e._rectangle.north,e._rectangle.south,CesiumMath.EPSILON10)&&!CesiumMath.equalsEpsilon(e._rectangle.east,e._rectangle.west,CesiumMath.EPSILON10)){var t=e._rectangle,i=e._ellipsoid,r=e._rotation,n=e._stRotation,a=e._vertexFormat,o=RectangleGeometryLibrary.computeOptions(t,e._granularity,r,n,rectangleScratch$2,nwScratch,stNwScratch),s=tangentRotationMatrixScratch;0!==n||0!==r?(c=Rectangle.center(t,centerScratch$3),u=i.geodeticSurfaceNormalCartographic(c,v1Scratch),Quaternion.fromAxisAngle(u,-n,quaternionScratch$3),Matrix3.fromQuaternion(quaternionScratch$3,s)):Matrix3.clone(Matrix3.IDENTITY,s);var l,c=e._surfaceHeight,u=e._extrudedHeight,n=!CesiumMath.equalsEpsilon(c,u,0,CesiumMath.EPSILON2);return o.lonScalar=1/e._rectangle.width,o.latScalar=1/e._rectangle.height,o.tangentRotationMatrix=s,t=e._rectangle,c=n?(l=constructExtrudedRectangle(e,o),n=BoundingSphere.fromRectangle3D(t,i,c,topBoundingSphere$2),u=BoundingSphere.fromRectangle3D(t,i,u,bottomBoundingSphere$2),BoundingSphere.union(n,u)):((l=constructRectangle(e,o)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(l.attributes.position.values,c,i,!1),defined(e._offsetAttribute)&&(o=l.attributes.position.values.length,arrayFill(o=new Uint8Array(o/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),l.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:o})),BoundingSphere.fromRectangle3D(t,i,c)),a.position||delete l.attributes.position,new Geometry({attributes:l.attributes,indices:l.indices,primitiveType:l.primitiveType,boundingSphere:c,offsetAttribute:e._offsetAttribute})}},RectangleGeometry.createShadowVolume=function(e,t,i){var r=e._granularity,n=e._ellipsoid,t=t(r,n),i=i(r,n);return new RectangleGeometry({rectangle:e._rectangle,rotation:e._rotation,ellipsoid:n,stRotation:e._stRotation,granularity:r,extrudedHeight:i,height:t,vertexFormat:VertexFormat.POSITION_ONLY,shadowVolume:!0})};var unrotatedTextureRectangleScratch=new Rectangle,points2DScratch$1=[new Cartesian2,new Cartesian2,new Cartesian2],rotation2DScratch$1=new Matrix2,rectangleCenterScratch$1=new Cartographic;function textureCoordinateRotationPoints$2(e){if(0===e._stRotation)return[0,0,0,1,1,0];var t=Rectangle.clone(e._rectangle,unrotatedTextureRectangleScratch),i=e._granularity,r=e._ellipsoid,t=computeRectangle$3(t,i,e._rotation-e._stRotation,r,unrotatedTextureRectangleScratch),n=points2DScratch$1;n[0].x=t.west,n[0].y=t.south,n[1].x=t.west,n[1].y=t.north,n[2].x=t.east,n[2].y=t.south;for(var a=e.rectangle,o=Matrix2.fromRotation(e._stRotation,rotation2DScratch$1),s=Rectangle.center(a,rectangleCenterScratch$1),l=0;l<3;++l){var c=n[l];c.x-=s.longitude,c.y-=s.latitude,Matrix2.multiplyByVector(o,c,c),c.x+=s.longitude,c.y+=s.latitude,c.x=(c.x-a.west)/a.width,c.y=(c.y-a.south)/a.height}i=n[0],r=n[1],t=n[2],e=new Array(6);return Cartesian2.pack(i,e),Cartesian2.pack(r,e,2),Cartesian2.pack(t,e,4),e}Object.defineProperties(RectangleGeometry.prototype,{rectangle:{get:function(){return defined(this._rotatedRectangle)||(this._rotatedRectangle=computeRectangle$3(this._rectangle,this._granularity,this._rotation,this._ellipsoid)),this._rotatedRectangle}},textureCoordinateRotationPoints:{get:function(){return defined(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=textureCoordinateRotationPoints$2(this)),this._textureCoordinateRotationPoints}}});var bottomBoundingSphere$3=new BoundingSphere,topBoundingSphere$3=new BoundingSphere,positionScratch$3=new Cartesian3,rectangleScratch$3=new Rectangle;function constructRectangle$1(e,t){var i=e._ellipsoid,r=t.height,n=t.width,a=t.northCap,o=t.southCap,s=r,l=2,c=0,e=4;a&&(--l,--s,c+=1,e-=2),o&&(--l,--s,c+=1,e-=2),c+=l*n+2*s-e;var u,d=new Float64Array(3*c),h=0,p=0,m=positionScratch$3;if(a)RectangleGeometryLibrary.computePosition(t,i,!1,p,0,m),d[h++]=m.x,d[h++]=m.y,d[h++]=m.z;else for(u=0;u<n;u++)RectangleGeometryLibrary.computePosition(t,i,!1,p,u,m),d[h++]=m.x,d[h++]=m.y,d[h++]=m.z;for(u=n-1,p=1;p<r;p++)RectangleGeometryLibrary.computePosition(t,i,!1,p,u,m),d[h++]=m.x,d[h++]=m.y,d[h++]=m.z;if(p=r-1,!o)for(u=n-2;0<=u;u--)RectangleGeometryLibrary.computePosition(t,i,!1,p,u,m),d[h++]=m.x,d[h++]=m.y,d[h++]=m.z;for(u=0,p=r-2;0<p;p--)RectangleGeometryLibrary.computePosition(t,i,!1,p,u,m),d[h++]=m.x,d[h++]=m.y,d[h++]=m.z;for(var o=d.length/3*2,f=IndexDatatype$1.createTypedArray(d.length/3,o),g=0,_=0;_<d.length/3-1;_++)f[g++]=_,f[g++]=_+1;f[g++]=d.length/3-1,f[g++]=0;o=new Geometry({attributes:new GeometryAttributes,primitiveType:PrimitiveType$1.LINES});return o.attributes.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:d}),o.indices=f,o}function constructExtrudedRectangle$1(e,t){var i=e._surfaceHeight,r=e._extrudedHeight,n=e._ellipsoid,a=r,o=i,s=constructRectangle$1(e,t),r=t.height,i=t.width,e=PolygonPipeline.scaleToGeodeticHeight(s.attributes.position.values,o,n,!1),l=e.length,o=new Float64Array(2*l);o.set(e);a=PolygonPipeline.scaleToGeodeticHeight(s.attributes.position.values,a,n);o.set(a,l),s.attributes.position.values=o;n=t.northCap,a=t.southCap,t=4;n&&--t,a&&--t;for(var t=2*(o.length/3+t),c=IndexDatatype$1.createTypedArray(o.length/3,t),l=o.length/6,u=0,d=0;d<l-1;d++)c[u++]=d,c[u++]=d+1,c[u++]=d+l,c[u++]=d+l+1;return c[u++]=l-1,c[u++]=0,c[u++]=l+l-1,c[u++]=l,c[u++]=0,c[u++]=l,r=n?r-1:(n=i-1,c[u++]=n,c[u++]=n+l,i+r-2),c[u++]=r,c[u++]=r+l,a||(r=i+r-1,c[u++]=r,c[u]=r+l),s.indices=c,s}function RectangleOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).rectangle,i=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),r=defaultValue(e.ellipsoid,Ellipsoid.WGS84),n=defaultValue(e.rotation,0),a=defaultValue(e.height,0),o=defaultValue(e.extrudedHeight,a);this._rectangle=Rectangle.clone(t),this._granularity=i,this._ellipsoid=r,this._surfaceHeight=Math.max(a,o),this._rotation=n,this._extrudedHeight=Math.min(a,o),this._offsetAttribute=e.offsetAttribute,this._workerName="createRectangleOutlineGeometry"}RectangleOutlineGeometry.packedLength=Rectangle.packedLength+Ellipsoid.packedLength+5,RectangleOutlineGeometry.pack=function(e,t,i){return i=defaultValue(i,0),Rectangle.pack(e._rectangle,t,i),i+=Rectangle.packedLength,Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._granularity,t[i++]=e._surfaceHeight,t[i++]=e._rotation,t[i++]=e._extrudedHeight,t[i]=defaultValue(e._offsetAttribute,-1),t};var scratchRectangle$1=new Rectangle,scratchEllipsoid$b=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$j={rectangle:scratchRectangle$1,ellipsoid:scratchEllipsoid$b,granularity:void 0,height:void 0,rotation:void 0,extrudedHeight:void 0,offsetAttribute:void 0};RectangleOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);var r=Rectangle.unpack(e,t,scratchRectangle$1);t+=Rectangle.packedLength;var n=Ellipsoid.unpack(e,t,scratchEllipsoid$b);t+=Ellipsoid.packedLength;var a=e[t++],o=e[t++],s=e[t++],l=e[t++],t=e[t];return defined(i)?(i._rectangle=Rectangle.clone(r,i._rectangle),i._ellipsoid=Ellipsoid.clone(n,i._ellipsoid),i._surfaceHeight=o,i._rotation=s,i._extrudedHeight=l,i._offsetAttribute=-1===t?void 0:t,i):(scratchOptions$j.granularity=a,scratchOptions$j.height=o,scratchOptions$j.rotation=s,scratchOptions$j.extrudedHeight=l,scratchOptions$j.offsetAttribute=-1===t?void 0:t,new RectangleOutlineGeometry(scratchOptions$j))};var nwScratch$1=new Cartographic;RectangleOutlineGeometry.createGeometry=function(e){var t=e._rectangle,i=e._ellipsoid,r=RectangleGeometryLibrary.computeOptions(t,e._granularity,e._rotation,0,rectangleScratch$3,nwScratch$1);if(!CesiumMath.equalsEpsilon(t.north,t.south,CesiumMath.EPSILON10)&&!CesiumMath.equalsEpsilon(t.east,t.west,CesiumMath.EPSILON10)){var n,a,o,s=e._surfaceHeight,l=e._extrudedHeight;return s=!CesiumMath.equalsEpsilon(s,l,0,CesiumMath.EPSILON2)?(a=constructExtrudedRectangle$1(e,r),defined(e._offsetAttribute)&&(n=a.attributes.position.values.length/3,o=new Uint8Array(n),o=e._offsetAttribute===GeometryOffsetAttribute$1.TOP?arrayFill(o,1,0,n/2):arrayFill(o,e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),a.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:o})),o=BoundingSphere.fromRectangle3D(t,i,s,topBoundingSphere$3),l=BoundingSphere.fromRectangle3D(t,i,l,bottomBoundingSphere$3),BoundingSphere.union(o,l)):((a=constructRectangle$1(e,r)).attributes.position.values=PolygonPipeline.scaleToGeodeticHeight(a.attributes.position.values,s,i,!1),defined(e._offsetAttribute)&&(r=a.attributes.position.values.length,arrayFill(r=new Uint8Array(r/3),e._offsetAttribute===GeometryOffsetAttribute$1.NONE?0:1),a.attributes.applyOffset=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:1,values:r})),BoundingSphere.fromRectangle3D(t,i,s)),new Geometry({attributes:a.attributes,indices:a.indices,primitiveType:PrimitiveType$1.LINES,boundingSphere:s,offsetAttribute:e._offsetAttribute})}};var ReferenceFrame={FIXED:0,INERTIAL:1},ReferenceFrame$1=Object.freeze(ReferenceFrame),ScreenSpaceEventType={LEFT_DOWN:0,LEFT_UP:1,LEFT_CLICK:2,LEFT_DOUBLE_CLICK:3,RIGHT_DOWN:5,RIGHT_UP:6,RIGHT_CLICK:7,MIDDLE_DOWN:10,MIDDLE_UP:11,MIDDLE_CLICK:12,MOUSE_MOVE:15,WHEEL:16,PINCH_START:17,PINCH_END:18,PINCH_MOVE:19},ScreenSpaceEventType$1=Object.freeze(ScreenSpaceEventType);function getPosition$1(e,t,i){e=e._element;if(e===document)return i.x=t.clientX,i.y=t.clientY,i;e=e.getBoundingClientRect();return i.x=t.clientX-e.left,i.y=t.clientY-e.top,i}function getInputEventKey(e,t){return defined(t)&&(e+="+"+t),e}function getModifier(e){return e.shiftKey?KeyboardEventModifier$1.SHIFT:e.ctrlKey?KeyboardEventModifier$1.CTRL:e.altKey?KeyboardEventModifier$1.ALT:void 0}var MouseButton={LEFT:0,MIDDLE:1,RIGHT:2};function registerListener(t,e,i,r){function n(e){r(t,e)}FeatureDetection.isInternetExplorer()?i.addEventListener(e,n,!1):i.addEventListener(e,n,{capture:!1,passive:!1}),t._removalFunctions.push(function(){i.removeEventListener(e,n,!1)})}function registerListeners(e){var t=e._element,i=defined(t.disableRootEvents)?t:document;FeatureDetection.supportsPointerEvents()?(registerListener(e,"pointerdown",t,handlePointerDown),registerListener(e,"pointerup",t,handlePointerUp),registerListener(e,"pointermove",t,handlePointerMove),registerListener(e,"pointercancel",t,handlePointerUp)):(registerListener(e,"mousedown",t,handleMouseDown),registerListener(e,"mouseup",i,handleMouseUp),registerListener(e,"mousemove",i,handleMouseMove),registerListener(e,"touchstart",t,handleTouchStart),registerListener(e,"touchend",i,handleTouchEnd),registerListener(e,"touchmove",i,handleTouchMove),registerListener(e,"touchcancel",i,handleTouchEnd)),registerListener(e,"dblclick",t,handleDblClick),registerListener(e,"onwheel"in t?"wheel":void 0!==document.onmousewheel?"mousewheel":"DOMMouseScroll",t,handleWheel)}function unregisterListeners(e){for(var t=e._removalFunctions,i=0;i<t.length;++i)t[i]()}var mouseDownEvent={position:new Cartesian2};function gotTouchEvent(e){e._lastSeenTouchEvent=getTimestamp$1()}function canProcessMouseEvent(e){return getTimestamp$1()-e._lastSeenTouchEvent>ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds}function checkPixelTolerance(e,t,i){var r=e.x-t.x,t=e.y-t.y;return Math.sqrt(r*r+t*t)<i}function handleMouseDown(e,t){if(canProcessMouseEvent(e)){var i,r=t.button;if(e._buttonDown[r]=!0,r===MouseButton.LEFT)i=ScreenSpaceEventType$1.LEFT_DOWN;else if(r===MouseButton.MIDDLE)i=ScreenSpaceEventType$1.MIDDLE_DOWN;else{if(r!==MouseButton.RIGHT)return;i=ScreenSpaceEventType$1.RIGHT_DOWN}var n=getPosition$1(e,t,e._primaryPosition);Cartesian2.clone(n,e._primaryStartPosition),Cartesian2.clone(n,e._primaryPreviousPosition);r=getModifier(t),r=e.getInputAction(i,r);defined(r)&&(Cartesian2.clone(n,mouseDownEvent.position),r(mouseDownEvent),t.preventDefault())}}var mouseUpEvent={position:new Cartesian2},mouseClickEvent={position:new Cartesian2};function cancelMouseEvent(e,t,i,r){var n=getModifier(r),t=e.getInputAction(t,n),n=e.getInputAction(i,n);(defined(t)||defined(n))&&(r=getPosition$1(e,r,e._primaryPosition),defined(t)&&(Cartesian2.clone(r,mouseUpEvent.position),t(mouseUpEvent)),defined(n)&&checkPixelTolerance(e._primaryStartPosition,r,e._clickPixelTolerance)&&(Cartesian2.clone(r,mouseClickEvent.position),n(mouseClickEvent)))}function handleMouseUp(e,t){var i;canProcessMouseEvent(e)&&((i=t.button)!==MouseButton.LEFT&&i!==MouseButton.MIDDLE&&i!==MouseButton.RIGHT||(e._buttonDown[MouseButton.LEFT]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.LEFT_UP,ScreenSpaceEventType$1.LEFT_CLICK,t),e._buttonDown[MouseButton.LEFT]=!1),e._buttonDown[MouseButton.MIDDLE]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.MIDDLE_UP,ScreenSpaceEventType$1.MIDDLE_CLICK,t),e._buttonDown[MouseButton.MIDDLE]=!1),e._buttonDown[MouseButton.RIGHT]&&(cancelMouseEvent(e,ScreenSpaceEventType$1.RIGHT_UP,ScreenSpaceEventType$1.RIGHT_CLICK,t),e._buttonDown[MouseButton.RIGHT]=!1)))}var mouseMoveEvent={startPosition:new Cartesian2,endPosition:new Cartesian2};function handleMouseMove(e,t){var i,r,n;canProcessMouseEvent(e)&&(n=getModifier(t),i=getPosition$1(e,t,e._primaryPosition),r=e._primaryPreviousPosition,defined(n=e.getInputAction(ScreenSpaceEventType$1.MOUSE_MOVE,n))&&(Cartesian2.clone(r,mouseMoveEvent.startPosition),Cartesian2.clone(i,mouseMoveEvent.endPosition),n(mouseMoveEvent)),Cartesian2.clone(i,r),(e._buttonDown[MouseButton.LEFT]||e._buttonDown[MouseButton.MIDDLE]||e._buttonDown[MouseButton.RIGHT])&&t.preventDefault())}var mouseDblClickEvent={position:new Cartesian2};function handleDblClick(e,t){var i,r;t.button===MouseButton.LEFT&&(i=ScreenSpaceEventType$1.LEFT_DOUBLE_CLICK,r=getModifier(t),defined(r=e.getInputAction(i,r))&&(getPosition$1(e,t,mouseDblClickEvent.position),r(mouseDblClickEvent)))}function handleWheel(e,t){var i,r;i=defined(t.deltaY)?(r=t.deltaMode)===t.DOM_DELTA_PIXEL?-t.deltaY:r===t.DOM_DELTA_LINE?40*-t.deltaY:120*-t.deltaY:0<t.detail?-120*t.detail:t.wheelDelta,defined(i)&&(r=getModifier(t),defined(r=e.getInputAction(ScreenSpaceEventType$1.WHEEL,r))&&(r(i),t.preventDefault()))}function handleTouchStart(e,t){gotTouchEvent(e);for(var i,r,n=t.changedTouches,a=n.length,o=e._positions,s=0;s<a;++s)r=(i=n[s]).identifier,o.set(r,getPosition$1(e,i,new Cartesian2));fireTouchEvents(e,t);var l=e._previousPositions;for(s=0;s<a;++s)r=(i=n[s]).identifier,l.set(r,Cartesian2.clone(o.get(r)))}function handleTouchEnd(e,t){gotTouchEvent(e);for(var i,r=t.changedTouches,n=r.length,a=e._positions,o=0;o<n;++o)i=r[o].identifier,a.remove(i);fireTouchEvents(e,t);var s=e._previousPositions;for(o=0;o<n;++o)i=r[o].identifier,s.remove(i)}var touchStartEvent={position:new Cartesian2},touch2StartEvent={position1:new Cartesian2,position2:new Cartesian2},touchEndEvent={position:new Cartesian2},touchClickEvent={position:new Cartesian2},touchHoldEvent={position:new Cartesian2};function fireTouchEvents(e,t){var i,r,n,a=getModifier(t),o=e._positions,s=o.length,l=e._isPinching;1!==s&&e._buttonDown[MouseButton.LEFT]&&(e._buttonDown[MouseButton.LEFT]=!1,defined(e._touchHoldTimer)&&(clearTimeout(e._touchHoldTimer),e._touchHoldTimer=void 0),defined(i=e.getInputAction(ScreenSpaceEventType$1.LEFT_UP,a))&&(Cartesian2.clone(e._primaryPosition,touchEndEvent.position),i(touchEndEvent)),0!==s||e._isTouchHolding||defined(r=e.getInputAction(ScreenSpaceEventType$1.LEFT_CLICK,a))&&checkPixelTolerance(e._primaryStartPosition,e._previousPositions.values[0],e._clickPixelTolerance)&&(Cartesian2.clone(e._primaryPosition,touchClickEvent.position),r(touchClickEvent)),e._isTouchHolding=!1),0===s&&l&&(e._isPinching=!1,defined(i=e.getInputAction(ScreenSpaceEventType$1.PINCH_END,a))&&i()),1!==s||l||(n=o.values[0],Cartesian2.clone(n,e._primaryPosition),Cartesian2.clone(n,e._primaryStartPosition),Cartesian2.clone(n,e._primaryPreviousPosition),e._buttonDown[MouseButton.LEFT]=!0,defined(i=e.getInputAction(ScreenSpaceEventType$1.LEFT_DOWN,a))&&(Cartesian2.clone(n,touchStartEvent.position),i(touchStartEvent)),e._touchHoldTimer=setTimeout(function(){e.isDestroyed()||(e._touchHoldTimer=void 0,e._isTouchHolding=!0,defined(r=e.getInputAction(ScreenSpaceEventType$1.RIGHT_CLICK,a))&&checkPixelTolerance(e._primaryStartPosition,e._previousPositions.values[0],e._holdPixelTolerance)&&(Cartesian2.clone(e._primaryPosition,touchHoldEvent.position),r(touchHoldEvent)))},ScreenSpaceEventHandler.touchHoldDelayMilliseconds),t.preventDefault()),2!==s||l||(e._isPinching=!0,defined(i=e.getInputAction(ScreenSpaceEventType$1.PINCH_START,a))&&(Cartesian2.clone(o.values[0],touch2StartEvent.position1),Cartesian2.clone(o.values[1],touch2StartEvent.position2),i(touch2StartEvent),t.preventDefault()))}function handleTouchMove(e,t){gotTouchEvent(e);for(var i,r,n=t.changedTouches,a=n.length,o=e._positions,s=0;s<a;++s){r=(i=n[s]).identifier;var l=o.get(r);defined(l)&&getPosition$1(e,i,l)}fireTouchMoveEvents(e,t);var c=e._previousPositions;for(s=0;s<a;++s)r=(i=n[s]).identifier,Cartesian2.clone(o.get(r),c.get(r))}var touchMoveEvent={startPosition:new Cartesian2,endPosition:new Cartesian2},touchPinchMovementEvent={distance:{startPosition:new Cartesian2,endPosition:new Cartesian2},angleAndHeight:{startPosition:new Cartesian2,endPosition:new Cartesian2}};function fireTouchMoveEvents(e,t){var i,r,n,a,o,s=getModifier(t),l=e._positions,c=e._previousPositions,u=l.length;1===u&&e._buttonDown[MouseButton.LEFT]?(o=l.values[0],Cartesian2.clone(o,e._primaryPosition),n=e._primaryPreviousPosition,defined(i=e.getInputAction(ScreenSpaceEventType$1.MOUSE_MOVE,s))&&(Cartesian2.clone(n,touchMoveEvent.startPosition),Cartesian2.clone(o,touchMoveEvent.endPosition),i(touchMoveEvent)),Cartesian2.clone(o,n),t.preventDefault()):2===u&&e._isPinching&&defined(i=e.getInputAction(ScreenSpaceEventType$1.PINCH_MOVE,s))&&(a=l.values[0],r=l.values[1],o=c.values[0],n=c.values[1],t=r.x-a.x,u=r.y-a.y,e=.25*Math.sqrt(t*t+u*u),s=n.x-o.x,l=n.y-o.y,c=.25*Math.sqrt(s*s+l*l),a=.125*(r.y+a.y),o=.125*(n.y+o.y),t=Math.atan2(u,t),s=Math.atan2(l,s),Cartesian2.fromElements(0,c,touchPinchMovementEvent.distance.startPosition),Cartesian2.fromElements(0,e,touchPinchMovementEvent.distance.endPosition),Cartesian2.fromElements(s,o,touchPinchMovementEvent.angleAndHeight.startPosition),Cartesian2.fromElements(t,a,touchPinchMovementEvent.angleAndHeight.endPosition),i(touchPinchMovementEvent))}function handlePointerDown(e,t){var i,r;t.target.setPointerCapture(t.pointerId),"touch"===t.pointerType?(i=e._positions,r=t.pointerId,i.set(r,getPosition$1(e,t,new Cartesian2)),fireTouchEvents(e,t),e._previousPositions.set(r,Cartesian2.clone(i.get(r)))):handleMouseDown(e,t)}function handlePointerUp(e,t){var i,r;"touch"===t.pointerType?(i=e._positions,r=t.pointerId,i.remove(r),fireTouchEvents(e,t),e._previousPositions.remove(r)):handleMouseUp(e,t)}function handlePointerMove(e,t){var i,r,n;"touch"===t.pointerType?(i=e._positions,r=t.pointerId,defined(n=i.get(r))&&(getPosition$1(e,t,n),fireTouchMoveEvents(e,t),n=e._previousPositions,Cartesian2.clone(i.get(r),n.get(r)))):handleMouseMove(e,t)}function ScreenSpaceEventHandler(e){this._inputEvents={},this._buttonDown={LEFT:!1,MIDDLE:!1,RIGHT:!1},this._isPinching=!1,this._isTouchHolding=!1,this._lastSeenTouchEvent=-ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds,this._primaryStartPosition=new Cartesian2,this._primaryPosition=new Cartesian2,this._primaryPreviousPosition=new Cartesian2,this._positions=new AssociativeArray,this._previousPositions=new AssociativeArray,this._removalFunctions=[],this._touchHoldTimer=void 0,this._clickPixelTolerance=5,this._holdPixelTolerance=25,this._element=defaultValue(e,document),registerListeners(this)}function ShowGeometryInstanceAttribute(e){e=defaultValue(e,!0),this.value=ShowGeometryInstanceAttribute.toValue(e)}ScreenSpaceEventHandler.prototype.setInputAction=function(e,t,i){i=getInputEventKey(t,i);this._inputEvents[i]=e},ScreenSpaceEventHandler.prototype.getInputAction=function(e,t){t=getInputEventKey(e,t);return this._inputEvents[t]},ScreenSpaceEventHandler.prototype.removeInputAction=function(e,t){t=getInputEventKey(e,t);delete this._inputEvents[t]},ScreenSpaceEventHandler.prototype.isDestroyed=function(){return!1},ScreenSpaceEventHandler.prototype.destroy=function(){return unregisterListeners(this),destroyObject(this)},ScreenSpaceEventHandler.mouseEmulationIgnoreMilliseconds=800,ScreenSpaceEventHandler.touchHoldDelayMilliseconds=1500,Object.defineProperties(ShowGeometryInstanceAttribute.prototype,{componentDatatype:{get:function(){return ComponentDatatype$1.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 1}},normalize:{get:function(){return!1}}}),ShowGeometryInstanceAttribute.toValue=function(e,t){return defined(t)?(t[0]=e,t):new Uint8Array([e])};var Simon1994PlanetaryPositions={};function computeTdbMinusTtSpice(e){e=6.239996+.0172019696544*e;return.001657*Math.sin(e+.01671*Math.sin(e))}var TdtMinusTai$1=32.184,J2000d$1=2451545;function taiToTdb(e,t){t=JulianDate.addSeconds(e,TdtMinusTai$1,t);e=JulianDate.totalDays(t)-J2000d$1;return t=JulianDate.addSeconds(t,computeTdbMinusTtSpice(e),t)}var epoch=new JulianDate(2451545,0,TimeStandard$1.TAI),MetersPerKilometer=1e3,RadiansPerDegree=CesiumMath.RADIANS_PER_DEGREE,RadiansPerArcSecond=CesiumMath.RADIANS_PER_ARCSECOND,MetersPerAstronomicalUnit=14959787e4,perifocalToEquatorial=new Matrix3;function elementsToCartesian(e,t,i,r,n,a,o){i<0&&(i=-i,n+=CesiumMath.PI);var s=e*(1-t),e=r-n,n=n,r=meanAnomalyToTrueAnomaly(a-r,t);perifocalToCartesianMatrix(e,i,n,perifocalToEquatorial);n=s*(1+t),s=Math.cos(r),r=Math.sin(r),t=n/(1+t*s);return defined(o)?(o.x=t*s,o.y=t*r,o.z=0):o=new Cartesian3(t*s,t*r,0),Matrix3.multiplyByVector(perifocalToEquatorial,o,o)}function meanAnomalyToTrueAnomaly(e,t){return eccentricAnomalyToTrueAnomaly(meanAnomalyToEccentricAnomaly(e,t),t)}var maxIterationCount=50,keplerEqConvergence=CesiumMath.EPSILON8;function meanAnomalyToEccentricAnomaly(e,t){for(var i=Math.floor(e/CesiumMath.TWO_PI),r=(e-=i*CesiumMath.TWO_PI)+t*Math.sin(e)/(1-Math.sin(e+t)+Math.sin(e)),n=Number.MAX_VALUE,a=0;a<maxIterationCount&&Math.abs(n-r)>keplerEqConvergence;++a)r=(n=r)-(n-t*Math.sin(n)-e)/(1-t*Math.cos(n));return n=r+i*CesiumMath.TWO_PI}function eccentricAnomalyToTrueAnomaly(e,t){var i=Math.floor(e/CesiumMath.TWO_PI);e-=i*CesiumMath.TWO_PI;var r=Math.cos(e)-t,t=Math.sin(e)*Math.sqrt(1-t*t),r=Math.atan2(t,r),r=CesiumMath.zeroToTwoPi(r);return e<0&&(r-=CesiumMath.TWO_PI),r+=i*CesiumMath.TWO_PI}function perifocalToCartesianMatrix(e,t,i,r){var n=Math.cos(e),a=Math.sin(e),o=Math.cos(t),e=Math.sin(t),t=Math.cos(i),i=Math.sin(i);return defined(r)?(r[0]=t*n-i*a*o,r[1]=i*n+t*a*o,r[2]=a*e,r[3]=-t*a-i*n*o,r[4]=-i*a+t*n*o,r[5]=n*e,r[6]=i*e,r[7]=-t*e,r[8]=o):r=new Matrix3(t*n-i*a*o,-t*a-i*n*o,i*e,i*n+t*a*o,-i*a+t*n*o,-t*e,a*e,n*e,o),r}var semiMajorAxis0=1.0000010178*MetersPerAstronomicalUnit,meanLongitude0=100.46645683*RadiansPerDegree,meanLongitude1=1295977422.83429*RadiansPerArcSecond,p1u=16002,p2u=21863,p3u=32004,p4u=10931,p5u=14529,p6u=16368,p7u=15318,p8u=32794,Ca1=64e-7*MetersPerAstronomicalUnit,Ca2=-152e-7*MetersPerAstronomicalUnit,Ca3=62e-7*MetersPerAstronomicalUnit,Ca4=-8e-7*MetersPerAstronomicalUnit,Ca5=32e-7*MetersPerAstronomicalUnit,Ca6=-41e-7*MetersPerAstronomicalUnit,Ca7=19e-7*MetersPerAstronomicalUnit,Ca8=-11e-7*MetersPerAstronomicalUnit,Sa1=1e-7*-150*MetersPerAstronomicalUnit,Sa2=-46e-7*MetersPerAstronomicalUnit,Sa3=68*1e-7*MetersPerAstronomicalUnit,Sa4=54e-7*MetersPerAstronomicalUnit,Sa5=14e-7*MetersPerAstronomicalUnit,Sa6=24e-7*MetersPerAstronomicalUnit,Sa7=-28e-7*MetersPerAstronomicalUnit,Sa8=22e-7*MetersPerAstronomicalUnit,q1u=10,q2u=16002,q3u=21863,q4u=10931,q5u=1473,q6u=32004,q7u=4387,q8u=73,Cl1=-325e-7,Cl2=-322e-7,Cl3=1e-7*-79,Cl4=232*1e-7,Cl5=1e-7*-52,Cl6=97e-7,Cl7=55e-7,Cl8=-41e-7,Sl1=-105e-7,Sl2=-137e-7,Sl3=258e-7,Sl4=35e-7,Sl5=1e-7*-116,Sl6=-88e-7,Sl7=-112e-7,Sl8=-8e-6,scratchDate=new JulianDate(0,0,TimeStandard$1.TAI);function computeSimonEarthMoonBarycenter(e,t){taiToTdb(e,scratchDate);var i=(scratchDate.dayNumber-epoch.dayNumber+(scratchDate.secondsOfDay-epoch.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY)/(10*TimeConstants$1.DAYS_PER_JULIAN_CENTURY),r=.3595362*i,e=semiMajorAxis0+Ca1*Math.cos(p1u*r)+Sa1*Math.sin(p1u*r)+Ca2*Math.cos(p2u*r)+Sa2*Math.sin(p2u*r)+Ca3*Math.cos(p3u*r)+Sa3*Math.sin(p3u*r)+Ca4*Math.cos(p4u*r)+Sa4*Math.sin(p4u*r)+Ca5*Math.cos(p5u*r)+Sa5*Math.sin(p5u*r)+Ca6*Math.cos(p6u*r)+Sa6*Math.sin(p6u*r)+Ca7*Math.cos(p7u*r)+Sa7*Math.sin(p7u*r)+Ca8*Math.cos(p8u*r)+Sa8*Math.sin(p8u*r),r=meanLongitude0+meanLongitude1*i+Cl1*Math.cos(q1u*r)+Sl1*Math.sin(q1u*r)+Cl2*Math.cos(q2u*r)+Sl2*Math.sin(q2u*r)+Cl3*Math.cos(q3u*r)+Sl3*Math.sin(q3u*r)+Cl4*Math.cos(q4u*r)+Sl4*Math.sin(q4u*r)+Cl5*Math.cos(q5u*r)+Sl5*Math.sin(q5u*r)+Cl6*Math.cos(q6u*r)+Sl6*Math.sin(q6u*r)+Cl7*Math.cos(q7u*r)+Sl7*Math.sin(q7u*r)+Cl8*Math.cos(q8u*r)+Sl8*Math.sin(q8u*r);return elementsToCartesian(e,.0167086342-.0004203654*i,469.97289*RadiansPerArcSecond*i,102.93734808*RadiansPerDegree+11612.3529*RadiansPerArcSecond*i,174.87317577*RadiansPerDegree-8679.27034*RadiansPerArcSecond*i,r,t)}function computeSimonMoon(e,t){taiToTdb(e,scratchDate);var i=(scratchDate.dayNumber-epoch.dayNumber+(scratchDate.secondsOfDay-epoch.secondsOfDay)/TimeConstants$1.SECONDS_PER_DAY)/TimeConstants$1.DAYS_PER_JULIAN_CENTURY,r=i*i,n=r*i,a=n*i,o=383397.7725+.004*i,s=.055545526-16e-9*i,l=5.15668983*RadiansPerDegree,c=-8e-5*i+.02966*r-42e-6*n-13e-8*a,u=83.35324312*RadiansPerDegree,d=14643420.2669*i-38.2702*r-.045047*n+21301e-8*a,h=125.04455501*RadiansPerDegree,p=-6967919.3631*i+6.3602*r+.007625*n-3586e-8*a,m=218.31664563*RadiansPerDegree,f=1732559343.4847*i-6.391*r+.006588*n-3169e-8*a,g=297.85019547*RadiansPerDegree+RadiansPerArcSecond*(1602961601.209*i-6.3706*r+.006593*n-3169e-8*a),_=134.96340251*RadiansPerDegree+RadiansPerArcSecond*(1717915923.2178*i+31.8792*r+.051635*n-2447e-7*a),y=357.52910918*RadiansPerDegree+RadiansPerArcSecond*(129596581.0481*i-.5532*r+136e-6*n-1149e-8*a),C=310.17137918*RadiansPerDegree-RadiansPerArcSecond*(6967051.436*i+6.2068*r+.007618*n-3219e-8*a),v=2*g,S=4*g,T=6*g,x=2*_,b=3*_,e=4*_,a=2*(93.27209062*RadiansPerDegree+RadiansPerArcSecond*(1739527262.8478*i-12.7512*r-.001037*n+417e-8*a));o+=3400.4*Math.cos(v)-635.6*Math.cos(v-_)-235.6*Math.cos(_)+218.1*Math.cos(v-y)+181*Math.cos(v+_),s+=.014216*Math.cos(v-_)+.008551*Math.cos(v-x)-.001383*Math.cos(_)+.001356*Math.cos(v+_)-.001147*Math.cos(S-b)-914e-6*Math.cos(S-x)+869e-6*Math.cos(v-y-_)-627e-6*Math.cos(v)-394e-6*Math.cos(S-e)+282e-6*Math.cos(v-y-x)-279e-6*Math.cos(g-_)-236e-6*Math.cos(x)+231e-6*Math.cos(S)+229e-6*Math.cos(T-e)-201e-6*Math.cos(x-a),c+=486.26*Math.cos(v-a)-40.13*Math.cos(v)+37.51*Math.cos(a)+25.73*Math.cos(x-a)+19.97*Math.cos(v-y-a),d+=-55609*Math.sin(v-_)-34711*Math.sin(v-x)-9792*Math.sin(_)+9385*Math.sin(S-b)+7505*Math.sin(S-x)+5318*Math.sin(v+_)+3484*Math.sin(S-e)-3417*Math.sin(v-y-_)-2530*Math.sin(T-e)-2376*Math.sin(v)-2075*Math.sin(v-b)-1883*Math.sin(x)-1736*Math.sin(T-5*_)+1626*Math.sin(y)-1370*Math.sin(T-b),p+=-5392*Math.sin(v-a)-540*Math.sin(y)-441*Math.sin(v)+423*Math.sin(a)-288*Math.sin(x-a),f+=-3332.9*Math.sin(v)+1197.4*Math.sin(v-_)-662.5*Math.sin(y)+396.3*Math.sin(_)-218*Math.sin(v-y);x=2*C,_=3*C;c+=46.997*Math.cos(C)*i-.614*Math.cos(v-a+C)*i+.614*Math.cos(v-a-C)*i-.0297*Math.cos(x)*r-.0335*Math.cos(C)*r+.0012*Math.cos(v-a+x)*r-16e-5*Math.cos(C)*n+4e-5*Math.cos(_)*n+4e-5*Math.cos(x)*n;y=2.116*Math.sin(C)*i-.111*Math.sin(v-a-C)*i-.0015*Math.sin(C)*r;return d+=y,f+=y,p+=-520.77*Math.sin(C)*i+13.66*Math.sin(v-a+C)*i+1.12*Math.sin(v-C)*i-1.06*Math.sin(a-C)*i+.66*Math.sin(x)*r+.371*Math.sin(C)*r-.035*Math.sin(v-a+x)*r-.015*Math.sin(v-a+C)*r+.0014*Math.sin(C)*n-.0011*Math.sin(_)*n-9e-4*Math.sin(x)*n,elementsToCartesian(o*=MetersPerKilometer,s,l+c*RadiansPerArcSecond,u+d*RadiansPerArcSecond,h+p*RadiansPerArcSecond,m+f*RadiansPerArcSecond,t)}var moonEarthMassRatio=.012300034,factor=moonEarthMassRatio/(moonEarthMassRatio+1)*-1;function computeSimonEarth(e,t){return t=computeSimonMoon(e,t),Cartesian3.multiplyByScalar(t,factor,t)}var axesTransformation=new Matrix3(1.0000000000000002,5619723173785822e-31,4690511510146299e-34,-5154129427414611e-31,.9174820620691819,-.39777715593191376,-223970096136568e-30,.39777715593191376,.9174820620691819),translation$1=new Cartesian3;function interpolateColors$1(e,t,i,r,n,a,o){var s=PolylinePipeline.numberOfPoints(e,t,n),l=i.red,c=i.green,u=i.blue,d=i.alpha,h=r.red,e=r.green,t=r.blue,n=r.alpha;if(Color.equals(i,r)){for(y=0;y<s;y++)a[o++]=Color.floatToByte(l),a[o++]=Color.floatToByte(c),a[o++]=Color.floatToByte(u),a[o++]=Color.floatToByte(d);return o}for(var p=(h-l)/s,m=(e-c)/s,f=(t-u)/s,g=(n-d)/s,_=o,y=0;y<s;y++)a[_++]=Color.floatToByte(l+y*p),a[_++]=Color.floatToByte(c+y*m),a[_++]=Color.floatToByte(u+y*f),a[_++]=Color.floatToByte(d+y*g);return _}function SimplePolylineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.colors,r=defaultValue(e.colorsPerVertex,!1);this._positions=t,this._colors=i,this._colorsPerVertex=r,this._arcType=defaultValue(e.arcType,ArcType$1.GEODESIC),this._granularity=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),this._ellipsoid=defaultValue(e.ellipsoid,Ellipsoid.WGS84),this._workerName="createSimplePolylineGeometry";t=1+t.length*Cartesian3.packedLength;t+=defined(i)?1+i.length*Color.packedLength:1,this.packedLength=t+Ellipsoid.packedLength+3}Simon1994PlanetaryPositions.computeSunPositionInEarthInertialFrame=function(e,t){return defined(e)||(e=JulianDate.now()),defined(t)||(t=new Cartesian3),translation$1=computeSimonEarthMoonBarycenter(e,translation$1),t=Cartesian3.negate(translation$1,t),computeSimonEarth(e,translation$1),Cartesian3.subtract(t,translation$1,t),Matrix3.multiplyByVector(axesTransformation,t,t),t},Simon1994PlanetaryPositions.computeMoonPositionInEarthInertialFrame=function(e,t){return defined(e)||(e=JulianDate.now()),t=computeSimonMoon(e,t),Matrix3.multiplyByVector(axesTransformation,t,t),t},SimplePolylineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._colors,a=defined(o)?o.length:0;for(t[i++]=a,r=0;r<a;++r,i+=Color.packedLength)Color.pack(o[r],t,i);return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,t[i++]=e._colorsPerVertex?1:0,t[i++]=e._arcType,t[i]=e._granularity,t},SimplePolylineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r=e[t++],n=new Array(r),a=0;a<r;++a,t+=Cartesian3.packedLength)n[a]=Cartesian3.unpack(e,t);var o=0<(r=e[t++])?new Array(r):void 0;for(a=0;a<r;++a,t+=Color.packedLength)o[a]=Color.unpack(e,t);var s=Ellipsoid.unpack(e,t);t+=Ellipsoid.packedLength;var l=1===e[t++],c=e[t++],u=e[t];return defined(i)?(i._positions=n,i._colors=o,i._ellipsoid=s,i._colorsPerVertex=l,i._arcType=c,i._granularity=u,i):new SimplePolylineGeometry({positions:n,colors:o,ellipsoid:s,colorsPerVertex:l,arcType:c,granularity:u})};var scratchArray1=new Array(2),scratchArray2=new Array(2),generateArcOptionsScratch={positions:scratchArray1,height:scratchArray2,ellipsoid:void 0,minDistance:void 0,granularity:void 0};function SphereGeometry(e){var t=defaultValue(e.radius,1),e={radii:new Cartesian3(t,t,t),stackPartitions:e.stackPartitions,slicePartitions:e.slicePartitions,vertexFormat:e.vertexFormat};this._ellipsoidGeometry=new EllipsoidGeometry(e),this._workerName="createSphereGeometry"}SimplePolylineGeometry.createGeometry=function(e){var t,i,r,n=e._positions,a=e._colors,o=e._colorsPerVertex,s=e._arcType,l=e._granularity,e=e._ellipsoid,c=CesiumMath.chordLength(l,e.maximumRadius),u=defined(a)&&!o,d=n.length,h=0;if(s===ArcType$1.GEODESIC||s===ArcType$1.RHUMB){var p,m,f=s===ArcType$1.GEODESIC?(p=CesiumMath.chordLength(l,e.maximumRadius),m=PolylinePipeline.numberOfPoints,PolylinePipeline.generateArc):(p=l,m=PolylinePipeline.numberOfPointsRhumbLine,PolylinePipeline.generateRhumbArc),g=PolylinePipeline.extractHeights(n,e),_=generateArcOptionsScratch;if(s===ArcType$1.GEODESIC?_.minDistance=c:_.granularity=l,_.ellipsoid=e,u){for(var y=0,C=0;C<d-1;C++)y+=m(n[C],n[C+1],p)+1;t=new Float64Array(3*y),r=new Uint8Array(4*y),_.positions=scratchArray1,_.height=scratchArray2;var v=0;for(C=0;C<d-1;++C){scratchArray1[0]=n[C],scratchArray1[1]=n[C+1],scratchArray2[0]=g[C],scratchArray2[1]=g[C+1];var S=f(_);if(defined(a))for(var T=S.length/3,x=a[C],b=0;b<T;++b)r[v++]=Color.floatToByte(x.red),r[v++]=Color.floatToByte(x.green),r[v++]=Color.floatToByte(x.blue),r[v++]=Color.floatToByte(x.alpha);t.set(S,h),h+=S.length}}else if(_.positions=n,_.height=g,t=new Float64Array(f(_)),defined(a)){for(r=new Uint8Array(t.length/3*4),C=0;C<d-1;++C)h=interpolateColors$1(n[C],n[C+1],a[C],a[C+1],c,r,h);var E=a[d-1];r[h++]=Color.floatToByte(E.red),r[h++]=Color.floatToByte(E.green),r[h++]=Color.floatToByte(E.blue),r[h++]=Color.floatToByte(E.alpha)}}else{i=u?2*d-2:d,t=new Float64Array(3*i),r=defined(a)?new Uint8Array(4*i):void 0;var P=0,A=0;for(C=0;C<d;++C){var w=n[C];if(u&&0<C&&(Cartesian3.pack(w,t,P),P+=3,x=a[C-1],r[A++]=Color.floatToByte(x.red),r[A++]=Color.floatToByte(x.green),r[A++]=Color.floatToByte(x.blue),r[A++]=Color.floatToByte(x.alpha)),u&&C===d-1)break;Cartesian3.pack(w,t,P),P+=3,defined(a)&&(x=a[C],r[A++]=Color.floatToByte(x.red),r[A++]=Color.floatToByte(x.green),r[A++]=Color.floatToByte(x.blue),r[A++]=Color.floatToByte(x.alpha))}}e=new GeometryAttributes;e.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:t}),defined(a)&&(e.color=new GeometryAttribute({componentDatatype:ComponentDatatype$1.UNSIGNED_BYTE,componentsPerAttribute:4,values:r,normalize:!0}));var E=2*((i=t.length/3)-1),D=IndexDatatype$1.createTypedArray(i,E),M=0;for(C=0;C<i-1;++C)D[M++]=C,D[M++]=C+1;return new Geometry({attributes:e,indices:D,primitiveType:PrimitiveType$1.LINES,boundingSphere:BoundingSphere.fromPoints(n)})},SphereGeometry.packedLength=EllipsoidGeometry.packedLength,SphereGeometry.pack=function(e,t,i){return EllipsoidGeometry.pack(e._ellipsoidGeometry,t,i)};var scratchEllipsoidGeometry=new EllipsoidGeometry,scratchOptions$k={radius:void 0,radii:new Cartesian3,vertexFormat:new VertexFormat,stackPartitions:void 0,slicePartitions:void 0};function SphereOutlineGeometry(e){var t=defaultValue(e.radius,1),e={radii:new Cartesian3(t,t,t),stackPartitions:e.stackPartitions,slicePartitions:e.slicePartitions,subdivisions:e.subdivisions};this._ellipsoidGeometry=new EllipsoidOutlineGeometry(e),this._workerName="createSphereOutlineGeometry"}SphereGeometry.unpack=function(e,t,i){t=EllipsoidGeometry.unpack(e,t,scratchEllipsoidGeometry);return scratchOptions$k.vertexFormat=VertexFormat.clone(t._vertexFormat,scratchOptions$k.vertexFormat),scratchOptions$k.stackPartitions=t._stackPartitions,scratchOptions$k.slicePartitions=t._slicePartitions,defined(i)?(Cartesian3.clone(t._radii,scratchOptions$k.radii),i._ellipsoidGeometry=new EllipsoidGeometry(scratchOptions$k),i):(scratchOptions$k.radius=t._radii.x,new SphereGeometry(scratchOptions$k))},SphereGeometry.createGeometry=function(e){return EllipsoidGeometry.createGeometry(e._ellipsoidGeometry)},SphereOutlineGeometry.packedLength=EllipsoidOutlineGeometry.packedLength,SphereOutlineGeometry.pack=function(e,t,i){return EllipsoidOutlineGeometry.pack(e._ellipsoidGeometry,t,i)};var scratchEllipsoidGeometry$1=new EllipsoidOutlineGeometry,scratchOptions$l={radius:void 0,radii:new Cartesian3,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0};function Spherical(e,t,i){this.clock=defaultValue(e,0),this.cone=defaultValue(t,0),this.magnitude=defaultValue(i,1)}function TerrainData(){DeveloperError.throwInstantiationError()}SphereOutlineGeometry.unpack=function(e,t,i){t=EllipsoidOutlineGeometry.unpack(e,t,scratchEllipsoidGeometry$1);return scratchOptions$l.stackPartitions=t._stackPartitions,scratchOptions$l.slicePartitions=t._slicePartitions,scratchOptions$l.subdivisions=t._subdivisions,defined(i)?(Cartesian3.clone(t._radii,scratchOptions$l.radii),i._ellipsoidGeometry=new EllipsoidOutlineGeometry(scratchOptions$l),i):(scratchOptions$l.radius=t._radii.x,new SphereOutlineGeometry(scratchOptions$l))},SphereOutlineGeometry.createGeometry=function(e){return EllipsoidOutlineGeometry.createGeometry(e._ellipsoidGeometry)},Spherical.fromCartesian3=function(e,t){var i=e.x,r=e.y,n=e.z,e=i*i+r*r;return defined(t)||(t=new Spherical),t.clock=Math.atan2(r,i),t.cone=Math.atan2(Math.sqrt(e),n),t.magnitude=Math.sqrt(e+n*n),t},Spherical.clone=function(e,t){if(defined(e))return defined(t)?(t.clock=e.clock,t.cone=e.cone,t.magnitude=e.magnitude,t):new Spherical(e.clock,e.cone,e.magnitude)},Spherical.normalize=function(e,t){return defined(t)?(t.clock=e.clock,t.cone=e.cone,t.magnitude=1,t):new Spherical(e.clock,e.cone,1)},Spherical.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e.clock===t.clock&&e.cone===t.cone&&e.magnitude===t.magnitude},Spherical.equalsEpsilon=function(e,t,i){return i=defaultValue(i,0),e===t||defined(e)&&defined(t)&&Math.abs(e.clock-t.clock)<=i&&Math.abs(e.cone-t.cone)<=i&&Math.abs(e.magnitude-t.magnitude)<=i},Spherical.prototype.equals=function(e){return Spherical.equals(this,e)},Spherical.prototype.clone=function(e){return Spherical.clone(this,e)},Spherical.prototype.equalsEpsilon=function(e,t){return Spherical.equalsEpsilon(this,e,t)},Spherical.prototype.toString=function(){return"("+this.clock+", "+this.cone+", "+this.magnitude+")"},Object.defineProperties(TerrainData.prototype,{credits:{get:DeveloperError.throwInstantiationError},waterMask:{get:DeveloperError.throwInstantiationError}}),TerrainData.prototype.interpolateHeight=DeveloperError.throwInstantiationError,TerrainData.prototype.isChildAvailable=DeveloperError.throwInstantiationError,TerrainData.prototype.createMesh=DeveloperError.throwInstantiationError,TerrainData.prototype.upsample=DeveloperError.throwInstantiationError,TerrainData.prototype.wasCreatedByUpsampling=DeveloperError.throwInstantiationError;var TileEdge={WEST:0,NORTH:1,EAST:2,SOUTH:3,NORTHWEST:4,NORTHEAST:5,SOUTHWEST:6,SOUTHEAST:7};function TilingScheme(e){}function compareIntervalStartTimes(e,t){return JulianDate.compare(e.start,t.start)}function TimeIntervalCollection(e){if(this._intervals=[],this._changedEvent=new Event,defined(e))for(var t=e.length,i=0;i<t;i++)this.addInterval(e[i])}Object.defineProperties(TilingScheme.prototype,{ellipsoid:{get:DeveloperError.throwInstantiationError},rectangle:{get:DeveloperError.throwInstantiationError},projection:{get:DeveloperError.throwInstantiationError}}),TilingScheme.prototype.getNumberOfXTilesAtLevel=DeveloperError.throwInstantiationError,TilingScheme.prototype.getNumberOfYTilesAtLevel=DeveloperError.throwInstantiationError,TilingScheme.prototype.rectangleToNativeRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.tileXYToNativeRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.tileXYToRectangle=DeveloperError.throwInstantiationError,TilingScheme.prototype.positionToTileXY=DeveloperError.throwInstantiationError,Object.defineProperties(TimeIntervalCollection.prototype,{changedEvent:{get:function(){return this._changedEvent}},start:{get:function(){var e=this._intervals;return 0===e.length?void 0:e[0].start}},isStartIncluded:{get:function(){var e=this._intervals;return 0!==e.length&&e[0].isStartIncluded}},stop:{get:function(){var e=this._intervals,t=e.length;return 0===t?void 0:e[t-1].stop}},isStopIncluded:{get:function(){var e=this._intervals,t=e.length;return 0!==t&&e[t-1].isStopIncluded}},length:{get:function(){return this._intervals.length}},isEmpty:{get:function(){return 0===this._intervals.length}}}),TimeIntervalCollection.prototype.equals=function(e,t){if(this===e)return!0;if(!(e instanceof TimeIntervalCollection))return!1;var i=this._intervals,r=e._intervals,n=i.length;if(n!==r.length)return!1;for(var a=0;a<n;a++)if(!TimeInterval.equals(i[a],r[a],t))return!1;return!0},TimeIntervalCollection.prototype.get=function(e){return this._intervals[e]},TimeIntervalCollection.prototype.removeAll=function(){0<this._intervals.length&&(this._intervals.length=0,this._changedEvent.raiseEvent(this))},TimeIntervalCollection.prototype.findIntervalContainingDate=function(e){e=this.indexOf(e);return 0<=e?this._intervals[e]:void 0},TimeIntervalCollection.prototype.findDataForIntervalContainingDate=function(e){e=this.indexOf(e);return 0<=e?this._intervals[e].data:void 0},TimeIntervalCollection.prototype.contains=function(e){return 0<=this.indexOf(e)};var indexOfScratch=new TimeInterval;TimeIntervalCollection.prototype.indexOf=function(e){var t=this._intervals;indexOfScratch.start=e,indexOfScratch.stop=e;var i=binarySearch(t,indexOfScratch,compareIntervalStartTimes);return 0<=i?t[i].isStartIncluded?i:0<i&&t[i-1].stop.equals(e)&&t[i-1].isStopIncluded?i-1:~i:0<(i=~i)&&i-1<t.length&&TimeInterval.contains(t[i-1],e)?i-1:~i},TimeIntervalCollection.prototype.findInterval=function(e){for(var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).start,i=e.stop,r=e.isStartIncluded,n=e.isStopIncluded,a=this._intervals,o=0,s=a.length;o<s;o++){var l=a[o];if((!defined(t)||l.start.equals(t))&&(!defined(i)||l.stop.equals(i))&&(!defined(r)||l.isStartIncluded===r)&&(!defined(n)||l.isStopIncluded===n))return a[o]}},TimeIntervalCollection.prototype.addInterval=function(e,t){if(!e.isEmpty){var i=this._intervals;if(0===i.length||JulianDate.greaterThan(e.start,i[i.length-1].stop))return i.push(e),void this._changedEvent.raiseEvent(this);var r,n=binarySearch(i,e,compareIntervalStartTimes);for(n<0?n=~n:0<n&&e.isStartIncluded&&i[n-1].isStartIncluded&&i[n-1].start.equals(e.start)?--n:n<i.length&&!e.isStartIncluded&&i[n].isStartIncluded&&i[n].start.equals(e.start)&&++n,0<n&&(0<(r=JulianDate.compare(i[n-1].stop,e.start))||0===r&&(i[n-1].isStopIncluded||e.isStartIncluded))&&((defined(t)?t(i[n-1].data,e.data):i[n-1].data===e.data)?(e=JulianDate.greaterThan(e.stop,i[n-1].stop)?new TimeInterval({start:i[n-1].start,stop:e.stop,isStartIncluded:i[n-1].isStartIncluded,isStopIncluded:e.isStopIncluded,data:e.data}):new TimeInterval({start:i[n-1].start,stop:i[n-1].stop,isStartIncluded:i[n-1].isStartIncluded,isStopIncluded:i[n-1].isStopIncluded||e.stop.equals(i[n-1].stop)&&e.isStopIncluded,data:e.data}),i.splice(n-1,1),--n):((0<(r=JulianDate.compare(i[n-1].stop,e.stop))||0===r&&i[n-1].isStopIncluded&&!e.isStopIncluded)&&i.splice(n,0,new TimeInterval({start:e.stop,stop:i[n-1].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:i[n-1].isStopIncluded,data:i[n-1].data})),i[n-1]=new TimeInterval({start:i[n-1].start,stop:e.start,isStartIncluded:i[n-1].isStartIncluded,isStopIncluded:!e.isStartIncluded,data:i[n-1].data})));n<i.length&&(0<(r=JulianDate.compare(e.stop,i[n].start))||0===r&&(e.isStopIncluded||i[n].isStartIncluded));)if(defined(t)?t(i[n].data,e.data):i[n].data===e.data)e=new TimeInterval({start:e.start,stop:(JulianDate.greaterThan(i[n].stop,e.stop)?i[n]:e).stop,isStartIncluded:e.isStartIncluded,isStopIncluded:(JulianDate.greaterThan(i[n].stop,e.stop)?i[n]:e).isStopIncluded,data:e.data}),i.splice(n,1);else{if(i[n]=new TimeInterval({start:e.stop,stop:i[n].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:i[n].isStopIncluded,data:i[n].data}),!i[n].isEmpty)break;i.splice(n,1)}i.splice(n,0,e),this._changedEvent.raiseEvent(this)}},TimeIntervalCollection.prototype.removeInterval=function(e){if(e.isEmpty)return!1;var t=this._intervals,i=binarySearch(t,e,compareIntervalStartTimes);i<0&&(i=~i);var r=!1;for(0<i&&(JulianDate.greaterThan(t[i-1].stop,e.start)||t[i-1].stop.equals(e.start)&&t[i-1].isStopIncluded&&e.isStartIncluded)&&(r=!0,(JulianDate.greaterThan(t[i-1].stop,e.stop)||t[i-1].isStopIncluded&&!e.isStopIncluded&&t[i-1].stop.equals(e.stop))&&t.splice(i,0,new TimeInterval({start:e.stop,stop:t[i-1].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:t[i-1].isStopIncluded,data:t[i-1].data})),t[i-1]=new TimeInterval({start:t[i-1].start,stop:e.start,isStartIncluded:t[i-1].isStartIncluded,isStopIncluded:!e.isStartIncluded,data:t[i-1].data})),i<t.length&&!e.isStartIncluded&&t[i].isStartIncluded&&e.start.equals(t[i].start)&&(r=!0,t.splice(i,0,new TimeInterval({start:t[i].start,stop:t[i].start,isStartIncluded:!0,isStopIncluded:!0,data:t[i].data})),++i);i<t.length&&JulianDate.greaterThan(e.stop,t[i].stop);)r=!0,t.splice(i,1);return i<t.length&&e.stop.equals(t[i].stop)&&(r=!0,!e.isStopIncluded&&t[i].isStopIncluded?i+1<t.length&&t[i+1].start.equals(e.stop)&&t[i].data===t[i+1].data?(t.splice(i,1),t[i]=new TimeInterval({start:t[i].start,stop:t[i].stop,isStartIncluded:!0,isStopIncluded:t[i].isStopIncluded,data:t[i].data})):t[i]=new TimeInterval({start:e.stop,stop:e.stop,isStartIncluded:!0,isStopIncluded:!0,data:t[i].data}):t.splice(i,1)),i<t.length&&(JulianDate.greaterThan(e.stop,t[i].start)||e.stop.equals(t[i].start)&&e.isStopIncluded&&t[i].isStartIncluded)&&(r=!0,t[i]=new TimeInterval({start:e.stop,stop:t[i].stop,isStartIncluded:!e.isStopIncluded,isStopIncluded:t[i].isStopIncluded,data:t[i].data})),r&&this._changedEvent.raiseEvent(this),r},TimeIntervalCollection.prototype.intersect=function(e,t,i){for(var r=new TimeIntervalCollection,n=0,a=0,o=this._intervals,s=e._intervals;n<o.length&&a<s.length;){var l,c=o[n],u=s[a];JulianDate.lessThan(c.stop,u.start)?++n:JulianDate.lessThan(u.stop,c.start)?++a:((defined(i)||defined(t)&&t(c.data,u.data)||!defined(t)&&u.data===c.data)&&((l=TimeInterval.intersect(c,u,new TimeInterval,i)).isEmpty||r.addInterval(l,t)),JulianDate.lessThan(c.stop,u.stop)||c.stop.equals(u.stop)&&!c.isStopIncluded&&u.isStopIncluded?++n:++a)}return r},TimeIntervalCollection.fromJulianDateArray=function(e,t){defined(t)||(t=new TimeIntervalCollection);var i=e.julianDates,r=i.length,n=e.dataCallback,a=defaultValue(e.isStartIncluded,!0),o=defaultValue(e.isStopIncluded,!0),s=defaultValue(e.leadingInterval,!1),e=defaultValue(e.trailingInterval,!1),l=0;s&&(++l,(u=new TimeInterval({start:Iso8601.MINIMUM_VALUE,stop:i[0],isStartIncluded:!0,isStopIncluded:!a})).data=defined(n)?n(u,t.length):t.length,t.addInterval(u));for(var c=0;c<r-1;++c){var u,d=i[c],h=i[c+1];(u=new TimeInterval({start:d,stop:h,isStartIncluded:t.length!==l||a,isStopIncluded:c===r-2&&o})).data=defined(n)?n(u,t.length):t.length,t.addInterval(u),0}return e&&((u=new TimeInterval({start:i[r-1],stop:Iso8601.MAXIMUM_VALUE,isStartIncluded:!o,isStopIncluded:!0})).data=defined(n)?n(u,t.length):t.length,t.addInterval(u)),t};var scratchGregorianDate=new GregorianDate,monthLengths=[0,31,28,31,30,31,30,31,31,30,31,30,31];function addToDate(e,t,i){defined(i)||(i=new JulianDate),JulianDate.toGregorianDate(e,scratchGregorianDate);var r=scratchGregorianDate.millisecond+t.millisecond,n=scratchGregorianDate.second+t.second,a=scratchGregorianDate.minute+t.minute,e=scratchGregorianDate.hour+t.hour,o=scratchGregorianDate.day+t.day,s=scratchGregorianDate.month+t.month,l=scratchGregorianDate.year+t.year;for(1e3<=r&&(n+=Math.floor(r/1e3),r%=1e3),60<=n&&(a+=Math.floor(n/60),n%=60),60<=a&&(e+=Math.floor(a/60),a%=60),24<=e&&(o+=Math.floor(e/24),e%=24),monthLengths[2]=isLeapYear(l)?29:28;o>monthLengths[s]||13<=s;)o>monthLengths[s]&&(o-=monthLengths[s],++s),13<=s&&(--s,l+=Math.floor(s/12),s%=12,++s),monthLengths[2]=isLeapYear(l)?29:28;return scratchGregorianDate.millisecond=r,scratchGregorianDate.second=n,scratchGregorianDate.minute=a,scratchGregorianDate.hour=e,scratchGregorianDate.day=o,scratchGregorianDate.month=s,scratchGregorianDate.year=l,JulianDate.fromGregorianDate(scratchGregorianDate,i)}var scratchJulianDate=new JulianDate,durationRegex=/P(?:([\d.,]+)Y)?(?:([\d.,]+)M)?(?:([\d.,]+)W)?(?:([\d.,]+)D)?(?:T(?:([\d.,]+)H)?(?:([\d.,]+)M)?(?:([\d.,]+)S)?)?/;function parseDuration(e,t){if(defined(e)&&0!==e.length){if(t.year=0,t.month=0,t.day=0,t.hour=0,t.minute=0,t.second=0,"P"===e[t.millisecond=0]){var i=e.match(durationRegex);if(!defined(i))return;defined(i[1])&&(t.year=Number(i[1].replace(",","."))),defined(i[2])&&(t.month=Number(i[2].replace(",","."))),defined(i[3])&&(t.day=7*Number(i[3].replace(",","."))),defined(i[4])&&(t.day+=Number(i[4].replace(",","."))),defined(i[5])&&(t.hour=Number(i[5].replace(",","."))),defined(i[6])&&(t.minute=Number(i[6].replace(",","."))),defined(i[7])&&(i=Number(i[7].replace(",",".")),t.second=Math.floor(i),t.millisecond=i%1*1e3)}else"Z"!==e[e.length-1]&&(e+="Z"),JulianDate.toGregorianDate(JulianDate.fromIso8601(e,scratchJulianDate),t);return t.year||t.month||t.day||t.hour||t.minute||t.second||t.millisecond}}var scratchDuration=new GregorianDate;TimeIntervalCollection.fromIso8601=function(e,t){var i=e.iso8601.split("/"),r=JulianDate.fromIso8601(i[0]),n=JulianDate.fromIso8601(i[1]),a=[];if(parseDuration(i[2],scratchDuration)){var o=JulianDate.clone(r);for(a.push(o);JulianDate.compare(o,n)<0;){o=addToDate(o,scratchDuration);JulianDate.compare(n,o)<=0&&JulianDate.clone(n,o),a.push(o)}}else a.push(r,n);return TimeIntervalCollection.fromJulianDateArray({julianDates:a,isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)},TimeIntervalCollection.fromIso8601DateArray=function(e,t){return TimeIntervalCollection.fromJulianDateArray({julianDates:e.iso8601Dates.map(function(e){return JulianDate.fromIso8601(e)}),isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)},TimeIntervalCollection.fromIso8601DurationArray=function(e,t){for(var i,r,n=e.epoch,a=e.iso8601Durations,o=defaultValue(e.relativeToPrevious,!1),s=[],l=a.length,c=0;c<l;++c)!parseDuration(a[c],scratchDuration)&&0!==c||(i=o&&defined(r)?addToDate(r,scratchDuration):addToDate(n,scratchDuration),s.push(i),r=i);return TimeIntervalCollection.fromJulianDateArray({julianDates:s,isStartIncluded:e.isStartIncluded,isStopIncluded:e.isStopIncluded,leadingInterval:e.leadingInterval,trailingInterval:e.trailingInterval,dataCallback:e.dataCallback},t)};var defaultScale=new Cartesian3(1,1,1),defaultTranslation=Cartesian3.ZERO,defaultRotation=Quaternion.IDENTITY;function TranslationRotationScale(e,t,i){this.translation=Cartesian3.clone(defaultValue(e,defaultTranslation)),this.rotation=Quaternion.clone(defaultValue(t,defaultRotation)),this.scale=Cartesian3.clone(defaultValue(i,defaultScale))}TranslationRotationScale.prototype.equals=function(e){return this===e||defined(e)&&Cartesian3.equals(this.translation,e.translation)&&Quaternion.equals(this.rotation,e.rotation)&&Cartesian3.equals(this.scale,e.scale)};var context2DsByWidthAndHeight={};function getImagePixels(e,t,i){defined(t)||(t=e.width),defined(i)||(i=e.height);var r=context2DsByWidthAndHeight[t];defined(r)||(r={},context2DsByWidthAndHeight[t]=r);var n,a=r[i];return defined(a)||((n=document.createElement("canvas")).width=t,n.height=i,(a=n.getContext("2d")).globalCompositeOperation="copy",r[i]=a),a.drawImage(e,0,0,t,i),a.getImageData(0,0,t,i).data}function DataRectangle(e,t){this.rectangle=e,this.maxLevel=t}function VRTheWorldTerrainProvider(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=Resource.createIfNeeded(e.url);this._resource=t,this._errorEvent=new Event,this._ready=!1,this._readyPromise=when.defer(),this._terrainDataStructure={heightScale:.001,heightOffset:-1e3,elementsPerHeight:3,stride:4,elementMultiplier:256,isBigEndian:!0,lowestEncodedHeight:0,highestEncodedHeight:16777215};t=e.credit;"string"==typeof t&&(t=new Credit(t)),this._credit=t,this._tilingScheme=void 0,this._rectangles=[];var i,u=this,d=defaultValue(e.ellipsoid,Ellipsoid.WGS84);function r(e){var t=e.getElementsByTagName("SRS")[0].textContent;if("EPSG:4326"===t){u._tilingScheme=new GeographicTilingScheme({ellipsoid:d});var i=e.getElementsByTagName("TileFormat")[0];u._heightmapWidth=parseInt(i.getAttribute("width"),10),u._heightmapHeight=parseInt(i.getAttribute("height"),10),u._levelZeroMaximumGeometricError=TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(d,Math.min(u._heightmapWidth,u._heightmapHeight),u._tilingScheme.getNumberOfXTilesAtLevel(0));for(var r=e.getElementsByTagName("DataExtent"),n=0;n<r.length;++n){var a=r[n],o=CesiumMath.toRadians(parseFloat(a.getAttribute("minx"))),s=CesiumMath.toRadians(parseFloat(a.getAttribute("miny"))),l=CesiumMath.toRadians(parseFloat(a.getAttribute("maxx"))),c=CesiumMath.toRadians(parseFloat(a.getAttribute("maxy"))),a=parseInt(a.getAttribute("maxlevel"),10);u._rectangles.push(new DataRectangle(new Rectangle(o,s,l,c),a))}u._ready=!0,u._readyPromise.resolve(!0)}else h("SRS "+t+" is not supported.")}function h(e){e=defaultValue(e,"An error occurred while accessing "+u._resource.url+".");i=TileProviderError.handleError(i,u,u._errorEvent,e,void 0,void 0,void 0,n)}function n(){when(u._resource.fetchXML(),r,h)}n()}Object.defineProperties(VRTheWorldTerrainProvider.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}},availability:{get:function(){}}}),VRTheWorldTerrainProvider.prototype.requestTileGeometry=function(t,i,r,e){var n=this._tilingScheme.getNumberOfYTilesAtLevel(r),e=this._resource.getDerivedResource({url:r+"/"+t+"/"+(n-i-1)+".tif",queryParameters:{cesium:!0},request:e}).fetchImage({preferImageBitmap:!0});if(defined(e)){var a=this;return when(e).then(function(e){return new HeightmapTerrainData({buffer:getImagePixels(e),width:a._heightmapWidth,height:a._heightmapHeight,childTileMask:getChildMask(a,t,i,r),structure:a._terrainDataStructure})})}},VRTheWorldTerrainProvider.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)};var rectangleScratch$4=new Rectangle;function getChildMask(e,t,i,r){for(var n=e._tilingScheme,a=e._rectangles,o=n.tileXYToRectangle(t,i,r),s=0,l=0;l<a.length&&15!==s;++l){var c=a[l];c.maxLevel<=r||(c=c.rectangle,defined(Rectangle.intersection(c,o,rectangleScratch$4))&&(isTileInRectangle(n,c,2*t,2*i,r+1)&&(s|=4),isTileInRectangle(n,c,2*t+1,2*i,r+1)&&(s|=8),isTileInRectangle(n,c,2*t,2*i+1,r+1)&&(s|=1),isTileInRectangle(n,c,2*t+1,2*i+1,r+1)&&(s|=2)))}return s}function isTileInRectangle(e,t,i,r,n){n=e.tileXYToRectangle(i,r,n);return defined(Rectangle.intersection(n,t,rectangleScratch$4))}function VideoSynchronizer(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._clock=void 0,this._element=void 0,this._clockSubscription=void 0,this._seekFunction=void 0,this._lastPlaybackRate=void 0,this.clock=e.clock,this.element=e.element,this.epoch=defaultValue(e.epoch,Iso8601.MINIMUM_VALUE),this.tolerance=defaultValue(e.tolerance,1),this._seeking=!1,this._seekFunction=void 0,this._firstTickAfterSeek=!1}function createSeekFunction(e){return function(){e._seeking=!1,e._firstTickAfterSeek=!0}}VRTheWorldTerrainProvider.prototype.getTileDataAvailable=function(e,t,i){},VRTheWorldTerrainProvider.prototype.loadTileDataAvailability=function(e,t,i){},Object.defineProperties(VideoSynchronizer.prototype,{clock:{get:function(){return this._clock},set:function(e){var t=this._clock;t!==e&&(defined(t)&&(this._clockSubscription(),this._clockSubscription=void 0),defined(e)&&(this._clockSubscription=e.onTick.addEventListener(VideoSynchronizer.prototype._onTick,this)),this._clock=e)}},element:{get:function(){return this._element},set:function(e){var t=this._element;t!==e&&(defined(t)&&t.removeEventListener("seeked",this._seekFunction,!1),defined(e)&&(this._seeking=!1,this._seekFunction=createSeekFunction(this),e.addEventListener("seeked",this._seekFunction,!1)),this._element=e,this._seeking=!1,this._firstTickAfterSeek=!1)}}}),VideoSynchronizer.prototype.destroy=function(){return this.element=void 0,this.clock=void 0,destroyObject(this)},VideoSynchronizer.prototype.isDestroyed=function(){return!1},VideoSynchronizer.prototype._trySetPlaybackRate=function(e){if(this._lastPlaybackRate!==e.multiplier){var t=this._element;try{t.playbackRate=e.multiplier}catch(e){t.playbackRate=0}this._lastPlaybackRate=e.multiplier}},VideoSynchronizer.prototype._onTick=function(e){var t,i,r,n=this._element;!defined(n)||n.readyState<2||(i=n.paused,(r=e.shouldAnimate)===i&&(r?n.play():n.pause()),this._seeking||this._firstTickAfterSeek?this._firstTickAfterSeek=!1:(this._trySetPlaybackRate(e),t=e.currentTime,i=defaultValue(this.epoch,Iso8601.MINIMUM_VALUE),e=JulianDate.secondsDifference(t,i),t=n.duration,i=n.currentTime,e=n.loop?((e%=t)<0&&(e=t-e),e):t<e?t:e<0?0:e,r=r?defaultValue(this.tolerance,1):.001,Math.abs(e-i)>r&&(this._seeking=!0,n.currentTime=e)))};var WallGeometryLibrary={};function latLonEquals(e,t){return CesiumMath.equalsEpsilon(e.latitude,t.latitude,CesiumMath.EPSILON10)&&CesiumMath.equalsEpsilon(e.longitude,t.longitude,CesiumMath.EPSILON10)}var scratchCartographic1$2=new Cartographic,scratchCartographic2$1=new Cartographic;function removeDuplicates(e,t,i,r){var n=(t=arrayRemoveDuplicates(t,Cartesian3.equalsEpsilon)).length;if(!(n<2)){var a=defined(r),o=defined(i),s=new Array(n),l=new Array(n),c=new Array(n),u=t[0];s[0]=u;var d=e.cartesianToCartographic(u,scratchCartographic1$2);o&&(d.height=i[0]),l[0]=d.height,c[0]=a?r[0]:0;for(var h=l[0]===c[0],p=1,m=1;m<n;++m){var f=t[m],g=e.cartesianToCartographic(f,scratchCartographic2$1);o&&(g.height=i[m]),h=h&&0===g.height,latLonEquals(d,g)?d.height<g.height&&(l[p-1]=g.height):(s[p]=f,l[p]=g.height,c[p]=a?r[m]:0,h=h&&l[p]===c[p],Cartographic.clone(g,d),++p)}if(!(h||p<2))return s.length=p,l.length=p,c.length=p,{positions:s,topHeights:l,bottomHeights:c}}}var positionsArrayScratch=new Array(2),heightsArrayScratch=new Array(2),generateArcOptionsScratch$1={positions:void 0,height:void 0,granularity:void 0,ellipsoid:void 0};WallGeometryLibrary.computePositions=function(e,t,i,r,n,a){var o=removeDuplicates(e,t,i,r);if(defined(o)){t=o.positions,i=o.topHeights,r=o.bottomHeights;var s,l,c=t.length,o=c-2,u=CesiumMath.chordLength(n,e.maximumRadius),d=generateArcOptionsScratch$1;if(d.minDistance=u,d.ellipsoid=e,a){for(var h=0,p=0;p<c-1;p++)h+=PolylinePipeline.numberOfPoints(t[p],t[p+1],u)+1;s=new Float64Array(3*h),l=new Float64Array(3*h);var m=positionsArrayScratch,f=heightsArrayScratch;d.positions=m,d.height=f;var g=0;for(p=0;p<c-1;p++){m[0]=t[p],m[1]=t[p+1],f[0]=i[p],f[1]=i[p+1];var _=PolylinePipeline.generateArc(d);s.set(_,g),f[0]=r[p],f[1]=r[p+1],l.set(PolylinePipeline.generateArc(d),g),g+=_.length}}else d.positions=t,d.height=i,s=new Float64Array(PolylinePipeline.generateArc(d)),d.height=r,l=new Float64Array(PolylinePipeline.generateArc(d));return{bottomPositions:l,topPositions:s,numCorners:o}}};var scratchCartesian3Position1=new Cartesian3,scratchCartesian3Position2=new Cartesian3,scratchCartesian3Position4=new Cartesian3,scratchCartesian3Position5=new Cartesian3,scratchBitangent$4=new Cartesian3,scratchTangent$4=new Cartesian3,scratchNormal$6=new Cartesian3;function WallGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.maximumHeights,r=e.minimumHeights,n=defaultValue(e.vertexFormat,VertexFormat.DEFAULT),a=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),e=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._positions=t,this._minimumHeights=r,this._maximumHeights=i,this._vertexFormat=VertexFormat.clone(n),this._granularity=a,this._ellipsoid=Ellipsoid.clone(e),this._workerName="createWallGeometry";t=1+t.length*Cartesian3.packedLength+2;defined(r)&&(t+=r.length),defined(i)&&(t+=i.length),this.packedLength=t+Ellipsoid.packedLength+VertexFormat.packedLength+1}WallGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._minimumHeights,a=defined(o)?o.length:0;if(t[i++]=a,defined(o))for(r=0;r<a;++r)t[i++]=o[r];var s=e._maximumHeights;if(a=defined(s)?s.length:0,t[i++]=a,defined(s))for(r=0;r<a;++r)t[i++]=s[r];return Ellipsoid.pack(e._ellipsoid,t,i),i+=Ellipsoid.packedLength,VertexFormat.pack(e._vertexFormat,t,i),t[i+=VertexFormat.packedLength]=e._granularity,t};var scratchEllipsoid$c=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchVertexFormat$c=new VertexFormat,scratchOptions$m={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:scratchEllipsoid$c,vertexFormat:scratchVertexFormat$c,granularity:void 0};WallGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r,n,a=e[t++],o=new Array(a),s=0;s<a;++s,t+=Cartesian3.packedLength)o[s]=Cartesian3.unpack(e,t);if(0<(a=e[t++]))for(r=new Array(a),s=0;s<a;++s)r[s]=e[t++];if(0<(a=e[t++]))for(n=new Array(a),s=0;s<a;++s)n[s]=e[t++];var l=Ellipsoid.unpack(e,t,scratchEllipsoid$c);t+=Ellipsoid.packedLength;var c=VertexFormat.unpack(e,t,scratchVertexFormat$c),u=e[t+=VertexFormat.packedLength];return defined(i)?(i._positions=o,i._minimumHeights=r,i._maximumHeights=n,i._ellipsoid=Ellipsoid.clone(l,i._ellipsoid),i._vertexFormat=VertexFormat.clone(c,i._vertexFormat),i._granularity=u,i):(scratchOptions$m.positions=o,scratchOptions$m.minimumHeights=r,scratchOptions$m.maximumHeights=n,scratchOptions$m.granularity=u,new WallGeometry(scratchOptions$m))},WallGeometry.fromConstantHeights=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.minimumHeight,r=e.maximumHeight,n=defined(i),a=defined(r);if(n||a)for(var o=t.length,s=n?new Array(o):void 0,l=a?new Array(o):void 0,c=0;c<o;++c)n&&(s[c]=i),a&&(l[c]=r);return new WallGeometry({positions:t,maximumHeights:l,minimumHeights:s,ellipsoid:e.ellipsoid,vertexFormat:e.vertexFormat})},WallGeometry.createGeometry=function(e){var t=e._positions,i=e._minimumHeights,r=e._maximumHeights,n=e._vertexFormat,a=e._granularity,o=e._ellipsoid,r=WallGeometryLibrary.computePositions(o,t,r,i,a,!0);if(defined(r)){for(var s=r.bottomPositions,l=r.topPositions,i=r.numCorners,c=l.length,a=2*c,u=n.position?new Float64Array(a):void 0,d=n.normal?new Float32Array(a):void 0,h=n.tangent?new Float32Array(a):void 0,p=n.bitangent?new Float32Array(a):void 0,m=n.st?new Float32Array(a/3*2):void 0,f=0,g=0,_=0,y=0,C=0,v=scratchNormal$6,S=scratchTangent$4,T=scratchBitangent$4,x=!0,b=0,E=1/((c/=3)-i-1),P=0;P<c;++P){var A,w=3*P,D=Cartesian3.fromArray(l,w,scratchCartesian3Position1),M=Cartesian3.fromArray(s,w,scratchCartesian3Position2);n.position&&(u[f++]=M.x,u[f++]=M.y,u[f++]=M.z,u[f++]=D.x,u[f++]=D.y,u[f++]=D.z),n.st&&(m[C++]=b,m[C++]=0,m[C++]=b,m[C++]=1),(n.normal||n.tangent||n.bitangent)&&(A=Cartesian3.clone(Cartesian3.ZERO,scratchCartesian3Position5),M=Cartesian3.subtract(D,o.geodeticSurfaceNormal(D,scratchCartesian3Position2),scratchCartesian3Position2),P+1<c&&(A=Cartesian3.fromArray(l,3+w,scratchCartesian3Position5)),x&&(w=Cartesian3.subtract(A,D,scratchCartesian3Position4),M=Cartesian3.subtract(M,D,scratchCartesian3Position1),v=Cartesian3.normalize(Cartesian3.cross(M,w,v),v),x=!1),Cartesian3.equalsEpsilon(D,A,CesiumMath.EPSILON10)?x=!0:(b+=E,n.tangent&&(S=Cartesian3.normalize(Cartesian3.subtract(A,D,S),S)),n.bitangent&&(T=Cartesian3.normalize(Cartesian3.cross(v,S,T),T))),n.normal&&(d[g++]=v.x,d[g++]=v.y,d[g++]=v.z,d[g++]=v.x,d[g++]=v.y,d[g++]=v.z),n.tangent&&(h[y++]=S.x,h[y++]=S.y,h[y++]=S.z,h[y++]=S.x,h[y++]=S.y,h[y++]=S.z),n.bitangent&&(p[_++]=T.x,p[_++]=T.y,p[_++]=T.z,p[_++]=T.x,p[_++]=T.y,p[_++]=T.z))}r=new GeometryAttributes;n.position&&(r.position=new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:u})),n.normal&&(r.normal=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:d})),n.tangent&&(r.tangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:h})),n.bitangent&&(r.bitangent=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:3,values:p})),n.st&&(r.st=new GeometryAttribute({componentDatatype:ComponentDatatype$1.FLOAT,componentsPerAttribute:2,values:m}));var I=a/3;a-=6*(i+1);var R=IndexDatatype$1.createTypedArray(I,a),O=0;for(P=0;P<I-2;P+=2){var L=P,F=P+2,N=Cartesian3.fromArray(u,3*L,scratchCartesian3Position1),B=Cartesian3.fromArray(u,3*F,scratchCartesian3Position2);Cartesian3.equalsEpsilon(N,B,CesiumMath.EPSILON10)||(N=P+1,B=P+3,R[O++]=N,R[O++]=L,R[O++]=B,R[O++]=B,R[O++]=L,R[O++]=F)}return new Geometry({attributes:r,indices:R,primitiveType:PrimitiveType$1.TRIANGLES,boundingSphere:new BoundingSphere.fromVertices(u)})}};var scratchCartesian3Position1$1=new Cartesian3,scratchCartesian3Position2$1=new Cartesian3;function WallOutlineGeometry(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.maximumHeights,r=e.minimumHeights,n=defaultValue(e.granularity,CesiumMath.RADIANS_PER_DEGREE),e=defaultValue(e.ellipsoid,Ellipsoid.WGS84);this._positions=t,this._minimumHeights=r,this._maximumHeights=i,this._granularity=n,this._ellipsoid=Ellipsoid.clone(e),this._workerName="createWallOutlineGeometry";t=1+t.length*Cartesian3.packedLength+2;defined(r)&&(t+=r.length),defined(i)&&(t+=i.length),this.packedLength=t+Ellipsoid.packedLength+1}WallOutlineGeometry.pack=function(e,t,i){var r;i=defaultValue(i,0);var n=e._positions,a=n.length;for(t[i++]=a,r=0;r<a;++r,i+=Cartesian3.packedLength)Cartesian3.pack(n[r],t,i);var o=e._minimumHeights,a=defined(o)?o.length:0;if(t[i++]=a,defined(o))for(r=0;r<a;++r)t[i++]=o[r];var s=e._maximumHeights;if(a=defined(s)?s.length:0,t[i++]=a,defined(s))for(r=0;r<a;++r)t[i++]=s[r];return Ellipsoid.pack(e._ellipsoid,t,i),t[i+=Ellipsoid.packedLength]=e._granularity,t};var scratchEllipsoid$d=Ellipsoid.clone(Ellipsoid.UNIT_SPHERE),scratchOptions$n={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:scratchEllipsoid$d,granularity:void 0},implementation$1;function WeightSpline(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).weights,e=e.times;this._times=e,this._weights=t,this._count=t.length/e.length,this._lastTimeIndex=0}function arraySlice(e,t,i){if("function"==typeof e.slice)return e.slice(t,i);for(var r=Array.prototype.slice.call(e,t,i),n=FeatureDetection.typedArrayTypes,a=n.length,o=0;o<a;++o)if(e instanceof n[o]){r=new n[o](r);break}return r}function cancelAnimationFramePolyfill(e){implementation$1(e)}function createGuid(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=16*Math.random()|0;return("x"===e?t:3&t|8).toString(16)})}function createWorldTerrain(e){return e=defaultValue(e,defaultValue.EMPTY_OBJECT),new CesiumTerrainProvider({url:IonResource.fromAssetId(1),requestVertexNormals:defaultValue(e.requestVertexNormals,!1),requestWaterMask:defaultValue(e.requestWaterMask,!1)})}WallOutlineGeometry.unpack=function(e,t,i){t=defaultValue(t,0);for(var r,n,a=e[t++],o=new Array(a),s=0;s<a;++s,t+=Cartesian3.packedLength)o[s]=Cartesian3.unpack(e,t);if(0<(a=e[t++]))for(r=new Array(a),s=0;s<a;++s)r[s]=e[t++];if(0<(a=e[t++]))for(n=new Array(a),s=0;s<a;++s)n[s]=e[t++];var l=Ellipsoid.unpack(e,t,scratchEllipsoid$d),c=e[t+=Ellipsoid.packedLength];return defined(i)?(i._positions=o,i._minimumHeights=r,i._maximumHeights=n,i._ellipsoid=Ellipsoid.clone(l,i._ellipsoid),i._granularity=c,i):(scratchOptions$n.positions=o,scratchOptions$n.minimumHeights=r,scratchOptions$n.maximumHeights=n,scratchOptions$n.granularity=c,new WallOutlineGeometry(scratchOptions$n))},WallOutlineGeometry.fromConstantHeights=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).positions,i=e.minimumHeight,r=e.maximumHeight,n=defined(i),a=defined(r);if(n||a)for(var o=t.length,s=n?new Array(o):void 0,l=a?new Array(o):void 0,c=0;c<o;++c)n&&(s[c]=i),a&&(l[c]=r);return new WallOutlineGeometry({positions:t,maximumHeights:l,minimumHeights:s,ellipsoid:e.ellipsoid})},WallOutlineGeometry.createGeometry=function(e){var t=e._positions,i=e._minimumHeights,r=e._maximumHeights,n=e._granularity,e=e._ellipsoid,i=WallGeometryLibrary.computePositions(e,t,r,i,n,!1);if(defined(i)){var a=i.bottomPositions,o=i.topPositions,s=o.length,n=2*s,l=new Float64Array(n),c=0;for(s/=3,f=0;f<s;++f){var u=3*f,d=Cartesian3.fromArray(o,u,scratchCartesian3Position1$1),u=Cartesian3.fromArray(a,u,scratchCartesian3Position2$1);l[c++]=u.x,l[c++]=u.y,l[c++]=u.z,l[c++]=d.x,l[c++]=d.y,l[c++]=d.z}for(var i=new GeometryAttributes({position:new GeometryAttribute({componentDatatype:ComponentDatatype$1.DOUBLE,componentsPerAttribute:3,values:l})}),h=n/3,n=2*h-4+h,p=IndexDatatype$1.createTypedArray(h,n),m=0,f=0;f<h-2;f+=2){var g=f,_=f+2,y=Cartesian3.fromArray(l,3*g,scratchCartesian3Position1$1),C=Cartesian3.fromArray(l,3*_,scratchCartesian3Position2$1);Cartesian3.equalsEpsilon(y,C,CesiumMath.EPSILON10)||(y=f+1,C=f+3,p[m++]=y,p[m++]=g,p[m++]=y,p[m++]=C,p[m++]=g,p[m++]=_)}return p[m++]=h-2,p[m++]=h-1,new Geometry({attributes:i,indices:p,primitiveType:PrimitiveType$1.LINES,boundingSphere:new BoundingSphere.fromVertices(l)})}},Object.defineProperties(WeightSpline.prototype,{times:{get:function(){return this._times}},weights:{get:function(){return this._weights}}}),WeightSpline.prototype.findTimeInterval=Spline.prototype.findTimeInterval,WeightSpline.prototype.wrapTime=Spline.prototype.wrapTime,WeightSpline.prototype.clampTime=Spline.prototype.clampTime,WeightSpline.prototype.evaluate=function(e,t){var i=this.weights,r=this.times,n=this._lastTimeIndex=this.findTimeInterval(e,this._lastTimeIndex),a=(e-r[n])/(r[n+1]-r[n]);defined(t)||(t=new Array(this._count));for(var o=0;o<this._count;o++){var s=n*this._count+o;t[o]=i[s]*(1-a)+i[s+this._count]*a}return t},"undefined"!=typeof cancelAnimationFrame&&(implementation$1=cancelAnimationFrame),function(){if(!defined(implementation$1)&&"undefined"!=typeof window)for(var e=["webkit","moz","ms","o"],t=0,i=e.length;t<i&&!defined(implementation$1);)defined(implementation$1=window[e[t]+"CancelAnimationFrame"])||(implementation$1=window[e[t]+"CancelRequestAnimationFrame"]),++t;defined(implementation$1)||(implementation$1=clearTimeout)}();var compressedMagic=1953029805,compressedMagicSwap=2917034100;function decodeGoogleEarthEnterpriseData(e,t){if(decodeGoogleEarthEnterpriseData.passThroughDataForTesting)return t;var i=e.byteLength;if(0===i||i%4!=0)throw new RuntimeError("The length of key must be greater than 0 and a multiple of 4.");var r=new DataView(t),n=r.getUint32(0,!0);if(n===compressedMagic||n===compressedMagicSwap)return t;for(var a,o=new DataView(e),s=0,l=t.byteLength,c=l-l%8,u=i,d=8;s<c;)for(a=d=(d+8)%24;s<c&&a<u;)r.setUint32(s,r.getUint32(s,!0)^o.getUint32(a,!0),!0),r.setUint32(s+4,r.getUint32(s+4,!0)^o.getUint32(a+4,!0),!0),s+=8,a+=24;if(s<l)for(u<=a&&(a=d=(d+8)%24);s<l;)r.setUint8(s,r.getUint8(s)^o.getUint8(a)),s++,a++}function getFilenameFromUri(e){var t=new URI(e);t.normalize();e=t.path,t=e.lastIndexOf("/");return-1!==t&&(e=e.substr(t+1)),e}function getMagic(e,t){return getStringFromTypedArray(e,t=defaultValue(t,0),Math.min(4,e.length))}decodeGoogleEarthEnterpriseData.passThroughDataForTesting=!1;var transcodeTaskProcessor=new TaskProcessor("transcodeCRNToDXT",Number.POSITIVE_INFINITY);function loadCRN(e){if(defined(e=e instanceof ArrayBuffer||ArrayBuffer.isView(e)?when.resolve(e):Resource.createIfNeeded(e).fetchArrayBuffer()))return e.then(function(e){if(defined(e)){var t=[];return e instanceof ArrayBuffer?t.push(e):(0===e.byteOffset&&e.byteLength===e.buffer.byteLength||(e=e.slice(0,e.length)),t.push(e.buffer)),transcodeTaskProcessor.scheduleTask(e,t)}}).then(function(e){return CompressedTextureBuffer.clone(e)})}function loadImageFromTypedArray(e){var t,i=e.uint8Array,r=e.format,n=e.request,a=defaultValue(e.flipY,!1),o=new Blob([i],{type:r});return Resource.supportsImageBitmapOptions().then(function(e){return e?when(Resource.createImageBitmapFromBlob(o,{flipY:a,premultiplyAlpha:!1})):new Resource({url:t=window.URL.createObjectURL(o),request:n}).fetchImage({flipY:a})}).then(function(e){return defined(t)&&window.URL.revokeObjectURL(t),e}).otherwise(function(e){return defined(t)&&window.URL.revokeObjectURL(t),when.reject(e)})}function loadKTX(e){if(defined(e=e instanceof ArrayBuffer||ArrayBuffer.isView(e)?when.resolve(e):Resource.createIfNeeded(e).fetchArrayBuffer()))return e.then(function(e){if(defined(e))return parseKTX(e)})}var fileIdentifier=[171,75,84,88,32,49,49,187,13,10,26,10],endiannessTest=67305985,faceOrder=["positiveX","negativeX","positiveY","negativeY","positiveZ","negativeZ"],sizeOfUint32$1=4;function parseKTX(e){for(var t,i=new Uint8Array(e),r=!0,n=0;n<fileIdentifier.length;++n)if(fileIdentifier[n]!==i[n]){r=!1;break}if(!r)throw new RuntimeError("Invalid KTX file.");t=defined(e.buffer)?(y=new DataView(e.buffer),e.byteOffset):(y=new DataView(e),0),t+=12;var a=y.getUint32(t,!0);if(t+=sizeOfUint32$1,a!==endiannessTest)throw new RuntimeError("File is the wrong endianness.");var o=y.getUint32(t,!0);t+=sizeOfUint32$1;var s=y.getUint32(t,!0);t+=sizeOfUint32$1;var l=y.getUint32(t,!0);t+=sizeOfUint32$1;var c=y.getUint32(t,!0);t+=sizeOfUint32$1;var u=y.getUint32(t,!0);t+=sizeOfUint32$1;var d=y.getUint32(t,!0);t+=sizeOfUint32$1;var h=y.getUint32(t,!0);t+=sizeOfUint32$1;var p=y.getUint32(t,!0);t+=sizeOfUint32$1;var m=y.getUint32(t,!0);t+=sizeOfUint32$1;var f=y.getUint32(t,!0);t+=sizeOfUint32$1;var g=y.getUint32(t,!0);t+=sizeOfUint32$1;a=y.getUint32(t,!0);t+=sizeOfUint32$1,t+=a;var _,y=y.getUint32(t,!0);if(t+=sizeOfUint32$1,_=defined(e.buffer)?new Uint8Array(e.buffer,t,y):new Uint8Array(e,t,y),c===WebGLConstants$1.RGB8?c=PixelFormat$1.RGB:c===WebGLConstants$1.RGBA8&&(c=PixelFormat$1.RGBA),!PixelFormat$1.validate(c))throw new RuntimeError("glInternalFormat is not a valid format.");if(PixelFormat$1.isCompressedFormat(c)){if(0!==o)throw new RuntimeError("glType must be zero when the texture is compressed.");if(1!==s)throw new RuntimeError("The type size for compressed textures must be 1.");if(0!==l)throw new RuntimeError("glFormat must be zero when the texture is compressed.")}else{if(o!==WebGLConstants$1.UNSIGNED_BYTE)throw new RuntimeError("Only unsigned byte buffers are supported.");if(u!==l)throw new RuntimeError("The base internal format must be the same as the format for uncompressed textures.")}if(0!==p)throw new RuntimeError("3D textures are unsupported.");if(0!==m)throw new RuntimeError("Texture arrays are unsupported.");var C=_.byteOffset,v=new Array(g);for(n=0;n<g;++n){for(var S=v[n]={},T=0;T<f;++T){var x=d>>n,b=h>>n,E=PixelFormat$1.isCompressedFormat(c)?PixelFormat$1.compressedTextureSizeInBytes(c,x,b):PixelFormat$1.textureSizeInBytes(c,o,x,b),P=new Uint8Array(_.buffer,C,E);S[faceOrder[T]]=new CompressedTextureBuffer(c,x,b,P),C+=E}C+=3-(C+3)%4+4}var A=v;if(1===f)for(n=0;n<g;++n)A[n]=A[n][faceOrder[0]];return 1===g&&(A=A[0]),A}var leftScratchArray=[],rightScratchArray=[];function merge(e,t,i,r,n,a){for(var o,s=n-r+1,l=a-n,c=leftScratchArray,u=rightScratchArray,d=0;d<s;++d)c[d]=e[r+d];for(o=0;o<l;++o)u[o]=e[n+o+1];o=d=0;for(var h=r;h<=a;++h){var p=c[d],m=u[o];d<s&&(l<=o||t(p,m,i)<=0)?(e[h]=p,++d):o<l&&(e[h]=m,++o)}}function sort(e,t,i,r,n){var a;n<=r||(sort(e,t,i,r,a=Math.floor(.5*(r+n))),sort(e,t,i,a+1,n),merge(e,t,i,r,a,n))}function mergeSort(e,t,i){var r=e.length,n=Math.ceil(.5*r);leftScratchArray.length=n,rightScratchArray.length=n,sort(e,t,i,0,r-1),leftScratchArray.length=0,rightScratchArray.length=0}var coords=new Cartesian3,implementation$2;function pointInsideTriangle(e,t,i,r){return barycentricCoordinates(e,t,i,r,coords),0<coords.x&&0<coords.y&&0<coords.z}function requestAnimationFramePolyFill(e){return implementation$2(e)}function sampleTerrain(e,t,i){return e.readyPromise.then(function(){return doSampling(e,t,i)})}function doSampling(e,t,i){for(var r=e.tilingScheme,n=[],a={},o=0;o<i.length;++o){var s=r.positionToTileXY(i[o],t),l=s.toString();a.hasOwnProperty(l)||(s={x:s.x,y:s.y,level:t,tilingScheme:r,terrainProvider:e,positions:[]},a[l]=s,n.push(s)),a[l].positions.push(i[o])}var c=[];for(o=0;o<n.length;++o){var u=n[o],u=u.terrainProvider.requestTileGeometry(u.x,u.y,u.level).then(createInterpolateFunction(u)).otherwise(createMarkFailedFunction(u));c.push(u)}return when.all(c,function(){return i})}function createInterpolateFunction(e){var r=e.positions,n=e.tilingScheme.tileXYToRectangle(e.x,e.y,e.level);return function(e){for(var t=0;t<r.length;++t){var i=r[t];i.height=e.interpolateHeight(n,i.longitude,i.latitude)}}}function createMarkFailedFunction(e){var t=e.positions;return function(){for(var e=0;e<t.length;++e)t[e].height=void 0}}"undefined"!=typeof requestAnimationFrame&&(implementation$2=requestAnimationFrame),function(){if(!defined(implementation$2)&&"undefined"!=typeof window)for(var e=["webkit","moz","ms","o"],t=0,i=e.length;t<i&&!defined(implementation$2);)implementation$2=window[e[t]+"RequestAnimationFrame"],++t;var r;defined(implementation$2)||(r=0,implementation$2=function(e){var t=getTimestamp$1(),i=Math.max(1e3/60-(t-r),0);return r=t+i,setTimeout(function(){e(r)},i)})}();var scratchCartesian2$7=new Cartesian2;function sampleTerrainMostDetailed(l,c){return l.readyPromise.then(function(){for(var e=[],r=[],n=l.availability,t=[],i=0;i<c.length;++i){var a=c[i],o=n.computeMaximumLevelAtPosition(a);0===(r[i]=o)&&(l.tilingScheme.positionToTileXY(a,1,scratchCartesian2$7),defined(s=l.loadTileDataAvailability(scratchCartesian2$7.x,scratchCartesian2$7.y,1))&&t.push(s));var s=e[o];defined(s)||(e[o]=s=[]),s.push(a)}return when.all(t).then(function(){return when.all(e.map(function(e,t){if(defined(e))return sampleTerrain(l,t,e)}))}).then(function(){for(var e=[],t=0;t<c.length;++t){var i=c[t];n.computeMaximumLevelAtPosition(i)!==r[t]&&e.push(i)}if(0<e.length)return sampleTerrainMostDetailed(l,e)}).then(function(){return c})})}function subdivideArray(e,t){for(var i=[],r=e.length,n=0;n<r;){var a=Math.ceil((r-n)/t--);i.push(e.slice(n,n+a)),n+=a}return i}function webGLConstantToGlslType(e){switch(e){case WebGLConstants$1.FLOAT:return"float";case WebGLConstants$1.FLOAT_VEC2:return"vec2";case WebGLConstants$1.FLOAT_VEC3:return"vec3";case WebGLConstants$1.FLOAT_VEC4:return"vec4";case WebGLConstants$1.FLOAT_MAT2:return"mat2";case WebGLConstants$1.FLOAT_MAT3:return"mat3";case WebGLConstants$1.FLOAT_MAT4:return"mat4";case WebGLConstants$1.SAMPLER_2D:return"sampler2D";case WebGLConstants$1.BOOL:return"bool"}}function wrapFunction(e,t,i){return function(){i.apply(e,arguments),t.apply(e,arguments)}}function ConstantProperty(e){this._value=void 0,this._hasClone=!1,this._hasEquals=!1,this._definitionChanged=new Event,this.setValue(e)}function createProperty(r,n,a,e,o){return{configurable:e,get:function(){return this[n]},set:function(e){var t=this[n],i=this[a];defined(i)&&(i(),this[a]=void 0),!(void 0!==e)||defined(e)&&defined(e.getValue)||!defined(o)||(e=o(e)),t!==e&&(this[n]=e,this._definitionChanged.raiseEvent(this,r,e,t)),defined(e)&&defined(e.definitionChanged)&&(this[a]=e.definitionChanged.addEventListener(function(){this._definitionChanged.raiseEvent(this,r,e,e)},this))}}}function createConstantProperty(e){return new ConstantProperty(e)}function createPropertyDescriptor(e,t,i){return createProperty(e,"_"+e.toString(),"_"+e.toString()+"Subscription",defaultValue(t,!1),defaultValue(i,createConstantProperty))}function BillboardGraphics(e){this._definitionChanged=new Event,this._show=void 0,this._showSubscription=void 0,this._image=void 0,this._imageSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._pixelOffset=void 0,this._pixelOffsetSubscription=void 0,this._eyeOffset=void 0,this._eyeOffsetSubscription=void 0,this._horizontalOrigin=void 0,this._horizontalOriginSubscription=void 0,this._verticalOrigin=void 0,this._verticalOriginSubscription=void 0,this._heightReference=void 0,this._heightReferenceSubscription=void 0,this._color=void 0,this._colorSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._alignedAxis=void 0,this._alignedAxisSubscription=void 0,this._sizeInMeters=void 0,this._sizeInMetersSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._scaleByDistance=void 0,this._scaleByDistanceSubscription=void 0,this._translucencyByDistance=void 0,this._translucencyByDistanceSubscription=void 0,this._pixelOffsetScaleByDistance=void 0,this._pixelOffsetScaleByDistanceSubscription=void 0,this._imageSubRegion=void 0,this._imageSubRegionSubscription=void 0,this._distanceDisplayCondition=void 0,this._distanceDisplayConditionSubscription=void 0,this._disableDepthTestDistance=void 0,this._disableDepthTestDistanceSubscription=void 0,this.merge(defaultValue(e,defaultValue.EMPTY_OBJECT))}Object.defineProperties(ConstantProperty.prototype,{isConstant:{value:!0},definitionChanged:{get:function(){return this._definitionChanged}}}),ConstantProperty.prototype.getValue=function(e,t){return this._hasClone?this._value.clone(t):this._value},ConstantProperty.prototype.setValue=function(e){var t,i,r=this._value;r!==e&&(t=(i=defined(e))&&"function"==typeof e.clone,(i=i&&"function"==typeof e.equals)&&e.equals(r)||(this._hasClone=t,this._hasEquals=i,this._value=t?e.clone(this._value):e,this._definitionChanged.raiseEvent(this)))},ConstantProperty.prototype.equals=function(e){return this===e||e instanceof ConstantProperty&&(!this._hasEquals&&this._value===e._value||this._hasEquals&&this._value.equals(e._value))},ConstantProperty.prototype.valueOf=function(){return this._value},ConstantProperty.prototype.toString=function(){return String(this._value)},Object.defineProperties(BillboardGraphics.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:createPropertyDescriptor("show"),image:createPropertyDescriptor("image"),scale:createPropertyDescriptor("scale"),pixelOffset:createPropertyDescriptor("pixelOffset"),eyeOffset:createPropertyDescriptor("eyeOffset"),horizontalOrigin:createPropertyDescriptor("horizontalOrigin"),verticalOrigin:createPropertyDescriptor("verticalOrigin"),heightReference:createPropertyDescriptor("heightReference"),color:createPropertyDescriptor("color"),rotation:createPropertyDescriptor("rotation"),alignedAxis:createPropertyDescriptor("alignedAxis"),sizeInMeters:createPropertyDescriptor("sizeInMeters"),width:createPropertyDescriptor("width"),height:createPropertyDescriptor("height"),scaleByDistance:createPropertyDescriptor("scaleByDistance"),translucencyByDistance:createPropertyDescriptor("translucencyByDistance"),pixelOffsetScaleByDistance:createPropertyDescriptor("pixelOffsetScaleByDistance"),imageSubRegion:createPropertyDescriptor("imageSubRegion"),distanceDisplayCondition:createPropertyDescriptor("distanceDisplayCondition"),disableDepthTestDistance:createPropertyDescriptor("disableDepthTestDistance")}),BillboardGraphics.prototype.clone=function(e){return defined(e)?(e.show=this._show,e.image=this._image,e.scale=this._scale,e.pixelOffset=this._pixelOffset,e.eyeOffset=this._eyeOffset,e.horizontalOrigin=this._horizontalOrigin,e.verticalOrigin=this._verticalOrigin,e.heightReference=this._heightReference,e.color=this._color,e.rotation=this._rotation,e.alignedAxis=this._alignedAxis,e.sizeInMeters=this._sizeInMeters,e.width=this._width,e.height=this._height,e.scaleByDistance=this._scaleByDistance,e.translucencyByDistance=this._translucencyByDistance,e.pixelOffsetScaleByDistance=this._pixelOffsetScaleByDistance,e.imageSubRegion=this._imageSubRegion,e.distanceDisplayCondition=this._distanceDisplayCondition,e.disableDepthTestDistance=this._disableDepthTestDistance,e):new BillboardGraphics(this)},BillboardGraphics.prototype.merge=function(e){this.show=defaultValue(this._show,e.show),this.image=defaultValue(this._image,e.image),this.scale=defaultValue(this._scale,e.scale),this.pixelOffset=defaultValue(this._pixelOffset,e.pixelOffset),this.eyeOffset=defaultValue(this._eyeOffset,e.eyeOffset),this.horizontalOrigin=defaultValue(this._horizontalOrigin,e.horizontalOrigin),this.verticalOrigin=defaultValue(this._verticalOrigin,e.verticalOrigin),this.heightReference=defaultValue(this._heightReference,e.heightReference),this.color=defaultValue(this._color,e.color),this.rotation=defaultValue(this._rotation,e.rotation),this.alignedAxis=defaultValue(this._alignedAxis,e.alignedAxis),this.sizeInMeters=defaultValue(this._sizeInMeters,e.sizeInMeters),this.width=defaultValue(this._width,e.width),this.height=defaultValue(this._height,e.height),this.scaleByDistance=defaultValue(this._scaleByDistance,e.scaleByDistance),this.translucencyByDistance=defaultValue(this._translucencyByDistance,e.translucencyByDistance),this.pixelOffsetScaleByDistance=defaultValue(this._pixelOffsetScaleByDistance,e.pixelOffsetScaleByDistance),this.imageSubRegion=defaultValue(this._imageSubRegion,e.imageSubRegion),this.distanceDisplayCondition=defaultValue(this._distanceDisplayCondition,e.distanceDisplayCondition),this.disableDepthTestDistance=defaultValue(this._disableDepthTestDistance,e.disableDepthTestDistance)};var HeightReference={NONE:0,CLAMP_TO_GROUND:1,RELATIVE_TO_GROUND:2},HeightReference$1=Object.freeze(HeightReference),HorizontalOrigin={CENTER:0,LEFT:1,RIGHT:-1},HorizontalOrigin$1=Object.freeze(HorizontalOrigin),VerticalOrigin={CENTER:0,BOTTOM:1,BASELINE:2,TOP:-1},VerticalOrigin$1=Object.freeze(VerticalOrigin),BoundingSphereState={DONE:0,PENDING:1,FAILED:2},BoundingSphereState$1=Object.freeze(BoundingSphereState);function Property(){DeveloperError.throwInstantiationError()}Object.defineProperties(Property.prototype,{isConstant:{get:DeveloperError.throwInstantiationError},definitionChanged:{get:DeveloperError.throwInstantiationError}}),Property.prototype.getValue=DeveloperError.throwInstantiationError,Property.prototype.equals=DeveloperError.throwInstantiationError,Property.equals=function(e,t){return e===t||defined(e)&&e.equals(t)},Property.arrayEquals=function(e,t){if(e===t)return!0;if(!defined(e)||!defined(t)||e.length!==t.length)return!1;for(var i=e.length,r=0;r<i;r++)if(!Property.equals(e[r],t[r]))return!1;return!0},Property.isConstant=function(e){return!defined(e)||e.isConstant},Property.getValueOrUndefined=function(e,t,i){return defined(e)?e.getValue(t,i):void 0},Property.getValueOrDefault=function(e,t,i,r){return defined(e)?defaultValue(e.getValue(t,r),i):i},Property.getValueOrClonedDefault=function(e,t,i,r){var n;return defined(e)&&(n=e.getValue(t,r)),defined(n)||(n=i.clone(n)),n};var defaultColor=Color.WHITE,defaultEyeOffset=Cartesian3.ZERO,defaultHeightReference=HeightReference$1.NONE,defaultPixelOffset=Cartesian2.ZERO,defaultScale$1=1,defaultRotation$1=0,defaultAlignedAxis=Cartesian3.ZERO,defaultHorizontalOrigin=HorizontalOrigin$1.CENTER,defaultVerticalOrigin=VerticalOrigin$1.CENTER,defaultSizeInMeters=!1,positionScratch$4=new Cartesian3,colorScratch$1=new Color,eyeOffsetScratch=new Cartesian3,pixelOffsetScratch=new Cartesian2,scaleByDistanceScratch=new NearFarScalar,translucencyByDistanceScratch=new NearFarScalar,pixelOffsetScaleByDistanceScratch=new NearFarScalar,boundingRectangleScratch=new BoundingRectangle,distanceDisplayConditionScratch=new DistanceDisplayCondition;function EntityData(e){this.entity=e,this.billboard=void 0,this.textureValue=void 0}function BillboardVisualizer(e,t){t.collectionChanged.addEventListener(BillboardVisualizer.prototype._onCollectionChanged,this),this._cluster=e,this._entityCollection=t,this._items=new AssociativeArray,this._onCollectionChanged(t,t.values,[],[])}function returnPrimitive(e,t,i){defined(e)&&(e.billboard=void 0,i.removeBillboard(t))}BillboardVisualizer.prototype.update=function(e){for(var t=this._items.values,i=this._cluster,r=0,n=t.length;r<n;r++){var a,o,s=t[r],l=s.entity,c=l._billboard,u=s.billboard,d=l.isShowing&&l.isAvailable(e)&&Property.getValueOrDefault(c._show,e,!0);d&&(o=Property.getValueOrUndefined(l._position,e,positionScratch$4),a=Property.getValueOrUndefined(c._image,e),d=defined(o)&&defined(a)),d?(Property.isConstant(l._position)||(i._clusterDirty=!0),defined(u)||((u=i.getBillboard(l)).id=l,u.image=void 0,s.billboard=u),u.show=d,defined(u.image)&&s.textureValue===a||(u.image=a,s.textureValue=a),u.position=o,u.color=Property.getValueOrDefault(c._color,e,defaultColor,colorScratch$1),u.eyeOffset=Property.getValueOrDefault(c._eyeOffset,e,defaultEyeOffset,eyeOffsetScratch),u.heightReference=Property.getValueOrDefault(c._heightReference,e,defaultHeightReference),u.pixelOffset=Property.getValueOrDefault(c._pixelOffset,e,defaultPixelOffset,pixelOffsetScratch),u.scale=Property.getValueOrDefault(c._scale,e,defaultScale$1),u.rotation=Property.getValueOrDefault(c._rotation,e,defaultRotation$1),u.alignedAxis=Property.getValueOrDefault(c._alignedAxis,e,defaultAlignedAxis),u.horizontalOrigin=Property.getValueOrDefault(c._horizontalOrigin,e,defaultHorizontalOrigin),u.verticalOrigin=Property.getValueOrDefault(c._verticalOrigin,e,defaultVerticalOrigin),u.width=Property.getValueOrUndefined(c._width,e),u.height=Property.getValueOrUndefined(c._height,e),u.scaleByDistance=Property.getValueOrUndefined(c._scaleByDistance,e,scaleByDistanceScratch),u.translucencyByDistance=Property.getValueOrUndefined(c._translucencyByDistance,e,translucencyByDistanceScratch),u.pixelOffsetScaleByDistance=Property.getValueOrUndefined(c._pixelOffsetScaleByDistance,e,pixelOffsetScaleByDistanceScratch),u.sizeInMeters=Property.getValueOrDefault(c._sizeInMeters,e,defaultSizeInMeters),u.distanceDisplayCondition=Property.getValueOrUndefined(c._distanceDisplayCondition,e,distanceDisplayConditionScratch),u.disableDepthTestDistance=Property.getValueOrUndefined(c._disableDepthTestDistance,e),defined(c=Property.getValueOrUndefined(c._imageSubRegion,e,boundingRectangleScratch))&&u.setImageSubRegion(u._imageId,c)):returnPrimitive(s,l,i)}return!0},BillboardVisualizer.prototype.getBoundingSphere=function(e,t){e=this._items.get(e.id);if(!defined(e)||!defined(e.billboard))return BoundingSphereState$1.FAILED;e=e.billboard;if(e.heightReference===HeightReference$1.NONE)t.center=Cartesian3.clone(e.position,t.center);else{if(!defined(e._clampedPosition))return BoundingSphereState$1.PENDING;t.center=Cartesian3.clone(e._clampedPosition,t.center)}return t.radius=0,BoundingSphereState$1.DONE},BillboardVisualizer.prototype.isDestroyed=function(){return!1},BillboardVisualizer.prototype.destroy=function(){this._entityCollection.collectionChanged.removeEventListener(BillboardVisualizer.prototype._onCollectionChanged,this);for(var e=this._entityCollection.values,t=0;t<e.length;t++)this._cluster.removeBillboard(e[t]);return destroyObject(this)},BillboardVisualizer.prototype._onCollectionChanged=function(e,t,i,r){for(var n,a=this._items,o=this._cluster,s=t.length-1;-1<s;s--)defined((n=t[s])._billboard)&&defined(n._position)&&a.set(n.id,new EntityData(n));for(s=r.length-1;-1<s;s--)defined((n=r[s])._billboard)&&defined(n._position)?a.contains(n.id)||a.set(n.id,new EntityData(n)):(returnPrimitive(a.get(n.id),n,o),a.remove(n.id));for(s=i.length-1;-1<s;s--)n=i[s],returnPrimitive(a.get(n.id),n,o),a.remove(n.id)};var AllMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_bitangentEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nmat3 tangentToEyeMatrix = czm_tangentToEyeSpaceMatrix(v_normalEC, v_tangentEC, v_bitangentEC);\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.tangentToEyeMatrix = tangentToEyeMatrix;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n#endif\n}\n",AllMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec3 tangent;\nattribute vec3 bitangent;\nattribute vec2 st;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_bitangentEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_tangentEC = czm_normal * tangent;\nv_bitangentEC = czm_normal * bitangent;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",BasicMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n#endif\n}\n",BasicMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",TexturedMaterialAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n#endif\n}\n",TexturedMaterialAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec2 st;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",BlendEquation={ADD:WebGLConstants$1.FUNC_ADD,SUBTRACT:WebGLConstants$1.FUNC_SUBTRACT,REVERSE_SUBTRACT:WebGLConstants$1.FUNC_REVERSE_SUBTRACT,MIN:WebGLConstants$1.MIN,MAX:WebGLConstants$1.MAX},BlendEquation$1=Object.freeze(BlendEquation),BlendFunction={ZERO:WebGLConstants$1.ZERO,ONE:WebGLConstants$1.ONE,SOURCE_COLOR:WebGLConstants$1.SRC_COLOR,ONE_MINUS_SOURCE_COLOR:WebGLConstants$1.ONE_MINUS_SRC_COLOR,DESTINATION_COLOR:WebGLConstants$1.DST_COLOR,ONE_MINUS_DESTINATION_COLOR:WebGLConstants$1.ONE_MINUS_DST_COLOR,SOURCE_ALPHA:WebGLConstants$1.SRC_ALPHA,ONE_MINUS_SOURCE_ALPHA:WebGLConstants$1.ONE_MINUS_SRC_ALPHA,DESTINATION_ALPHA:WebGLConstants$1.DST_ALPHA,ONE_MINUS_DESTINATION_ALPHA:WebGLConstants$1.ONE_MINUS_DST_ALPHA,CONSTANT_COLOR:WebGLConstants$1.CONSTANT_COLOR,ONE_MINUS_CONSTANT_COLOR:WebGLConstants$1.ONE_MINUS_CONSTANT_COLOR,CONSTANT_ALPHA:WebGLConstants$1.CONSTANT_ALPHA,ONE_MINUS_CONSTANT_ALPHA:WebGLConstants$1.ONE_MINUS_CONSTANT_ALPHA,SOURCE_ALPHA_SATURATE:WebGLConstants$1.SRC_ALPHA_SATURATE},BlendFunction$1=Object.freeze(BlendFunction),BlendingState={DISABLED:Object.freeze({enabled:!1}),ALPHA_BLEND:Object.freeze({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.SOURCE_ALPHA,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA}),PRE_MULTIPLIED_ALPHA_BLEND:Object.freeze({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.ONE,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:BlendFunction$1.ONE_MINUS_SOURCE_ALPHA}),ADDITIVE_BLEND:Object.freeze({enabled:!0,equationRgb:BlendEquation$1.ADD,equationAlpha:BlendEquation$1.ADD,functionSourceRgb:BlendFunction$1.SOURCE_ALPHA,functionSourceAlpha:BlendFunction$1.ONE,functionDestinationRgb:BlendFunction$1.ONE,functionDestinationAlpha:BlendFunction$1.ONE})},BlendingState$1=Object.freeze(BlendingState),CullFace={FRONT:WebGLConstants$1.FRONT,BACK:WebGLConstants$1.BACK,FRONT_AND_BACK:WebGLConstants$1.FRONT_AND_BACK},CullFace$1=Object.freeze(CullFace);function Appearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this.material=e.material,this.translucent=defaultValue(e.translucent,!0),this._vertexShaderSource=e.vertexShaderSource,this._fragmentShaderSource=e.fragmentShaderSource,this._renderState=e.renderState,this._closed=defaultValue(e.closed,!1)}Object.defineProperties(Appearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}}}),Appearance.prototype.getFragmentShaderSource=function(){var e=[];return this.flat&&e.push("#define FLAT"),this.faceForward&&e.push("#define FACE_FORWARD"),defined(this.material)&&e.push(this.material.shaderSource),e.push(this.fragmentShaderSource),e.join("\n")},Appearance.prototype.isTranslucent=function(){return defined(this.material)&&this.material.isTranslucent()||!defined(this.material)&&this.translucent},Appearance.prototype.getRenderState=function(){var e=this.isTranslucent(),t=clone(this.renderState,!1);return e?(t.depthMask=!1,t.blending=BlendingState$1.ALPHA_BLEND):t.depthMask=!0,t},Appearance.getDefaultRenderState=function(e,t,i){var r={depthTest:{enabled:!0}};return e&&(r.depthMask=!1,r.blending=BlendingState$1.ALPHA_BLEND),t&&(r.cull={enabled:!0,face:CullFace$1.BACK}),defined(i)&&(r=combine(i,r,!0)),r};var ContextLimits={_maximumCombinedTextureImageUnits:0,_maximumCubeMapSize:0,_maximumFragmentUniformVectors:0,_maximumTextureImageUnits:0,_maximumRenderbufferSize:0,_maximumTextureSize:0,_maximumVaryingVectors:0,_maximumVertexAttributes:0,_maximumVertexTextureImageUnits:0,_maximumVertexUniformVectors:0,_minimumAliasedLineWidth:0,_maximumAliasedLineWidth:0,_minimumAliasedPointSize:0,_maximumAliasedPointSize:0,_maximumViewportWidth:0,_maximumViewportHeight:0,_maximumTextureFilterAnisotropy:0,_maximumDrawBuffers:0,_maximumColorAttachments:0,_highpFloatSupported:!1,_highpIntSupported:!1};function CubeMapFace(e,t,i,r,n,a,o,s,l,c,u){this._context=e,this._texture=t,this._textureTarget=i,this._targetFace=r,this._pixelDatatype=o,this._internalFormat=n,this._pixelFormat=a,this._size=s,this._preMultiplyAlpha=l,this._flipY=c,this._initialized=u}Object.defineProperties(ContextLimits,{maximumCombinedTextureImageUnits:{get:function(){return ContextLimits._maximumCombinedTextureImageUnits}},maximumCubeMapSize:{get:function(){return ContextLimits._maximumCubeMapSize}},maximumFragmentUniformVectors:{get:function(){return ContextLimits._maximumFragmentUniformVectors}},maximumTextureImageUnits:{get:function(){return ContextLimits._maximumTextureImageUnits}},maximumRenderbufferSize:{get:function(){return ContextLimits._maximumRenderbufferSize}},maximumTextureSize:{get:function(){return ContextLimits._maximumTextureSize}},maximumVaryingVectors:{get:function(){return ContextLimits._maximumVaryingVectors}},maximumVertexAttributes:{get:function(){return ContextLimits._maximumVertexAttributes}},maximumVertexTextureImageUnits:{get:function(){return ContextLimits._maximumVertexTextureImageUnits}},maximumVertexUniformVectors:{get:function(){return ContextLimits._maximumVertexUniformVectors}},minimumAliasedLineWidth:{get:function(){return ContextLimits._minimumAliasedLineWidth}},maximumAliasedLineWidth:{get:function(){return ContextLimits._maximumAliasedLineWidth}},minimumAliasedPointSize:{get:function(){return ContextLimits._minimumAliasedPointSize}},maximumAliasedPointSize:{get:function(){return ContextLimits._maximumAliasedPointSize}},maximumViewportWidth:{get:function(){return ContextLimits._maximumViewportWidth}},maximumViewportHeight:{get:function(){return ContextLimits._maximumViewportHeight}},maximumTextureFilterAnisotropy:{get:function(){return ContextLimits._maximumTextureFilterAnisotropy}},maximumDrawBuffers:{get:function(){return ContextLimits._maximumDrawBuffers}},maximumColorAttachments:{get:function(){return ContextLimits._maximumColorAttachments}},highpFloatSupported:{get:function(){return ContextLimits._highpFloatSupported}},highpIntSupported:{get:function(){return ContextLimits._highpIntSupported}}}),Object.defineProperties(CubeMapFace.prototype,{pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},_target:{get:function(){return this._targetFace}}}),CubeMapFace.prototype.copyFrom=function(e,t,i){t=defaultValue(t,0),i=defaultValue(i,0);var r=this._context._gl,n=this._textureTarget,a=this._targetFace;r.activeTexture(r.TEXTURE0),r.bindTexture(n,this._texture);var o=e.width,s=e.height,l=e.arrayBufferView,c=this._size,u=this._pixelFormat,d=this._internalFormat,h=this._pixelDatatype,p=this._preMultiplyAlpha,m=this._flipY,f=4;defined(l)&&(f=PixelFormat$1.alignmentInBytes(u,h,o)),r.pixelStorei(r.UNPACK_ALIGNMENT,f);var g=!1;this._initialized||(0===t&&0===i&&o===c&&s===c?(defined(l)?(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,!1),m&&(l=PixelFormat$1.flipY(l,u,h,c,c)),r.texImage2D(a,0,d,c,c,0,u,PixelDatatype$1.toWebGLConstant(h,this._context),l)):(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,p),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,m),r.texImage2D(a,0,d,u,PixelDatatype$1.toWebGLConstant(h,this._context),e)),g=!0):(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,!1),f=PixelFormat$1.createTypedArray(u,h,c,c),r.texImage2D(a,0,d,c,c,0,u,PixelDatatype$1.toWebGLConstant(h,this._context),f)),this._initialized=!0),g||(defined(l)?(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,!1),m&&(l=PixelFormat$1.flipY(l,u,h,o,s)),r.texSubImage2D(a,0,t,i,o,s,u,PixelDatatype$1.toWebGLConstant(h,this._context),l)):(r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,p),r.pixelStorei(r.UNPACK_FLIP_Y_WEBGL,m),r.texSubImage2D(a,0,t,i,u,PixelDatatype$1.toWebGLConstant(h,this._context),e))),r.bindTexture(n,null)},CubeMapFace.prototype.copyFromFramebuffer=function(e,t,i,r,n,a){e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,0),n=defaultValue(n,this._size),a=defaultValue(a,this._size);var o=this._context._gl,s=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(s,this._texture),o.copyTexSubImage2D(this._targetFace,0,e,t,i,r,n,a),o.bindTexture(s,null),this._initialized=!0};var MipmapHint={DONT_CARE:WebGLConstants$1.DONT_CARE,FASTEST:WebGLConstants$1.FASTEST,NICEST:WebGLConstants$1.NICEST,validate:function(e){return e===MipmapHint.DONT_CARE||e===MipmapHint.FASTEST||e===MipmapHint.NICEST}},MipmapHint$1=Object.freeze(MipmapHint),TextureMagnificationFilter={NEAREST:WebGLConstants$1.NEAREST,LINEAR:WebGLConstants$1.LINEAR,validate:function(e){return e===TextureMagnificationFilter.NEAREST||e===TextureMagnificationFilter.LINEAR}},TextureMagnificationFilter$1=Object.freeze(TextureMagnificationFilter),TextureMinificationFilter={NEAREST:WebGLConstants$1.NEAREST,LINEAR:WebGLConstants$1.LINEAR,NEAREST_MIPMAP_NEAREST:WebGLConstants$1.NEAREST_MIPMAP_NEAREST,LINEAR_MIPMAP_NEAREST:WebGLConstants$1.LINEAR_MIPMAP_NEAREST,NEAREST_MIPMAP_LINEAR:WebGLConstants$1.NEAREST_MIPMAP_LINEAR,LINEAR_MIPMAP_LINEAR:WebGLConstants$1.LINEAR_MIPMAP_LINEAR,validate:function(e){return e===TextureMinificationFilter.NEAREST||e===TextureMinificationFilter.LINEAR||e===TextureMinificationFilter.NEAREST_MIPMAP_NEAREST||e===TextureMinificationFilter.LINEAR_MIPMAP_NEAREST||e===TextureMinificationFilter.NEAREST_MIPMAP_LINEAR||e===TextureMinificationFilter.LINEAR_MIPMAP_LINEAR}},TextureMinificationFilter$1=Object.freeze(TextureMinificationFilter),TextureWrap={CLAMP_TO_EDGE:WebGLConstants$1.CLAMP_TO_EDGE,REPEAT:WebGLConstants$1.REPEAT,MIRRORED_REPEAT:WebGLConstants$1.MIRRORED_REPEAT,validate:function(e){return e===TextureWrap.CLAMP_TO_EDGE||e===TextureWrap.REPEAT||e===TextureWrap.MIRRORED_REPEAT}},TextureWrap$1=Object.freeze(TextureWrap);function Sampler(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.wrapS,TextureWrap$1.CLAMP_TO_EDGE),i=defaultValue(e.wrapT,TextureWrap$1.CLAMP_TO_EDGE),r=defaultValue(e.minificationFilter,TextureMinificationFilter$1.LINEAR),n=defaultValue(e.magnificationFilter,TextureMagnificationFilter$1.LINEAR),e=defined(e.maximumAnisotropy)?e.maximumAnisotropy:1;this._wrapS=t,this._wrapT=i,this._minificationFilter=r,this._magnificationFilter=n,this._maximumAnisotropy=e}function CubeMap(e){var o,s=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,t=e.source;defined(t)?(p=[t.positiveX,t.negativeX,t.positiveY,t.negativeY,t.positiveZ,t.negativeZ],o=p[0].width,p[0].height):(o=e.width,e.height);var l=o,c=defaultValue(e.pixelDatatype,PixelDatatype$1.UNSIGNED_BYTE),u=defaultValue(e.pixelFormat,PixelFormat$1.RGBA),d=PixelFormat$1.toInternalFormat(u,c,s),i=6*PixelFormat$1.textureSizeInBytes(u,c,l,l),r=e.preMultiplyAlpha||u===PixelFormat$1.RGB||u===PixelFormat$1.LUMINANCE,n=defaultValue(e.flipY,!0),h=s._gl,a=h.TEXTURE_CUBE_MAP,p=h.createTexture();function m(e,t,i,r){var n=t.arrayBufferView;defined(n)||(n=t.bufferView);var a=4;defined(n)&&(a=PixelFormat$1.alignmentInBytes(u,c,o)),h.pixelStorei(h.UNPACK_ALIGNMENT,a),defined(n)?(h.pixelStorei(h.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),h.pixelStorei(h.UNPACK_FLIP_Y_WEBGL,!1),r&&(n=PixelFormat$1.flipY(n,u,c,l,l)),h.texImage2D(e,0,d,l,l,0,u,PixelDatatype$1.toWebGLConstant(c,s),n)):(h.pixelStorei(h.UNPACK_PREMULTIPLY_ALPHA_WEBGL,i),h.pixelStorei(h.UNPACK_FLIP_Y_WEBGL,r),h.texImage2D(e,0,d,u,PixelDatatype$1.toWebGLConstant(c,s),t))}h.activeTexture(h.TEXTURE0),h.bindTexture(a,p),defined(t)?(m(h.TEXTURE_CUBE_MAP_POSITIVE_X,t.positiveX,r,n),m(h.TEXTURE_CUBE_MAP_NEGATIVE_X,t.negativeX,r,n),m(h.TEXTURE_CUBE_MAP_POSITIVE_Y,t.positiveY,r,n),m(h.TEXTURE_CUBE_MAP_NEGATIVE_Y,t.negativeY,r,n),m(h.TEXTURE_CUBE_MAP_POSITIVE_Z,t.positiveZ,r,n),m(h.TEXTURE_CUBE_MAP_NEGATIVE_Z,t.negativeZ,r,n)):(h.texImage2D(h.TEXTURE_CUBE_MAP_POSITIVE_X,0,d,l,l,0,u,PixelDatatype$1.toWebGLConstant(c,s),null),h.texImage2D(h.TEXTURE_CUBE_MAP_NEGATIVE_X,0,d,l,l,0,u,PixelDatatype$1.toWebGLConstant(c,s),null),h.texImage2D(h.TEXTURE_CUBE_MAP_POSITIVE_Y,0,d,l,l,0,u,PixelDatatype$1.toWebGLConstant(c,s),null),h.texImage2D(h.TEXTURE_CUBE_MAP_NEGATIVE_Y,0,d,l,l,0,u,PixelDatatype$1.toWebGLConstant(c,s),null),h.texImage2D(h.TEXTURE_CUBE_MAP_POSITIVE_Z,0,d,l,l,0,u,PixelDatatype$1.toWebGLConstant(c,s),null),h.texImage2D(h.TEXTURE_CUBE_MAP_NEGATIVE_Z,0,d,l,l,0,u,PixelDatatype$1.toWebGLConstant(c,s),null)),h.bindTexture(a,null),this._context=s,this._textureFilterAnisotropic=s._textureFilterAnisotropic,this._textureTarget=a,this._texture=p,this._pixelFormat=u,this._pixelDatatype=c,this._size=l,this._hasMipmap=!1,this._sizeInBytes=i,this._preMultiplyAlpha=r,this._flipY=n,this._sampler=void 0;t=defined(t);this._positiveX=new CubeMapFace(s,p,a,h.TEXTURE_CUBE_MAP_POSITIVE_X,d,u,c,l,r,n,t),this._negativeX=new CubeMapFace(s,p,a,h.TEXTURE_CUBE_MAP_NEGATIVE_X,d,u,c,l,r,n,t),this._positiveY=new CubeMapFace(s,p,a,h.TEXTURE_CUBE_MAP_POSITIVE_Y,d,u,c,l,r,n,t),this._negativeY=new CubeMapFace(s,p,a,h.TEXTURE_CUBE_MAP_NEGATIVE_Y,d,u,c,l,r,n,t),this._positiveZ=new CubeMapFace(s,p,a,h.TEXTURE_CUBE_MAP_POSITIVE_Z,d,u,c,l,r,n,t),this._negativeZ=new CubeMapFace(s,p,a,h.TEXTURE_CUBE_MAP_NEGATIVE_Z,d,u,c,l,r,n,t),this.sampler=defined(e.sampler)?e.sampler:new Sampler}function Texture(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,i=e.width,r=e.height,n=e.source;defined(n)&&(defined(i)||(i=defaultValue(n.videoWidth,n.width)),defined(r)||(r=defaultValue(n.videoHeight,n.height)));var a=defaultValue(e.pixelFormat,PixelFormat$1.RGBA),o=defaultValue(e.pixelDatatype,PixelDatatype$1.UNSIGNED_BYTE),s=PixelFormat$1.toInternalFormat(a,o,t),l=PixelFormat$1.isCompressedFormat(s),c=e.preMultiplyAlpha||a===PixelFormat$1.RGB||a===PixelFormat$1.LUMINANCE,u=defaultValue(e.flipY,!0),d=!0,h=t._gl,p=h.TEXTURE_2D,m=h.createTexture();h.activeTexture(h.TEXTURE0),h.bindTexture(p,m);var f=4;if(defined(n)&&defined(n.arrayBufferView)&&!l&&(f=PixelFormat$1.alignmentInBytes(a,o,i)),h.pixelStorei(h.UNPACK_ALIGNMENT,f),defined(n))if(defined(n.arrayBufferView)){h.pixelStorei(h.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),h.pixelStorei(h.UNPACK_FLIP_Y_WEBGL,!1);f=n.arrayBufferView;if(l)h.compressedTexImage2D(p,0,s,i,r,0,f);else if(u&&(f=PixelFormat$1.flipY(f,a,o,i,r)),h.texImage2D(p,0,s,i,r,0,a,PixelDatatype$1.toWebGLConstant(o,t),f),defined(n.mipLevels))for(var g=i,_=r,y=0;y<n.mipLevels.length;++y)(g=0|Math.floor(g/2))<1&&(g=1),(_=0|Math.floor(_/2))<1&&(_=1),h.texImage2D(p,y+1,s,g,_,0,a,PixelDatatype$1.toWebGLConstant(o,t),n.mipLevels[y])}else defined(n.framebuffer)?(h.pixelStorei(h.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),h.pixelStorei(h.UNPACK_FLIP_Y_WEBGL,!1),n.framebuffer!==t.defaultFramebuffer&&n.framebuffer._bind(),h.copyTexImage2D(p,0,s,n.xOffset,n.yOffset,i,r,0),n.framebuffer!==t.defaultFramebuffer&&n.framebuffer._unBind()):(h.pixelStorei(h.UNPACK_PREMULTIPLY_ALPHA_WEBGL,c),h.pixelStorei(h.UNPACK_FLIP_Y_WEBGL,u),h.texImage2D(p,0,s,a,PixelDatatype$1.toWebGLConstant(o,t),n));else h.texImage2D(p,0,s,i,r,0,a,PixelDatatype$1.toWebGLConstant(o,t),null),d=!1;h.bindTexture(p,null),l=l?PixelFormat$1.compressedTextureSizeInBytes(a,i,r):PixelFormat$1.textureSizeInBytes(a,o,i,r),this._id=createGuid(),this._context=t,this._textureFilterAnisotropic=t._textureFilterAnisotropic,this._textureTarget=p,this._texture=m,this._internalFormat=s,this._pixelFormat=a,this._pixelDatatype=o,this._width=i,this._height=r,this._dimensions=new Cartesian2(i,r),this._hasMipmap=!1,this._sizeInBytes=l,this._preMultiplyAlpha=c,this._flipY=u,this._initialized=d,this._sampler=void 0,this.sampler=defined(e.sampler)?e.sampler:new Sampler}Object.defineProperties(Sampler.prototype,{wrapS:{get:function(){return this._wrapS}},wrapT:{get:function(){return this._wrapT}},minificationFilter:{get:function(){return this._minificationFilter}},magnificationFilter:{get:function(){return this._magnificationFilter}},maximumAnisotropy:{get:function(){return this._maximumAnisotropy}}}),Sampler.equals=function(e,t){return e===t||defined(e)&&defined(t)&&e._wrapS===t._wrapS&&e._wrapT===t._wrapT&&e._minificationFilter===t._minificationFilter&&e._magnificationFilter===t._magnificationFilter&&e._maximumAnisotropy===t._maximumAnisotropy},Sampler.NEAREST=Object.freeze(new Sampler({wrapS:TextureWrap$1.CLAMP_TO_EDGE,wrapT:TextureWrap$1.CLAMP_TO_EDGE,minificationFilter:TextureMinificationFilter$1.NEAREST,magnificationFilter:TextureMagnificationFilter$1.NEAREST})),Object.defineProperties(CubeMap.prototype,{positiveX:{get:function(){return this._positiveX}},negativeX:{get:function(){return this._negativeX}},positiveY:{get:function(){return this._positiveY}},negativeY:{get:function(){return this._negativeY}},positiveZ:{get:function(){return this._positiveZ}},negativeZ:{get:function(){return this._negativeZ}},sampler:{get:function(){return this._sampler},set:function(e){var t=e.minificationFilter,i=e.magnificationFilter,r=t===TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST||t===TextureMinificationFilter$1.NEAREST_MIPMAP_LINEAR||t===TextureMinificationFilter$1.LINEAR_MIPMAP_NEAREST||t===TextureMinificationFilter$1.LINEAR_MIPMAP_LINEAR,n=this._context,a=this._pixelDatatype;(a===PixelDatatype$1.FLOAT&&!n.textureFloatLinear||a===PixelDatatype$1.HALF_FLOAT&&!n.textureHalfFloatLinear)&&(t=r?TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST:TextureMinificationFilter$1.NEAREST,i=TextureMagnificationFilter$1.NEAREST);r=n._gl,n=this._textureTarget;r.activeTexture(r.TEXTURE0),r.bindTexture(n,this._texture),r.texParameteri(n,r.TEXTURE_MIN_FILTER,t),r.texParameteri(n,r.TEXTURE_MAG_FILTER,i),r.texParameteri(n,r.TEXTURE_WRAP_S,e.wrapS),r.texParameteri(n,r.TEXTURE_WRAP_T,e.wrapT),defined(this._textureFilterAnisotropic)&&r.texParameteri(n,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),r.bindTexture(n,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},width:{get:function(){return this._size}},height:{get:function(){return this._size}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(4*this._sizeInBytes/3):this._sizeInBytes}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},_target:{get:function(){return this._textureTarget}}}),CubeMap.prototype.generateMipmap=function(e){e=defaultValue(e,MipmapHint$1.DONT_CARE),this._hasMipmap=!0;var t=this._context._gl,i=this._textureTarget;t.hint(t.GENERATE_MIPMAP_HINT,e),t.activeTexture(t.TEXTURE0),t.bindTexture(i,this._texture),t.generateMipmap(i),t.bindTexture(i,null)},CubeMap.prototype.isDestroyed=function(){return!1},CubeMap.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),this._positiveX=destroyObject(this._positiveX),this._negativeX=destroyObject(this._negativeX),this._positiveY=destroyObject(this._positiveY),this._negativeY=destroyObject(this._negativeY),this._positiveZ=destroyObject(this._positiveZ),this._negativeZ=destroyObject(this._negativeZ),destroyObject(this)},Texture.create=function(e){return new Texture(e)},Texture.fromFramebuffer=function(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context,i=t._gl,r=defaultValue(e.pixelFormat,PixelFormat$1.RGB),n=defaultValue(e.framebufferXOffset,0),a=defaultValue(e.framebufferYOffset,0),o=defaultValue(e.width,i.drawingBufferWidth),i=defaultValue(e.height,i.drawingBufferHeight),e=e.framebuffer;return new Texture({context:t,width:o,height:i,pixelFormat:r,source:{framebuffer:defined(e)?e:t.defaultFramebuffer,xOffset:n,yOffset:a,width:o,height:i}})},Object.defineProperties(Texture.prototype,{id:{get:function(){return this._id}},sampler:{get:function(){return this._sampler},set:function(e){var t=e.minificationFilter,i=e.magnificationFilter,r=this._context,n=this._pixelFormat,a=this._pixelDatatype,o=t===TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST||t===TextureMinificationFilter$1.NEAREST_MIPMAP_LINEAR||t===TextureMinificationFilter$1.LINEAR_MIPMAP_NEAREST||t===TextureMinificationFilter$1.LINEAR_MIPMAP_LINEAR;(a===PixelDatatype$1.FLOAT&&!r.textureFloatLinear||a===PixelDatatype$1.HALF_FLOAT&&!r.textureHalfFloatLinear)&&(t=o?TextureMinificationFilter$1.NEAREST_MIPMAP_NEAREST:TextureMinificationFilter$1.NEAREST,i=TextureMagnificationFilter$1.NEAREST),r.webgl2&&PixelFormat$1.isDepthFormat(n)&&(t=TextureMinificationFilter$1.NEAREST,i=TextureMagnificationFilter$1.NEAREST);n=r._gl,r=this._textureTarget;n.activeTexture(n.TEXTURE0),n.bindTexture(r,this._texture),n.texParameteri(r,n.TEXTURE_MIN_FILTER,t),n.texParameteri(r,n.TEXTURE_MAG_FILTER,i),n.texParameteri(r,n.TEXTURE_WRAP_S,e.wrapS),n.texParameteri(r,n.TEXTURE_WRAP_T,e.wrapT),defined(this._textureFilterAnisotropic)&&n.texParameteri(r,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),n.bindTexture(r,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},dimensions:{get:function(){return this._dimensions}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(4*this._sizeInBytes/3):this._sizeInBytes}},_target:{get:function(){return this._textureTarget}}}),Texture.prototype.copyFrom=function(e,t,i){t=defaultValue(t,0),i=defaultValue(i,0);var r=this._context,n=r._gl,a=this._textureTarget;n.activeTexture(n.TEXTURE0),n.bindTexture(a,this._texture);var o=e.width,s=e.height,l=e.arrayBufferView,c=this._width,u=this._height,d=this._internalFormat,h=this._pixelFormat,p=this._pixelDatatype,m=this._preMultiplyAlpha,f=this._flipY,g=4;defined(l)&&(g=PixelFormat$1.alignmentInBytes(h,p,o)),n.pixelStorei(n.UNPACK_ALIGNMENT,g);var _=!1;this._initialized||(0===t&&0===i&&o===c&&s===u?(defined(l)?(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,!1),f&&(l=PixelFormat$1.flipY(l,h,p,c,u)),n.texImage2D(a,0,d,c,u,0,h,PixelDatatype$1.toWebGLConstant(p,r),l)):(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,m),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,f),n.texImage2D(a,0,d,h,PixelDatatype$1.toWebGLConstant(p,r),e)),_=!0):(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,!1),g=PixelFormat$1.createTypedArray(h,p,c,u),n.texImage2D(a,0,d,c,u,0,h,PixelDatatype$1.toWebGLConstant(p,r),g)),this._initialized=!0),_||(defined(l)?(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,!1),f&&(l=PixelFormat$1.flipY(l,h,p,o,s)),n.texSubImage2D(a,0,t,i,o,s,h,PixelDatatype$1.toWebGLConstant(p,r),l)):(n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,m),n.pixelStorei(n.UNPACK_FLIP_Y_WEBGL,f),n.texSubImage2D(a,0,t,i,h,PixelDatatype$1.toWebGLConstant(p,r),e))),n.bindTexture(a,null)},Texture.prototype.copyFromFramebuffer=function(e,t,i,r,n,a){e=defaultValue(e,0),t=defaultValue(t,0),i=defaultValue(i,0),r=defaultValue(r,0),n=defaultValue(n,this._width),a=defaultValue(a,this._height);var o=this._context._gl,s=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(s,this._texture),o.copyTexSubImage2D(s,0,e,t,i,r,n,a),o.bindTexture(s,null),this._initialized=!0},Texture.prototype.generateMipmap=function(e){e=defaultValue(e,MipmapHint$1.DONT_CARE),this._hasMipmap=!0;var t=this._context._gl,i=this._textureTarget;t.hint(t.GENERATE_MIPMAP_HINT,e),t.activeTexture(t.TEXTURE0),t.bindTexture(i,this._texture),t.generateMipmap(i),t.bindTexture(i,null)},Texture.prototype.isDestroyed=function(){return!1},Texture.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),destroyObject(this)};var AspectRampMaterial="uniform sampler2D image;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 rampColor = texture2D(image, vec2(materialInput.aspect / (2.0 * czm_pi), 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",BumpMapMaterial="uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nvec2 centerPixel = fract(repeat * st);\nfloat centerBump = texture2D(image, centerPixel).channel;\nfloat imageWidth = float(imageDimensions.x);\nvec2 rightPixel = fract(repeat * (st + vec2(1.0 / imageWidth, 0.0)));\nfloat rightBump = texture2D(image, rightPixel).channel;\nfloat imageHeight = float(imageDimensions.y);\nvec2 leftPixel = fract(repeat * (st + vec2(0.0, 1.0 / imageHeight)));\nfloat topBump = texture2D(image, leftPixel).channel;\nvec3 normalTangentSpace = normalize(vec3(centerBump - rightBump, centerBump - topBump, clamp(1.0 - strength, 0.1, 1.0)));\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nmaterial.diffuse = vec3(0.01);\nreturn material;\n}\n",CheckerboardMaterial="uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat b = mod(floor(repeat.s * st.s) + floor(repeat.t * st.t), 2.0);\nfloat scaledWidth = fract(repeat.s * st.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(repeat.t * st.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value = min(scaledWidth, scaledHeight);\nvec4 currentColor = mix(lightColor, darkColor, b);\nvec4 color = czm_antialias(lightColor, darkColor, currentColor, value, 0.03);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",DotMaterial="uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat b = smoothstep(0.3, 0.32, length(fract(repeat * materialInput.st) - 0.5));\nvec4 color = mix(lightColor, darkColor, b);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",ElevationBandMaterial="uniform sampler2D heights;\nuniform sampler2D colors;\nfloat getHeight(int idx, float invTexSize)\n{\nvec2 uv = vec2((float(idx) + 0.5) * invTexSize, 0.5);\n#ifdef OES_texture_float\nreturn texture2D(heights, uv).x;\n#else\nreturn czm_unpackFloat(texture2D(heights, uv));\n#endif\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat height = materialInput.height;\nfloat invTexSize = 1.0 / float(heightsDimensions.x);\nfloat minHeight = getHeight(0, invTexSize);\nfloat maxHeight = getHeight(heightsDimensions.x - 1, invTexSize);\nif (height < minHeight || height > maxHeight) {\nmaterial.diffuse = vec3(0.0);\nmaterial.alpha = 0.0;\nreturn material;\n}\nint idxBelow = 0;\nint idxAbove = heightsDimensions.x;\nfloat heightBelow = minHeight;\nfloat heightAbove = maxHeight;\nconst int maxIterations = 16;\nfor (int i = 0; i < maxIterations; i++) {\nif (idxBelow >= idxAbove - 1) {\nbreak;\n}\nint idxMid = (idxBelow + idxAbove) / 2;\nfloat heightTex = getHeight(idxMid, invTexSize);\nif (height > heightTex) {\nidxBelow = idxMid;\nheightBelow = heightTex;\n} else {\nidxAbove = idxMid;\nheightAbove = heightTex;\n}\n}\nfloat lerper = heightBelow == heightAbove ? 1.0 : (height - heightBelow) / (heightAbove - heightBelow);\nvec2 colorUv = vec2(invTexSize * (float(idxBelow) + 0.5 + lerper), 0.5);\nvec4 color = texture2D(colors, colorUv);\nif (color.a > 0.0)\n{\ncolor.rgb /= color.a;\n}\ncolor.rgb = czm_gammaCorrect(color.rgb);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",ElevationContourMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nuniform float spacing;\nuniform float width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat distanceToContour = mod(materialInput.height, spacing);\n#ifdef GL_OES_standard_derivatives\nfloat dxc = abs(dFdx(materialInput.height));\nfloat dyc = abs(dFdy(materialInput.height));\nfloat dF = max(dxc, dyc) * czm_pixelRatio * width;\nfloat alpha = (distanceToContour < dF) ? 1.0 : 0.0;\n#else\nfloat alpha = (distanceToContour < (czm_pixelRatio * width)) ? 1.0 : 0.0;\n#endif\nvec4 outColor = czm_gammaCorrect(vec4(color.rgb, alpha * color.a));\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",ElevationRampMaterial="uniform sampler2D image;\nuniform float minimumHeight;\nuniform float maximumHeight;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat scaledHeight = clamp((materialInput.height - minimumHeight) / (maximumHeight - minimumHeight), 0.0, 1.0);\nvec4 rampColor = texture2D(image, vec2(scaledHeight, 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",FadeMaterial="uniform vec4 fadeInColor;\nuniform vec4 fadeOutColor;\nuniform float maximumDistance;\nuniform bool repeat;\nuniform vec2 fadeDirection;\nuniform vec2 time;\nfloat getTime(float t, float coord)\n{\nfloat scalar = 1.0 / maximumDistance;\nfloat q  = distance(t, coord) * scalar;\nif (repeat)\n{\nfloat r = distance(t, coord + 1.0) * scalar;\nfloat s = distance(t, coord - 1.0) * scalar;\nq = min(min(r, s), q);\n}\nreturn clamp(q, 0.0, 1.0);\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat s = getTime(time.x, st.s) * fadeDirection.s;\nfloat t = getTime(time.y, st.t) * fadeDirection.t;\nfloat u = length(vec2(s, t));\nvec4 color = mix(fadeInColor, fadeOutColor, u);\ncolor = czm_gammaCorrect(color);\nmaterial.emission = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",GridMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nuniform float cellAlpha;\nuniform vec2 lineCount;\nuniform vec2 lineThickness;\nuniform vec2 lineOffset;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat scaledWidth = fract(lineCount.s * st.s - lineOffset.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(lineCount.t * st.t - lineOffset.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value;\n#ifdef GL_OES_standard_derivatives\nconst float fuzz = 1.2;\nvec2 thickness = (lineThickness * czm_pixelRatio) - 1.0;\nvec2 dx = abs(dFdx(st));\nvec2 dy = abs(dFdy(st));\nvec2 dF = vec2(max(dx.s, dy.s), max(dx.t, dy.t)) * lineCount;\nvalue = min(\nsmoothstep(dF.s * thickness.s, dF.s * (fuzz + thickness.s), scaledWidth),\nsmoothstep(dF.t * thickness.t, dF.t * (fuzz + thickness.t), scaledHeight));\n#else\nconst float fuzz = 0.05;\nvec2 range = 0.5 - (lineThickness * 0.05);\nvalue = min(\n1.0 - smoothstep(range.s, range.s + fuzz, scaledWidth),\n1.0 - smoothstep(range.t, range.t + fuzz, scaledHeight));\n#endif\nfloat dRim = 1.0 - abs(dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC)));\nfloat sRim = smoothstep(0.8, 1.0, dRim);\nvalue *= (1.0 - sRim);\nvec4 halfColor;\nhalfColor.rgb = color.rgb * 0.5;\nhalfColor.a = color.a * (1.0 - ((1.0 - cellAlpha) * value));\nhalfColor = czm_gammaCorrect(halfColor);\nmaterial.diffuse = halfColor.rgb;\nmaterial.emission = halfColor.rgb;\nmaterial.alpha = halfColor.a;\nreturn material;\n}\n",NormalMapMaterial="uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 textureValue = texture2D(image, fract(repeat * materialInput.st));\nvec3 normalTangentSpace = textureValue.channels;\nnormalTangentSpace.xy = normalTangentSpace.xy * 2.0 - 1.0;\nnormalTangentSpace.z = clamp(1.0 - strength, 0.1, 1.0);\nnormalTangentSpace = normalize(normalTangentSpace);\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nreturn material;\n}\n",PolylineArrowMaterial="#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nfloat getPointOnLine(vec2 p0, vec2 p1, float x)\n{\nfloat slope = (p0.y - p1.y) / (p0.x - p1.x);\nreturn slope * (x - p0.x) + p0.y;\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\n#ifdef GL_OES_standard_derivatives\nfloat base = 1.0 - abs(fwidth(st.s)) * 10.0 * czm_pixelRatio;\n#else\nfloat base = 0.975;\n#endif\nvec2 center = vec2(1.0, 0.5);\nfloat ptOnUpperLine = getPointOnLine(vec2(base, 1.0), center, st.s);\nfloat ptOnLowerLine = getPointOnLine(vec2(base, 0.0), center, st.s);\nfloat halfWidth = 0.15;\nfloat s = step(0.5 - halfWidth, st.t);\ns *= 1.0 - step(0.5 + halfWidth, st.t);\ns *= 1.0 - step(base, st.s);\nfloat t = step(base, materialInput.st.s);\nt *= 1.0 - step(ptOnUpperLine, st.t);\nt *= step(ptOnLowerLine, st.t);\nfloat dist;\nif (st.s < base)\n{\nfloat d1 = abs(st.t - (0.5 - halfWidth));\nfloat d2 = abs(st.t - (0.5 + halfWidth));\ndist = min(d1, d2);\n}\nelse\n{\nfloat d1 = czm_infinity;\nif (st.t < 0.5 - halfWidth && st.t > 0.5 + halfWidth)\n{\nd1 = abs(st.s - base);\n}\nfloat d2 = abs(st.t - ptOnUpperLine);\nfloat d3 = abs(st.t - ptOnLowerLine);\ndist = min(min(d1, d2), d3);\n}\nvec4 outsideColor = vec4(0.0);\nvec4 currentColor = mix(outsideColor, color, clamp(s + t, 0.0, 1.0));\nvec4 outColor = czm_antialias(outsideColor, color, currentColor, dist);\noutColor = czm_gammaCorrect(outColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",PolylineDashMaterial="uniform vec4 color;\nuniform vec4 gapColor;\nuniform float dashLength;\nuniform float dashPattern;\nvarying float v_polylineAngle;\nconst float maskLength = 16.0;\nmat2 rotate(float rad) {\nfloat c = cos(rad);\nfloat s = sin(rad);\nreturn mat2(\nc, s,\n-s, c\n);\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 pos = rotate(v_polylineAngle) * gl_FragCoord.xy;\nfloat dashPosition = fract(pos.x / (dashLength * czm_pixelRatio));\nfloat maskIndex = floor(dashPosition * maskLength);\nfloat maskTest = floor(dashPattern / pow(2.0, maskIndex));\nvec4 fragColor = (mod(maskTest, 2.0) < 1.0) ? gapColor : color;\nif (fragColor.a < 0.005) {\ndiscard;\n}\nfragColor = czm_gammaCorrect(fragColor);\nmaterial.emission = fragColor.rgb;\nmaterial.alpha = fragColor.a;\nreturn material;\n}\n",PolylineGlowMaterial="uniform vec4 color;\nuniform float glowPower;\nuniform float taperPower;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat glow = glowPower / abs(st.t - 0.5) - (glowPower / 0.5);\nif (taperPower <= 0.99999) {\nglow *= min(1.0, taperPower / (0.5 - st.s * 0.5) - (taperPower / 0.5));\n}\nvec4 fragColor;\nfragColor.rgb = max(vec3(glow - 1.0 + color.rgb), color.rgb);\nfragColor.a = clamp(0.0, 1.0, glow) * color.a;\nfragColor = czm_gammaCorrect(fragColor);\nmaterial.emission = fragColor.rgb;\nmaterial.alpha = fragColor.a;\nreturn material;\n}\n",PolylineOutlineMaterial="uniform vec4 color;\nuniform vec4 outlineColor;\nuniform float outlineWidth;\nvarying float v_width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat halfInteriorWidth =  0.5 * (v_width - outlineWidth) / v_width;\nfloat b = step(0.5 - halfInteriorWidth, st.t);\nb *= 1.0 - step(0.5 + halfInteriorWidth, st.t);\nfloat d1 = abs(st.t - (0.5 - halfInteriorWidth));\nfloat d2 = abs(st.t - (0.5 + halfInteriorWidth));\nfloat dist = min(d1, d2);\nvec4 currentColor = mix(outlineColor, color, b);\nvec4 outColor = czm_antialias(outlineColor, color, currentColor, dist);\noutColor = czm_gammaCorrect(outColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n",RimLightingMaterial="uniform vec4 color;\nuniform vec4 rimColor;\nuniform float width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat d = 1.0 - dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC));\nfloat s = smoothstep(1.0 - width, 1.0, d);\nvec4 outColor = czm_gammaCorrect(color);\nvec4 outRimColor = czm_gammaCorrect(rimColor);\nmaterial.diffuse = outColor.rgb;\nmaterial.emission = outRimColor.rgb * s;\nmaterial.alpha = mix(outColor.a, outRimColor.a, s);\nreturn material;\n}\n",SlopeRampMaterial="uniform sampler2D image;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 rampColor = texture2D(image, vec2(materialInput.slope / (czm_pi / 2.0), 0.5));\nrampColor = czm_gammaCorrect(rampColor);\nmaterial.diffuse = rampColor.rgb;\nmaterial.alpha = rampColor.a;\nreturn material;\n}\n",StripeMaterial="uniform vec4 evenColor;\nuniform vec4 oddColor;\nuniform float offset;\nuniform float repeat;\nuniform bool horizontal;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat coord = mix(materialInput.st.s, materialInput.st.t, float(horizontal));\nfloat value = fract((coord - offset) * (repeat * 0.5));\nfloat dist = min(value, min(abs(value - 0.5), 1.0 - value));\nvec4 currentColor = mix(evenColor, oddColor, step(0.5, value));\nvec4 color = czm_antialias(evenColor, oddColor, currentColor, dist);\ncolor = czm_gammaCorrect(color);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n",WaterMaterial="uniform sampler2D specularMap;\nuniform sampler2D normalMap;\nuniform vec4 baseWaterColor;\nuniform vec4 blendColor;\nuniform float frequency;\nuniform float animationSpeed;\nuniform float amplitude;\nuniform float specularIntensity;\nuniform float fadeFactor;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat time = czm_frameNumber * animationSpeed;\nfloat fade = max(1.0, (length(materialInput.positionToEyeEC) / 10000000000.0) * frequency * fadeFactor);\nfloat specularMapValue = texture2D(specularMap, materialInput.st).r;\nvec4 noise = czm_getWaterNoise(normalMap, materialInput.st * frequency, time, 0.0);\nvec3 normalTangentSpace = noise.xyz * vec3(1.0, 1.0, (1.0 / amplitude));\nnormalTangentSpace.xy /= fade;\nnormalTangentSpace = mix(vec3(0.0, 0.0, 50.0), normalTangentSpace, specularMapValue);\nnormalTangentSpace = normalize(normalTangentSpace);\nfloat tsPerturbationRatio = clamp(dot(normalTangentSpace, vec3(0.0, 0.0, 1.0)), 0.0, 1.0);\nmaterial.alpha = mix(blendColor.a, baseWaterColor.a, specularMapValue) * specularMapValue;\nmaterial.diffuse = mix(blendColor.rgb, baseWaterColor.rgb, specularMapValue);\nmaterial.diffuse += (0.1 * tsPerturbationRatio);\nmaterial.diffuse = material.diffuse;\nmaterial.normal = normalize(materialInput.tangentToEyeMatrix * normalTangentSpace);\nmaterial.specular = specularIntensity;\nmaterial.shininess = 10.0;\nreturn material;\n}\n";function Material(e){this.type=void 0,this.shaderSource=void 0,this.materials=void 0,this.uniforms=void 0,this._uniforms=void 0,this.translucent=void 0,this._minificationFilter=defaultValue(e.minificationFilter,TextureMinificationFilter$1.LINEAR),this._magnificationFilter=defaultValue(e.magnificationFilter,TextureMagnificationFilter$1.LINEAR),this._strict=void 0,this._template=void 0,this._count=void 0,this._texturePaths={},this._loadedImages=[],this._loadedCubeMaps=[],this._textures={},this._updateFunctions=[],this._defaultTexture=void 0,initializeMaterial(e,this),Object.defineProperties(this,{type:{value:this.type,writable:!1}}),defined(Material._uniformList[this.type])||(Material._uniformList[this.type]=Object.keys(this._uniforms))}function initializeMaterial(e,t){e=defaultValue(e,defaultValue.EMPTY_OBJECT),t._strict=defaultValue(e.strict,!1),t._count=defaultValue(e.count,0),t._template=clone(defaultValue(e.fabric,defaultValue.EMPTY_OBJECT)),t._template.uniforms=clone(defaultValue(t._template.uniforms,defaultValue.EMPTY_OBJECT)),t._template.materials=clone(defaultValue(t._template.materials,defaultValue.EMPTY_OBJECT)),t.type=defined(t._template.type)?t._template.type:createGuid(),t.shaderSource="",t.materials={},t.uniforms={},t._uniforms={},t._translucentFunctions=[];var i,r=Material._materialCache.getMaterial(t.type);defined(r)&&(i=clone(r.fabric,!0),t._template=combine(t._template,i,!0),n=r.translucent),checkForTemplateErrors(t),defined(r)||Material._materialCache.addMaterial(t.type,t),createMethodDefinition(t),createUniforms(t),createSubMaterials(t);var r=0===t._translucentFunctions.length||void 0,n=defaultValue(n,r);defined(n=defaultValue(e.translucent,n))&&("function"==typeof n?t._translucentFunctions.push(function(){return n(t)}):t._translucentFunctions.push(n))}function checkForValidProperties(e,t,i,r){if(defined(e))for(var n in e){var a;e.hasOwnProperty(n)&&(a=-1!==t.indexOf(n),(r&&!a||!r&&a)&&i(n,t))}}function invalidNameError(e,t){}function duplicateNameError(e,t){}Material._uniformList={},Material.fromType=function(e,t){var i=new Material({fabric:{type:e}});if(defined(t))for(var r in t)t.hasOwnProperty(r)&&(i.uniforms[r]=t[r]);return i},Material.prototype.isTranslucent=function(){if(defined(this.translucent))return"function"==typeof this.translucent?this.translucent():this.translucent;for(var e=!0,t=this._translucentFunctions,i=t.length,r=0;r<i;++r){var n=t[r];if(!(e="function"==typeof n?e&&n():e&&n))break}return e},Material.prototype.update=function(e){for(var t=this._loadedImages,i=t.length,r=0;r<i;++r){var n=t[r],a=n.id,o=n.image,n=new Sampler({minificationFilter:this._minificationFilter,magnificationFilter:this._magnificationFilter}),o=defined(o.internalFormat)?new Texture({context:e,pixelFormat:o.internalFormat,width:o.width,height:o.height,source:{arrayBufferView:o.bufferView},sampler:n}):new Texture({context:e,source:o,sampler:n});this._textures[a]=o;n=a+"Dimensions";this.uniforms.hasOwnProperty(n)&&((n=this.uniforms[n]).x=o._width,n.y=o._height)}t.length=0;var s=this._loadedCubeMaps,i=s.length;for(r=0;r<i;++r){var l=s[r];a=l.id;l=l.images,l=new CubeMap({context:e,source:{positiveX:l[0],negativeX:l[1],positiveY:l[2],negativeY:l[3],positiveZ:l[4],negativeZ:l[5]},sampler:new Sampler({minificationFilter:this._minificationFilter,magnificationFilter:this._magnificationFilter})});this._textures[a]=l}s.length=0;var c=this._updateFunctions;for(i=c.length,r=0;r<i;++r)c[r](this,e);var u,d=this.materials;for(u in d)d.hasOwnProperty(u)&&d[u].update(e)},Material.prototype.isDestroyed=function(){return!1},Material.prototype.destroy=function(){var e,t,i=this._textures;for(e in i)!i.hasOwnProperty(e)||(t=i[e])!==this._defaultTexture&&t.destroy();var r,n=this.materials;for(r in n)n.hasOwnProperty(r)&&n[r].destroy();return destroyObject(this)};var templateProperties=["type","materials","uniforms","components","source"],componentProperties=["diffuse","specular","shininess","normal","emission","alpha"];function checkForTemplateErrors(e){var t=e._template,i=t.uniforms,r=t.materials,e=t.components;checkForValidProperties(t,templateProperties,invalidNameError,!0),checkForValidProperties(e,componentProperties,invalidNameError,!0);var n,a=[];for(n in r)r.hasOwnProperty(n)&&a.push(n);checkForValidProperties(i,a,duplicateNameError,!1)}function isMaterialFused(e,t){var i,r=t._template.materials;for(i in r)if(r.hasOwnProperty(i)&&-1<e.indexOf(i))return!0;return!1}function createMethodDefinition(e){var t=e._template.components,i=e._template.source;if(defined(i))e.shaderSource+=i+"\n";else{if(e.shaderSource+="czm_material czm_getMaterial(czm_materialInput materialInput)\n{\n",e.shaderSource+="czm_material material = czm_getDefaultMaterial(materialInput);\n",defined(t)){var r,n,a=0<Object.keys(e._template.materials).length;for(r in t)t.hasOwnProperty(r)&&("diffuse"===r||"emission"===r?(n=a&&isMaterialFused(t[r],e)?t[r]:"czm_gammaCorrect("+t[r]+")",e.shaderSource+="material."+r+" = "+n+"; \n"):e.shaderSource+="alpha"===r?"material.alpha = "+t.alpha+"; \n":"material."+r+" = "+t[r]+";\n")}e.shaderSource+="return material;\n}\n"}}var matrixMap={mat2:Matrix2,mat3:Matrix3,mat4:Matrix4},ktxRegex=/\.ktx$/i,crnRegex=/\.crn$/i;function createTexture2DUpdateFunction(l){var c;return function(t,e){var i=t.uniforms,r=i[l],n=c!==r;c=r;var a,o=t._textures[l];if(r instanceof HTMLVideoElement)if(2<=r.readyState){if(n&&defined(o)&&(o!==e.defaultTexture&&o.destroy(),o=void 0),!defined(o)||o===e.defaultTexture){var o=new Texture({context:e,source:r,sampler:new Sampler({minificationFilter:t._minificationFilter,magnificationFilter:t._magnificationFilter})});return void(t._textures[l]=o)}o.copyFrom(r)}else defined(o)||(t._textures[l]=e.defaultTexture);else{if(r instanceof Texture&&r!==o){t._texturePaths[l]=void 0;var s=t._textures[l];return s!==t._defaultTexture&&s.destroy(),t._textures[l]=r,s=l+"Dimensions",void(i.hasOwnProperty(s)&&((a=i[s]).x=r._width,a.y=r._height))}defined(o)||(t._texturePaths[l]=void 0,defined(t._defaultTexture)||(t._defaultTexture=e.defaultTexture),o=t._textures[l]=t._defaultTexture,s=l+"Dimensions",i.hasOwnProperty(s)&&((a=i[s]).x=o._width,a.y=o._height)),r!==Material.DefaultImageId&&(o=r instanceof Resource,(!defined(t._texturePaths[l])||o&&r.url!==t._texturePaths[l].url||!o&&r!==t._texturePaths[l])&&("string"==typeof r||o?(o=o?r:Resource.createIfNeeded(r),when(ktxRegex.test(o.url)?loadKTX(o):crnRegex.test(o.url)?loadCRN(o):o.fetchImage(),function(e){t._loadedImages.push({id:l,image:e})})):(r instanceof HTMLCanvasElement||r instanceof HTMLImageElement)&&t._loadedImages.push({id:l,image:r}),t._texturePaths[l]=r))}}}function createCubeMapUpdateFunction(n){return function(t,e){var i=t.uniforms[n];if(i instanceof CubeMap){var r=t._textures[n];return r!==t._defaultTexture&&r.destroy(),t._texturePaths[n]=void 0,void(t._textures[n]=i)}defined(t._textures[n])||(t._texturePaths[n]=void 0,t._textures[n]=e.defaultCubeMap),i===Material.DefaultCubeMapId||(e=i.positiveX+i.negativeX+i.positiveY+i.negativeY+i.positiveZ+i.negativeZ)!==t._texturePaths[n]&&(i=[Resource.createIfNeeded(i.positiveX).fetchImage(),Resource.createIfNeeded(i.negativeX).fetchImage(),Resource.createIfNeeded(i.positiveY).fetchImage(),Resource.createIfNeeded(i.negativeY).fetchImage(),Resource.createIfNeeded(i.positiveZ).fetchImage(),Resource.createIfNeeded(i.negativeZ).fetchImage()],when.all(i).then(function(e){t._loadedCubeMaps.push({id:n,images:e})}),t._texturePaths[n]=e)}}function createUniforms(e){var t,i=e._template.uniforms;for(t in i)i.hasOwnProperty(t)&&createUniform(e,t)}function createUniform(e,t){e._strict;var i,r,n,a=e._template.uniforms,o=a[t],s=getUniformType(o);"channels"===s?replaceToken(e,t,o,!1):("sampler2D"!==s||0<getNumberOfTokens(e,i=t+"Dimensions")&&(a[i]={type:"ivec3",x:1,y:1},createUniform(e,i)),new RegExp("uniform\\s+"+s+"\\s+"+t+"\\s*;").test(e.shaderSource)||(r="uniform "+s+" "+t+";",e.shaderSource=r+e.shaderSource),r=t+"_"+e._count++,replaceToken(e,t,r),e.uniforms[t]=o,"sampler2D"===s?(e._uniforms[r]=function(){return e._textures[t]},e._updateFunctions.push(createTexture2DUpdateFunction(t))):"samplerCube"===s?(e._uniforms[r]=function(){return e._textures[t]},e._updateFunctions.push(createCubeMapUpdateFunction(t))):-1!==s.indexOf("mat")?(n=new matrixMap[s],e._uniforms[r]=function(){return matrixMap[s].fromColumnMajorArray(e.uniforms[t],n)}):e._uniforms[r]=function(){return e.uniforms[t]})}function getUniformType(e){var t=e.type;if(!defined(t)){var i=typeof e;if("number"==i)t="float";else if("boolean"==i)t="bool";else if("string"==i||e instanceof Resource||e instanceof HTMLCanvasElement||e instanceof HTMLImageElement)t=/^([rgba]){1,4}$/i.test(e)?"channels":e===Material.DefaultCubeMapId?"samplerCube":"sampler2D";else if("object"==i)if(Array.isArray(e))4!==e.length&&9!==e.length&&16!==e.length||(t="mat"+Math.sqrt(e.length));else{var r,n=0;for(r in e)e.hasOwnProperty(r)&&(n+=1);2<=n&&n<=4?t="vec"+n:6===n&&(t="samplerCube")}}return t}function createSubMaterials(e){var t,i,r,n=e._strict,a=e._template.materials;for(t in a)a.hasOwnProperty(t)&&(i=new Material({strict:n,fabric:a[t],count:e._count}),e._count=i._count,e._uniforms=combine(e._uniforms,i._uniforms,!0),e.materials[t]=i,e._translucentFunctions=e._translucentFunctions.concat(i._translucentFunctions),replaceToken(i,r="czm_getMaterial",r=r+"_"+e._count++),e.shaderSource=i.shaderSource+e.shaderSource,replaceToken(e,t,r+"(materialInput)"))}function replaceToken(e,t,r,i){i=defaultValue(i,!0);var n=0,t=new RegExp("([\\w"+(i?".":"")+"])?"+t+"([\\w])?","g");return e.shaderSource=e.shaderSource.replace(t,function(e,t,i){return t||i?e:(n+=1,r)}),n}function getNumberOfTokens(e,t,i){return replaceToken(e,t,t,i)}function MaterialAppearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.translucent,!0),i=defaultValue(e.closed,!1),r=defaultValue(e.materialSupport,MaterialAppearance.MaterialSupport.TEXTURED);this.material=defined(e.material)?e.material:Material.fromType(Material.ColorType),this.translucent=t,this._vertexShaderSource=defaultValue(e.vertexShaderSource,r.vertexShaderSource),this._fragmentShaderSource=defaultValue(e.fragmentShaderSource,r.fragmentShaderSource),this._renderState=Appearance.getDefaultRenderState(t,i,e.renderState),this._closed=i,this._materialSupport=r,this._vertexFormat=r.vertexFormat,this._flat=defaultValue(e.flat,!1),this._faceForward=defaultValue(e.faceForward,!i)}Material._materialCache={_materials:{},addMaterial:function(e,t){this._materials[e]=t},getMaterial:function(e){return this._materials[e]}},Material.DefaultImageId="czm_defaultImage",Material.DefaultCubeMapId="czm_defaultCubeMap",Material.ColorType="Color",Material._materialCache.addMaterial(Material.ColorType,{fabric:{type:Material.ColorType,uniforms:{color:new Color(1,0,0,.5)},components:{diffuse:"color.rgb",alpha:"color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),Material.ImageType="Image",Material._materialCache.addMaterial(Material.ImageType,{fabric:{type:Material.ImageType,uniforms:{image:Material.DefaultImageId,repeat:new Cartesian2(1,1),color:new Color(1,1,1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).rgb * color.rgb",alpha:"texture2D(image, fract(repeat * materialInput.st)).a * color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),Material.DiffuseMapType="DiffuseMap",Material._materialCache.addMaterial(Material.DiffuseMapType,{fabric:{type:Material.DiffuseMapType,uniforms:{image:Material.DefaultImageId,channels:"rgb",repeat:new Cartesian2(1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),Material.AlphaMapType="AlphaMap",Material._materialCache.addMaterial(Material.AlphaMapType,{fabric:{type:Material.AlphaMapType,uniforms:{image:Material.DefaultImageId,channel:"a",repeat:new Cartesian2(1,1)},components:{alpha:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!0}),Material.SpecularMapType="SpecularMap",Material._materialCache.addMaterial(Material.SpecularMapType,{fabric:{type:Material.SpecularMapType,uniforms:{image:Material.DefaultImageId,channel:"r",repeat:new Cartesian2(1,1)},components:{specular:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!1}),Material.EmissionMapType="EmissionMap",Material._materialCache.addMaterial(Material.EmissionMapType,{fabric:{type:Material.EmissionMapType,uniforms:{image:Material.DefaultImageId,channels:"rgb",repeat:new Cartesian2(1,1)},components:{emission:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),Material.BumpMapType="BumpMap",Material._materialCache.addMaterial(Material.BumpMapType,{fabric:{type:Material.BumpMapType,uniforms:{image:Material.DefaultImageId,channel:"r",strength:.8,repeat:new Cartesian2(1,1)},source:BumpMapMaterial},translucent:!1}),Material.NormalMapType="NormalMap",Material._materialCache.addMaterial(Material.NormalMapType,{fabric:{type:Material.NormalMapType,uniforms:{image:Material.DefaultImageId,channels:"rgb",strength:.8,repeat:new Cartesian2(1,1)},source:NormalMapMaterial},translucent:!1}),Material.GridType="Grid",Material._materialCache.addMaterial(Material.GridType,{fabric:{type:Material.GridType,uniforms:{color:new Color(0,1,0,1),cellAlpha:.1,lineCount:new Cartesian2(8,8),lineThickness:new Cartesian2(1,1),lineOffset:new Cartesian2(0,0)},source:GridMaterial},translucent:function(e){e=e.uniforms;return e.color.alpha<1||e.cellAlpha<1}}),Material.StripeType="Stripe",Material._materialCache.addMaterial(Material.StripeType,{fabric:{type:Material.StripeType,uniforms:{horizontal:!0,evenColor:new Color(1,1,1,.5),oddColor:new Color(0,0,1,.5),offset:0,repeat:5},source:StripeMaterial},translucent:function(e){e=e.uniforms;return e.evenColor.alpha<1||e.oddColor.alpha<1}}),Material.CheckerboardType="Checkerboard",Material._materialCache.addMaterial(Material.CheckerboardType,{fabric:{type:Material.CheckerboardType,uniforms:{lightColor:new Color(1,1,1,.5),darkColor:new Color(0,0,0,.5),repeat:new Cartesian2(5,5)},source:CheckerboardMaterial},translucent:function(e){e=e.uniforms;return e.lightColor.alpha<1||e.darkColor.alpha<1}}),Material.DotType="Dot",Material._materialCache.addMaterial(Material.DotType,{fabric:{type:Material.DotType,uniforms:{lightColor:new Color(1,1,0,.75),darkColor:new Color(0,1,1,.75),repeat:new Cartesian2(5,5)},source:DotMaterial},translucent:function(e){e=e.uniforms;return e.lightColor.alpha<1||e.darkColor.alpha<1}}),Material.WaterType="Water",Material._materialCache.addMaterial(Material.WaterType,{fabric:{type:Material.WaterType,uniforms:{baseWaterColor:new Color(.2,.3,.6,1),blendColor:new Color(0,1,.699,1),specularMap:Material.DefaultImageId,normalMap:Material.DefaultImageId,frequency:10,animationSpeed:.01,amplitude:1,specularIntensity:.5,fadeFactor:1},source:WaterMaterial},translucent:function(e){e=e.uniforms;return e.baseWaterColor.alpha<1||e.blendColor.alpha<1}}),Material.RimLightingType="RimLighting",Material._materialCache.addMaterial(Material.RimLightingType,{fabric:{type:Material.RimLightingType,uniforms:{color:new Color(1,0,0,.7),rimColor:new Color(1,1,1,.4),width:.3},source:RimLightingMaterial},translucent:function(e){e=e.uniforms;return e.color.alpha<1||e.rimColor.alpha<1}}),Material.FadeType="Fade",Material._materialCache.addMaterial(Material.FadeType,{fabric:{type:Material.FadeType,uniforms:{fadeInColor:new Color(1,0,0,1),fadeOutColor:new Color(0,0,0,0),maximumDistance:.5,repeat:!0,fadeDirection:{x:!0,y:!0},time:new Cartesian2(.5,.5)},source:FadeMaterial},translucent:function(e){e=e.uniforms;return e.fadeInColor.alpha<1||e.fadeOutColor.alpha<1}}),Material.PolylineArrowType="PolylineArrow",Material._materialCache.addMaterial(Material.PolylineArrowType,{fabric:{type:Material.PolylineArrowType,uniforms:{color:new Color(1,1,1,1)},source:PolylineArrowMaterial},translucent:!0}),Material.PolylineDashType="PolylineDash",Material._materialCache.addMaterial(Material.PolylineDashType,{fabric:{type:Material.PolylineDashType,uniforms:{color:new Color(1,0,1,1),gapColor:new Color(0,0,0,0),dashLength:16,dashPattern:255},source:PolylineDashMaterial},translucent:!0}),Material.PolylineGlowType="PolylineGlow",Material._materialCache.addMaterial(Material.PolylineGlowType,{fabric:{type:Material.PolylineGlowType,uniforms:{color:new Color(0,.5,1,1),glowPower:.25,taperPower:1},source:PolylineGlowMaterial},translucent:!0}),Material.PolylineOutlineType="PolylineOutline",Material._materialCache.addMaterial(Material.PolylineOutlineType,{fabric:{type:Material.PolylineOutlineType,uniforms:{color:new Color(1,1,1,1),outlineColor:new Color(1,0,0,1),outlineWidth:1},source:PolylineOutlineMaterial},translucent:function(e){e=e.uniforms;return e.color.alpha<1||e.outlineColor.alpha<1}}),Material.ElevationContourType="ElevationContour",Material._materialCache.addMaterial(Material.ElevationContourType,{fabric:{type:Material.ElevationContourType,uniforms:{spacing:100,color:new Color(1,0,0,1),width:1},source:ElevationContourMaterial},translucent:!1}),Material.ElevationRampType="ElevationRamp",Material._materialCache.addMaterial(Material.ElevationRampType,{fabric:{type:Material.ElevationRampType,uniforms:{image:Material.DefaultImageId,minimumHeight:0,maximumHeight:1e4},source:ElevationRampMaterial},translucent:!1}),Material.SlopeRampMaterialType="SlopeRamp",Material._materialCache.addMaterial(Material.SlopeRampMaterialType,{fabric:{type:Material.SlopeRampMaterialType,uniforms:{image:Material.DefaultImageId},source:SlopeRampMaterial},translucent:!1}),Material.AspectRampMaterialType="AspectRamp",Material._materialCache.addMaterial(Material.AspectRampMaterialType,{fabric:{type:Material.AspectRampMaterialType,uniforms:{image:Material.DefaultImageId},source:AspectRampMaterial},translucent:!1}),Material.ElevationBandType="ElevationBand",Material._materialCache.addMaterial(Material.ElevationBandType,{fabric:{type:Material.ElevationBandType,uniforms:{heights:Material.DefaultImageId,colors:Material.DefaultImageId},source:ElevationBandMaterial},translucent:!0}),Object.defineProperties(MaterialAppearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},materialSupport:{get:function(){return this._materialSupport}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),MaterialAppearance.prototype.getFragmentShaderSource=Appearance.prototype.getFragmentShaderSource,MaterialAppearance.prototype.isTranslucent=Appearance.prototype.isTranslucent,MaterialAppearance.prototype.getRenderState=Appearance.prototype.getRenderState,MaterialAppearance.MaterialSupport={BASIC:Object.freeze({vertexFormat:VertexFormat.POSITION_AND_NORMAL,vertexShaderSource:BasicMaterialAppearanceVS,fragmentShaderSource:BasicMaterialAppearanceFS}),TEXTURED:Object.freeze({vertexFormat:VertexFormat.POSITION_NORMAL_AND_ST,vertexShaderSource:TexturedMaterialAppearanceVS,fragmentShaderSource:TexturedMaterialAppearanceFS}),ALL:Object.freeze({vertexFormat:VertexFormat.ALL,vertexShaderSource:AllMaterialAppearanceVS,fragmentShaderSource:AllMaterialAppearanceFS})};var PerInstanceColorAppearanceFS="varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nvec4 color = czm_gammaCorrect(v_color);\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getDefaultMaterial(materialInput);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);\n}\n",PerInstanceColorAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec4 color;\nattribute float batchId;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n",PerInstanceFlatColorAppearanceFS="varying vec4 v_color;\nvoid main()\n{\ngl_FragColor = czm_gammaCorrect(v_color);\n}\n",PerInstanceFlatColorAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec4 color;\nattribute float batchId;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n";function PerInstanceColorAppearance(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT);var t=defaultValue(e.translucent,!0),i=defaultValue(e.closed,!1),r=defaultValue(e.flat,!1),n=r?PerInstanceFlatColorAppearanceVS:PerInstanceColorAppearanceVS,a=r?PerInstanceFlatColorAppearanceFS:PerInstanceColorAppearanceFS,o=r?PerInstanceColorAppearance.FLAT_VERTEX_FORMAT:PerInstanceColorAppearance.VERTEX_FORMAT;this.material=void 0,this.translucent=t,this._vertexShaderSource=defaultValue(e.vertexShaderSource,n),this._fragmentShaderSource=defaultValue(e.fragmentShaderSource,a),this._renderState=Appearance.getDefaultRenderState(t,i,e.renderState),this._closed=i,this._vertexFormat=o,this._flat=r,this._faceForward=defaultValue(e.faceForward,!i)}function ColorMaterialProperty(e){this._definitionChanged=new Event,this._color=void 0,this._colorSubscription=void 0,this.color=e}function DrawCommand(e){e=defaultValue(e,defaultValue.EMPTY_OBJECT),this._boundingVolume=e.boundingVolume,this._orientedBoundingBox=e.orientedBoundingBox,this._cull=defaultValue(e.cull,!0),this._occlude=defaultValue(e.occlude,!0),this._modelMatrix=e.modelMatrix,this._primitiveType=defaultValue(e.primitiveType,PrimitiveType$1.TRIANGLES),this._vertexArray=e.vertexArray,this._count=e.count,this._offset=defaultValue(e.offset,0),this._instanceCount=defaultValue(e.instanceCount,0),this._shaderProgram=e.shaderProgram,this._uniformMap=e.uniformMap,this._renderState=e.renderState,this._framebuffer=e.framebuffer,this._pass=e.pass,this._executeInClosestFrustum=defaultValue(e.executeInClosestFrustum,!1),this._owner=e.owner,this._debugShowBoundingVolume=defaultValue(e.debugShowBoundingVolume,!1),this._debugOverlappingFrustums=0,this._castShadows=defaultValue(e.castShadows,!1),this._receiveShadows=defaultValue(e.receiveShadows,!1),this._pickId=e.pickId,this._pickOnly=defaultValue(e.pickOnly,!1),this.dirty=!0,this.lastDirtyTime=0,this.derivedCommands={}}Object.defineProperties(PerInstanceColorAppearance.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),PerInstanceColorAppearance.VERTEX_FORMAT=VertexFormat.POSITION_AND_NORMAL,PerInstanceColorAppearance.FLAT_VERTEX_FORMAT=VertexFormat.POSITION_ONLY,PerInstanceColorAppearance.prototype.getFragmentShaderSource=Appearance.prototype.getFragmentShaderSource,PerInstanceColorAppearance.prototype.isTranslucent=Appearance.prototype.isTranslucent,PerInstanceColorAppearance.prototype.getRenderState=Appearance.prototype.getRenderState,Object.defineProperties(ColorMaterialProperty.prototype,{isConstant:{get:function(){return Property.isConstant(this._color)}},definitionChanged:{get:function(){return this._definitionChanged}},color:createPropertyDescriptor("color")}),ColorMaterialProperty.prototype.getType=function(e){return"Color"},ColorMaterialProperty.prototype.getValue=function(e,t){return defined(t)||(t={}),t.color=Property.getValueOrClonedDefault(this._color,e,Color.WHITE,t.color),t},ColorMaterialProperty.prototype.equals=function(e){return this===e||e instanceof ColorMaterialProperty&&Property.equals(this._color,e._color)},Object.defineProperties(DrawCommand.prototype,{boundingVolume:{get:function(){return this._boundingVolume},set:function(e){this._boundingVolume!==e&&(this._boundingVolume=e,this.dirty=!0)}},orientedBoundingBox:{get:function(){return this._orientedBoundingBox},set:function(e){this._orientedBoundingBox!==e&&(this._orientedBoundingBox=e,this.dirty=!0)}},cull:{get:function(){return this._cull},set:function(e){this._cull!==e&&(this._cull=e,this.dirty=!0)}},occlude:{get:function(){return this._occlude},set:function(e){this._occlude!==e&&(this._occlude=e,this.dirty=!0)}},modelMatrix:{get:function(){return this._modelMatrix},set:function(e){this._modelMatrix!==e&&(this._modelMatrix=e,this.dirty=!0)}},primitiveType:{get:function(){return this._primitiveType},set:function(e){this._primitiveType!==e&&(this._primitiveType=e,this.dirty=!0)}},vertexArray:{get:function(){return this._vertexArray},set:function(e){this._vertexArray!==e&&(this._vertexArray=e,this.dirty=!0)}},count:{get:function(){return this._count},set:function(e){this._count!==e&&(this._count=e,this.dirty=!0)}},offset:{get:function(){return this._offset},set:function(e){this._offset!==e&&(this._offset=e,this.dirty=!0)}},instanceCount:{get:function(){return this._instanceCount},set:function(e){this._instanceCount!==e&&(this._instanceCount=e,this.dirty=!0)}},shaderProgram:{get:function(){return this._shaderProgram},set:function(e){this._shaderProgram!==e&&(this._shaderProgram=e,this.dirty=!0)}},castShadows:{get:function(){return this._castShadows},set:function(e){this._castShadows!==e&&(this._castShadows=e,this.dirty=!0)}},receiveShadows:{get:function(){return this._receiveShadows},set:function(e){this._receiveShadows!==e&&(this._receiveShadows=e,this.dirty=!0)}},uniformMap:{get:function(){return this._uniformMap},set:function(e){this._uniformMap!==e&&(this._uniformMap=e,this.dirty=!0)}},renderState:{get:function(){return this._renderState},set:function(e){this._renderState!==e&&(this._renderState=e,this.dirty=!0)}},framebuffer:{get:function(){return this._framebuffer},set:function(e){this._framebuffer!==e&&(this._framebuffer=e,this.dirty=!0)}},pass:{get:function(){return this._pass},set:function(e){this._pass!==e&&(this._pass=e,this.dirty=!0)}},executeInClosestFrustum:{get:function(){return this._executeInClosestFrustum},set:function(e){this._executeInClosestFrustum!==e&&(this._executeInClosestFrustum=e,this.dirty=!0)}},owner:{get:function(){return this._owner},set:function(e){this._owner!==e&&(this._owner=e,this.dirty=!0)}},debugShowBoundingVolume:{get:function(){return this._debugShowBoundingVolume},set:function(e){this._debugShowBoundingVolume!==e&&(this._debugShowBoundingVolume=e,this.dirty=!0)}},debugOverlappingFrustums:{get:function(){return this._debugOverlappingFrustums},set:function(e){this._debugOverlappingFrustums!==e&&(this._debugOverlappingFrustums=e,this.dirty=!0)}},pickId:{get:function(){return this._pickId},set:function(e){this._pickId!==e&&(this._pickId=e,this.dirty=!0)}},pickOnly:{get:function(){return this._pickOnly},set:function(e){this._pickOnly!==e&&(this._pickOnly=e,this.dirty=!0)}}}),DrawCommand.shallowClone=function(e,t){if(defined(e))return defined(t)||(t=new DrawCommand),t._boundingVolume=e._boundingVolume,t._orientedBoundingBox=e._orientedBoundingBox,t._cull=e._cull,t._occlude=e._occlude,t._modelMatrix=e._modelMatrix,t._primitiveType=e._primitiveType,t._vertexArray=e._vertexArray,t._count=e._count,t._offset=e._offset,t._instanceCount=e._instanceCount,t._shaderProgram=e._shaderProgram,t._uniformMap=e._uniformMap,t._renderState=e._renderState,t._framebuffer=e._framebuffer,t._pass=e._pass,t._executeInClosestFrustum=e._executeInClosestFrustum,t._owner=e._owner,t._debugShowBoundingVolume=e._debugShowBoundingVolume,t._debugOverlappingFrustums=e._debugOverlappingFrustums,t._castShadows=e._castShadows,t._receiveShadows=e._receiveShadows,t._pickId=e._pickId,t._pickOnly=e._pickOnly,t.dirty=!0,t.lastDirtyTime=0,t},DrawCommand.prototype.execute=function(e,t){e.draw(this,t)};var Pass={ENVIRONMENT:0,COMPUTE:1,GLOBE:2,TERRAIN_CLASSIFICATION:3,CESIUM_3D_TILE:4,CESIUM_3D_TILE_CLASSIFICATION:5,CESIUM_3D_TILE_CLASSIFICATION_IGNORE_SHOW:6,OPAQUE:7,TRANSLUCENT:8,OVERLAY:9,NUMBER_OF_PASSES:10},Pass$1=Object.freeze(Pass);function freezeRenderState(e){if("object"!=typeof e||null===e)return e;for(var t,i=Object.keys(e),r=0;r<i.length;r++)t=i[r],e.hasOwnProperty(t)&&"_applyFunctions"!==t&&(e[t]=freezeRenderState(e[t]));return Object.freeze(e)}function RenderState(e){var t=defaultValue(e,defaultValue.EMPTY_OBJECT),i=defaultValue(t.cull,defaultValue.EMPTY_OBJECT),r=defaultValue(t.polygonOffset,defaultValue.EMPTY_OBJECT),n=defaultValue(t.scissorTest,defaultValue.EMPTY_OBJECT),a=defaultValue(n.rectangle,defaultValue.EMPTY_OBJECT),o=defaultValue(t.depthRange,defaultValue.EMPTY_OBJECT),s=defaultValue(t.depthTest,defaultValue.EMPTY_OBJECT),l=defaultValue(t.colorMask,defaultValue.EMPTY_OBJECT),c=defaultValue(t.blending,defaultValue.EMPTY_OBJECT),u=defaultValue(c.color,defaultValue.EMPTY_OBJECT),d=defaultValue(t.stencilTest,defaultValue.EMPTY_OBJECT),h=defaultValue(d.frontOperation,defaultValue.EMPTY_OBJECT),p=defaultValue(d.backOperation,defaultValue.EMPTY_OBJECT),m=defaultValue(t.sampleCoverage,defaultValue.EMPTY_OBJECT),e=t.viewport;this.frontFace=defaultValue(t.frontFace,WindingOrder$1.COUNTER_CLOCKWISE),this.cull={enabled:defaultValue(i.enabled,!1),face:defaultValue(i.face,WebGLConstants$1.BACK)},this.lineWidth=defaultValue(t.lineWidth,1),this.polygonOffset={enabled:defaultValue(r.enabled,!1),factor:defaultValue(r.factor,0),units:defaultValue(r.units,0)},this.scissorTest={enabled:defaultValue(n.enabled,!1),rectangle:BoundingRectangle.clone(a)},this.depthRange={near:defaultValue(o.near,0),far:defaultValue(o.far,1)},this.depthTest={enabled:defaultValue(s.enabled,!1),func:defaultValue(s.func,WebGLConstants$1.LESS)},this.colorMask={red:defaultValue(l.red,!0),green:defaultValue(l.green,!0),blue:defaultValue(l.blue,!0),alpha:defaultValue(l.alpha,!0)},this.depthMask=defaultValue(t.depthMask,!0),this.stencilMask=defaultValue(t.stencilMask,-1),this.blending={enabled:defaultValue(c.enabled,!1),color:new Color(defaultValue(u.red,0),defaultValue(u.green,0),defaultValue(u.blue,0),defaultValue(u.alpha,0)),equationRgb:defaultValue(c.equationRgb,WebGLConstants$1.FUNC_ADD),equationAlpha:defaultValue(c.equationAlpha,WebGLConstants$1.FUNC_ADD),functionSourceRgb:defaultValue(c.functionSourceRgb,WebGLConstants$1.ONE),functionSourceAlpha:defaultValue(c.functionSourceAlpha,WebGLConstants$1.ONE),functionDestinationRgb:defaultValue(c.functionDestinationRgb,WebGLConstants$1.ZERO),functionDestinationAlpha:defaultValue(c.functionDestinationAlpha,WebGLConstants$1.ZERO)},this.stencilTest={enabled:defaultValue(d.enabled,!1),frontFunction:defaultValue(d.frontFunction,WebGLConstants$1.ALWAYS),backFunction:defaultValue(d.backFunction,WebGLConstants$1.ALWAYS),reference:defaultValue(d.reference,0),mask:defaultValue(d.mask,-1),frontOperation:{fail:defaultValue(h.fail,WebGLConstants$1.KEEP),zFail:defaultValue(h.zFail,WebGLConstants$1.KEEP),zPass:defaultValue(h.zPass,WebGLConstants$1.KEEP)},backOperation:{fail:defaultValue(p.fail,WebGLConstants$1.KEEP),zFail:defaultValue(p.zFail,WebGLConstants$1.KEEP),zPass:defaultValue(p.zPass,WebGLConstants$1.KEEP)}},this.sampleCoverage={enabled:defaultValue(m.enabled,!1),value:defaultValue(m.value,1),invert:defaultValue(m.invert,!1)},this.viewport=defined(e)?new BoundingRectangle(e.x,e.y,e.width,e.height):void 0,this.id=0,this._applyFunctions=[]}var nextRenderStateId=0,renderStateCache={};function enableOrDisable(e,t,i){i?e.enable(t):e.disable(t)}function applyFrontFace(e,t){e.frontFace(t.frontFace)}function applyCull(e,t){var i=t.cull,t=i.enabled;enableOrDisable(e,e.CULL_FACE,t),t&&e.cullFace(i.face)}function applyLineWidth(e,t){e.lineWidth(t.lineWidth)}function applyPolygonOffset(e,t){var i=t.polygonOffset,t=i.enabled;enableOrDisable(e,e.POLYGON_OFFSET_FILL,t),t&&e.polygonOffset(i.factor,i.units)}function applyScissorTest(e,t,i){var r=t.scissorTest,t=(defined(i.scissorTest)?i.scissorTest:r).enabled;enableOrDisable(e,e.SCISSOR_TEST,t),t&&(r=(defined(i.scissorTest)?i.scissorTest:r).rectangle,e.scissor(r.x,r.y,r.width,r.height))}function applyDepthRange(e,t){t=t.depthRange;e.depthRange(t.near,t.far)}function applyDepthTest(e,t){var i=t.depthTest,t=i.enabled;enableOrDisable(e,e.DEPTH_TEST,t),t&&e.depthFunc(i.func)}function applyColorMask(e,t){t=t.colorMask;e.colorMask(t.red,t.green,t.blue,t.alpha)}function applyDepthMask(e,t){e.depthMask(t.depthMask)}function applyStencilMask(e,t){e.stencilMask(t.stencilMask)}function applyBlendingColor(e,t){e.blendColor(t.red,t.green,t.blue,t.alpha)}function applyBlending(e,t,i){t=t.blending,i=defined(i.blendingEnabled)?i.blendingEnabled:t.enabled;enableOrDisable(e,e.BLEND,i),i&&(applyBlendingColor(e,t.color),e.blendEquationSeparate(t.equationRgb,t.equationAlpha),e.blendFuncSeparate(t.functionSourceRgb,t.functionDestinationRgb,t.functionSourceAlpha,t.functionDestinationAlpha))}function applyStencilTest(e,t){var i,r,n=t.stencilTest,a=n.enabled;enableOrDisable(e,e.STENCIL_TEST,a),a&&(r=n.frontFunction,i=n.backFunction,t=n.reference,a=n.mask,e.stencilFunc(r,t,a),e.stencilFuncSeparate(e.BACK,i,t,a),e.stencilFuncSeparate(e.FRONT,r,t,a),t=(r=n.frontOperation).fail,a=r.zFail,r=r.zPass,e.stencilOpSeparate(e.FRONT,t,a,r),r=(a=n.backOperation).fail,n=a.zFail,a=a.zPass,e.stencilOpSeparate(e.BACK,r,n,a))}function applySampleCoverage(e,t){var i=t.sampleCoverage,t=i.enabled;enableOrDisable(e,e.SAMPLE_COVERAGE,t),t&&e.sampleCoverage(i.value,i.invert)}RenderState.fromCache=function(e){var t=JSON.stringify(e),i=renderStateCache[t];if(defined(i))return++i.referenceCount,i.state;var r=new RenderState(e),e=JSON.stringify(r);return defined(i=renderStateCache[e])||(r.id=nextRenderStateId++,i={referenceCount:0,state:r},renderStateCache[e]=i),++i.referenceCount,renderStateCache[t]={referenceCount:1,state:i.state},i.state},RenderState.removeFromCache=function(e){var t=new RenderState(e),i=JSON.stringify(t),r=renderStateCache[i],t=JSON.stringify(e),e=renderStateCache[t];defined(e)&&(--e.referenceCount,0===e.referenceCount&&(delete renderStateCache[t],defined(r)&&--r.referenceCount)),defined(r)&&0===r.referenceCount&&delete renderStateCache[i]},RenderState.getCache=function(){return renderStateCache},RenderState.clearCache=function(){renderStateCache={}};var scratchViewport=new BoundingRectangle;function applyViewport(e,t,i){t=defaultValue(t.viewport,i.viewport);defined(t)||((t=scratchViewport).width=i.context.drawingBufferWidth,t.height=i.context.drawingBufferHeight),i.context.uniformState.viewport=t,e.viewport(t.x,t.y,t.width,t.height)}function createFuncs(e,t){var i=[];return e.frontFace!==t.frontFace&&i.push(applyFrontFace),e.cull.enabled===t.cull.enabled&&e.cull.face===t.cull.face||i.push(applyCull),e.lineWidth!==t.lineWidth&&i.push(applyLineWidth),e.polygonOffset.enabled===t.polygonOffset.enabled&&e.polygonOffset.factor===t.polygonOffset.factor&&e.polygonOffset.units===t.polygonOffset.units||i.push(applyPolygonOffset),e.depthRange.near===t.depthRange.near&&e.depthRange.far===t.depthRange.far||i.push(applyDepthRange),e.depthTest.enabled===t.depthTest.enabled&&e.depthTest.func===t.depthTest.func||i.push(applyDepthTest),e.colorMask.red===t.colorMask.red&&e.colorMask.green===t.colorMask.green&&e.colorMask.blue===t.colorMask.blue&&e.colorMask.alpha===t.colorMask.alpha||i.push(applyColorMask),e.depthMask!==t.depthMask&&i.push(applyDepthMask),e.stencilMask!==t.stencilMask&&i.push(applyStencilMask),e.stencilTest.enabled===t.stencilTest.enabled&&e.stencilTest.frontFunction===t.stencilTest.frontFunction&&e.stencilTest.backFunction===t.stencilTest.backFunction&&e.stencilTest.reference===t.stencilTest.reference&&e.stencilTest.mask===t.stencilTest.mask&&e.stencilTest.frontOperation.fail===t.stencilTest.frontOperation.fail&&e.stencilTest.frontOperation.zFail===t.stencilTest.frontOperation.zFail&&e.stencilTest.backOperation.fail===t.stencilTest.backOperation.fail&&e.stencilTest.backOperation.zFail===t.stencilTest.backOperation.zFail&&e.stencilTest.backOperation.zPass===t.stencilTest.backOperation.zPass||i.push(applyStencilTest),e.sampleCoverage.enabled===t.sampleCoverage.enabled&&e.sampleCoverage.value===t.sampleCoverage.value&&e.sampleCoverage.invert===t.sampleCoverage.invert||i.push(applySampleCoverage),i}RenderState.apply=function(e,t,i){applyFrontFace(e,t),applyCull(e,t),applyLineWidth(e,t),applyPolygonOffset(e,t),applyDepthRange(e,t),applyDepthTest(e,t),applyColorMask(e,t),applyDepthMask(e,t),applyStencilMask(e,t),applyStencilTest(e,t),applySampleCoverage(e,t),applyScissorTest(e,t,i),applyBlending(e,t,i),applyViewport(e,t,i)},RenderState.partialApply=function(e,t,i,r,n,a){if(t!==i){var o=i._applyFunctions[t.id];defined(o)||(o=createFuncs(t,i),i._applyFunctions[t.id]=o);for(var s=o.length,l=0;l<s;++l)o[l](e,i)}(defined(r.scissorTest)?r:t).scissorTest===(defined(n.scissorTest)?n:i).scissorTest&&!a||applyScissorTest(e,i,n);var c=defined(r.blendingEnabled)?r.blendingEnabled:t.blending.enabled,a=defined(n.blendingEnabled)?n.blendingEnabled:i.blending.enabled;(c!==a||a&&t.blending!==i.blending)&&applyBlending(e,i,n),t===i&&r===n&&r.context===n.context||applyViewport(e,i,n)},RenderState.getState=function(e){return{frontFace:e.frontFace,cull:{enabled:e.cull.enabled,face:e.cull.face},lineWidth:e.lineWidth,polygonOffset:{enabled:e.polygonOffset.enabled,factor:e.polygonOffset.factor,units:e.polygonOffset.units},scissorTest:{enabled:e.scissorTest.enabled,rectangle:BoundingRectangle.clone(e.scissorTest.rectangle)},depthRange:{near:e.depthRange.near,far:e.depthRange.far},depthTest:{enabled:e.depthTest.enabled,func:e.depthTest.func},colorMask:{red:e.colorMask.red,green:e.colorMask.green,blue:e.colorMask.blue,alpha:e.colorMask.alpha},depthMask:e.depthMask,stencilMask:e.stencilMask,blending:{enabled:e.blending.enabled,color:Color.clone(e.blending.color),equationRgb:e.blending.equationRgb,equationAlpha:e.blending.equationAlpha,functionSourceRgb:e.blending.functionSourceRgb,functionSourceAlpha:e.blending.functionSourceAlpha,functionDestinationRgb:e.blending.functionDestinationRgb,functionDestinationAlpha:e.blending.functionDestinationAlpha},stencilTest:{enabled:e.stencilTest.enabled,frontFunction:e.stencilTest.frontFunction,backFunction:e.stencilTest.backFunction,reference:e.stencilTest.reference,mask:e.stencilTest.mask,frontOperation:{fail:e.stencilTest.frontOperation.fail,zFail:e.stencilTest.frontOperation.zFail,zPass:e.stencilTest.frontOperation.zPass},backOperation:{fail:e.stencilTest.backOperation.fail,zFail:e.stencilTest.backOperation.zFail,zPass:e.stencilTest.backOperation.zPass}},sampleCoverage:{enabled:e.sampleCoverage.enabled,value:e.sampleCoverage.value,invert:e.sampleCoverage.invert},viewport:defined(e.viewport)?BoundingRectangle.clone(e.viewport):void 0}};var viewerPositionWCScratch=new Cartesian3;function AutomaticUniform(e){this._size=e.size,this._datatype=e.datatype,this.getValue=e.getValue}var datatypeToGlsl={};datatypeToGlsl[WebGLConstants$1.FLOAT]="float",datatypeToGlsl[WebGLConstants$1.FLOAT_VEC2]="vec2",datatypeToGlsl[WebGLConstants$1.FLOAT_VEC3]="vec3",datatypeToGlsl[WebGLConstants$1.FLOAT_VEC4]="vec4",datatypeToGlsl[WebGLConstants$1.INT]="int",datatypeToGlsl[WebGLConstants$1.INT_VEC2]="ivec2",datatypeToGlsl[WebGLConstants$1.INT_VEC3]="ivec3",datatypeToGlsl[WebGLConstants$1.INT_VEC4]="ivec4",datatypeToGlsl[WebGLConstants$1.BOOL]="bool",datatypeToGlsl[WebGLConstants$1.BOOL_VEC2]="bvec2",datatypeToGlsl[WebGLConstants$1.BOOL_VEC3]="bvec3",datatypeToGlsl[WebGLConstants$1.BOOL_VEC4]="bvec4",datatypeToGlsl[WebGLConstants$1.FLOAT_MAT2]="mat2",datatypeToGlsl[WebGLConstants$1.FLOAT_MAT3]="mat3",datatypeToGlsl[WebGLConstants$1.FLOAT_MAT4]="mat4",datatypeToGlsl[WebGLConstants$1.SAMPLER_2D]="sampler2D",datatypeToGlsl[WebGLConstants$1.SAMPLER_CUBE]="samplerCube",AutomaticUniform.prototype.getDeclaration=function(e){var t="uniform "+datatypeToGlsl[this._datatype]+" "+e,e=this._size;return t+=1===e?";":"["+e.toString()+"];"};var AutomaticUniforms={czm_viewport:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.viewportCartesian4}}),czm_viewportOrthographic:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.viewportOrthographic}}),czm_viewportTransformation:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.viewportTransformation}}),czm_globeDepthTexture:new AutomaticUniform({size:1,datatype:WebGLConstants$1.SAMPLER_2D,getValue:function(e){return e.globeDepthTexture}}),czm_model:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.model}}),czm_inverseModel:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModel}}),czm_view:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.view}}),czm_view3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.view3D}}),czm_viewRotation:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.viewRotation}}),czm_viewRotation3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.viewRotation3D}}),czm_inverseView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseView}}),czm_inverseView3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseView3D}}),czm_inverseViewRotation:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation}}),czm_inverseViewRotation3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation3D}}),czm_projection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.projection}}),czm_inverseProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseProjection}}),czm_infiniteProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.infiniteProjection}}),czm_modelView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelView}}),czm_modelView3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelView3D}}),czm_modelViewRelativeToEye:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewRelativeToEye}}),czm_inverseModelView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModelView}}),czm_inverseModelView3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModelView3D}}),czm_viewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.viewProjection}}),czm_inverseViewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseViewProjection}}),czm_modelViewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewProjection}}),czm_inverseModelViewProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.inverseModelViewProjection}}),czm_modelViewProjectionRelativeToEye:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewProjectionRelativeToEye}}),czm_modelViewInfiniteProjection:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT4,getValue:function(e){return e.modelViewInfiniteProjection}}),czm_orthographicIn3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.orthographicIn3D?1:0}}),czm_normal:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.normal}}),czm_normal3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.normal3D}}),czm_inverseNormal:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseNormal}}),czm_inverseNormal3D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.inverseNormal3D}}),czm_eyeHeight:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.eyeHeight}}),czm_eyeHeight2D:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.eyeHeight2D}}),czm_entireFrustum:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.entireFrustum}}),czm_currentFrustum:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.currentFrustum}}),czm_frustumPlanes:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.frustumPlanes}}),czm_farDepthFromNearPlusOne:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.farDepthFromNearPlusOne}}),czm_log2FarDepthFromNearPlusOne:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.log2FarDepthFromNearPlusOne}}),czm_oneOverLog2FarDepthFromNearPlusOne:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.oneOverLog2FarDepthFromNearPlusOne}}),czm_sunPositionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunPositionWC}}),czm_sunPositionColumbusView:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunPositionColumbusView}}),czm_sunDirectionEC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunDirectionEC}}),czm_sunDirectionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sunDirectionWC}}),czm_moonDirectionEC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.moonDirectionEC}}),czm_lightDirectionEC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.lightDirectionEC}}),czm_lightDirectionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.lightDirectionWC}}),czm_lightColor:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.lightColor}}),czm_lightColorHdr:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.lightColorHdr}}),czm_encodedCameraPositionMCHigh:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCHigh}}),czm_encodedCameraPositionMCLow:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCLow}}),czm_viewerPositionWC:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return Matrix4.getTranslation(e.inverseView,viewerPositionWCScratch)}}),czm_frameNumber:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.frameState.frameNumber}}),czm_morphTime:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.frameState.morphTime}}),czm_sceneMode:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.frameState.mode}}),czm_pass:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.pass}}),czm_backgroundColor:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.backgroundColor}}),czm_brdfLut:new AutomaticUniform({size:1,datatype:WebGLConstants$1.SAMPLER_2D,getValue:function(e){return e.brdfLut}}),czm_environmentMap:new AutomaticUniform({size:1,datatype:WebGLConstants$1.SAMPLER_CUBE,getValue:function(e){return e.environmentMap}}),czm_specularEnvironmentMaps:new AutomaticUniform({size:1,datatype:WebGLConstants$1.SAMPLER_2D,getValue:function(e){return e.specularEnvironmentMaps}}),czm_specularEnvironmentMapSize:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC2,getValue:function(e){return e.specularEnvironmentMapsDimensions}}),czm_specularEnvironmentMapsMaximumLOD:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.specularEnvironmentMapsMaximumLOD}}),czm_sphericalHarmonicCoefficients:new AutomaticUniform({size:9,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.sphericalHarmonicCoefficients}}),czm_temeToPseudoFixed:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_MAT3,getValue:function(e){return e.temeToPseudoFixedMatrix}}),czm_pixelRatio:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.pixelRatio}}),czm_fogDensity:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.fogDensity}}),czm_imagerySplitPosition:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.imagerySplitPosition}}),czm_geometricToleranceOverMeter:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.geometricToleranceOverMeter}}),czm_minimumDisableDepthTestDistance:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.minimumDisableDepthTestDistance}}),czm_invertClassificationColor:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC4,getValue:function(e){return e.invertClassificationColor}}),czm_gamma:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT,getValue:function(e){return e.gamma}}),czm_ellipsoidRadii:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.ellipsoid.radii}}),czm_ellipsoidInverseRadii:new AutomaticUniform({size:1,datatype:WebGLConstants$1.FLOAT_VEC3,getValue:function(e){return e.ellipsoid.oneOverRadii}})};function createUniform$1(e,t,i,r){switch(t.type){case e.FLOAT:return new UniformFloat(e,t,i,r);case e.FLOAT_VEC2:return new UniformFloatVec2(e,t,i,r);case e.FLOAT_VEC3:return new UniformFloatVec3(e,t,i,r);case e.FLOAT_VEC4:return new UniformFloatVec4(e,t,i,r);case e.SAMPLER_2D:case e.SAMPLER_CUBE:return new UniformSampler(e,t,i,r);case e.INT:case e.BOOL:return new UniformInt(e,t,i,r);case e.INT_VEC2:case e.BOOL_VEC2:return new UniformIntVec2(e,t,i,r);case e.INT_VEC3:case e.BOOL_VEC3:return new UniformIntVec3(e,t,i,r);case e.INT_VEC4:case e.BOOL_VEC4:return new UniformIntVec4(e,t,i,r);case e.FLOAT_MAT2:return new UniformMat2(e,t,i,r);case e.FLOAT_MAT3:return new UniformMat3(e,t,i,r);case e.FLOAT_MAT4:return new UniformMat4(e,t,i,r);default:throw new RuntimeError("Unrecognized uniform type: "+t.type+' for uniform "'+i+'".')}}function UniformFloat(e,t,i,r){this.name=i,this.value=void 0,this._value=0,this._gl=e,this._location=r}function UniformFloatVec2(e,t,i,r){this.name=i,this.value=void 0,this._value=new Cartesian2,this._gl=e,this._location=r}function UniformFloatVec3(e,t,i,r){this.name=i,this.value=void 0,this._value=void 0,this._gl=e,this._location=r}function UniformFloatVec4(e,t,i,r){this.name=i,this.value=void 0,this._value=void 0,this._gl=e,this._location=r}function UniformSampler(e,t,i,r){this.name=i,this.value=void 0,this._gl=e,this._location=r,this.textureUnitIndex=void 0}function UniformInt(e,t,i,r){this.name=i,this.value=void 0,this._value=0,this._gl=e,this._location=r}function UniformIntVec2(e,t,i,r){this.name=i,this.value=void 0,this._value=new Cartesian2,this._gl=e,this._location=r}function UniformIntVec3(e,t,i,r){this.name=i,this.value=void 0,this._value=new Cartesian3,this._gl=e,this._location=r}function UniformIntVec4(e,t,i,r){this.name=i,this.value=void 0,this._value=new Cartesian4,this._gl=e,this._location=r}UniformFloat.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1f(this._location,this.value))},UniformFloatVec2.prototype.set=function(){var e=this.value;Cartesian2.equals(e,this._value)||(Cartesian2.clone(e,this._value),this._gl.uniform2f(this._location,e.x,e.y))},UniformFloatVec3.prototype.set=function(){var e=this.value;defined(e.red)?Color.equals(e,this._value)||(this._value=Color.clone(e,this._value),this._gl.uniform3f(this._location,e.red,e.green,e.blue)):defined(e.x)&&(Cartesian3.equals(e,this._value)||(this._value=Cartesian3.clone(e,this._value),this._gl.uniform3f(this._location,e.x,e.y,e.z)))},UniformFloatVec4.prototype.set=function(){var e=this.value;defined(e.red)?Color.equals(e,this._value)||(this._value=Color.clone(e,this._value),this._gl.uniform4f(this._location,e.red,e.green,e.blue,e.alpha)):defined(e.x)&&(Cartesian4.equals(e,this._value)||(this._value=Cartesian4.clone(e,this._value),this._gl.uniform4f(this._location,e.x,e.y,e.z,e.w)))},UniformSampler.prototype.set=function(){var e=this._gl;e.activeTexture(e.TEXTURE0+this.textureUnitIndex);var t=this.value;e.bindTexture(t._target,t._texture)},UniformSampler.prototype._setSampler=function(e){return this.textureUnitIndex=e,this._gl.uniform1i(this._location,e),e+1},UniformInt.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1i(this._location,this.value))},UniformIntVec2.prototype.set=function(){var e=this.value;Cartesian2.equals(e,this._value)||(Cartesian2.clone(e,this._value),this._gl.uniform2i(this._location,e.x,e.y))},UniformIntVec3.prototype.set=function(){var e=this.value;Cartesian3.equals(e,this._value)||(Cartesian3.clone(e,this._value),this._gl.uniform3i(this._location,e.x,e.y,e.z))},UniformIntVec4.prototype.set=function(){var e=this.value;Cartesian4.equals(e,this._value)||(Cartesian4.clone(e,this._value),this._gl.uniform4i(this._location,e.x,e.y,e.z,e.w))};var scratchUniformArray=new Float32Array(4);function UniformMat2(e,t,i,r){this.name=i,this.value=void 0,this._value=new Matrix2,this._gl=e,this._location=r}UniformMat2.prototype.set=function(){var e;Matrix2.equalsArray(this.value,this._value,0)||(Matrix2.clone(this.value,this._value),e=Matrix2.toArray(this.value,scratchUniformArray),this._gl.uniformMatrix2fv(this._location,!1,e))};var scratchMat3Array=new Float32Array(9);function UniformMat3(e,t,i,r){this.name=i,this.value=void 0,this._value=new Matrix3,this._gl=e,this._location=r}UniformMat3.prototype.set=function(){var e;Matrix3.equalsArray(this.value,this._value,0)||(Matrix3.clone(this.value,this._value),e=Matrix3.toArray(this.value,scratchMat3Array),this._gl.uniformMatrix3fv(this._location,!1,e))};var scratchMat4Array=new Float32Array(16);function UniformMat4(e,t,i,r){this.name=i,this.value=void 0,this._value=new Matrix4,this._gl=e,this._location=r}function createUniformArray(e,t,i,r){switch(t.type){case e.FLOAT:return new UniformArrayFloat(e,t,i,r);case e.FLOAT_VEC2:return new UniformArrayFloatVec2(e,t,i,r);case e.FLOAT_VEC3:return new UniformArrayFloatVec3(e,t,i,r);case e.FLOAT_VEC4:return new UniformArrayFloatVec4(e,t,i,r);case e.SAMPLER_2D:case e.SAMPLER_CUBE:return new UniformArraySampler(e,t,i,r);case e.INT:case e.BOOL:return new UniformArrayInt(e,t,i,r);case e.INT_VEC2:case e.BOOL_VEC2:return new UniformArrayIntVec2(e,t,i,r);case e.INT_VEC3:case e.BOOL_VEC3:return new UniformArrayIntVec3(e,t,i,r);case e.INT_VEC4:case e.BOOL_VEC4:return new UniformArrayIntVec4(e,t,i,r);case e.FLOAT_MAT2:return new UniformArrayMat2(e,t,i,r);case e.FLOAT_MAT3:return new UniformArrayMat3(e,t,i,r);case e.FLOAT_MAT4:return new UniformArrayMat4(e,t,i,r);default:throw new RuntimeError("Unrecognized uniform type: "+t.type+' for uniform "'+i+'".')}}function UniformArrayFloat(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(n),this._gl=e,this._location=r[0]}function UniformArrayFloatVec2(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(2*n),this._gl=e,this._location=r[0]}function UniformArrayFloatVec3(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(3*n),this._gl=e,this._location=r[0]}function UniformArrayFloatVec4(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(4*n),this._gl=e,this._location=r[0]}function UniformArraySampler(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(n),this._gl=e,this._locations=r,this.textureUnitIndex=void 0}function UniformArrayInt(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Int32Array(n),this._gl=e,this._location=r[0]}function UniformArrayIntVec2(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Int32Array(2*n),this._gl=e,this._location=r[0]}function UniformArrayIntVec3(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Int32Array(3*n),this._gl=e,this._location=r[0]}function UniformArrayIntVec4(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Int32Array(4*n),this._gl=e,this._location=r[0]}function UniformArrayMat2(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(4*n),this._gl=e,this._location=r[0]}function UniformArrayMat3(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(9*n),this._gl=e,this._location=r[0]}function UniformArrayMat4(e,t,i,r){var n=r.length;this.name=i,this.value=new Array(n),this._value=new Float32Array(16*n),this._gl=e,this._location=r[0]}UniformMat4.prototype.set=function(){var e;Matrix4.equalsArray(this.value,this._value,0)||(Matrix4.clone(this.value,this._value),e=Matrix4.toArray(this.value,scratchMat4Array),this._gl.uniformMatrix4fv(this._location,!1,e))},UniformArrayFloat.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0;n<t;++n){var a=e[n];a!==i[n]&&(i[n]=a,r=!0)}r&&this._gl.uniform1fv(this._location,i)},UniformArrayFloatVec2.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Cartesian2.equalsArray(o,i,n)||(Cartesian2.pack(o,i,n),r=!0),n+=2}r&&this._gl.uniform2fv(this._location,i)},UniformArrayFloatVec3.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];defined(o.red)?o.red===i[n]&&o.green===i[n+1]&&o.blue===i[n+2]||(i[n]=o.red,i[n+1]=o.green,i[n+2]=o.blue,r=!0):defined(o.x)&&(Cartesian3.equalsArray(o,i,n)||(Cartesian3.pack(o,i,n),r=!0)),n+=3}r&&this._gl.uniform3fv(this._location,i)},UniformArrayFloatVec4.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];defined(o.red)?Color.equalsArray(o,i,n)||(Color.pack(o,i,n),r=!0):defined(o.x)&&(Cartesian4.equalsArray(o,i,n)||(Cartesian4.pack(o,i,n),r=!0)),n+=4}r&&this._gl.uniform4fv(this._location,i)},UniformArraySampler.prototype.set=function(){for(var e=this._gl,t=e.TEXTURE0+this.textureUnitIndex,i=this.value,r=i.length,n=0;n<r;++n){var a=i[n];e.activeTexture(t+n),e.bindTexture(a._target,a._texture)}},UniformArraySampler.prototype._setSampler=function(e){this.textureUnitIndex=e;for(var t=this._locations,i=t.length,r=0;r<i;++r){var n=e+r;this._gl.uniform1i(t[r],n)}return e+i},UniformArrayInt.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0;n<t;++n){var a=e[n];a!==i[n]&&(i[n]=a,r=!0)}r&&this._gl.uniform1iv(this._location,i)},UniformArrayIntVec2.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Cartesian2.equalsArray(o,i,n)||(Cartesian2.pack(o,i,n),r=!0),n+=2}r&&this._gl.uniform2iv(this._location,i)},UniformArrayIntVec3.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Cartesian3.equalsArray(o,i,n)||(Cartesian3.pack(o,i,n),r=!0),n+=3}r&&this._gl.uniform3iv(this._location,i)},UniformArrayIntVec4.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Cartesian4.equalsArray(o,i,n)||(Cartesian4.pack(o,i,n),r=!0),n+=4}r&&this._gl.uniform4iv(this._location,i)},UniformArrayMat2.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Matrix2.equalsArray(o,i,n)||(Matrix2.pack(o,i,n),r=!0),n+=4}r&&this._gl.uniformMatrix2fv(this._location,!1,i)},UniformArrayMat3.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Matrix3.equalsArray(o,i,n)||(Matrix3.pack(o,i,n),r=!0),n+=9}r&&this._gl.uniformMatrix3fv(this._location,!1,i)},UniformArrayMat4.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,r=!1,n=0,a=0;a<t;++a){var o=e[a];Matrix4.equalsArray(o,i,n)||(Matrix4.pack(o,i,n),r=!0),n+=16}r&&this._gl.uniformMatrix4fv(this._location,!1,i)};var nextShaderProgramId=0;function ShaderProgram(e){var t=e.vertexShaderText,i=e.fragmentShaderText;"undefined"!=typeof spector&&(t=t.replace(/^#line/gm,"//#line"),i=i.replace(/^#line/gm,"//#line"));i=handleUniformPrecisionMismatches(t,i);this._gl=e.gl,this._logShaderCompilation=e.logShaderCompilation,this._debugShaders=e.debugShaders,this._attributeLocations=e.attributeLocations,this._program=void 0,this._numberOfVertexAttributes=void 0,this._vertexAttributes=void 0,this._uniformsByName=void 0,this._uniforms=void 0,this._automaticUniforms=void 0,this._manualUniforms=void 0,this._duplicateUniformNames=i.duplicateUniformNames,this._cachedShader=void 0,this.maximumTextureUnitIndex=void 0,this._vertexShaderSource=e.vertexShaderSource,this._vertexShaderText=e.vertexShaderText,this._fragmentShaderSource=e.fragmentShaderSource,this._fragmentShaderText=i.fragmentShaderText,this.id=nextShaderProgramId++}function extractUniforms(e){var t=[],i=e.match(/uniform.*?(?![^{]*})(?=[=\[;])/g);if(defined(i))for(var r=i.length,n=0;n<r;n++){var a=i[n].trim(),a=a.slice(a.lastIndexOf(" ")+1);t.push(a)}return t}function handleUniformPrecisionMismatches(e,t){var i={};if(!ContextLimits.highpFloatSupported||!ContextLimits.highpIntSupported)for(var r,n,a,o,s=extractUniforms(e),l=extractUniforms(t),c=s.length,u=l.length,d=0;d<c;d++)for(r=0;r<u;r++)s[d]===l[r]&&(a="czm_mediump_"+(n=s[d]),o=new RegExp(n+"\\b","g"),t=t.replace(o,a),i[a]=n);return{fragmentShaderText:t,duplicateUniformNames:i}}ShaderProgram.fromCache=function(e){return(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context.shaderCache.getShaderProgram(e)},ShaderProgram.replaceCache=function(e){return(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context.shaderCache.replaceShaderProgram(e)},Object.defineProperties(ShaderProgram.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},vertexAttributes:{get:function(){return initialize$1(this),this._vertexAttributes}},numberOfVertexAttributes:{get:function(){return initialize$1(this),this._numberOfVertexAttributes}},allUniforms:{get:function(){return initialize$1(this),this._uniformsByName}}});var consolePrefix="[Cesium WebGL] ";function createAndLinkProgram(e,t){var i=t._vertexShaderText,r=t._fragmentShaderText,n=e.createShader(e.VERTEX_SHADER);e.shaderSource(n,i),e.compileShader(n);i=e.createShader(e.FRAGMENT_SHADER);e.shaderSource(i,r),e.compileShader(i);var a=e.createProgram();e.attachShader(a,n),e.attachShader(a,i),e.deleteShader(n),e.deleteShader(i);var o=t._attributeLocations;if(defined(o))for(var s in o)o.hasOwnProperty(s)&&e.bindAttribLocation(a,o[s],s);if(e.linkProgram(a),!e.getProgramParameter(a,e.LINK_STATUS)){r=t._debugShaders;if(!e.getShaderParameter(i,e.COMPILE_STATUS)){var l,c=e.getShaderInfoLog(i);throw console.error(consolePrefix+"Fragment shader compile log: "+c),defined(r)&&(""!==(l=r.getTranslatedShaderSource(i))?console.error(consolePrefix+"Translated fragment shader source:\n"+l):console.error(consolePrefix+"Fragment shader translation failed.")),e.deleteProgram(a),new RuntimeError("Fragment shader failed to compile.  Compile log: "+c)}if(!e.getShaderParameter(n,e.COMPILE_STATUS))throw c=e.getShaderInfoLog(n),console.error(consolePrefix+"Vertex shader compile log: "+c),defined(r)&&(""!==(l=r.getTranslatedShaderSource(n))?console.error(consolePrefix+"Translated vertex shader source:\n"+l):console.error(consolePrefix+"Vertex shader translation failed.")),e.deleteProgram(a),new RuntimeError("Vertex shader failed to compile.  Compile log: "+c);throw c=e.getProgramInfoLog(a),console.error(consolePrefix+"Shader program link log: "+c),defined(r)&&(console.error(consolePrefix+"Translated vertex shader source:\n"+r.getTranslatedShaderSource(n)),console.error(consolePrefix+"Translated fragment shader source:\n"+r.getTranslatedShaderSource(i))),e.deleteProgram(a),new RuntimeError("Program failed to link.  Link log: "+c)}t=t._logShaderCompilation;return t&&defined(c=e.getShaderInfoLog(n))&&0<c.length&&console.log(consolePrefix+"Vertex shader compile log: "+c),t&&defined(c=e.getShaderInfoLog(i))&&0<c.length&&console.log(consolePrefix+"Fragment shader compile log: "+c),t&&defined(c=e.getProgramInfoLog(a))&&0<c.length&&console.log(consolePrefix+"Shader program link log: "+c),a}function findVertexAttributes(e,t,i){for(var r={},n=0;n<i;++n){var a=e.getActiveAttrib(t,n),o=e.getAttribLocation(t,a.name);r[a.name]={name:a.name,type:a.type,index:o}}return r}function findUniforms(e,t){for(var i={},r=[],n=[],a=e.getProgramParameter(t,e.ACTIVE_UNIFORMS),o=0;o<a;++o){var s=e.getActiveUniform(t,o),l=-1!==s.name.indexOf("[0]",s.name.length-"[0]".length)?s.name.slice(0,s.name.length-3):s.name;if(0!==l.indexOf("gl_"))if(s.name.indexOf("[")<0){var c=e.getUniformLocation(t,l);null!==c&&(p=createUniform$1(e,s,l,c),i[l]=p,r.push(p),p._setSampler&&n.push(p))}else{var u,d,h,p=l.indexOf("[");if(0<=p)defined(u=i[l.slice(0,p)])&&(d=u._locations).length<=1&&(p=u.value,null!==(h=e.getUniformLocation(t,l))&&(d.push(h),p.push(e.getUniform(t,h))));else{d=[];for(var m=0;m<s.size;++m)null!==(h=e.getUniformLocation(t,l+"["+m+"]"))&&d.push(h);u=createUniformArray(e,s,l,d),i[l]=u,r.push(u),u._setSampler&&n.push(u)}}}return{uniformsByName:i,uniforms:r,samplerUniforms:n}}function partitionUniforms(e,t){var i,r,n,a,o=[],s=[];for(i in t)t.hasOwnProperty(i)&&(r=t[i],a=i,defined(n=e._duplicateUniformNames[a])&&(a=r.name=n),defined(a=AutomaticUniforms[a])?o.push({uniform:r,automaticUniform:a}):s.push(r));return{automaticUniforms:o,manualUniforms:s}}function setSamplerUniforms(e,t,i){e.useProgram(t);for(var r=0,n=i.length,a=0;a<n;++a)r=i[a]._setSampler(r);return e.useProgram(null),r}function initialize$1(e){defined(e._program)||reinitialize(e)}function reinitialize(s){var e=s._program,t=s._gl,i=createAndLinkProgram(t,s,s._debugShaders),r=t.getProgramParameter(i,t.ACTIVE_ATTRIBUTES),n=findUniforms(t,i),a=partitionUniforms(s,n.uniformsByName);s._program=i,s._numberOfVertexAttributes=r,s._vertexAttributes=findVertexAttributes(t,i,r),s._uniformsByName=n.uniformsByName,s._uniforms=n.uniforms,s._automaticUniforms=a.automaticUniforms,s._manualUniforms=a.manualUniforms,s.maximumTextureUnitIndex=setSamplerUniforms(t,i,n.samplerUniforms),e&&s._gl.deleteProgram(e),"undefined"!=typeof spector&&(s._program.__SPECTOR_rebuildProgram=function(e,t,i,r){var n=s._vertexShaderText,a=s._fragmentShaderText,o=/ ! = /g;s._vertexShaderText=e.replace(o," != "),s._fragmentShaderText=t.replace(o," != ");try{reinitialize(s),i(s._program)}catch(e){s._vertexShaderText=n,s._fragmentShaderText=a;a=/(?:Compile|Link) error: ([^]*)/.exec(e.message);r(a?a[1]:e.message)}})}function modernizeShader(e,t){var i=/#define OUTPUT_DECLARATION/,r=e.split("\n");if(/#version 300 es/g.test(e))return e;for(var n,a=-1,o=0;o<r.length;++o)if(n=r[o],i.test(n)){a=o;break}if(-1===a)throw new DeveloperError("Could not find a #define OUTPUT_DECLARATION!");var s=[];for(o=0;o<10;o++){var l="gl_FragData\\["+o+"\\]",c="czm_out"+o;new RegExp(l,"g").test(e)&&(setAdd(c,s),replaceInSourceString(l,c,r),r.splice(a,0,"layout(location = "+o+") out vec4 "+c+";"),a+=1)}var u="czm_fragColor";findInSource("gl_FragColor",r)&&(setAdd(u,s),replaceInSourceString("gl_FragColor",u,r),r.splice(a,0,"layout(location = 0) out vec4 czm_fragColor;"),a+=1);var d,h=getVariablePreprocessorBranch(s,r),p={};for(o=0;o<r.length;o++)for(var m in n=r[o],h)h.hasOwnProperty(m)&&new RegExp("(layout)[^]+(out)[^]+("+m+")[^]+","g").test(n)&&(p[n]=m);for(d in p)if(p.hasOwnProperty(d)){for(var f=p[d],g=r.indexOf(d),_=h[f],y=_.length,C=0;C<y;C++)r.splice(g,0,_[C]);for(g+=y+1,C=y-1;0<=C;C--)r.splice(g,0,"#endif //"+_[C])}var u="WEBGL_2",v="#version 300 es",S=!1;for(o=0;o<r.length;o++)if(/#version/.test(r[o])){r[o]=v,S=!0;break}return S||r.splice(0,0,v),r.splice(1,0,"#define WEBGL_2"),removeExtension("EXT_draw_buffers",u,r),removeExtension("EXT_frag_depth",u,r),removeExtension("OES_standard_derivatives",u,r),replaceInSourceString("texture2D","texture",r),replaceInSourceString("texture3D","texture",r),replaceInSourceString("textureCube","texture",r),replaceInSourceString("gl_FragDepthEXT","gl_FragDepth",r),t?replaceInSourceString("varying","in",r):(replaceInSourceString("attribute","in",r),replaceInSourceString("varying","out",r)),compileSource(r)}function replaceInSourceString(e,t,i){for(var r=new RegExp("(^|[^\\w])("+e+")($|[^\\w])","g"),n=i.length,a=0;a<n;++a){var o=i[a];i[a]=o.replace(r,"$1"+t+"$3")}}function replaceInSourceRegex(e,t,i){for(var r=i.length,n=0;n<r;++n){var a=i[n];i[n]=a.replace(e,t)}}function findInSource(e,t){for(var i=new RegExp("(^|[^\\w])("+e+")($|[^\\w])","g"),r=t.length,n=0;n<r;++n){var a=t[n];if(i.test(a))return 1}}function compileSource(e){for(var t="",i=e.length,r=0;r<i;++r)t+=e[r]+"\n";return t}function setAdd(e,t){-1===t.indexOf(e)&&t.push(e)}function getVariablePreprocessorBranch(e,t){for(var i={},r=e.length,n=[],a=0;a<t.length;++a){var o=t[a],s=/(#ifdef|#if)/g.test(o),l=/#else/g.test(o),c=/#endif/g.test(o);if(s)n.push(o);else if(l){l=n[n.length-1].replace("ifdef","ifndef");/if/g.test(l)&&(l=l.replace(/(#if\s+)(\S*)([^]*)/,"$1!($2)$3")),n.pop(),n.push(l)}else if(c)n.pop();else if(!/layout/g.test(o))for(var u=0;u<r;++u){var d=e[u];-1!==o.indexOf(d)&&(defined(i[d])?i[d]=i[d].filter(function(e){return 0<=n.indexOf(e)}):i[d]=n.slice())}}return i}function removeExtension(e,t,i){replaceInSourceRegex(new RegExp("#extension\\s+GL_"+e+"\\s+:\\s+[a-zA-Z0-9]+\\s*$","g"),"",i),replaceInSourceString("GL_"+e,t,i)}ShaderProgram.prototype._bind=function(){initialize$1(this),this._gl.useProgram(this._program)},ShaderProgram.prototype._setUniforms=function(e,t,i){if(defined(e))for(var r=this._manualUniforms,n=r.length,a=0;a<n;++a){var o=r[a];o.value=e[o.name]()}var s=this._automaticUniforms;for(n=s.length,a=0;a<n;++a){var l=s[a];l.uniform.value=l.automaticUniform.getValue(t)}var c,u=this._uniforms;for(n=u.length,a=0;a<n;++a)u[a].set();i&&(c=this._gl,i=this._program,c.validateProgram(i))},ShaderProgram.prototype.isDestroyed=function(){return!1},ShaderProgram.prototype.destroy=function(){this._cachedShader.cache.releaseShaderProgram(this)},ShaderProgram.prototype.finalDestroy=function(){return this._gl.deleteProgram(this._program),destroyObject(this)};var czm_degreesPerRadian="const float czm_degreesPerRadian = 57.29577951308232;\n",czm_depthRange="const czm_depthRangeStruct czm_depthRange = czm_depthRangeStruct(0.0, 1.0);\n",czm_epsilon1="const float czm_epsilon1 = 0.1;\n",czm_epsilon2="const float czm_epsilon2 = 0.01;\n",czm_epsilon3="const float czm_epsilon3 = 0.001;\n",czm_epsilon4="const float czm_epsilon4 = 0.0001;\n",czm_epsilon5="const float czm_epsilon5 = 0.00001;\n",czm_epsilon6="const float czm_epsilon6 = 0.000001;\n",czm_epsilon7="const float czm_epsilon7 = 0.0000001;\n",czm_infinity="const float czm_infinity = 5906376272000.0;\n",czm_oneOverPi="const float czm_oneOverPi = 0.3183098861837907;\n",czm_oneOverTwoPi="const float czm_oneOverTwoPi = 0.15915494309189535;\n",czm_passCesium3DTile="const float czm_passCesium3DTile = 4.0;\n",czm_passCesium3DTileClassification="const float czm_passCesium3DTileClassification = 5.0;\n",czm_passCesium3DTileClassificationIgnoreShow="const float czm_passCesium3DTileClassificationIgnoreShow = 6.0;\n",czm_passClassification="const float czm_passClassification = 7.0;\n",czm_passCompute="const float czm_passCompute = 1.0;\n",czm_passEnvironment="const float czm_passEnvironment = 0.0;\n",czm_passGlobe="const float czm_passGlobe = 2.0;\n",czm_passOpaque="const float czm_passOpaque = 7.0;\n",czm_passOverlay="const float czm_passOverlay = 9.0;\n",czm_passTerrainClassification="const float czm_passTerrainClassification = 3.0;\n",czm_passTranslucent="const float czm_passTranslucent = 8.0;\n",czm_pi="const float czm_pi = 3.141592653589793;\n",czm_piOverFour="const float czm_piOverFour = 0.7853981633974483;\n",czm_piOverSix="const float czm_piOverSix = 0.5235987755982988;\n",czm_piOverThree="const float czm_piOverThree = 1.0471975511965976;\n",czm_piOverTwo="const float czm_piOverTwo = 1.5707963267948966;\n",czm_radiansPerDegree="const float czm_radiansPerDegree = 0.017453292519943295;\n",czm_sceneMode2D="const float czm_sceneMode2D = 2.0;\n",czm_sceneMode3D="const float czm_sceneMode3D = 3.0;\n",czm_sceneModeColumbusView="const float czm_sceneModeColumbusView = 1.0;\n",czm_sceneModeMorphing="const float czm_sceneModeMorphing = 0.0;\n",czm_solarRadius="const float czm_solarRadius = 695500000.0;\n",czm_threePiOver2="const float czm_threePiOver2 = 4.71238898038469;\n",czm_twoPi="const float czm_twoPi = 6.283185307179586;\n",czm_webMercatorMaxLatitude="const float czm_webMercatorMaxLatitude = 1.4844222297453324;\n",czm_depthRangeStruct="struct czm_depthRangeStruct\n{\nfloat near;\nfloat far;\n};\n",czm_material="struct czm_material\n{\nvec3 diffuse;\nfloat specular;\nfloat shininess;\nvec3 normal;\nvec3 emission;\nfloat alpha;\n};\n",czm_materialInput="struct czm_materialInput\n{\nfloat s;\nvec2 st;\nvec3 str;\nvec3 normalEC;\nmat3 tangentToEyeMatrix;\nvec3 positionToEyeEC;\nfloat height;\nfloat slope;\nfloat aspect;\n};\n",czm_ray="struct czm_ray\n{\nvec3 origin;\nvec3 direction;\n};\n",czm_raySegment="struct czm_raySegment\n{\nfloat start;\nfloat stop;\n};\nconst czm_raySegment czm_emptyRaySegment = czm_raySegment(-czm_infinity, -czm_infinity);\nconst czm_raySegment czm_fullRaySegment = czm_raySegment(0.0, czm_infinity);\n",czm_shadowParameters="struct czm_shadowParameters\n{\n#ifdef USE_CUBE_MAP_SHADOW\nvec3 texCoords;\n#else\nvec2 texCoords;\n#endif\nfloat depthBias;\nfloat depth;\nfloat nDotL;\nvec2 texelStepSize;\nfloat normalShadingSmooth;\nfloat darkness;\n};\n",czm_HSBToRGB="const vec4 K_HSB2RGB = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 czm_HSBToRGB(vec3 hsb)\n{\nvec3 p = abs(fract(hsb.xxx + K_HSB2RGB.xyz) * 6.0 - K_HSB2RGB.www);\nreturn hsb.z * mix(K_HSB2RGB.xxx, clamp(p - K_HSB2RGB.xxx, 0.0, 1.0), hsb.y);\n}\n",czm_HSLToRGB="vec3 hueToRGB(float hue)\n{\nfloat r = abs(hue * 6.0 - 3.0) - 1.0;\nfloat g = 2.0 - abs(hue * 6.0 - 2.0);\nfloat b = 2.0 - abs(hue * 6.0 - 4.0);\nreturn clamp(vec3(r, g, b), 0.0, 1.0);\n}\nvec3 czm_HSLToRGB(vec3 hsl)\n{\nvec3 rgb = hueToRGB(hsl.x);\nfloat c = (1.0 - abs(2.0 * hsl.z - 1.0)) * hsl.y;\nreturn (rgb - 0.5) * c + hsl.z;\n}\n",czm_RGBToHSB="const vec4 K_RGB2HSB = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec3 czm_RGBToHSB(vec3 rgb)\n{\nvec4 p = mix(vec4(rgb.bg, K_RGB2HSB.wz), vec4(rgb.gb, K_RGB2HSB.xy), step(rgb.b, rgb.g));\nvec4 q = mix(vec4(p.xyw, rgb.r), vec4(rgb.r, p.yzx), step(p.x, rgb.r));\nfloat d = q.x - min(q.w, q.y);\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + czm_epsilon7)), d / (q.x + czm_epsilon7), q.x);\n}\n",czm_RGBToHSL="vec3 RGBtoHCV(vec3 rgb)\n{\nvec4 p = (rgb.g < rgb.b) ? vec4(rgb.bg, -1.0, 2.0 / 3.0) : vec4(rgb.gb, 0.0, -1.0 / 3.0);\nvec4 q = (rgb.r < p.x) ? vec4(p.xyw, rgb.r) : vec4(rgb.r, p.yzx);\nfloat c = q.x - min(q.w, q.y);\nfloat h = abs((q.w - q.y) / (6.0 * c + czm_epsilon7) + q.z);\nreturn vec3(h, c, q.x);\n}\nvec3 czm_RGBToHSL(vec3 rgb)\n{\nvec3 hcv = RGBtoHCV(rgb);\nfloat l = hcv.z - hcv.y * 0.5;\nfloat s = hcv.y / (1.0 - abs(l * 2.0 - 1.0) + czm_epsilon7);\nreturn vec3(hcv.x, s, l);\n}\n",czm_RGBToXYZ="vec3 czm_RGBToXYZ(vec3 rgb)\n{\nconst mat3 RGB2XYZ = mat3(0.4124, 0.2126, 0.0193,\n0.3576, 0.7152, 0.1192,\n0.1805, 0.0722, 0.9505);\nvec3 xyz = RGB2XYZ * rgb;\nvec3 Yxy;\nYxy.r = xyz.g;\nfloat temp = dot(vec3(1.0), xyz);\nYxy.gb = xyz.rg / temp;\nreturn Yxy;\n}\n",czm_XYZToRGB="vec3 czm_XYZToRGB(vec3 Yxy)\n{\nconst mat3 XYZ2RGB = mat3( 3.2405, -0.9693,  0.0556,\n-1.5371,  1.8760, -0.2040,\n-0.4985,  0.0416,  1.0572);\nvec3 xyz;\nxyz.r = Yxy.r * Yxy.g / Yxy.b;\nxyz.g = Yxy.r;\nxyz.b = Yxy.r * (1.0 - Yxy.g - Yxy.b) / Yxy.b;\nreturn XYZ2RGB * xyz;\n}\n",czm_acesTonemapping="vec3 czm_acesTonemapping(vec3 color) {\nfloat g = 0.985;\nfloat a = 0.065;\nfloat b = 0.0001;\nfloat c = 0.433;\nfloat d = 0.238;\ncolor = (color * (color + a) - b) / (color * (g * color + c) + d);\ncolor = clamp(color, 0.0, 1.0);\nreturn color;\n}\n",czm_alphaWeight="float czm_alphaWeight(float a)\n{\nfloat z = (gl_FragCoord.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];\nreturn pow(a + 0.01, 4.0) + max(1e-2, min(3.0 * 1e3, 0.003 / (1e-5 + pow(abs(z) / 200.0, 4.0))));\n}\n",czm_antialias="vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist, float fuzzFactor)\n{\nfloat val1 = clamp(dist / fuzzFactor, 0.0, 1.0);\nfloat val2 = clamp((dist - 0.5) / fuzzFactor, 0.0, 1.0);\nval1 = val1 * (1.0 - val2);\nval1 = val1 * val1 * (3.0 - (2.0 * val1));\nval1 = pow(val1, 0.5);\nvec4 midColor = (color1 + color2) * 0.5;\nreturn mix(midColor, currentColor, val1);\n}\nvec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist)\n{\nreturn czm_antialias(color1, color2, currentColor, dist, 0.1);\n}\n",czm_approximateSphericalCoordinates="vec2 czm_approximateSphericalCoordinates(vec3 normal) {\nfloat latitudeApproximation = czm_fastApproximateAtan(sqrt(normal.x * normal.x + normal.y * normal.y), normal.z);\nfloat longitudeApproximation = czm_fastApproximateAtan(normal.x, normal.y);\nreturn vec2(latitudeApproximation, longitudeApproximation);\n}\n",czm_backFacing="bool czm_backFacing()\n{\nreturn gl_FrontFacing == false;\n}\n",czm_branchFreeTernary="float czm_branchFreeTernary(bool comparison, float a, float b) {\nfloat useA = float(comparison);\nreturn a * useA + b * (1.0 - useA);\n}\nvec2 czm_branchFreeTernary(bool comparison, vec2 a, vec2 b) {\nfloat useA = float(comparison);\nreturn a * useA + b * (1.0 - useA);\n}\nvec3 czm_branchFreeTernary(bool comparison, vec3 a, vec3 b) {\nfloat useA = float(comparison);\nreturn a * useA + b * (1.0 - useA);\n}\nvec4 czm_branchFreeTernary(bool comparison, vec4 a, vec4 b) {\nfloat useA = float(comparison);\nreturn a * useA + b * (1.0 - useA);\n}\n",czm_cascadeColor="vec4 czm_cascadeColor(vec4 weights)\n{\nreturn vec4(1.0, 0.0, 0.0, 1.0) * weights.x +\nvec4(0.0, 1.0, 0.0, 1.0) * weights.y +\nvec4(0.0, 0.0, 1.0, 1.0) * weights.z +\nvec4(1.0, 0.0, 1.0, 1.0) * weights.w;\n}\n",czm_cascadeDistance="uniform vec4 shadowMap_cascadeDistances;\nfloat czm_cascadeDistance(vec4 weights)\n{\nreturn dot(shadowMap_cascadeDistances, weights);\n}\n",czm_cascadeMatrix="uniform mat4 shadowMap_cascadeMatrices[4];\nmat4 czm_cascadeMatrix(vec4 weights)\n{\nreturn shadowMap_cascadeMatrices[0] * weights.x +\nshadowMap_cascadeMatrices[1] * weights.y +\nshadowMap_cascadeMatrices[2] * weights.z +\nshadowMap_cascadeMatrices[3] * weights.w;\n}\n",czm_cascadeWeights="uniform vec4 shadowMap_cascadeSplits[2];\nvec4 czm_cascadeWeights(float depthEye)\n{\nvec4 near = step(shadowMap_cascadeSplits[0], vec4(depthEye));\nvec4 far = step(depthEye, shadowMap_cascadeSplits[1]);\nreturn near * far;\n}\n",czm_columbusViewMorph="vec4 czm_columbusViewMorph(vec4 position2D, vec4 position3D, float time)\n{\nvec3 p = mix(position2D.xyz, position3D.xyz, time);\nreturn vec4(p, 1.0);\n}\n",czm_computePosition="vec4 czm_computePosition();\n",czm_cosineAndSine="vec2 cordic(float angle)\n{\nvec2 vector = vec2(6.0725293500888267e-1, 0.0);\nfloat sense = (angle < 0.0) ? -1.0 : 1.0;\nmat2 rotation = mat2(1.0, sense, -sense, 1.0);\nvector = rotation * vector;\nangle -= sense * 7.8539816339744828e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfloat factor = sense * 5.0e-1;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 4.6364760900080609e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 2.5e-1;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 2.4497866312686414e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.25e-1;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.2435499454676144e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 6.25e-2;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 6.2418809995957350e-2;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.125e-2;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.1239833430268277e-2;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.5625e-2;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.5623728620476831e-2;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 7.8125e-3;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 7.8123410601011111e-3;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.90625e-3;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.9062301319669718e-3;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.953125e-3;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.9531225164788188e-3;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 9.765625e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 9.7656218955931946e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 4.8828125e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 4.8828121119489829e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 2.44140625e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 2.4414062014936177e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.220703125e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.2207031189367021e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 6.103515625e-5;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 6.1035156174208773e-5;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.0517578125e-5;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.0517578115526096e-5;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.52587890625e-5;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.5258789061315762e-5;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 7.62939453125e-6;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 7.6293945311019700e-6;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.814697265625e-6;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.8146972656064961e-6;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.9073486328125e-6;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.9073486328101870e-6;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 9.5367431640625e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 9.5367431640596084e-7;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 4.76837158203125e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 4.7683715820308884e-7;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 2.384185791015625e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 2.3841857910155797e-7;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.1920928955078125e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nreturn vector;\n}\nvec2 czm_cosineAndSine(float angle)\n{\nif (angle < -czm_piOverTwo || angle > czm_piOverTwo)\n{\nif (angle < 0.0)\n{\nreturn -cordic(angle + czm_pi);\n}\nelse\n{\nreturn -cordic(angle - czm_pi);\n}\n}\nelse\n{\nreturn cordic(angle);\n}\n}\n",czm_decompressTextureCoordinates="vec2 czm_decompressTextureCoordinates(float encoded)\n{\nfloat temp = encoded / 4096.0;\nfloat xZeroTo4095 = floor(temp);\nfloat stx = xZeroTo4095 / 4095.0;\nfloat sty = (encoded - xZeroTo4095 * 4096.0) / 4095.0;\nreturn vec2(stx, sty);\n}\n",czm_depthClamp="#if defined(GL_EXT_frag_depth) && !defined(LOG_DEPTH)\nvarying float v_WindowZ;\n#endif\nvec4 czm_depthClamp(vec4 coords)\n{\n#ifndef LOG_DEPTH\n#ifdef GL_EXT_frag_depth\nv_WindowZ = (0.5 * (coords.z / coords.w) + 0.5) * coords.w;\ncoords.z = 0.0;\n#else\ncoords.z = min(coords.z, coords.w);\n#endif\n#endif\nreturn coords;\n}\n",czm_eastNorthUpToEyeCoordinates="mat3 czm_eastNorthUpToEyeCoordinates(vec3 positionMC, vec3 normalEC)\n{\nvec3 tangentMC = normalize(vec3(-positionMC.y, positionMC.x, 0.0));\nvec3 tangentEC = normalize(czm_normal3D * tangentMC);\nvec3 bitangentEC = normalize(cross(normalEC, tangentEC));\nreturn mat3(\ntangentEC.x,   tangentEC.y,   tangentEC.z,\nbitangentEC.x, bitangentEC.y, bitangentEC.z,\nnormalEC.x,    normalEC.y,    normalEC.z);\n}\n",czm_ellipsoidContainsPoint="bool czm_ellipsoidContainsPoint(vec3 ellipsoid_inverseRadii, vec3 point)\n{\nvec3 scaled = ellipsoid_inverseRadii * (czm_inverseModelView * vec4(point, 1.0)).xyz;\nreturn (dot(scaled, scaled) <= 1.0);\n}\n",czm_ellipsoidWgs84TextureCoordinates="vec2 czm_ellipsoidWgs84TextureCoordinates(vec3 normal)\n{\nreturn vec2(atan(normal.y, normal.x) * czm_oneOverTwoPi + 0.5, asin(normal.z) * czm_oneOverPi + 0.5);\n}\n",czm_equalsEpsilon="bool czm_equalsEpsilon(vec4 left, vec4 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec4(epsilon)));\n}\nbool czm_equalsEpsilon(vec3 left, vec3 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec3(epsilon)));\n}\nbool czm_equalsEpsilon(vec2 left, vec2 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec2(epsilon)));\n}\nbool czm_equalsEpsilon(float left, float right, float epsilon) {\nreturn (abs(left - right) <= epsilon);\n}\n",czm_eyeOffset="vec4 czm_eyeOffset(vec4 positionEC, vec3 eyeOffset)\n{\nvec4 p = positionEC;\nvec4 zEyeOffset = normalize(p) * eyeOffset.z;\np.xy += eyeOffset.xy + zEyeOffset.xy;\np.z += zEyeOffset.z;\nreturn p;\n}\n",czm_eyeToWindowCoordinates="vec4 czm_eyeToWindowCoordinates(vec4 positionEC)\n{\nvec4 q = czm_projection * positionEC;\nq.xyz /= q.w;\nq.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz;\nreturn q;\n}\n",czm_fastApproximateAtan="float czm_fastApproximateAtan(float x) {\nreturn x * (-0.1784 * x - 0.0663 * x * x + 1.0301);\n}\nfloat czm_fastApproximateAtan(float x, float y) {\nfloat t = abs(x);\nfloat opposite = abs(y);\nfloat adjacent = max(t, opposite);\nopposite = min(t, opposite);\nt = czm_fastApproximateAtan(opposite / adjacent);\nt = czm_branchFreeTernary(abs(y) > abs(x), czm_piOverTwo - t, t);\nt = czm_branchFreeTernary(x < 0.0, czm_pi - t, t);\nt = czm_branchFreeTernary(y < 0.0, -t, t);\nreturn t;\n}\n",czm_fog="vec3 czm_fog(float distanceToCamera, vec3 color, vec3 fogColor)\n{\nfloat scalar = distanceToCamera * czm_fogDensity;\nfloat fog = 1.0 - exp(-(scalar * scalar));\nreturn mix(color, fogColor, fog);\n}\nvec3 czm_fog(float distanceToCamera, vec3 color, vec3 fogColor, float fogModifierConstant)\n{\nfloat scalar = distanceToCamera * czm_fogDensity;\nfloat fog = 1.0 - exp(-((fogModifierConstant * scalar + fogModifierConstant) * (scalar * (1.0 + fogModifierConstant))));\nreturn mix(color, fogColor, fog);\n}\n",czm_gammaCorrect="vec3 czm_gammaCorrect(vec3 color) {\n#ifdef HDR\ncolor = pow(color, vec3(czm_gamma));\n#endif\nreturn color;\n}\nvec4 czm_gammaCorrect(vec4 color) {\n#ifdef HDR\ncolor.rgb = pow(color.rgb, vec3(czm_gamma));\n#endif\nreturn color;\n}\n",czm_geodeticSurfaceNormal="vec3 czm_geodeticSurfaceNormal(vec3 positionOnEllipsoid, vec3 ellipsoidCenter, vec3 oneOverEllipsoidRadiiSquared)\n{\nreturn normalize((positionOnEllipsoid - ellipsoidCenter) * oneOverEllipsoidRadiiSquared);\n}\n",czm_getDefaultMaterial="czm_material czm_getDefaultMaterial(czm_materialInput materialInput)\n{\nczm_material material;\nmaterial.diffuse = vec3(0.0);\nmaterial.specular = 0.0;\nmaterial.shininess = 1.0;\nmaterial.normal = materialInput.normalEC;\nmaterial.emission = vec3(0.0);\nmaterial.alpha = 1.0;\nreturn material;\n}\n",czm_getLambertDiffuse="float czm_getLambertDiffuse(vec3 lightDirectionEC, vec3 normalEC)\n{\nreturn max(dot(lightDirectionEC, normalEC), 0.0);\n}\n",czm_getSpecular="float czm_getSpecular(vec3 lightDirectionEC, vec3 toEyeEC, vec3 normalEC, float shininess)\n{\nvec3 toReflectedLight = reflect(-lightDirectionEC, normalEC);\nfloat specular = max(dot(toReflectedLight, toEyeEC), 0.0);\nreturn pow(specular, max(shininess, czm_epsilon2));\n}\n",czm_getWaterNoise="vec4 czm_getWaterNoise(sampler2D normalMap, vec2 uv, float time, float angleInRadians)\n{\nfloat cosAngle = cos(angleInRadians);\nfloat sinAngle = sin(angleInRadians);\nvec2 s0 = vec2(1.0/17.0, 0.0);\nvec2 s1 = vec2(-1.0/29.0, 0.0);\nvec2 s2 = vec2(1.0/101.0, 1.0/59.0);\nvec2 s3 = vec2(-1.0/109.0, -1.0/57.0);\ns0 = vec2((cosAngle * s0.x) - (sinAngle * s0.y), (sinAngle * s0.x) + (cosAngle * s0.y));\ns1 = vec2((cosAngle * s1.x) - (sinAngle * s1.y), (sinAngle * s1.x) + (cosAngle * s1.y));\ns2 = vec2((cosAngle * s2.x) - (sinAngle * s2.y), (sinAngle * s2.x) + (cosAngle * s2.y));\ns3 = vec2((cosAngle * s3.x) - (sinAngle * s3.y), (sinAngle * s3.x) + (cosAngle * s3.y));\nvec2 uv0 = (uv/103.0) + (time * s0);\nvec2 uv1 = uv/107.0 + (time * s1) + vec2(0.23);\nvec2 uv2 = uv/vec2(897.0, 983.0) + (time * s2) + vec2(0.51);\nvec2 uv3 = uv/vec2(991.0, 877.0) + (time * s3) + vec2(0.71);\nuv0 = fract(uv0);\nuv1 = fract(uv1);\nuv2 = fract(uv2);\nuv3 = fract(uv3);\nvec4 noise = (texture2D(normalMap, uv0)) +\n(texture2D(normalMap, uv1)) +\n(texture2D(normalMap, uv2)) +\n(texture2D(normalMap, uv3));\nreturn ((noise / 4.0) - 0.5) * 2.0;\n}\n",czm_hue="vec3 czm_hue(vec3 rgb, float adjustment)\n{\nconst mat3 toYIQ = mat3(0.299,     0.587,     0.114,\n0.595716, -0.274453, -0.321263,\n0.211456, -0.522591,  0.311135);\nconst mat3 toRGB = mat3(1.0,  0.9563,  0.6210,\n1.0, -0.2721, -0.6474,\n1.0, -1.107,   1.7046);\nvec3 yiq = toYIQ * rgb;\nfloat hue = atan(yiq.z, yiq.y) + adjustment;\nfloat chroma = sqrt(yiq.z * yiq.z + yiq.y * yiq.y);\nvec3 color = vec3(yiq.x, chroma * cos(hue), chroma * sin(hue));\nreturn toRGB * color;\n}\n",czm_inverseGamma="vec3 czm_inverseGamma(vec3 color) {\nreturn pow(color, vec3(1.0 / czm_gamma));\n}\n",czm_isEmpty="bool czm_isEmpty(czm_raySegment interval)\n{\nreturn (interval.stop < 0.0);\n}\n",czm_isFull="bool czm_isFull(czm_raySegment interval)\n{\nreturn (interval.start == 0.0 && interval.stop == czm_infinity);\n}\n",czm_latitudeToWebMercatorFraction="float czm_latitudeToWebMercatorFraction(float latitude, float southMercatorY, float oneOverMercatorHeight)\n{\nfloat sinLatitude = sin(latitude);\nfloat mercatorY = 0.5 * log((1.0 + sinLatitude) / (1.0 - sinLatitude));\nreturn (mercatorY - southMercatorY) * oneOverMercatorHeight;\n}\n",czm_lineDistance="float czm_lineDistance(vec2 point1, vec2 point2, vec2 point) {\nreturn abs((point2.y - point1.y) * point.x - (point2.x - point1.x) * point.y + point2.x * point1.y - point2.y * point1.x) / distance(point2, point1);\n}\n",czm_luminance="float czm_luminance(vec3 rgb)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nreturn dot(rgb, W);\n}\n",czm_metersPerPixel="float czm_metersPerPixel(vec4 positionEC, float pixelRatio)\n{\nfloat width = czm_viewport.z;\nfloat height = czm_viewport.w;\nfloat pixelWidth;\nfloat pixelHeight;\nfloat top = czm_frustumPlanes.x;\nfloat bottom = czm_frustumPlanes.y;\nfloat left = czm_frustumPlanes.z;\nfloat right = czm_frustumPlanes.w;\nif (czm_sceneMode == czm_sceneMode2D || czm_orthographicIn3D == 1.0)\n{\nfloat frustumWidth = right - left;\nfloat frustumHeight = top - bottom;\npixelWidth = frustumWidth / width;\npixelHeight = frustumHeight / height;\n}\nelse\n{\nfloat distanceToPixel = -positionEC.z;\nfloat inverseNear = 1.0 / czm_currentFrustum.x;\nfloat tanTheta = top * inverseNear;\npixelHeight = 2.0 * distanceToPixel * tanTheta / height;\ntanTheta = right * inverseNear;\npixelWidth = 2.0 * distanceToPixel * tanTheta / width;\n}\nreturn max(pixelWidth, pixelHeight) * pixelRatio;\n}\nfloat czm_metersPerPixel(vec4 positionEC)\n{\nreturn czm_metersPerPixel(positionEC, czm_pixelRatio);\n}\n",czm_modelToWindowCoordinates="vec4 czm_modelToWindowCoordinates(vec4 position)\n{\nvec4 q = czm_modelViewProjection * position;\nq.xyz /= q.w;\nq.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz;\nreturn q;\n}\n",czm_multiplyWithColorBalance="vec3 czm_multiplyWithColorBalance(vec3 left, vec3 right)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nvec3 target = left * right;\nfloat leftLuminance = dot(left, W);\nfloat rightLuminance = dot(right, W);\nfloat targetLuminance = dot(target, W);\nreturn ((leftLuminance + rightLuminance) / (2.0 * targetLuminance)) * target;\n}\n",czm_nearFarScalar="float czm_nearFarScalar(vec4 nearFarScalar, float cameraDistSq)\n{\nfloat valueAtMin = nearFarScalar.y;\nfloat valueAtMax = nearFarScalar.w;\nfloat nearDistanceSq = nearFarScalar.x * nearFarScalar.x;\nfloat farDistanceSq = nearFarScalar.z * nearFarScalar.z;\nfloat t = (cameraDistSq - nearDistanceSq) / (farDistanceSq - nearDistanceSq);\nt = pow(clamp(t, 0.0, 1.0), 0.2);\nreturn mix(valueAtMin, valueAtMax, t);\n}\n",czm_octDecode="vec3 czm_octDecode(vec2 encoded, float range)\n{\nif (encoded.x == 0.0 && encoded.y == 0.0) {\nreturn vec3(0.0, 0.0, 0.0);\n}\nencoded = encoded / range * 2.0 - 1.0;\nvec3 v = vec3(encoded.x, encoded.y, 1.0 - abs(encoded.x) - abs(encoded.y));\nif (v.z < 0.0)\n{\nv.xy = (1.0 - abs(v.yx)) * czm_signNotZero(v.xy);\n}\nreturn normalize(v);\n}\nvec3 czm_octDecode(vec2 encoded)\n{\nreturn czm_octDecode(encoded, 255.0);\n}\nvec3 czm_octDecode(float encoded)\n{\nfloat temp = encoded / 256.0;\nfloat x = floor(temp);\nfloat y = (temp - x) * 256.0;\nreturn czm_octDecode(vec2(x, y));\n}\nvoid czm_octDecode(vec2 encoded, out vec3 vector1, out vec3 vector2, out vec3 vector3)\n{\nfloat temp = encoded.x / 65536.0;\nfloat x = floor(temp);\nfloat encodedFloat1 = (temp - x) * 65536.0;\ntemp = encoded.y / 65536.0;\nfloat y = floor(temp);\nfloat encodedFloat2 = (temp - y) * 65536.0;\nvector1 = czm_octDecode(encodedFloat1);\nvector2 = czm_octDecode(encodedFloat2);\nvector3 = czm_octDecode(vec2(x, y));\n}\n",czm_packDepth="vec4 czm_packDepth(float depth)\n{\nvec4 enc = vec4(1.0, 255.0, 65025.0, 16581375.0) * depth;\nenc = fract(enc);\nenc -= enc.yzww * vec4(1.0 / 255.0, 1.0 / 255.0, 1.0 / 255.0, 0.0);\nreturn enc;\n}\n",czm_phong="float czm_private_getLambertDiffuseOfMaterial(vec3 lightDirectionEC, czm_material material)\n{\nreturn czm_getLambertDiffuse(lightDirectionEC, material.normal);\n}\nfloat czm_private_getSpecularOfMaterial(vec3 lightDirectionEC, vec3 toEyeEC, czm_material material)\n{\nreturn czm_getSpecular(lightDirectionEC, toEyeEC, material.normal, material.shininess);\n}\nvec4 czm_phong(vec3 toEye, czm_material material, vec3 lightDirectionEC)\n{\nfloat diffuse = czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 0.0, 1.0), material);\nif (czm_sceneMode == czm_sceneMode3D) {\ndiffuse += czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 1.0, 0.0), material);\n}\nfloat specular = czm_private_getSpecularOfMaterial(lightDirectionEC, toEye, material);\nvec3 materialDiffuse = material.diffuse * 0.5;\nvec3 ambient = materialDiffuse;\nvec3 color = ambient + material.emission;\ncolor += materialDiffuse * diffuse * czm_lightColor;\ncolor += material.specular * specular * czm_lightColor;\nreturn vec4(color, material.alpha);\n}\nvec4 czm_private_phong(vec3 toEye, czm_material material, vec3 lightDirectionEC)\n{\nfloat diffuse = czm_private_getLambertDiffuseOfMaterial(lightDirectionEC, material);\nfloat specular = czm_private_getSpecularOfMaterial(lightDirectionEC, toEye, material);\nvec3 ambient = vec3(0.0);\nvec3 color = ambient + material.emission;\ncolor += material.diffuse * diffuse * czm_lightColor;\ncolor += material.specular * specular * czm_lightColor;\nreturn vec4(color, material.alpha);\n}\n",czm_planeDistance="float czm_planeDistance(vec4 plane, vec3 point) {\nreturn (dot(plane.xyz, point) + plane.w);\n}\nfloat czm_planeDistance(vec3 planeNormal, float planeDistance, vec3 point) {\nreturn (dot(planeNormal, point) + planeDistance);\n}\n",czm_pointAlongRay="vec3 czm_pointAlongRay(czm_ray ray, float time)\n{\nreturn ray.origin + (time * ray.direction);\n}\n",czm_rayEllipsoidIntersectionInterval="czm_raySegment czm_rayEllipsoidIntersectionInterval(czm_ray ray, vec3 ellipsoid_center, vec3 ellipsoid_inverseRadii)\n{\nvec3 q = ellipsoid_inverseRadii * (czm_inverseModelView * vec4(ray.origin, 1.0)).xyz;\nvec3 w = ellipsoid_inverseRadii * (czm_inverseModelView * vec4(ray.direction, 0.0)).xyz;\nq = q - ellipsoid_inverseRadii * (czm_inverseModelView * vec4(ellipsoid_center, 1.0)).xyz;\nfloat q2 = dot(q, q);\nfloat qw = dot(q, w);\nif (q2 > 1.0)\n{\nif (qw >= 0.0)\n{\nreturn czm_emptyRaySegment;\n}\nelse\n{\nfloat qw2 = qw * qw;\nfloat difference = q2 - 1.0;\nfloat w2 = dot(w, w);\nfloat product = w2 * difference;\nif (qw2 < product)\n{\nreturn czm_emptyRaySegment;\n}\nelse if (qw2 > product)\n{\nfloat discriminant = qw * qw - product;\nfloat temp = -qw + sqrt(discriminant);\nfloat root0 = temp / w2;\nfloat root1 = difference / temp;\nif (root0 < root1)\n{\nczm_raySegment i = czm_raySegment(root0, root1);\nreturn i;\n}\nelse\n{\nczm_raySegment i = czm_raySegment(root1, root0);\nreturn i;\n}\n}\nelse\n{\nfloat root = sqrt(difference / w2);\nczm_raySegment i = czm_raySegment(root, root);\nreturn i;\n}\n}\n}\nelse if (q2 < 1.0)\n{\nfloat difference = q2 - 1.0;\nfloat w2 = dot(w, w);\nfloat product = w2 * difference;\nfloat discriminant = qw * qw - product;\nfloat temp = -qw + sqrt(discriminant);\nczm_raySegment i = czm_raySegment(0.0, temp / w2);\nreturn i;\n}\nelse\n{\nif (qw < 0.0)\n{\nfloat w2 = dot(w, w);\nczm_raySegment i = czm_raySegment(0.0, -qw / w2);\nreturn i;\n}\nelse\n{\nreturn czm_emptyRaySegment;\n}\n}\n}\n",czm_readDepth="float czm_readDepth(sampler2D depthTexture, vec2 texCoords)\n{\nreturn czm_reverseLogDepth(texture2D(depthTexture, texCoords).r);\n}\n",czm_readNonPerspective="float czm_readNonPerspective(float value, float oneOverW) {\nreturn value * oneOverW;\n}\nvec2 czm_readNonPerspective(vec2 value, float oneOverW) {\nreturn value * oneOverW;\n}\nvec3 czm_readNonPerspective(vec3 value, float oneOverW) {\nreturn value * oneOverW;\n}\nvec4 czm_readNonPerspective(vec4 value, float oneOverW) {\nreturn value * oneOverW;\n}\n",czm_reverseLogDepth="float czm_reverseLogDepth(float logZ)\n{\n#ifdef LOG_DEPTH\nfloat near = czm_currentFrustum.x;\nfloat far = czm_currentFrustum.y;\nfloat log2Depth = logZ * czm_log2FarDepthFromNearPlusOne;\nfloat depthFromNear = pow(2.0, log2Depth) - 1.0;\nreturn far * (1.0 - near / (depthFromNear + near)) / (far - near);\n#endif\nreturn logZ;\n}\n",czm_sampleOctahedralProjection="vec3 czm_sampleOctahedralProjectionWithFiltering(sampler2D projectedMap, vec2 textureSize, vec3 direction, float lod)\n{\ndirection /= dot(vec3(1.0), abs(direction));\nvec2 rev = abs(direction.zx) - vec2(1.0);\nvec2 neg = vec2(direction.x < 0.0 ? rev.x : -rev.x,\ndirection.z < 0.0 ? rev.y : -rev.y);\nvec2 uv = direction.y < 0.0 ? neg : direction.xz;\nvec2 coord = 0.5 * uv + vec2(0.5);\nvec2 pixel = 1.0 / textureSize;\nif (lod > 0.0)\n{\nfloat scale = 1.0 / pow(2.0, lod);\nfloat offset = ((textureSize.y + 1.0) / textureSize.x);\ncoord.x *= offset;\ncoord *= scale;\ncoord.x += offset + pixel.x;\ncoord.y += (1.0 - (1.0 / pow(2.0, lod - 1.0))) + pixel.y * (lod - 1.0) * 2.0;\n}\nelse\n{\ncoord.x *= (textureSize.y / textureSize.x);\n}\n#ifndef OES_texture_float_linear\nvec3 color1 = texture2D(projectedMap, coord + vec2(0.0, pixel.y)).rgb;\nvec3 color2 = texture2D(projectedMap, coord + vec2(pixel.x, 0.0)).rgb;\nvec3 color3 = texture2D(projectedMap, coord + pixel).rgb;\nvec3 color4 = texture2D(projectedMap, coord).rgb;\nvec2 texturePosition = coord * textureSize;\nfloat fu = fract(texturePosition.x);\nfloat fv = fract(texturePosition.y);\nvec3 average1 = mix(color4, color2, fu);\nvec3 average2 = mix(color1, color3, fu);\nvec3 color = mix(average1, average2, fv);\n#else\nvec3 color = texture2D(projectedMap, coord).rgb;\n#endif\nreturn color;\n}\nvec3 czm_sampleOctahedralProjection(sampler2D projectedMap, vec2 textureSize, vec3 direction, float lod, float maxLod) {\nfloat currentLod = floor(lod + 0.5);\nfloat nextLod = min(currentLod + 1.0, maxLod);\nvec3 colorCurrentLod = czm_sampleOctahedralProjectionWithFiltering(projectedMap, textureSize, direction, currentLod);\nvec3 colorNextLod = czm_sampleOctahedralProjectionWithFiltering(projectedMap, textureSize, direction, nextLod);\nreturn mix(colorNextLod, colorCurrentLod, nextLod - lod);\n}\n",czm_saturation="vec3 czm_saturation(vec3 rgb, float adjustment)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nvec3 intensity = vec3(dot(rgb, W));\nreturn mix(intensity, rgb, adjustment);\n}\n",czm_shadowDepthCompare="float czm_sampleShadowMap(highp samplerCube shadowMap, vec3 d)\n{\nreturn czm_unpackDepth(textureCube(shadowMap, d));\n}\nfloat czm_sampleShadowMap(highp sampler2D shadowMap, vec2 uv)\n{\n#ifdef USE_SHADOW_DEPTH_TEXTURE\nreturn texture2D(shadowMap, uv).r;\n#else\nreturn czm_unpackDepth(texture2D(shadowMap, uv));\n#endif\n}\nfloat czm_shadowDepthCompare(samplerCube shadowMap, vec3 uv, float depth)\n{\nreturn step(depth, czm_sampleShadowMap(shadowMap, uv));\n}\nfloat czm_shadowDepthCompare(sampler2D shadowMap, vec2 uv, float depth)\n{\nreturn step(depth, czm_sampleShadowMap(shadowMap, uv));\n}\n",czm_shadowVisibility="float czm_private_shadowVisibility(float visibility, float nDotL, float normalShadingSmooth, float darkness)\n{\n#ifdef USE_NORMAL_SHADING\n#ifdef USE_NORMAL_SHADING_SMOOTH\nfloat strength = clamp(nDotL / normalShadingSmooth, 0.0, 1.0);\n#else\nfloat strength = step(0.0, nDotL);\n#endif\nvisibility *= strength;\n#endif\nvisibility = max(visibility, darkness);\nreturn visibility;\n}\n#ifdef USE_CUBE_MAP_SHADOW\nfloat czm_shadowVisibility(samplerCube shadowMap, czm_shadowParameters shadowParameters)\n{\nfloat depthBias = shadowParameters.depthBias;\nfloat depth = shadowParameters.depth;\nfloat nDotL = shadowParameters.nDotL;\nfloat normalShadingSmooth = shadowParameters.normalShadingSmooth;\nfloat darkness = shadowParameters.darkness;\nvec3 uvw = shadowParameters.texCoords;\ndepth -= depthBias;\nfloat visibility = czm_shadowDepthCompare(shadowMap, uvw, depth);\nreturn czm_private_shadowVisibility(visibility, nDotL, normalShadingSmooth, darkness);\n}\n#else\nfloat czm_shadowVisibility(sampler2D shadowMap, czm_shadowParameters shadowParameters)\n{\nfloat depthBias = shadowParameters.depthBias;\nfloat depth = shadowParameters.depth;\nfloat nDotL = shadowParameters.nDotL;\nfloat normalShadingSmooth = shadowParameters.normalShadingSmooth;\nfloat darkness = shadowParameters.darkness;\nvec2 uv = shadowParameters.texCoords;\ndepth -= depthBias;\n#ifdef USE_SOFT_SHADOWS\nvec2 texelStepSize = shadowParameters.texelStepSize;\nfloat radius = 1.0;\nfloat dx0 = -texelStepSize.x * radius;\nfloat dy0 = -texelStepSize.y * radius;\nfloat dx1 = texelStepSize.x * radius;\nfloat dy1 = texelStepSize.y * radius;\nfloat visibility = (\nczm_shadowDepthCompare(shadowMap, uv, depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(dx0, dy0), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(0.0, dy0), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(dx1, dy0), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(dx0, 0.0), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(dx1, 0.0), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(dx0, dy1), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(0.0, dy1), depth) +\nczm_shadowDepthCompare(shadowMap, uv + vec2(dx1, dy1), depth)\n) * (1.0 / 9.0);\n#else\nfloat visibility = czm_shadowDepthCompare(shadowMap, uv, depth);\n#endif\nreturn czm_private_shadowVisibility(visibility, nDotL, normalShadingSmooth, darkness);\n}\n#endif\n",czm_signNotZero="float czm_signNotZero(float value)\n{\nreturn value >= 0.0 ? 1.0 : -1.0;\n}\nvec2 czm_signNotZero(vec2 value)\n{\nreturn vec2(czm_signNotZero(value.x), czm_signNotZero(value.y));\n}\nvec3 czm_signNotZero(vec3 value)\n{\nreturn vec3(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z));\n}\nvec4 czm_signNotZero(vec4 value)\n{\nreturn vec4(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z), czm_signNotZero(value.w));\n}\n",czm_sphericalHarmonics="vec3 czm_sphericalHarmonics(vec3 normal, vec3 coefficients[9])\n{\nconst float c1 = 0.429043;\nconst float c2 = 0.511664;\nconst float c3 = 0.743125;\nconst float c4 = 0.886227;\nconst float c5 = 0.247708;\nvec3 L00 = coefficients[0];\nvec3 L1_1 = coefficients[1];\nvec3 L10 = coefficients[2];\nvec3 L11 = coefficients[3];\nvec3 L2_2 = coefficients[4];\nvec3 L2_1 = coefficients[5];\nvec3 L20 = coefficients[6];\nvec3 L21 = coefficients[7];\nvec3 L22 = coefficients[8];\nfloat x = normal.x;\nfloat y = normal.y;\nfloat z = normal.z;\nreturn c1 * L22 * (x * x - y * y) + c3 * L20 * z * z + c4 * L00 - c5 * L20 +\n2.0 * c1 * (L2_2 * x * y + L21 * x * z + L2_1 * y * z) +\n2.0 * c2 * (L11 * x + L1_1 * y + L10 * z);\n}\n",czm_tangentToEyeSpaceMatrix="mat3 czm_tangentToEyeSpaceMatrix(vec3 normalEC, vec3 tangentEC, vec3 bitangentEC)\n{\nvec3 normal = normalize(normalEC);\nvec3 tangent = normalize(tangentEC);\nvec3 bitangent = normalize(bitangentEC);\nreturn mat3(tangent.x  , tangent.y  , tangent.z,\nbitangent.x, bitangent.y, bitangent.z,\nnormal.x   , normal.y   , normal.z);\n}\n",czm_transformPlane="vec4 czm_transformPlane(vec4 plane, mat4 transform) {\nvec4 transformedPlane = transform * plane;\nfloat normalMagnitude = length(transformedPlane.xyz);\nreturn transformedPlane / normalMagnitude;\n}\n",czm_translateRelativeToEye="vec4 czm_translateRelativeToEye(vec3 high, vec3 low)\n{\nvec3 highDifference = high - czm_encodedCameraPositionMCHigh;\nvec3 lowDifference = low - czm_encodedCameraPositionMCLow;\nreturn vec4(highDifference + lowDifference, 1.0);\n}\n",czm_translucentPhong="vec4 czm_translucentPhong(vec3 toEye, czm_material material, vec3 lightDirectionEC)\n{\nfloat diffuse = czm_getLambertDiffuse(vec3(0.0, 0.0, 1.0), material.normal);\nif (czm_sceneMode == czm_sceneMode3D) {\ndiffuse += czm_getLambertDiffuse(vec3(0.0, 1.0, 0.0), material.normal);\n}\ndiffuse = clamp(diffuse, 0.0, 1.0);\nfloat specular = czm_getSpecular(lightDirectionEC, toEye, material.normal, material.shininess);\nvec3 materialDiffuse = material.diffuse * 0.5;\nvec3 ambient = materialDiffuse;\nvec3 color = ambient + material.emission;\ncolor += materialDiffuse * diffuse * czm_lightColor;\ncolor += material.specular * specular * czm_lightColor;\nreturn vec4(color, material.alpha);\n}\n",czm_transpose="mat2 czm_transpose(mat2 matrix)\n{\nreturn mat2(\nmatrix[0][0], matrix[1][0],\nmatrix[0][1], matrix[1][1]);\n}\nmat3 czm_transpose(mat3 matrix)\n{\nreturn mat3(\nmatrix[0][0], matrix[1][0], matrix[2][0],\nmatrix[0][1], matrix[1][1], matrix[2][1],\nmatrix[0][2], matrix[1][2], matrix[2][2]);\n}\nmat4 czm_transpose(mat4 matrix)\n{\nreturn mat4(\nmatrix[0][0], matrix[1][0], matrix[2][0], matrix[3][0],\nmatrix[0][1], matrix[1][1], matrix[2][1], matrix[3][1],\nmatrix[0][2], matrix[1][2], matrix[2][2], matrix[3][2],\nmatrix[0][3], matrix[1][3], matrix[2][3], matrix[3][3]);\n}\n",czm_unpackDepth="float czm_unpackDepth(vec4 packedDepth)\n{\nreturn dot(packedDepth, vec4(1.0, 1.0 / 255.0, 1.0 / 65025.0, 1.0 / 16581375.0));\n}\n",czm_unpackFloat="float czm_unpackFloat(vec4 packedFloat)\n{\npackedFloat = floor(packedFloat * 255.0 + 0.5);\nfloat sign = 1.0 - step(128.0, packedFloat[3]) * 2.0;\nfloat exponent = 2.0 * mod(packedFloat[3], 128.0) + step(128.0, packedFloat[2]) - 127.0;\nif (exponent == -127.0)\n{\nreturn 0.0;\n}\nfloat mantissa = mod(packedFloat[2], 128.0) * 65536.0 + packedFloat[1] * 256.0 + packedFloat[0] + float(0x800000);\nfloat result = sign * exp2(exponent - 23.0) * mantissa;\nreturn result;\n}\n",czm_vertexLogDepth="#ifdef LOG_DEPTH\nvarying float v_depthFromNearPlusOne;\n#ifdef SHADOW_MAP\nvarying vec3 v_logPositionEC;\n#endif\n#endif\nvec4 czm_updatePositionDepth(vec4 coords) {\n#if defined(LOG_DEPTH)\n#ifdef SHADOW_MAP\nvec3 logPositionEC = (czm_inverseProjection * coords).xyz;\nv_logPositionEC = logPositionEC;\n#endif\ncoords.z = clamp(coords.z / coords.w, -1.0, 1.0) * coords.w;\n#endif\nreturn coords;\n}\nvoid czm_vertexLogDepth()\n{\n#ifdef LOG_DEPTH\nv_depthFromNearPlusOne = (gl_Position.w - czm_currentFrustum.x) + 1.0;\ngl_Position = czm_updatePositionDepth(gl_Position);\n#endif\n}\nvoid czm_vertexLogDepth(vec4 clipCoords)\n{\n#ifdef LOG_DEPTH\nv_depthFromNearPlusOne = (clipCoords.w - czm_currentFrustum.x) + 1.0;\nczm_updatePositionDepth(clipCoords);\n#endif\n}\n",czm_windowToEyeCoordinates="vec4 czm_windowToEyeCoordinates(vec4 fragmentCoordinate)\n{\nfloat x = 2.0 * (fragmentCoordinate.x - czm_viewport.x) / czm_viewport.z - 1.0;\nfloat y = 2.0 * (fragmentCoordinate.y - czm_viewport.y) / czm_viewport.w - 1.0;\nfloat z = (fragmentCoordinate.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];\nvec4 q = vec4(x, y, z, 1.0);\nq /= fragmentCoordinate.w;\nif (!(czm_inverseProjection == mat4(0.0)))\n{\nq = czm_inverseProjection * q;\n}\nelse\n{\nfloat top = czm_frustumPlanes.x;\nfloat bottom = czm_frustumPlanes.y;\nfloat left = czm_frustumPlanes.z;\nfloat right = czm_frustumPlanes.w;\nfloat near = czm_currentFrustum.x;\nfloat far = czm_currentFrustum.y;\nq.x = (q.x * (right - left) + left + right) * 0.5;\nq.y = (q.y * (top - bottom) + bottom + top) * 0.5;\nq.z = (q.z * (near - far) - near - far) * 0.5;\nq.w = 1.0;\n}\nreturn q;\n}\nvec4 czm_windowToEyeCoordinates(vec2 fragmentCoordinateXY, float depthOrLogDepth)\n{\n#ifdef LOG_DEPTH\nfloat near = czm_currentFrustum.x;\nfloat far = czm_currentFrustum.y;\nfloat log2Depth = depthOrLogDepth * czm_log2FarDepthFromNearPlusOne;\nfloat depthFromNear = pow(2.0, log2Depth) - 1.0;\nfloat depthFromCamera = depthFromNear + near;\nvec4 windowCoord = vec4(fragmentCoordinateXY, far * (1.0 - near / depthFromCamera) / (far - near), 1.0);\nvec4 eyeCoordinate = czm_windowToEyeCoordinates(windowCoord);\neyeCoordinate.w = 1.0 / depthFromCamera;\nreturn eyeCoordinate;\n#else\nvec4 windowCoord = vec4(fragmentCoordinateXY, depthOrLogDepth, 1.0);\nvec4 eyeCoordinate = czm_windowToEyeCoordinates(windowCoord);\n#endif\nreturn eyeCoordinate;\n}\n",czm_writeDepthClamp="#if defined(GL_EXT_frag_depth) && !defined(LOG_DEPTH)\nvarying float v_WindowZ;\n#endif\nvoid czm_writeDepthClamp()\n{\n#if defined(GL_EXT_frag_depth) && !defined(LOG_DEPTH)\ngl_FragDepthEXT = clamp(v_WindowZ * gl_FragCoord.w, 0.0, 1.0);\n#endif\n}\n",czm_writeLogDepth="#ifdef LOG_DEPTH\nvarying float v_depthFromNearPlusOne;\n#ifdef POLYGON_OFFSET\nuniform vec2 u_polygonOffset;\n#endif\n#endif\nvoid czm_writeLogDepth(float depth)\n{\n#if defined(GL_EXT_frag_depth) && defined(LOG_DEPTH)\nif (depth <= 0.9999999 || depth > czm_farDepthFromNearPlusOne) {\ndiscard;\n}\n#ifdef POLYGON_OFFSET\nfloat factor = u_polygonOffset[0];\nfloat units = u_polygonOffset[1];\n#ifdef GL_OES_standard_derivatives\nfloat x = dFdx(depth);\nfloat y = dFdy(depth);\nfloat m = sqrt(x * x + y * y);\ndepth += m * factor;\n#endif\n#endif\ngl_FragDepthEXT = log2(depth) * czm_oneOverLog2FarDepthFromNearPlusOne;\n#ifdef POLYGON_OFFSET\ngl_FragDepthEXT += czm_epsilon7 * units;\n#endif\n#endif\n}\nvoid czm_writeLogDepth() {\n#ifdef LOG_DEPTH\nczm_writeLogDepth(v_depthFromNearPlusOne);\n#endif\n}\n",czm_writeNonPerspective="float czm_writeNonPerspective(float value, float w) {\nreturn value * w;\n}\nvec2 czm_writeNonPerspective(vec2 value, float w) {\nreturn value * w;\n}\nvec3 czm_writeNonPerspective(vec3 value, float w) {\nreturn value * w;\n}\nvec4 czm_writeNonPerspective(vec4 value, float w) {\nreturn value * w;\n}\n",CzmBuiltins={czm_degreesPerRadian:czm_degreesPerRadian,czm_depthRange:czm_depthRange,czm_epsilon1:czm_epsilon1,czm_epsilon2:czm_epsilon2,czm_epsilon3:czm_epsilon3,czm_epsilon4:czm_epsilon4,czm_epsilon5:czm_epsilon5,czm_epsilon6:czm_epsilon6,czm_epsilon7:czm_epsilon7,czm_infinity:czm_infinity,czm_oneOverPi:czm_oneOverPi,czm_oneOverTwoPi:czm_oneOverTwoPi,czm_passCesium3DTile:czm_passCesium3DTile,czm_passCesium3DTileClassification:czm_passCesium3DTileClassification,czm_passCesium3DTileClassificationIgnoreShow:czm_passCesium3DTileClassificationIgnoreShow,czm_passClassification:czm_passClassification,czm_passCompute:czm_passCompute,czm_passEnvironment:czm_passEnvironment,czm_passGlobe:czm_passGlobe,czm_passOpaque:czm_passOpaque,czm_passOverlay:czm_passOverlay,czm_passTerrainClassification:czm_passTerrainClassification,czm_passTranslucent:czm_passTranslucent,czm_pi:czm_pi,czm_piOverFour:czm_piOverFour,czm_piOverSix:czm_piOverSix,czm_piOverThree:czm_piOverThree,czm_piOverTwo:czm_piOverTwo,czm_radiansPerDegree:czm_radiansPerDegree,czm_sceneMode2D:czm_sceneMode2D,czm_sceneMode3D:czm_sceneMode3D,czm_sceneModeColumbusView:czm_sceneModeColumbusView,czm_sceneModeMorphing:czm_sceneModeMorphing,czm_solarRadius:czm_solarRadius,czm_threePiOver2:czm_threePiOver2,czm_twoPi:czm_twoPi,czm_webMercatorMaxLatitude:czm_webMercatorMaxLatitude,czm_depthRangeStruct:czm_depthRangeStruct,czm_material:czm_material,czm_materialInput:czm_materialInput,czm_ray:czm_ray,czm_raySegment:czm_raySegment,czm_shadowParameters:czm_shadowParameters,czm_HSBToRGB:czm_HSBToRGB,czm_HSLToRGB:czm_HSLToRGB,czm_RGBToHSB:czm_RGBToHSB,czm_RGBToHSL:czm_RGBToHSL,czm_RGBToXYZ:czm_RGBToXYZ,czm_XYZToRGB:czm_XYZToRGB,czm_acesTonemapping:czm_acesTonemapping,czm_alphaWeight:czm_alphaWeight,czm_antialias:czm_antialias,czm_approximateSphericalCoordinates:czm_approximateSphericalCoordinates,czm_backFacing:czm_backFacing,czm_branchFreeTernary:czm_branchFreeTernary,czm_cascadeColor:czm_cascadeColor,czm_cascadeDistance:czm_cascadeDistance,czm_cascadeMatrix:czm_cascadeMatrix,czm_cascadeWeights:czm_cascadeWeights,czm_columbusViewMorph:czm_columbusViewMorph,czm_computePosition:czm_computePosition,czm_cosineAndSine:czm_cosineAndSine,czm_decompressTextureCoordinates:czm_decompressTextureCoordinates,czm_depthClamp:czm_depthClamp,czm_eastNorthUpToEyeCoordinates:czm_eastNorthUpToEyeCoordinates,czm_ellipsoidContainsPoint:czm_ellipsoidContainsPoint,czm_ellipsoidWgs84TextureCoordinates:czm_ellipsoidWgs84TextureCoordinates,czm_equalsEpsilon:czm_equalsEpsilon,czm_eyeOffset:czm_eyeOffset,czm_eyeToWindowCoordinates:czm_eyeToWindowCoordinates,czm_fastApproximateAtan:czm_fastApproximateAtan,czm_fog:czm_fog,czm_gammaCorrect:czm_gammaCorrect,czm_geodeticSurfaceNormal:czm_geodeticSurfaceNormal,czm_getDefaultMaterial:czm_getDefaultMaterial,czm_getLambertDiffuse:czm_getLambertDiffuse,czm_getSpecular:czm_getSpecular,czm_getWaterNoise:czm_getWaterNoise,czm_hue:czm_hue,czm_inverseGamma:czm_inverseGamma,czm_isEmpty:czm_isEmpty,czm_isFull:czm_isFull,czm_latitudeToWebMercatorFraction:czm_latitudeToWebMercatorFraction,czm_lineDistance:czm_lineDistance,czm_luminance:czm_luminance,czm_metersPerPixel:czm_metersPerPixel,czm_modelToWindowCoordinates:czm_modelToWindowCoordinates,czm_multiplyWithColorBalance:czm_multiplyWithColorBalance,czm_nearFarScalar:czm_nearFarScalar,czm_octDecode:czm_octDecode,czm_packDepth:czm_packDepth,czm_phong:czm_phong,czm_planeDistance:czm_planeDistance,czm_pointAlongRay:czm_pointAlongRay,czm_rayEllipsoidIntersectionInterval:czm_rayEllipsoidIntersectionInterval,czm_readDepth:czm_readDepth,czm_readNonPerspective:czm_readNonPerspective,czm_reverseLogDepth:czm_reverseLogDepth,czm_sampleOctahedralProjection:czm_sampleOctahedralProjection,czm_saturation:czm_saturation,czm_shadowDepthCompare:czm_shadowDepthCompare,czm_shadowVisibility:czm_shadowVisibility,czm_signNotZero:czm_signNotZero,czm_sphericalHarmonics:czm_sphericalHarmonics,czm_tangentToEyeSpaceMatrix:czm_tangentToEyeSpaceMatrix,czm_transformPlane:czm_transformPlane,czm_translateRelativeToEye:czm_translateRelativeToEye,czm_translucentPhong:czm_translucentPhong,czm_transpose:czm_transpose,czm_unpackDepth:czm_unpackDepth,czm_unpackFloat:czm_unpackFloat,czm_vertexLogDepth:czm_vertexLogDepth,czm_windowToEyeCoordinates:czm_windowToEyeCoordinates,czm_writeDepthClamp:czm_writeDepthClamp,czm_writeLogDepth:czm_writeLogDepth,czm_writeNonPerspective:czm_writeNonPerspective},builtinName,uniformName,uniform;function removeComments(e){return(e=e.replace(/\/\/.*/g,"")).replace(/\/\*\*[\s\S]*?\*\//gm,function(e){for(var t=e.match(/\n/gm).length,i="",r=0;r<t;++r)i+="\n";return i})}function getDependencyNode(e,t,i){for(var r,n=0;n<i.length;++n)i[n].name===e&&(r=i[n]);return defined(r)||(r={name:e,glslSource:t=removeComments(t),dependsOn:[],requiredBy:[],evaluated:!1},i.push(r)),r}function generateDependencies(t,i){var r;t.evaluated||(t.evaluated=!0,defined(r=t.glslSource.match(/\bczm_[a-zA-Z0-9_]*/g))&&null!==r&&(r=r.filter(function(e,t){return r.indexOf(e)===t})).forEach(function(e){e!==t.name&&ShaderSource._czmBuiltinsAndUniforms.hasOwnProperty(e)&&(e=getDependencyNode(e,ShaderSource._czmBuiltinsAndUniforms[e],i),t.dependsOn.push(e),e.requiredBy.push(t),generateDependencies(e,i))}))}function sortDependencies(e){for(var t=[],i=[];0<e.length;){var r=e.pop();i.push(r),0===r.requiredBy.length&&t.push(r)}for(;0<t.length;){var n=t.shift();e.push(n);for(var a=0;a<n.dependsOn.length;++a){var o=n.dependsOn[a],s=o.requiredBy.indexOf(n);o.requiredBy.splice(s,1),0===o.requiredBy.length&&t.push(o)}}for(var l=0;l<i.length;++l)i[l].requiredBy.length}function getBuiltinsAndAutomaticUniforms(e){var t=[],e=getDependencyNode("main",e,t);generateDependencies(e,t),sortDependencies(t);for(var i="",r=t.length-1;0<=r;--r)i=i+t[r].glslSource+"\n";return i.replace(e.glslSource,"")}function combineShader(e,t,i){var r,n,a="",o=e.sources;if(defined(o))for(d=0,r=o.length;d<r;++d)a+="\n#line 0\n"+o[d];a=(a=removeComments(a)).replace(/#version\s+(.*?)\n/gm,function(e,t){return n=t,"\n"});var s=[];a=(a=a.replace(/#extension.*\n/gm,function(e){return s.push(e),"\n"})).replace(/precision\s(lowp|mediump|highp)\s(float|int);/,"");var l=e.pickColorQualifier;defined(l)&&(a=ShaderSource.createPickFragmentShaderSource(a,l));var c="";defined(n)&&(c="#version "+n+"\n");for(var u=s.length,d=0;d<u;d++)c+=s[d];t&&(c+="#ifdef GL_FRAGMENT_PRECISION_HIGH\n    precision highp float;\n#else\n    precision mediump float;\n    #define highp mediump\n#endif\n\n");var h=e.defines;if(defined(h))for(d=0,r=h.length;d<r;++d){var p=h[d];0!==p.length&&(c+="#define "+p+"\n")}return i.webgl2&&(c+="#define OUTPUT_DECLARATION\n\n"),i.textureFloatLinear&&(c+="#define OES_texture_float_linear\n\n"),i.floatingPointTexture&&(c+="#define OES_texture_float\n\n"),e.includeBuiltIns&&(c+=getBuiltinsAndAutomaticUniforms(a)),c+="\n#line 0\n",c+=a,i.webgl2&&(c=modernizeShader(c,t)),c}function ShaderSource(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).pickColorQualifier;this.defines=defined(e.defines)?e.defines.slice(0):[],this.sources=defined(e.sources)?e.sources.slice(0):[],this.pickColorQualifier=t,this.includeBuiltIns=defaultValue(e.includeBuiltIns,!0)}for(builtinName in ShaderSource.prototype.clone=function(){return new ShaderSource({sources:this.sources,defines:this.defines,pickColorQualifier:this.pickColorQualifier,includeBuiltIns:this.includeBuiltIns})},ShaderSource.replaceMain=function(e,t){return t="void "+t+"()",e.replace(/void\s+main\s*\(\s*(?:void)?\s*\)/g,t)},ShaderSource.prototype.createCombinedVertexShader=function(e){return combineShader(this,!1,e)},ShaderSource.prototype.createCombinedFragmentShader=function(e){return combineShader(this,!0,e)},ShaderSource._czmBuiltinsAndUniforms={},CzmBuiltins)CzmBuiltins.hasOwnProperty(builtinName)&&(ShaderSource._czmBuiltinsAndUniforms[builtinName]=CzmBuiltins[builtinName]);for(uniformName in AutomaticUniforms){AutomaticUniforms.hasOwnProperty(uniformName)&&(uniform=AutomaticUniforms[uniformName],"function"==typeof uniform.getDeclaration&&(ShaderSource._czmBuiltinsAndUniforms[uniformName]=uniform.getDeclaration(uniformName)))}ShaderSource.createPickVertexShaderSource=function(e){return ShaderSource.replaceMain(e,"czm_old_main")+"\nattribute vec4 pickColor; \nvarying vec4 czm_pickColor; \nvoid main() \n{ \n    czm_old_main(); \n    czm_pickColor = pickColor; \n}"},ShaderSource.createPickFragmentShaderSource=function(e,t){return ShaderSource.replaceMain(e,"czm_old_main")+"\n"+(t+" vec4 czm_pickColor; \nvoid main() \n{ \n    czm_old_main(); \n    if (gl_FragColor.a == 0.0) { \n       discard; \n    } \n    gl_FragColor = czm_pickColor; \n}")},ShaderSource.findVarying=function(e,t){for(var i=e.sources,r=t.length,n=0;n<r;++n)for(var a=t[n],o=i.length,s=0;s<o;++s)if(-1!==i[s].indexOf(a))return a};var normalVaryingNames=["v_normalEC","v_normal"];ShaderSource.findNormalVarying=function(e){return ShaderSource.findVarying(e,normalVaryingNames)};var positionVaryingNames=["v_positionEC"];ShaderSource.findPositionVarying=function(e){return ShaderSource.findVarying(e,positionVaryingNames)};var ShadowVolumeAppearanceVS="attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute float batchId;\n#ifdef EXTRUDED_GEOMETRY\nattribute vec3 extrudeDirection;\nuniform float u_globeMinimumAltitude;\n#endif // EXTRUDED_GEOMETRY\n#ifdef PER_INSTANCE_COLOR\nvarying vec4 v_color;\n#endif // PER_INSTANCE_COLOR\n#ifdef TEXTURE_COORDINATES\n#ifdef SPHERICAL\nvarying vec4 v_sphericalExtents;\n#else // SPHERICAL\nvarying vec2 v_inversePlaneExtents;\nvarying vec4 v_westPlane;\nvarying vec4 v_southPlane;\n#endif // SPHERICAL\nvarying vec3 v_uvMinAndSphericalLongitudeRotation;\nvarying vec3 v_uMaxAndInverseDistance;\nvarying vec3 v_vMaxAndInverseDistance;\n#endif // TEXTURE_COORDINATES\nvoid main()\n{\nvec4 position = czm_computePosition();\n#ifdef EXTRUDED_GEOMETRY\nfloat delta = min(u_globeMinimumAltitude, czm_geometricToleranceOverMeter * length(position.xyz));\ndelta *= czm_sceneMode == czm_sceneMode3D ? 1.0 : 0.0;\nposition = position + vec4(extrudeDirection * delta, 0.0);\n#endif\n#ifdef TEXTURE_COORDINATES\n#ifdef SPHERICAL\nv_sphericalExtents = czm_batchTable_sphericalExtents(batchId);\nv_uvMinAndSphericalLongitudeRotation.z = czm_batchTable_longitudeRotation(batchId);\n#else // SPHERICAL\n#ifdef COLUMBUS_VIEW_2D\nvec4 planes2D_high = czm_batchTable_planes2D_HIGH(batchId);\nvec4 planes2D_low = czm_batchTable_planes2D_LOW(batchId);\nvec2 idlSplitNewPlaneHiLow = vec2(EAST_MOST_X_HIGH - (WEST_MOST_X_HIGH - planes2D_high.w), EAST_MOST_X_LOW - (WEST_MOST_X_LOW - planes2D_low.w));\nbool idlSplit = planes2D_high.x > planes2D_high.w && position3DLow.y > 0.0;\nplanes2D_high.w = czm_branchFreeTernary(idlSplit, idlSplitNewPlaneHiLow.x, planes2D_high.w);\nplanes2D_low.w = czm_branchFreeTernary(idlSplit, idlSplitNewPlaneHiLow.y, planes2D_low.w);\nidlSplit = planes2D_high.x > planes2D_high.w && position3DLow.y < 0.0;\nidlSplitNewPlaneHiLow = vec2(WEST_MOST_X_HIGH - (EAST_MOST_X_HIGH - planes2D_high.x), WEST_MOST_X_LOW - (EAST_MOST_X_LOW - planes2D_low.x));\nplanes2D_high.x = czm_branchFreeTernary(idlSplit, idlSplitNewPlaneHiLow.x, planes2D_high.x);\nplanes2D_low.x = czm_branchFreeTernary(idlSplit, idlSplitNewPlaneHiLow.y, planes2D_low.x);\nvec3 southWestCorner = (czm_modelViewRelativeToEye * czm_translateRelativeToEye(vec3(0.0, planes2D_high.xy), vec3(0.0, planes2D_low.xy))).xyz;\nvec3 northWestCorner = (czm_modelViewRelativeToEye * czm_translateRelativeToEye(vec3(0.0, planes2D_high.x, planes2D_high.z), vec3(0.0, planes2D_low.x, planes2D_low.z))).xyz;\nvec3 southEastCorner = (czm_modelViewRelativeToEye * czm_translateRelativeToEye(vec3(0.0, planes2D_high.w, planes2D_high.y), vec3(0.0, planes2D_low.w, planes2D_low.y))).xyz;\n#else // COLUMBUS_VIEW_2D\nvec3 southWestCorner = (czm_modelViewRelativeToEye * czm_translateRelativeToEye(czm_batchTable_southWest_HIGH(batchId), czm_batchTable_southWest_LOW(batchId))).xyz;\nvec3 northWestCorner = czm_normal * czm_batchTable_northward(batchId) + southWestCorner;\nvec3 southEastCorner = czm_normal * czm_batchTable_eastward(batchId) + southWestCorner;\n#endif // COLUMBUS_VIEW_2D\nvec3 eastWard = southEastCorner - southWestCorner;\nfloat eastExtent = length(eastWard);\neastWard /= eastExtent;\nvec3 northWard = northWestCorner - southWestCorner;\nfloat northExtent = length(northWard);\nnorthWard /= northExtent;\nv_westPlane = vec4(eastWard, -dot(eastWard, southWestCorner));\nv_southPlane = vec4(northWard, -dot(northWard, southWestCorner));\nv_inversePlaneExtents = vec2(1.0 / eastExtent, 1.0 / northExtent);\n#endif // SPHERICAL\nvec4 uvMinAndExtents = czm_batchTable_uvMinAndExtents(batchId);\nvec4 uMaxVmax = czm_batchTable_uMaxVmax(batchId);\nv_uMaxAndInverseDistance = vec3(uMaxVmax.xy, uvMinAndExtents.z);\nv_vMaxAndInverseDistance = vec3(uMaxVmax.zw, uvMinAndExtents.w);\nv_uvMinAndSphericalLongitudeRotation.xy = uvMinAndExtents.xy;\n#endif // TEXTURE_COORDINATES\n#ifdef PER_INSTANCE_COLOR\nv_color = czm_batchTable_color(batchId);\n#endif\ngl_Position = czm_depthClamp(czm_modelViewProjectionRelativeToEye * position);\n}\n",ShadowVolumeFS="#ifdef GL_EXT_frag_depth\n#extension GL_EXT_frag_depth : enable\n#endif\n#ifdef VECTOR_TILE\nuniform vec4 u_highlightColor;\n#endif\nvoid main(void)\n{\n#ifdef VECTOR_TILE\ngl_FragColor = czm_gammaCorrect(u_highlightColor);\n#else\ngl_FragColor = vec4(1.0);\n#endif\nczm_writeDepthClamp();\n}\n",ClassificationType={TERRAIN:0,CESIUM_3D_TILE:1,BOTH:2,NUMBER_OF_CLASSIFICATION_TYPES:3},ClassificationType$1=Object.freeze(ClassificationType),DepthFunction={NEVER:WebGLConstants$1.NEVER,LESS:WebGLConstants$1.LESS,EQUAL:WebGLConstants$1.EQUAL,LESS_OR_EQUAL:WebGLConstants$1.LEQUAL,GREATER:WebGLConstants$1.GREATER,NOT_EQUAL:WebGLConstants$1.NOTEQUAL,GREATER_OR_EQUAL:WebGLConstants$1.GEQUAL,ALWAYS:WebGLConstants$1.ALWAYS},DepthFunction$1=Object.freeze(DepthFunction),BufferUsage={STREAM_DRAW:WebGLConstants$1.STREAM_DRAW,STATIC_DRAW:WebGLConstants$1.STATIC_DRAW,DYNAMIC_DRAW:WebGLConstants$1.DYNAMIC_DRAW,validate:function(e){return e===BufferUsage.STREAM_DRAW||e===BufferUsage.STATIC_DRAW||e===BufferUsage.DYNAMIC_DRAW}},BufferUsage$1=Object.freeze(BufferUsage);function Buffer$1(e){var t=(e=defaultValue(e,defaultValue.EMPTY_OBJECT)).context._gl,i=e.bufferTarget,r=e.typedArray,n=e.sizeInBytes,a=e.usage,o=defined(r);o&&(n=r.byteLength);var s=t.createBuffer();t.bindBuffer(i,s),t.bufferData(i,o?r:n,a),t.bindBuffer(i,null),this._gl=t,this._webgl2=e.context._webgl2,this._bufferTarget=i,this._sizeInBytes=n,this._usage=a,this._buffer=s,this.vertexArrayDestroyable=!0}function addAttribute(e,t,i,r){var n=defined(t.vertexBuffer),a=defined(t.value),o=t.value?t.value.length:t.componentsPerAttribute,s={index:defaultValue(t.index,i),enabled:defaultValue(t.enabled,!0),vertexBuffer:t.vertexBuffer,value:a?t.value.slice(0):void 0,componentsPerAttribute:o,component