/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import com.arbortext.catalog.Catalog;
import com.arbortext.catalog.CatalogEntityResolver;
import edu.ucsb.nceas.metacat.DBEntityResolver;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DBValidate {
    static int WARNING = 0;
    static int ERROR = 1;
    static int FATAL_ERROR = 2;
    XMLReader parser;
    ErrorStorer ef;
    String xml_doc;
    public boolean alreadyHandle = false;

    public DBValidate() {
        try {
            String parserName = PropertyService.getProperty("xml.saxparser");
            this.parser = XMLReaderFactory.createXMLReader(parserName);
            this.parser.setFeature("http://xml.org/sax/features/validation", true);
        }
        catch (Exception e) {
            System.err.println("Could not create parser in DBValidate.DBValidate");
        }
    }

    public DBValidate(String xmlcatalogfile) {
        this();
        CatalogEntityResolver cer = new CatalogEntityResolver();
        try {
            Catalog myCatalog = new Catalog();
            myCatalog.loadSystemCatalogs();
            myCatalog.parseCatalog(xmlcatalogfile);
            cer.setCatalog(myCatalog);
        }
        catch (Exception e) {
            System.out.println("Problem creating Catalog in DBValidate.DBValidate");
        }
        this.parser.setEntityResolver(cer);
    }

    public DBValidate(DBConnection conn) {
        this();
        DBEntityResolver dbresolver = new DBEntityResolver(conn);
        this.parser.setEntityResolver(dbresolver);
    }

    public boolean validate(String doc) {
        this.xml_doc = doc;
        this.ef = new ErrorStorer();
        this.ef.resetErrors();
        this.parser.setErrorHandler(this.ef);
        try {
            this.parser.parse(this.createURL(this.xml_doc).toString());
        }
        catch (IOException e) {
            System.out.println("IOException:Could not parse :" + this.xml_doc + " from DBValidate.validate");
            ParseError eip = null;
            eip = new ParseError("", 0, 0, "IOException:Could not parse :" + this.xml_doc);
            if (this.ef.errorNodes == null) {
                this.ef.errorNodes = new Vector();
            }
            this.ef.errorNodes.addElement(eip);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.ef == null || this.ef.getErrorNodes() == null || this.ef.getErrorNodes().size() <= 0;
    }

    public boolean validateString(String xmldoc) {
        this.ef = new ErrorStorer();
        this.ef.resetErrors();
        this.parser.setErrorHandler(this.ef);
        InputSource is = new InputSource(new StringReader(xmldoc));
        try {
            this.parser.parse(is);
        }
        catch (SAXParseException e) {
            System.out.println("SAXParseException Error in DBValidate.validateString" + e.getMessage());
            this.ef.error(e);
        }
        catch (SAXException saxe) {
            System.out.println("SAXException error in validateString: " + saxe.getMessage());
            this.ef.otherError(saxe, null);
        }
        catch (IOException ioe) {
            System.out.println("IOExcption error in validateString " + ioe.getMessage());
            this.ef.otherError(ioe, null);
        }
        return this.ef == null || this.ef.getErrorNodes() == null || this.ef.getErrorNodes().size() <= 0;
    }

    public String returnErrors() {
        StringBuffer errorstring = new StringBuffer();
        errorstring.append("<?xml version=\"1.0\" ?>\n");
        if (this.ef != null && this.ef.getErrorNodes() != null && this.ef.getErrorNodes().size() > 0) {
            Vector errors = this.ef.getErrorNodes();
            errorstring.append("<validationerrors>\n");
            Enumeration e = errors.elements();
            while (e.hasMoreElements()) {
                errorstring.append(((ParseError)e.nextElement()).toXML());
            }
            errorstring.append("</validationerrors>\n");
        } else {
            errorstring.append("<valid />\n");
        }
        return errorstring.toString();
    }

    private URL createURL(String name) throws Exception {
        try {
            URL u = new URL(name);
            return u;
        }
        catch (MalformedURLException u) {
            URL u2 = new URL("file:" + new File(name).getAbsolutePath());
            return u2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java DBValidate <xmlfile or URL>");
            System.exit(0);
        }
        String doc = args[0];
        DBConnection conn = null;
        int serailNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("DBValidate.main");
            serailNumber = conn.getCheckOutSerialNumber();
            DBValidate gxv = new DBValidate(conn);
            if (gxv.validate(doc)) {
                System.out.print(gxv.returnErrors());
            } else {
                System.out.print(gxv.returnErrors());
            }
        }
        catch (SQLException e) {
            System.out.println("<error>Couldn't open database connection.</error>");
        }
        finally {
            DBConnectionPool.returnDBConnection(conn, serailNumber);
        }
    }

    class ParseError {
        String fileName;
        int lineNo;
        int charOffset;
        String msg;

        public ParseError(String fileName, int lineNo, int charOffset, String msg) {
            this.fileName = fileName;
            this.lineNo = lineNo;
            this.charOffset = charOffset;
            this.msg = msg;
        }

        public ParseError(String fileName, String msg) {
            this.fileName = fileName;
            this.msg = msg;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public int getCharOffset() {
            return this.charOffset;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String s) {
            this.msg = s;
        }

        public String toXML() {
            StringBuffer err = new StringBuffer();
            err.append("<error>\n");
            err.append("<filename>").append(this.getFileName()).append("</filename>\n");
            err.append("<line>").append(this.getLineNo()).append("</line>\n");
            err.append("<offset>").append(this.getCharOffset()).append("</offset>\n");
            err.append("<message>").append(this.getMsg()).append("</message>\n");
            err.append("</error>\n");
            return err.toString();
        }
    }

    class ErrorStorer
    implements ErrorHandler {
        Vector errorNodes = null;

        public Vector getErrorNodes() {
            return this.errorNodes;
        }

        public Object getError() {
            if (this.errorNodes == null) {
                return null;
            }
            return this.errorNodes;
        }

        public void resetErrors() {
            if (this.errorNodes != null) {
                this.errorNodes.removeAllElements();
            }
        }

        @Override
        public void warning(SAXParseException ex) {
            this.handleError(ex, WARNING);
        }

        @Override
        public void error(SAXParseException ex) {
            this.handleError(ex, ERROR);
        }

        @Override
        public void fatalError(SAXParseException ex) {
            this.handleError(ex, FATAL_ERROR);
        }

        public void otherError(Exception ex, String fileName) {
            if (!DBValidate.this.alreadyHandle) {
                if (this.errorNodes == null) {
                    this.errorNodes = new Vector();
                }
                ParseError error = new ParseError(fileName, ex.getMessage());
                this.errorNodes.addElement(error);
            }
        }

        private void handleError(SAXParseException ex, int type) {
            if (this.errorNodes == null) {
                this.errorNodes = new Vector();
            }
            ParseError eip = null;
            eip = new ParseError(ex.getSystemId(), ex.getLineNumber(), ex.getColumnNumber(), ex.getMessage());
            this.errorNodes.addElement(eip);
            DBValidate.this.alreadyHandle = true;
        }
    }
}

