/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.EventLogData;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventLogFilter {
    private Vector<String> blackIPList = null;
    private Vector<String> blackSubjectList = null;
    private Log logMetacat = LogFactory.getLog(EventLogFilter.class);

    public EventLogFilter() {
        String blackIPString = null;
        String blackSubjectString = null;
        try {
            blackIPString = PropertyService.getProperty("event.log.blacklist.ipaddress");
        }
        catch (PropertyNotFoundException pnfe) {
            this.logMetacat.warn((Object)("EventLogFilter.EventLogFilter - Could not get metacat property: event.log.blacklist.ipaddress. Any ip address will be allowed to log: " + pnfe.getMessage()));
        }
        try {
            blackSubjectString = PropertyService.getProperty("event.log.blacklist.subject");
        }
        catch (PropertyNotFoundException pnfe) {
            this.logMetacat.warn((Object)("EventLogFilter.EventLogFilter - Could not get metacat property: event.log.blacklist.subject. Any subject will be allowed to log: " + pnfe.getMessage()));
        }
        this.blackIPList = AuthUtil.split(blackIPString, AuthUtil.DELIMITER, AuthUtil.ESCAPECHAR);
        this.logMetacat.debug((Object)("EventLogFilter.EventLogFilter - the black ip addresses are: " + this.blackIPList));
        this.blackSubjectList = AuthUtil.split(blackSubjectString, AuthUtil.DELIMITER, AuthUtil.ESCAPECHAR);
        this.logMetacat.debug((Object)("EventLogFilter.EventLogFilter - the black subjects are: " + this.blackSubjectList));
    }

    public boolean filter(EventLogData logData) {
        boolean filteredOut = false;
        if (logData != null) {
            String subject;
            String ipAddress = logData.getIpAddress();
            if (ipAddress != null && !ipAddress.trim().equals("") && this.blackIPList != null && !this.blackIPList.isEmpty() && this.blackIPList.contains(ipAddress)) {
                filteredOut = true;
            }
            if (!filteredOut && (subject = logData.getPrincipal()) != null && !subject.trim().equals("") && this.blackSubjectList != null && !this.blackSubjectList.isEmpty() && this.blackSubjectList.contains(subject)) {
                filteredOut = true;
            }
        } else {
            this.logMetacat.warn((Object)"EventLogFilter.filter - the logData object is null. So we filter it out");
            filteredOut = true;
        }
        return filteredOut;
    }
}

