/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MetacatProfiler {
    private static MetacatProfiler profiler = null;
    private Hashtable<String, Profile> profiles = new Hashtable();
    private String log = "";
    private int callOrderCount = 0;
    private boolean aggregateMethodCalls = true;

    private MetacatProfiler() {
    }

    public static MetacatProfiler getInstance() {
        if (profiler == null) {
            profiler = new MetacatProfiler();
        }
        return profiler;
    }

    public Hashtable<String, Profile> getProfiles() {
        return this.profiles;
    }

    public void reset() {
        this.profiles = new Hashtable();
        this.log = "";
    }

    public void printLogMsg(String msg) {
        this.log = this.log + "//" + new Date().toString() + ":" + msg + "\n";
    }

    public void startTime(String profileName) {
        long start = new Date().getTime();
        Profile p = this.profiles.get(profileName);
        if (!this.aggregateMethodCalls || p == null) {
            p = new Profile();
            p.name = profileName;
            p.start = start;
            p.methodcalls = 0L;
            p.total = 0L;
            p.callorder = this.callOrderCount;
            ++this.callOrderCount;
            this.profiles.put(profileName, p);
        } else {
            p.start = start;
            this.profiles.put(profileName, p);
        }
    }

    public void stopTime(String profileName) {
        long stop = new Date().getTime();
        boolean found = false;
        Profile p = this.profiles.get(profileName);
        if (p == null) {
            System.out.println("WARNING: profile " + profileName + " not registered with MetacatProfiler");
        } else {
            p.stop = stop;
        }
        if (!this.aggregateMethodCalls) {
            this.log = this.log + p.toString();
        } else if (p != null) {
            p.total += p.stop - p.start;
            ++p.methodcalls;
            this.profiles.put(profileName, p);
        } else {
            p = new Profile();
            p.methodcalls = 1L;
            this.profiles.put(profileName, p);
        }
    }

    public Profile[] sortProfiles(String sortKey) {
        Vector v = new Vector();
        Enumeration<String> keys = this.profiles.keys();
        Profile[] pArr = new Profile[this.profiles.size()];
        int i = 0;
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            pArr[i] = this.profiles.get(key);
            ++i;
        }
        int n = this.profiles.size();
        for (int pass = 1; pass < n; ++pass) {
            for (i = 0; i < n - pass; ++i) {
                long x = 0L;
                long y = 0L;
                if (sortKey.equals("callorder")) {
                    x = pArr[i].callorder;
                    y = pArr[i + 1].callorder;
                } else if (sortKey.equals("callcount")) {
                    x = pArr[i].methodcalls;
                    y = pArr[i + 1].methodcalls;
                } else {
                    x = pArr[i].total;
                    y = pArr[i + 1].total;
                }
                if (x >= y) continue;
                Profile temp = pArr[i];
                pArr[i] = pArr[i + 1];
                pArr[i + 1] = temp;
            }
        }
        return pArr;
    }

    public void printSortedCSV(File f, String sortKey) throws IOException {
        Profile[] p = this.sortProfiles(sortKey);
        String log2 = "";
        log2 = "\n" + this.log + "\n=======profile entries sorted by " + sortKey + "========\n";
        for (int i = 0; i < p.length; ++i) {
            log2 = log2 + p[i].toString() + "\n";
        }
        log2 = log2 + "=======end profile entries========";
        System.out.println(log2);
        if (f != null) {
            FileWriter fw = new FileWriter(f, true);
            fw.write(log2);
            fw.flush();
            fw.close();
        }
    }

    public void printCSV(File f) throws IOException {
        if (this.aggregateMethodCalls) {
            Enumeration<String> keys = this.profiles.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Profile p = this.profiles.get(key);
                this.log = this.log + p.toString();
            }
        }
        FileWriter fw = new FileWriter(f, true);
        fw.write(this.log);
        fw.flush();
        fw.close();
    }

    public class Profile {
        public long start;
        public long stop;
        public long total = -1L;
        public long methodcalls;
        public long callorder;
        public String name;

        public String toString() {
            if (this.total == -1L) {
                this.total = this.stop - this.start;
            }
            return "name: " + this.name + ", calls: " + this.methodcalls + ", totaltime: " + this.total;
        }
    }
}

