/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.Version;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MetacatVersion
extends Version {
    public MetacatVersion(String versionID) {
        super(versionID);
    }

    public static String getVersionID() throws PropertyNotFoundException {
        String version = PropertyService.getProperty("application.metacatVersion");
        return version;
    }

    public static String getVersionAsXml() throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<version>");
        sb.append(MetacatVersion.getVersionFromDB());
        sb.append("</version>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersionFromDB() throws SQLException {
        DBConnection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String version = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("MetacatVersion.getVersionFromDB()");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement("SELECT version FROM db_version WHERE status = ?");
            pstmt.setInt(1, 1);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                version = rs.getString(1);
            }
            pstmt.close();
            rs.close();
        }
        catch (SQLException e) {
            throw new SQLException("MetacatVersion.getVersionFromDB - sql error: " + e.getMessage());
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
        return version;
    }
}

