/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.MetacatAdmin;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginAdmin
extends MetacatAdmin {
    private static LoginAdmin Admin = null;
    private static Log logMetacat = LogFactory.getLog(LoginAdmin.class);

    private LoginAdmin() {
    }

    public static LoginAdmin getInstance() {
        if (Admin == null) {
            Admin = new LoginAdmin();
        }
        return Admin;
    }

    public void authenticateUser(HttpServletRequest request, HttpServletResponse response) throws AdminException {
        String processForm = request.getParameter("processForm");
        String formErrors = (String)request.getAttribute("formErrors");
        if (processForm == null || !processForm.equals("true") || formErrors != null) {
            try {
                request.setAttribute("adminList", AuthUtil.getAdministrators());
                RequestUtil.forwardRequest(request, response, "/admin/admin-login.jsp", null);
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("LoginAdmin.authenticateUser - Utility problem while processing login page: " + mue.getMessage());
            }
        }
        Vector<String> processingSuccess = new Vector<String>();
        Vector<String> processingErrors = new Vector<String>();
        Vector<String> validationErrors = new Vector<String>();
        String userName = "";
        userName = request.getParameter("username");
        String password = request.getParameter("password");
        validationErrors.addAll(this.validateOptions(request));
        if (validationErrors.size() == 0) {
            try {
                AuthUtil.logUserIn(request, userName, password);
            }
            catch (MetacatUtilException ue) {
                String errorMessage = "LoginAdmin.authenticateUser - Could not log in as: " + userName + " : " + ue.getMessage() + ". Please try again";
                processingErrors.add(errorMessage);
                logMetacat.error((Object)errorMessage);
            }
        }
        try {
            if (validationErrors.size() > 0 || processingErrors.size() > 0) {
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestFormErrors(request, validationErrors);
                RequestUtil.setRequestErrors(request, processingErrors);
                RequestUtil.forwardRequest(request, response, "/admin", null);
            } else {
                processingSuccess.add("User logged in as: " + userName);
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setUserId(request, userName);
                RequestUtil.setRequestSuccess(request, processingSuccess);
                RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
            }
        }
        catch (MetacatUtilException mue) {
            throw new AdminException("LoginAdmin.authenticateUser - IO problem while processing login page: " + mue.getMessage());
        }
    }

    @Override
    protected Vector<String> validateOptions(HttpServletRequest request) {
        Vector<String> errorVector = new Vector<String>();
        return errorVector;
    }
}

