/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin.upgrade.dataone;

import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.upgrade.UpgradeUtilityInterface;
import edu.ucsb.nceas.metacat.dataone.SystemMetadataFactory;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.v2.MNode;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectInfo;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v2.SystemMetadata;
import org.dspace.foresite.ResourceMap;

public class GenerateORE
implements UpgradeUtilityInterface {
    private static Log log = LogFactory.getLog(GenerateORE.class);
    private int serverLocation = 1;

    @Override
    public boolean upgrade() throws AdminException {
        boolean success = true;
        boolean includeOre = true;
        boolean downloadData = false;
        try {
            downloadData = Boolean.parseBoolean(PropertyService.getProperty("dataone.ore.downloaddata"));
        }
        catch (PropertyNotFoundException e) {
            log.warn((Object)"Could not find ORE 'dataone.ore.downloaddata' property, defaulting to false", (Throwable)e);
        }
        try {
            Vector<String> idList = null;
            idList = DBUtil.getAllDocidsByType(DocumentImpl.EML2_0_0NAMESPACE, true, this.serverLocation);
            this.filterOutExisting(idList);
            Collections.sort(idList);
            SystemMetadataFactory.generateSystemMetadata(idList, includeOre, downloadData);
            idList = DBUtil.getAllDocidsByType(DocumentImpl.EML2_0_1NAMESPACE, true, this.serverLocation);
            this.filterOutExisting(idList);
            Collections.sort(idList);
            SystemMetadataFactory.generateSystemMetadata(idList, includeOre, downloadData);
            idList = DBUtil.getAllDocidsByType(DocumentImpl.EML2_1_0NAMESPACE, true, this.serverLocation);
            this.filterOutExisting(idList);
            Collections.sort(idList);
            SystemMetadataFactory.generateSystemMetadata(idList, includeOre, downloadData);
            idList = DBUtil.getAllDocidsByType(DocumentImpl.EML2_1_1NAMESPACE, true, this.serverLocation);
            this.filterOutExisting(idList);
            Collections.sort(idList);
            SystemMetadataFactory.generateSystemMetadata(idList, includeOre, downloadData);
            idList = DBUtil.getAllDocidsByType(DocumentImpl.EML2_2_0NAMESPACE, true, this.serverLocation);
            this.filterOutExisting(idList);
            Collections.sort(idList);
            SystemMetadataFactory.generateSystemMetadata(idList, includeOre, downloadData);
        }
        catch (Exception e) {
            String msg = "Problem generating missing system metadata: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            success = false;
            throw new AdminException(msg);
        }
        return success;
    }

    private List<String> filterOutExisting(List<String> idList) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String id : idList) {
            Identifier identifier = new Identifier();
            identifier.setValue(id);
            boolean exists = SystemMetadataFactory.oreExistsFor(identifier);
            if (!exists) continue;
            toRemove.add(id);
        }
        for (String id : toRemove) {
            idList.remove(id);
        }
        return idList;
    }

    public int getServerLocation() {
        return this.serverLocation;
    }

    public void setServerLocation(int serverLocation) {
        this.serverLocation = serverLocation;
    }

    public static void updateOREdateFormat(String mnBaseUrl) {
        List<Identifier> orePids = GenerateORE.getAllOREpids(mnBaseUrl);
        GenerateORE.updateOREs(orePids, "b", mnBaseUrl);
    }

    public static List<Identifier> getAllOREpids(String mnBaseUrl) {
        MNode mn = null;
        ObjectFormatIdentifier formatId = null;
        ArrayList<Identifier> pids = null;
        try {
            mn = D1Client.getMN((String)mnBaseUrl);
            formatId = ObjectFormatCache.getInstance().getFormat("http://www.openarchives.org/ore/terms").getFormatId();
            ObjectList objectList = mn.listObjects(null, null, null, formatId, null, null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            pids = new ArrayList<Identifier>();
            for (ObjectInfo o : objectList.getObjectInfoList()) {
                pids.add(o.getIdentifier());
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not get MN list of ORE pids", (Throwable)e);
        }
        return pids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateOREs(List<Identifier> orePids, String pidSuffix, String mnBaseUrl) {
        MNode mn = null;
        try {
            mn = D1Client.getMN((String)mnBaseUrl);
        }
        catch (Exception e) {
            log.error((Object)"Could not get MN client", (Throwable)e);
            return;
        }
        if (pidSuffix == null) {
            pidSuffix = "b";
        }
        for (Identifier orePid : orePids) {
            try {
                log.debug((Object)("processing ORE pid: " + orePid.getValue()));
                SystemMetadata originalOreSysMeta = mn.getSystemMetadata(null, orePid);
                if (originalOreSysMeta.getObsoletedBy() != null || originalOreSysMeta.getArchived() != null && originalOreSysMeta.getArchived().booleanValue()) {
                    log.debug((Object)("ORE pid is obsolete or archived, skipping: " + orePid.getValue()));
                    continue;
                }
                InputStream originalOreStream = mn.get(null, orePid);
                Map originalOre = null;
                try {
                    originalOre = ResourceMapFactory.getInstance().parseResourceMap(originalOreStream);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)originalOreStream);
                }
                Identifier updatedOrePid = new Identifier();
                updatedOrePid.setValue(orePid.getValue() + pidSuffix);
                ResourceMap updatedOre = ResourceMapFactory.getInstance().createResourceMap(updatedOrePid, (Map)originalOre.entrySet().iterator().next().getValue());
                String resourceMapXML = ResourceMapFactory.getInstance().serializeResourceMap(updatedOre);
                Checksum oreChecksum = ChecksumUtil.checksum((InputStream)IOUtils.toInputStream((String)resourceMapXML, (String)"UTF-8"), (String)"MD5");
                Date today = Calendar.getInstance().getTime();
                SystemMetadata updatedOreSysMeta = new SystemMetadata();
                BeanUtils.copyProperties((Object)updatedOreSysMeta, (Object)originalOreSysMeta);
                updatedOreSysMeta.setIdentifier(updatedOrePid);
                updatedOreSysMeta.setObsoletes(orePid);
                updatedOreSysMeta.setObsoletedBy(null);
                updatedOreSysMeta.setArchived(Boolean.valueOf(false));
                updatedOreSysMeta.setChecksum(oreChecksum);
                updatedOreSysMeta.setSize(BigInteger.valueOf(SystemMetadataFactory.sizeOfStream(IOUtils.toInputStream((String)resourceMapXML, (String)"UTF-8"))));
                updatedOreSysMeta.setDateSysMetadataModified(today);
                updatedOreSysMeta.setDateUploaded(today);
                updatedOreSysMeta.setReplicaList(null);
                InputStream updatedOreStream = IOUtils.toInputStream((String)resourceMapXML, (String)"UTF-8");
                mn.update(null, orePid, updatedOreStream, updatedOrePid, updatedOreSysMeta);
            }
            catch (Exception e) {
                log.error((Object)("Could not update ORE map: " + orePid), (Throwable)e);
            }
        }
    }

    public static void main(String[] ags) {
        try {
            SortedProperties testProperties = new SortedProperties("test/test.properties");
            testProperties.load();
            String metacatContextDir = testProperties.getProperty("metacat.contextDir");
            PropertyService.getInstance(metacatContextDir + "/WEB-INF");
            GenerateORE upgrader = new GenerateORE();
            upgrader.upgrade();
        }
        catch (Exception ex) {
            System.out.println("Exception:" + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

