/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.authentication;

import edu.ucsb.nceas.metacat.authentication.AuthFileHashInterface;
import org.mindrot.jbcrypt.BCrypt;

public class AuthFileBCryptHash
implements AuthFileHashInterface {
    @Override
    public boolean match(String plain, String hashed) throws Exception {
        if (plain == null || plain.trim().equals("")) {
            throw new IllegalArgumentException("AuthFileBrryptHash.match - the password parameter can't be null or blank");
        }
        if (hashed == null || hashed.trim().equals("")) {
            throw new IllegalArgumentException("AuthFileBrryptHash.match - the hashed value of password parameter can't be null or blank");
        }
        return BCrypt.checkpw((String)plain, (String)hashed);
    }

    @Override
    public String hash(String plain) {
        if (plain == null || plain.trim().equals("")) {
            throw new IllegalArgumentException("AuthFileBrryptHash.hash - the password parameter can't be null or blank");
        }
        return BCrypt.hashpw((String)plain, (String)BCrypt.gensalt());
    }
}

