/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.quota;

import edu.ucsb.nceas.metacat.dataone.quota.BookKeeperClient;
import edu.ucsb.nceas.metacat.dataone.quota.CreateUsageTask;
import edu.ucsb.nceas.metacat.dataone.quota.DeleteUsageTask;
import edu.ucsb.nceas.metacat.dataone.quota.LocalUsage;
import edu.ucsb.nceas.metacat.dataone.quota.QuotaDBManager;
import edu.ucsb.nceas.metacat.dataone.quota.QuotaService;
import edu.ucsb.nceas.metacat.dataone.quota.UpdateUsageTask;
import edu.ucsb.nceas.metacat.dataone.quota.UsageTask;
import java.sql.ResultSet;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FailedReportingAttemptChecker
extends TimerTask {
    private static Log logMetacat = LogFactory.getLog(FailedReportingAttemptChecker.class);
    private static final int MAXTIMES = 100;
    private ExecutorService executor = null;
    BookKeeperClient bookkeeperClient = null;

    public FailedReportingAttemptChecker(ExecutorService executor, BookKeeperClient bookkeeperClient) {
        this.executor = executor;
        this.bookkeeperClient = bookkeeperClient;
    }

    @Override
    public void run() {
        try {
            ResultSet rs = QuotaDBManager.getUnReportedUsages();
            int localId = -1;
            while (rs.next()) {
                try {
                    LocalUsage usage = new LocalUsage();
                    localId = rs.getInt(1);
                    usage.setLocalId(localId);
                    usage.setQuotaId(rs.getInt(2));
                    String instanceId = rs.getString(3);
                    logMetacat.debug((Object)("FailedReportingAttemptChecker.run - the instance id needed to report is " + instanceId));
                    usage.setInstanceId(instanceId);
                    usage.setQuantity(rs.getDouble(4));
                    usage.setObject(rs.getString(5));
                    String status = rs.getString(6);
                    logMetacat.debug((Object)("FailedReportingAttemptChecker.run - the status needed to report is " + status));
                    usage.setStatus(status);
                    String nodeId = rs.getString(7);
                    if (nodeId == null || nodeId.trim().equals("")) {
                        nodeId = QuotaService.nodeId;
                    }
                    usage.setNodeId(nodeId);
                    UsageTask task = null;
                    if (status != null && status.equals("active")) {
                        task = new CreateUsageTask(usage, this.bookkeeperClient);
                    } else if (status != null && status.equals("inactive")) {
                        task = new UpdateUsageTask(usage, this.bookkeeperClient);
                    } else if (status != null && status.equals("deleted")) {
                        task = new DeleteUsageTask(usage, this.bookkeeperClient);
                    } else {
                        throw new Exception("Doesn't support the status of the usage " + status);
                    }
                    task.setIsLoggedLocally(true);
                    Future<?> future = this.executor.submit(task);
                    for (int times = 0; !future.isDone() && times <= 100; ++times) {
                        logMetacat.debug((Object)("FailedReportingAttemptChecker.run - wait for completing the report to the remote book keeper server for the instance id " + usage.getInstanceId() + " with the status " + status + ". This is " + times + " tries."));
                        Thread.sleep(500L);
                    }
                }
                catch (Exception ee) {
                    logMetacat.error((Object)("FailedReportingAttemptChecker.run - can't report the usage to the remote book server with the local id " + localId + " since " + ee.getMessage() + ". If the local id is -1. It means the local id can't be got from the local db."));
                }
            }
            rs.close();
        }
        catch (Exception e) {
            logMetacat.error((Object)("FailedReportingAttemptChecker.run - can't get the result set of un-reported usages since " + e.getMessage()));
        }
    }
}

