/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.quota;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v2.SystemMetadata;

public class QuotaTypeDeterminer {
    public static final String STORAGE = "storage";
    public static final String PORTAL = "portal";
    private static Log logMetacat = LogFactory.getLog(QuotaTypeDeterminer.class);
    private List<String> portalNameSpaces = null;
    private String quotaType = null;
    private String instanceId = null;

    public QuotaTypeDeterminer(List<String> portalNameSpaces) throws ServiceFailure {
        this.portalNameSpaces = portalNameSpaces;
        if (this.portalNameSpaces == null || this.portalNameSpaces.isEmpty()) {
            throw new ServiceFailure("4893", "The propery dataone.quotas.portal.namespaces in metacat.properties file can'be blank.");
        }
    }

    public void determine(SystemMetadata sysmeta) throws InvalidRequest {
        this.quotaType = null;
        if (sysmeta != null) {
            ObjectFormatIdentifier format = sysmeta.getFormatId();
            String formatId = format.getValue();
            for (String portalNamespace : this.portalNameSpaces) {
                logMetacat.debug((Object)("QuotaTypeDeterminer.determine - the portal namespace in the metacat.properties file is " + portalNamespace + " and the format id in the sysmeta is " + formatId));
                if (portalNamespace == null || !portalNamespace.equals(formatId)) continue;
                this.quotaType = PORTAL;
                Identifier sid = sysmeta.getSeriesId();
                if (sid != null) {
                    this.instanceId = sid.getValue();
                    if (this.instanceId != null && !this.instanceId.trim().equals("")) break;
                    throw new InvalidRequest("4891", "The series id field in the syste metadata of portal objects can't be null.");
                }
                throw new InvalidRequest("4891", "The series id field in the syste metadata of portal objects can't be null.");
            }
            if (this.quotaType == null) {
                this.quotaType = STORAGE;
                this.instanceId = sysmeta.getIdentifier().getValue();
            }
        } else {
            throw new InvalidRequest("4891", "The system metadata can't be null when Metacat determines a quota type.");
        }
        logMetacat.debug((Object)("QuotaTypeDeterminer.determine - the final quota type is " + this.quotaType + " and the instance id is " + this.instanceId));
    }

    public String getQuotaType() {
        return this.quotaType;
    }

    public String getInstanceId() {
        return this.instanceId;
    }
}

