/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.doi.datacite;

import java.io.StringWriter;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public abstract class DataCiteMetadataFactory {
    public static final String EN = "en";
    public static final String XML_LANG = "xml:lang";
    public static final String NAMESPACE = "http://datacite.org/schema/kernel-4";
    public static final String SCHEMALOCATION = "https://schema.datacite.org/meta/kernel-4.3/metadata.xsd";
    public static final String RESOURCE = "resource";
    public static final String CREATORS = "creators";
    public static final String CREATOR = "creator";
    public static final String CREATORNAME = "creatorName";
    public static final String TITLES = "titles";
    public static final String SUBJECTS = "subjects";
    public static final String DESCRIPTIONS = "descriptions";
    public static final String FORMATS = "formats";
    public static final String DOI = "DOI";
    public static final String ABSTRACT = "Abstract";
    private static final int FIRST = 0;
    protected static final String INVALIDCODE = "1031";
    private static Log logMetacat = LogFactory.getLog(DataCiteMetadataFactory.class);
    protected static XPath xpath = null;

    public abstract String generateMetadata(Identifier var1, SystemMetadata var2) throws InvalidRequest, ServiceFailure;

    public abstract boolean canProcess(String var1);

    protected Document generateROOTDoc() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElementNS(NAMESPACE, RESOURCE);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://datacite.org/schema/kernel-4 https://schema.datacite.org/meta/kernel-4.3/metadata.xsd");
        doc.appendChild(root);
        return doc;
    }

    protected Document addIdentifier(Document doc, String identifier, String scheme) throws InvalidRequest {
        if (identifier == null || identifier.trim().equals("")) {
            throw new InvalidRequest(INVALIDCODE, "The datacite instance must have a identifier. It can't be null or blank");
        }
        if (scheme == null || !scheme.equals(DOI)) {
            throw new InvalidRequest(INVALIDCODE, "The scheme of the identifier element only can be DOI and the specified one " + scheme + " is not allowed.");
        }
        Element identifierEle = doc.createElement("identifier");
        identifierEle.setAttribute("identifierType", scheme);
        identifierEle.appendChild(doc.createTextNode(identifier));
        doc.getFirstChild().appendChild(identifierEle);
        return doc;
    }

    protected Document appendCreator(String creatorName, Document doc, String affiliation, String nameIdentifier, String nameIdentifierSchemeURI, String nameIdentifierScheme) throws XPathExpressionException {
        if (creatorName != null && !creatorName.trim().equals("")) {
            String path;
            XPathExpression expr;
            NodeList creatorsList;
            Element creator = doc.createElement(CREATOR);
            Element creatorNameEle = doc.createElement(CREATORNAME);
            creatorNameEle.appendChild(doc.createTextNode(creatorName));
            creator.appendChild(creatorNameEle);
            if (nameIdentifier != null && !nameIdentifier.trim().equals("") && nameIdentifierScheme != null && !nameIdentifierScheme.trim().equals("")) {
                Element nameIdentifierEle = doc.createElement("nameIdentifier");
                if (nameIdentifierSchemeURI != null && !nameIdentifierSchemeURI.trim().equals("")) {
                    nameIdentifierEle.setAttribute("schemeURI", nameIdentifierSchemeURI);
                }
                nameIdentifierEle.setAttribute("nameIdentifierScheme", nameIdentifierScheme);
                nameIdentifierEle.appendChild(doc.createTextNode(nameIdentifier));
                creator.appendChild(nameIdentifierEle);
            }
            if (affiliation != null && !affiliation.trim().equals("")) {
                Element affiliationEle = doc.createElement("affiliation");
                affiliationEle.appendChild(doc.createTextNode(affiliation));
                creator.appendChild(affiliationEle);
            }
            if ((creatorsList = (NodeList)(expr = xpath.compile(path = "//creators")).evaluate(doc, XPathConstants.NODESET)) == null || creatorsList.getLength() == 0) {
                Element creatorsEle = doc.createElement(CREATORS);
                doc.getFirstChild().appendChild(creatorsEle);
                creatorsEle.appendChild(creator);
            } else {
                creatorsList.item(0).appendChild(creator);
            }
        }
        return doc;
    }

    public Document appendTitle(String title, Document doc, String language) throws XPathExpressionException {
        if (title != null && !title.trim().equals("")) {
            Element titleEle = doc.createElement("title");
            String code = DataCiteMetadataFactory.getISOLanguageCode(language);
            titleEle.setAttribute(XML_LANG, code);
            titleEle.appendChild(doc.createTextNode(title));
            String path = "//titles";
            XPathExpression expr = xpath.compile(path);
            NodeList titlesList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            if (titlesList == null || titlesList.getLength() == 0) {
                Element titlesEle = doc.createElement(TITLES);
                doc.getFirstChild().appendChild(titlesEle);
                titlesEle.appendChild(titleEle);
            } else {
                titlesList.item(0).appendChild(titleEle);
            }
        }
        return doc;
    }

    protected Document addPublisher(Document doc, String publisher) throws InvalidRequest {
        if (publisher == null || publisher.trim().equals("")) {
            throw new InvalidRequest(INVALIDCODE, "The datacite instance must have a publisher. It can't be null or blank");
        }
        Element publisherEle = doc.createElement("publisher");
        publisherEle.appendChild(doc.createTextNode(publisher));
        doc.getFirstChild().appendChild(publisherEle);
        return doc;
    }

    protected Document addPublicationYear(Document doc, String publicationYear) throws InvalidRequest {
        if (publicationYear == null || publicationYear.trim().equals("")) {
            throw new InvalidRequest(INVALIDCODE, "The datacite instance must have a publication year. It can't be null or blank");
        }
        Element publicationYearEle = doc.createElement("publicationYear");
        publicationYearEle.appendChild(doc.createTextNode(publicationYear));
        doc.getFirstChild().appendChild(publicationYearEle);
        return doc;
    }

    protected Document appendSubject(String subject, Document doc, String language) throws XPathExpressionException {
        if (subject != null && !subject.trim().equals("")) {
            Element subjectEle = doc.createElement("subject");
            String code = DataCiteMetadataFactory.getISOLanguageCode(language);
            subjectEle.setAttribute(XML_LANG, code);
            subjectEle.appendChild(doc.createTextNode(subject));
            String path = "//subjects";
            XPathExpression expr = xpath.compile(path);
            NodeList subjectsList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            if (subjectsList == null || subjectsList.getLength() == 0) {
                Element subjectsEle = doc.createElement(SUBJECTS);
                doc.getFirstChild().appendChild(subjectsEle);
                subjectsEle.appendChild(subjectEle);
            } else {
                subjectsList.item(0).appendChild(subjectEle);
            }
        }
        return doc;
    }

    protected Document addLanguage(Document doc, String language) {
        String code = DataCiteMetadataFactory.getISOLanguageCode(language);
        Element languageEle = doc.createElement("language");
        languageEle.appendChild(doc.createTextNode(code));
        doc.getFirstChild().appendChild(languageEle);
        return doc;
    }

    protected Document addResourceType(Document doc, String resourceTypeGeneral, String resourceType) {
        Element resourceTypeEle = doc.createElement("resourceType");
        resourceTypeEle.setAttribute("resourceTypeGeneral", resourceTypeGeneral);
        if (resourceType != null) {
            resourceTypeEle.appendChild(doc.createTextNode(resourceType));
        }
        doc.getFirstChild().appendChild(resourceTypeEle);
        return doc;
    }

    protected Document appendFormat(Document doc, String format) throws XPathExpressionException {
        if (format != null && !format.trim().equals("")) {
            Element formatEle = doc.createElement("format");
            formatEle.appendChild(doc.createTextNode(format));
            String path = "//formats";
            XPathExpression expr = xpath.compile(path);
            NodeList formatsList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            if (formatsList == null || formatsList.getLength() == 0) {
                Element formatsEle = doc.createElement(FORMATS);
                doc.getFirstChild().appendChild(formatsEle);
                formatsEle.appendChild(formatEle);
            } else {
                formatsList.item(0).appendChild(formatEle);
            }
        }
        return doc;
    }

    protected Document addVersion(Document doc, String version) {
        if (version != null && !version.trim().equals("")) {
            Element versionEle = doc.createElement("version");
            versionEle.appendChild(doc.createTextNode(version));
            doc.getFirstChild().appendChild(versionEle);
        }
        return doc;
    }

    protected Document appendDescription(String description, Document doc, String language, String descriptionType) throws XPathExpressionException {
        if (description != null && !description.trim().equals("")) {
            Element descriptionEle = doc.createElement("description");
            String code = DataCiteMetadataFactory.getISOLanguageCode(language);
            if (descriptionType == null || description.trim().equals("")) {
                descriptionType = ABSTRACT;
            }
            descriptionEle.setAttribute(XML_LANG, code);
            descriptionEle.setAttribute("descriptionType", descriptionType);
            descriptionEle.appendChild(doc.createTextNode(description));
            String path = "//descriptions";
            XPathExpression expr = xpath.compile(path);
            NodeList descriptionsList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            if (descriptionsList == null || descriptionsList.getLength() == 0) {
                Element descriptionsEle = doc.createElement(DESCRIPTIONS);
                doc.getFirstChild().appendChild(descriptionsEle);
                descriptionsEle.appendChild(descriptionEle);
            } else {
                descriptionsList.item(0).appendChild(descriptionEle);
            }
        }
        return doc;
    }

    protected String serializeDoc(Document doc) {
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)doc.getImplementation());
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        LSOutput lsOutput = domImplementation.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter();
        lsOutput.setCharacterStream(stringWriter);
        lsSerializer.write(doc, lsOutput);
        return ((Object)stringWriter).toString();
    }

    static String getISOLanguageCode(String language) {
        if (language == null) {
            return EN;
        }
        for (Locale locale : Locale.getAvailableLocales()) {
            if (!language.equalsIgnoreCase(locale.getDisplayLanguage()) && !language.equalsIgnoreCase(locale.getLanguage()) && !language.equalsIgnoreCase(locale.getISO3Language())) continue;
            return locale.getLanguage();
        }
        return EN;
    }

    public static String lookupFormat(SystemMetadata sysMeta) {
        String format = null;
        try {
            ObjectFormat objectFormat = D1Client.getCN().getFormat(sysMeta.getFormatId());
            format = objectFormat.getMediaType().getName();
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Could not lookup resource type for formatId" + e.getMessage()));
        }
        return format;
    }

    protected String removeIdSchemePrefix(String id, String scheme) {
        if (id.startsWith(scheme.toLowerCase())) {
            id = id.replaceFirst(scheme.toLowerCase() + ":", "");
        } else if (id.startsWith(scheme)) {
            id = id.replaceFirst(scheme + ":", "");
        }
        return id;
    }

    static {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        xpath = xPathfactory.newXPath();
    }
}

