/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.doi.datacite;

import edu.ucsb.nceas.ezid.profile.DataCiteProfileResourceTypeValues;
import edu.ucsb.nceas.ezid.profile.ErcMissingValueCode;
import edu.ucsb.nceas.metacat.dataone.MNodeService;
import edu.ucsb.nceas.metacat.doi.datacite.DataCiteMetadataFactory;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.SystemMetadata;
import org.w3c.dom.Document;

public class DefaultDataCiteFactory
extends DataCiteMetadataFactory {
    private static Log logMetacat = LogFactory.getLog(DefaultDataCiteFactory.class);

    @Override
    public String generateMetadata(Identifier identifier, SystemMetadata sysmeta) throws InvalidRequest, ServiceFailure {
        if (identifier != null && sysmeta != null) {
            try {
                String language = "English";
                Document doc = this.generateROOTDoc();
                String scheme = "DOI";
                String id = this.removeIdSchemePrefix(identifier.getValue(), scheme);
                this.addIdentifier(doc, id, scheme);
                String affiliation = null;
                String nameIdentifier = null;
                String nameIdentifierSchemeURI = null;
                String nameIdentifierScheme = null;
                this.appendCreator(sysmeta.getRightsHolder().getValue(), doc, affiliation, nameIdentifier, nameIdentifierSchemeURI, nameIdentifierScheme);
                this.appendTitle(ErcMissingValueCode.UNKNOWN.toString(), doc, language);
                Node node = MNodeService.getInstance(null).getCapabilities();
                this.addPublisher(doc, node.getName());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                String year = sdf.format(sysmeta.getDateUploaded());
                this.addPublicationYear(doc, year);
                String resourceType = null;
                this.addResourceType(doc, DataCiteProfileResourceTypeValues.DATASET.toString(), resourceType);
                String format = DefaultDataCiteFactory.lookupFormat(sysmeta);
                if (format != null) {
                    this.appendFormat(doc, format);
                }
                return this.serializeDoc(doc);
            }
            catch (InvalidRequest e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServiceFailure("1030", e.getMessage());
            }
        }
        return null;
    }

    @Override
    public boolean canProcess(String namespace) {
        return true;
    }
}

